/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.openitem;

import com.infor.igf.core.types.PersistableEnum;
import com.infor.igf.core.util.PersistableEnumUtils;
import com.varial.accounting.domain.accountcleanup.AccountCleanupSession;
import com.varial.accounting.domain.adviceposting.AdvicePostingSession;
import com.varial.accounting.domain.bankaccount.BankAccount;
import com.varial.accounting.domain.bankstatementposting.BankStatementPostingSession;
import com.varial.accounting.domain.cashtransaction.CashTransaction;
import com.varial.accounting.domain.chequedeposit.ChequeDepositTransaction;
import com.varial.accounting.domain.constructionproject.ConstructionProjectHelper;
import com.varial.accounting.domain.currencyrevaluation.CurrencyRevaluation;
import com.varial.accounting.domain.currencyrevaluation.CurrencyRevaluationSession;
import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.documenttype.DocumentCategoryType;
import com.varial.accounting.domain.documenttype.DocumentType;
import com.varial.accounting.domain.downpaymentrequestallocation.DownPaymentRequestAllocationAmount;
import com.varial.accounting.domain.downpaymentrequestallocation.DownPaymentRequestAllocationAmountPersistencyManager;
import com.varial.accounting.domain.downpaymentrequestallocation.DownPaymentRequestAllocationHelper;
import com.varial.accounting.domain.dunninggroup.DunningGrade;
import com.varial.accounting.domain.dunningletter.DunningLetterSession;
import com.varial.accounting.domain.financesetup.CurrencyType;
import com.varial.accounting.domain.financesetup.FinanceSetup;
import com.varial.accounting.domain.financesetup.IFinanceSetup;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.instalment.Instalment;
import com.varial.accounting.domain.invoiceallocation.AllocationAmount;
import com.varial.accounting.domain.invoiceallocation.AllocationAmountPersistencyManager;
import com.varial.accounting.domain.invoiceallocation.IPaymentOpenItem;
import com.varial.accounting.domain.invoiceallocation.InvoiceAllocationType;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocation;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocationFactory;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocationRemainderPersistencyManager;
import com.varial.accounting.domain.invoiceallocation.dto.AllocationDate;
import com.varial.accounting.domain.invoiceallocation.payment.PaymentEffectiveDateFromInvoiceResolver;
import com.varial.accounting.domain.invoiceallocation.utils.CompletedAllocationSelectionHelper;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.DiscountType;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.DownPaymentRequestOpenItemPersistencyManager;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.InvoiceTransaction;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.KsefNumberType;
import com.varial.accounting.domain.nlaccountopenitem.NLAccountOpenItem;
import com.varial.accounting.domain.nominalledger.NLAccountCompanySetting;
import com.varial.accounting.domain.nominaltransactionbase.ChequeDepositData;
import com.varial.accounting.domain.nominaltransactionbase.INominalLedgerEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalTaxEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBase;
import com.varial.accounting.domain.nominaltransactionbase.PersonalAccountEntry;
import com.varial.accounting.domain.nominaltransactionbase.TransactionExceptionMapper;
import com.varial.accounting.domain.nominaltransactionbase.TransactionHelper;
import com.varial.accounting.domain.nominaltransactionbase.TransactionType;
import com.varial.accounting.domain.nominaltransactionbase.cancellation.CancellationContext;
import com.varial.accounting.domain.openitem.BankStatementData;
import com.varial.accounting.domain.openitem.DeliveryAddress;
import com.varial.accounting.domain.openitem.EsrPayment;
import com.varial.accounting.domain.openitem.IOpenItem;
import com.varial.accounting.domain.openitem.IOpenItemDiscount;
import com.varial.accounting.domain.openitem.OpenAmountTransferManager;
import com.varial.accounting.domain.openitem.OpenItemCurrentStatus;
import com.varial.accounting.domain.openitem.OpenItemData;
import com.varial.accounting.domain.openitem.OpenItemDiscountCalculator;
import com.varial.accounting.domain.openitem.OpenItemExceptionMapper;
import com.varial.accounting.domain.openitem.OpenItemPersistencyManager;
import com.varial.accounting.domain.openitem.OpenItemStatusAllocationPersistencyManager;
import com.varial.accounting.domain.openitem.OpenItemType;
import com.varial.accounting.domain.openitem.OpenItemValidator;
import com.varial.accounting.domain.openitem.ReminderStatus;
import com.varial.accounting.domain.openitem.dates.CompletedAllocationDateResolver;
import com.varial.accounting.domain.openitem.service.OpenItemCurrentStatusService;
import com.varial.accounting.domain.openitemallocationbase.AllocationNumberManager;
import com.varial.accounting.domain.openitemallocationbase.IAllocationBase;
import com.varial.accounting.domain.openitembase.IAccount;
import com.varial.accounting.domain.openitembase.IOpenItemBase;
import com.varial.accounting.domain.openitembase.OpenItemHelper;
import com.varial.accounting.domain.openitembase.OpenItemOperationType;
import com.varial.accounting.domain.openitembase.OpenItemSecondaryCurrencyAmounts;
import com.varial.accounting.domain.openitemstatus.OpenItemStatus;
import com.varial.accounting.domain.openitemstatus.OpenItemStatusHelper;
import com.varial.accounting.domain.openitemstatus.OpenItemStatusType;
import com.varial.accounting.domain.payment.ConversionRateMap;
import com.varial.accounting.domain.payment.GeneratePaymentRemittance;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.PaymentSessionBankAccount;
import com.varial.accounting.domain.personalaccount.IPersonalAccountBankAddress;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.personalaccountreposting.PersonalAccountRepostingOpenItemPersistencyManager;
import com.varial.accounting.domain.purchaseregister.PurchaseInvoiceRegisterStatus;
import com.varial.accounting.domain.representative.Representative;
import com.varial.accounting.domain.sequenceno.SequenceNo;
import com.varial.accounting.domain.servicetypeawv.ServiceTypeAWV;
import com.varial.accounting.domain.taxcode.TaxCode;
import com.varial.accounting.domain.taxcode.TaxCodePersistencyManager;
import com.varial.accounting.domain.taxcode.TaxRate;
import com.varial.accounting.domain.taxcode.TaxRatePersistencyManager;
import com.varial.accounting.domain.termsofpayment.ITermOfPayment;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.text.TextFactory;
import com.varial.base.types.date.DateHelper;
import com.varial.costing.base.domain.costcentrebase.CostCentreBase;
import com.varial.costing.base.domain.costunit.ICostUnit;
import com.varial.framework.domain.analysiscode.AnalysisCodeCategory;
import com.varial.framework.domain.analysiscode.AnalysisCodeCategoryPersistencyManager;
import com.varial.framework.domain.analysiscode.AnalysisCodeCategoryType;
import com.varial.framework.domain.analysiscode.AnalysisCodeTable;
import com.varial.framework.domain.analysiscode.IAnalysisCodeEntry;
import com.varial.framework.domain.company.ICompany;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.currency.ConversionRate;
import com.varial.framework.domain.currency.ConversionRateUtils;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.framework.domain.paymentbase.ModeOfPayment;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import de.varial.accounting.domain.z4session.Z4PaymentPersistencyManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpenItem
extends PersistentObject
implements IOpenItem,
IPaymentOpenItem {
    public static final String CLASSNAME = OpenItem.class.getName();
    public static final int PRIORITY = 6;
    private final OpenItemValidator validator = new OpenItemValidator();
    private AccountingCompany mCompany;
    private PersonalAccountEntry mPersonalAccountEntry;
    private PersonalAccount mPersonalAccount;
    private String mReferenceNumber;
    private String mSequenceNumber;
    private String mProcessID;
    private Date mDocumentDate;
    private OpenItemType mOpenItemType;
    private String mNote;
    private ICurrency mEnteredCurrency;
    private ConversionRate mConversionRate;
    private BigDecimal mOriginalAmount;
    private BigDecimal mBaseOriginalAmount;
    private BigDecimal mOpenAmount;
    private BigDecimal mBaseOpenAmount;
    private ConversionRate mSeccurr1ConversionRate;
    private BigDecimal mSeccurr1OriginalAmount;
    private BigDecimal mSeccurr1OpenAmount;
    private ConversionRate mSeccurr2ConversionRate;
    private BigDecimal mSeccurr2OriginalAmount;
    private BigDecimal mSeccurr2OpenAmount;
    private ConversionRate mSeccurr3ConversionRate;
    private BigDecimal mSeccurr3OriginalAmount;
    private BigDecimal mSeccurr3OpenAmount;
    private ConversionRate mSeccurr4ConversionRate;
    private BigDecimal mSeccurr4OriginalAmount;
    private BigDecimal mSeccurr4OpenAmount;
    private boolean mIsAllocated;
    private Date mCompletedAllocationDate;
    private FinancialYear mCompletedAllocationYear;
    private String mAllocationNumber;
    private boolean mIsCancelled;
    private boolean mIsCancellation;
    private AllocationAmount[] mAllocationAmounts;
    private CustSupAddress mOneOffAccountAddress;
    private CurrencyRevaluationSession mCurrencyRevaluationSession;
    private String mImportApplication;
    private boolean mFactoring;
    private String mFactoringNote;
    private int mInstalmentNumber;
    private String[] mAnalysisCodes;
    private boolean mIsDownPayment;
    private BigDecimal mDownPaymentDiscountAmount;
    private BigDecimal mDownPaymentBaseDiscountAmount;
    private String mDownPaymentTaxCodeOID;
    private BigDecimal mDownPaymentTaxAmount;
    private BigDecimal mDownPaymentBaseTaxAmount;
    private String mRemainderTaxCodeOID;
    private FinancialYear mFinancialYear;
    private Date mTransactionDate;
    private DocumentType mDocumentType;
    private boolean mIsDownPaymentFinalInvoice;
    private boolean mIsOpeningBalance;
    private boolean mHasNewConversionRate;
    private boolean mIsInterestOpenItem;
    private CostCentreBase mCostCentreBase;
    private Instalment mInstalment;
    private BankStatementPostingSession mBankStatementPostingSession;
    private AdvicePostingSession mAdvicePostingSession;
    private DocumentCategoryType mDocumentCategory;
    private TransactionType mTransactionType;
    private boolean mIsUnfinished;
    private BankStatementData mBankStatementData;
    private BankAccount mBankAccount;
    private Date mTaxDate;
    private boolean mIsDebit;
    private NLAccountCompanySetting mContraNLAccount;
    private boolean mIsInputTax;
    private ModeOfPayment mPaymentType;
    private IPersonalAccountBankAddress mBankAddress;
    private Date mDueDate;
    private Date mValueDate;
    private OpenItemCurrentStatus mCurrentStatus;
    private ITermOfPayment mTermOfPayment;
    private BigDecimal mDiscountableAmount;
    private BigDecimal mDiscountableBaseAmount;
    private IOpenItemDiscount mDiscount1;
    private IOpenItemDiscount mDiscount2;
    private IOpenItemDiscount mDiscount3;
    private DeliveryAddress mDeliveryAddress;
    private DiscountType mDiscountType;
    private String mTaxRateOID;
    private BigDecimal mTaxAmount;
    private BigDecimal mBaseTaxAmount;
    private BigDecimal mNetAmount;
    private boolean mIsCorrection;
    private Date paymentEffectiveDate;
    private String mOcrBData;
    private EsrPayment mEsrPayment;
    private Date mWithholdDirectDebitOrPaymentToDate;
    private String mDirectDebitOrPaymentDetails;
    private Date mWithholdReminderToDate;
    private boolean mForcedPayment;
    private boolean mExcludeFromCentralizedPayment;
    private GeneratePaymentSession mGeneratePaymentSession;
    private Date mPaymentSessionExecuteDate;
    private DunningLetterSession mDunningLetterSession;
    private DunningGrade mDunningGradeUsedForCopyOpenItem;
    private DunningGrade mDunningGrade;
    private Date mLastDunningDate;
    private BigDecimal mDownPaymentAmount;
    private BigDecimal mDownPaymentBaseAmount;
    private CustSupAddress mDunningAddress;
    private Representative mRepresentative;
    private ConversionRate mNewConversionRate;
    private Date mFactoringESDate;
    private Date mAbsTransferDate;
    private ReminderStatus mReminderStatus;
    private boolean mInProcessing;
    private AccountCleanupSession mAccountCleanupSession;
    private boolean mIsReturnPayment;
    private OpenItem mOriginalOpenItem;
    private boolean mIsDiscountable1;
    private String mTaxRate2OID;
    private BigDecimal mTaxAmount2;
    private BigDecimal mNetAmount2;
    private boolean mIsDiscountable2;
    private String mTaxRate3OID;
    private BigDecimal mTaxAmount3;
    private BigDecimal mNetAmount3;
    private boolean mIsDiscountable3;
    private String mTaxRate4OID;
    private BigDecimal mTaxAmount4;
    private BigDecimal mNetAmount4;
    private boolean mIsDiscountable4;
    private String mTaxRate5OID;
    private BigDecimal mTaxAmount5;
    private BigDecimal mNetAmount5;
    private boolean mIsDiscountable5;
    private ServiceTypeAWV mServiceTypeAWV;
    private PurchaseInvoiceRegisterStatus mPurchaseInvoiceRegisterStatus;
    private ICostUnit mCostUnit;
    private int mTransactionPersistencyType;
    private boolean mUpdateByOpenItemAllocation = false;
    private CurrencyRevaluation mCurrencyRevaluation;
    private PersonalAccount mDunningLetterPersonalAccount;
    private boolean mIsDunningLetterInvoice;
    private PersonalAccount mPayer;
    private PaymentSessionBankAccount mPaymentSessionBankAccount;
    private Date mExecuteDate;
    private IPersonalAccountBankAddress mPaymentBankAddress;
    private FinanceSetup mFinanceSetup = null;
    private Map<ICurrency, ConversionRate> mSeccurrConversionRateMap = null;
    private boolean mIsAllocated_old = false;
    private Date mInterestCalculationDate;
    private OpenItem mDunningOpenItemForReplace;
    private boolean mIsCreatedByTransfer = false;
    private boolean mAssignedToFinalInvoice = false;
    private boolean mAssignedToFinalInvoiceCalculated = false;
    private boolean mIsKronospanPL;
    private boolean mIsKronospanPLCalculated = false;
    private BigDecimal mDownPaymentOpenAmount;
    private BigDecimal mDownPaymentBaseOpenAmount;
    private boolean mIsDownPaymentRequestAllocated;
    private DownPaymentRequestAllocationAmount[] mDownPaymentRequestAllocationAmounts;
    private boolean mIsProcessingInRepostingPersonalAccount;
    private boolean mIsProcessingInRepostingPersonalAccountCalculated = false;
    private Boolean isInZ4List;
    private String ksefNumber;
    private KsefNumberType ksefNumberType;

    public OpenItem(PersonalAccountEntry entry, AccountingCompany company) {
        super(6);
        this.mTransactionPersistencyType = entry != null ? entry.getTransactionPersistencyType() : 0;
        this.mCompany = company;
        this.mPersonalAccountEntry = entry;
        this.mIsAllocated = false;
        this.mIsCancelled = false;
        this.mIsCancellation = false;
        this.mIsOpeningBalance = false;
        this.mIsInterestOpenItem = false;
        this.mForcedPayment = false;
        this.mIsUnfinished = false;
        this.mIsCorrection = false;
        this.mExcludeFromCentralizedPayment = false;
        this.mInProcessing = false;
        if (entry != null) {
            this.mIsDebit = TransactionHelper.getIsDebit((INominalLedgerEntry)entry);
        }
        this.mIsReturnPayment = false;
        this.mIsDownPaymentRequestAllocated = false;
        this.mPurchaseInvoiceRegisterStatus = PurchaseInvoiceRegisterStatus.NONE;
        this.ksefNumberType = KsefNumberType.NOT_SPECIFIED;
    }

    OpenItem(String objectid, int transactionPersistencyType) {
        super(6, objectid);
        this.mTransactionPersistencyType = transactionPersistencyType;
    }

    public OpenItem(String objectid, int version, PersonalAccountEntry entry) {
        super(6, objectid, version, true);
        this.mTransactionPersistencyType = entry != null ? entry.getTransactionPersistencyType() : 0;
        if (this.getIsRecurring() || this.getIsBankStatementPosting()) {
            throw ExceptionMapper.makeApplicationException((String)"openitem.create an updateable object: should not be called");
        }
        this.mPersonalAccountEntry = entry;
        this.requireLoaded();
    }

    public OpenItem(boolean readOnly, int transactionPersistencyType) {
        super(6, readOnly);
        this.mTransactionPersistencyType = transactionPersistencyType;
    }

    public OpenItem(OpenItem openItemToCancel, PersonalAccountEntry cancellationEntry, boolean wasAllocationDeleted) throws BusinessDomainException {
        super(6);
        this.validator.checkForCancellation(openItemToCancel);
        this.mTransactionPersistencyType = cancellationEntry.getTransactionPersistencyType();
        this.mCompany = openItemToCancel.getCompany();
        this.mPersonalAccountEntry = cancellationEntry;
        this.mInProcessing = false;
        this.mPurchaseInvoiceRegisterStatus = PurchaseInvoiceRegisterStatus.NONE;
        boolean debit = TransactionHelper.getIsDebit((INominalLedgerEntry)cancellationEntry);
        this.setIsDebit(debit);
        this.setIsCancellation(true);
        this.setOpenItemType(openItemToCancel.getOpenItemType());
        OpenItemSecondaryCurrencyAmounts seccurrOriginalAmounts = new OpenItemSecondaryCurrencyAmounts(openItemToCancel.getSeccurr1OriginalAmount(), openItemToCancel.getSeccurr2OriginalAmount(), openItemToCancel.getSeccurr3OriginalAmount(), openItemToCancel.getSeccurr4OriginalAmount());
        this.setBaseOriginalAmount(openItemToCancel.getBaseOriginalAmount(), seccurrOriginalAmounts);
        this.setOriginalAmount(openItemToCancel.getOriginalAmount());
        if (wasAllocationDeleted) {
            this.setOpenAmount(openItemToCancel.getOpenAmount());
            this.setBaseOpenAmount(openItemToCancel.getBaseOpenAmount(), new OpenItemSecondaryCurrencyAmounts(openItemToCancel.getSeccurr1OpenAmount(), openItemToCancel.getSeccurr2OpenAmount(), openItemToCancel.getSeccurr3OpenAmount(), openItemToCancel.getSeccurr4OpenAmount()));
            this.setNote(openItemToCancel.getNote());
        } else {
            this.setIsAllocated(false);
            this.setOpenAmount(openItemToCancel.getOriginalAmount());
            this.setBaseOpenAmount(openItemToCancel.getBaseOriginalAmount(), seccurrOriginalAmounts);
            this.setNote(cancellationEntry.getDescription());
            this.setAllocationNumber(null);
        }
        this.setIsInputTax(openItemToCancel.getIsInputTax());
        this.setDueDate(openItemToCancel.getDueDate());
        this.setValueDate(openItemToCancel.getValueDate());
        this.setDiscountableAmount(openItemToCancel.getDiscountableAmount());
        this.setDiscountableBaseAmount(openItemToCancel.getDiscountableBaseAmount());
        this.setDiscount1(openItemToCancel.getDiscount1());
        this.setDiscount2(openItemToCancel.getDiscount2());
        this.setDiscount3(openItemToCancel.getDiscount3());
        this.setTermOfPayment(openItemToCancel.getTermOfPayment());
        this.setBankAddress(openItemToCancel.getBankAddress());
        this.setPaymentType(openItemToCancel.getPaymentType());
        this.setWithholdDirectDebitOrPaymentToDate(openItemToCancel.getWithholdDirectDebitOrPaymentToDate());
        this.setWithholdReminderToDate(openItemToCancel.getWithholdReminderToDate());
        this.setForcedPayment(openItemToCancel.getForcedPayment());
        this.setDirectDebitOrPaymentDetails(openItemToCancel.getDirectDebitOrPaymentDetails());
        this.setOneOffAccountAddress(openItemToCancel.getOneOffAccountAddress());
        this.setFactoring(openItemToCancel.getFactoring());
        this.setFactoringNote(openItemToCancel.getFactoringNote());
        this.setInstalmentNumber(openItemToCancel.getInstalmentNumber());
        this.setAnalysisCodes(openItemToCancel.getAnalysisCodes(), false, false);
        this.setIsDownPayment(openItemToCancel.isDownPayment());
        this.setDownPaymentDiscountAmount(openItemToCancel.getDownPaymentDiscountAmount());
        this.setDownPaymentBaseDiscountAmount(openItemToCancel.getDownPaymentBaseDiscountAmount());
        this.setDownPaymentTaxCode(openItemToCancel.getDownPaymentTaxCode());
        this.setIsDownPaymentFinalInvoice(openItemToCancel.getIsDownPaymentFinalInvoice());
        this.setBankStatementData(openItemToCancel.getBankStatementData());
        this.setIsOpeningBalance(openItemToCancel.getIsOpeningBalance());
        this.setDeliveryAddress(openItemToCancel.getDeliveryAddress());
        this.setDunningAddress(openItemToCancel.getDunningAddress());
        this.setRepresentative(openItemToCancel.getRepresentative());
        this.setServiceTypeAWV(openItemToCancel.getServiceTypeAWV());
        this.setIsInterestOpenItem(openItemToCancel.isInterestOpenItem());
        this.setTaxRate(openItemToCancel.getFixedTaxRate());
        this.setTaxAmount(openItemToCancel.getTaxAmount());
        this.setBaseTaxAmount(openItemToCancel.getBaseTaxAmount());
        this.setExcludeFromCentralizedPayment(openItemToCancel.getExcludeFromCentralizedPayment());
        this.setDownPaymentBaseTaxAmount(openItemToCancel.getDownPaymentBaseTaxAmount());
        this.setDownPaymentTaxAmount(openItemToCancel.getDownPaymentTaxAmount());
        this.setDownPaymentAmount(openItemToCancel.getDownPaymentAmount());
        this.setDownPaymentBaseAmount(openItemToCancel.getDownPaymentBaseAmount());
        this.setCostUnit(openItemToCancel.getCostUnit());
        this.copyDataFromTransaction();
    }

    public OpenItem(OpenItem copyFromOpenItem, CancellationContext cancellationContext) throws BusinessDomainException {
        super(6);
        this.mTransactionPersistencyType = 0;
        this.mCompany = copyFromOpenItem.getCompany();
        this.mPersonalAccountEntry = null;
        this.mInProcessing = false;
        this.setIsCancellation(false);
        boolean debit = copyFromOpenItem.getIsDebit();
        this.setIsDebit(!debit);
        this.setOpenItemType(copyFromOpenItem.getOpenItemType());
        this.setTransactionDate(cancellationContext.getTransactionDate());
        this.setFinancialYear(cancellationContext.getFinancialYear());
        OpenItemSecondaryCurrencyAmounts seccurrOriginalAmounts = new OpenItemSecondaryCurrencyAmounts(copyFromOpenItem.getSeccurr1OriginalAmount(), copyFromOpenItem.getSeccurr2OriginalAmount(), copyFromOpenItem.getSeccurr3OriginalAmount(), copyFromOpenItem.getSeccurr4OriginalAmount());
        this.setBaseOriginalAmount(copyFromOpenItem.getBaseOriginalAmount(), seccurrOriginalAmounts);
        this.setOriginalAmount(copyFromOpenItem.getOriginalAmount());
        this.setOpenAmount(copyFromOpenItem.getOriginalAmount());
        this.setBaseOpenAmount(copyFromOpenItem.getBaseOriginalAmount(), seccurrOriginalAmounts);
        this.setEnteredCurrency(copyFromOpenItem.getEnteredCurrency());
        this.setConversionRate(copyFromOpenItem.getConversionRate());
        this.setSeccurr1ConversionRate(copyFromOpenItem.getSeccurr1ConversionRate());
        this.setSeccurr2ConversionRate(copyFromOpenItem.getSeccurr2ConversionRate());
        this.setSeccurr3ConversionRate(copyFromOpenItem.getSeccurr3ConversionRate());
        this.setSeccurr4ConversionRate(copyFromOpenItem.getSeccurr4ConversionRate());
        this.setIsAllocated(false);
        this.setReferenceNumber(copyFromOpenItem.getReferenceNumber());
        this.setPersonalAccount(copyFromOpenItem.getPersonalAccount());
        this.setSequenceNumber(copyFromOpenItem.getSequenceNumber());
        this.setProcessID(copyFromOpenItem.getProcessID());
        this.setIsUnfinished(copyFromOpenItem.isUnfinished());
        this.setDocumentDate(copyFromOpenItem.getDocumentDate());
        this.setTransactionType(null);
        this.setTaxDate(copyFromOpenItem.getTaxDate());
        this.setNote(copyFromOpenItem.getNote());
        this.setIsInputTax(copyFromOpenItem.getIsInputTax());
        this.setDueDate(copyFromOpenItem.getDueDate());
        this.setValueDate(copyFromOpenItem.getValueDate());
        this.setDiscountType(copyFromOpenItem.getDiscountType());
        this.setDiscountableAmount(copyFromOpenItem.getDiscountableAmount());
        this.setDiscountableBaseAmount(copyFromOpenItem.getDiscountableBaseAmount());
        this.setDiscount1(copyFromOpenItem.getDiscount1());
        this.setDiscount2(copyFromOpenItem.getDiscount2());
        this.setDiscount3(copyFromOpenItem.getDiscount3());
        this.setTermOfPayment(copyFromOpenItem.getTermOfPayment());
        this.setBankAddress(copyFromOpenItem.getBankAddress());
        this.setPaymentType(copyFromOpenItem.getPaymentType());
        this.setWithholdDirectDebitOrPaymentToDate(copyFromOpenItem.getWithholdDirectDebitOrPaymentToDate());
        this.setWithholdReminderToDate(copyFromOpenItem.getWithholdReminderToDate());
        this.setForcedPayment(copyFromOpenItem.getForcedPayment());
        this.setDirectDebitOrPaymentDetails(copyFromOpenItem.getDirectDebitOrPaymentDetails());
        this.setOneOffAccountAddress(copyFromOpenItem.getOneOffAccountAddress());
        this.setFactoring(copyFromOpenItem.getFactoring());
        this.setFactoringNote(copyFromOpenItem.getFactoringNote());
        this.setInstalmentNumber(copyFromOpenItem.getInstalmentNumber());
        this.setAnalysisCodes(copyFromOpenItem.getAnalysisCodes(), false, false);
        this.setIsDownPayment(copyFromOpenItem.isDownPayment());
        this.setDownPaymentDiscountAmount(copyFromOpenItem.getDownPaymentDiscountAmount());
        this.setDownPaymentBaseDiscountAmount(copyFromOpenItem.getDownPaymentBaseDiscountAmount());
        this.setDownPaymentTaxCode(copyFromOpenItem.getDownPaymentTaxCode());
        this.setIsDownPaymentFinalInvoice(copyFromOpenItem.getIsDownPaymentFinalInvoice());
        this.setRemainderTaxCode(copyFromOpenItem.getRemainderTaxCode());
        this.setBankStatementData(copyFromOpenItem.getBankStatementData());
        this.setIsOpeningBalance(copyFromOpenItem.getIsOpeningBalance());
        this.setDeliveryAddress(copyFromOpenItem.getDeliveryAddress());
        this.setDunningAddress(copyFromOpenItem.getDunningAddress());
        this.setRepresentative(copyFromOpenItem.getRepresentative());
        this.setServiceTypeAWV(copyFromOpenItem.getServiceTypeAWV());
        this.setIsInterestOpenItem(copyFromOpenItem.isInterestOpenItem());
        this.setTaxRate(copyFromOpenItem.getFixedTaxRate());
        this.setTaxAmount(copyFromOpenItem.getTaxAmount());
        this.setBaseTaxAmount(copyFromOpenItem.getBaseTaxAmount());
        this.setExcludeFromCentralizedPayment(copyFromOpenItem.getExcludeFromCentralizedPayment());
        this.setDownPaymentBaseTaxAmount(copyFromOpenItem.getDownPaymentBaseTaxAmount());
        this.setDownPaymentTaxAmount(copyFromOpenItem.getDownPaymentTaxAmount());
        this.setPurchaseInvoiceRegisterStatus(copyFromOpenItem.getPurchaseInvoiceRegisterStatus());
    }

    protected void load() {
        if (this.getIsRecurring() || this.getIsBankStatementPosting()) {
            throw ExceptionMapper.makeApplicationException((String)"openitem.load: should not be called");
        }
        OpenItemPersistencyManager.load((OpenItem)this);
    }

    protected void destroyImpl() throws BusinessDomainException {
        this.requireLoaded();
        this.validator.checkForDestroy(this);
        OpenItemAllocation placeholderAllocation = this.getPlaceholderAllocation();
        if (placeholderAllocation != null) {
            placeholderAllocation.makeSaveable();
            placeholderAllocation.destroy();
        }
        if (this.getBankAddress() != null && this.getBankAddress().getIsOneOffAddress() && OpenItemPersistencyManager.countOpenItemsUsingBankAddress((IPersonalAccountBankAddress)this.getBankAddress()) == 1L) {
            this.getBankAddress().makeSaveable();
            this.getBankAddress().destroy();
        }
    }

    protected void deleteImpl() {
        if (!this.getIsRecurring() && !this.getIsBankStatementPosting()) {
            OpenItemPersistencyManager.delete((OpenItem)this);
        }
    }

    public String getClassName() {
        return CLASSNAME;
    }

    public String getDomainKey() {
        return this.getPersonalAccount().getDomainKey() + "/" + DateMapper.toString((Date)this.getDocumentDate()) + "/" + StringMapper.toString((String)this.getReferenceNumber());
    }

    protected void saveImpl() {
        if (!this.getIsRecurring() && !this.getIsBankStatementPosting()) {
            OpenItemPersistencyManager.save((OpenItem)this);
            if (!this.isNew()) {
                this.registerForLastExecute();
            }
        }
    }

    protected void lastExecuteImpl() throws BusinessDomainException {
        if (this.isNew()) {
            return;
        }
        new OpenItemCurrentStatusService().updateAllocationIfRequired(this);
    }

    public void setData(OpenItemData data) {
        this.mCompany = data.getCompany();
        this.mPersonalAccountEntry = data.getPersonalAccountEntry();
        this.mPersonalAccount = data.getPersonalAccount();
        this.mReferenceNumber = data.getReferenceNumber();
        this.mSequenceNumber = data.getSequenceNumber();
        this.mProcessID = data.getProcessID();
        this.mDocumentDate = data.getDocumentDate();
        this.mOpenItemType = data.getOpenItemType();
        this.mNote = data.getNote();
        this.mEnteredCurrency = data.getEnteredCurrency();
        this.mConversionRate = data.getConversionRate();
        this.mOriginalAmount = data.getOriginalAmount();
        this.mBaseOriginalAmount = data.getBaseOriginalAmount();
        this.mOpenAmount = data.getOpenAmount();
        this.mBaseOpenAmount = data.getBaseOpenAmount();
        this.mIsAllocated = data.isAllocated();
        this.mCompletedAllocationDate = data.getCompletedAllocationDate();
        this.mCompletedAllocationYear = data.getCompletedAllocationYear();
        this.mIsCancelled = data.isCancelled();
        this.mIsCancellation = data.isCancellation();
        this.mPaymentType = data.getPaymentType();
        this.mBankAddress = data.getBankAddress();
        this.mOneOffAccountAddress = data.getOneOffAccountAddress();
        this.mDueDate = data.getDueDate();
        this.mValueDate = data.getValueDate();
        this.mTermOfPayment = data.getTermOfPayment();
        this.mDiscount1 = data.getDiscount1();
        this.mDiscount2 = data.getDiscount2();
        this.mDiscount3 = data.getDiscount3();
        this.mDiscountableAmount = data.getDiscountableAmount();
        this.mDiscountableBaseAmount = data.getDiscountableBaseAmount();
        this.mWithholdDirectDebitOrPaymentToDate = data.getWithholdDirectDebitOrPaymentToDate();
        this.mDirectDebitOrPaymentDetails = data.getDirectDebitOrPaymentDetails();
        this.mWithholdReminderToDate = data.getWithholdReminderToDate();
        this.mForcedPayment = data.isForcedPayment();
        this.mCurrencyRevaluationSession = data.getCurrencyRevaluationSession();
        this.mImportApplication = data.getImportApplication();
        this.mFactoring = data.isFactoring();
        this.mFactoringNote = data.getFactoringNote();
        this.mGeneratePaymentSession = data.getGeneratePaymentSession();
        this.mPaymentSessionExecuteDate = data.getPaymentSessionExecuteDate();
        this.mDunningLetterSession = data.getDunningLetterSession();
        this.mDunningGrade = data.getDunningGrade();
        this.mLastDunningDate = data.getLastDunningDate();
        this.mOcrBData = data.getOcrBData();
        this.mEsrPayment = data.getEsrPayment();
        this.mInstalmentNumber = data.getInstalmentNumber();
        this.mCurrentStatus = data.getCurrentStatus();
        this.mAnalysisCodes = data.getAnalysisCodes();
        this.mIsDownPayment = data.isDownPayment();
        this.mRemainderTaxCodeOID = data.getRemainderTaxCodeOID();
        this.mDownPaymentDiscountAmount = data.getDownPaymentDiscountAmount();
        this.mDownPaymentBaseDiscountAmount = data.getDownPaymentBaseDiscountAmount();
        this.mDownPaymentBaseTaxAmount = data.getDownPaymentBaseTaxAmount();
        this.mFinancialYear = data.getFinancialYear();
        this.mDownPaymentTaxCodeOID = data.getDownPaymentTaxCodeOID();
        this.mDocumentType = data.getDocumentType();
        this.mTransactionDate = data.getTransactionDate();
        this.mIsDownPaymentFinalInvoice = data.isDownPaymentFinalInvoice();
        this.mBankStatementData = data.getBankStatementData();
        this.mIsOpeningBalance = data.isOpeningBalance();
        this.mDeliveryAddress = data.getDeliveryAddress();
        this.mHasNewConversionRate = data.isHasNewConversionRate();
        this.mDownPaymentAmount = data.getDownPaymentAmount();
        this.mFactoringESDate = data.getFactoringESDate();
        this.mAbsTransferDate = data.getAbsTransferDate();
        this.mDunningAddress = data.getDunningAddress();
        this.mRepresentative = data.getRepresentative();
        this.mServiceTypeAWV = data.getServiceTypeAWV();
        this.mReminderStatus = data.getReminderStatus();
        this.mIsInterestOpenItem = data.isInterestOpenItem();
        this.mCostCentreBase = data.getCostCentreBase();
        this.mInstalment = data.getInstalment();
        this.mOriginalOpenItem = data.getOriginalOpenItem();
        this.mAllocationNumber = data.getAllocationNumber();
        this.mBankStatementPostingSession = data.getBankStatementPostingSession();
        this.mAdvicePostingSession = data.getAdvicePostingSession();
        this.mDocumentCategory = data.getDocumentCategory();
        this.mTaxDate = data.getTaxDate();
        this.mBankAccount = data.getBankAccount();
        this.mDiscountType = data.getDiscountType();
        this.mTaxRateOID = data.getTaxRateOID();
        this.mTaxAmount = data.getTaxAmount();
        this.mBaseTaxAmount = data.getBaseTaxAmount();
        this.mNetAmount = data.getNetAmount();
        this.mTaxRate2OID = data.getTaxRate2OID();
        this.mTaxAmount2 = data.getTaxAmount2();
        this.mNetAmount2 = data.getNetAmount2();
        this.mTaxRate3OID = data.getTaxRate3OID();
        this.mTaxAmount3 = data.getTaxAmount3();
        this.mNetAmount3 = data.getNetAmount3();
        this.mTaxRate4OID = data.getTaxRate4OID();
        this.mTaxAmount4 = data.getTaxAmount4();
        this.mNetAmount4 = data.getNetAmount4();
        this.mTaxRate5OID = data.getTaxRate5OID();
        this.mTaxAmount5 = data.getTaxAmount5();
        this.mNetAmount5 = data.getNetAmount5();
        this.mIsUnfinished = data.isUnfinished();
        this.mTransactionType = data.getTransactionType();
        this.mDownPaymentTaxAmount = data.getDownPaymentTaxAmount();
        this.mIsDiscountable1 = data.isDiscountable1();
        this.mIsDiscountable2 = data.isDiscountable2();
        this.mIsDiscountable3 = data.isDiscountable3();
        this.mIsDiscountable4 = data.isDiscountable4();
        this.mIsDiscountable5 = data.isDiscountable5();
        this.mContraNLAccount = data.getContraNLAccount();
        this.mIsDebit = data.isDebit();
        this.mIsCorrection = data.isCorrection();
        this.mIsInputTax = data.isInputTax();
        this.mInterestCalculationDate = data.getInterestCalculationDate();
        this.mExcludeFromCentralizedPayment = data.isExcludeFromCentralizedPayment();
        this.mSeccurr1OriginalAmount = data.getSeccurr1OriginalAmount();
        this.mSeccurr2OriginalAmount = data.getSeccurr2OriginalAmount();
        this.mSeccurr3OriginalAmount = data.getSeccurr3OriginalAmount();
        this.mSeccurr4OriginalAmount = data.getSeccurr4OriginalAmount();
        this.mSeccurr1OpenAmount = data.getSeccurr1OpenAmount();
        this.mSeccurr2OpenAmount = data.getSeccurr2OpenAmount();
        this.mSeccurr3OpenAmount = data.getSeccurr3OpenAmount();
        this.mSeccurr4OpenAmount = data.getSeccurr4OpenAmount();
        this.mSeccurr1ConversionRate = data.getSeccurr1ConversionRate();
        this.mSeccurr2ConversionRate = data.getSeccurr2ConversionRate();
        this.mSeccurr3ConversionRate = data.getSeccurr3ConversionRate();
        this.mSeccurr4ConversionRate = data.getSeccurr4ConversionRate();
        this.mInProcessing = data.isInProcessing();
        this.mAccountCleanupSession = data.getAccountCleanupSession();
        this.mIsAllocated_old = data.isAllocated();
        this.mIsCreatedByTransfer = data.isCreatedByTransfer();
        this.mIsReturnPayment = data.getIsReturnPayment();
        this.mIsDownPaymentRequestAllocated = data.getIsDownPaymentRequestAllocated();
        this.mDownPaymentOpenAmount = data.getDownPaymentOpenAmount();
        this.mDownPaymentBaseAmount = data.getDownPaymentBaseAmount();
        this.mDownPaymentBaseOpenAmount = data.getDownPaymentBaseOpenAmount();
        this.mCostUnit = data.getCostUnit();
        this.mPurchaseInvoiceRegisterStatus = data.getPurchaseInvoiceRegisterStatus();
        this.ksefNumber = data.getKsefNumber();
        this.ksefNumberType = data.getKsefNumberType();
        this.paymentEffectiveDate = data.getPaymentEffectiveDate();
    }

    public AccountingCompany getCompany() {
        this.requireLoaded();
        return this.mCompany;
    }

    public PersonalAccountEntry getPersonalAccountEntry() {
        if (this.mPersonalAccountEntry == null) {
            this.requireLoaded();
        }
        return this.mPersonalAccountEntry;
    }

    public void setPersonalAccountEntry(PersonalAccountEntry personalAccountEntry) {
        this.mPersonalAccountEntry = personalAccountEntry;
    }

    public void setExcludeFromCentralizedPayment(boolean excludeFromCentralizedPayment) {
        this.mExcludeFromCentralizedPayment = excludeFromCentralizedPayment;
    }

    public boolean getExcludeFromCentralizedPayment() {
        this.requireLoaded();
        return this.mExcludeFromCentralizedPayment;
    }

    public void setIsCorrection(boolean isCorrection) {
        this.mIsCorrection = isCorrection;
    }

    public boolean getIsCorrection() {
        this.requireLoaded();
        return this.mIsCorrection;
    }

    public FinancialYear getFinancialYear() {
        this.requireLoaded();
        return this.mFinancialYear;
    }

    public void setFinancialYear(FinancialYear financialYear) throws BusinessDomainException {
        if (this.getOpenItemType() == OpenItemType.DOWN_PAYMENT_REQUEST) {
            if (financialYear == null) {
                throw TransactionExceptionMapper.makeFinancialYearMissingDomainException();
            }
            if (!this.isNew() && PersistentObjectUtils.objectChanged((IPersistentObject)this.getFinancialYear(), (IPersistentObject)financialYear)) {
                this.checkIfProcessedForUpdate();
            }
        }
        this.protocol("financialyear", (IPersistentObject)this.mFinancialYear, (IPersistentObject)financialYear);
        this.mFinancialYear = financialYear;
    }

    public Date getTransactionDate() {
        this.requireLoaded();
        return this.mTransactionDate;
    }

    public void setTransactionDate(Date transactionDate) throws BusinessDomainException {
        if (this.getOpenItemType() == OpenItemType.DOWN_PAYMENT_REQUEST) {
            if (transactionDate == null) {
                throw TransactionExceptionMapper.makeTransactionDateMissingDomainException();
            }
            if (!this.isNew() && !DateHelper.equal((Date)transactionDate, (Date)this.getTransactionDate())) {
                this.checkIfProcessedForUpdate();
            }
        }
        this.protocol("transactiondate", this.mTransactionDate, transactionDate);
        this.mTransactionDate = transactionDate;
    }

    public Date getTaxDate() {
        this.requireLoaded();
        return this.mTaxDate;
    }

    public void setTaxDate(Date taxDate) throws BusinessDomainException {
        this.setTaxDate(taxDate, false);
    }

    public void setTaxDate(Date taxDate, boolean withCheck) throws BusinessDomainException {
        if (withCheck && !this.isNew()) {
            if (this.getTaxDate() != null && taxDate == null) {
                throw TransactionExceptionMapper.makeTaxDateMissingDomainException();
            }
            if (!DateHelper.equal((Date)taxDate, (Date)this.getTaxDate()) && this.isAllocated()) {
                if (this.isKronospanPL()) {
                    if (this.getHasPersonalAccountAdjustments()) {
                        throw TransactionExceptionMapper.makeHasPersonalAccountAdjustmentsDomainException();
                    }
                } else {
                    throw OpenItemExceptionMapper.makeChangeNotAllowedBacauseAllocatedDomainException();
                }
            }
        }
        this.protocol("taxdate", this.mTaxDate, taxDate);
        this.mTaxDate = taxDate;
    }

    public boolean getIsInputTax() {
        this.requireLoaded();
        return this.mIsInputTax;
    }

    public void setIsInputTax(boolean isInputTax) throws BusinessDomainException {
        this.setIsInputTax(isInputTax, true);
    }

    public void setIsInputTax(boolean isInputTax, boolean checkIfAllocated) throws BusinessDomainException {
        if (!this.isNew() && this.getIsInputTax() != isInputTax && checkIfAllocated && this.isAllocated()) {
            throw OpenItemExceptionMapper.makeChangeNotAllowedBacauseAllocatedDomainException();
        }
        this.protocol("isinputtax", this.mIsInputTax, isInputTax);
        this.mIsInputTax = isInputTax;
    }

    public void setDunningAddress(CustSupAddress dunningAddress) {
        this.protocol("dunningaddress", (IPersistentObject)this.mDunningAddress, (IPersistentObject)dunningAddress);
        this.mDunningAddress = dunningAddress;
    }

    public CustSupAddress getDunningAddress() {
        this.requireLoaded();
        return this.mDunningAddress;
    }

    public void setRepresentative(Representative representative) {
        this.protocol("representative", (IPersistentObject)this.mRepresentative, (IPersistentObject)representative);
        this.mRepresentative = representative;
    }

    public Representative getRepresentative() {
        this.requireLoaded();
        return this.mRepresentative;
    }

    public void setServiceTypeAWV(ServiceTypeAWV serviceTypeAWV) {
        this.protocol("servicetypeawv", (IPersistentObject)this.mServiceTypeAWV, (IPersistentObject)serviceTypeAWV);
        this.mServiceTypeAWV = serviceTypeAWV;
    }

    public ServiceTypeAWV getServiceTypeAWV() {
        this.requireLoaded();
        return this.mServiceTypeAWV;
    }

    public PersonalAccount getPersonalAccount() {
        this.requireLoaded();
        if (this.mPersonalAccount == null && this.getPersonalAccountEntry() != null) {
            this.mPersonalAccount = this.getPersonalAccountEntry().getPersonalAccount();
        }
        return this.mPersonalAccount;
    }

    public void setPersonalAccount(PersonalAccount personalAccount) throws BusinessDomainException {
        if (personalAccount == null) {
            throw TransactionExceptionMapper.makePersonalAccountNotSet();
        }
        if (!this.isNew() && !this.mPersonalAccount.equals((Object)personalAccount)) {
            this.checkIfProcessedForUpdate();
        }
        this.protocol("personalaccount", (IPersistentObject)this.mPersonalAccount, (IPersistentObject)personalAccount);
        this.mPersonalAccount = personalAccount;
    }

    public void setIsDownPaymentFinalInvoice(boolean downPaymentFinalInvoice) {
        this.protocol("isdownpaymentfinalinvoice", this.mIsDownPaymentFinalInvoice, downPaymentFinalInvoice);
        this.mIsDownPaymentFinalInvoice = downPaymentFinalInvoice;
    }

    public boolean getIsDownPaymentFinalInvoice() {
        this.requireLoaded();
        return this.mIsDownPaymentFinalInvoice;
    }

    public NLAccountCompanySetting getContraNLAccount() {
        this.requireLoaded();
        return this.mContraNLAccount;
    }

    public void setContraNLAccount(NLAccountCompanySetting contraNLAccount) {
        this.mContraNLAccount = contraNLAccount;
    }

    public void setHasNewConversionRate(boolean newConversionRate) {
        this.protocol("hasNewConversionRate", this.mHasNewConversionRate, newConversionRate);
        this.mHasNewConversionRate = newConversionRate;
    }

    public boolean getHasNewConversionRate() {
        this.requireLoaded();
        return this.mHasNewConversionRate;
    }

    public void setIsOpeningBalance(boolean openingBalance) {
        this.protocol("isopeningbalance", this.mIsOpeningBalance, openingBalance);
        this.mIsOpeningBalance = openingBalance;
    }

    public boolean getIsOpeningBalance() {
        this.requireLoaded();
        return this.mIsOpeningBalance;
    }

    public CurrencyRevaluationSession getCurrencyRevaluationSession() {
        this.requireLoaded();
        return this.mCurrencyRevaluationSession;
    }

    public CurrencyRevaluation getCurrencyRevaluation() {
        return this.mCurrencyRevaluation;
    }

    public void setCurrencyRevaluation(CurrencyRevaluation currencyRevaluation) {
        this.mCurrencyRevaluation = currencyRevaluation;
    }

    public Instalment getInstalment() {
        this.requireLoaded();
        return this.mInstalment;
    }

    public BankStatementPostingSession getBankStatementPostingSession() {
        this.requireLoaded();
        return this.mBankStatementPostingSession;
    }

    public AdvicePostingSession getAdvicePostingSession() {
        this.requireLoaded();
        return this.mAdvicePostingSession;
    }

    public GeneratePaymentSession getGeneratePaymentSession() {
        this.requireLoaded();
        return this.mGeneratePaymentSession;
    }

    public Date getPaymentSessionExecuteDate() {
        this.requireLoaded();
        return this.mPaymentSessionExecuteDate;
    }

    public void setPaymentSessionExecuteDate(Date paymentSessionExecuteDate) {
        this.mPaymentSessionExecuteDate = paymentSessionExecuteDate;
    }

    public DunningLetterSession getDunningLetterSession() {
        this.requireLoaded();
        return this.mDunningLetterSession;
    }

    public Date getDueDateUsedForDunning() {
        Date dueDate = this.getDueDate();
        if (dueDate == null) {
            dueDate = this.getDocumentDate();
        }
        return dueDate;
    }

    public DunningGrade getDunningGradeUsedForCopyOpenItem() {
        return this.mDunningGradeUsedForCopyOpenItem;
    }

    public void setDunningGradeUsedForCopyOpenItem(DunningGrade dunningGrade) {
        this.mDunningGradeUsedForCopyOpenItem = dunningGrade;
    }

    public ReminderStatus getReminderStatus() {
        this.requireLoaded();
        if (this.mReminderStatus == null) {
            this.mReminderStatus = ReminderStatus.NONE;
        }
        return this.mReminderStatus;
    }

    public void setReminderStatus(ReminderStatus reminderStatus) throws BusinessDomainException {
        this.requireLoaded();
        this.protocol("dunningstatus", PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)this.mReminderStatus), PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)reminderStatus));
        this.mReminderStatus = reminderStatus;
        if (this.getDunningLetterSession() != null && !this.mDunningLetterSession.isNew()) {
            IAnalysisCodeEntry[] analysisCodeEntries;
            AnalysisCodeCategory analysisCodeCategory;
            AnalysisCodeTable[] analysisCodeTables;
            OpenItemPersistencyManager.updateDunningStatus((OpenItem)this);
            boolean isSetFirstAnalyseCodeToCustomer = ISoftware.getSetFirstAnalyseCodeToCustomer();
            if (isSetFirstAnalyseCodeToCustomer && (analysisCodeTables = (analysisCodeCategory = AnalysisCodeCategoryPersistencyManager.getCategory((ICompany)this.getDunningLetterSession().getAccountingCompany(), (AnalysisCodeCategoryType)AnalysisCodeCategoryType.CUSTOMER_OPEN_ITEMS)).getAnalysisCodeTables()) != null && analysisCodeTables.length > 0 && (analysisCodeEntries = analysisCodeTables[0].getCodes()) != null && analysisCodeEntries.length > 0) {
                String[] analysisCodesOfCustomer = this.getAnalysisCodes();
                if (analysisCodesOfCustomer != null && analysisCodesOfCustomer.length > 0) {
                    analysisCodesOfCustomer[0] = this.mReminderStatus == ReminderStatus.DISPUTED_OPEN_ITEM ? analysisCodeEntries[0].getText() : "";
                }
                this.setAnalysisCodes(analysisCodesOfCustomer);
                OpenItemPersistencyManager.updateAnalyseCode0((OpenItem)this, (String)analysisCodesOfCustomer[0]);
            }
        }
    }

    public DunningGrade getDunningGrade() {
        this.requireLoaded();
        return this.mDunningGrade;
    }

    public void setDunningGrade(DunningGrade dunningGrade) {
        this.protocol("DunningGrade", (IPersistentObject)this.mDunningGrade, (IPersistentObject)dunningGrade);
        this.mDunningGrade = dunningGrade;
    }

    public Date getLastDunningDate() {
        this.requireLoaded();
        return this.mLastDunningDate;
    }

    public void setLastDunningDate(Date lastDunningDate) {
        this.protocol("lastdunningdate", this.mLastDunningDate, lastDunningDate);
        this.mLastDunningDate = lastDunningDate;
    }

    public void setDunningData(DunningGrade dunningGrade, Date lastDunningDate) throws BusinessDomainException {
        if (this.getDunningLetterSession() == null) {
            this.setLastDunningDate(lastDunningDate);
            this.setDunningGrade(dunningGrade);
        } else {
            if (PersistentObjectUtils.objectChanged((IPersistentObject)this.getDunningGrade(), (IPersistentObject)dunningGrade)) {
                throw OpenItemExceptionMapper.makeChangeNotAllowedBacauseDunningSessionDomainException();
            }
            if (lastDunningDate == null ? this.getLastDunningDate() != null : this.getLastDunningDate() == null || !DateHelper.equal((Date)this.getLastDunningDate(), (Date)lastDunningDate)) {
                throw OpenItemExceptionMapper.makeChangeNotAllowedBacauseDunningSessionDomainException();
            }
        }
    }

    public Date getFactoringESDate() {
        this.requireLoaded();
        return this.mFactoringESDate;
    }

    public void setFactoringESDate(Date factoringESDate) {
        this.protocol("factoringESDate", this.mFactoringESDate, factoringESDate);
        this.mFactoringESDate = factoringESDate;
    }

    public Date getAbsTransferDate() {
        this.requireLoaded();
        return this.mAbsTransferDate;
    }

    public void setAbsTransferDate(Date absTransferDate) {
        this.protocol("absTransferDate", this.mAbsTransferDate, absTransferDate);
        this.mAbsTransferDate = absTransferDate;
    }

    public String getOcrBData() {
        this.requireLoaded();
        return this.mOcrBData;
    }

    public void setOcrBData(String ocrBData) {
        this.protocol("ocrBData", this.mOcrBData, ocrBData);
        this.mOcrBData = ocrBData;
    }

    public EsrPayment getEsrPayment() {
        this.requireLoaded();
        return this.mEsrPayment;
    }

    public void setEsrPayment(EsrPayment esrPayment) {
        EsrPayment.protocol((PersistentObject)this, (EsrPayment)esrPayment, (EsrPayment)this.mEsrPayment);
        this.mEsrPayment = esrPayment;
    }

    public BankStatementData getBankStatementData() {
        this.requireLoaded();
        return this.mBankStatementData;
    }

    public void setBankStatementData(BankStatementData bankStatementData) {
        this.mBankStatementData = bankStatementData;
    }

    public DeliveryAddress getDeliveryAddress() {
        this.requireLoaded();
        return this.mDeliveryAddress;
    }

    public void setDeliveryAddress(DeliveryAddress deliveryAddress) {
        this.mDeliveryAddress = deliveryAddress;
    }

    public String getReferenceNumber() {
        this.requireLoaded();
        return this.mReferenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) throws BusinessDomainException {
        if (!this.isNew() && !StringMapper.equalWithTrim((String)this.getReferenceNumber(), (String)referenceNumber)) {
            this.checkIfProcessedForUpdate();
        }
        this.protocol("referencenumber", this.mReferenceNumber, referenceNumber);
        this.mReferenceNumber = referenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) throws BusinessDomainException {
        if (!this.isNew() && !StringMapper.equalWithTrim((String)this.getSequenceNumber(), (String)sequenceNumber) && this.getIsProcessingInRepostingPersonalAccount()) {
            throw TransactionExceptionMapper.makeAmendingNotAllowedBecauseOfRepostingSessionDomainException();
        }
        this.protocol("sequencenumber", this.mSequenceNumber, sequenceNumber);
        this.mSequenceNumber = sequenceNumber;
    }

    public String getSequenceNumber() {
        this.requireLoaded();
        return this.mSequenceNumber;
    }

    public String getProcessID() {
        this.requireLoaded();
        return this.mProcessID;
    }

    public void setProcessID(String processId) throws BusinessDomainException {
        if (this.getOpenItemType() == OpenItemType.DOWN_PAYMENT_REQUEST && StringMapper.isNullString((String)processId)) {
            throw OpenItemExceptionMapper.makeProcessidMissingDomainException();
        }
        if (!this.isNew() && !StringMapper.equalWithTrim((String)this.getProcessID(), (String)processId)) {
            if (this.getAssignedToFinalInvoice()) {
                throw OpenItemExceptionMapper.makeDownPaymentRequestHasBeenAssignedToFinalInvoiceUpdateDomainException();
            }
            if (this.getIsDownPaymentRequestAllocated()) {
                if (this.isDownPaymentRequest()) {
                    throw OpenItemExceptionMapper.makeChangeNotAllowedBacauseAllocatedDomainException();
                }
                throw OpenItemExceptionMapper.makeChangeNotAllowedBacauseOfDownPaymentRequestAllocationDomainException((String)"");
            }
        }
        this.protocol("processid", this.mProcessID, processId);
        this.mProcessID = processId;
    }

    public DocumentType getDocumentType() {
        this.requireLoaded();
        return this.mDocumentType;
    }

    public void setDocumentType(DocumentType documentType) {
        this.mDocumentType = documentType;
    }

    public Date getDocumentDate() {
        this.requireLoaded();
        return this.mDocumentDate;
    }

    public void setDocumentDate(Date documentDate) throws BusinessDomainException {
        this.setDocumentDate(documentDate, true);
    }

    public void setDocumentDate(Date documentDate, boolean setTransactionDate) throws BusinessDomainException {
        if (setTransactionDate && this.getOpenItemType() == OpenItemType.DOWN_PAYMENT_REQUEST) {
            if (documentDate == null) {
                throw OpenItemExceptionMapper.makeDocumentDateMissingDomainException();
            }
            FinancialYear fy = this.getPersonalAccount().getAccountingCompany().getFinancialYear(documentDate);
            if (fy == null) {
                throw OpenItemExceptionMapper.makeNoFinancialYearForDocumentDateDomainException();
            }
            this.setTransactionDate(documentDate);
            this.setFinancialYear(fy);
        }
        if (!this.isNew() && !DateHelper.equal((Date)this.getDocumentDate(), (Date)documentDate)) {
            this.checkIfProcessedForUpdate();
        }
        this.protocol("documentdate", this.mDocumentDate, documentDate);
        this.mDocumentDate = documentDate;
    }

    public ICurrency getEnteredCurrency() {
        this.requireLoaded();
        return this.mEnteredCurrency;
    }

    public void setEnteredCurrency(ICurrency currency) throws BusinessDomainException {
        if (!this.isNew() && !this.mEnteredCurrency.equals(currency)) {
            this.checkIfProcessedForUpdate();
        }
        this.protocol("enteredcurrency", (IPersistentObject)this.mEnteredCurrency, (IPersistentObject)currency);
        this.mEnteredCurrency = currency;
    }

    public ConversionRate getConversionRate() {
        this.requireLoaded();
        return this.mConversionRate;
    }

    public void setConversionRate(ConversionRate conversionRate) throws BusinessDomainException {
        if (conversionRate == null || BigDecimalMapper.isZeroOrNull((BigDecimal)conversionRate.getRate())) {
            throw OpenItemExceptionMapper.makeConversionRateMissingDomainException();
        }
        if (conversionRate.getRate().signum() < 0) {
            throw OpenItemExceptionMapper.makeConversionRateNegativeMissingDomainException();
        }
        if (!this.isNew() && !ConversionRateUtils.isEqual((ConversionRate)this.getConversionRate(), (ConversionRate)conversionRate)) {
            this.checkIfProcessedForUpdate();
        }
        this.mConversionRate = conversionRate;
    }

    public ConversionRate getNewConversionRate() {
        if (this.mNewConversionRate == null || !this.getHasNewConversionRate()) {
            return this.getConversionRate();
        }
        return this.mNewConversionRate;
    }

    public void setNewConversionRate(ConversionRate newConversionRate) {
        this.mNewConversionRate = newConversionRate;
    }

    public void setOpenItemType(OpenItemType openItemType, boolean isDebit) throws BusinessDomainException {
        this.setOpenItemType(openItemType);
        this.setIsDebit(isDebit);
    }

    public OpenItemType getOpenItemType() {
        this.requireLoaded();
        return this.mOpenItemType;
    }

    private void setOpenItemType(OpenItemType openItemType) throws BusinessDomainException {
        if (openItemType == null) {
            throw ExceptionMapper.makeApplicationException((String)"OpenItem.setOpenItemType: open item type is null");
        }
        if (!this.isNew() && openItemType != this.getOpenItemType()) {
            this.checkIfProcessedForUpdate();
        }
        this.protocol("openitemtype", PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)this.mOpenItemType), PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)openItemType));
        this.mOpenItemType = openItemType;
    }

    public boolean isCheque() {
        return this.getPersonalAccountEntry() != null && this.getPersonalAccountEntry().getTransaction().isChequeDepositTransaction();
    }

    private void checkAmount(BigDecimal amount) throws BusinessDomainException {
        if (amount != null && amount.signum() < 0) {
            throw TransactionExceptionMapper.makeAmountNegativeDomainException((String)StringMapper.toString((String)this.getReferenceNumber()));
        }
    }

    public void setOriginalAmount(BigDecimal originalAmount) throws BusinessDomainException {
        this.checkAmount(originalAmount);
        if (this.getOpenItemType() == OpenItemType.DOWN_PAYMENT_REQUEST && BigDecimalMapper.isZeroOrNull((BigDecimal)originalAmount)) {
            throw TransactionExceptionMapper.makeAmountZeroDomainException();
        }
        if (!this.isNew() && this.changedAmount(this.getOriginalAmount(), originalAmount)) {
            this.checkIfProcessedForUpdate();
        }
        this.protocol("originalamount", this.mOriginalAmount, originalAmount);
        this.mOriginalAmount = originalAmount;
    }

    public BigDecimal getOriginalAmount() {
        this.requireLoaded();
        return this.mOriginalAmount;
    }

    public BigDecimal getBaseOriginalAmount() {
        this.requireLoaded();
        return this.mBaseOriginalAmount;
    }

    public void setBaseOriginalAmount(BigDecimal baseOriginalAmount, OpenItemSecondaryCurrencyAmounts seccurrOriginalAmounts) throws BusinessDomainException {
        this.checkAmount(baseOriginalAmount);
        BigDecimal seccurr1OriginalAmount = null;
        BigDecimal seccurr2OriginalAmount = null;
        BigDecimal seccurr3OriginalAmount = null;
        BigDecimal seccurr4OriginalAmount = null;
        if (seccurrOriginalAmounts != null) {
            seccurr1OriginalAmount = seccurrOriginalAmounts.mSeccurr1Amount;
            this.checkAmount(seccurr1OriginalAmount);
            seccurr2OriginalAmount = seccurrOriginalAmounts.mSeccurr2Amount;
            this.checkAmount(seccurr2OriginalAmount);
            seccurr3OriginalAmount = seccurrOriginalAmounts.mSeccurr3Amount;
            this.checkAmount(seccurr3OriginalAmount);
            seccurr4OriginalAmount = seccurrOriginalAmounts.mSeccurr4Amount;
            this.checkAmount(seccurr4OriginalAmount);
        }
        if (this.getOpenItemType() == OpenItemType.DOWN_PAYMENT_REQUEST && BigDecimalMapper.isZeroOrNull((BigDecimal)baseOriginalAmount)) {
            throw TransactionExceptionMapper.makeAmountZeroDomainException();
        }
        if (!this.isNew() && (this.changedAmount(this.getBaseOriginalAmount(), baseOriginalAmount) || this.changedAmount(this.getSeccurr1OriginalAmount(), seccurr1OriginalAmount) || this.changedAmount(this.getSeccurr2OriginalAmount(), seccurr2OriginalAmount) || this.changedAmount(this.getSeccurr3OriginalAmount(), seccurr3OriginalAmount) || this.changedAmount(this.getSeccurr4OriginalAmount(), seccurr4OriginalAmount))) {
            this.checkIfProcessedForUpdate();
        }
        this.mBaseOriginalAmount = baseOriginalAmount;
        this.mSeccurr1OriginalAmount = seccurr1OriginalAmount;
        this.mSeccurr2OriginalAmount = seccurr2OriginalAmount;
        this.mSeccurr3OriginalAmount = seccurr3OriginalAmount;
        this.mSeccurr4OriginalAmount = seccurr4OriginalAmount;
    }

    public BigDecimal getOpenAmount() {
        this.requireLoaded();
        return this.mOpenAmount;
    }

    public void setOpenAmount(BigDecimal openAmount) throws BusinessDomainException {
        if (openAmount == null) {
            openAmount = BigDecimal.ZERO;
        }
        if (this.isRemainder()) {
            this.checkAmount(openAmount);
        }
        if (!this.isNew() && this.mOpenAmount != null && this.mOpenAmount.compareTo(openAmount) != 0 && this.getCurrencyRevaluationSession() != null && this.getCurrencyRevaluationSession().getAutomaticPosting()) {
            throw OpenItemExceptionMapper.makeChangeNotAllowedBecauseCurrencyRevaluationDomainException((String)(this.getCurrencyRevaluationSession().getCode() + "/" + StringMapper.toString((String)this.getReferenceNumber())));
        }
        this.protocol("openamount", this.mOpenAmount, openAmount);
        this.mOpenAmount = openAmount;
    }

    public BigDecimal getBaseOpenAmount() {
        this.requireLoaded();
        return this.mBaseOpenAmount;
    }

    public void setBaseOpenAmount(BigDecimal baseOpenAmount, OpenItemSecondaryCurrencyAmounts seccurrOpenAmounts) throws BusinessDomainException {
        this.setBaseOpenAmount(baseOpenAmount, seccurrOpenAmounts, true);
    }

    private void setBaseOpenAmount(BigDecimal baseOpenAmount, OpenItemSecondaryCurrencyAmounts seccurrOpenAmounts, boolean checkAmount) throws BusinessDomainException {
        if (baseOpenAmount == null) {
            baseOpenAmount = BigDecimal.ZERO;
        }
        BigDecimal seccurr1OpenAmount = null;
        BigDecimal seccurr2OpenAmount = null;
        BigDecimal seccurr3OpenAmount = null;
        BigDecimal seccurr4OpenAmount = null;
        if (seccurrOpenAmounts != null) {
            seccurr1OpenAmount = seccurrOpenAmounts.mSeccurr1Amount;
            seccurr2OpenAmount = seccurrOpenAmounts.mSeccurr2Amount;
            seccurr3OpenAmount = seccurrOpenAmounts.mSeccurr3Amount;
            seccurr4OpenAmount = seccurrOpenAmounts.mSeccurr4Amount;
        }
        if (checkAmount && this.isRemainder()) {
            this.checkAmount(baseOpenAmount);
            this.checkAmount(seccurr1OpenAmount);
            this.checkAmount(seccurr2OpenAmount);
            this.checkAmount(seccurr3OpenAmount);
            this.checkAmount(seccurr4OpenAmount);
        }
        this.mBaseOpenAmount = baseOpenAmount;
        this.mSeccurr1OpenAmount = seccurr1OpenAmount;
        this.mSeccurr2OpenAmount = seccurr2OpenAmount;
        this.mSeccurr3OpenAmount = seccurr3OpenAmount;
        this.mSeccurr4OpenAmount = seccurr4OpenAmount;
    }

    public void setSeccurrOpenAmounts(OpenItemSecondaryCurrencyAmounts seccurrOpenAmounts) {
        BigDecimal seccurr1OpenAmount = null;
        BigDecimal seccurr2OpenAmount = null;
        BigDecimal seccurr3OpenAmount = null;
        BigDecimal seccurr4OpenAmount = null;
        if (seccurrOpenAmounts != null) {
            seccurr1OpenAmount = seccurrOpenAmounts.mSeccurr1Amount;
            seccurr2OpenAmount = seccurrOpenAmounts.mSeccurr2Amount;
            seccurr3OpenAmount = seccurrOpenAmounts.mSeccurr3Amount;
            seccurr4OpenAmount = seccurrOpenAmounts.mSeccurr4Amount;
        }
        this.mSeccurr1OpenAmount = seccurr1OpenAmount;
        this.mSeccurr2OpenAmount = seccurr2OpenAmount;
        this.mSeccurr3OpenAmount = seccurr3OpenAmount;
        this.mSeccurr4OpenAmount = seccurr4OpenAmount;
    }

    public String getNote() {
        this.requireLoaded();
        return this.mNote;
    }

    public void setNote(String note) {
        this.protocol("note", this.mNote, note);
        this.mNote = note;
    }

    public int getInstalmentNumber() {
        this.requireLoaded();
        return this.mInstalmentNumber;
    }

    public void setInstalmentNumber(int instalmentNumber) {
        this.protocol("instalmentnumber", this.mInstalmentNumber, instalmentNumber);
        this.mInstalmentNumber = instalmentNumber;
    }

    public String[] getAnalysisCodes() {
        this.requireLoaded();
        return this.mAnalysisCodes;
    }

    public void setAnalysisCodes(String[] codes) throws BusinessDomainException {
        this.setAnalysisCodes(codes, false);
    }

    public void setAnalysisCodes(String[] codes, boolean usePreset) throws BusinessDomainException {
        this.setAnalysisCodes(codes, usePreset, true);
    }

    public void setAnalysisCodes(String[] codes, boolean usePreset, boolean withCheck) throws BusinessDomainException {
        this.mAnalysisCodes = this.getPersonalAccount().checkPersonalAccountOpenItemCodes(codes, withCheck, usePreset);
    }

    public boolean isAllocated() {
        this.requireLoaded();
        return this.mIsAllocated;
    }

    public void setIsAllocated(boolean isAllocated) {
        this.mIsAllocated = isAllocated;
    }

    public BankAccount getBankAccount() {
        this.requireLoaded();
        return this.mBankAccount;
    }

    public void setBankAccount(BankAccount bankAccount) {
        this.protocol("bankaccount", (IPersistentObject)this.mBankAccount, (IPersistentObject)bankAccount);
        this.mBankAccount = bankAccount;
    }

    public boolean isDownPayment() {
        this.requireLoaded();
        return this.mIsDownPayment;
    }

    public void setIsDownPayment(boolean isDownPayment) {
        this.protocol("isdownpayment", this.mIsDownPayment, isDownPayment);
        this.mIsDownPayment = isDownPayment;
    }

    public boolean isRemainder() {
        return this.getOpenItemType() == OpenItemType.REMAINDER_CREDITNOTE || this.getOpenItemType() == OpenItemType.REMAINDER_INVOICE;
    }

    public String getRemainderTaxCodeOID() {
        this.requireLoaded();
        return this.mRemainderTaxCodeOID;
    }

    public TaxCode getRemainderTaxCode() {
        this.requireLoaded();
        TaxCode taxCode = null;
        if (!StringMapper.isNullString((String)this.mRemainderTaxCodeOID)) {
            taxCode = TaxCodePersistencyManager.getTaxCode((String)this.mRemainderTaxCodeOID);
        }
        return taxCode;
    }

    public void setRemainderTaxCode(TaxCode remainderTaxCode) throws BusinessDomainException {
        if (!this.isNew()) {
            if (PersistentObjectUtils.objectChanged((IPersistentObject)this.getRemainderTaxCode(), (IPersistentObject)remainderTaxCode) && this.isAllocated()) {
                throw OpenItemExceptionMapper.makeChangeNotAllowedBacauseAllocatedDomainException();
            }
            this.protocol("remaindertaxcode", (IPersistentObject)this.getRemainderTaxCode(), (IPersistentObject)remainderTaxCode);
        }
        this.mRemainderTaxCodeOID = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)remainderTaxCode);
    }

    public BigDecimal getDownPaymentDiscountAmount() {
        this.requireLoaded();
        return this.mDownPaymentDiscountAmount;
    }

    public void setDownPaymentTaxCode(TaxCode taxCode) throws BusinessDomainException {
        this.setDownPaymentTaxCode(taxCode, true);
    }

    public void setDownPaymentTaxCode(TaxCode taxCode, boolean checkIfAllocated) throws BusinessDomainException {
        if (!this.isNew()) {
            if (PersistentObjectUtils.objectChanged((IPersistentObject)this.getDownPaymentTaxCode(), (IPersistentObject)taxCode)) {
                if (checkIfAllocated && this.isAllocated()) {
                    throw OpenItemExceptionMapper.makeChangeNotAllowedBacauseAllocatedDomainException();
                }
                if (this.getAssignedToFinalInvoice()) {
                    throw OpenItemExceptionMapper.makeDownPaymentRequestHasBeenAssignedToFinalInvoiceUpdateDomainException();
                }
            }
            this.protocol("downpaymenttaxcode", (IPersistentObject)this.getDownPaymentTaxCode(), (IPersistentObject)taxCode);
        }
        this.mDownPaymentTaxCodeOID = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)taxCode);
    }

    public TaxCode getDownPaymentTaxCode() {
        this.requireLoaded();
        TaxCode downPaymentTaxCode = null;
        if (!StringMapper.isNullString((String)this.mDownPaymentTaxCodeOID)) {
            downPaymentTaxCode = TaxCodePersistencyManager.getTaxCode((String)this.mDownPaymentTaxCodeOID);
        }
        return downPaymentTaxCode;
    }

    public String getDownPaymentTaxCodeOID() {
        this.requireLoaded();
        return this.mDownPaymentTaxCodeOID;
    }

    public void setDownPaymentDiscountAmount(BigDecimal amount) throws BusinessDomainException {
        this.checkAmount(amount);
        this.protocol("downpaymentdiscountamount", this.mDownPaymentDiscountAmount, amount);
        this.mDownPaymentDiscountAmount = amount;
    }

    public BigDecimal getDownPaymentBaseDiscountAmount() {
        this.requireLoaded();
        return this.mDownPaymentBaseDiscountAmount;
    }

    public void setDownPaymentBaseDiscountAmount(BigDecimal amount) throws BusinessDomainException {
        this.checkAmount(amount);
        this.protocol("downpaymentbasediscountamount", this.mDownPaymentBaseDiscountAmount, amount);
        this.mDownPaymentBaseDiscountAmount = amount;
    }

    public BigDecimal getDownPaymentBaseTaxAmount() {
        this.requireLoaded();
        return this.mDownPaymentBaseTaxAmount;
    }

    public void setDownPaymentBaseTaxAmount(BigDecimal amount) throws BusinessDomainException {
        this.checkAmount(amount);
        this.protocol("downpaymentbasetaxamount", this.mDownPaymentBaseTaxAmount, amount);
        this.mDownPaymentBaseTaxAmount = amount;
    }

    public BigDecimal getDownPaymentTaxAmount() {
        this.requireLoaded();
        return this.mDownPaymentTaxAmount;
    }

    public void setDownPaymentTaxAmount(BigDecimal amount) throws BusinessDomainException {
        this.checkAmount(amount);
        this.protocol("downpaymenttaxamount", this.mDownPaymentTaxAmount, amount);
        this.mDownPaymentTaxAmount = amount;
    }

    public BigDecimal getDownPaymentAmount() {
        this.requireLoaded();
        return this.mDownPaymentAmount;
    }

    public void setDownPaymentAmount(BigDecimal amount) throws BusinessDomainException {
        this.checkAmount(amount);
        if (!this.isDownPaymentRequest() && !this.isNew() && this.changedAmount(this.getDownPaymentAmount(), amount) && this.getIsDownPaymentRequestAllocated()) {
            throw OpenItemExceptionMapper.makeChangeNotAllowedBacauseOfDownPaymentRequestAllocationDomainException((String)"");
        }
        this.protocol("downpaymentamount", this.mDownPaymentAmount, amount);
        this.mDownPaymentAmount = amount;
    }

    public boolean isCancelled() {
        this.requireLoaded();
        return this.mIsCancelled;
    }

    public void setIsCancelled(boolean isCancelled) {
        this.mIsCancelled = isCancelled;
    }

    public boolean isCancellation() {
        this.requireLoaded();
        return this.mIsCancellation;
    }

    public void setIsCancellation(boolean isCancellation) {
        this.mIsCancellation = isCancellation;
    }

    public CustSupAddress getOneOffAccountAddress() {
        this.requireLoaded();
        return this.mOneOffAccountAddress;
    }

    public void setOneOffAccountAddress(CustSupAddress address) throws BusinessDomainException {
        if (!this.isNew() && PersistentObjectUtils.objectChanged((IPersistentObject)this.getOneOffAccountAddress(), (IPersistentObject)address)) {
            this.checkIfProcessedForUpdate();
        }
        this.protocol("oneoffaccountaddress", (IPersistentObject)this.mOneOffAccountAddress, (IPersistentObject)address);
        this.mOneOffAccountAddress = address;
    }

    public IPersonalAccountBankAddress getBankAddress() {
        this.requireLoaded();
        return this.mBankAddress;
    }

    public void setBankAddress(IPersonalAccountBankAddress bankAddress) throws BusinessDomainException {
        if (bankAddress != null && !bankAddress.getIsOneOffAddress() && bankAddress.getIsDefault() && ISoftware.getDoNotSetStandardBankAddressInOI()) {
            bankAddress = null;
        }
        if (this.getBankAddress() != null && this.mBankAddress.getIsOneOffAddress()) {
            if (bankAddress != null && bankAddress.getIsOneOffAddress() && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)this.mBankAddress, (IPersistentObject)bankAddress)) {
                throw ExceptionMapper.makeApplicationException((String)"OpenItem.setBankAddress: wrong one-off account bank address");
            }
            if (bankAddress == null || !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)bankAddress, (IPersistentObject)this.mBankAddress)) {
                this.mBankAddress.makeSaveable();
                this.mBankAddress.destroy();
            }
        }
        this.protocol("bankaddress", (IPersistentObject)this.mBankAddress, (IPersistentObject)bankAddress);
        this.mBankAddress = bankAddress;
    }

    public void setBankAddressFromMigration(IPersonalAccountBankAddress bankAddress) throws BusinessDomainException {
        if (this.getBankAddress() != null && this.mBankAddress.getIsOneOffAddress() && (bankAddress == null || !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)bankAddress, (IPersistentObject)this.mBankAddress))) {
            this.mBankAddress.makeSaveable();
            this.mBankAddress.destroy();
        }
        this.protocol("bankaddress", (IPersistentObject)this.mBankAddress, (IPersistentObject)bankAddress);
        this.mBankAddress = bankAddress;
    }

    public ITermOfPayment getTermOfPayment() {
        this.requireLoaded();
        return this.mTermOfPayment;
    }

    public void setTermOfPayment(ITermOfPayment termOfPayment) throws BusinessDomainException {
        if (this.isPaymentReceipt()) {
            termOfPayment = null;
        }
        if (termOfPayment != null && termOfPayment.getStop()) {
            throw TransactionExceptionMapper.makeTermsOfPaymentBlockedDomainException((String)termOfPayment.getCode());
        }
        this.protocol("termofpayment", (IPersistentObject)this.mTermOfPayment, (IPersistentObject)termOfPayment);
        this.mTermOfPayment = termOfPayment;
    }

    public OpenItemCurrentStatus getCurrentStatus() {
        this.requireLoaded();
        return this.mCurrentStatus;
    }

    public void setCurrentStatus(OpenItemCurrentStatus newStatus) {
        if (this.getCurrentStatus() != null && newStatus == null) {
            OpenItemStatusAllocationPersistencyManager.delete((OpenItem)this);
        }
        this.mCurrentStatus = newStatus;
    }

    public ICurrency getBaseCurrency() {
        return this.getPersonalAccount().getAccountingCompany().getFinanceSetup().getBaseCurrency();
    }

    public boolean isDownPaymentRequest() {
        return this.getOpenItemType() == OpenItemType.DOWN_PAYMENT_REQUEST;
    }

    public void adjustDiscount() throws BusinessDomainException {
        new OpenItemDiscountCalculator((IOpenItem)this).setDiscount();
    }

    public BigDecimal getDiscountableAmount() {
        this.requireLoaded();
        return this.mDiscountableAmount;
    }

    public void setDiscountableAmount(BigDecimal discountableAmount) throws BusinessDomainException {
        this.checkAmount(discountableAmount);
        if (this.isPaymentReceipt()) {
            discountableAmount = null;
        }
        if (!this.isNew() && this.changedAmount(discountableAmount, this.getDiscountableAmount())) {
            this.checkDiscounForUpdate();
        }
        this.protocol("discountableamount", this.mDiscountableAmount, discountableAmount);
        this.mDiscountableAmount = discountableAmount;
    }

    public BigDecimal getDiscountableBaseAmount() {
        this.requireLoaded();
        return this.mDiscountableBaseAmount;
    }

    public void setDiscountableBaseAmount(BigDecimal discountableBaseAmount) throws BusinessDomainException {
        this.checkAmount(discountableBaseAmount);
        if (this.isPaymentReceipt()) {
            discountableBaseAmount = null;
        }
        if (!this.isNew() && this.changedAmount(discountableBaseAmount, this.getDiscountableBaseAmount())) {
            this.checkDiscounForUpdate();
        }
        this.protocol("discountablebaseamount", this.mDiscountableBaseAmount, discountableBaseAmount);
        this.mDiscountableBaseAmount = discountableBaseAmount;
    }

    public IOpenItemDiscount[] getDiscounts() {
        ArrayList<IOpenItemDiscount> discounts = new ArrayList<IOpenItemDiscount>();
        if (this.getDiscount1() != null) {
            discounts.add(this.getDiscount1());
        }
        if (this.getDiscount2() != null) {
            discounts.add(this.getDiscount2());
        }
        if (this.getDiscount3() != null) {
            discounts.add(this.getDiscount3());
        }
        return discounts.toArray(new IOpenItemDiscount[0]);
    }

    public IOpenItemDiscount getDiscount1() {
        this.requireLoaded();
        return this.mDiscount1;
    }

    public void setDiscount1(IOpenItemDiscount discount1) throws BusinessDomainException {
        if (this.isPaymentReceipt()) {
            discount1 = null;
        }
        if (!this.isNew() && this.changedDiscount(discount1, this.getDiscount1())) {
            this.checkDiscounForUpdate();
        }
        this.mDiscount1 = discount1;
    }

    public IOpenItemDiscount getDiscount2() {
        this.requireLoaded();
        return this.mDiscount2;
    }

    public void setDiscount2(IOpenItemDiscount discount2) throws BusinessDomainException {
        if (this.isPaymentReceipt()) {
            discount2 = null;
        }
        if (!this.isNew() && this.changedDiscount(discount2, this.getDiscount2())) {
            this.checkDiscounForUpdate();
        }
        this.mDiscount2 = discount2;
    }

    public IOpenItemDiscount getDiscount3() {
        this.requireLoaded();
        return this.mDiscount3;
    }

    public void setDiscount3(IOpenItemDiscount discount3) throws BusinessDomainException {
        if (this.isPaymentReceipt()) {
            discount3 = null;
        }
        if (!this.isNew() && this.changedDiscount(discount3, this.getDiscount3())) {
            this.checkDiscounForUpdate();
        }
        this.mDiscount3 = discount3;
    }

    public Date getValueDate() {
        this.requireLoaded();
        return this.mValueDate;
    }

    public void setValueDate(Date valueDate) throws BusinessDomainException {
        if (this.mOpenItemType == OpenItemType.DOWN_PAYMENT_REQUEST && valueDate == null) {
            throw OpenItemExceptionMapper.makeValueDateMissingDomainException();
        }
        if (!this.isNew() && !DateHelper.equal((Date)valueDate, (Date)this.getValueDate())) {
            this.checkDiscounForUpdate();
        }
        this.protocol("valuedate", this.mValueDate, valueDate);
        this.mValueDate = valueDate;
    }

    public Date getCompletedAllocationDate() {
        this.requireLoaded();
        return this.mCompletedAllocationDate;
    }

    public void setCompletedAllocationDate(AllocationDate completedAllocationDate) {
        this.mCompletedAllocationDate = completedAllocationDate != null ? completedAllocationDate.getAllocationDate() : null;
        this.mCompletedAllocationYear = completedAllocationDate != null ? completedAllocationDate.getFinancialYear() : null;
    }

    public FinancialYear getCompletedAllocationYear() {
        this.requireLoaded();
        return this.mCompletedAllocationYear;
    }

    public String getAllocationNumber() {
        this.requireLoaded();
        return this.mAllocationNumber;
    }

    public void setAllocationNumber(String allocationNumber) {
        this.protocol("allocationnumber", this.mAllocationNumber, allocationNumber);
        this.mAllocationNumber = allocationNumber;
    }

    public Date getDueDate() {
        this.requireLoaded();
        return this.mDueDate;
    }

    public void setDueDate(Date dueDate) throws BusinessDomainException {
        if (this.isPaymentReceipt()) {
            dueDate = null;
        }
        if (this.mOpenItemType == OpenItemType.DOWN_PAYMENT_REQUEST && dueDate == null) {
            throw OpenItemExceptionMapper.makeDueDateMissingDomainException();
        }
        if (!this.isNew() && !DateHelper.equal((Date)dueDate, (Date)this.getDueDate())) {
            if (this.getGeneratePaymentSession() != null) {
                throw OpenItemExceptionMapper.makeChangeNotAllowedBacausePaymentSessionDomainException();
            }
            if (this.getIsProcessingInRepostingPersonalAccount()) {
                throw TransactionExceptionMapper.makeAmendingNotAllowedBecauseOfRepostingSessionDomainException();
            }
        }
        this.protocol("duedate", this.mDueDate, dueDate);
        this.mDueDate = dueDate;
    }

    public boolean isUnfinished() {
        this.requireLoaded();
        return this.mIsUnfinished;
    }

    public void setIsUnfinished(boolean unfinished) throws BusinessDomainException {
        if (!this.isNew() && this.isUnfinished() != unfinished) {
            this.checkIfProcessedForUpdate();
        }
        this.protocol("isunfinished", this.mIsUnfinished, unfinished);
        this.mIsUnfinished = unfinished;
    }

    public ModeOfPayment getPaymentType() {
        this.requireLoaded();
        if (this.mPaymentType == null) {
            this.mPaymentType = ModeOfPayment.UNKNOWN;
        }
        return this.mPaymentType;
    }

    public void setPaymentType(ModeOfPayment paymentType) {
        this.protocol("paymentType", PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)this.mPaymentType), PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)paymentType));
        this.mPaymentType = paymentType;
    }

    public Date getWithholdDirectDebitOrPaymentToDate() {
        this.requireLoaded();
        return this.mWithholdDirectDebitOrPaymentToDate;
    }

    public void setWithholdDirectDebitOrPaymentToDate(Date withholdToDate) {
        this.protocol("withholddirectdebitorpaymenttodate", this.mWithholdDirectDebitOrPaymentToDate, withholdToDate);
        this.mWithholdDirectDebitOrPaymentToDate = withholdToDate;
    }

    public Date getWithholdReminderToDate() {
        this.requireLoaded();
        return this.mWithholdReminderToDate;
    }

    public void setWithholdReminderToDate(Date withholdReminderToDate) {
        this.protocol("withholdremindertodate", this.mWithholdReminderToDate, withholdReminderToDate);
        this.mWithholdReminderToDate = withholdReminderToDate;
    }

    public String getDirectDebitOrPaymentDetails() {
        this.requireLoaded();
        return this.mDirectDebitOrPaymentDetails;
    }

    public void setDirectDebitOrPaymentDetails(String details) {
        this.protocol("directdebitorpaymentdetails", this.mDirectDebitOrPaymentDetails, details);
        this.mDirectDebitOrPaymentDetails = details;
    }

    public boolean getForcedPayment() {
        this.requireLoaded();
        return this.mForcedPayment;
    }

    public void setForcedPayment(boolean forcedPayment) {
        this.protocol("forcedpayment", this.mForcedPayment, forcedPayment);
        this.mForcedPayment = forcedPayment;
    }

    public String getImportApplication() {
        this.requireLoaded();
        return this.mImportApplication;
    }

    public void setImportApplication(String importApplication) {
        this.protocol("importapplication", this.mImportApplication, importApplication);
        this.mImportApplication = importApplication;
    }

    public boolean getFactoring() {
        this.requireLoaded();
        return this.mFactoring;
    }

    public void setFactoring(boolean factoring) {
        this.protocol("factoring", this.mFactoring, factoring);
        this.mFactoring = factoring;
    }

    public String getFactoringNote() {
        this.requireLoaded();
        return this.mFactoringNote;
    }

    public void setFactoringNote(String factoringNote) {
        this.protocol("factoringnote", this.mFactoringNote, factoringNote);
        this.mFactoringNote = factoringNote;
    }

    public int getOverdueDays(Date date) {
        return OpenItemHelper.calculateOverdueDays((Date)date, (Date)this.getDueDate());
    }

    public int getOverdueDaysForReminderReport(Date date, Date dueDate) {
        return OpenItemHelper.calculateOverdueDays((Date)date, (Date)dueDate);
    }

    public boolean isInterestOpenItem() {
        this.requireLoaded();
        return this.mIsInterestOpenItem;
    }

    public void setIsInterestOpenItem(boolean interest) {
        if (this.isNew()) {
            this.mIsInterestOpenItem = interest;
        }
    }

    public void setCostCentreBase(CostCentreBase costCentreBase) {
        this.protocol("costCentreBase", (IPersistentObject)this.mCostCentreBase, (IPersistentObject)costCentreBase);
        this.mCostCentreBase = costCentreBase;
    }

    public CostCentreBase getCostCentreBase() {
        this.requireLoaded();
        return this.mCostCentreBase;
    }

    public TaxRate getFixedTaxRate() {
        this.requireLoaded();
        if (this.getTaxRate() != null && this.getTaxRate2() == null) {
            return this.getTaxRate();
        }
        return null;
    }

    public void setTaxRate(TaxRate taxRate) {
        this.protocol("taxrate", (IPersistentObject)this.getTaxRate(), (IPersistentObject)taxRate);
        this.mTaxRateOID = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)taxRate);
    }

    public String getTaxRateOID() {
        this.requireLoaded();
        return this.mTaxRateOID;
    }

    public TaxRate getTaxRate() {
        this.requireLoaded();
        TaxRate taxRate = null;
        if (!StringMapper.isNullString((String)this.mTaxRateOID)) {
            taxRate = TaxRatePersistencyManager.getTaxRate((String)this.mTaxRateOID);
        }
        return taxRate;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.protocol("taxamount", this.mTaxAmount, taxAmount);
        this.mTaxAmount = taxAmount;
    }

    public BigDecimal getTaxAmount() {
        this.requireLoaded();
        return this.mTaxAmount;
    }

    public void setNetAmount(BigDecimal netAmount) {
        this.protocol("netamount", this.mNetAmount, netAmount);
        this.mNetAmount = netAmount;
    }

    public BigDecimal getNetAmount() {
        this.requireLoaded();
        return this.mNetAmount;
    }

    public BigDecimal getNetAmountTotal() {
        this.requireLoaded();
        return BigDecimalMapper.toBigDecimal((BigDecimal)this.mNetAmount).add(BigDecimalMapper.toBigDecimal((BigDecimal)this.mNetAmount2)).add(BigDecimalMapper.toBigDecimal((BigDecimal)this.mNetAmount3)).add(BigDecimalMapper.toBigDecimal((BigDecimal)this.mNetAmount4)).add(BigDecimalMapper.toBigDecimal((BigDecimal)this.mNetAmount5));
    }

    public void setBaseTaxAmount(BigDecimal taxAmount) {
        this.protocol("basetaxamount", this.mBaseTaxAmount, taxAmount);
        this.mBaseTaxAmount = taxAmount;
    }

    public BigDecimal getOpenBaseNetAmount(BigDecimal openBaseAmount) {
        BigDecimal altTotalAmount;
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)openBaseAmount) || this.mTransactionType == TransactionType.CASH_TRANSACTION) {
            return BigDecimal.ZERO;
        }
        boolean isNegative = openBaseAmount.signum() < 0;
        BigDecimal netAmount = this.getNetAmountTotal();
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)netAmount)) {
            netAmount = openBaseAmount;
        }
        if (this.mIsDownPaymentFinalInvoice && (altTotalAmount = BigDecimalMapper.toBigDecimal((BigDecimal)this.mNetAmount).add(BigDecimalMapper.toBigDecimal((BigDecimal)this.mTaxAmount))).abs().compareTo(this.getOriginalAmount().abs()) > 0) {
            netAmount = this.getOriginalAmount().multiply(this.mNetAmount).divide(altTotalAmount, 2, RoundingMode.HALF_DOWN);
        }
        if (openBaseAmount.compareTo(this.getOriginalAmount()) == 0) {
            return netAmount;
        }
        BigDecimal result = netAmount.multiply(openBaseAmount).divide(this.getBaseOriginalAmount(), RoundingMode.HALF_DOWN).setScale(2, RoundingMode.HALF_DOWN);
        if (isNegative && result.signum() > 0 || !isNegative && result.signum() < 0) {
            result = result.negate();
        }
        return result;
    }

    public BigDecimal getBaseTaxAmount() {
        this.requireLoaded();
        return this.mBaseTaxAmount;
    }

    public boolean getIsDiscountable1() {
        this.requireLoaded();
        return this.mIsDiscountable1;
    }

    public void setIsDiscountable1(boolean isDiscountable) {
        this.mIsDiscountable1 = isDiscountable;
    }

    public void setTaxRate2(TaxRate taxRate) {
        this.protocol("taxrate2", (IPersistentObject)this.getTaxRate2(), (IPersistentObject)taxRate);
        this.mTaxRate2OID = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)taxRate);
    }

    public String getTaxRate2OID() {
        this.requireLoaded();
        return this.mTaxRate2OID;
    }

    public TaxRate getTaxRate2() {
        this.requireLoaded();
        TaxRate taxRate = null;
        if (!StringMapper.isNullString((String)this.mTaxRate2OID)) {
            taxRate = TaxRatePersistencyManager.getTaxRate((String)this.mTaxRate2OID);
        }
        return taxRate;
    }

    public void setTaxAmount2(BigDecimal taxAmount) {
        this.protocol("taxamount2", this.mTaxAmount2, taxAmount);
        this.mTaxAmount2 = taxAmount;
    }

    public BigDecimal getTaxAmount2() {
        this.requireLoaded();
        return this.mTaxAmount2;
    }

    public void setNetAmount2(BigDecimal netAmount) {
        this.protocol("netamount2", this.mNetAmount2, netAmount);
        this.mNetAmount2 = netAmount;
    }

    public BigDecimal getNetAmount2() {
        this.requireLoaded();
        return this.mNetAmount2;
    }

    public boolean getIsDiscountable2() {
        this.requireLoaded();
        return this.mIsDiscountable2;
    }

    public void setIsDiscountable2(boolean isDiscountable) {
        this.mIsDiscountable2 = isDiscountable;
    }

    public void setTaxRate3(TaxRate taxRate) {
        this.protocol("taxrate3", (IPersistentObject)this.getTaxRate3(), (IPersistentObject)taxRate);
        this.mTaxRate3OID = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)taxRate);
    }

    public String getTaxRate3OID() {
        this.requireLoaded();
        return this.mTaxRate3OID;
    }

    public TaxRate getTaxRate3() {
        this.requireLoaded();
        TaxRate taxRate = null;
        if (!StringMapper.isNullString((String)this.mTaxRate3OID)) {
            taxRate = TaxRatePersistencyManager.getTaxRate((String)this.mTaxRate3OID);
        }
        return taxRate;
    }

    public void setTaxAmount3(BigDecimal taxAmount) {
        this.protocol("taxamount3", this.mTaxAmount3, taxAmount);
        this.mTaxAmount3 = taxAmount;
    }

    public BigDecimal getTaxAmount3() {
        this.requireLoaded();
        return this.mTaxAmount3;
    }

    public void setNetAmount3(BigDecimal netAmount) {
        this.protocol("netamount3", this.mNetAmount3, netAmount);
        this.mNetAmount3 = netAmount;
    }

    public BigDecimal getNetAmount3() {
        this.requireLoaded();
        return this.mNetAmount3;
    }

    public boolean getIsDiscountable3() {
        this.requireLoaded();
        return this.mIsDiscountable3;
    }

    public void setIsDiscountable3(boolean isDiscountable) {
        this.mIsDiscountable3 = isDiscountable;
    }

    public void setTaxRate4(TaxRate taxRate) {
        this.protocol("taxrate4", (IPersistentObject)this.getTaxRate4(), (IPersistentObject)taxRate);
        this.mTaxRate4OID = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)taxRate);
    }

    public String getTaxRate4OID() {
        this.requireLoaded();
        return this.mTaxRate4OID;
    }

    public TaxRate getTaxRate4() {
        this.requireLoaded();
        TaxRate taxRate = null;
        if (!StringMapper.isNullString((String)this.mTaxRate4OID)) {
            taxRate = TaxRatePersistencyManager.getTaxRate((String)this.mTaxRate4OID);
        }
        return taxRate;
    }

    public void setTaxAmount4(BigDecimal taxAmount) {
        this.protocol("taxamount4", this.mTaxAmount4, taxAmount);
        this.mTaxAmount4 = taxAmount;
    }

    public BigDecimal getTaxAmount4() {
        this.requireLoaded();
        return this.mTaxAmount4;
    }

    public void setNetAmount4(BigDecimal netAmount) {
        this.protocol("netamount4", this.mNetAmount4, netAmount);
        this.mNetAmount4 = netAmount;
    }

    public BigDecimal getNetAmount4() {
        this.requireLoaded();
        return this.mNetAmount4;
    }

    public boolean getIsDiscountable4() {
        this.requireLoaded();
        return this.mIsDiscountable4;
    }

    public void setIsDiscountable4(boolean isDiscountable) {
        this.mIsDiscountable4 = isDiscountable;
    }

    public void setTaxRate5(TaxRate taxRate) {
        this.protocol("taxrate5", (IPersistentObject)this.getTaxRate5(), (IPersistentObject)taxRate);
        this.mTaxRate5OID = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)taxRate);
    }

    public String getTaxRate5OID() {
        this.requireLoaded();
        return this.mTaxRate5OID;
    }

    public TaxRate getTaxRate5() {
        this.requireLoaded();
        TaxRate taxRate = null;
        if (!StringMapper.isNullString((String)this.mTaxRate5OID)) {
            taxRate = TaxRatePersistencyManager.getTaxRate((String)this.mTaxRate5OID);
        }
        return taxRate;
    }

    public void setTaxAmount5(BigDecimal taxAmount) {
        this.protocol("taxamount5", this.mTaxAmount5, taxAmount);
        this.mTaxAmount5 = taxAmount;
    }

    public BigDecimal getTaxAmount5() {
        this.requireLoaded();
        return this.mTaxAmount5;
    }

    public void setNetAmount5(BigDecimal netAmount) {
        this.protocol("netamount5", this.mNetAmount5, netAmount);
        this.mNetAmount5 = netAmount;
    }

    public BigDecimal getNetAmount5() {
        this.requireLoaded();
        return this.mNetAmount5;
    }

    public boolean getIsDiscountable5() {
        this.requireLoaded();
        return this.mIsDiscountable5;
    }

    public void setIsDiscountable5(boolean isDiscountable) {
        this.mIsDiscountable5 = isDiscountable;
    }

    public DocumentCategoryType getDocumentCategory() {
        this.requireLoaded();
        return this.mDocumentCategory;
    }

    public void setDocumentCategory(DocumentCategoryType documentCategory) {
        this.mDocumentCategory = documentCategory;
    }

    public TransactionType getTransactionType() {
        this.requireLoaded();
        return this.mTransactionType;
    }

    public void setTransactionType(TransactionType transactionType) {
        this.mTransactionType = transactionType;
    }

    public boolean isPaymentReceipt() {
        return OpenItemHelper.isPaymentReceipt((OpenItemType)this.getOpenItemType());
    }

    public DiscountType getDiscountType() {
        this.requireLoaded();
        if (this.mDiscountType == null && this.getPersonalAccountEntry() != null && this.getPersonalAccountEntry().getTransaction().isInvoiceTransaction()) {
            this.mDiscountType = ((InvoiceTransaction)this.getPersonalAccountEntry().getTransaction()).getDiscountType();
        }
        if (this.mDiscountType == null) {
            this.mDiscountType = DiscountType.NO_DISCOUNT;
        }
        return this.mDiscountType;
    }

    public void setDiscountType(DiscountType discountType) {
        this.mDiscountType = discountType;
    }

    public void removePlaceholderAllocationAmount(AllocationAmount placeholder) {
        if (placeholder.getOpenItemAllocation().getAllocationType() != InvoiceAllocationType.PLACEHOLDER) {
            throw ExceptionMapper.makeApplicationException((String)"This is no placeholder allocation");
        }
        ArrayList<AllocationAmount> remaining = new ArrayList<AllocationAmount>();
        for (int i = 0; i < this.getAllocationAmounts().length; ++i) {
            if (PersistentObjectUtils.haveEqualObjectids((IPersistentObject)this.getAllocationAmounts()[i], (IPersistentObject)placeholder)) continue;
            remaining.add(this.getAllocationAmounts()[i]);
        }
        if (remaining.size() == this.getAllocationAmounts().length) {
            return;
        }
        AllocationAmount[] newArray = new AllocationAmount[remaining.size()];
        this.mAllocationAmounts = remaining.toArray(newArray);
    }

    public void addPlaceholderAllocationAmount(AllocationAmount placeholder) {
        if (placeholder.getOpenItemAllocation().getAllocationType() != InvoiceAllocationType.PLACEHOLDER) {
            throw ExceptionMapper.makeApplicationException((String)"This is no placeholder allocation");
        }
        AllocationAmount[] newArray = new AllocationAmount[this.getAllocationAmounts().length + 1];
        for (int i = 0; i < this.getAllocationAmounts().length; ++i) {
            newArray[i] = this.getAllocationAmounts()[i];
        }
        newArray[newArray.length - 1] = placeholder;
        this.mAllocationAmounts = newArray;
    }

    private void adjustCurrentStatus(AllocationAmount allocationAmount, boolean isRemoveCase) throws BusinessDomainException {
        if (this.getCurrentStatus() != null && !OpenItemStatusHelper.isBillOfExchangeStatus((OpenItemStatusType)this.getCurrentStatus().getStatusType())) {
            boolean isCurrent;
            if (allocationAmount.isNew()) {
                this.mCurrentStatus.addCurrentOpenItemAllocation(allocationAmount.getOpenItemAllocation());
            }
            if (!(isCurrent = allocationAmount.isNew())) {
                isCurrent = this.mCurrentStatus.isCurrentOpenItemAllocation(allocationAmount.getOpenItemAllocation());
            }
            if (isCurrent) {
                BigDecimal newBaseTotal;
                if (isRemoveCase) {
                    newBaseTotal = BigDecimalMapper.ZERO;
                    this.mCurrentStatus.removeCurrentOpenItemAllocation(allocationAmount.getOpenItemAllocation());
                } else {
                    newBaseTotal = allocationAmount.getBaseTotalAmount();
                }
                BigDecimal baseSettlement = newBaseTotal.subtract(allocationAmount.getBaseTotal_old());
                boolean backTransfer = true;
                BigDecimal newTransferredAmount = null;
                BigDecimal transferAmount = null;
                boolean adjust = true;
                if (baseSettlement.signum() == 0) {
                    adjust = false;
                } else if (baseSettlement.signum() == 1) {
                    transferAmount = baseSettlement.compareTo(this.getCurrentStatus().getTransferredAmount()) > 0 ? this.getCurrentStatus().getTransferredAmount() : baseSettlement;
                    newTransferredAmount = this.getCurrentStatus().getTransferredAmount().subtract(transferAmount);
                } else {
                    transferAmount = (baseSettlement = baseSettlement.abs()).compareTo(this.getCurrentStatus().getPaymentSettlement()) >= 0 ? this.getCurrentStatus().getPaymentSettlement() : baseSettlement;
                    newTransferredAmount = this.getCurrentStatus().getTransferredAmount().add(transferAmount);
                    backTransfer = false;
                }
                if (adjust) {
                    OpenItemStatusType openItemStatusType;
                    boolean executeTransfer = false;
                    if (newTransferredAmount.signum() == 0) {
                        if (this.mCurrentStatus.getStatusType() == OpenItemStatusType.COMPLETELY_SETTLED) {
                            openItemStatusType = this.mCurrentStatus.getStatusType();
                        } else {
                            openItemStatusType = OpenItemStatusType.COMPLETELY_SETTLED;
                            executeTransfer = true;
                        }
                    } else if (newTransferredAmount.compareTo(this.mCurrentStatus.getPaymentSettlement()) == 0) {
                        openItemStatusType = this.mCurrentStatus.getLastPaymentStatusType();
                        if (!isRemoveCase) {
                            this.mCurrentStatus.removeCurrentOpenItemAllocation(allocationAmount.getOpenItemAllocation());
                        }
                        executeTransfer = true;
                    } else {
                        openItemStatusType = this.mCurrentStatus.getStatusType() == OpenItemStatusType.PARTIALLY_SETTLED || this.mCurrentStatus.getStatusType() == OpenItemStatusType.OUTSTANDING_AMOUNT_UNCLEAR ? this.mCurrentStatus.getStatusType() : OpenItemStatusType.PARTIALLY_SETTLED;
                        executeTransfer = true;
                    }
                    if (executeTransfer && this.checkForOpenAmountTransfer()) {
                        OpenAmountTransferManager manager = new OpenAmountTransferManager(this);
                        manager.transfer(allocationAmount.getOpenItemAllocation(), transferAmount, backTransfer);
                    }
                    this.mCurrentStatus.setStatusType(openItemStatusType);
                    this.mCurrentStatus.setTransferredAmount(newTransferredAmount);
                }
            }
        }
    }

    public void addToOpenItem(AllocationAmount allocAmount) throws BusinessDomainException {
        this.makeSaveable();
        OpenItemSecondaryCurrencyAmounts seccurrOpenAmounts = null;
        if (allocAmount.getOpenItemAllocation().getFinanceSetup().hasParallelCurrencies()) {
            seccurrOpenAmounts = OpenItemSecondaryCurrencyAmounts.makeOpenItemSecondaryCurrencyAmounts((BigDecimal)BigDecimalMapper.subtract((BigDecimal)this.getSeccurr1OpenAmount(), (BigDecimal)allocAmount.getSeccurr1TotalAmount()), (BigDecimal)BigDecimalMapper.subtract((BigDecimal)this.getSeccurr2OpenAmount(), (BigDecimal)allocAmount.getSeccurr2TotalAmount()), (BigDecimal)BigDecimalMapper.subtract((BigDecimal)this.getSeccurr3OpenAmount(), (BigDecimal)allocAmount.getSeccurr3TotalAmount()), (BigDecimal)BigDecimalMapper.subtract((BigDecimal)this.getSeccurr4OpenAmount(), (BigDecimal)allocAmount.getSeccurr4TotalAmount()), (IFinanceSetup)allocAmount.getOpenItemAllocation().getFinanceSetup());
        }
        if (allocAmount.getOpenItemAllocation().isCurrencyRevaluation()) {
            this.setBaseOpenAmount(this.getBaseOpenAmount().subtract(allocAmount.getBaseTotalAmount()), seccurrOpenAmounts, false);
            this.mIsAllocated = true;
            this.mUpdateByOpenItemAllocation = true;
            return;
        }
        BigDecimal newOpenAmount = this.getOpenAmount().subtract(allocAmount.getForeignTotalAmount());
        BigDecimal newBaseOpenAmount = this.getBaseOpenAmount().subtract(allocAmount.getBaseTotalAmount());
        this.setOpenAmount(newOpenAmount);
        this.setBaseOpenAmount(newBaseOpenAmount, seccurrOpenAmounts);
        this.adjustCurrentStatus(allocAmount, false);
        this.adjustIsAllocated(allocAmount.getOpenItemAllocation().isReversalPayment(), false);
        if (this.getBaseOpenAmount().signum() == 0) {
            this.getAllocationAmounts();
            this.updateCompletedAndEffectiveDates(allocAmount, false);
        } else {
            this.clearCompletedAndEffectiveDates();
        }
        for (int i = 0; i < this.getAllocationAmounts().length; ++i) {
            if (!PersistentObjectUtils.haveEqualObjectids((IPersistentObject)this.getAllocationAmounts()[i], (IPersistentObject)allocAmount)) continue;
            this.adjustAllocationNumber(true);
            return;
        }
        AllocationAmount[] newArray = new AllocationAmount[this.getAllocationAmounts().length + 1];
        for (int i = 0; i < this.getAllocationAmounts().length; ++i) {
            newArray[i] = this.getAllocationAmounts()[i];
        }
        newArray[newArray.length - 1] = allocAmount;
        this.mAllocationAmounts = newArray;
        this.mUpdateByOpenItemAllocation = true;
        this.adjustAllocationNumber(true);
    }

    public void addToOpenAmount(AllocationAmount allocAmount) {
        this.requireLoaded();
        this.mOpenAmount = this.mOpenAmount.add(allocAmount.getForeignTotalAmount());
        this.mBaseOpenAmount = this.mBaseOpenAmount.add(allocAmount.getBaseTotalAmount());
        if (allocAmount.getOpenItemAllocation().getFinanceSetup().hasParallelCurrencies()) {
            OpenItemSecondaryCurrencyAmounts seccurrOpenAmounts = OpenItemSecondaryCurrencyAmounts.makeOpenItemSecondaryCurrencyAmounts((BigDecimal)BigDecimalMapper.add((BigDecimal)this.mSeccurr1OpenAmount, (BigDecimal)allocAmount.getSeccurr1TotalAmount()), (BigDecimal)BigDecimalMapper.add((BigDecimal)this.mSeccurr2OpenAmount, (BigDecimal)allocAmount.getSeccurr2TotalAmount()), (BigDecimal)BigDecimalMapper.add((BigDecimal)this.mSeccurr3OpenAmount, (BigDecimal)allocAmount.getSeccurr3TotalAmount()), (BigDecimal)BigDecimalMapper.add((BigDecimal)this.mSeccurr4OpenAmount, (BigDecimal)allocAmount.getSeccurr4TotalAmount()), (IFinanceSetup)allocAmount.getOpenItemAllocation().getFinanceSetup());
            this.mSeccurr1OpenAmount = seccurrOpenAmounts.mSeccurr1Amount;
            this.mSeccurr2OpenAmount = seccurrOpenAmounts.mSeccurr2Amount;
            this.mSeccurr3OpenAmount = seccurrOpenAmounts.mSeccurr3Amount;
            this.mSeccurr4OpenAmount = seccurrOpenAmounts.mSeccurr4Amount;
        }
    }

    public void removeFromOpenItem(AllocationAmount allocAmount) throws BusinessDomainException {
        this.makeSaveable();
        OpenItemSecondaryCurrencyAmounts seccurrOpenAmounts = null;
        if (allocAmount.getOpenItemAllocation().getFinanceSetup().hasParallelCurrencies()) {
            seccurrOpenAmounts = OpenItemSecondaryCurrencyAmounts.makeOpenItemSecondaryCurrencyAmounts((BigDecimal)BigDecimalMapper.add((BigDecimal)this.getSeccurr1OpenAmount(), (BigDecimal)allocAmount.getSeccurr1TotalAmount()), (BigDecimal)BigDecimalMapper.add((BigDecimal)this.getSeccurr2OpenAmount(), (BigDecimal)allocAmount.getSeccurr2TotalAmount()), (BigDecimal)BigDecimalMapper.add((BigDecimal)this.getSeccurr3OpenAmount(), (BigDecimal)allocAmount.getSeccurr3TotalAmount()), (BigDecimal)BigDecimalMapper.add((BigDecimal)this.getSeccurr4OpenAmount(), (BigDecimal)allocAmount.getSeccurr4TotalAmount()), (IFinanceSetup)allocAmount.getOpenItemAllocation().getFinanceSetup());
        }
        BigDecimal newBaseOpenAmount = this.getBaseOpenAmount().add(allocAmount.getBaseTotalAmount());
        if (allocAmount.getOpenItemAllocation().isCurrencyRevaluation()) {
            this.setBaseOpenAmount(newBaseOpenAmount, seccurrOpenAmounts, false);
            this.mIsAllocated = newBaseOpenAmount.compareTo(this.getBaseOriginalAmount()) != 0;
            this.mUpdateByOpenItemAllocation = true;
            return;
        }
        this.setBaseOpenAmount(newBaseOpenAmount, seccurrOpenAmounts);
        BigDecimal newOpenAmount = this.getOpenAmount().add(allocAmount.getForeignTotalAmount());
        this.setOpenAmount(newOpenAmount);
        this.adjustCurrentStatus(allocAmount, true);
        this.adjustIsAllocated(allocAmount.getOpenItemAllocation().isReversalPayment(), true);
        if (allocAmount.getOpenItemAllocation().isReturnPayment() && this.getBaseOpenAmount().signum() == 0) {
            this.getAllocationAmounts();
            this.updateCompletedAndEffectiveDates(allocAmount, true);
        } else {
            this.clearCompletedAndEffectiveDates();
        }
        ArrayList<AllocationAmount> remainingList = new ArrayList<AllocationAmount>();
        for (int i = 0; i < this.getAllocationAmounts().length; ++i) {
            if (PersistentObjectUtils.haveEqualObjectids((IPersistentObject)this.getAllocationAmounts()[i], (IPersistentObject)allocAmount)) continue;
            remainingList.add(this.getAllocationAmounts()[i]);
        }
        if (remainingList.size() == this.getAllocationAmounts().length) {
            return;
        }
        this.mAllocationAmounts = new AllocationAmount[remainingList.size()];
        remainingList.toArray(this.mAllocationAmounts);
        this.mUpdateByOpenItemAllocation = true;
        this.adjustAllocationNumber(false);
    }

    public void clearCompletedAndEffectiveDates() {
        this.setCompletedAllocationDate(null);
        this.setPaymentEffectiveDate(null);
    }

    private void updateCompletedAndEffectiveDates(AllocationAmount current, boolean isRemoveCase) {
        List allocations = CompletedAllocationSelectionHelper.getRelevantAllocations((OpenItem)this, (AllocationAmount)current, (boolean)isRemoveCase);
        AllocationDate completedDate = CompletedAllocationDateResolver.resolve((List)allocations);
        this.setCompletedAllocationDate(completedDate);
        if (this.requiresPaymentEffectiveDate() && completedDate != null && completedDate.getAllocationDate() != null) {
            Date paymentEffectiveDate = PaymentEffectiveDateFromInvoiceResolver.resolve((List)allocations);
            this.setPaymentEffectiveDate(paymentEffectiveDate);
        } else {
            this.setPaymentEffectiveDate(null);
        }
    }

    public boolean isUpdateByOpenItemAllocation() {
        return this.mUpdateByOpenItemAllocation;
    }

    private void adjustAllocationNumber(boolean addToAllocation) throws BusinessDomainException {
        this.mAllocationNumber = AllocationNumberManager.getAllocationNumber((IOpenItemBase)this, (boolean)addToAllocation);
    }

    private void adjustIsAllocated(boolean isReturnPayment, boolean isRemoveCase) throws BusinessDomainException {
        if (this.getBaseOpenAmount().compareTo(this.getBaseOriginalAmount()) != 0) {
            this.setIsAllocated(true);
        } else if (isReturnPayment && isRemoveCase) {
            this.setIsAllocated(true);
        } else {
            this.setIsAllocated(false);
        }
        if (this.isPaymentReceipt()) {
            OpenItemAllocation placeholderAllocation = this.getPlaceholderAllocation();
            if (!this.isAllocated()) {
                if (placeholderAllocation == null && !this.isDownPayment()) {
                    OpenItemAllocationFactory.createPlaceholderAllocation((OpenItem)this);
                }
            } else if (placeholderAllocation != null) {
                placeholderAllocation.makeSaveable();
                placeholderAllocation.destroy();
            }
        }
    }

    public AllocationAmount[] getAllocationAmounts() {
        this.requireLoaded();
        if (this.mAllocationAmounts == null) {
            if (!this.isNew() && (this.mIsAllocated_old || this.isPaymentReceipt())) {
                this.mAllocationAmounts = AllocationAmountPersistencyManager.getAllocationAmounts((OpenItem)this);
            }
            if (this.mAllocationAmounts == null) {
                this.mAllocationAmounts = new AllocationAmount[0];
            }
        }
        return this.mAllocationAmounts;
    }

    public void setAllocationAmount(AllocationAmount allocationAmount) {
        this.getAllocationAmounts();
        for (int i = 0; i < this.mAllocationAmounts.length; ++i) {
            if (!PersistentObjectUtils.haveEqualObjectids((IPersistentObject)this.mAllocationAmounts[i], (IPersistentObject)allocationAmount)) continue;
            this.mAllocationAmounts[i] = allocationAmount;
            return;
        }
    }

    public OpenItemAllocation getPlaceholderAllocation() {
        for (int i = 0; i < this.getAllocationAmounts().length; ++i) {
            if (!this.getAllocationAmounts()[i].getOpenItemAllocation().isPlaceholder()) continue;
            return this.getAllocationAmounts()[i].getOpenItemAllocation();
        }
        return null;
    }

    public PersonalAccount getDunningLetterPersonalAccount() {
        return this.mDunningLetterPersonalAccount;
    }

    public void setDunningLetterPersonalAccount(PersonalAccount pa) {
        this.mDunningLetterPersonalAccount = pa;
    }

    public boolean getIsDunningLetterInvoice() {
        return this.mIsDunningLetterInvoice;
    }

    public void setIsDunningLetterInvoice(boolean isInvoice) {
        this.mIsDunningLetterInvoice = isInvoice;
    }

    public PersonalAccount getPayer() {
        if (this.mPayer == null) {
            return this.getPersonalAccount();
        }
        return this.mPayer;
    }

    public void setPayer(PersonalAccount payer) {
        this.mPayer = payer;
    }

    public PaymentSessionBankAccount getPaymentSessionBankAccount() {
        return this.mPaymentSessionBankAccount;
    }

    public void setPaymentSessionBankAccount(PaymentSessionBankAccount paymentSessionBankAccount) {
        this.mPaymentSessionBankAccount = paymentSessionBankAccount;
    }

    public void setExecuteDate(Date executeDate) {
        this.mExecuteDate = executeDate;
    }

    public Date getExecuteDate() {
        return this.mExecuteDate;
    }

    public void setPaymentBankAddress(IPersonalAccountBankAddress bankAddress) {
        this.mPaymentBankAddress = bankAddress;
    }

    public IPersonalAccountBankAddress getPaymentBankAddress() {
        return this.mPaymentBankAddress;
    }

    public BigDecimal getSeccurr1OpenAmountWithSign() {
        return this.getAmountWithSign(this.getSeccurr1OpenAmount());
    }

    public BigDecimal getSeccurr1OriginalAmountWithSign() {
        return this.getAmountWithSign(this.getSeccurr1OriginalAmount());
    }

    public BigDecimal getSeccurr2OpenAmountWithSign() {
        return this.getAmountWithSign(this.getSeccurr2OpenAmount());
    }

    public BigDecimal getSeccurr2OriginalAmountWithSign() {
        return this.getAmountWithSign(this.getSeccurr2OriginalAmount());
    }

    public BigDecimal getSeccurr3OpenAmountWithSign() {
        return this.getAmountWithSign(this.getSeccurr3OpenAmount());
    }

    public BigDecimal getSeccurr3OriginalAmountWithSign() {
        return this.getAmountWithSign(this.getSeccurr3OriginalAmount());
    }

    public BigDecimal getSeccurr4OpenAmountWithSign() {
        return this.getAmountWithSign(this.getSeccurr4OpenAmount());
    }

    public BigDecimal getSeccurr4OriginalAmountWithSign() {
        return this.getAmountWithSign(this.getSeccurr4OriginalAmount());
    }

    private BigDecimal getAmountWithSign(BigDecimal amount) {
        return OpenItemHelper.makeAmountWithSign((BigDecimal)amount, (boolean)this.getIsDebit());
    }

    public BigDecimal getOriginalAmountWithSign() {
        return this.getAmountWithSign(this.getOriginalAmount());
    }

    public BigDecimal getBaseOriginalAmountWithSign() {
        return this.getAmountWithSign(this.getBaseOriginalAmount());
    }

    public BigDecimal getOpenAmountWithSign() {
        return this.getAmountWithSign(this.getOpenAmount());
    }

    public BigDecimal getBaseOpenAmountWithSign() {
        return this.getAmountWithSign(this.getBaseOpenAmount());
    }

    public void checkOpenItem() throws BusinessDomainException {
        this.validator.checkData(this);
    }

    public FinanceSetup getFinanceSetup() {
        if (this.mFinanceSetup == null) {
            this.mFinanceSetup = this.getCompany().getFinanceSetup();
        }
        return this.mFinanceSetup;
    }

    public void setFinanceSetup(FinanceSetup financeSetup) {
        this.mFinanceSetup = financeSetup;
    }

    public boolean isGuideTaxSplit() {
        return this.getIsOpeningBalance() && this.getTaxRate() != null;
    }

    protected void check() throws BusinessDomainException {
        if (this.isUnfinished() || this.getIsRecurring() || this.getIsBankStatementPosting() || this.getPersonalAccount().getNegotiatedExchangeRate()) {
            return;
        }
        OpenItemHelper.checkOpenAmounts((IOpenItemBase)this);
        if (this.isDownPayment() && this.isPaymentReceipt()) {
            if (this.getDownPaymentOpenAmount().signum() == 0 && this.getDownPaymentBaseOpenAmount().signum() != 0) {
                String errorValue = StringMapper.toString((String)this.getReferenceNumber()) + " / " + StringMapper.toString((String)this.getPersonalAccount().getCode()) + " / " + BigDecimalMapper.toString((BigDecimal)this.getOriginalAmount()) + " / " + BigDecimalMapper.toString((BigDecimal)this.getDownPaymentOpenAmount()) + " / " + BigDecimalMapper.toString((BigDecimal)this.getDownPaymentBaseOpenAmount());
                throw OpenItemExceptionMapper.makeDownPaymentOpenAmountZeroDomainException((String)errorValue);
            }
            if (this.getDownPaymentOpenAmount().signum() != 0 && this.getDownPaymentBaseOpenAmount().signum() == 0) {
                String errorValue = StringMapper.toString((String)this.getReferenceNumber()) + " / " + StringMapper.toString((String)this.getPersonalAccount().getCode()) + " / " + BigDecimalMapper.toString((BigDecimal)this.getOriginalAmount()) + " / " + BigDecimalMapper.toString((BigDecimal)this.getDownPaymentOpenAmount()) + " / " + BigDecimalMapper.toString((BigDecimal)this.getDownPaymentBaseOpenAmount());
                throw OpenItemExceptionMapper.makeDownPaymentOpenAmountNotZeroDomainException((String)errorValue);
            }
        }
        if (this.getSeccurr1OpenAmount() != null && this.getBaseOpenAmount().signum() == 0 && this.getSeccurr1OpenAmount().signum() != 0) {
            throw ExceptionMapper.makeApplicationException((String)"Open amount in SC1 is not zero");
        }
        if (this.getSeccurr2OpenAmount() != null && this.getBaseOpenAmount().signum() == 0 && this.getSeccurr2OpenAmount().signum() != 0) {
            throw ExceptionMapper.makeApplicationException((String)"Open amount in SC2 is not zero");
        }
        if (this.getSeccurr3OpenAmount() != null && this.getBaseOpenAmount().signum() == 0 && this.getSeccurr3OpenAmount().signum() != 0) {
            throw ExceptionMapper.makeApplicationException((String)"Open amount in SC3 is not zero");
        }
        if (this.getSeccurr4OpenAmount() != null && this.getBaseOpenAmount().signum() == 0 && this.getSeccurr4OpenAmount().signum() != 0) {
            throw ExceptionMapper.makeApplicationException((String)"Open amount in SC4 is not zero");
        }
    }

    public boolean getIsRecurring() {
        return this.mTransactionPersistencyType == 1;
    }

    public boolean getIsBankStatementPosting() {
        return this.mTransactionPersistencyType == 2;
    }

    private boolean checkForOpenAmountTransfer() {
        return this.getOpenItemType() == OpenItemType.CREDITNOTE || this.getOpenItemType() == OpenItemType.INVOICE || this.getOpenItemType() == OpenItemType.REPOSTED_CREDITNOTE || this.getOpenItemType() == OpenItemType.REPOSTED_INVOICE;
    }

    public void setNewStatus(OpenItemStatusType statusType, GeneratePaymentRemittance paymentRemittance) throws BusinessDomainException {
        OpenItemCurrentStatus newStatus;
        this.makeSaveable();
        switch (statusType) {
            case INCLUDED_IN_DIRECT_DEBIT_SESSION: 
            case INCLUDED_IN_PAYMENT_SESSION: 
            case FREE_FOR_COLLECTION: 
            case FREE_FOR_PAYMENT: {
                newStatus = new OpenItemCurrentStatus(statusType);
                break;
            }
            case PAYMENT_FILE_CREATED: 
            case CHECK_PRINTED: 
            case FILE_FOR_COLLECTION_CREATED: {
                GeneratePaymentSession session = paymentRemittance.getGeneratePayment().getGeneratePaymentSession();
                OpenItemStatus openItemStatus = session.getOpenItemStatusManager().getOpenItemStatus(paymentRemittance.getGeneratePayment().getBankAccount(), statusType);
                if (openItemStatus == null) {
                    throw OpenItemExceptionMapper.makeOpenItemStatusMissingDomainException();
                }
                NLAccountCompanySetting accountOfTransfer = null;
                if (this.checkForOpenAmountTransfer()) {
                    OpenAmountTransferManager manager = new OpenAmountTransferManager(this);
                    accountOfTransfer = manager.transfer(paymentRemittance, openItemStatus);
                }
                newStatus = new OpenItemCurrentStatus(statusType, accountOfTransfer, paymentRemittance.getTransferredAmount(), statusType, paymentRemittance.getTransferredAmount());
                break;
            }
            default: {
                throw ExceptionMapper.makeApplicationException((String)"OI-Status not allowed");
            }
        }
        this.setCurrentStatus(newStatus);
    }

    public void resetStatus(GeneratePaymentRemittance paymentRemittance) throws BusinessDomainException {
        this.requireLoaded();
        if (this.getCurrentStatus() != null) {
            this.makeSaveable();
            if (this.checkForOpenAmountTransfer()) {
                OpenAmountTransferManager manager = new OpenAmountTransferManager(this);
                manager.backTransfer(paymentRemittance);
            }
            this.setCurrentStatus(null);
        }
        this.mGeneratePaymentSession = null;
        this.mInProcessing = false;
    }

    public Map<String, TaxCode> getUsedTaxCodes() {
        PersonalAccountEntry originalPaEntry = this.getOriginalPaEntry();
        if (originalPaEntry != null) {
            return originalPaEntry.getTransaction().getUsedTaxCodes();
        }
        HashMap<String, TaxCode> usedTaxCodes = new HashMap<String, TaxCode>();
        if (this.getRemainderTaxCode() != null) {
            usedTaxCodes.put(this.getRemainderTaxCode().getCode(), this.getRemainderTaxCode());
        } else {
            if (this.getTaxRate() != null) {
                usedTaxCodes.put(this.getTaxRate().getTaxCode().getCode(), this.getTaxRate().getTaxCode());
            }
            if (this.getTaxRate2() != null) {
                usedTaxCodes.put(this.getTaxRate2().getTaxCode().getCode(), this.getTaxRate2().getTaxCode());
            }
            if (this.getTaxRate3() != null) {
                usedTaxCodes.put(this.getTaxRate3().getTaxCode().getCode(), this.getTaxRate3().getTaxCode());
            }
            if (this.getTaxRate4() != null) {
                usedTaxCodes.put(this.getTaxRate4().getTaxCode().getCode(), this.getTaxRate4().getTaxCode());
            }
            if (this.getTaxRate5() != null) {
                usedTaxCodes.put(this.getTaxRate5().getTaxCode().getCode(), this.getTaxRate5().getTaxCode());
            }
        }
        return usedTaxCodes;
    }

    public TaxCode getUsedTaxCode() {
        if (this.getDownPaymentTaxCode() != null) {
            return this.getDownPaymentTaxCode();
        }
        if (this.getRemainderTaxCode() != null) {
            return this.getRemainderTaxCode();
        }
        if (this.getTaxRate() != null && this.getTaxRate2() == null) {
            return this.getTaxRate().getTaxCode();
        }
        return null;
    }

    public boolean getIsDebit() {
        this.requireLoaded();
        return this.mIsDebit;
    }

    private void setIsDebit(boolean isdebit) {
        this.mIsDebit = isdebit;
    }

    public boolean getRemainderRelatedToOpenItem() {
        return this.getOriginalOpenItem() != null;
    }

    public PersonalAccountEntry getOriginalPaEntry() {
        PersonalAccountEntry paEntry = this.getPersonalAccountEntry();
        if (paEntry == null && this.getParentOpenItem() != null) {
            paEntry = this.getParentOpenItem().getPersonalAccountEntry();
        }
        return paEntry;
    }

    public OpenItem getParentOpenItem() {
        this.requireLoaded();
        OpenItem parentOi = this.getOriginalOpenItem();
        if (parentOi != null) {
            boolean stop = false;
            do {
                if (parentOi.getOriginalOpenItem() == null) {
                    stop = true;
                    continue;
                }
                parentOi = parentOi.getOriginalOpenItem();
            } while (!stop);
        }
        return parentOi;
    }

    public void setOriginalOpenIten(OpenItem originalOpenItem) {
        this.mOriginalOpenItem = originalOpenItem;
    }

    public OpenItem getOriginalOpenItem() {
        this.requireLoaded();
        return this.mOriginalOpenItem;
    }

    public void setDownPaymentTaxData(NominalLedgerEntry[] downPaymentEntries, TaxCode downPaymentTaxCode) throws BusinessDomainException {
        this.setDownPaymentTaxCode(downPaymentTaxCode);
        BigDecimal downPaymentBaseTaxAmount = null;
        BigDecimal downPaymentTaxAmount = null;
        if (downPaymentEntries != null && downPaymentEntries.length > 0) {
            if (downPaymentEntries.length == 2) {
                downPaymentBaseTaxAmount = downPaymentEntries[0].getBaseAmount().subtract(downPaymentEntries[1].getBaseAmount());
                downPaymentBaseTaxAmount = downPaymentBaseTaxAmount.abs();
                downPaymentTaxAmount = downPaymentEntries[0].getEnteredAmount().subtract(downPaymentEntries[1].getEnteredAmount());
                downPaymentTaxAmount = downPaymentTaxAmount.abs();
            } else {
                downPaymentBaseTaxAmount = downPaymentEntries[0].getBaseAmount();
                downPaymentTaxAmount = downPaymentEntries[0].getEnteredAmount();
            }
        }
        this.setDownPaymentBaseTaxAmount(downPaymentBaseTaxAmount);
        this.setDownPaymentTaxAmount(downPaymentTaxAmount);
    }

    public void copyDataFromTransaction() throws BusinessDomainException {
        if (this.getPersonalAccountEntry() == null) {
            return;
        }
        NominalTransactionBase transaction = this.getPersonalAccountEntry().getTransaction();
        this.setPersonalAccount(this.getPersonalAccountEntry().getPersonalAccount());
        this.setSequenceNumber(transaction.getSequenceNumber());
        this.setIsUnfinished(transaction.getIsUnfinished());
        this.setDocumentDate(transaction.getDocumentDate());
        this.setTransactionDate(transaction.getTransactionDate());
        this.setTransactionType(transaction.getTransactionType());
        if (this.isCancellation()) {
            this.setDocumentCategory(transaction.getDocumentCategory());
        } else {
            this.setDocumentCategory(transaction.getDocumentCategory_New());
        }
        this.setTaxDate(transaction.getTaxDate());
        if (transaction.isChequeDepositTransaction()) {
            this.setBankAccount(((ChequeDepositTransaction)transaction).getBankAccountEntry().getBankAccount());
            this.setValueDate(transaction.getValueDate());
            ChequeDepositData chequeDepositData = this.getPersonalAccountEntry().getChequeDepositData();
            if (chequeDepositData != null) {
                this.setReferenceNumber(chequeDepositData.getReferenceNumber());
                this.setProcessID(chequeDepositData.getProcessId());
            } else {
                this.setReferenceNumber(null);
                this.setProcessID(null);
            }
        } else {
            this.setReferenceNumber(transaction.getReferenceNumber());
            if (transaction.isCashTransaction() && (this.isDownPayment() || ((CashTransaction)transaction).isSeveralAccounts())) {
                this.setProcessID(this.getPersonalAccountEntry().getDownPaymentProcessId());
            } else {
                this.setProcessID(transaction.getProcessId());
            }
        }
        this.setConversionRate(transaction.getConversionRate());
        this.setEnteredCurrency(transaction.getEnteredCurrency());
        this.setSeccurr1ConversionRate(transaction.getSeccurr1ConversionRate());
        this.setSeccurr2ConversionRate(transaction.getSeccurr2ConversionRate());
        this.setSeccurr3ConversionRate(transaction.getSeccurr3ConversionRate());
        this.setSeccurr4ConversionRate(transaction.getSeccurr4ConversionRate());
        this.setFinancialYear(transaction.getFinancialYear());
        this.setDocumentType(transaction.getDocumentType());
        this.setIsCorrection(transaction.getIsCorrection());
        if (!this.isCancellation()) {
            this.setTaxRate(null);
            this.setTaxAmount(null);
            this.setBaseTaxAmount(null);
        }
        if (this.isDownPayment()) {
            this.setIsInputTax(this.getPersonalAccountEntry().getDownPaymentInputTax());
        } else {
            this.setIsInputTax(transaction.getIsInputTax());
        }
        if (transaction.isInvoiceTransaction()) {
            this.setDiscountType(((InvoiceTransaction)transaction).getDiscountType());
            this.setContraNLAccount(this.getPersonalAccountEntry().getContraNLAccount());
            this.setKsefNumber(((InvoiceTransaction)transaction).getKsefNumber());
            this.setKsefNumberType(((InvoiceTransaction)transaction).getKsefNumberType());
            if (!this.isCancellation() && this.getPersonalAccountEntry() != null && this.getPersonalAccountEntry().getOpenItems().length == 1 && !this.isDownPayment()) {
                this.setTaxRate(transaction.getFixedTaxRate());
                if (((InvoiceTransaction)transaction).getTaxTotal() != null) {
                    this.setTaxAmount(((InvoiceTransaction)transaction).getTaxTotal().abs());
                }
                if (((InvoiceTransaction)transaction).getBaseTaxTotal() != null) {
                    this.setBaseTaxAmount(((InvoiceTransaction)transaction).getBaseTaxTotal().abs());
                }
            }
        }
        if (transaction.isCashTransaction()) {
            this.setBankAccount(((CashTransaction)transaction).getBankAccountEntry().getBankAccount());
            this.setValueDate(transaction.getValueDate());
        }
        if (!this.isCancellation() && !this.getPersonalAccountEntry().getIsDownPayment() && transaction.getFinanceSetup().getCostingForConstructionWork(this.getPersonalAccountEntry().getPersonalAccount()) && transaction.isInvoiceTransaction()) {
            ICostUnit costUnit = ConstructionProjectHelper.getCostUnit((NominalTransactionBase)transaction);
            this.setCostUnit(costUnit);
        }
    }

    public Date getInterestCalculationDate() {
        this.requireLoaded();
        return this.mInterestCalculationDate;
    }

    public void setInterestCalculationDate(Date date) {
        this.mInterestCalculationDate = date;
    }

    public void setOriginalTaxAmountsInBaseCurrency() {
        if (this.getPersonalAccountEntry() != null) {
            NominalTaxEntry[] nlTaxEntries = this.getPersonalAccountEntry().getTransaction().getTaxEntries();
            BigDecimal orgBaseAmount = this.getPersonalAccountEntry().getTransaction().getBaseTotal();
            BigDecimal oiPercentage = BigDecimalMapper.HUNDRED.multiply(this.mBaseOriginalAmount).divide(orgBaseAmount, RoundingMode.HALF_UP);
            if (nlTaxEntries.length > 0) {
                BigDecimal bigDecimal = this.mTaxAmount = nlTaxEntries[0].getIsDebit() ? nlTaxEntries[0].getAmount().negate() : nlTaxEntries[0].getAmount();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTaxAmount)) {
                    this.mTaxAmount = this.mTaxAmount.multiply(oiPercentage).divide(BigDecimalMapper.HUNDRED, 2, RoundingMode.HALF_UP);
                }
                BigDecimal bigDecimal2 = this.mNetAmount = nlTaxEntries[0].getIsDebit() ? nlTaxEntries[0].getBaseNetAmount().negate() : nlTaxEntries[0].getBaseNetAmount();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mNetAmount)) {
                    this.mNetAmount = this.mNetAmount.multiply(oiPercentage).divide(BigDecimalMapper.HUNDRED, 2, RoundingMode.HALF_UP);
                }
                this.mTaxRateOID = nlTaxEntries[0].getTaxRate().getObjectid();
            }
            if (nlTaxEntries.length > 1) {
                BigDecimal bigDecimal = this.mTaxAmount2 = nlTaxEntries[1].getIsDebit() ? nlTaxEntries[1].getAmount().negate() : nlTaxEntries[1].getAmount();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTaxAmount2)) {
                    this.mTaxAmount2 = this.mTaxAmount2.multiply(oiPercentage).divide(BigDecimalMapper.HUNDRED, 2, RoundingMode.HALF_UP);
                }
                BigDecimal bigDecimal3 = this.mNetAmount2 = nlTaxEntries[1].getIsDebit() ? nlTaxEntries[1].getBaseNetAmount().negate() : nlTaxEntries[1].getBaseNetAmount();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mNetAmount2)) {
                    this.mNetAmount2 = this.mNetAmount2.multiply(oiPercentage).divide(BigDecimalMapper.HUNDRED, 2, RoundingMode.HALF_UP);
                }
                this.mTaxRate2OID = nlTaxEntries[1].getTaxRate().getObjectid();
            }
            if (nlTaxEntries.length > 2) {
                BigDecimal bigDecimal = this.mTaxAmount3 = nlTaxEntries[2].getIsDebit() ? nlTaxEntries[2].getAmount().negate() : nlTaxEntries[2].getAmount();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTaxAmount3)) {
                    this.mTaxAmount3 = this.mTaxAmount3.multiply(oiPercentage).divide(BigDecimalMapper.HUNDRED, 2, RoundingMode.HALF_UP);
                }
                BigDecimal bigDecimal4 = this.mNetAmount3 = nlTaxEntries[2].getIsDebit() ? nlTaxEntries[2].getBaseNetAmount().negate() : nlTaxEntries[2].getBaseNetAmount();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mNetAmount3)) {
                    this.mNetAmount3 = this.mNetAmount3.multiply(oiPercentage).divide(BigDecimalMapper.HUNDRED, 2, RoundingMode.HALF_UP);
                }
                this.mTaxRate3OID = nlTaxEntries[2].getTaxRate().getObjectid();
            }
            if (nlTaxEntries.length > 3) {
                BigDecimal bigDecimal = this.mTaxAmount4 = nlTaxEntries[3].getIsDebit() ? nlTaxEntries[3].getAmount().negate() : nlTaxEntries[3].getAmount();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTaxAmount4)) {
                    this.mTaxAmount4 = this.mTaxAmount4.multiply(oiPercentage).divide(BigDecimalMapper.HUNDRED, 2, RoundingMode.HALF_UP);
                }
                BigDecimal bigDecimal5 = this.mNetAmount4 = nlTaxEntries[3].getIsDebit() ? nlTaxEntries[3].getBaseNetAmount().negate() : nlTaxEntries[3].getBaseNetAmount();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mNetAmount4)) {
                    this.mNetAmount4 = this.mNetAmount4.multiply(oiPercentage).divide(BigDecimalMapper.HUNDRED, 2, RoundingMode.HALF_UP);
                }
                this.mTaxRate4OID = nlTaxEntries[3].getTaxRate().getObjectid();
            }
            if (nlTaxEntries.length > 4) {
                BigDecimal bigDecimal = this.mTaxAmount5 = nlTaxEntries[4].getIsDebit() ? nlTaxEntries[4].getAmount().negate() : nlTaxEntries[4].getAmount();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTaxAmount5)) {
                    this.mTaxAmount5 = this.mTaxAmount5.multiply(oiPercentage).divide(BigDecimalMapper.HUNDRED, 2, RoundingMode.HALF_UP);
                }
                BigDecimal bigDecimal6 = this.mNetAmount5 = nlTaxEntries[4].getIsDebit() ? nlTaxEntries[4].getBaseNetAmount().negate() : nlTaxEntries[4].getBaseNetAmount();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mNetAmount5)) {
                    this.mNetAmount5 = this.mNetAmount5.multiply(oiPercentage).divide(BigDecimalMapper.HUNDRED, 2, RoundingMode.HALF_UP);
                }
                this.mTaxRate5OID = nlTaxEntries[4].getTaxRate().getObjectid();
            }
        }
    }

    public BigDecimal getSeccurr1OriginalAmount() {
        this.requireLoaded();
        return this.mSeccurr1OriginalAmount;
    }

    public BigDecimal getSeccurr1OpenAmount() {
        this.requireLoaded();
        return this.mSeccurr1OpenAmount;
    }

    public BigDecimal getSeccurr2OriginalAmount() {
        this.requireLoaded();
        return this.mSeccurr2OriginalAmount;
    }

    public BigDecimal getSeccurr2OpenAmount() {
        this.requireLoaded();
        return this.mSeccurr2OpenAmount;
    }

    public BigDecimal getSeccurr3OriginalAmount() {
        this.requireLoaded();
        return this.mSeccurr3OriginalAmount;
    }

    public BigDecimal getSeccurr3OpenAmount() {
        this.requireLoaded();
        return this.mSeccurr3OpenAmount;
    }

    public BigDecimal getSeccurr4OriginalAmount() {
        this.requireLoaded();
        return this.mSeccurr4OriginalAmount;
    }

    public BigDecimal getSeccurr4OpenAmount() {
        this.requireLoaded();
        return this.mSeccurr4OpenAmount;
    }

    public ConversionRate getSeccurr1ConversionRate() {
        this.requireLoaded();
        return this.mSeccurr1ConversionRate;
    }

    private void setSeccurr1ConversionRate(ConversionRate rate) {
        this.mSeccurr1ConversionRate = rate;
    }

    public ConversionRate getSeccurr2ConversionRate() {
        this.requireLoaded();
        return this.mSeccurr2ConversionRate;
    }

    private void setSeccurr2ConversionRate(ConversionRate rate) {
        this.mSeccurr2ConversionRate = rate;
    }

    public ConversionRate getSeccurr3ConversionRate() {
        this.requireLoaded();
        return this.mSeccurr3ConversionRate;
    }

    private void setSeccurr3ConversionRate(ConversionRate rate) {
        this.mSeccurr3ConversionRate = rate;
    }

    public ConversionRate getSeccurr4ConversionRate() {
        this.requireLoaded();
        return this.mSeccurr4ConversionRate;
    }

    private void setSeccurr4ConversionRate(ConversionRate rate) {
        this.mSeccurr4ConversionRate = rate;
    }

    public ConversionRate getConversionRate(CurrencyType currencyType) {
        return ConversionRateMap.makeRate((CurrencyType)currencyType, (ConversionRate)this.getNewConversionRate(), (ConversionRate)this.getSeccurr1ConversionRate(), (ConversionRate)this.getSeccurr2ConversionRate(), (ConversionRate)this.getSeccurr3ConversionRate(), (ConversionRate)this.getSeccurr4ConversionRate());
    }

    public Map<ICurrency, ConversionRate> getSeccurrConversionRateMap() {
        if (this.mSeccurrConversionRateMap == null) {
            this.mSeccurrConversionRateMap = this.makeSeccurrConversionRateMap(this.getFinanceSetup());
        }
        return this.mSeccurrConversionRateMap;
    }

    public void setSeccurrConversionRateMap(Map<ICurrency, ConversionRate> rateMap) {
        this.mSeccurrConversionRateMap = rateMap;
    }

    private Map<ICurrency, ConversionRate> makeSeccurrConversionRateMap(FinanceSetup setup) {
        HashMap<ICurrency, ConversionRate> map = new HashMap<ICurrency, ConversionRate>();
        if (setup.getSeccurrency1() != null) {
            ConversionRate seccurr1rate = this.getSeccurr1ConversionRate();
            map.put(setup.getSeccurrency1(), seccurr1rate);
        }
        if (setup.getSeccurrency2() != null) {
            ConversionRate seccurr2rate = this.getSeccurr2ConversionRate();
            map.put(setup.getSeccurrency2(), seccurr2rate);
        }
        if (setup.getSeccurrency3() != null) {
            ConversionRate seccurr3rate = this.getSeccurr3ConversionRate();
            map.put(setup.getSeccurrency3(), seccurr3rate);
        }
        if (setup.getSeccurrency4() != null) {
            ConversionRate seccurr4rate = this.getSeccurr4ConversionRate();
            map.put(setup.getSeccurrency4(), seccurr4rate);
        }
        return map;
    }

    public void setSeccurrConversionRates(OpenItemSecondaryCurrencyAmounts seccurrAmounts) {
        if (seccurrAmounts != null) {
            this.setSeccurr1ConversionRate(seccurrAmounts.mSeccurr1ConversionRate);
            this.setSeccurr2ConversionRate(seccurrAmounts.mSeccurr2ConversionRate);
            this.setSeccurr3ConversionRate(seccurrAmounts.mSeccurr3ConversionRate);
            this.setSeccurr4ConversionRate(seccurrAmounts.mSeccurr4ConversionRate);
        }
    }

    public boolean getInProcessing() {
        this.requireLoaded();
        return this.mInProcessing;
    }

    public void setInProcessing(boolean inProcessing) {
        this.mInProcessing = inProcessing;
    }

    public boolean getNegotiatedExchangeRate(CurrencyType currencyType) {
        if (currencyType == CurrencyType.BASE_CURRENCY) {
            return this.getPersonalAccount().getNegotiatedExchangeRate();
        }
        return false;
    }

    public OpenItem getOpenItem() {
        return this;
    }

    public AccountCleanupSession getAccountCleanupSession() {
        this.requireLoaded();
        return this.mAccountCleanupSession;
    }

    public boolean isCreatedByTransfer() {
        this.requireLoaded();
        return this.mIsCreatedByTransfer;
    }

    public void setIsCreatedByTransfer(boolean isCreatedByTransfer) {
        this.mIsCreatedByTransfer = isCreatedByTransfer;
    }

    public void setDunningOpenItemForReplace(OpenItem openItem) {
        this.mDunningOpenItemForReplace = openItem;
    }

    public OpenItem getDunningOpenItemForReplace() {
        return this.mDunningOpenItemForReplace;
    }

    public void setDunningLetterSession(DunningLetterSession session) {
        this.mDunningLetterSession = session;
    }

    public boolean getAssignedToFinalInvoice() throws BusinessDomainException {
        if (!this.mAssignedToFinalInvoiceCalculated) {
            this.mAssignedToFinalInvoiceCalculated = true;
            if (!this.isNew() && this.isDownPaymentRequest() && this.getFinanceSetup().getFinalInvoiceWithDownPaymentRequest()) {
                this.mAssignedToFinalInvoice = DownPaymentRequestOpenItemPersistencyManager.assignedToFinalInvoice((OpenItem)this);
            }
        }
        return this.mAssignedToFinalInvoice;
    }

    public IAccount getAccount() {
        return this.getPersonalAccount();
    }

    public NLAccountOpenItem getNLAccountOpenItem() {
        return null;
    }

    public boolean getHasPersonalAccountAdjustments() {
        AllocationAmount[] aas;
        boolean result = false;
        if (this.isAllocated() && (aas = this.getAllocationAmounts()) != null) {
            for (AllocationAmount aa : aas) {
                if (aa.getAdjustmentTransactions().isEmpty()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean isKronospanPL() {
        if (!this.mIsKronospanPLCalculated) {
            this.mIsKronospanPL = this.getPersonalAccount().getAccountingCompany().getJurisdictionType() == JurisdictionType.PL && ISoftware.isKronospan();
            this.mIsKronospanPLCalculated = true;
        }
        return this.mIsKronospanPL;
    }

    public void setIsReturnPayment(boolean isReturnPayment) {
        this.mIsReturnPayment = isReturnPayment;
    }

    public boolean getIsReturnPayment() {
        this.requireLoaded();
        return this.mIsReturnPayment;
    }

    public CustSupAddress getCustSupAddress() {
        CustSupAddress result = this.getPersonalAccount().getOneOffAccount() ? this.getOneOffAccountAddress() : this.getPersonalAccount().getAddress();
        return result;
    }

    public IAllocationBase getCreationOpenItemAllocation() {
        if (!this.getIsOpeningBalance() && this.isRemainder()) {
            return OpenItemAllocationRemainderPersistencyManager.getOpenItemAllocation((OpenItem)this);
        }
        return null;
    }

    public SequenceNo getSequenceNoForAllocation() throws BusinessDomainException {
        return this.getFinanceSetup().getSequenceNoForAllocation();
    }

    public void addToOpenItem(DownPaymentRequestAllocationAmount aa) throws BusinessDomainException {
        DownPaymentRequestAllocationHelper.addToOpenItem((OpenItem)this, (DownPaymentRequestAllocationAmount)aa);
    }

    public void removeFromOpenItem(DownPaymentRequestAllocationAmount aa) throws BusinessDomainException {
        DownPaymentRequestAllocationHelper.removeFromOpenItem((OpenItem)this, (DownPaymentRequestAllocationAmount)aa);
    }

    private void checkIfProcessedForUpdate() throws BusinessDomainException {
        this.validator.checkIfProcessedForUpdate(this);
    }

    private boolean changedDiscount(IOpenItemDiscount oldDiscount, IOpenItemDiscount newDiscount) {
        if (!this.isNew()) {
            return newDiscount == null && oldDiscount != null || newDiscount != null && oldDiscount == null || newDiscount != null && oldDiscount != null && newDiscount.getPercent().compareTo(oldDiscount.getPercent()) != 0;
        }
        return false;
    }

    private boolean changedAmount(BigDecimal amountOld, BigDecimal amountNew) {
        if (!this.isNew()) {
            return !TransactionHelper.isEqual((BigDecimal)amountOld, (BigDecimal)amountNew);
        }
        return false;
    }

    private void checkDiscounForUpdate() throws BusinessDomainException {
        if (this.isAllocated()) {
            if (this.isKronospanPL()) {
                if (this.getHasPersonalAccountAdjustments()) {
                    throw TransactionExceptionMapper.makeHasPersonalAccountAdjustmentsDomainException();
                }
            } else {
                throw OpenItemExceptionMapper.makeChangeNotAllowedBacauseAllocatedDomainException();
            }
        }
        if (this.getBankStatementPostingSession() != null) {
            throw OpenItemExceptionMapper.makeChangeNotAllowedBacauseBankStatementSessionDomainException();
        }
        if (this.getGeneratePaymentSession() != null) {
            throw OpenItemExceptionMapper.makeChangeNotAllowedBacausePaymentSessionDomainException();
        }
    }

    public DownPaymentRequestAllocationAmount[] getDownPaymentRequestAllocationAmounts() {
        if (this.mDownPaymentRequestAllocationAmounts == null) {
            if (!this.isNew()) {
                this.mDownPaymentRequestAllocationAmounts = DownPaymentRequestAllocationAmountPersistencyManager.getDownPaymentRequestAllocationAmounts((OpenItem)this);
            }
            if (this.mDownPaymentRequestAllocationAmounts == null) {
                this.mDownPaymentRequestAllocationAmounts = new DownPaymentRequestAllocationAmount[0];
            }
        }
        return this.mDownPaymentRequestAllocationAmounts;
    }

    public boolean getIsDownPaymentRequestAllocated() {
        this.requireLoaded();
        return this.mIsDownPaymentRequestAllocated;
    }

    public void setIsDownPaymentRequestAllocated(boolean b) {
        this.mIsDownPaymentRequestAllocated = b;
    }

    public BigDecimal getDownPaymentBaseAmount() {
        this.requireLoaded();
        return this.mDownPaymentBaseAmount;
    }

    public void setDownPaymentBaseAmount(BigDecimal amount) {
        this.mDownPaymentBaseAmount = amount;
    }

    public BigDecimal getDownPaymentOpenAmount() {
        this.requireLoaded();
        return this.mDownPaymentOpenAmount;
    }

    public void setDownPaymentOpenAmount(BigDecimal openAmount) {
        this.mDownPaymentOpenAmount = openAmount;
    }

    public BigDecimal getDownPaymentBaseOpenAmount() {
        this.requireLoaded();
        return this.mDownPaymentBaseOpenAmount;
    }

    public void setDownPaymentBaseOpenAmount(BigDecimal openAmount) {
        this.mDownPaymentBaseOpenAmount = openAmount;
    }

    public boolean getIsProcessingInRepostingPersonalAccount() {
        if (!this.mIsProcessingInRepostingPersonalAccountCalculated) {
            this.mIsProcessingInRepostingPersonalAccount = this.getInProcessing() ? PersonalAccountRepostingOpenItemPersistencyManager.isInProcessing((String)this.getObjectid()) : false;
            this.mIsProcessingInRepostingPersonalAccountCalculated = true;
        }
        return this.mIsProcessingInRepostingPersonalAccount;
    }

    public ICostUnit getCostUnit() {
        this.requireLoaded();
        return this.mCostUnit;
    }

    public void setCostUnit(ICostUnit costUnit) throws BusinessDomainException {
        this.setCostUnit(costUnit, true);
    }

    public void setCostUnit(ICostUnit costUnit, boolean checkIfAllocated) throws BusinessDomainException {
        if (!this.isNew() && PersistentObjectUtils.objectChanged((IPersistentObject)this.getCostUnit(), (IPersistentObject)costUnit)) {
            if (checkIfAllocated) {
                this.validator.checkIfAllocated(this, OpenItemOperationType.UPDATE);
            }
            if (this.getGeneratePaymentSession() != null) {
                throw OpenItemExceptionMapper.makeChangeNotAllowedBacausePaymentSessionDomainException();
            }
        }
        this.mCostUnit = costUnit;
    }

    public PurchaseInvoiceRegisterStatus getPurchaseInvoiceRegisterStatus() {
        this.requireLoaded();
        return this.mPurchaseInvoiceRegisterStatus;
    }

    public void setPurchaseInvoiceRegisterStatus(PurchaseInvoiceRegisterStatus purchaseInvoiceRegisterStatus) {
        this.mPurchaseInvoiceRegisterStatus = purchaseInvoiceRegisterStatus;
    }

    public BigDecimal getOpenAmountSC(CurrencyType secondaryCurrencyType) {
        switch (secondaryCurrencyType) {
            case SECONDARY_CURRENCY_1: {
                return this.getSeccurr1OpenAmountWithSign();
            }
            case SECONDARY_CURRENCY_2: {
                return this.getSeccurr2OpenAmountWithSign();
            }
            case SECONDARY_CURRENCY_3: {
                return this.getSeccurr3OpenAmountWithSign();
            }
            case SECONDARY_CURRENCY_4: {
                return this.getSeccurr4OpenAmountWithSign();
            }
        }
        throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)secondaryCurrencyType));
    }

    public BigDecimal getAmountSC(CurrencyType secondaryCurrencyType) {
        switch (secondaryCurrencyType) {
            case SECONDARY_CURRENCY_1: {
                return this.getSeccurr1OriginalAmountWithSign();
            }
            case SECONDARY_CURRENCY_2: {
                return this.getSeccurr2OriginalAmountWithSign();
            }
            case SECONDARY_CURRENCY_3: {
                return this.getSeccurr3OriginalAmountWithSign();
            }
            case SECONDARY_CURRENCY_4: {
                return this.getSeccurr4OriginalAmountWithSign();
            }
        }
        throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)secondaryCurrencyType));
    }

    public boolean isInZ4List() {
        if (this.isInZ4List == null) {
            this.isInZ4List = !this.isNew() && Z4PaymentPersistencyManager.isInZ4List((IOpenItem)this);
        }
        return this.isInZ4List;
    }

    public String getKsefNumber() {
        this.requireLoaded();
        return this.ksefNumber;
    }

    public void setKsefNumber(String ksefNumber) {
        this.ksefNumber = ksefNumber;
    }

    public KsefNumberType getKsefNumberType() {
        this.requireLoaded();
        return this.ksefNumberType;
    }

    public void setKsefNumberType(KsefNumberType ksefNumberType) {
        this.ksefNumberType = ksefNumberType;
    }

    public Date getPaymentEffectiveDate() {
        this.requireLoaded();
        return this.paymentEffectiveDate;
    }

    public void setPaymentEffectiveDate(Date paymentEffectiveDate) {
        this.paymentEffectiveDate = paymentEffectiveDate;
    }

    public boolean requiresPaymentEffectiveDate() {
        return !this.isPaymentReceipt() && this.getPersonalAccountEntry() != null && this.getPersonalAccountEntry().requiresPaymentEffectiveDate();
    }
}

