/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.nominaltransactionbase.exchangerate;

import com.varial.accounting.domain.nominaltransactionbase.INominalTransactionBase;
import com.varial.accounting.domain.nominaltransactionbase.TransactionUtils;
import com.varial.accounting.domain.nominaltransactionbase.exchangerate.DefaultExchangeRateStrategy;
import com.varial.accounting.domain.nominaltransactionbase.exchangerate.ExchangeRateStrategy;
import com.varial.accounting.domain.nominaltransactionbase.exchangerate.ExchangeRateStrategyType;
import com.varial.accounting.domain.nominaltransactionbase.exchangerate.FixedTaxBasisDateStrategy;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.isoftware.ISoftware;

public class ExchangeRateStrategyFactory {
    private ExchangeRateStrategyFactory() {
    }

    public static ExchangeRateStrategy selectStrategy(INominalTransactionBase tx) {
        ExchangeRateStrategyType type = ExchangeRateStrategyFactory.determineStrategyType(tx);
        return ExchangeRateStrategyFactory.create(type);
    }

    public static ExchangeRateStrategy create(ExchangeRateStrategyType type) {
        if (type == ExchangeRateStrategyType.FIXED_TAX_BASIS_DATE) {
            return new FixedTaxBasisDateStrategy();
        }
        return new DefaultExchangeRateStrategy();
    }

    public static ExchangeRateStrategyType determineStrategyType(INominalTransactionBase tx) {
        if (TransactionUtils.isForeignCurrencyTransaction((INominalTransactionBase)tx) && tx.isInvoiceTransaction() && tx.getCompany().getJurisdictionType() == JurisdictionType.PL) {
            return ISoftware.isKronospan() || tx.getCompany().getNote() != null && tx.getCompany().getNote().contains("%UseInvRateBaseDateBasedOnTaxcode%") ? ExchangeRateStrategyType.FIXED_TAX_BASIS_DATE : ExchangeRateStrategyType.DEFAULT;
        }
        return ExchangeRateStrategyType.DEFAULT;
    }
}

