/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.invoiceallocation;

import com.infor.igf.core.types.PersistableEnum;
import com.infor.igf.core.util.PersistableEnumUtils;
import com.varial.accounting.domain.batch.Batch;
import com.varial.accounting.domain.claimpaymentdifferences.ClaimPaymentDifferences;
import com.varial.accounting.domain.claimpaymentdifferences.ClaimPaymentDifferencesPersistencyManager;
import com.varial.accounting.domain.claimpaymentdifferences.ClaimPaymentDifferencesSession;
import com.varial.accounting.domain.financesetup.CurrencyType;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.invoiceallocation.AllocationAmount;
import com.varial.accounting.domain.invoiceallocation.AllocationAmountFactory;
import com.varial.accounting.domain.invoiceallocation.AllocationAmountPersistencyManager;
import com.varial.accounting.domain.invoiceallocation.ClaimFollowUpAction;
import com.varial.accounting.domain.invoiceallocation.IInvoiceAllocation;
import com.varial.accounting.domain.invoiceallocation.IInvoiceAllocationAmountBase;
import com.varial.accounting.domain.invoiceallocation.IInvoiceAllocationBase;
import com.varial.accounting.domain.invoiceallocation.InstalmentOpenItemComparator;
import com.varial.accounting.domain.invoiceallocation.InvoiceAllocationBase;
import com.varial.accounting.domain.invoiceallocation.InvoiceAllocationStatus;
import com.varial.accounting.domain.invoiceallocation.InvoiceAllocationType;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocationBalanceManager;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocationData;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocationExceptionMapper;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocationIgnoreCaseComparatorCode;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocationIgnoreCaseComparatorShortAddress;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocationPersistencyManager;
import com.varial.accounting.domain.invoiceallocation.PersonalAccountAdjustmentTransaction;
import com.varial.accounting.domain.invoiceallocation.RemainderOpenItem;
import com.varial.accounting.domain.invoiceallocation.RemainderOpenItemPersistencyManager;
import com.varial.accounting.domain.invoiceallocation.ReturnPaymentAllocationRelPersistencyManager;
import com.varial.accounting.domain.invoiceallocation.adjustment.AdjustmentTransactionManager;
import com.varial.accounting.domain.invoiceallocation.adjustment.association.AssociationAdjustmentBalance;
import com.varial.accounting.domain.invoiceallocation.payment.PaymentOpenItemEffectiveDateResolver;
import com.varial.accounting.domain.invoiceallocation.resolver.InvoiceAllocationExchangeRateResolver;
import com.varial.accounting.domain.invoiceallocation.resolver.InvoiceAllocationPaymentEffectiveDateResolver;
import com.varial.accounting.domain.invoiceallocation.returnpayment.ReturnPaymentStatusEnum;
import com.varial.accounting.domain.nominaltransactionbase.ActTaxationManager;
import com.varial.accounting.domain.nominaltransactionbase.DownPaymentOpenItem;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBase;
import com.varial.accounting.domain.nominaltransactionbase.TransactionHelper;
import com.varial.accounting.domain.nominaltransactionbase.cancellation.CancellationContext;
import com.varial.accounting.domain.openitem.IOpenItem;
import com.varial.accounting.domain.openitem.OpenItem;
import com.varial.accounting.domain.openitem.OpenItemExceptionMapper;
import com.varial.accounting.domain.openitem.dates.PaymentEffectiveDateEntriesUpdater;
import com.varial.accounting.domain.openitem.service.PaymentEffectiveDateService;
import com.varial.accounting.domain.openitemallocationbase.AllocationAmountComparator;
import com.varial.accounting.domain.openitemallocationbase.AllocationBalance;
import com.varial.accounting.domain.openitemallocationbase.AllocationNumberManager;
import com.varial.accounting.domain.openitemallocationbase.IAllocationAmountBase;
import com.varial.accounting.domain.openitemallocationbase.IAllocationBase;
import com.varial.accounting.domain.openitemallocationbase.IRemainderOpenItemBase;
import com.varial.accounting.domain.openitembase.IOpenItemBase;
import com.varial.accounting.domain.openitemstatus.OpenItemStatusManager;
import com.varial.accounting.domain.payment.ConversionRateMap;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.IFinancePaymentSessionPersistencyManager;
import com.varial.accounting.domain.personalaccount.IPersonalAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccountAssociation;
import com.varial.accounting.domain.personalaccountreposting.PersonalAccountReposting;
import com.varial.accounting.domain.sequenceno.SequenceNo;
import com.varial.accounting.domain.sequenceno.SequenceNoMappingManager;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.company.Jurisdiction;
import com.varial.framework.domain.company.JurisdictionFactory;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.currency.ConversionRate;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.user.IUserPersistencyManager;
import com.varial.serverbase.domain.user.User;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import de.varial.accounting.domain.z4session.Z4PaymentPersistencyManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenItemAllocation
extends InvoiceAllocationBase
implements IInvoiceAllocation {
    private static final IUserPersistencyManager userPersistencyManager = (IUserPersistencyManager)UtilitiesManager.getBean((String)"userPersistencyManager", IUserPersistencyManager.class);
    static final String CLASSNAME = OpenItemAllocation.class.getName();
    protected static Logger LOGGER = LoggerFactory.getLogger((String)OpenItemAllocation.class.getName());
    public static final int PRIORITY = 7;
    protected AllocationAmount mPaymentReceipt;
    protected AllocationAmount[] mAllocationAmounts;
    private InvoiceAllocationType mAllocationType;
    private PersonalAccountAdjustmentTransaction mResidueAdjustment;
    private RemainderOpenItem[] mRemainderOpenItems;
    private Date mFactoringESDate;
    private ClaimFollowUpAction mClaimFollowUpAction;
    private ClaimPaymentDifferencesSession mClaimPaymentDifferencesSession;
    private ClaimPaymentDifferences mClaimPaymentDifferences;
    private InvoiceAllocationStatus mStatus;
    private OpenItemAllocation mPaymentOpenItemAllocation;
    private OpenItemAllocation mReversalPaymentOpenItemAllocation;
    private OpenItemAllocation mReturnPaymentOpenItemAllocation;
    private ReturnPaymentStatusEnum mReturnPaymentStatus;
    private PersonalAccountAdjustmentTransaction mForeignCurrencyAdjustment;
    private Batch mBatch;
    private boolean mBatchEmpty = true;
    private User mUser;
    private ConversionRateMap mSeccurr1ConversionRateMap;
    private ConversionRateMap mSeccurr2ConversionRateMap;
    private ConversionRateMap mSeccurr3ConversionRateMap;
    private ConversionRateMap mSeccurr4ConversionRateMap;
    protected Date mPaymentEffectiveDate;
    protected Date mDiscountDate;
    private InvoiceAllocationType mAllocationType_old;
    private Batch mNLBatch;
    private boolean mNLBatchEmpty = true;
    private Batch mNLTransferBatch;
    private boolean mNLTransferBatchEmpty = true;
    private OpenItemStatusManager mOpenItemStatusManager;
    private Jurisdiction mJurisdiction;
    private boolean mAllocationInOCBalanced = false;
    private boolean mDoNotCheckDiscount = false;
    private SequenceNoMappingManager mSequenceNoMappingManager;
    private CancellationContext mCancellationContext;
    private boolean mIsAutomaticProcessing = false;
    private boolean mUpdateFromClaimPaymentDifferencesSession = false;
    private boolean mUpdateFromFactoring = false;
    private String mSequenceNumberForAllocationNumber;
    private boolean mReturnPaymentOpenItemAllocationLoaded = false;
    private boolean mPaymentOpenItemAllocationLoaded = false;
    private boolean mReversalPaymentOpenItemAllocationLoaded = false;
    private boolean mJournaliseAdjustments = false;
    private boolean mFromGenerateDownPayment = false;
    private boolean mReversalTransaction = false;
    private PersonalAccountReposting mPersonalAccountReposting;
    private ReturnPaymentStatusEnum mReturnPaymentStatus_old;
    private boolean mChangedReturnPaymentStatus = false;
    private Boolean isInZ4List;

    public OpenItemAllocation(AccountingCompany company, FinancialYear year, Date allocationDate, PersonalAccountAssociation association, PersonalAccount personalAccount, boolean withSubAccounts) {
        super(company, year, allocationDate, association, personalAccount, withSubAccounts, 7);
        this.mReturnPaymentStatus = ReturnPaymentStatusEnum.RPSE_NONE;
    }

    public OpenItemAllocation(NominalTransactionBase transaction, InvoiceAllocationType allocationType, PersonalAccountAssociation association, PersonalAccount personalAccount) {
        super(transaction.getBatch().getCompany(), transaction.getFinancialYear(), transaction.getTransactionDate(), association, personalAccount, false, 7);
        this.mAllocationType = allocationType;
        this.mReturnPaymentStatus = ReturnPaymentStatusEnum.RPSE_NONE;
    }

    public OpenItemAllocation(FinancialYear financialYear, Date transactionDate, InvoiceAllocationType allocationType, PersonalAccount personalAccount) {
        super(financialYear.getCompany(), financialYear, transactionDate, null, personalAccount, false, 7);
        this.mAllocationType = allocationType;
        this.mReturnPaymentStatus = ReturnPaymentStatusEnum.RPSE_NONE;
    }

    public OpenItemAllocation(OpenItem prepaidOpenItem, DownPaymentOpenItem[] downPaymentOpenItems) throws BusinessDomainException {
        super(prepaidOpenItem.getPersonalAccountEntry().getTransaction().getCompany(), prepaidOpenItem.getPersonalAccountEntry().getTransaction().getFinancialYear(), prepaidOpenItem.getPersonalAccountEntry().getTransaction().getTransactionDate(), null, prepaidOpenItem.getPersonalAccountEntry().getPersonalAccount(), false, 4);
        this.mReturnPaymentStatus = ReturnPaymentStatusEnum.RPSE_NONE;
        this.mAllocationType = InvoiceAllocationType.DOWNPAYMENT;
        ConversionRate conversionRate = prepaidOpenItem.getPersonalAccountEntry().getTransaction().getConversionRate();
        this.setPaymentReceipt(AllocationAmountFactory.createAllocationAmount((OpenItem)prepaidOpenItem, (OpenItemAllocation)this, (ConversionRate)conversionRate, (boolean)true));
        AllocationAmount[] allocationAmounts = new AllocationAmount[downPaymentOpenItems.length];
        for (int i = 0; i < allocationAmounts.length; ++i) {
            if (!prepaidOpenItem.getPersonalAccountEntry().getTransaction().getEnteredCurrency().equals(downPaymentOpenItems[i].getDownPayment().getEnteredCurrency())) {
                throw OpenItemAllocationExceptionMapper.makeDownPaymentAllocationInDifferentCurrenciesNotAllowedDomainException();
            }
            allocationAmounts[i] = AllocationAmountFactory.createAllocationAmount((DownPaymentOpenItem)downPaymentOpenItems[i], (OpenItemAllocation)this, (ConversionRate)conversionRate);
        }
        this.setAllocationAmounts(allocationAmounts);
        this.rework();
    }

    public OpenItemAllocation(String objectid) {
        super(7, objectid);
    }

    public OpenItemAllocation(String objectid, int version) {
        super(7, objectid, version);
    }

    public OpenItemAllocation(boolean readOnly) {
        super(7, readOnly);
    }

    public Jurisdiction getJurisdiction() {
        if (this.mJurisdiction == null) {
            this.mJurisdiction = JurisdictionFactory.getJurisdiction((JurisdictionType)this.getCompany().getJurisdictionType());
        }
        return this.mJurisdiction;
    }

    protected void load() {
        OpenItemAllocationPersistencyManager.load((OpenItemAllocation)this);
    }

    protected void deleteImpl() {
        OpenItemAllocationPersistencyManager.delete((OpenItemAllocation)this);
    }

    public String getClassName() {
        return CLASSNAME;
    }

    public String getDomainKey() {
        return this.getCompany().getDomainKey() + "/" + DateMapper.toString((Date)this.getAllocationDate());
    }

    protected void saveImpl() {
        OpenItemAllocationPersistencyManager.save((OpenItemAllocation)this);
        if (this.changedReturnPaymentStatus() || !this.updateFromClaimPaymentDifferencesSession()) {
            this.registerForLastExecute();
        }
    }

    protected void lastExecuteImpl() throws BusinessDomainException {
        if (!this.updateFromClaimPaymentDifferencesSession()) {
            OpenItemAllocationPersistencyManager.updatePaymentReceipt((OpenItemAllocation)this);
        }
        if (this.mChangedReturnPaymentStatus) {
            AllocationAmountPersistencyManager.updateReturnPaymentStatus((OpenItemAllocation)this);
        }
    }

    public boolean updateFromClaimPaymentDifferencesSession() {
        return this.mUpdateFromClaimPaymentDifferencesSession;
    }

    public void setUpdateFromClaimPaymentDifferencesSession(boolean fromSession) {
        this.mUpdateFromClaimPaymentDifferencesSession = fromSession;
    }

    public boolean updateFromFactoring() {
        return this.mUpdateFromFactoring;
    }

    public void setUpdateFromFactoring(boolean fromFactoring) {
        this.mUpdateFromFactoring = fromFactoring;
    }

    protected void destroyImpl() throws BusinessDomainException {
        AllocationAmount[] allocationAmounts;
        this.checkForDestroy();
        if (this.isReturnPayment()) {
            OpenItemAllocation[] paymentOpenItemAllocations;
            OpenItemAllocation[] reversalPaymentOpenItemAllocations = ReturnPaymentAllocationRelPersistencyManager.getReversalPaymentOpenItemAllocations((OpenItemAllocation)this);
            if (reversalPaymentOpenItemAllocations != null) {
                HashMap<String, String> openItemAllocationMap = new HashMap<String, String>();
                for (int i = 0; i < reversalPaymentOpenItemAllocations.length; ++i) {
                    AllocationAmount[] allocationAmountArray;
                    reversalPaymentOpenItemAllocations[i].makeSaveable();
                    reversalPaymentOpenItemAllocations[i].destroy();
                    AllocationAmount[] allocationAmountArray2 = allocationAmountArray = reversalPaymentOpenItemAllocations[i].getAllocationAmounts();
                    int n = allocationAmountArray2.length;
                    for (int j = 0; j < n; ++j) {
                        AllocationAmount[] allocationAmounts2;
                        AllocationAmount allocationAmount = allocationAmountArray2[j];
                        OpenItem openItem = allocationAmount.getOpenItem();
                        for (AllocationAmount aa : allocationAmounts2 = openItem.getAllocationAmounts()) {
                            openItemAllocationMap.put(aa.getOpenItemAllocation().getObjectid(), aa.getOpenItemAllocation().getObjectid());
                        }
                    }
                }
                for (String string : openItemAllocationMap.values()) {
                    if (ReturnPaymentAllocationRelPersistencyManager.existsOpenItemAllocation((String)string)) continue;
                    throw OpenItemAllocationExceptionMapper.makeDeleteReturnPaymentNotAllowedDomainException((String)"");
                }
            }
            if ((paymentOpenItemAllocations = ReturnPaymentAllocationRelPersistencyManager.getPaymentOpenItemAllocations((OpenItemAllocation)this)) != null) {
                for (int i = 0; i < paymentOpenItemAllocations.length; ++i) {
                    paymentOpenItemAllocations[i].makeSaveable();
                    paymentOpenItemAllocations[i].setReturnPaymentStatus(ReturnPaymentStatusEnum.RPSE_NONE);
                }
            }
            ReturnPaymentAllocationRelPersistencyManager.deleteAll((OpenItemAllocation)this);
        }
        List<Batch> batches = this.getBatches();
        if (this.getPaymentReceipt() != null) {
            if (!this.isNew()) {
                OpenItemAllocationPersistencyManager.setPaymentReceiptToNull((OpenItemAllocation)this);
            }
            if (this.getPaymentReceipt().isNew()) {
                this.getPaymentReceipt().makeReadOnly();
            } else {
                this.getPaymentReceipt().makeSaveable();
                this.getPaymentReceipt().destroy();
                this.removeCostUnitForConstructionWork();
            }
        }
        List<PersonalAccountAdjustmentTransaction> adjustments = this.getAdjustmentTransactions();
        for (PersonalAccountAdjustmentTransaction personalAccountAdjustmentTransaction : adjustments) {
            AdjustmentTransactionManager.deleteAdjustmentTransaction((PersonalAccountAdjustmentTransaction)personalAccountAdjustmentTransaction, (CancellationContext)this.getCancellationContext(), (boolean)this.getJournaliseAdjustments());
        }
        new PaymentEffectiveDateService(new PaymentEffectiveDateEntriesUpdater()).clearEffectiveDates(this);
        for (AllocationAmount allocationAmount : allocationAmounts = this.getAllocationAmounts()) {
            allocationAmount.makeSaveable();
            allocationAmount.destroy();
        }
        if (!this.mNLTransferBatchEmpty) {
            this.getNLTransferBatch().close();
        }
        RemainderOpenItem[] remainderOpenItemArray = this.getRemainderOpenItems();
        for (RemainderOpenItem remainderOpenItem : remainderOpenItemArray) {
            remainderOpenItem.makeSaveable();
            remainderOpenItem.destroy();
        }
        if (this.getClaimPaymentDifferences() != null) {
            this.getClaimPaymentDifferences().makeSaveable();
            this.getClaimPaymentDifferences().destroy();
        }
        for (Batch batch : batches) {
            if (!batch.isEmpty()) continue;
            batch.makeSaveable();
            batch.destroy();
        }
    }

    private void checkForDestroy() throws BusinessDomainException {
        FinancePaymentSession[] paymentSessions;
        if (this.isPostedBack()) {
            throw OpenItemAllocationExceptionMapper.makePostedBackAllocationCannotBeDeletedDomainException();
        }
        if (this.isDownPayment() && !this.getIsAutomaticProcessing()) {
            throw OpenItemAllocationExceptionMapper.makeDownPaymentAllocationCannotBeChangedDomainException();
        }
        if (!this.isPlaceholder() && !ISoftware.getDoNotCheckAllocationDateWhenDeleting()) {
            this.checkAllocationDate(true);
        }
        if (this.isInstalment() && !this.getIsAutomaticProcessing()) {
            throw OpenItemAllocationExceptionMapper.makeInstalmentAllocationCannotBeDeletedDomainException();
        }
        if (this.isReverseFactoring() && (paymentSessions = ((IFinancePaymentSessionPersistencyManager)UtilitiesManager.getBean((String)"financePaymentSessionPersistencyManager", IFinancePaymentSessionPersistencyManager.class)).getSessionsByOpenItemAllocation(this)) != null && paymentSessions.length > 0) {
            throw OpenItemAllocationExceptionMapper.makeInvoiceAllocationIncludedInReverseFactoringSessionDomainException((String)paymentSessions[0].getName());
        }
        if (this.isInZ4List()) {
            throw OpenItemAllocationExceptionMapper.makeInvoiceAllocationIsInZ4ListDomainException();
        }
    }

    public void setIsAutomaticProcessing(boolean isAutomaticProcessing) {
        this.mIsAutomaticProcessing = isAutomaticProcessing;
    }

    public boolean getIsAutomaticProcessing() {
        return this.mIsAutomaticProcessing;
    }

    protected void setData(OpenItemAllocationData data) {
        super.setData(data.getOpenItemAllocationBaseData());
        this.mPaymentReceipt = data.getPaymentReceipt();
        this.mAllocationType = data.getAllocationType();
        this.mResidueAdjustment = data.getResidueAdjustment();
        this.mFactoringESDate = data.getFactoringESDate();
        this.mClaimFollowUpAction = data.getClaimFollowUpAction();
        this.mClaimPaymentDifferencesSession = data.getClaimPaymentDifferencesSession();
        this.mStatus = data.getStatus();
        this.mReturnPaymentStatus = data.getReturnPaymentStatus();
        this.mForeignCurrencyAdjustment = data.getForeignCurrencyAdjustmentt();
        this.mAllocationType_old = data.getAllocationType();
        this.mReturnPaymentStatus_old = data.getReturnPaymentStatus();
    }

    protected boolean getAllocationInOCBalanced() {
        return this.mAllocationInOCBalanced;
    }

    public void setAllocationInOCBalanced(boolean allocationInOCBalanced) {
        this.mAllocationInOCBalanced = allocationInOCBalanced;
    }

    public CancellationContext getCancellationContext() {
        return this.mCancellationContext;
    }

    public void setCancellationContext(CancellationContext context) {
        this.mCancellationContext = context;
    }

    public void setClaimPaymentDifferencesSession(ClaimPaymentDifferencesSession claimPaymentDifferencesSession) {
        this.mClaimPaymentDifferencesSession = claimPaymentDifferencesSession;
    }

    public ClaimPaymentDifferencesSession getClaimPaymentDifferencesSession() {
        if (this.mClaimPaymentDifferencesSession == null) {
            this.requireLoaded();
        }
        return this.mClaimPaymentDifferencesSession;
    }

    public void setClaimFollowUpAction(ClaimFollowUpAction claimFollowUpAction) {
        this.mClaimFollowUpAction = claimFollowUpAction;
    }

    public ClaimFollowUpAction getClaimFollowUpAction() {
        this.requireLoaded();
        if (this.mClaimFollowUpAction == null) {
            this.mClaimFollowUpAction = ClaimFollowUpAction.NOTHING;
        }
        return this.mClaimFollowUpAction;
    }

    public void setStatus(InvoiceAllocationStatus status) {
        if (status != null && status == InvoiceAllocationStatus.FREE_FOR_ADJUSTMENT && this.getAllocationType() == InvoiceAllocationType.DONE) {
            this.setAllocationType(InvoiceAllocationType.NOTDONE);
        }
        this.mStatus = status;
    }

    public InvoiceAllocationStatus getStatus() {
        this.requireLoaded();
        if (this.mStatus == null) {
            this.mStatus = InvoiceAllocationStatus.NONE;
        }
        return this.mStatus;
    }

    public ClaimPaymentDifferences getClaimPaymentDifferences() {
        this.requireLoaded();
        if (this.mClaimPaymentDifferences == null && !this.isNew() && this.getClaimPaymentDifferencesSession() != null) {
            this.mClaimPaymentDifferences = ClaimPaymentDifferencesPersistencyManager.getClaimPaymentDifferences((OpenItemAllocation)this);
        }
        return this.mClaimPaymentDifferences;
    }

    public void setResidueAdjustment(PersonalAccountAdjustmentTransaction residueAdjustment) throws BusinessDomainException {
        if (this.mResidueAdjustment != null) {
            if (residueAdjustment == null || residueAdjustment.isNew()) {
                AdjustmentTransactionManager.deleteAdjustmentTransaction((PersonalAccountAdjustmentTransaction)this.mResidueAdjustment, (CancellationContext)this.getCancellationContext(), (boolean)this.getJournaliseAdjustments());
            } else if (!PersistentObjectUtils.haveEqualObjectids((IPersistentObject)this.mResidueAdjustment, (IPersistentObject)residueAdjustment)) {
                throw ExceptionMapper.makeApplicationException((String)"wrong objectid for residue adjustment");
            }
        }
        this.mResidueAdjustment = residueAdjustment;
    }

    public PersonalAccountAdjustmentTransaction getResidueAdjustment() {
        this.requireLoaded();
        return this.mResidueAdjustment;
    }

    public AllocationAmount getPaymentReceipt() {
        this.requireLoaded();
        return this.mPaymentReceipt;
    }

    public void setPaymentReceipt(AllocationAmount paymentReceipt) throws BusinessDomainException {
        this.getAllocationAmounts();
        if (this.getPaymentReceipt() != null && paymentReceipt != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)this.mPaymentReceipt, (IPersistentObject)paymentReceipt)) {
            throw ExceptionMapper.makeApplicationException((String)"OpenItemAllocation.setPaymentReceipt: wrong payment/receipt for allocation");
        }
        if (this.mPaymentReceipt != null && paymentReceipt == null) {
            if (this.getClaimPaymentDifferencesSession() != null) {
                throw OpenItemAllocationExceptionMapper.makeAmendingNotAllowedBecauseClaimPaymentDifferencesSessionDomainException();
            }
            this.mPaymentReceipt.makeSaveable();
            this.mPaymentReceipt.destroy();
        }
        this.mPaymentReceipt = paymentReceipt;
    }

    public Date getPaymentEffectiveDate() {
        this.requireLoaded();
        if (this.mPaymentEffectiveDate == null) {
            this.mPaymentEffectiveDate = InvoiceAllocationPaymentEffectiveDateResolver.resolve((IInvoiceAllocation)this);
        }
        return this.mPaymentEffectiveDate;
    }

    public void setPaymentEffectiveDate(Date paymentEffectiveDate) {
        this.mPaymentEffectiveDate = paymentEffectiveDate;
    }

    public Date getDiscountDate() {
        if (this.mDiscountDate == null && this.getPaymentReceipt() != null) {
            this.mDiscountDate = PaymentOpenItemEffectiveDateResolver.resolve((IOpenItem)this.getPaymentReceipt().getOpenItem());
        }
        return this.mDiscountDate;
    }

    public void setDiscountDate(OpenItem paymentReceipt) {
        this.mDiscountDate = PaymentOpenItemEffectiveDateResolver.resolve((IOpenItem)paymentReceipt);
    }

    public InvoiceAllocationType getAllocationType() {
        this.requireLoaded();
        return this.mAllocationType;
    }

    public void setAllocationType(InvoiceAllocationType allocationType) {
        if (!this.isNew() && this.getStatus() == InvoiceAllocationStatus.FREE_FOR_ADJUSTMENT && allocationType == InvoiceAllocationType.DONE && this.getAllocationType() == InvoiceAllocationType.NOTDONE) {
            this.setStatus(InvoiceAllocationStatus.ADJUSTED);
        }
        this.protocol("allocationtype", PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)this.mAllocationType), PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)allocationType));
        this.mAllocationType = allocationType;
    }

    public AllocationAmount[] getAllocationAmounts() {
        this.requireLoaded();
        if (this.mAllocationAmounts == null) {
            if (!this.isNew()) {
                this.mAllocationAmounts = this.mPaymentReceipt == null ? AllocationAmountPersistencyManager.getAllocationAmounts((OpenItemAllocation)this) : AllocationAmountPersistencyManager.getAllocationAmounts((OpenItemAllocation)this, (AllocationAmount)this.mPaymentReceipt);
            }
            if (this.mAllocationAmounts == null) {
                this.mAllocationAmounts = new AllocationAmount[0];
            }
        }
        return this.mAllocationAmounts;
    }

    public AllocationAmount[] getSortedAllocationAmounts() {
        AllocationAmount[] allocationAmounts = this.getAllocationAmounts();
        if (allocationAmounts != null && allocationAmounts.length > 1) {
            Arrays.sort(allocationAmounts, AllocationAmountComparator.getComparator());
        }
        return allocationAmounts;
    }

    public void setAllocationAmounts(AllocationAmount[] allocationAmounts) throws BusinessDomainException {
        this.setSortingNumbers(allocationAmounts);
        this.mAllocationAmounts = PersistentObjectUtils.removeUnusedObjects((IPersistentObject[])this.getAllocationAmounts(), (IPersistentObject[])allocationAmounts).toArray(new AllocationAmount[0]);
    }

    public void setAllocationAmounts(List<AllocationAmount> allocationAmounts) {
        this.mAllocationAmounts = new AllocationAmount[allocationAmounts.size()];
        allocationAmounts.toArray(this.mAllocationAmounts);
    }

    public Batch getBatch() throws BusinessDomainException {
        if (this.mBatch == null) {
            this.mBatch = new Batch(this.getCompany(), this.getUser(), true);
            this.mBatchEmpty = false;
        }
        return this.mBatch;
    }

    private boolean getBatchEmpty() {
        return this.mBatchEmpty;
    }

    public void setBatchToNull() {
        this.mBatch = null;
        this.mBatchEmpty = true;
    }

    public void setBatch(Batch batch) {
        this.mBatch = batch;
        this.mBatchEmpty = false;
    }

    public Batch getNLBatch() throws BusinessDomainException {
        if (this.mNLBatch == null) {
            this.mNLBatch = new Batch(this.getCompany(), this.getUser(), true);
            this.mNLBatchEmpty = false;
        }
        return this.mNLBatch;
    }

    private boolean getNLBatchEmpty() {
        return this.mNLBatchEmpty;
    }

    public void setNLBatchToNull() {
        this.mNLBatch = null;
        this.mNLBatchEmpty = true;
    }

    public Batch getNLTransferBatch() throws BusinessDomainException {
        if (this.mNLTransferBatch == null) {
            this.mNLTransferBatch = new Batch(this.getCompany(), this.getUser(), true);
            this.mNLTransferBatchEmpty = false;
        }
        return this.mNLTransferBatch;
    }

    private boolean getNLTransferBatchEmpty() {
        return this.mNLTransferBatchEmpty;
    }

    private User getUser() {
        if (this.mUser == null) {
            this.mUser = userPersistencyManager.query(SessionContext.getInstance().getSession().getUserCode());
        }
        return this.mUser;
    }

    public void setUser(User user) {
        this.mUser = user;
    }

    public void setSeccurrConversionRates(OpenItem paymentReceiptOpenItem) {
        if (this.getFinanceSetup().hasParallelCurrencies()) {
            CurrencyType currencyType = CurrencyType.SECONDARY_CURRENCY_1;
            int i = 0;
            while (currencyType != null) {
                ConversionRateMap rateMap = new ConversionRateMap(this.getFinanceSetup(), currencyType, InvoiceAllocationExchangeRateResolver.resolveExchangeRateDate((OpenItemAllocation)this), (IOpenItemBase)paymentReceiptOpenItem, InvoiceAllocationExchangeRateResolver.resolveConversionTableType((OpenItemAllocation)this));
                if (i == 0) {
                    this.mSeccurr1ConversionRateMap = rateMap;
                    currencyType = CurrencyType.SECONDARY_CURRENCY_2;
                } else if (i == 1) {
                    this.mSeccurr2ConversionRateMap = rateMap;
                    currencyType = CurrencyType.SECONDARY_CURRENCY_3;
                } else if (i == 2) {
                    this.mSeccurr3ConversionRateMap = rateMap;
                    currencyType = CurrencyType.SECONDARY_CURRENCY_4;
                } else if (i == 3) {
                    this.mSeccurr4ConversionRateMap = rateMap;
                    currencyType = null;
                }
                ++i;
            }
        }
    }

    public ConversionRateMap makeConversionRateMap() {
        ConversionRateMap conversionRateMap = new ConversionRateMap(this.getFinanceSetup(), CurrencyType.BASE_CURRENCY, InvoiceAllocationExchangeRateResolver.resolveExchangeRateDate((OpenItemAllocation)this), null, InvoiceAllocationExchangeRateResolver.resolveConversionTableType((OpenItemAllocation)this));
        if (this.getPaymentReceipt() != null) {
            conversionRateMap.addRate(this.getPaymentReceipt());
        }
        for (int i = 0; i < this.getAllocationAmounts().length; ++i) {
            conversionRateMap.addRate(this.getAllocationAmounts()[i]);
        }
        return conversionRateMap;
    }

    public ConversionRateMap getSeccurr1ConversionRateMap() {
        return this.mSeccurr1ConversionRateMap;
    }

    public ConversionRateMap getSeccurr2ConversionRateMap() {
        return this.mSeccurr2ConversionRateMap;
    }

    public ConversionRateMap getSeccurr3ConversionRateMap() {
        return this.mSeccurr3ConversionRateMap;
    }

    public ConversionRateMap getSeccurr4ConversionRateMap() {
        return this.mSeccurr4ConversionRateMap;
    }

    public boolean isDownPayment() {
        return this.getAllocationType() == InvoiceAllocationType.DOWNPAYMENT;
    }

    public boolean isInstalment() {
        return this.getAllocationType() == InvoiceAllocationType.INSTALMENT;
    }

    public boolean isReverseFactoring() {
        return this.getAllocationType() == InvoiceAllocationType.REVERSE_FACTORING;
    }

    private void setSortingNumbers(AllocationAmount[] allocationAmounts) {
        if (allocationAmounts == null) {
            return;
        }
        for (int i = 0; i < allocationAmounts.length; ++i) {
            allocationAmounts[i].setAllocationAmountNumber(i);
        }
    }

    private void checkPersonalAccount(PersonalAccount personalAccount, PersonalAccount openItemPA) throws BusinessDomainException {
        if (!openItemPA.getAccountingCompany().equals((Object)this.getCompany())) {
            throw OpenItemAllocationExceptionMapper.makeOpenItemNotInCompanyDomainException((String)openItemPA.getCode());
        }
        if (this.getAllocationType() != InvoiceAllocationType.REPOSTING && this.getAllocationType() != InvoiceAllocationType.REVERSE_FACTORING) {
            if (this.getAssociation() != null) {
                if (!this.getAssociation().hasAccount((IPersonalAccount)openItemPA)) {
                    throw OpenItemAllocationExceptionMapper.makePersonalAccountNotInAssociationDomainException((String)openItemPA.getCode());
                }
            } else if (!openItemPA.equals((Object)personalAccount)) {
                if (this.getWithSubAccounts()) {
                    if (openItemPA.getParentAccount() == null || !openItemPA.getParentAccount().equals((Object)personalAccount)) {
                        throw OpenItemAllocationExceptionMapper.makeAllocationForDifferentPersonalAccountsNotAllowedDomainException();
                    }
                } else {
                    throw OpenItemAllocationExceptionMapper.makeAllocationForDifferentPersonalAccountsNotAllowedDomainException();
                }
            }
        }
    }

    private void checkAllocationDate(boolean deleting) throws BusinessDomainException {
        if (this.getFinanceSetup().getPostBlockDateFrom() != null && DateHelper.before((Date)this.getAllocationDate(), (Date)this.getFinanceSetup().getPostBlockDateFrom()) || this.getFinanceSetup().getPostBlockDateTo() != null && DateHelper.after((Date)this.getAllocationDate(), (Date)this.getFinanceSetup().getPostBlockDateTo())) {
            if (deleting) {
                if (!this.mReversalTransaction) {
                    throw OpenItemAllocationExceptionMapper.makeDeletingNotPossibleAsAllocationDateIsNotWithinTheValidTransactionPeriodDomainException((String)DateMapper.toString((Date)this.getAllocationDate()));
                }
                throw OpenItemAllocationExceptionMapper.makeReverseAllocationFromClosedPeriodDomainException((String)DateMapper.toString((Date)this.getAllocationDate()));
            }
            throw OpenItemAllocationExceptionMapper.makeAllocationDateIsNotWithinTheValidTransactionPeriodDomainException((String)DateMapper.toString((Date)this.getAllocationDate()));
        }
    }

    public void rework() throws BusinessDomainException {
        this.rework(true);
    }

    public void rework(boolean closeBatch) throws BusinessDomainException {
        this.checkAllocationDate(false);
        if (this.isCancellation() || this.isPlaceholder()) {
            return;
        }
        this.checkIfEmptyAllocation();
        this.checkPersonalAccount();
        this.checkIfTransactionDateAfterAllocationDate();
        this.calculateTotalAmount();
        this.checkRemainderOpenItems();
        this.checkCurrency();
        AllocationBalance allocationBalance = this.getAllocationBalance();
        this.checkAndAdjustAllocationBalance(allocationBalance);
        boolean generateFCAdjustment = !BigDecimalMapper.isZeroOrNull((BigDecimal)allocationBalance.totalAmountOC) || this.getRemainderOpenItems().length > 0 || this.isAllocationInDifferentCurrencies();
        this.adjustForeignCurrencyAdjustment(generateFCAdjustment);
        if (this.getPaymentReceipt() != null) {
            this.getPaymentReceipt().adjustConversionAdjustment();
            this.getPaymentReceipt().getOpenItem().addToOpenItem(this.getPaymentReceipt());
            this.getPaymentReceipt().checkAllocationAmount();
        }
        for (AllocationAmount allocationAmount : this.getAllocationAmounts()) {
            allocationAmount.adjustConversionAdjustment();
            allocationAmount.getOpenItem().addToOpenItem(allocationAmount);
            allocationAmount.checkAllocationAmount();
            allocationAmount.adjustAssociationAdjustment();
            allocationAmount.adjustForeignCurrencyAdjustment(generateFCAdjustment, null);
            allocationAmount.setAllocationNumberInAdjustments(allocationAmount.getOpenItem().getAllocationNumber());
        }
        String allocationNumberRemainderOI = AllocationNumberManager.getAllocationNumberForRemainderOpenItem((IAllocationBase)this);
        for (RemainderOpenItem remainderOpenItem : this.getRemainderOpenItems()) {
            remainderOpenItem.adjustAssociationAdjustment();
            remainderOpenItem.adjustForeignCurrencyAdjustment(generateFCAdjustment);
            if (this.isReposting()) continue;
            if (!remainderOpenItem.getOpenItem().isAllocated()) {
                remainderOpenItem.getOpenItem().setAllocationNumber(allocationNumberRemainderOI);
            }
            remainderOpenItem.setAllocationNumberInAdjustments(allocationNumberRemainderOI);
        }
        if (this.getPaymentReceipt() != null) {
            this.getPaymentReceipt().adjustForeignCurrencyAdjustment(generateFCAdjustment, this.getAssociationAdjustmentBalance());
            this.getPaymentReceipt().setAllocationNumberInAdjustments(this.getPaymentReceipt().getOpenItem().getAllocationNumber());
        }
        if (closeBatch && !this.getBatchEmpty()) {
            this.getBatch().close(false);
        }
        if (!this.getNLTransferBatchEmpty()) {
            this.getNLTransferBatch().close(false);
        }
        if (!this.isReposting() && !this.isDownPayment()) {
            this.updateActTaxationData();
        }
        new PaymentEffectiveDateService(new PaymentEffectiveDateEntriesUpdater()).updateEffectiveDatesIfAllocated(this);
        this.setCostUnitForConstructionWork();
    }

    private void setCostUnitForConstructionWork() throws BusinessDomainException {
        if (this.shouldBeSetCostUnitForConstructionWork() && this.getAllocationAmounts().length > 0) {
            this.getPaymentReceipt().getOpenItem().setCostUnit(this.getAllocationAmounts()[0].getOpenItem().getCostUnit(), false);
            this.getPaymentReceipt().getOpenItem().setDownPaymentTaxCode(this.getAllocationAmounts()[0].getOpenItem().getUsedTaxCode(), false);
            this.getPaymentReceipt().getOpenItem().setIsInputTax(this.getAllocationAmounts()[0].getOpenItem().getPersonalAccount().isSupplier(), false);
        }
    }

    private void removeCostUnitForConstructionWork() throws BusinessDomainException {
        if (!this.isPlaceholder() && this.shouldBeSetCostUnitForConstructionWork()) {
            this.getPaymentReceipt().getOpenItem().setCostUnit(null);
            this.getPaymentReceipt().getOpenItem().setDownPaymentTaxCode(null);
        }
    }

    private boolean shouldBeSetCostUnitForConstructionWork() {
        return this.getCompany().getFinanceSetup().getCostingForConstructionWork(this.getPersonalAccount()) && this.getPaymentReceipt() != null && !this.getPaymentReceipt().getOpenItem().isDownPayment();
    }

    private void checkCurrency() throws BusinessDomainException {
        if (this.isDownPayment() && this.isAllocationInDifferentCurrencies()) {
            throw OpenItemAllocationExceptionMapper.makeDownPaymentAllocationInDifferentCurrenciesNotAllowedDomainException();
        }
    }

    private void checkIfTransactionDateAfterAllocationDate() throws BusinessDomainException {
        boolean checkTransactionDateAfterAllocationDate;
        boolean bl = checkTransactionDateAfterAllocationDate = !ISoftware.getTransactionDateAfterAllocationDate();
        if (this.getPaymentReceipt() != null) {
            this.checkTransactionDateAfterAllocationDate(this.getPaymentReceipt().getOpenItem(), checkTransactionDateAfterAllocationDate);
        }
        for (AllocationAmount allocationAmount : this.getAllocationAmounts()) {
            this.checkTransactionDateAfterAllocationDate(allocationAmount.getOpenItem(), checkTransactionDateAfterAllocationDate);
        }
    }

    private void checkPersonalAccount() throws BusinessDomainException {
        PersonalAccount personalAccount = this.getPersonalAccountForCheck();
        if (this.getPaymentReceipt() != null) {
            this.checkPersonalAccount(personalAccount, this.getPaymentReceipt().getOpenItem().getPersonalAccount());
        }
        if (this.getResidueAdjustment() != null) {
            this.checkPersonalAccount(personalAccount, this.getResidueAdjustment().getPersonalAccountEntry().getPersonalAccount());
        }
        for (AllocationAmount allocationAmount : this.getAllocationAmounts()) {
            this.checkPersonalAccount(personalAccount, allocationAmount.getOpenItem().getPersonalAccount());
        }
        for (AllocationAmount allocationAmount : this.getRemainderOpenItems()) {
            this.checkPersonalAccount(personalAccount, allocationAmount.getOpenItem().getPersonalAccount());
        }
    }

    private AssociationAdjustmentBalance getAssociationAdjustmentBalance() {
        AssociationAdjustmentBalance associationBalance = new AssociationAdjustmentBalance(this.getPaymentReceipt(), this.getFinanceSetup().getBaseCurrency());
        for (AllocationAmount allocationAmount : this.getAllocationAmounts()) {
            associationBalance.addToBalance(allocationAmount.getAssociationAdjustment());
        }
        for (AllocationAmount allocationAmount : this.getRemainderOpenItems()) {
            associationBalance.addToBalance(allocationAmount.getAssociationAdjustment());
        }
        return associationBalance;
    }

    private void checkRemainderOpenItems() throws BusinessDomainException {
        for (RemainderOpenItem remainderOpenItem : this.getRemainderOpenItems()) {
            this.checkRemainderOpenItem(remainderOpenItem.getOpenItem());
        }
    }

    public boolean isAllocationInDifferentCurrencies() {
        ICurrency foreignCurrency = null;
        if (this.getPaymentReceipt() != null) {
            foreignCurrency = this.getPaymentReceipt().getOpenItem().getEnteredCurrency();
        }
        if (this.getResidueAdjustment() != null) {
            if (foreignCurrency == null) {
                foreignCurrency = this.getResidueAdjustment().getEnteredCurrency();
            } else if (!foreignCurrency.equals(this.getResidueAdjustment().getEnteredCurrency())) {
                return true;
            }
        }
        if (this.getAllocationAmounts().length > 0) {
            if (foreignCurrency == null) {
                foreignCurrency = this.getAllocationAmounts()[0].getOpenItem().getEnteredCurrency();
            }
            for (AllocationAmount allocationAmount : this.getAllocationAmounts()) {
                if (foreignCurrency.equals(allocationAmount.getOpenItem().getEnteredCurrency())) continue;
                return true;
            }
        }
        return false;
    }

    private void calculateTotalAmount() throws BusinessDomainException {
        if (this.getPaymentReceipt() != null && !this.isCurrencyRevaluation()) {
            this.getPaymentReceipt().calculateTotalAmount();
        }
        for (AllocationAmount allocationAmount : this.getAllocationAmounts()) {
            allocationAmount.adjustDiscountAdjustment();
            allocationAmount.calculateTotalAmount();
        }
    }

    private void checkIfEmptyAllocation() throws BusinessDomainException {
        if (this.getPaymentReceipt() == null && this.getAllocationAmounts().length == 0 && this.getRemainderOpenItems().length == 0) {
            throw OpenItemAllocationExceptionMapper.makeNotBalancedDomainException((String)"");
        }
    }

    private PersonalAccount getPersonalAccountForCheck() {
        if (this.getPaymentReceipt() != null) {
            return this.getPaymentReceipt().getOpenItem().getPersonalAccount();
        }
        if (this.getAllocationAmounts().length > 0) {
            return this.getAllocationAmounts()[0].getOpenItem().getPersonalAccount();
        }
        if (this.getRemainderOpenItems().length > 0) {
            return this.getRemainderOpenItems()[0].getOpenItem().getPersonalAccount();
        }
        return null;
    }

    public AllocationBalance getAllocationBalance() {
        AllocationBalance balance = new AllocationBalance();
        if (this.getPaymentReceipt() != null) {
            balance.addToBalance((IAllocationAmountBase)this.getPaymentReceipt());
        }
        if (this.getResidueAdjustment() != null) {
            balance.addToBalance((NominalLedgerEntry)this.getResidueAdjustment().getPersonalAccountEntry(), this.getFinanceSetup().hasParallelCurrencies());
        }
        for (AllocationAmount allocationAmount : this.getAllocationAmounts()) {
            balance.addToBalance((IAllocationAmountBase)allocationAmount);
        }
        for (AllocationAmount allocationAmount : this.getRemainderOpenItems()) {
            balance.addToBalance((IOpenItemBase)allocationAmount.getOpenItem());
        }
        if (this.getAllocationInOCBalanced()) {
            balance.totalAmountOC = BigDecimal.ZERO;
        }
        return balance;
    }

    private void checkAndAdjustAllocationBalance(AllocationBalance balance) throws BusinessDomainException {
        if (balance.totalAmountBC.signum() != 0) {
            if (this.getPersonalAccount().getNegotiatedExchangeRate()) {
                throw OpenItemAllocationExceptionMapper.makeNotBalancedDomainException((String)BigDecimalMapper.toString((BigDecimal)balance.totalAmountBC));
            }
            if (!this.isAllocationInDifferentCurrencies() && balance.totalAmountOC.signum() == 0 && (this.getAllOICompleteAllocated() || this.isDownPayment() || this.getAllocationInOCBalanced())) {
                OpenItemAllocationBalanceManager.adjustBaseBalance((OpenItemAllocation)this, (CurrencyType)CurrencyType.BASE_CURRENCY, (BigDecimal)balance.totalAmountBC);
            } else {
                throw OpenItemAllocationExceptionMapper.makeNotBalancedDomainException((String)BigDecimalMapper.toString((BigDecimal)balance.totalAmountBC));
            }
        }
        if (balance.totalAmountSC1.signum() != 0) {
            OpenItemAllocationBalanceManager.adjustBaseBalance((OpenItemAllocation)this, (CurrencyType)CurrencyType.SECONDARY_CURRENCY_1, (BigDecimal)balance.totalAmountSC1);
        }
        if (balance.totalAmountSC2.signum() != 0) {
            OpenItemAllocationBalanceManager.adjustBaseBalance((OpenItemAllocation)this, (CurrencyType)CurrencyType.SECONDARY_CURRENCY_2, (BigDecimal)balance.totalAmountSC2);
        }
        if (balance.totalAmountSC3.signum() != 0) {
            OpenItemAllocationBalanceManager.adjustBaseBalance((OpenItemAllocation)this, (CurrencyType)CurrencyType.SECONDARY_CURRENCY_3, (BigDecimal)balance.totalAmountSC3);
        }
        if (balance.totalAmountSC4.signum() != 0) {
            OpenItemAllocationBalanceManager.adjustBaseBalance((OpenItemAllocation)this, (CurrencyType)CurrencyType.SECONDARY_CURRENCY_4, (BigDecimal)balance.totalAmountSC4);
        }
    }

    private boolean getAllOICompleteAllocated() {
        if (this.getPaymentReceipt() != null && !this.getPaymentReceipt().isOICompleteAllocated()) {
            return false;
        }
        for (AllocationAmount allocationAmount : this.getAllocationAmounts()) {
            if (allocationAmount.isOICompleteAllocated()) continue;
            return false;
        }
        return true;
    }

    private void updateActTaxationData() throws BusinessDomainException {
        Date taxReportDate;
        OpenItem payment = this.getPaymentReceiptForActTaxation();
        if (payment != null) {
            taxReportDate = payment.getValueDate();
            if (taxReportDate == null) {
                taxReportDate = payment.getDocumentDate();
            }
        } else {
            taxReportDate = this.getAllocationDate();
        }
        if (this.getResidueAdjustment() != null) {
            new ActTaxationManager().setActTaxation((NominalTransactionBase)this.getResidueAdjustment(), taxReportDate, this, this.getResidueAdjustment().getPersonalAccountEntry().getBaseAmount());
        }
        if (this.getPaymentReceipt() != null) {
            this.getPaymentReceipt().updateActTaxationData(taxReportDate);
        }
        for (int i = 0; i < this.getAllocationAmounts().length; ++i) {
            this.getAllocationAmounts()[i].updateActTaxationData(taxReportDate);
        }
        if (!this.getNLBatchEmpty()) {
            this.getNLBatch().close(false);
        }
    }

    private void checkTransactionDateAfterAllocationDate(OpenItem openItem, boolean checkTransactionDateAfterAllocationDate) throws BusinessDomainException {
        if (checkTransactionDateAfterAllocationDate && TransactionHelper.transactionDateBefore((Date)this.getAllocationDate(), (FinancialYear)this.getFinancialYear(), (Date)openItem.getTransactionDate(), (FinancialYear)openItem.getFinancialYear())) {
            throw OpenItemAllocationExceptionMapper.makeTransactionDateAfterAllocationDateDomainException((String)StringMapper.toString((String)openItem.getReferenceNumber()));
        }
    }

    private void checkRemainderOpenItem(OpenItem remainderOpenItem) throws BusinessDomainException {
        BigDecimal originalAmount = remainderOpenItem.getOriginalAmount();
        if (originalAmount == null || originalAmount.signum() == 0) {
            throw OpenItemExceptionMapper.makeAmountOfRemainderOpenItemIsZeroDomainException();
        }
        if (remainderOpenItem.getConversionRate().getRate().compareTo(BigDecimal.ONE) == 0 && originalAmount.compareTo(remainderOpenItem.getBaseOriginalAmount()) != 0) {
            throw ExceptionMapper.makeApplicationException((String)"Amounts in FC und BC must be equal");
        }
        if (remainderOpenItem.getEnteredCurrency().equals(this.getFinanceSetup().getBaseCurrency()) && remainderOpenItem.getConversionRate().getRate().compareTo(BigDecimal.ONE) != 0) {
            throw OpenItemAllocationExceptionMapper.makeRemainderOiInvalidRateDomainException((String)remainderOpenItem.getReferenceNumber());
        }
    }

    public OpenItem getPaymentReceiptForActTaxation() {
        if (this.getPaymentReceipt() != null && this.getPaymentReceipt().getOpenItem().isPaymentReceipt()) {
            return this.getPaymentReceipt().getOpenItem();
        }
        return null;
    }

    public String getReferenceNumberForAdjustment(OpenItem openItem) {
        String result = "";
        if (this.getPaymentReceipt() != null) {
            result = this.getPaymentReceipt().getOpenItem().getReferenceNumber();
        }
        if (StringMapper.isNullString((String)result) && openItem != null) {
            result = openItem.getReferenceNumber();
        }
        if (StringMapper.isNullString((String)result)) {
            result = DateMapper.toString((Date)this.getAllocationDate());
        }
        return result;
    }

    public OpenItemStatusManager getOpenItemStatusManager() {
        if (this.mOpenItemStatusManager == null) {
            this.mOpenItemStatusManager = new OpenItemStatusManager(this.getCompany());
        }
        return this.mOpenItemStatusManager;
    }

    public RemainderOpenItem[] getRemainderOpenItems() {
        if (this.mRemainderOpenItems == null) {
            if (!this.isNew()) {
                this.mRemainderOpenItems = RemainderOpenItemPersistencyManager.getRemainderOpenItems((OpenItemAllocation)this);
            }
            if (this.mRemainderOpenItems == null) {
                this.mRemainderOpenItems = new RemainderOpenItem[0];
            }
            if (this.mRemainderOpenItems.length > 1 && this.isInstalment()) {
                Arrays.sort(this.mRemainderOpenItems, InstalmentOpenItemComparator.getComparator());
            }
        }
        return this.mRemainderOpenItems;
    }

    public void setRemainderOpenItems(OpenItem[] openItems) throws BusinessDomainException {
        RemainderOpenItem[] remainderOpenItems = this.getRemainderOpenItems();
        if (openItems == null) {
            openItems = new OpenItem[]{};
        }
        HashMap<String, RemainderOpenItem> remainderOpenItemMap = new HashMap<String, RemainderOpenItem>();
        for (RemainderOpenItem remainderOpenItem : remainderOpenItems) {
            remainderOpenItemMap.put(remainderOpenItem.getOpenItem().getObjectid(), remainderOpenItem);
        }
        ArrayList<RemainderOpenItem> newList = new ArrayList<RemainderOpenItem>();
        for (int i = 0; i < openItems.length; ++i) {
            if (openItems[i].isNew()) {
                newList.add(new RemainderOpenItem(this, openItems[i]));
                continue;
            }
            RemainderOpenItem remainderOpenItem = (RemainderOpenItem)remainderOpenItemMap.get(openItems[i].getObjectid());
            if (remainderOpenItem == null) continue;
            remainderOpenItem.makeSaveable();
            remainderOpenItem.setOpenItem(openItems[i]);
            newList.add(remainderOpenItem);
        }
        RemainderOpenItem[] newRemainderOpenItems = new RemainderOpenItem[newList.size()];
        newList.toArray(newRemainderOpenItems);
        List changedObjects = PersistentObjectUtils.removeUnusedObjects((IPersistentObject[])this.getRemainderOpenItems(), (IPersistentObject[])newRemainderOpenItems);
        this.mRemainderOpenItems = new RemainderOpenItem[changedObjects.size()];
        changedObjects.toArray(this.mRemainderOpenItems);
    }

    public void setRemainderOpenItems(RemainderOpenItem[] remainderOpenItems) throws BusinessDomainException {
        List changedObjects = PersistentObjectUtils.removeUnusedObjects((IPersistentObject[])this.getRemainderOpenItems(), (IPersistentObject[])remainderOpenItems);
        this.mRemainderOpenItems = new RemainderOpenItem[changedObjects.size()];
        changedObjects.toArray(this.mRemainderOpenItems);
    }

    public SequenceNoMappingManager getSequenceNoMappingManager() {
        if (this.mSequenceNoMappingManager == null) {
            this.mSequenceNoMappingManager = new SequenceNoMappingManager(this.getCompany());
        }
        return this.mSequenceNoMappingManager;
    }

    public void setSequenceNoMappingManager(SequenceNoMappingManager manager) {
        this.mSequenceNoMappingManager = manager;
    }

    public void setSequenceNumberForAllocationNumber(String sequenceNumberForAllocationNumber) {
        this.mSequenceNumberForAllocationNumber = sequenceNumberForAllocationNumber;
    }

    public String getSequenceNumberForAllocationNumber() throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.mSequenceNumberForAllocationNumber)) {
            this.mSequenceNumberForAllocationNumber = AllocationNumberManager.getSequenceNumberForAllocationNumber((IAllocationBase)this);
        }
        return this.mSequenceNumberForAllocationNumber;
    }

    public Date getFactoringESDate() {
        this.requireLoaded();
        return this.mFactoringESDate;
    }

    public void setFactoringESDate(Date factoringESDate) {
        this.protocol("factoringesdate", this.mFactoringESDate, factoringESDate);
        this.mFactoringESDate = factoringESDate;
    }

    public static Comparator<OpenItemAllocation> getCodeIgnoreCaseComparator() {
        return OpenItemAllocationIgnoreCaseComparatorCode.getComparator();
    }

    public static Comparator<OpenItemAllocation> getShortAddressIgnoreCaseComparator() {
        return OpenItemAllocationIgnoreCaseComparatorShortAddress.getComparator();
    }

    public static Comparator<RemainderOpenItem> getInstalmentOpenItemComparator() {
        return InstalmentOpenItemComparator.getComparator();
    }

    public InvoiceAllocationType getAllocationType_old() {
        this.requireLoaded();
        return this.mAllocationType_old;
    }

    public OpenItemAllocation getReversalPaymentOpenItemAllocation() {
        this.requireLoaded();
        if (!this.mReversalPaymentOpenItemAllocationLoaded) {
            if (!this.isNew()) {
                this.mReversalPaymentOpenItemAllocation = ReturnPaymentAllocationRelPersistencyManager.getReversalPaymentOpenItemAllocation((OpenItemAllocation)this);
            }
            this.mReversalPaymentOpenItemAllocationLoaded = true;
        }
        return this.mReversalPaymentOpenItemAllocation;
    }

    public void setReversalPaymentOpenItemAllocation(OpenItemAllocation reversalPaymentOpenItemAllocation) {
        this.mReversalPaymentOpenItemAllocation = reversalPaymentOpenItemAllocation;
        this.mReversalPaymentOpenItemAllocationLoaded = true;
    }

    public boolean isReversalPayment() {
        return this.getAllocationType() == InvoiceAllocationType.REVERSAL_PAYMENT;
    }

    public void setReturnPaymentOpenItemAllocation(OpenItemAllocation returnPaymentOpenItemAllocation) {
        this.mReturnPaymentOpenItemAllocation = returnPaymentOpenItemAllocation;
        this.mReturnPaymentOpenItemAllocationLoaded = true;
    }

    public OpenItemAllocation getReturnPaymentOpenItemAllocation() {
        this.requireLoaded();
        if (!this.mReturnPaymentOpenItemAllocationLoaded) {
            if (!this.isNew()) {
                this.mReturnPaymentOpenItemAllocation = ReturnPaymentAllocationRelPersistencyManager.getReturnPaymentOpenItemAllocation((IInvoiceAllocationBase)this, (boolean)true);
            }
            this.mReturnPaymentOpenItemAllocationLoaded = true;
        }
        return this.mReturnPaymentOpenItemAllocation;
    }

    public OpenItemAllocation getPaymentOpenItemAllocation() {
        this.requireLoaded();
        if (!this.mPaymentOpenItemAllocationLoaded) {
            if (!this.isNew()) {
                this.mPaymentOpenItemAllocation = ReturnPaymentAllocationRelPersistencyManager.getPaymentOpenItemAllocation((OpenItemAllocation)this);
            }
            this.mPaymentOpenItemAllocationLoaded = true;
        }
        return this.mPaymentOpenItemAllocation;
    }

    public ReturnPaymentStatusEnum getReturnPaymentStatus() {
        this.requireLoaded();
        return this.mReturnPaymentStatus;
    }

    public void setReturnPaymentStatus(ReturnPaymentStatusEnum returnPaymentStatus) {
        this.mReturnPaymentStatus = returnPaymentStatus;
    }

    public boolean isPostedBack() {
        return this.getReturnPaymentStatus().value() == 1;
    }

    public boolean isReturnPayment() {
        return this.getReturnPaymentStatus().value() == 2;
    }

    public boolean getJournaliseAdjustments() {
        return this.mJournaliseAdjustments;
    }

    public void setJournaliseAdjustments(boolean journaliseAdjustments) {
        this.mJournaliseAdjustments = journaliseAdjustments;
    }

    public void setFromGenerateDownPayment(boolean fromGenerateDownPayment) {
        this.mFromGenerateDownPayment = fromGenerateDownPayment;
    }

    public boolean getFromGenerateDownPayment() {
        return this.mFromGenerateDownPayment;
    }

    public PersonalAccountAdjustmentTransaction getForeignCurrencyAdjustment() {
        this.requireLoaded();
        return this.mForeignCurrencyAdjustment;
    }

    public void setForeignCurrencyAdjustment(PersonalAccountAdjustmentTransaction foreignCurrencyAdjustment) {
        this.mForeignCurrencyAdjustment = foreignCurrencyAdjustment;
    }

    private void adjustForeignCurrencyAdjustment(boolean generateForeignCurrencyAdjustment) throws BusinessDomainException {
        boolean mustBeCreated = this.getResidueAdjustment() != null && !this.getResidueAdjustment().getEnteredCurrency().equals(this.getFinanceSetup().getBaseCurrency()) && generateForeignCurrencyAdjustment;
        this.mForeignCurrencyAdjustment = AdjustmentTransactionManager.adjustConversionAdjustment((boolean)mustBeCreated, (PersonalAccountAdjustmentTransaction)this.getForeignCurrencyAdjustment(), (OpenItemAllocation)this, (PersonalAccountAdjustmentTransaction)this.getResidueAdjustment(), null, (CurrencyType)CurrencyType.FOREIGN_CURRENCY, null);
    }

    public void setReversalTransaction(boolean reversalTransaction) {
        this.mReversalTransaction = reversalTransaction;
    }

    public SequenceNo getSequenceNoForAllocation() {
        return this.getFinanceSetup().getSequenceNoForAllocation();
    }

    public List<PersonalAccountAdjustmentTransaction> getAdjustmentTransactions() {
        PersonalAccountAdjustmentTransaction foreignCurrencyAdjustment;
        ArrayList<PersonalAccountAdjustmentTransaction> result = new ArrayList<PersonalAccountAdjustmentTransaction>();
        PersonalAccountAdjustmentTransaction residueAdjustment = this.getResidueAdjustment();
        if (residueAdjustment != null) {
            result.add(residueAdjustment);
        }
        if ((foreignCurrencyAdjustment = this.getForeignCurrencyAdjustment()) != null) {
            result.add(foreignCurrencyAdjustment);
        }
        return result;
    }

    public void journalizeAdjustments() throws BusinessDomainException {
        if (this.getAllocationType() == InvoiceAllocationType.PLACEHOLDER || this.getAllocationType() == InvoiceAllocationType.NOTDONE) {
            throw OpenItemAllocationExceptionMapper.makeJournalizationNotPossibleDomainException();
        }
        this.setUpdateFromClaimPaymentDifferencesSession(true);
        List<Batch> batches = this.getBatches();
        if (batches.isEmpty()) {
            throw OpenItemAllocationExceptionMapper.makeNoAdjutmentsDomainException();
        }
        int count = 0;
        for (Batch batch : batches) {
            if (!batch.getIsClosed()) {
                batch.makeSaveable();
                batch.close();
                ++count;
            }
            if (batch.getIsJournalized()) continue;
            batch.makeSaveable();
            batch.journalize();
            ++count;
        }
        if (count == 0) {
            throw OpenItemAllocationExceptionMapper.makeAdjustmentsAlreadyJournalizedDomainException();
        }
    }

    public List<Batch> getBatches() {
        HashMap<String, Batch> batchMap = new HashMap<String, Batch>();
        List<PersonalAccountAdjustmentTransaction> adjustments = this.getAllAdjustmentTransactions();
        for (PersonalAccountAdjustmentTransaction adjustment : adjustments) {
            Batch batch = (Batch)batchMap.get(adjustment.getBatch().getObjectid());
            if (batch == null) {
                batch = adjustment.getBatch();
                batchMap.put(batch.getObjectid(), batch);
            }
            batch.setTransaction((NominalTransactionBase)adjustment);
            adjustment.setBatchWithoutCheck(batch);
        }
        ArrayList<Batch> result = new ArrayList<Batch>();
        result.addAll(batchMap.values());
        return result;
    }

    private List<PersonalAccountAdjustmentTransaction> getAllAdjustmentTransactions() {
        RemainderOpenItem[] remainderOpenItems;
        AllocationAmount[] allocationAmounts;
        ArrayList<PersonalAccountAdjustmentTransaction> result = new ArrayList<PersonalAccountAdjustmentTransaction>();
        result.addAll(this.getAdjustmentTransactions());
        AllocationAmount paymentReceipt = this.getPaymentReceipt();
        if (paymentReceipt != null) {
            result.addAll(paymentReceipt.getAdjustmentTransactions());
        }
        for (AllocationAmount allocationAmount : allocationAmounts = this.getAllocationAmounts()) {
            result.addAll(allocationAmount.getAdjustmentTransactions());
        }
        for (RemainderOpenItem remainderOpenItem : remainderOpenItems = this.getRemainderOpenItems()) {
            result.addAll(remainderOpenItem.getAdjustmentTransactions());
        }
        return result;
    }

    public void setPersonalAccountReposting(PersonalAccountReposting personalAccountReposting) {
        this.mPersonalAccountReposting = personalAccountReposting;
    }

    public PersonalAccountReposting getPersonalAccountReposting() {
        return this.mPersonalAccountReposting;
    }

    public boolean isDownPaymentRequestAllocation() {
        return false;
    }

    private boolean changedReturnPaymentStatus() {
        this.mChangedReturnPaymentStatus = !this.isNew() && this.mReturnPaymentStatus != this.mReturnPaymentStatus_old;
        return this.mChangedReturnPaymentStatus;
    }

    public IInvoiceAllocationAmountBase getPaymentReceiptBase() {
        return this.getPaymentReceipt();
    }

    public IRemainderOpenItemBase[] getRemainderOpenItemBases() {
        return this.getRemainderOpenItems();
    }

    public IInvoiceAllocationAmountBase[] getAllocationAmountBases() {
        return this.getAllocationAmounts();
    }

    public boolean isInZ4List() {
        if (this.isInZ4List == null) {
            this.isInZ4List = !this.isNew() && !this.isPlaceholder() && Z4PaymentPersistencyManager.isInZ4List((IInvoiceAllocation)this);
        }
        return this.isInZ4List;
    }

    public boolean isDoNotCheckDiscount() {
        return this.mDoNotCheckDiscount;
    }

    public void setDoNotCheckDiscount(boolean doNotCheckDiscount) {
        this.mDoNotCheckDiscount = doNotCheckDiscount;
    }
}

