/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.invoiceallocation;

import com.varial.accounting.domain.financesetup.ConversionTableType;
import com.varial.accounting.domain.financesetup.CurrencyType;
import com.varial.accounting.domain.financesetup.FinanceSetup;
import com.varial.accounting.domain.financesetup.IFinanceSetup;
import com.varial.accounting.domain.invoiceallocation.AllocationAmountData;
import com.varial.accounting.domain.invoiceallocation.AllocationAmountPersistencyManager;
import com.varial.accounting.domain.invoiceallocation.IInvoiceAllocation;
import com.varial.accounting.domain.invoiceallocation.IInvoiceAllocationAmount;
import com.varial.accounting.domain.invoiceallocation.InvoiceAllocationAmountBase;
import com.varial.accounting.domain.invoiceallocation.InvoiceAllocationType;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocation;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocationExceptionMapper;
import com.varial.accounting.domain.invoiceallocation.PersonalAccountAdjustmentTransaction;
import com.varial.accounting.domain.invoiceallocation.adjustment.AdjustmentTransactionManager;
import com.varial.accounting.domain.invoiceallocation.adjustment.AdjustmentTransactionType;
import com.varial.accounting.domain.invoiceallocation.adjustment.association.AssociationAdjustmentBalance;
import com.varial.accounting.domain.invoiceallocation.adjustment.association.AssociationAdjustmentTransactionManager;
import com.varial.accounting.domain.invoiceallocation.adjustment.conversion.ConversionAdjustmentTransactionManager;
import com.varial.accounting.domain.invoiceallocation.adjustment.residue.ResidueAdjustmentTransactionValidator;
import com.varial.accounting.domain.invoiceallocation.resolver.InvoiceAllocationExchangeRateResolver;
import com.varial.accounting.domain.invoiceallocation.utils.OpenItemAllocationHelper;
import com.varial.accounting.domain.invoiceallocation.validation.AllocationAmountValidator;
import com.varial.accounting.domain.nominaltransactionbase.ActTaxationManager;
import com.varial.accounting.domain.nominaltransactionbase.NominalTaxEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBase;
import com.varial.accounting.domain.nominaltransactionbase.PersonalAccountEntry;
import com.varial.accounting.domain.nominaltransactionbase.TransactionExceptionMapper;
import com.varial.accounting.domain.nominaltransactionbase.cancellation.CancellationContext;
import com.varial.accounting.domain.openitem.OpenItem;
import com.varial.accounting.domain.openitem.OpenItemType;
import com.varial.accounting.domain.openitem.dates.PaymentEffectiveDateEntriesUpdater;
import com.varial.accounting.domain.openitem.service.PaymentEffectiveDateService;
import com.varial.accounting.domain.openitemallocationbase.IAllocationBase;
import com.varial.accounting.domain.openitembase.IOpenItemBase;
import com.varial.accounting.domain.openitembase.OpenItemSecondaryCurrencyAmounts;
import com.varial.accounting.domain.payment.ConversionRateMap;
import com.varial.accounting.domain.purchaseregister.PurchaseInvoiceRegisterStatus;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.text.TextFactory;
import com.varial.framework.domain.currency.ConversionRate;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AllocationAmount
extends InvoiceAllocationAmountBase
implements IInvoiceAllocationAmount {
    protected static final String CLASSNAME = AllocationAmount.class.getName();
    private static final int PRIORITY = 8;
    private OpenItemAllocation mOpenItemAllocation;
    private PersonalAccountAdjustmentTransaction mDiscountAdjustment;
    private PersonalAccountAdjustmentTransaction mResidueAdjustment;
    private PersonalAccountAdjustmentTransaction mBaseConversionAdjustment;
    private PersonalAccountAdjustmentTransaction mSeccurr1ConversionAdjustment;
    private PersonalAccountAdjustmentTransaction mSeccurr2ConversionAdjustment;
    private PersonalAccountAdjustmentTransaction mSeccurr3ConversionAdjustment;
    private PersonalAccountAdjustmentTransaction mSeccurr4ConversionAdjustment;
    private PersonalAccountAdjustmentTransaction mForeignCurrencyAdjustment;
    private PersonalAccountAdjustmentTransaction mAssociationAdjustment;
    private int mAllocationAmountNumber;
    private BigDecimal mInterestAmount;
    private BigDecimal mInterestBaseAmount;
    private BigDecimal mDeduction;
    private BigDecimal mBaseDeduction;
    private BigDecimal mAllowedDiscount;
    private BigDecimal mAllowedBaseDiscount;
    private BigDecimal mUnauthorisedDeduction;
    private BigDecimal mUnauthorisedBaseDeduction;
    private Date mFactoringESDate;
    private BigDecimal mBaseTotal_old;
    private boolean mIsBaseCurrency;
    private boolean mIsBaseCurrencyCalculated = false;
    private boolean mIsBaseConversionDifferenceCleanup = false;

    public AllocationAmount(OpenItem openItem, OpenItemAllocation openItemAllocation) throws BusinessDomainException {
        super(8, openItem);
        if (openItem.getOpenItemType() == OpenItemType.DOWN_PAYMENT_REQUEST) {
            throw OpenItemAllocationExceptionMapper.makeDownPaymentRequestCannotBeAllocatedDomainException();
        }
        if (!openItemAllocation.isCurrencyRevaluation() && openItem.getOriginalAmount().signum() != 0 && openItem.getBaseOpenAmount().signum() == 0 && openItem.getOpenAmount().signum() == 0) {
            throw OpenItemAllocationExceptionMapper.makeOpenItemAlreadyCompleteAllocatedDomainException((String)StringMapper.toString((String)openItem.getReferenceNumber()));
        }
        if (!openItemAllocation.isCancellation() && openItem.getPurchaseInvoiceRegisterStatus() == PurchaseInvoiceRegisterStatus.POSTED_WITHOUT_VERIFICATION && openItemAllocation.getFinanceSetup().getBlockPurchaseRegisterInvoices()) {
            throw OpenItemAllocationExceptionMapper.makeOpenItemFromPurchaseRegisterBlockedForAllocationDomainException((String)StringMapper.toString((String)openItem.getReferenceNumber()));
        }
        this.mOpenItemAllocation = openItemAllocation;
    }

    public AllocationAmount(AllocationAmount oldAllocationAmount, OpenItemAllocation openItemAllocation, CancellationContext cancelData) throws BusinessDomainException {
        super(8, oldAllocationAmount.getOpenItem());
        this.mOpenItemAllocation = openItemAllocation;
        this.setIsDebit(this.getReverseIsDebit(oldAllocationAmount, cancelData));
        this.setBaseTotalAmount(this.getReverseAmount(oldAllocationAmount.getBaseTotalAmount(), cancelData));
        this.setForeignTotalAmount(this.getReverseAmount(oldAllocationAmount.getForeignTotalAmount(), cancelData));
        this.setSeccurr1TotalAmount(this.getReverseAmount(oldAllocationAmount.getSeccurr1TotalAmount(), cancelData));
        this.setSeccurr2TotalAmount(this.getReverseAmount(oldAllocationAmount.getSeccurr2TotalAmount(), cancelData));
        this.setSeccurr3TotalAmount(this.getReverseAmount(oldAllocationAmount.getSeccurr3TotalAmount(), cancelData));
        this.setSeccurr4TotalAmount(this.getReverseAmount(oldAllocationAmount.getSeccurr4TotalAmount(), cancelData));
        this.setBaseSettlementAmount(this.getReverseAmount(oldAllocationAmount.getBaseSettlementAmount(), cancelData));
        this.setForeignSettlementAmount(this.getReverseAmount(oldAllocationAmount.getForeignSettlementAmount(), cancelData));
        this.setSeccurr1SettlementAmount(this.getReverseAmount(oldAllocationAmount.getSeccurr1SettlementAmount(), cancelData));
        this.setSeccurr2SettlementAmount(this.getReverseAmount(oldAllocationAmount.getSeccurr2SettlementAmount(), cancelData));
        this.setSeccurr3SettlementAmount(this.getReverseAmount(oldAllocationAmount.getSeccurr3SettlementAmount(), cancelData));
        this.setSeccurr4SettlementAmount(this.getReverseAmount(oldAllocationAmount.getSeccurr4SettlementAmount(), cancelData));
        this.setBaseDiscount(this.getReverseAmount(oldAllocationAmount.getBaseDiscount(), cancelData));
        this.setForeignDiscount(this.getReverseAmount(oldAllocationAmount.getForeignDiscount(), cancelData));
        this.setDiscountPercent(oldAllocationAmount.getDiscountPercent());
        this.mDiscountAdjustment = this.getReversalAdjustment(oldAllocationAmount.getDiscountAdjustment(), cancelData);
        this.setSeccurr1Discount(this.getReverseAmount(oldAllocationAmount.getSeccurr1Discount(), cancelData));
        this.setSeccurr2Discount(this.getReverseAmount(oldAllocationAmount.getSeccurr2Discount(), cancelData));
        this.setSeccurr3Discount(this.getReverseAmount(oldAllocationAmount.getSeccurr3Discount(), cancelData));
        this.setSeccurr4Discount(this.getReverseAmount(oldAllocationAmount.getSeccurr4Discount(), cancelData));
        this.setBaseResidue(this.getReverseAmount(oldAllocationAmount.getBaseResidue(), cancelData));
        this.setForeignResidue(this.getReverseAmount(oldAllocationAmount.getForeignResidue(), cancelData));
        this.mResidueAdjustment = this.getReversalAdjustment(oldAllocationAmount.getResidueAdjustment(), cancelData);
        this.setSeccurr1Residue(this.getReverseAmount(oldAllocationAmount.getSeccurr1Residue(), cancelData));
        this.setSeccurr2Residue(this.getReverseAmount(oldAllocationAmount.getSeccurr2Residue(), cancelData));
        this.setSeccurr3Residue(this.getReverseAmount(oldAllocationAmount.getSeccurr3Residue(), cancelData));
        this.setSeccurr4Residue(this.getReverseAmount(oldAllocationAmount.getSeccurr4Residue(), cancelData));
        this.setConversionRate(oldAllocationAmount.getConversionRate());
        this.setBaseConversionAmount(BigDecimalMapper.negate((BigDecimal)oldAllocationAmount.getBaseConversionAmount()));
        this.mBaseConversionAdjustment = this.getReversalAdjustment(oldAllocationAmount.getBaseConversionAdjustment(), cancelData);
        this.setSeccurr1ConversionAmount(BigDecimalMapper.negate((BigDecimal)oldAllocationAmount.getSeccurr1ConversionAmount()));
        this.setSeccurr2ConversionAmount(BigDecimalMapper.negate((BigDecimal)oldAllocationAmount.getSeccurr2ConversionAmount()));
        this.setSeccurr3ConversionAmount(BigDecimalMapper.negate((BigDecimal)oldAllocationAmount.getSeccurr3ConversionAmount()));
        this.setSeccurr4ConversionAmount(BigDecimalMapper.negate((BigDecimal)oldAllocationAmount.getSeccurr4ConversionAmount()));
        this.setSeccurr1ConversionRate(oldAllocationAmount.getSeccurr1ConversionRate());
        this.setSeccurr2ConversionRate(oldAllocationAmount.getSeccurr2ConversionRate());
        this.setSeccurr3ConversionRate(oldAllocationAmount.getSeccurr3ConversionRate());
        this.setSeccurr4ConversionRate(oldAllocationAmount.getSeccurr4ConversionRate());
        this.mSeccurr1ConversionAdjustment = this.getReversalAdjustment(oldAllocationAmount.getSeccurr1ConversionAdjustment(), cancelData);
        this.mSeccurr2ConversionAdjustment = this.getReversalAdjustment(oldAllocationAmount.getSeccurr2ConversionAdjustment(), cancelData);
        this.mSeccurr3ConversionAdjustment = this.getReversalAdjustment(oldAllocationAmount.getSeccurr3ConversionAdjustment(), cancelData);
        this.mSeccurr4ConversionAdjustment = this.getReversalAdjustment(oldAllocationAmount.getSeccurr4ConversionAdjustment(), cancelData);
        this.mAssociationAdjustment = this.getReversalAdjustment(oldAllocationAmount.getAssociationAdjustment(), cancelData);
        this.mForeignCurrencyAdjustment = this.getReversalAdjustment(oldAllocationAmount.getForeignCurrencyAdjustment(), cancelData);
        if (cancelData.isInverseDebit()) {
            this.getOpenItem().removeFromOpenItem(this);
        }
    }

    public AllocationAmount(String objectid, int version, OpenItem openItem, OpenItemAllocation openItemAllocation) {
        super(8, objectid, version, openItem);
        this.mOpenItemAllocation = openItemAllocation;
        this.requireLoaded();
    }

    protected AllocationAmount(boolean readOnly, OpenItemAllocation openItemAllocation, OpenItem openItem) {
        super(8, readOnly, openItem);
        this.mOpenItemAllocation = openItemAllocation;
    }

    protected AllocationAmount(String objectid, OpenItemAllocation openItemAllocation) {
        super(8, objectid);
        this.mOpenItemAllocation = openItemAllocation;
    }

    protected void load() {
        AllocationAmountPersistencyManager.load((AllocationAmount)this);
    }

    protected void deleteImpl() {
        AllocationAmountPersistencyManager.delete((AllocationAmount)this);
    }

    public String getClassName() {
        return CLASSNAME;
    }

    public String getDomainKey() {
        return this.getOpenItem().getDomainKey() + "/" + this.getOpenItemAllocation().getDomainKey();
    }

    protected void saveImpl() {
        AllocationAmountPersistencyManager.save((AllocationAmount)this);
    }

    protected void destroyImpl() throws BusinessDomainException {
        if (this.getOpenItemAllocation().isPlaceholder()) {
            this.getOpenItem().removePlaceholderAllocationAmount(this);
            return;
        }
        if (this.getOpenItemAllocation().getClaimPaymentDifferencesSession() != null) {
            throw OpenItemAllocationExceptionMapper.makeAmendingNotAllowedBecauseClaimPaymentDifferencesSessionDomainException();
        }
        if (this.getOpenItemAllocation().isInZ4List()) {
            throw OpenItemAllocationExceptionMapper.makeInvoiceAllocationIsInZ4ListDomainException();
        }
        if (this.getOpenItemAllocation().isReversalPayment()) {
            this.getOpenItem().addToOpenItem(this);
        } else {
            this.getOpenItem().removeFromOpenItem(this);
        }
        this.getOpenItem().setIsCancelled(false);
        if (this.getDiscountAdjustment() != null) {
            this.mDiscountAdjustment.setIsSupplierDiscountAdjustment(this.getIsSupplier());
        }
        List<PersonalAccountAdjustmentTransaction> adjustments = this.getAdjustmentTransactions();
        for (PersonalAccountAdjustmentTransaction adjustment : adjustments) {
            this.deleteAdjustmentTransaction(adjustment);
        }
        PersonalAccountEntry originalPaEntry = this.getOpenItem().getOriginalPaEntry();
        if (originalPaEntry != null) {
            NominalTaxEntry[] taxEntries;
            for (NominalTaxEntry taxEntry : taxEntries = originalPaEntry.getTransaction().getTaxEntries()) {
                taxEntry.removeActTaxation(this.mOpenItemAllocation);
                taxEntry.removeSplitPayment(this.mOpenItemAllocation);
            }
        }
        new PaymentEffectiveDateService(new PaymentEffectiveDateEntriesUpdater()).clearEffectiveDates(this);
    }

    protected void setData(AllocationAmountData data) {
        super.setData(data.getBaseData());
        this.mDiscountAdjustment = data.getDiscountAdjustment();
        this.mResidueAdjustment = data.getResidueAdjustment();
        this.mBaseConversionAdjustment = data.getBaseConversionAdjustment();
        this.mAllocationAmountNumber = data.getAllocationAmountNumber();
        this.mAssociationAdjustment = data.getAssociationAdjustment();
        this.mInterestAmount = data.getInterestAmount();
        this.mInterestBaseAmount = data.getInterestBaseAmount();
        this.mDeduction = data.getDeduction();
        this.mBaseDeduction = data.getBaseDeduction();
        this.mAllowedDiscount = data.getAllowedDiscount();
        this.mAllowedBaseDiscount = data.getAllowedBaseDiscount();
        this.mUnauthorisedDeduction = data.getUnauthorisedDeduction();
        this.mUnauthorisedBaseDeduction = data.getUnauthorisedBaseDeduction();
        this.mFactoringESDate = data.getFactoringESDate();
        this.mSeccurr1ConversionAdjustment = data.getSeccurr1ConversionAdjustment();
        this.mSeccurr2ConversionAdjustment = data.getSeccurr2ConversionAdjustment();
        this.mSeccurr3ConversionAdjustment = data.getSeccurr3ConversionAdjustment();
        this.mSeccurr4ConversionAdjustment = data.getSeccurr4ConversionAdjustment();
        this.mForeignCurrencyAdjustment = data.getForeignCurrencyAdjustment();
        this.mBaseTotal_old = data.getBaseData().getBaseTotalAmount();
    }

    public void setAllocationAmount(ConversionRate conversionRate, BigDecimal foreignDiscount, PersonalAccountAdjustmentTransaction residueAdjustment, BigDecimal foreignSettlement, BigDecimal baseSettlement, BigDecimal discountPercent) throws BusinessDomainException {
        this.setAllocationAmount(conversionRate, foreignDiscount, residueAdjustment, foreignSettlement, baseSettlement, false, discountPercent);
    }

    public void setAllocationAmount(ConversionRate conversionRate, BigDecimal foreignDiscount, PersonalAccountAdjustmentTransaction residueAdjustment, BigDecimal foreignSettlement, BigDecimal baseSettlement, boolean isDownPayment, BigDecimal discountPercent) throws BusinessDomainException {
        if (!isDownPayment && !this.isNew()) {
            this.getOpenItem().addToOpenAmount(this);
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.getOpenItem().getOpenAmount())) {
            BigDecimal newRate = this.getOpenItem().getBaseOpenAmount().divide(this.getOpenItem().getOpenAmount(), 9, RoundingMode.HALF_UP);
            this.getOpenItem().setNewConversionRate(new ConversionRate(newRate, false));
        }
        this.setConversionRateWithCheck(conversionRate);
        this.setForeignSettlementAmountWithCheck(foreignSettlement);
        this.setBaseSettlementAmountWithCheck(baseSettlement);
        this.setForeignDiscountWithCheck(foreignDiscount);
        this.setResidueAdjustment(residueAdjustment);
        this.setDiscountPercent(discountPercent);
        if (this.getOpenItemAllocation().getFinanceSetup().hasParallelCurrencies()) {
            OpenItemSecondaryCurrencyAmounts seccurrSettlements = OpenItemSecondaryCurrencyAmounts.convert((FinanceSetup)this.getOpenItemAllocation().getFinanceSetup(), (BigDecimal)foreignSettlement.abs(), (ICurrency)this.getOpenItem().getEnteredCurrency(), (Date)InvoiceAllocationExchangeRateResolver.resolveExchangeRateDate((OpenItemAllocation)this.getOpenItemAllocation()), (ConversionTableType)InvoiceAllocationExchangeRateResolver.resolveConversionTableType((OpenItemAllocation)this.getOpenItemAllocation()), (ConversionRateMap)this.getOpenItemAllocation().getSeccurr1ConversionRateMap(), (ConversionRateMap)this.getOpenItemAllocation().getSeccurr2ConversionRateMap(), (ConversionRateMap)this.getOpenItemAllocation().getSeccurr3ConversionRateMap(), (ConversionRateMap)this.getOpenItemAllocation().getSeccurr4ConversionRateMap());
            this.setSeccurrConversionRates(seccurrSettlements);
            this.setSeccurrSettlementAmounts(seccurrSettlements);
        }
    }

    public OpenItemAllocation getOpenItemAllocation() {
        if (this.mOpenItemAllocation == null) {
            this.requireLoaded();
        }
        return this.mOpenItemAllocation;
    }

    protected void setOpenItemAllocation(OpenItemAllocation openItemAllocation) {
        this.mOpenItemAllocation = openItemAllocation;
    }

    protected boolean isOpenItemAllocationNull() {
        return this.mOpenItemAllocation == null;
    }

    public void setIsDebit(OpenItem openItem) {
        this.setIsDebit(openItem.getIsDebit());
    }

    public void setAllocationAmountNumber(int allocationAmountNumber) {
        this.mAllocationAmountNumber = allocationAmountNumber;
    }

    public int getAllocationAmountNumber() {
        this.requireLoaded();
        return this.mAllocationAmountNumber;
    }

    public BigDecimal getBaseTotal_old() {
        this.requireLoaded();
        return this.mBaseTotal_old == null ? BigDecimalMapper.ZERO : this.mBaseTotal_old;
    }

    private void setBaseSettlementAmountWithCheck(BigDecimal baseSettlement) throws BusinessDomainException {
        if (baseSettlement == null) {
            baseSettlement = BigDecimal.ZERO;
        } else {
            baseSettlement = baseSettlement.abs();
            this.checkAmount(baseSettlement, this.mOpenItemAllocation.getFinanceSetup().getBaseCurrency());
        }
        if (!this.isNew() && this.getOpenItemAllocation().getClaimPaymentDifferencesSession() != null && this.getBaseSettlementAmount().compareTo(baseSettlement) != 0) {
            throw OpenItemAllocationExceptionMapper.makeAmendingNotAllowedBecauseClaimPaymentDifferencesSessionDomainException();
        }
        this.setBaseSettlementAmount(baseSettlement);
    }

    private void setForeignSettlementAmountWithCheck(BigDecimal foreignSettlementAmount) throws BusinessDomainException {
        if (foreignSettlementAmount == null) {
            foreignSettlementAmount = BigDecimal.ZERO;
        } else {
            foreignSettlementAmount = foreignSettlementAmount.abs();
            this.checkAmount(foreignSettlementAmount, this.getOpenItem().getEnteredCurrency());
        }
        if (!this.isNew() && this.getOpenItemAllocation().getClaimPaymentDifferencesSession() != null && this.getForeignSettlementAmount().compareTo(foreignSettlementAmount) != 0) {
            throw OpenItemAllocationExceptionMapper.makeAmendingNotAllowedBecauseClaimPaymentDifferencesSessionDomainException();
        }
        this.setForeignSettlementAmount(foreignSettlementAmount);
    }

    private void setConversionRateWithCheck(ConversionRate conversionRate) {
        if (this.getOpenItem().getPersonalAccount().getNegotiatedExchangeRate()) {
            conversionRate = this.getOpenItem().getConversionRate();
        }
        this.setConversionRate(conversionRate);
    }

    private void setForeignDiscountWithCheck(BigDecimal foreignDiscount) throws BusinessDomainException {
        if (foreignDiscount == null) {
            foreignDiscount = BigDecimal.ZERO;
        } else {
            if (foreignDiscount.signum() != 0 && this.getOpenItem().isPaymentReceipt()) {
                throw OpenItemAllocationExceptionMapper.makeDiscountOnlyForInvoiceOrCreditNoteDomainException((String)StringMapper.toString((String)this.getOpenItem().getReferenceNumber()));
            }
            foreignDiscount = foreignDiscount.abs();
            this.checkAmount(foreignDiscount, this.getOpenItem().getEnteredCurrency());
        }
        this.setForeignDiscount(foreignDiscount);
        if (foreignDiscount.signum() == 0) {
            this.setBaseDiscount(BigDecimal.ZERO);
            OpenItemSecondaryCurrencyAmounts seccurrAmounts = OpenItemSecondaryCurrencyAmounts.makeOpenItemSecondaryCurrencyAmounts((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (IFinanceSetup)this.getOpenItemAllocation().getFinanceSetup());
            this.setSeccurrDiscountAmounts(seccurrAmounts);
        }
    }

    public boolean getIsSupplier() {
        return this.getOpenItem().getPersonalAccount() != null && this.getOpenItem().getPersonalAccount().isSupplier();
    }

    protected void adjustDiscountAdjustment() throws BusinessDomainException {
        if (this.getDiscountAdjustment() != null) {
            this.mDiscountAdjustment.setIsSupplierDiscountAdjustment(this.getIsSupplier());
            if (this.getForeignDiscount().signum() != 0) {
                this.mDiscountAdjustment.makeSaveable();
                PersonalAccountAdjustmentTransaction newAdjustment = this.updateDiscountAdjustment(this.mDiscountAdjustment);
                if (newAdjustment != null) {
                    this.cancelAdjustmentTransaction(this.mDiscountAdjustment, AdjustmentTransactionType.DISCOUNT_ADJUSTMENT);
                    this.mDiscountAdjustment = newAdjustment;
                }
            } else {
                this.deleteAdjustmentTransaction(this.mDiscountAdjustment);
                this.mDiscountAdjustment = null;
            }
        } else if (this.getForeignDiscount().signum() != 0) {
            this.mDiscountAdjustment = this.createDiscountAdjustment();
        }
        if (this.getForeignDiscount().signum() != 0) {
            PersonalAccountEntry paEntry = this.mDiscountAdjustment.getPersonalAccountEntry();
            this.setBaseDiscount(paEntry.getBaseAmount());
            OpenItemSecondaryCurrencyAmounts seccurrDiscounts = OpenItemSecondaryCurrencyAmounts.makeOpenItemSecondaryCurrencyAmounts((BigDecimal)paEntry.getSeccurr1Amount(), (BigDecimal)paEntry.getSeccurr2Amount(), (BigDecimal)paEntry.getSeccurr3Amount(), (BigDecimal)paEntry.getSeccurr4Amount(), (IFinanceSetup)this.getOpenItemAllocation().getFinanceSetup());
            this.setSeccurrDiscountAmounts(seccurrDiscounts);
        }
    }

    private PersonalAccountAdjustmentTransaction createDiscountAdjustment() throws BusinessDomainException {
        return AdjustmentTransactionManager.createDiscountAdjustmentTransaction((AllocationAmount)this, (boolean)true);
    }

    private PersonalAccountAdjustmentTransaction updateDiscountAdjustment(PersonalAccountAdjustmentTransaction oldAdjustment) throws BusinessDomainException {
        return AdjustmentTransactionManager.updateAdjustmentTransaction((PersonalAccountAdjustmentTransaction)oldAdjustment, (AdjustmentTransactionType)AdjustmentTransactionType.DISCOUNT_ADJUSTMENT, (AllocationAmount)this, (CurrencyType)CurrencyType.BASE_CURRENCY, null, (OpenItemAllocation)this.getOpenItemAllocation(), null);
    }

    private PersonalAccountAdjustmentTransaction updateConversionAdjustment(PersonalAccountAdjustmentTransaction oldAdjustment, CurrencyType currencyType) throws BusinessDomainException {
        return AdjustmentTransactionManager.updateAdjustmentTransaction((PersonalAccountAdjustmentTransaction)oldAdjustment, (AdjustmentTransactionType)AdjustmentTransactionType.CONVERSION_ADJUSTMENT, (AllocationAmount)this, (CurrencyType)currencyType, null, (OpenItemAllocation)this.getOpenItemAllocation(), null);
    }

    private void setResidueAdjustment(PersonalAccountAdjustmentTransaction residueAdjustment) throws BusinessDomainException {
        OpenItemSecondaryCurrencyAmounts seccurrResidues;
        BigDecimal baseResidue;
        BigDecimal foreignResidue;
        if (this.mResidueAdjustment != null) {
            if (residueAdjustment == null || residueAdjustment.isNew()) {
                AdjustmentTransactionManager.deleteAdjustmentTransaction((PersonalAccountAdjustmentTransaction)this.mResidueAdjustment, (CancellationContext)this.mOpenItemAllocation.getCancellationContext(), (boolean)this.mOpenItemAllocation.getJournaliseAdjustments());
            } else if (!PersistentObjectUtils.haveEqualObjectids((IPersistentObject)this.mResidueAdjustment, (IPersistentObject)residueAdjustment)) {
                throw ExceptionMapper.makeApplicationException((String)"wrong residue adjustment");
            }
        }
        this.mResidueAdjustment = residueAdjustment;
        if (this.mResidueAdjustment != null) {
            new ResidueAdjustmentTransactionValidator(this).checkResidueAdjustment();
            PersonalAccountEntry paEntry = this.mResidueAdjustment.getPersonalAccountEntry();
            foreignResidue = paEntry.getEnteredAmount();
            baseResidue = paEntry.getBaseAmount();
            seccurrResidues = OpenItemSecondaryCurrencyAmounts.makeOpenItemSecondaryCurrencyAmounts((BigDecimal)paEntry.getSeccurr1Amount(), (BigDecimal)paEntry.getSeccurr2Amount(), (BigDecimal)paEntry.getSeccurr3Amount(), (BigDecimal)paEntry.getSeccurr4Amount(), (IFinanceSetup)this.getOpenItemAllocation().getFinanceSetup());
        } else {
            foreignResidue = BigDecimal.ZERO;
            baseResidue = BigDecimal.ZERO;
            seccurrResidues = OpenItemSecondaryCurrencyAmounts.makeOpenItemSecondaryCurrencyAmounts((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (IFinanceSetup)this.getOpenItemAllocation().getFinanceSetup());
        }
        this.setForeignResidue(foreignResidue);
        this.setBaseResidue(baseResidue);
        this.setSeccurrResidueAmounts(seccurrResidues);
    }

    private void deleteAdjustmentTransaction(PersonalAccountAdjustmentTransaction adjustmentTransaction) throws BusinessDomainException {
        AdjustmentTransactionManager.deleteAdjustmentTransaction((PersonalAccountAdjustmentTransaction)adjustmentTransaction, (CancellationContext)this.getOpenItemAllocation().getCancellationContext(), (boolean)this.getOpenItemAllocation().getJournaliseAdjustments());
    }

    protected void adjustConversionAdjustment() throws BusinessDomainException {
        this.mBaseConversionAdjustment = this.adjustConversionAdjustment(this.getBaseConversionAmount(), this.mBaseConversionAdjustment, CurrencyType.BASE_CURRENCY);
        this.mSeccurr1ConversionAdjustment = this.adjustConversionAdjustment(this.getSeccurr1ConversionAmount(), this.mSeccurr1ConversionAdjustment, CurrencyType.SECONDARY_CURRENCY_1);
        this.mSeccurr2ConversionAdjustment = this.adjustConversionAdjustment(this.getSeccurr2ConversionAmount(), this.mSeccurr2ConversionAdjustment, CurrencyType.SECONDARY_CURRENCY_2);
        this.mSeccurr3ConversionAdjustment = this.adjustConversionAdjustment(this.getSeccurr3ConversionAmount(), this.mSeccurr3ConversionAdjustment, CurrencyType.SECONDARY_CURRENCY_3);
        this.mSeccurr4ConversionAdjustment = this.adjustConversionAdjustment(this.getSeccurr4ConversionAmount(), this.mSeccurr4ConversionAdjustment, CurrencyType.SECONDARY_CURRENCY_4);
    }

    private PersonalAccountAdjustmentTransaction adjustConversionAdjustment(BigDecimal gainLoss, PersonalAccountAdjustmentTransaction conversionAdjustment, CurrencyType currencyType) throws BusinessDomainException {
        if (gainLoss != null && gainLoss.signum() != 0) {
            if (conversionAdjustment == null) {
                conversionAdjustment = this.createConversionAdjustment(currencyType);
            } else {
                conversionAdjustment.makeSaveable();
                PersonalAccountAdjustmentTransaction newAdjustment = this.updateConversionAdjustment(conversionAdjustment, currencyType);
                if (newAdjustment != null) {
                    this.cancelAdjustmentTransaction(conversionAdjustment, AdjustmentTransactionType.CONVERSION_ADJUSTMENT);
                    conversionAdjustment = newAdjustment;
                }
            }
        } else if (conversionAdjustment != null) {
            this.deleteAdjustmentTransaction(conversionAdjustment);
            conversionAdjustment = null;
        }
        return conversionAdjustment;
    }

    protected void adjustAssociationAdjustment() throws BusinessDomainException {
        boolean generateAssociationAdjustment;
        boolean bl = generateAssociationAdjustment = !this.getOpenItemAllocation().getPersonalAccount().equals((Object)this.getOpenItem().getPersonalAccount()) && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.getBaseSettlementAmount());
        if (this.getAssociationAdjustment() != null) {
            if (generateAssociationAdjustment) {
                try {
                    this.mAssociationAdjustment.makeSaveable();
                    AssociationAdjustmentTransactionManager.updateAssociationAdjustment((PersonalAccountAdjustmentTransaction)this.mAssociationAdjustment, (OpenItemAllocation)this.mOpenItemAllocation, (AllocationAmount)this, null);
                }
                catch (BusinessDomainException e) {
                    if (e.getErrorNumber() == 300 && StringMapper.equal((String)e.getDomain(), (String)"Transaction")) {
                        this.cancelAdjustmentTransaction(this.mAssociationAdjustment, AdjustmentTransactionType.ASSOCIATION_ADJUSTMENT);
                        this.mAssociationAdjustment = this.createAssociationAdjustment();
                    }
                    throw e;
                }
            } else {
                this.deleteAdjustmentTransaction(this.mAssociationAdjustment);
                this.mAssociationAdjustment = null;
            }
        } else if (generateAssociationAdjustment) {
            this.mAssociationAdjustment = this.createAssociationAdjustment();
        }
    }

    private void cancelAdjustmentTransaction(PersonalAccountAdjustmentTransaction adjustment, AdjustmentTransactionType adjustmentType) throws BusinessDomainException {
        AdjustmentTransactionManager.cancelAdjustmentTransaction((PersonalAccountAdjustmentTransaction)adjustment, (AdjustmentTransactionType)adjustmentType, (boolean)this.getIsSupplier(), (OpenItemAllocation)this.getOpenItemAllocation());
    }

    public PersonalAccountAdjustmentTransaction getBaseConversionAdjustment() {
        this.requireLoaded();
        return this.mBaseConversionAdjustment;
    }

    public PersonalAccountAdjustmentTransaction getDiscountAdjustment() {
        this.requireLoaded();
        return this.mDiscountAdjustment;
    }

    public PersonalAccountAdjustmentTransaction getResidueAdjustment() {
        this.requireLoaded();
        return this.mResidueAdjustment;
    }

    public PersonalAccountAdjustmentTransaction getAssociationAdjustment() {
        this.requireLoaded();
        return this.mAssociationAdjustment;
    }

    private PersonalAccountAdjustmentTransaction createConversionAdjustment(CurrencyType currencyType) throws BusinessDomainException {
        return ConversionAdjustmentTransactionManager.createConversionAdjustmentTransaction((AllocationAmount)this, (boolean)true, (CurrencyType)currencyType, null, (OpenItemAllocation)this.getOpenItemAllocation(), null);
    }

    private PersonalAccountAdjustmentTransaction createAssociationAdjustment() throws BusinessDomainException {
        return AssociationAdjustmentTransactionManager.createAssociationAdjustmentTransaction((AllocationAmount)this);
    }

    private void checkAmount(BigDecimal amount, ICurrency currency) throws BusinessDomainException {
        if (currency.round(amount).compareTo(amount) != 0) {
            Object errorValue = this.getOpenItem() != null && this.getOpenItem().getPersonalAccount() != null ? this.getOpenItem().getPersonalAccount().getCode() + "/" + StringMapper.toString((String)this.getOpenItem().getReferenceNumber()) + "/" + BigDecimalMapper.toString((BigDecimal)amount) : BigDecimalMapper.toString((BigDecimal)amount);
            throw TransactionExceptionMapper.makeRoundingNotCorrectDomainException((String)errorValue);
        }
    }

    protected void checkAllocationAmount() throws BusinessDomainException {
        new AllocationAmountValidator().checkAllocationAmount(this);
    }

    protected void updateActTaxationData(Date taxReportDate) throws BusinessDomainException {
        new ActTaxationManager().setActTaxation(this, taxReportDate);
    }

    public void setDeduction(BigDecimal deduction) {
        this.protocol("deduction", this.mDeduction, deduction);
        this.mDeduction = deduction;
    }

    public BigDecimal getDeduction() {
        this.requireLoaded();
        return this.mDeduction;
    }

    public void setBaseDeduction(BigDecimal baseDeduction) {
        this.protocol("basededuction", this.mBaseDeduction, baseDeduction);
        this.mBaseDeduction = baseDeduction;
    }

    public BigDecimal getBaseDeduction() {
        this.requireLoaded();
        return this.mBaseDeduction;
    }

    public void setInterestAmount(BigDecimal interestAmount) {
        this.protocol("interestamount", this.mInterestAmount, interestAmount);
        this.mInterestAmount = interestAmount;
    }

    public void setInterestBaseAmount(BigDecimal interestBaseAmount) {
        this.protocol("interestbaseamount", this.mInterestBaseAmount, interestBaseAmount);
        this.mInterestBaseAmount = interestBaseAmount;
    }

    public BigDecimal getInterestBaseAmount() {
        this.requireLoaded();
        return this.mInterestBaseAmount;
    }

    public BigDecimal getInterestAmount() {
        this.requireLoaded();
        return this.mInterestAmount;
    }

    public BigDecimal getAllowedDiscount() {
        this.requireLoaded();
        return this.mAllowedDiscount;
    }

    public void setAllowedDiscount(BigDecimal allowedDiscount) {
        this.protocol("alloweddiscount", this.mAllowedDiscount, allowedDiscount);
        this.mAllowedDiscount = allowedDiscount;
    }

    public BigDecimal getAllowedBaseDiscount() {
        this.requireLoaded();
        return this.mAllowedBaseDiscount;
    }

    public void setAllowedBaseDiscount(BigDecimal allowedBaseDiscount) {
        this.protocol("allowedbasediscount", this.mAllowedBaseDiscount, allowedBaseDiscount);
        this.mAllowedBaseDiscount = allowedBaseDiscount;
    }

    public void setUnauthorisedDeduction(BigDecimal unauthorisedDeduction) {
        this.mUnauthorisedDeduction = unauthorisedDeduction;
    }

    public BigDecimal getUnauthorisedDeduction() {
        this.requireLoaded();
        if (this.mUnauthorisedDeduction != null) {
            return this.mUnauthorisedDeduction;
        }
        return BigDecimalMapper.subtract((BigDecimal)this.getDeduction(), (BigDecimal)this.getAllowedDiscount());
    }

    public BigDecimal getUnauthorisedDeductionWithoutCalculation() {
        this.requireLoaded();
        return this.mUnauthorisedDeduction;
    }

    public void setUnauthorisedBaseDeduction(BigDecimal unauthorisedBaseDeduction) {
        this.mUnauthorisedBaseDeduction = unauthorisedBaseDeduction;
    }

    public BigDecimal getUnauthorisedBaseDeduction() {
        this.requireLoaded();
        if (this.mUnauthorisedBaseDeduction != null) {
            return this.mUnauthorisedBaseDeduction;
        }
        return BigDecimalMapper.subtract((BigDecimal)this.getBaseDeduction(), (BigDecimal)this.getAllowedBaseDiscount());
    }

    public BigDecimal getUnauthorisedBaseDeductionWithoutCalculation() {
        this.requireLoaded();
        return this.mUnauthorisedBaseDeduction;
    }

    public boolean isBaseCurrency() {
        this.requireLoaded();
        if (!this.mIsBaseCurrencyCalculated) {
            this.mIsBaseCurrency = this.getOpenItem().getEnteredCurrency().equals(this.getOpenItemAllocation().getFinanceSetup().getBaseCurrency());
            this.mIsBaseCurrencyCalculated = true;
        }
        return this.mIsBaseCurrency;
    }

    public Date getFactoringESDate() {
        this.requireLoaded();
        return this.mFactoringESDate;
    }

    public void setFactoringESDate(Date factoringESDate) {
        this.mFactoringESDate = factoringESDate;
    }

    public PersonalAccountAdjustmentTransaction getSeccurr1ConversionAdjustment() {
        this.requireLoaded();
        return this.mSeccurr1ConversionAdjustment;
    }

    public PersonalAccountAdjustmentTransaction getSeccurr2ConversionAdjustment() {
        this.requireLoaded();
        return this.mSeccurr2ConversionAdjustment;
    }

    public PersonalAccountAdjustmentTransaction getSeccurr3ConversionAdjustment() {
        this.requireLoaded();
        return this.mSeccurr3ConversionAdjustment;
    }

    public PersonalAccountAdjustmentTransaction getSeccurr4ConversionAdjustment() {
        this.requireLoaded();
        return this.mSeccurr4ConversionAdjustment;
    }

    public boolean isOICompleteAllocated() {
        return this.getOpenItem().getOpenAmount().subtract(this.getForeignTotalAmount()).signum() == 0;
    }

    public void calculateTotalAmount() throws BusinessDomainException {
        if (this.mIsBaseConversionDifferenceCleanup) {
            return;
        }
        this.calculateBaseTotalAmount();
        this.calculateSeccurrTotalAmount(CurrencyType.SECONDARY_CURRENCY_1);
        this.calculateSeccurrTotalAmount(CurrencyType.SECONDARY_CURRENCY_2);
        this.calculateSeccurrTotalAmount(CurrencyType.SECONDARY_CURRENCY_3);
        this.calculateSeccurrTotalAmount(CurrencyType.SECONDARY_CURRENCY_4);
    }

    public void setIsBaseConversionDifferenceCleanup(boolean isBaseConversionDifferenceCleanup) {
        this.mIsBaseConversionDifferenceCleanup = isBaseConversionDifferenceCleanup;
    }

    public boolean getIsBaseConversionDifferenceCleanup() {
        return this.mIsBaseConversionDifferenceCleanup;
    }

    public void setAllocationNumberInAdjustments(String allocationNumber) {
        List<PersonalAccountAdjustmentTransaction> adjustments = this.getAdjustmentTransactions();
        for (PersonalAccountAdjustmentTransaction adjustment : adjustments) {
            adjustment.setAllocationNumber(allocationNumber);
        }
    }

    public PersonalAccountAdjustmentTransaction getForeignCurrencyAdjustment() {
        this.requireLoaded();
        return this.mForeignCurrencyAdjustment;
    }

    public void setForeignCurrencyAdjustment(PersonalAccountAdjustmentTransaction foreignCurrencyAdjustment) {
        this.mForeignCurrencyAdjustment = foreignCurrencyAdjustment;
    }

    protected void adjustForeignCurrencyAdjustment(boolean generateForeignCurrencyAdjustment, AssociationAdjustmentBalance associationBalance) throws BusinessDomainException {
        boolean mustBeCreated;
        if (this.getOpenItem().getEnteredCurrency().equals(this.getOpenItemAllocation().getFinanceSetup().getBaseCurrency())) {
            return;
        }
        BigDecimal foreignSettlementAmount = this.getForeignSettlementAmount();
        boolean isDebit = this.getIsDebit();
        boolean resetForeignSettlement = false;
        boolean bl = mustBeCreated = !BigDecimalMapper.isZeroOrNull((BigDecimal)foreignSettlementAmount) && generateForeignCurrencyAdjustment;
        if (mustBeCreated) {
            if (this.getAssociationAdjustment() != null) {
                if (!this.getAssociationAdjustment().getEnteredCurrency().equals(this.getOpenItemAllocation().getFinanceSetup().getBaseCurrency())) {
                    mustBeCreated = false;
                }
            } else if (associationBalance != null && !BigDecimalMapper.isZeroOrNull((BigDecimal)associationBalance.getForeignBalance())) {
                BigDecimal newForeignSettlement = this.getForeignSettlementAmountWithSign().add(associationBalance.getForeignBalance());
                if (newForeignSettlement.signum() == 0) {
                    mustBeCreated = false;
                } else {
                    this.setForeignSettlementAmount(newForeignSettlement.abs());
                    this.setIsDebit(newForeignSettlement.signum() > 0);
                    resetForeignSettlement = true;
                }
            }
        }
        this.mForeignCurrencyAdjustment = AdjustmentTransactionManager.adjustConversionAdjustment((boolean)mustBeCreated, (PersonalAccountAdjustmentTransaction)this.getForeignCurrencyAdjustment(), (OpenItemAllocation)this.getOpenItemAllocation(), null, (AllocationAmount)this, (CurrencyType)CurrencyType.FOREIGN_CURRENCY, null);
        if (resetForeignSettlement) {
            this.setForeignSettlementAmount(foreignSettlementAmount);
            this.setIsDebit(isDebit);
        }
    }

    public void setSeccurrencyConversionTransaction(CurrencyType currencyType, PersonalAccountAdjustmentTransaction adjustmentTransaction) {
        switch (currencyType) {
            case SECONDARY_CURRENCY_1: {
                this.mSeccurr1ConversionAdjustment = adjustmentTransaction;
                break;
            }
            case SECONDARY_CURRENCY_2: {
                this.mSeccurr2ConversionAdjustment = adjustmentTransaction;
                break;
            }
            case SECONDARY_CURRENCY_3: {
                this.mSeccurr3ConversionAdjustment = adjustmentTransaction;
                break;
            }
            case SECONDARY_CURRENCY_4: {
                this.mSeccurr4ConversionAdjustment = adjustmentTransaction;
                break;
            }
            default: {
                throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)currencyType));
            }
        }
    }

    public List<PersonalAccountAdjustmentTransaction> getAdjustmentTransactions() {
        ArrayList<PersonalAccountAdjustmentTransaction> result = new ArrayList<PersonalAccountAdjustmentTransaction>();
        OpenItemAllocationHelper.addToAdjustmentTransactions(result, (PersonalAccountAdjustmentTransaction)this.getDiscountAdjustment());
        OpenItemAllocationHelper.addToAdjustmentTransactions(result, (PersonalAccountAdjustmentTransaction)this.getResidueAdjustment());
        OpenItemAllocationHelper.addToAdjustmentTransactions(result, (PersonalAccountAdjustmentTransaction)this.getBaseConversionAdjustment());
        OpenItemAllocationHelper.addToAdjustmentTransactions(result, (PersonalAccountAdjustmentTransaction)this.getSeccurr1ConversionAdjustment());
        OpenItemAllocationHelper.addToAdjustmentTransactions(result, (PersonalAccountAdjustmentTransaction)this.getSeccurr2ConversionAdjustment());
        OpenItemAllocationHelper.addToAdjustmentTransactions(result, (PersonalAccountAdjustmentTransaction)this.getSeccurr3ConversionAdjustment());
        OpenItemAllocationHelper.addToAdjustmentTransactions(result, (PersonalAccountAdjustmentTransaction)this.getSeccurr4ConversionAdjustment());
        OpenItemAllocationHelper.addToAdjustmentTransactions(result, (PersonalAccountAdjustmentTransaction)this.getAssociationAdjustment());
        OpenItemAllocationHelper.addToAdjustmentTransactions(result, (PersonalAccountAdjustmentTransaction)this.getForeignCurrencyAdjustment());
        return result;
    }

    public void setSeccurrDiscountAmounts(OpenItemSecondaryCurrencyAmounts seccurrAmounts) {
        this.setSeccurr1Discount(seccurrAmounts.mSeccurr1Amount);
        this.setSeccurr2Discount(seccurrAmounts.mSeccurr2Amount);
        this.setSeccurr3Discount(seccurrAmounts.mSeccurr3Amount);
        this.setSeccurr4Discount(seccurrAmounts.mSeccurr4Amount);
    }

    public void setSeccurrResidueAmounts(OpenItemSecondaryCurrencyAmounts seccurrAmounts) {
        this.setSeccurr1Residue(seccurrAmounts.mSeccurr1Amount);
        this.setSeccurr2Residue(seccurrAmounts.mSeccurr2Amount);
        this.setSeccurr3Residue(seccurrAmounts.mSeccurr3Amount);
        this.setSeccurr4Residue(seccurrAmounts.mSeccurr4Amount);
    }

    public void setSeccurrConversionAmounts(OpenItemSecondaryCurrencyAmounts seccurrAmounts) {
        this.setSeccurr1ConversionAmount(seccurrAmounts.mSeccurr1Amount);
        this.setSeccurr2ConversionAmount(seccurrAmounts.mSeccurr2Amount);
        this.setSeccurr3ConversionAmount(seccurrAmounts.mSeccurr3Amount);
        this.setSeccurr4ConversionAmount(seccurrAmounts.mSeccurr4Amount);
    }

    public void setSeccurrTotalAmounts(OpenItemSecondaryCurrencyAmounts seccurrAmounts) {
        this.setSeccurr1TotalAmount(seccurrAmounts.mSeccurr1Amount);
        this.setSeccurr2TotalAmount(seccurrAmounts.mSeccurr2Amount);
        this.setSeccurr3TotalAmount(seccurrAmounts.mSeccurr3Amount);
        this.setSeccurr4TotalAmount(seccurrAmounts.mSeccurr4Amount);
    }

    public void setSeccurrSettlementAmounts(OpenItemSecondaryCurrencyAmounts seccurrAmounts) {
        this.setSeccurr1SettlementAmount(seccurrAmounts.mSeccurr1Amount);
        this.setSeccurr2SettlementAmount(seccurrAmounts.mSeccurr2Amount);
        this.setSeccurr3SettlementAmount(seccurrAmounts.mSeccurr3Amount);
        this.setSeccurr4SettlementAmount(seccurrAmounts.mSeccurr4Amount);
    }

    public void setSeccurrConversionRates(OpenItemSecondaryCurrencyAmounts seccurrAmounts) {
        this.setSeccurr1ConversionRate(seccurrAmounts.mSeccurr1ConversionRate);
        this.setSeccurr2ConversionRate(seccurrAmounts.mSeccurr2ConversionRate);
        this.setSeccurr3ConversionRate(seccurrAmounts.mSeccurr3ConversionRate);
        this.setSeccurr4ConversionRate(seccurrAmounts.mSeccurr4ConversionRate);
    }

    public void checkForeignTotalAmount(BigDecimal foreignTotalAmount) throws BusinessDomainException {
        if (foreignTotalAmount.signum() == 0 && this.getOpenItemAllocation().getAllocationType() != InvoiceAllocationType.CURRENCY_REVALUATION && !this.getOpenItemAllocation().isDownPayment()) {
            throw OpenItemAllocationExceptionMapper.makeEmptyAllocationDomainException();
        }
    }

    public FinanceSetup getFinanceSetup() {
        return this.getOpenItemAllocation().getFinanceSetup();
    }

    public Date getDiscountDate() {
        return this.getOpenItemAllocation().getDiscountDate();
    }

    private boolean getReverseIsDebit(AllocationAmount allocationAmount, CancellationContext cancelData) {
        boolean isDebit = allocationAmount.getIsDebit();
        if (cancelData.isInverseDebit()) {
            isDebit = !allocationAmount.getIsDebit();
        }
        return isDebit;
    }

    private BigDecimal getReverseAmount(BigDecimal amount, CancellationContext cancelData) {
        if (amount == null || cancelData.isInverseDebit()) {
            return amount;
        }
        return amount.negate();
    }

    private PersonalAccountAdjustmentTransaction getReversalAdjustment(PersonalAccountAdjustmentTransaction adjustmentTransaction, CancellationContext cancelData) throws BusinessDomainException {
        PersonalAccountAdjustmentTransaction result = null;
        if (adjustmentTransaction != null) {
            if (cancelData.isCancellation()) {
                adjustmentTransaction.setIsAutomaticProcessing(true);
                adjustmentTransaction.cancelTransaction(cancelData);
                result = adjustmentTransaction.getReverseTransaction();
                adjustmentTransaction.getBatch().addTransaction((NominalTransactionBase)result);
            } else {
                result = new PersonalAccountAdjustmentTransaction(adjustmentTransaction, cancelData);
            }
        }
        return result;
    }

    public IAllocationBase getAllocation() {
        return this.getOpenItemAllocation();
    }

    public IOpenItemBase getOpenItemBase() {
        return this.getOpenItem();
    }

    public IInvoiceAllocation getInvoiceAllocation() {
        return this.getOpenItemAllocation();
    }
}

