/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.ecsaleslist;

import com.varial.base.error.ErrorList;
import com.varial.base.error.ErrorMessage;
import com.varial.base.error.Errors;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.i18n.Translatable;
import com.varial.serverbase.mapper.ExceptionMapper;

public class ECSalesListExceptionMapper {
    private static final String CLASS_GENERAL = "ECSalesList";
    private static final int FINAL_REPORT_CANNOT_BE_DELETED = 650;
    private static final int EC_DATA_MISSING = 651;
    private static final int NO_VALID_EC_SALES_LIST_FOR_THIS_COMPANY = 652;
    private static final int EC_SALES_LIST_NOT_CLOSED_FOR_THIS_COMPANY = 653;
    private static final int CONSOLIDATED_EC_SALES_LIST_FOR_THIS_GROUP_ALREADY_EXISTS = 654;
    private static final int NO_TRANSACTIONS_FOR_EC = 655;
    private static final int NO_VALID_PERIOD = 656;
    private static final int EC_SALES_LIST_ALREADY_EXISTS = 657;
    private static final int NO_TAXCODES_FOR_EC = 658;
    private static final int EC_SALES_LIST_FOR_PERFIDIA_MUST_BE_YEARLY_OR_QUARTERLY = 659;
    private static final int USED_IN_CONSOLIDATED_REPORT = 660;
    private static final int NO_DATA_FOR_QUALIFIED_VAT_CHECK = 661;
    private static final int ESL_CANNOT_BE_REOPENED_BECAUSE_OF_EXISTING_ESL_CORRECTION = 662;
    private static final int ESL_CANNOT_BE_REOPENED_BECAUSE_CONSOLIDATED_DECLARATION_IS_ALREADY_DONE = 663;
    private static final int EC_COMPANY_TAX_MISSING = 664;
    @Translatable(type=Translatable.Type.ERRORLIST)
    @Errors
    private static final ErrorList mErrorList = new ErrorList("ECSalesList", new ErrorMessage[]{new ErrorMessage(650, "A final report cannot be deleted"), new ErrorMessage(651, "There are transactions (EC Sale or EC triangular trade)with missing VAT registration number."), new ErrorMessage(652, "No valid ECSalesList existing for this company and period:"), new ErrorMessage(653, "Closing not possible. The ECSalesList for this company not closed:"), new ErrorMessage(654, "A consolidated ECSalesList for this group and frequency already exists"), new ErrorMessage(655, "Cannot create ECSalesList, because no transactions are present."), new ErrorMessage(656, "The selected period is not valid."), new ErrorMessage(657, "ECSalesList for this period already exists."), new ErrorMessage(658, "Cannot create ECSalesList, because no ec-taxcodes defined."), new ErrorMessage(659, "Nur Jahresmeldung oder Quartalsmeldung k\u00f6nnen an Perfidia \u00fcbergeben werden."), new ErrorMessage(660, "Bestandteil einer konsolidierten Meldung kann nicht gel\u00f6scht werden."), new ErrorMessage(661, "There are no data for the qualified VAT check."), new ErrorMessage(662, "The ESL cannot be reopened because an ESL Correction has already been created for this period. The Correction must be deleted first."), new ErrorMessage(663, "The ESL cannot be reopened because a consolidated declaration has already been created for this period. The consolidated declaration must be reopened first."), new ErrorMessage(664, "Please specify the company\u2019s EU-VAT Registration No.")});

    public static BusinessDomainException makeEcCompanyTaxMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)664, (String)mErrorList.getDefaultString(664));
    }

    public static BusinessDomainException makeESLCannotBeReopenedBecauseOfExistingConsolidatedDeclarationDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)663, (String)mErrorList.getDefaultString(663));
    }

    public static BusinessDomainException makeESLCannotBeReopenedBecauseOfExistingESLCorrectionDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)662, (String)mErrorList.getDefaultString(662));
    }

    public static BusinessDomainException makeNoDataAvailableForQualifiedVATCheckDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)661, (String)mErrorList.getDefaultString(661));
    }

    public static BusinessDomainException makeFinalReportCannotBeDeletedDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)650, (String)mErrorList.getDefaultString(650));
    }

    public static BusinessDomainException makeECDataMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)651, (String)mErrorList.getDefaultString(651));
    }

    public static BusinessDomainException makeNoValidECSalesListForCompanyException(String companyName) {
        String error = mErrorList.getDefaultString(652) + " " + companyName;
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)companyName, (int)652, (String)error);
    }

    public static BusinessDomainException makeIndividualDeclarationNotDoneException(String companyName) {
        String error = mErrorList.getDefaultString(653) + " " + companyName;
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)companyName, (int)653, (String)error);
    }

    public static BusinessDomainException makeConsolidatedListForGroupAlreadyExistsDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)654, (String)mErrorList.getDefaultString(654));
    }

    public static BusinessDomainException makeNoTransactionsForECDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)655, (String)mErrorList.getDefaultString(655));
    }

    public static BusinessDomainException makeNoValidPeriodDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)656, (String)mErrorList.getDefaultString(656));
    }

    public static BusinessDomainException makeECSalesListAlreadyExistsDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)657, (String)mErrorList.getDefaultString(657));
    }

    public static BusinessDomainException makeNoTaxcodesForECDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)658, (String)mErrorList.getDefaultString(658));
    }

    public static BusinessDomainException makeECSalesListForPerfidiaMustBeYearlyOrQuarterlyDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)659, (String)mErrorList.getDefaultString(659));
    }

    public static BusinessDomainException makeUsedInConsolidatedReportDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)660, (String)mErrorList.getDefaultString(660));
    }
}

