/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.eaudit.export.v35.record.builder;

import com.varial.accounting.domain.eaudit.IEAuditSession;
import com.varial.accounting.domain.eaudit.export.common.context.EAuditExportContext;
import com.varial.accounting.domain.eaudit.export.eauditdata.dto.TaxRateDetails;
import com.varial.accounting.domain.eaudit.export.v35.record.builder.AbstractEAuditRecordBuilder;
import com.varial.accounting.domain.eaudit.export.v35.util.NlentryResolver;
import com.varial.accounting.persistency.nlentry.NlentryContainer;
import com.varial.base.exception.BusinessDomainException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class EAuditTransactionRecordBuilder
extends AbstractEAuditRecordBuilder<EAuditTransactionRecordBuilder> {
    private static final String RECORD_TYPE = "DSBU";
    private static final String RECORD_VERSION = "01";
    private static final String TEST_MODE_NEWLINE = "TESTMODE: NEWLINE";
    private static final int ENTRY_DESCRIPTION_LENGTH = 70;
    private static final int TRANSACTION_NOTE_LENGTH = 100;

    protected EAuditTransactionRecordBuilder self() {
        return this;
    }

    @Override
    protected String getRecordType() {
        return RECORD_TYPE;
    }

    @Override
    protected String getRecordVersion() {
        return RECORD_VERSION;
    }

    private EAuditTransactionRecordBuilder groupId() {
        return (EAuditTransactionRecordBuilder)this.appendField(35, "");
    }

    public EAuditTransactionRecordBuilder appendDevNewLine(IEAuditSession session) {
        if (session.isTestMode() && session.getNote() != null && session.getNote().contains(TEST_MODE_NEWLINE)) {
            return (EAuditTransactionRecordBuilder)this.appendNewLine();
        }
        return this;
    }

    public EAuditTransactionRecordBuilder buildFrom(EAuditExportContext exportContext, List<NlentryContainer> containers, Map<String, String> accountCodeMap, Map<String, TaxRateDetails> taxRateMap) throws BusinessDomainException {
        if (containers == null || containers.isEmpty()) {
            throw new IllegalArgumentException("Entry list must not be null or empty.");
        }
        NlentryContainer first = containers.get(0);
        int entryCount = containers.size();
        this.appendHeader(exportContext.getSession(), first, entryCount);
        this.appendDevNewLine(exportContext.getSession());
        int entryNumber = 1;
        for (NlentryContainer container : containers) {
            this.appendEntry(container, accountCodeMap, taxRateMap, entryNumber++);
            this.appendDevNewLine(exportContext.getSession());
        }
        this.appendFooter();
        return this;
    }

    private EAuditTransactionRecordBuilder appendEntry(NlentryContainer container, Map<String, String> accountCodeMap, Map<String, TaxRateDetails> taxRateMap, int entryNumber) throws BusinessDomainException {
        String accountCode = NlentryResolver.getAccountCode((String)container.oidaccount, accountCodeMap);
        TaxRateDetails taxDetails = NlentryResolver.getTaxRateDetails((NlentryContainer)container, taxRateMap);
        return this.addEntry(accountCode, container.debit ? container.baseamount : null, container.debit ? null : container.baseamount, taxDetails != null ? taxDetails.getPercent() : null, taxDetails != null ? taxDetails.getDescription() : null, container.description, entryNumber);
    }

    private EAuditTransactionRecordBuilder appendHeader(IEAuditSession session, NlentryContainer container, int entryCount) throws BusinessDomainException {
        return ((EAuditTransactionRecordBuilder)((Object)((EAuditTransactionRecordBuilder)((Object)((EAuditTransactionRecordBuilder)((Object)((EAuditTransactionRecordBuilder)((Object)((EAuditTransactionRecordBuilder)((Object)((EAuditTransactionRecordBuilder)((Object)((EAuditTransactionRecordBuilder)((Object)((EAuditTransactionRecordBuilder)((Object)((EAuditTransactionRecordBuilder)((Object)((EAuditTransactionRecordBuilder)((Object)((EAuditTransactionRecordBuilder)((Object)this.recordType())).eubpProcedure())).senderNumber(session))).receiverNumber(session))).recordVersion())).createdNow())).noError())).noError())).sysId())).companyCode(session))).referenceNumber(container.referencenumber).documentDate(container.documentdate).transactionDate(container.transactiondate).transactionNote().noEInvoice())).groupId().entryCount(entryCount);
    }

    private EAuditTransactionRecordBuilder addEntry(String accountCode, BigDecimal amountDebit, BigDecimal amountCredit, BigDecimal taxRatePercent, String taxRateDescription, String description, int entryNumber) throws BusinessDomainException {
        return ((EAuditTransactionRecordBuilder)((Object)((EAuditTransactionRecordBuilder)((Object)this.entryNumber(entryNumber).accountType())).accountCode(accountCode))).amountDebit(amountDebit).amountCredit(amountCredit).entryDescription(description).taxRate(taxRatePercent).taxRateDescription(taxRateDescription).orgUnit().orgUnit().orgUnit();
    }

    private EAuditTransactionRecordBuilder entryDescription(String description) {
        return (EAuditTransactionRecordBuilder)this.appendField(70, this.eAuditConverter.convert(description));
    }

    private EAuditTransactionRecordBuilder taxRateDescription(String taxRateDescription) {
        return (EAuditTransactionRecordBuilder)this.appendField(70, this.eAuditConverter.convert(taxRateDescription));
    }

    private EAuditTransactionRecordBuilder taxRate(BigDecimal taxRatePercent) {
        return (EAuditTransactionRecordBuilder)((Object)this.appendAmount(taxRatePercent, 5, 2));
    }

    private EAuditTransactionRecordBuilder amountDebit(BigDecimal amountDebit) {
        return (EAuditTransactionRecordBuilder)((Object)this.appendSignedAmount(amountDebit));
    }

    private EAuditTransactionRecordBuilder amountCredit(BigDecimal amountCredit) {
        return (EAuditTransactionRecordBuilder)((Object)this.appendSignedAmount(amountCredit));
    }

    private EAuditTransactionRecordBuilder referenceNumber(String referenceNumber) {
        return (EAuditTransactionRecordBuilder)this.appendField(36, this.eAuditConverter.convert(referenceNumber));
    }

    private EAuditTransactionRecordBuilder transactionNote() {
        return (EAuditTransactionRecordBuilder)this.appendField(100, "");
    }

    private EAuditTransactionRecordBuilder transactionDate(Date transactionDate) {
        return (EAuditTransactionRecordBuilder)((Object)this.appendDateField(transactionDate));
    }

    private EAuditTransactionRecordBuilder documentDate(Date documentDate) {
        return (EAuditTransactionRecordBuilder)((Object)this.appendDateField(documentDate));
    }

    private EAuditTransactionRecordBuilder appendFooter() {
        return (EAuditTransactionRecordBuilder)((Object)this.endFlag());
    }

    private EAuditTransactionRecordBuilder orgUnit() {
        return (EAuditTransactionRecordBuilder)this.appendField(50, "");
    }

    private EAuditTransactionRecordBuilder entryNumber(int entryNumber) {
        return (EAuditTransactionRecordBuilder)this.appendNumericField(6, entryNumber);
    }

    private EAuditTransactionRecordBuilder entryCount(int entryCount) {
        return (EAuditTransactionRecordBuilder)this.appendNumericField(6, entryCount);
    }
}

