/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.bankstatementposting.matching;

import com.infor.igf.core.types.PersistableEnum;
import com.infor.igf.core.util.PersistableEnumUtils;
import com.varial.accounting.bankstatementposting.BankStatementAllocationTypeEnum;
import com.varial.accounting.bankstatementposting.BankStatementEntryStateEnum;
import com.varial.accounting.bankstatementposting.BankStatementErrorMessageEnum;
import com.varial.accounting.domain.bankstatementposting.BankStatementEntry;
import com.varial.accounting.domain.bankstatementposting.BankStatementFormatUtils;
import com.varial.accounting.domain.bankstatementposting.BankStatementOpenItem;
import com.varial.accounting.domain.bankstatementposting.matching.returndebitnote.strategy.Camt053De00108ReturnDebitNoteStrategy;
import com.varial.accounting.domain.bankstatementposting.matching.returndebitnote.strategy.DefaultReturnDebitNoteStrategy;
import com.varial.accounting.domain.bankstatementposting.matching.returndebitnote.strategy.ReturnDebitNoteStrategy;
import com.varial.accounting.domain.invoiceallocation.AllocationAmount;
import com.varial.accounting.domain.invoiceallocation.AllocationAmountPersistencyManager;
import com.varial.accounting.domain.invoiceallocation.InvoiceAllocationType;
import com.varial.accounting.domain.invoiceallocation.returnpayment.ReturnPaymentStatusEnum;
import com.varial.accounting.domain.invoiceallocation.returnpayment.ReturnPaymentStatusMapper;
import com.varial.accounting.domain.personalaccount.IPersonalAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.persistency.openitemalloc.IOpenitemallocDao;
import com.varial.accounting.persistency.openitemalloc.OpenitemallocContainer;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Junction;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.persistency.criterion.SubSelect;
import com.varial.base.persistency.criterion.Subqueries;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.Map;

public class ReturnDebitNoteProcessor {
    private static final IOpenitemallocDao openItemAllocDao = (IOpenitemallocDao)UtilitiesManager.getBean((String)"openitemallocDao", IOpenitemallocDao.class);
    private final BankStatementEntry entry;
    private final ReturnDebitNoteStrategy strategy;

    public ReturnDebitNoteProcessor(BankStatementEntry entry) {
        this.entry = entry;
        this.strategy = this.createStrategy(entry);
    }

    private ReturnDebitNoteStrategy createStrategy(BankStatementEntry entry) {
        if (BankStatementFormatUtils.isCamt053De00108(entry.getBankStatementPostingSession())) {
            return new Camt053De00108ReturnDebitNoteStrategy();
        }
        return new DefaultReturnDebitNoteStrategy();
    }

    public void findAndAllocatePayment(Map<String, AllocationAmount> allocatedPaymentMap) throws BusinessDomainException {
        BigDecimal charges = this.strategy.getCharges(this.entry);
        AllocationAmount allocatedPayment = this.findPayment(charges, allocatedPaymentMap);
        this.updateEntry(charges, allocatedPayment);
    }

    private void updateEntry(BigDecimal charges, AllocationAmount allocatedPayment) throws BusinessDomainException {
        this.entry.setCharges(charges);
        this.entry.setBaseCharges(this.getBaseCharges(charges, allocatedPayment));
        this.entry.setErrorMessage(this.determineErrorMessage(charges, allocatedPayment));
        this.entry.setIsReturnDebitNote(true);
        PersonalAccount personalAccount = this.getPersonalAccount(allocatedPayment);
        this.entry.setPersonalAccount(personalAccount);
        this.entry.setAllocationType(this.getAllocationType((IPersonalAccount)personalAccount));
        this.entry.setBankStatementOpenItems(this.createBankStatementOpenItems(allocatedPayment));
        this.entry.setForeignSettlement(this.getForeignSettlement(allocatedPayment));
        this.entry.setBaseSettlement(this.getBaseSettlement(allocatedPayment));
        this.entry.setEntryState(this.getEntryState(allocatedPayment));
    }

    private BankStatementErrorMessageEnum determineErrorMessage(BigDecimal charges, AllocationAmount allocatedPayment) {
        if (charges == null) {
            return BankStatementErrorMessageEnum.BSME_RETURN_DEBIT_NOTE_CHARGES_COULD_NOT_BE_DETERMINED;
        }
        if (allocatedPayment == null) {
            return BankStatementErrorMessageEnum.BSME_ALLOCATED_PAYMENTS_NOT_FOUND;
        }
        return BankStatementErrorMessageEnum.BSME_NO_ERROR_MESSAGE;
    }

    private AllocationAmount findPayment(BigDecimal charges, Map<String, AllocationAmount> allocatedPaymentMap) {
        String oidAllocatedPayment;
        if (charges == null) {
            return null;
        }
        String referenceNumber = this.strategy.getReferenceNumber(this.entry);
        if (StringMapper.isNullString((String)referenceNumber)) {
            return null;
        }
        BigDecimal originalAmount = this.strategy.getOriginalAmount(this.entry);
        OpenitemallocContainer[] allocContainers = openItemAllocDao.getRows(null, this.getAllocatedPaymentFilter(originalAmount, referenceNumber));
        if (allocContainers != null && allocContainers.length == 1 && allocatedPaymentMap.get(oidAllocatedPayment = allocContainers[0].oidpayreceipt) == null) {
            AllocationAmount allocatedPayment = AllocationAmountPersistencyManager.getAllocationAmount((String)oidAllocatedPayment, null);
            allocatedPaymentMap.put(oidAllocatedPayment, allocatedPayment);
            return allocatedPayment;
        }
        return null;
    }

    private BankStatementOpenItem[] createBankStatementOpenItems(AllocationAmount allocatedPayment) {
        if (allocatedPayment != null) {
            return new BankStatementOpenItem[]{this.createBankStatementOpenItem(allocatedPayment)};
        }
        return new BankStatementOpenItem[0];
    }

    private BankStatementOpenItem createBankStatementOpenItem(AllocationAmount allocatedPayment) {
        BankStatementOpenItem result = new BankStatementOpenItem(this.entry);
        result.setOpenItem(allocatedPayment.getOpenItem());
        BigDecimal foreignSettlement = allocatedPayment.getForeignSettlementAmountWithSign();
        result.setForeignSettlement(foreignSettlement);
        BigDecimal baseSettlement = this.getBaseAmount(foreignSettlement);
        result.setBaseSettlement(baseSettlement);
        result.setConversionRate(this.entry.getConversionRate());
        result.setAllocatedPayment(allocatedPayment);
        return result;
    }

    private BankStatementAllocationTypeEnum getAllocationType(IPersonalAccount personalAccount) {
        if (personalAccount == null || personalAccount.isCustomer()) {
            return BankStatementAllocationTypeEnum.BSATE_CUSTOMER;
        }
        return BankStatementAllocationTypeEnum.BSATE_SUPPLIER;
    }

    private BigDecimal getForeignSettlement(AllocationAmount allocatedPayment) {
        if (allocatedPayment != null) {
            return allocatedPayment.getForeignSettlementAmountWithSign();
        }
        return null;
    }

    private BigDecimal getBaseSettlement(AllocationAmount allocatedPayment) {
        if (allocatedPayment != null) {
            return allocatedPayment.getBaseSettlementAmountWithSign();
        }
        return null;
    }

    private BankStatementEntryStateEnum getEntryState(AllocationAmount allocatedPayment) {
        if (allocatedPayment != null) {
            return BankStatementEntryStateEnum.BSESE_ALLOCATED;
        }
        return BankStatementEntryStateEnum.BSESE_UNCLEARED;
    }

    private BigDecimal getBaseCharges(BigDecimal charges, AllocationAmount allocatedPayment) {
        if (allocatedPayment != null) {
            return this.entry.getPaymentBaseAmount().abs().subtract(allocatedPayment.getBaseSettlementAmount().abs());
        }
        return this.getBaseAmount(charges);
    }

    private PersonalAccount getPersonalAccount(AllocationAmount allocatedPayment) {
        if (allocatedPayment != null) {
            return allocatedPayment.getOpenItem().getPersonalAccount();
        }
        return null;
    }

    private Criterion getAllocatedPaymentFilter(BigDecimal originalAmount, String referenceNumber) {
        Junction filter = Restrictions.conjunction().add(Restrictions.eq((String)"oidcompany", (String)this.entry.getBankStatementPostingSession().getAccountingCompany().getObjectid())).add(Restrictions.isNotNull((String)"oidpayreceipt")).add(Restrictions.eq((String)"allocationtype", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)InvoiceAllocationType.DONE))).add(Restrictions.eq((String)"retpaymstatus", (String)ReturnPaymentStatusMapper.toString((ReturnPaymentStatusEnum)ReturnPaymentStatusEnum.RPSE_NONE)));
        Junction openItemFilter = Restrictions.conjunction().add(Restrictions.eq((String)"isdebit", (String)BooleanMapper.toString((!this.entry.isPayment() ? 1 : 0) != 0))).add(Restrictions.eq((String)"oidbankaccount", (String)this.entry.getBankStatementPostingSession().getBankAccount().getObjectid())).add(Restrictions.eq((String)"oidenteredcurrency", (String)this.entry.getPaymentCurrency().getObjectid()));
        if (!StringMapper.isNullString((String)referenceNumber)) {
            openItemFilter.add(Restrictions.eq((String)"referencenumber", (String)referenceNumber, (boolean)true));
        }
        filter.add(Subqueries.notIn((String)"oidpayreceipt", (SubSelect)new SubSelect("SELECT OIDALLOCATEDPAYMEN FROM BANKSTATALLOCPAY_T ")));
        filter.add(Subqueries.in((String)"oidpayreceipt", (SubSelect)new SubSelect("SELECT objectid FROM allocationamount_T ", (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"FOREIGNSETTLEMENT", (String)BigDecimalMapper.toString((BigDecimal)originalAmount)), Subqueries.in((String)"oidopenitem", (SubSelect)new SubSelect("SELECT objectid from openitem_T ", (Criterion)openItemFilter))}))));
        return filter;
    }

    private BigDecimal getBaseAmount(BigDecimal amount) {
        BigDecimal result = amount;
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)amount)) {
            ICurrency baseCurrency = this.entry.getBankStatementPostingSession().getAccountingCompany().getFinanceSetup().getBaseCurrency();
            if (!this.entry.getPaymentCurrency().equals(baseCurrency)) {
                result = baseCurrency.round(result.multiply(this.entry.getConversionRate().getRate()));
            }
        }
        return result;
    }
}

