/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.isoft;

import com.varial.base.UtilitiesManager;
import com.varial.license.service.ILicenseService;
import com.varial.license.service.LicenseCodes;

public enum LicenseCodesPayroll {
    MONTHLY_MESSAGES("PYZ769"),
    EVALUATION_DISABILITIES("PYEVDI"),
    SELFSERVICE("SelfService"),
    STATEMENTOFEARNINGS_KNOTT("PY0902-ISW-201769", false),
    STATEMENTOFEARNINGS_ROBERT_LINDNER("PY0902-ISW-202009", false),
    STATEMENTOFEARNINGS_MURTFELDT("PY0902-ISW-200989", false),
    ADDRESSFIELD_CARITAS("PY0902-ISW-201562", false),
    TRANSFERVIEWS_ROBERT_LINDNER("PY1707-ISW-202009", false),
    TRANSFERVIEWS_HUETTENES_ALBERTUS("PY1707-ISW-201176", false),
    COSTINGREPORT_PAUL_SCHULTEN("PY1213-ISW-201827", false),
    PAYROLLPAYMENT_VANDERLANDE(LicenseCodes.PAYROLLPAYMENT_VANDERLANDE, false);

    private final boolean isLicensedInDemo;
    private final String licenseCode;

    private LicenseCodesPayroll(String licenseCode) {
        this(licenseCode, true);
    }

    private LicenseCodesPayroll(String licenseCode, boolean isLicensedInDemo) {
        this.licenseCode = licenseCode;
        this.isLicensedInDemo = isLicensedInDemo;
    }

    private LicenseCodesPayroll(LicenseCodes licenseCode, boolean isLicensedInDemo) {
        this.licenseCode = licenseCode.getLicenseCode();
        this.isLicensedInDemo = isLicensedInDemo;
    }

    public boolean isLicensed() {
        ILicenseService licenseService = (ILicenseService)UtilitiesManager.getBean((String)"licenseService", ILicenseService.class);
        return licenseService.isDemo() && !this.isLicensedInDemo ? false : licenseService.isLicensed(this.licenseCode);
    }
}

