/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.zahls;

import com.varial.base.UtilitiesManager;
import com.varial.base.callback.TransactionMode;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.reports.JasperReportCompiler;
import com.varial.framework.domain.reports.JasperReportManager;
import com.varial.personnel.domain.companyplant.GeneralEmploymentOffice;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.deuvmessaging.SiVersionCheck;
import com.varial.personnel.domain.deuvmessaging.mapper.DeuvmessagingExceptionMapper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundPersistencyManager;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.plant.IPlantPersistencyManager;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportBeanDataSource;
import com.varial.personnel.domain.reports.ReportFormatFactory;
import com.varial.personnel.domain.reports.ReportSecondFilterStruct;
import com.varial.personnel.domain.reports.deuvstatementofcontribution.DEUVCompanyStruct;
import com.varial.personnel.domain.reports.mapper.ReportExceptionMapper;
import com.varial.personnel.domain.reports.zahls.ZahlsProtocolReportDataSource;
import com.varial.personnel.domain.zahls.DueDate;
import com.varial.personnel.domain.zahls.DueDateFilterStruct;
import com.varial.personnel.domain.zahls.IZahlsAccountsCreator;
import com.varial.personnel.domain.zahls.StockMessageFilterStruct;
import com.varial.personnel.domain.zahls.ZahlsAdvice;
import com.varial.personnel.domain.zahls.ZahlsAdviceable;
import com.varial.personnel.domain.zahls.ZahlsTransfer;
import com.varial.personnel.domain.zahls.account.ZahlsAccount;
import com.varial.personnel.domain.zahls.account.ZahlsSetupTypEnum;
import com.varial.personnel.domain.zahls.dsvz.ZahlsDsvz;
import com.varial.personnel.domain.zahls.mapper.ZahlsExceptionMapper;
import com.varial.personnel.framework.D;
import com.varial.personnel.framework.ExclusiveExecutionLockHelper;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.servantimpl.employee.SpecialAccessPrintCommand;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.AllCallbackOperations;
import com.varial.serverbase.query.PutDataException;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;

public class ZahlsProtocolReport
extends SpecialAccessPrintCommand<ReportFileStructCallback> {
    private static final String PROFILE_PREFIX = "ZPR";
    private static final String REPORT_FOLDER = "com/varial/personnel/jasperreport/zahls/";
    private final StockMessageFilterStruct mStruct;
    private final boolean mIsTransfer;
    private final DEUVCompanyStruct[] mCompanyStructs;
    private final boolean mPreview;
    private final boolean mInAdvance;
    private ProgressBarUpdater mProgressBar;
    private final ReportSecondFilterStruct[] mFilters;
    private Date mPseudoDate;

    public ZahlsProtocolReport(AuthorizationToken token, ReportFileStructCallback callback, StockMessageFilterStruct struct, boolean isTransfer, DEUVCompanyStruct[] companyStructs, boolean preview, ZahlsSetupTypEnum setupTypEnum, ReportSecondFilterStruct[] filters, String pseudoDate) throws BusinessDomainException {
        super(token, (AllCallbackOperations)callback, TransactionMode.UPDATE, true);
        this.mStruct = struct;
        this.mIsTransfer = isTransfer;
        if (!StringMapper.isNullString((String)pseudoDate)) {
            if (!DateHelper.validate((String)pseudoDate) || filters == null || filters.length == 0) {
                throw ZahlsExceptionMapper.makeNoValidPseudoDateOrEmployee();
            }
            this.mPseudoDate = DateMapper.toDate((String)pseudoDate);
        }
        if (!(companyStructs != null && companyStructs.length != 0 || filters != null && filters.length != 0 || this.isValid(this.mStruct.dueDate))) {
            throw ZahlsExceptionMapper.makeNoCompanyOrDueDate();
        }
        this.mFilters = filters;
        this.mCompanyStructs = companyStructs;
        this.mPreview = preview;
        this.mInAdvance = ZahlsSetupTypEnum.INADVANCE.equals((Object)setupTypEnum);
    }

    private boolean isValid(DueDateFilterStruct dueDate) {
        return DateHelper.validate((String)this.mStruct.dueDate.dueDate) && !StringMapper.isNullString((String)this.mStruct.dueDate.oidPCompany) && !StringMapper.isNullString((String)this.mStruct.dueDate.oidHealthfund);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BusinessDomainException, PutDataException {
        try {
            DEUVSender deuvSender;
            D.enter();
            ExclusiveExecutionLockHelper.checkExclusiveExecutionLock((Object)((Object)this), (String)"createZahlsAccounts");
            if (this.mPreview) {
                this.setRollbackOnly();
            }
            SiVersionCheck.checkVersionValidness(SiVersionCheck.Type.ZMV);
            ArrayList<String> emptycompanies = new ArrayList<String>(this.mCompanyStructs.length);
            for (DEUVCompanyStruct each : this.mCompanyStructs) {
                if (!this.mIsTransfer) {
                    deuvSender = DEUVSender.getDEUVSender((String)this.mStruct.oidDEUVSender);
                    if (this.setupData(deuvSender, each)) continue;
                    emptycompanies.add(each.oidPCompany);
                    continue;
                }
                if (this.transferData(DeuvHelper.getDeuvSender((PCompany)PCompanyPersistencyManager.getPCompany((String)each.oidPCompany)), each)) continue;
                emptycompanies.add(each.oidPCompany);
            }
            boolean empty = true;
            if (!this.mIsTransfer && (DateHelper.validate((String)this.mStruct.dueDate.dueDate) || this.mFilters.length > 0) && this.setupData(deuvSender = DEUVSender.getDEUVSender((String)this.mStruct.oidDEUVSender), null)) {
                empty = false;
            }
            if (emptycompanies.size() == this.mCompanyStructs.length && empty) {
                throw ReportExceptionMapper.makeNoEmployeeForThisAssortment();
            }
        }
        finally {
            ExclusiveExecutionLockHelper.releaseExclusiveExecutionLock((Object)((Object)this), (String)"createZahlsAccounts");
            D.leave();
            D.statistics();
        }
    }

    private boolean setupData(DEUVSender deuvSender, DEUVCompanyStruct compStruct) throws BusinessDomainException, PutDataException {
        ZahlsAdvice advice;
        DueDate dueDate = null;
        if (DateHelper.validate((String)this.mStruct.dueDate.dueDate) && !StringMapper.isNullString((String)this.mStruct.dueDate.oidHealthfund)) {
            HealthFund hf = HealthFundPersistencyManager.getHealthFund((String)this.mStruct.dueDate.oidHealthfund);
            Date date = DateHelper.getFirstDayOfMonth((Date)DateMapper.toDate((String)this.mStruct.dueDate.dueDate));
            Object oidPCompany = this.mStruct.dueDate.oidPCompany;
            if (StringMapper.isNullString((String)oidPCompany)) {
                oidPCompany = this.mFilters[0].oidPCompany;
            }
            String zahlsNumber = ZahlsProtocolReport.getZahlsNumber((String)oidPCompany, this.mStruct.dueDate.oidPlant, date);
            dueDate = new DueDate(date, hf, zahlsNumber, (String)oidPCompany);
            if (DateHelper.afterOrEqual((Date)VDate.getCurrentLocalizedDateAndTime(), (Date)ZahlsAdvice.INVENTORY_END)) {
                throw ZahlsExceptionMapper.makeInventoryNotAllowedException();
            }
        }
        if ((advice = new ZahlsAdvice(deuvSender, compStruct, this.mFilters, dueDate, this.mPreview, this.mPseudoDate, this.mInAdvance)).isDateOfStartZahlsMissed()) {
            throw ZahlsExceptionMapper.makeDateOfStartZahlsMissedException();
        }
        List untransmitteds = advice.getUntransmitteds();
        if (untransmitteds != null) {
            this.mProgressBar = new ProgressBarUpdater((ReportFileStructCallback)this.getCallback(), untransmitteds.size(), 1, "L\u00f6schen von nicht \u00fcbermittelten Meldungen: ");
            this.mProgressBar.show();
            for (Object each : untransmitteds) {
                this.mProgressBar.update("L\u00f6schen von nicht \u00fcbermittelten Meldungen: ");
                each.makeSaveable();
                each.destroy();
            }
        }
        this.getContext().flush();
        List adviceables = advice.getAdviceables();
        if (adviceables != null) {
            this.mProgressBar = new ProgressBarUpdater((ReportFileStructCallback)this.getCallback(), adviceables.size(), 1, "Aufbau Meldungen: ");
            this.mProgressBar.show();
            for (ZahlsAdviceable each : adviceables) {
                this.mProgressBar.update("Aufbau Meldungen: " + each.getAzVu());
                if (this.mPseudoDate != null) {
                    if (!DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.mPseudoDate), (Date)each.getValidFrom())) continue;
                    advice.create(each);
                    continue;
                }
                if (advice.hasDuesDate()) {
                    if (this.mPreview && DateHelper.before((Date)advice.getDueDate().getMonth(), (Date)DateHelper.addMonths((Date)each.getAfterJournalized(), (int)-1))) {
                        throw ZahlsExceptionMapper.makePreviewStockBeforeJournException((String)each.getAzVu());
                    }
                    if (!advice.isInventory(each)) continue;
                    advice.create(each);
                    continue;
                }
                advice.create(each);
            }
        }
        this.getContext().flush();
        if (advice.hasDuesDate() && advice.getDueDate().getCounter() == 0) {
            throw ZahlsExceptionMapper.makeGivenDueDateMissedException((String)(DateMapper.toDDMMPointEndPointSeparationString((Date)advice.getDueDate().getMonth()) + " " + advice.getDueDate().getZahlNummer() + " " + advice.getDueDate().getHealthFund().getHealthFund()));
        }
        if (!advice.hasDuesDate() && this.mPseudoDate == null && !this.mInAdvance) {
            advice.makeCancelations();
        }
        if (advice.isEmpty()) {
            return false;
        }
        this.getContext().flush();
        ZahlsTransfer transfer = new ZahlsTransfer(advice);
        transfer.verifyTransfer(this.mPseudoDate != null && !this.mInAdvance);
        this.getContext().flush();
        File file = JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)this.compileReport("ZahlsProtocolReport"), this.createParameters(), (JRDataSource)this.createDataSource((IZahlsAccountsCreator)advice), (String)PROFILE_PREFIX);
        String[] reports = new String[]{JasperReportManager.getUrl((File)file)};
        ((ReportFileStructCallback)this.getCallback()).putData(reports);
        return true;
    }

    public static String getZahlsNumber(Employee employee, Date effectiveTP, Date validTP) throws BusinessDomainException {
        String result = "";
        Plant plant = employee.getAppurtenantPlant(effectiveTP, validTP);
        String oidPlant = "";
        if (plant != null) {
            oidPlant = plant.getObjectid();
        }
        if (StringMapper.isNullString((String)(result = ZahlsProtocolReport.getZahlsNumber(employee.getPCompany().getObjectid(), oidPlant, validTP)))) {
            result = ZahlsProtocolReport.getZahlsNumber(employee.getPCompany().getObjectid(), null, validTP);
        }
        return result;
    }

    public static String getZahlsNumber(String oidPCompany, String oidPlant, Date dueDate) throws BusinessDomainException {
        return ZahlsProtocolReport.getGeneralEmploymentOffice(oidPCompany, oidPlant, dueDate).getStandardPaymentPointNumberPensionersHealthInsurance();
    }

    private static GeneralEmploymentOffice getGeneralEmploymentOffice(String oidPCompany, String oidPlant, Date dueDate) throws BusinessDomainException {
        GeneralEmploymentOffice result;
        if (StringMapper.isNullString((String)oidPlant)) {
            result = ZahlsProtocolReport.getPCompany(oidPCompany).getCompanyEmploymentOffice(VDate.getDateMax(), dueDate).getGeneralEmploymentOffice();
        } else {
            try {
                result = ZahlsProtocolReport.getPlant(oidPlant).getPlantEmploymentOffice(VDate.getDateMax(), dueDate).getGeneralEmploymentOffice();
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                    result = ZahlsProtocolReport.getPCompany(oidPCompany).getCompanyEmploymentOffice(VDate.getDateMax(), dueDate).getGeneralEmploymentOffice();
                }
                throw e;
            }
        }
        return result;
    }

    private static PCompany getPCompany(String oidPCompany) {
        return PCompanyPersistencyManager.getPCompany((String)oidPCompany);
    }

    private static Plant getPlant(String oidPlant) {
        return ((IPlantPersistencyManager)UtilitiesManager.getBean((String)"plantPersistencyManager", IPlantPersistencyManager.class)).getPlant(oidPlant);
    }

    private boolean transferData(DEUVSender deuvSender, DEUVCompanyStruct compStruct) throws BusinessDomainException, PutDataException {
        ZahlsAdvice advice = new ZahlsAdvice(deuvSender, compStruct);
        if (advice.isEmpty()) {
            return false;
        }
        for (ZahlsAccount each : advice.getCreateds()) {
            ZahlsDsvz dsvz = each.getZahlsDsvz();
            dsvz.makeSaveable();
            dsvz.setDatenSatzId(each.getObjectid());
        }
        this.getContext().flush();
        ZahlsTransfer transfer = new ZahlsTransfer(advice);
        List accounts = transfer.getRecipients().stream().flatMap(recipient -> recipient.getAccounts().stream()).collect(Collectors.toList());
        for (ZahlsAccount zahlsAccount : accounts) {
            if (zahlsAccount.getZahlsDsvz().isCurrentVersion()) continue;
            throw DeuvmessagingExceptionMapper.makeOldVersionCheckDomainException();
        }
        transfer.createTransferFiles();
        this.getContext().flush();
        File file = JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)this.compileReport("ZahlsProtocolReport"), this.createParameters(), (JRDataSource)this.createDataSource((IZahlsAccountsCreator)advice), (String)PROFILE_PREFIX);
        String[] reports = new String[]{JasperReportManager.getUrl((File)file)};
        ((ReportFileStructCallback)this.getCallback()).putData(reports);
        transfer.writePerfidiaFiles();
        return true;
    }

    private Map<String, Object> createParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("dbanReport", this.compileReport("DbanSubreport"));
        parameters.put("dbfeReport", this.compileReport("DbfeSubreport"));
        parameters.put("dbgaReport", this.compileReport("DbgaSubreport"));
        parameters.put("dbkzReport", this.compileReport("DbkzSubreport"));
        parameters.put("dbnaReport", this.compileReport("DbnaSubreport"));
        parameters.put("dbzkReport", this.compileReport("DbzkSubreport"));
        parameters.put("dsvzReport", this.compileReport("DsvzSubreport"));
        parameters.put("recipientReport", this.compileReport("RecipientSubreport"));
        parameters.put("REPORT_FORMAT_FACTORY", new ReportFormatFactory());
        parameters.put("user", this.getUser());
        return parameters;
    }

    private String getUser() {
        SessionContext sc = SessionContext.getInstance();
        if (sc == null) {
            return "";
        }
        return sc.getSession().getUserCode();
    }

    private JRDataSource createDataSource(IZahlsAccountsCreator advice) {
        final ZahlsProtocolReportDataSource ds = new ZahlsProtocolReportDataSource(advice, this.mIsTransfer, this.mPreview);
        ReportBeanDataSource dataSource = new ReportBeanDataSource(ds){

            protected boolean doNext() throws JRException {
                return ds.next();
            }
        };
        return dataSource;
    }

    public JasperReport compileReport(String reportName) {
        return JasperReportCompiler.compileReport((String)(REPORT_FOLDER + reportName + ".jrxml"));
    }
}

