/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.statementofcontributionkvdr;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.CorbaExceptionMapper;
import com.varial.interfaces.IPersonalAccount;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.AssignmentPCompanyHealthFund;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.AssignmentPCompanyHealthFundTP;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.mapper.PaymentModeEnumMapper;
import com.varial.personnel.domain.companyplant.CompanyPlantPostalAddress;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.companyplant.GeneralEmploymentOffice;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.global.federalstate.FederalStateTP;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.emploffice.CompanyEmploymentOffice;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.pcompany.settings.CompanySettings;
import com.varial.personnel.domain.plant.IPlantPersistencyManager;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.emploffice.PlantEmploymentOffice;
import com.varial.personnel.domain.plant.foundations.PlantFoundations;
import com.varial.personnel.domain.reports.ArchivingMetadata;
import com.varial.personnel.domain.reports.EmployeeForReport;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportRespectValuateEnum;
import com.varial.personnel.domain.reports.ReportSecondFilterStruct;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.ReportThirdFilterStruct;
import com.varial.personnel.domain.reports.library.EmployeeForReportGenerator;
import com.varial.personnel.domain.reports.library.ReportEmployeesHandlingHelper;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.library.ReportValues;
import com.varial.personnel.domain.reports.mapper.ReportExceptionMapper;
import com.varial.personnel.domain.reports.statementofcontribution.SOCDataSourceHelper;
import com.varial.personnel.domain.reports.statementofcontribution.mapper.SOCRExceptionMapper;
import com.varial.personnel.domain.reports.statementofcontributionkvdr.EmployeeForSOCKVDRBean;
import com.varial.personnel.domain.reports.statementofcontributionkvdr.PaymentCompHealthFundBean;
import com.varial.personnel.domain.reports.statementofcontributionkvdr.SOCKVDRReportSortComparator;
import com.varial.personnel.domain.reports.statementofcontributionkvdr.StatementOfContributionGlobalSocialInsuranceKVDRBean;
import com.varial.personnel.domain.reports.statementofcontributionkvdr.StatementOfContributionHealthFundKVDRBean;
import com.varial.personnel.domain.reports.statementofcontributionkvdr.StatementOfContributionKVDRSumBean;
import com.varial.personnel.domain.reports.statementofcontributionkvdr.StatementOfContributionSummKVDRBean;
import com.varial.personnel.domain.reports.statementofcontributionkvdr.StatementOfContributionTypeKVDRBean;
import com.varial.personnel.framework.ISpecialAccessPersistencyContext;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.basictypes.PostalAddress;
import com.varial.personnel.framework.mapper.TypeOfBankTransferEnumMapper;
import com.varial.personnel.persistency.assignments.comphealthfunall.ComphealthfunallContainer;
import com.varial.personnel.persistency.assignments.comphealthfunall.IComphealthfunallDao;
import com.varial.personnel.persistency.employee.valueposition.ValuepositionContainer;
import com.varial.personnel.persistency.global.fstateregionall.FstateregionallContainer;
import com.varial.personnel.persistency.global.fstateregionall.IFstateregionallDao;
import com.varial.personnel.persistency.global.socialinsurance.ISocialinsuranceDao;
import com.varial.personnel.persistency.global.socialinsurance.SocialinsuranceContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.query.AllCallback;
import com.varial.shared.Version;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementOfContributionKVDRReportDataSource
implements JRDataSource {
    private static IComphealthfunallDao daoComphealthfunall = (IComphealthfunallDao)UtilitiesManager.getBean((String)"comphealthfunallDao", IComphealthfunallDao.class);
    private static IFstateregionallDao daoFstateregionall = (IFstateregionallDao)UtilitiesManager.getBean((String)"fstateregionallDao", IFstateregionallDao.class);
    private static ISocialinsuranceDao daoSocialinsurance = (ISocialinsuranceDao)UtilitiesManager.getBean((String)"socialinsuranceDao", ISocialinsuranceDao.class);
    private static IPlantPersistencyManager pm = (IPlantPersistencyManager)UtilitiesManager.getBean((String)"plantPersistencyManager", IPlantPersistencyManager.class);
    private static Logger LOGGER = LoggerFactory.getLogger(StatementOfContributionKVDRReportDataSource.class);
    private final ReportHelper mReportHelper = (ReportHelper)UtilitiesManager.getBean((String)"reportHelper", ReportHelper.class);
    private static final int FIELD_Status_int = 0;
    private static final String mMinijobZentraleNumber = "98000006";
    private final String[] mResultValueTypeNumber = new String[]{"129300", "129310", "130520", "350510", "351510", "354510", "355510", "351516", "355516", "102560"};
    private PaymentCompHealthFundBean mPaymentCompHealthFundBean;
    private String FIELD_jahr = "";
    private String FIELD_firma_bezeichnung = "";
    private String FIELD_betriebsstaette_bezeichnung = "";
    private String FIELD_betriebsstaette_beitragskonto_nr = "";
    private String FIELD_kk_bezeichnung = "";
    private String FIELD_firma_nr = "";
    private String FIELD_betriebsstaette_nr = "";
    private String FIELD_kk_str_nr = "";
    private String FIELD_kk_plz_ort = "";
    private String FIELD_kk_betriebs_nr = "";
    private String FIELD_AG_str_nr = "";
    private String FIELD_AG_plz_ort = "";
    private String FIELD_AG_beitragskontonummer = "";
    private String FIELD_AG_VWE_NR = "";
    private String FIELD_rk_header = "";
    private String FIELD_AG_bezeichnung = "";
    private String FIELD_AG_betriebsnummer = "";
    private final String FIELD_Status = "";
    private String FIELD_header_monat_bezeichnung = "";
    private String FIELD_subreport_monat_bezeichnung = "";
    private String FIELD_pers_nr = "";
    private String FIELD_vorname = "";
    private String FIELD_familienname = "";
    private String FIELD_geb_datum = "";
    private String FIELD_aktenzeichen = "";
    private String FIELD_versicherungsnummer = "";
    private String FIELD_pgs = "";
    private String FIELD_sv_nummer = "";
    private IPersonalAccount FIELD_personalAccount = null;
    private String FIELD_taxCode = "";
    private String FIELD_bgs_kv = "";
    private String FIELD_bgs_pv = "";
    private String FIELD_parent = "";
    private int FIELD_Monat_int;
    private static final String PARAMETER_USER = "Parameter_User";
    private static final String staticText_internalUse = "internalUse_1";
    private static final String staticText_sichtDatum = "sichtDatum";
    private String mStaticText_internalUse = "";
    private Integer FIELD_seitenzahl = 0;
    private String FIELD_seitenwechsel = "Seitenwechesl_1";
    private int mTypeBeansSerialNumber = 0;
    private List<String> mNoInsuranceDataErrorList;
    private final String mOidPCompany;
    private String mPCompanyLongDescription = "";
    protected PCompany mPCompany;
    protected Foundations mPCompanyFoundations;
    private CompanyPlantPostalAddress mPCompanyPlantPostalAddress;
    private GeneralEmploymentOffice mPCompanyGeneralEmploymentOffice;
    protected final Date mForEffectiveDate;
    protected final Date mForValidDate;
    private Date mListFirstDate;
    private Date mListEndDate;
    private final Date mCalculationStartDate;
    private final ReportValues mReportValues = new ReportValues();
    private boolean mInternalUse = true;
    private boolean mPayment = false;
    private boolean mEmployeePlantIsEast = false;
    private boolean mFirstPurchase = true;
    private boolean mHasNaxt = false;
    private boolean mLeaveNext = false;
    private String mFFSOidHealthFund = "";
    private String mSelHFDes = "";
    private String mSelHFDesBuKnSpace = "";
    private String mPCompanyKey = "";
    private String mCompanyEmployerNumber = "";
    private String mCompanyKVDRZahlstellenNumber = "";
    private final Map<String, Foundations> mPlantFoundationsMap = new HashMap<String, Foundations>();
    private final Map<String, String> mPlantLongDescriptionMap = new HashMap<String, String>();
    private final Map<String, Plant> mPlantMap = new HashMap<String, Plant>();
    private final Map<String, String> mPlantKeyMap = new HashMap<String, String>();
    private final Map<String, String> mLawAreaMap = new HashMap<String, String>();
    private final Map<String, Insurance> mInsuranceMap = new HashMap<String, Insurance>();
    private final Map<String, Employee> mEmployeeMap = new HashMap<String, Employee>();
    private final Map<String, HealthFundTP> mHealthFundTPMap = new HashMap<String, HealthFundTP>();
    private final Map<String, HealthFund> mHealthFundMap = new HashMap<String, HealthFund>();
    private final Map<String, String> mHealthFundShortDescriptionMap = new HashMap<String, String>();
    private List<ComphealthfunallContainer> mCompHealthFundAllList = new LinkedList<ComphealthfunallContainer>();
    private final Map<String, String> mStandardCompanyNumberMap = new HashMap<String, String>();
    private Map<String, List<FstateregionallContainer>> mFstateregionallMap = new HashMap<String, List<FstateregionallContainer>>();
    private final Map<String, AssignmentPCompanyHealthFund> mCompHealthfundMap = new HashMap<String, AssignmentPCompanyHealthFund>();
    private final Map<String, AssignmentPCompanyHealthFundTP> mCompHealthfundTPMap = new HashMap<String, AssignmentPCompanyHealthFundTP>();
    private final Map<String, String> mEmployeeCorrectionMap = new HashMap<String, String>();
    private ComphealthfunallContainer mCompHFAForPayment;
    private final Iterator<StatementOfContributionTypeKVDRBean> mEmployeeForReportIt;
    private Collection<StatementOfContributionGlobalSocialInsuranceKVDRBean> mGlobalSocialInsuranceKVDRCollection = new LinkedList<StatementOfContributionGlobalSocialInsuranceKVDRBean>();
    private Collection<StatementOfContributionHealthFundKVDRBean> mHealthFundKVDRCollection = new LinkedList<StatementOfContributionHealthFundKVDRBean>();
    private final Collection<StatementOfContributionTypeKVDRBean> mTypeInsuredCollection = new LinkedList<StatementOfContributionTypeKVDRBean>();
    private final Collection<StatementOfContributionSummKVDRBean> mSummKVDRCollection = new LinkedList<StatementOfContributionSummKVDRBean>();
    protected final Collection<StatementOfContributionKVDRSumBean> mSummBeanCollection = new LinkedList<StatementOfContributionKVDRSumBean>();
    private BigDecimal FIELD_129300_summierung = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_129310_summierung = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_130520_summierung = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_350510_summierung = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_351510_summierung = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_351516_summierung = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_354510_summierung = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_355510_summierung = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_kv_1000_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_kv_2000_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_kv_3000_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_pv_0001_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_pv_0002_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_pv_0003_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_pv_0004_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_pv_0005_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_kv_1000_beitrag = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_kv_2000_beitrag = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_kv_3000_beitrag = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_pv_0001_beitrag = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_pv_0002_beitrag = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_pv_0003_beitrag = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_pv_0004_beitrag = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_pv_0005_beitrag = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_kv_zusatzbeitrag = BigDecimal.valueOf(0L, 2);
    private BigDecimal f_summe_beitrag = BigDecimal.valueOf(0L, 2);
    protected String f_zahlungsart = "";
    protected String f_blz_krk = "";
    protected String f_bankbez = "";
    protected String f_kontonr_krk = "";
    private StatementOfContributionTypeKVDRBean mSOCKVDRTypeBeanForReport;
    private StatementOfContributionTypeKVDRBean mSOCKVDRTypeBeanForReportNext;
    private final EmployeeForReportGenerator generator;
    private final EmployeeForReport[] mEmployees;
    private boolean mWithCorrection = false;
    private boolean mStatementOfContributionProCompany = false;
    private BigDecimal mGesamtSumme = BigDecimal.ZERO;
    private final AllCallback callback;
    protected ProgressBarUpdater mProgressBar;
    private final int mCountIterations;

    public StatementOfContributionKVDRReportDataSource(AllCallback callback, ISpecialAccessPersistencyContext specialAccessPersistencyContext, ReportFirstFilterStruct firstFilter, ReportSecondFilterStruct[] secondFilters, ReportThirdFilterStruct thirdFilter, ReportSortStruct[] sorts, Date forEffectiveDate, Date forValidDate, boolean payment, boolean withCorrection, boolean internalUse, boolean isTransfer, ProgressBarUpdater progressBar, List<String> errorList) throws BusinessDomainException {
        this.callback = callback;
        this.mPayment = payment;
        this.mInternalUse = internalUse;
        this.mForEffectiveDate = DateHelper.getLastDayOfMonth((Date)forEffectiveDate);
        this.mForValidDate = DateHelper.getLastDayOfMonth((Date)forValidDate);
        this.mListFirstDate = DateHelper.getFirstDayOfMonth((Date)this.mForValidDate);
        this.mListEndDate = DateHelper.getLastDayOfMonth((Date)this.mForValidDate);
        this.mProgressBar = progressBar;
        this.mWithCorrection = DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2009, 0, 1).getDate()) ? withCorrection : false;
        this.initCurrentObjects();
        if (firstFilter != null && !StringMapper.isNullString((String)firstFilter.oidHealthFund)) {
            this.mFFSOidHealthFund = firstFilter.oidHealthFund;
            HealthFundTP hFTP = this.getHealthFundTP(this.mFFSOidHealthFund, this.mForEffectiveDate, this.mForValidDate);
            if (hFTP == null) {
                throw SOCRExceptionMapper.makeNoHealthfundExistent();
            }
            this.mSelHFDes = hFTP.getShortDescription();
            if (StringMapper.isNullString((String)this.mSelHFDes)) {
                throw SOCRExceptionMapper.makeNoHealthfundShortDescriptionExistent();
            }
            if (StringMapper.isNullString((String)hFTP.getStandardCompanyNumber())) {
                throw SOCRExceptionMapper.makeNoHealthfundStandardCompanyNumberExistent();
            }
            this.mSelHFDes = this.mSelHFDes + hFTP.getStandardCompanyNumber();
        }
        this.generator = new EmployeeForReportGenerator(specialAccessPersistencyContext, firstFilter, secondFilters, thirdFilter, sorts, forEffectiveDate, this.mListFirstDate, this.mListEndDate, errorList, ReportRespectValuateEnum.RRVE_Keine_Reaktion_auf_Fehler, this.mProgressBar);
        this.mEmployees = this.generator.getEmployeesForReport();
        List<String> oidPlantLi = this.getOidUniqueOidPlantList(this.mEmployees);
        Iterator<String> oidPlantIt = oidPlantLi.iterator();
        while (oidPlantIt.hasNext()) {
            String oidPlant = oidPlantIt.next().toString();
            this.setEmployeePlantIsEast(oidPlant);
        }
        this.mOidPCompany = this.getOidPCompany();
        this.mPCompany = this.getPCompany();
        this.mPCompanyFoundations = this.getCompanyFoundations();
        this.mPCompanyLongDescription = this.getCompanyLongDescription();
        this.mCalculationStartDate = this.mReportHelper.getCalculationStartDate(this.mPCompany.getCompanyFoundations(this.mForEffectiveDate, this.mListEndDate));
        this.mListFirstDate = DateHelper.before((Date)this.mListFirstDate, (Date)this.mCalculationStartDate) ? this.mCalculationStartDate : this.mListFirstDate;
        CompanySettings companySettings = this.mPCompany.getCompanySettings(this.mForEffectiveDate, this.mForValidDate);
        this.mStatementOfContributionProCompany = companySettings.getStatementOfContributionProCompany();
        this.mCompHealthFundAllList = this.getListCompHealthFundAll(new String[]{this.getOidPCompany()}, this.mForEffectiveDate, this.mCalculationStartDate, this.mListEndDate);
        List<StatementOfContributionTypeKVDRBean> reportTypeBeansLi = this.getOverSteuerungsModulEmployeeBeans(this.mEmployees);
        if (reportTypeBeansLi.isEmpty() && !isTransfer) {
            throw ReportExceptionMapper.makeNoEmployeeForThisAssortment();
        }
        LinkedList<StatementOfContributionTypeKVDRBean> trash = new LinkedList<StatementOfContributionTypeKVDRBean>();
        for (StatementOfContributionTypeKVDRBean bean : reportTypeBeansLi) {
            Employee employee = (Employee)this.generator.used((IPersistentObject)this.getIEmployeePM().getEmployee(bean.getOidEmployee()));
            if (!this.generator.isValuated(employee)) {
                errorList.add("Personalnummer: " + bean.getF_pers_nr() + " Name: " + bean.getF_familienname());
                trash.add(bean);
            }
            if (this.mInternalUse || !DateHelper.after((Date)this.mForValidDate, (Date)DateHelper.getLastDayOfMonth((Date)employee.getJournalizedUntil()))) continue;
            throw ReportExceptionMapper.makeEmployeeNotJournalized((String)"\nDie KVdR-Mitarbeiter m\u00fcssen f\u00fcr den eingegebenen G\u00fcltigkeitsmonat journalisiert sein!");
        }
        if (!errorList.isEmpty()) {
            reportTypeBeansLi.removeAll(trash);
            String[] temp = errorList.toArray(new String[errorList.size()]);
            BusinessDomainException de = ReportExceptionMapper.makeStickyEmployeesInEmployeeForReport((String[])temp);
            errorList.clear();
            if (internalUse) {
                callback.setDomainException(CorbaExceptionMapper.toDomainExceptionStruct((BusinessDomainException)de));
            } else {
                throw de;
            }
        }
        this.setGlobalSocialInsuranceKVDRCollection();
        this.mEmployeeForReportIt = reportTypeBeansLi.iterator();
        this.mCountIterations = this.getCountIterations(reportTypeBeansLi);
    }

    private List<StatementOfContributionTypeKVDRBean> getOverSteuerungsModulEmployeeBeans(EmployeeForReport[] efrs) throws BusinessDomainException {
        HashMap<String, Map<String, List<EmployeeForSOCKVDRBean>>> pcompanyPlantMap = new HashMap<String, Map<String, List<EmployeeForSOCKVDRBean>>>();
        LinkedList<StatementOfContributionTypeKVDRBean> retroActiveTypeBeansLi = new LinkedList<StatementOfContributionTypeKVDRBean>();
        for (int i = 0; i < efrs.length; ++i) {
            String oidPCompany;
            Date currentValidUntilDate;
            EmployeeForReport currentEmployee = efrs[i];
            String currentOidEmployee = currentEmployee.getOidEmployee();
            Insurance insurance = null;
            HealthFund healthFundKVDR = null;
            Date currentEmployeeFirstDate = currentEmployee.getDateOfEntry();
            Date currentEmployeeLastDate = currentEmployee.getDateOfWithDrawal();
            Date currentValidFromDate = DateHelper.before((Date)this.mListFirstDate, (Date)currentEmployeeFirstDate) ? currentEmployeeFirstDate : this.mListFirstDate;
            currentEmployeeLastDate = currentEmployeeLastDate == null ? VDate.getDateMax() : currentEmployeeLastDate;
            Date date = currentValidUntilDate = DateHelper.before((Date)this.mListEndDate, (Date)currentEmployeeLastDate) ? this.mListEndDate : currentEmployeeLastDate;
            if (DateHelper.afterOrEqual((Date)currentValidUntilDate, (Date)currentValidFromDate)) {
                insurance = this.getInsurance(currentOidEmployee, this.mForEffectiveDate, currentValidFromDate);
                if (insurance == null) {
                    this.mNoInsuranceDataErrorList.add("Personalnummer: " + efrs[i].getPersonnelNumber() + " Name: " + efrs[i].getSurname());
                    continue;
                }
                healthFundKVDR = insurance.getHealthFundKVdR();
                if (healthFundKVDR != null) {
                    EmployeeForSOCKVDRBean aktuallEmployeeForSOCBean = new EmployeeForSOCKVDRBean(currentEmployee.getPersonnelNumber(), currentEmployee.getSurname(), currentEmployee.getFirstname(), this.getDateOfBirth(currentEmployee.getOidPCompany(), currentEmployee.getPersonnelNumber()), currentOidEmployee, currentEmployee.getOidPCompany(), currentEmployee.getOidPlant(), this.mForEffectiveDate, currentValidFromDate, currentValidUntilDate);
                    this.getEmployeeProperties(aktuallEmployeeForSOCBean, healthFundKVDR);
                    if (DateHelper.afterOrEqual((Date)currentValidUntilDate, (Date)new VDate(2009, 0, 1).getDate()) || !this.mWithCorrection) {
                        this.setEmployeeForSOCKVDRBean(aktuallEmployeeForSOCBean, pcompanyPlantMap);
                    } else {
                        oidPCompany = this.mEmployeeCorrectionMap.get(currentEmployee.getPersonnelNumber());
                        if (StringMapper.isNullString((String)oidPCompany)) {
                            this.mEmployeeCorrectionMap.put(currentEmployee.getPersonnelNumber(), currentEmployee.getOidPCompany());
                        }
                    }
                }
            }
            Date retroactiveCorrectionDate = null;
            if (!DateHelper.equal((Date)this.mForEffectiveDate, (Date)this.mForValidDate) || (retroactiveCorrectionDate = ReportEmployeesHandlingHelper.getRetroactiveCorrectionDate((String[])new String[]{currentEmployee.getOidEmployee()}, (Date)this.mForEffectiveDate, (Date)this.mListFirstDate, (Date)this.mCalculationStartDate)) == null) continue;
            Date retroactiveCorrectionValidFrom = DateHelper.getFirstDayOfMonth((Date)retroactiveCorrectionDate);
            retroactiveCorrectionValidFrom = DateHelper.before((Date)retroactiveCorrectionValidFrom, (Date)currentEmployeeFirstDate) ? currentEmployeeFirstDate : retroactiveCorrectionValidFrom;
            Date lastRRMonth = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate));
            Date oldEffectiveDate = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate));
            while (DateHelper.beforeOrEqual((Date)retroactiveCorrectionValidFrom, (Date)lastRRMonth)) {
                Date validUntilDate = DateHelper.getLastDayOfMonth((Date)retroactiveCorrectionValidFrom);
                validUntilDate = DateHelper.after((Date)validUntilDate, (Date)lastRRMonth) ? lastRRMonth : validUntilDate;
                insurance = this.getInsurance(currentEmployee.getOidEmployee(), this.mForEffectiveDate, retroactiveCorrectionValidFrom);
                HashMap<String, Map<String, List<EmployeeForSOCKVDRBean>>> pcompanyPlantMapNew = null;
                HashMap<String, Map<String, List<EmployeeForSOCKVDRBean>>> pcompanyPlantMapOld = null;
                if (insurance != null && insurance.getHealthFundKVdR() != null) {
                    pcompanyPlantMapNew = new HashMap<String, Map<String, List<EmployeeForSOCKVDRBean>>>();
                    EmployeeForSOCKVDRBean employeeForSOCBeanNew = new EmployeeForSOCKVDRBean(currentEmployee.getPersonnelNumber(), currentEmployee.getSurname(), currentEmployee.getFirstname(), this.getDateOfBirth(currentEmployee.getOidPCompany(), currentEmployee.getPersonnelNumber()), currentOidEmployee, currentEmployee.getOidPCompany(), currentEmployee.getOidPlant(), this.mForEffectiveDate, retroactiveCorrectionValidFrom, validUntilDate);
                    this.getEmployeeProperties(employeeForSOCBeanNew, insurance.getHealthFundKVdR());
                    if (DateHelper.afterOrEqual((Date)validUntilDate, (Date)new VDate(2009, 0, 1).getDate()) || !this.mWithCorrection) {
                        this.setEmployeeForSOCKVDRBean(employeeForSOCBeanNew, pcompanyPlantMapNew);
                    } else {
                        oidPCompany = this.mEmployeeCorrectionMap.get(currentEmployee.getPersonnelNumber());
                        if (StringMapper.isNullString((String)oidPCompany)) {
                            this.mEmployeeCorrectionMap.put(currentEmployee.getPersonnelNumber(), currentEmployee.getOidPCompany());
                        }
                    }
                }
                if ((insurance = this.getInsurance(currentEmployee.getOidEmployee(), oldEffectiveDate, retroactiveCorrectionValidFrom)) != null && insurance.getHealthFundKVdR() != null) {
                    pcompanyPlantMapOld = new HashMap<String, Map<String, List<EmployeeForSOCKVDRBean>>>();
                    EmployeeForSOCKVDRBean employeeForSOCBeanOld = new EmployeeForSOCKVDRBean(currentEmployee.getPersonnelNumber(), currentEmployee.getSurname(), currentEmployee.getFirstname(), this.getDateOfBirth(currentEmployee.getOidPCompany(), currentEmployee.getPersonnelNumber()), currentOidEmployee, currentEmployee.getOidPCompany(), currentEmployee.getOidPlant(), oldEffectiveDate, retroactiveCorrectionValidFrom, validUntilDate);
                    this.getEmployeeProperties(employeeForSOCBeanOld, insurance.getHealthFundKVdR());
                    if (DateHelper.afterOrEqual((Date)validUntilDate, (Date)new VDate(2009, 0, 1).getDate()) || !this.mWithCorrection) {
                        this.setEmployeeForSOCKVDRBean(employeeForSOCBeanOld, pcompanyPlantMapOld);
                    } else {
                        oidPCompany = this.mEmployeeCorrectionMap.get(currentEmployee.getPersonnelNumber());
                        if (StringMapper.isNullString((String)oidPCompany)) {
                            this.mEmployeeCorrectionMap.put(currentEmployee.getPersonnelNumber(), currentEmployee.getOidPCompany());
                        }
                    }
                }
                if (pcompanyPlantMapNew != null || pcompanyPlantMapOld != null) {
                    if (pcompanyPlantMapNew != null && pcompanyPlantMapOld == null) {
                        List<StatementOfContributionTypeKVDRBean> newStatementOfContributionTypeKVDRBeanLi = this.getNewStatementOfContributionKVDRBeanList(pcompanyPlantMapNew);
                        retroActiveTypeBeansLi.addAll(newStatementOfContributionTypeKVDRBeanLi);
                    }
                    if (pcompanyPlantMapNew == null && pcompanyPlantMapOld != null) {
                        List<StatementOfContributionTypeKVDRBean> oldStatementOfContributionTypeKVDRBeanLi = this.getOldStatementOfContributionKVDRBeanList(pcompanyPlantMapOld);
                        retroActiveTypeBeansLi.addAll(oldStatementOfContributionTypeKVDRBeanLi);
                    }
                    if (pcompanyPlantMapNew != null && pcompanyPlantMapOld != null) {
                        List<EmployeeForSOCKVDRBean> currentEmployeeSONewBeanLi = this.sortEmployeeForReport(pcompanyPlantMapNew);
                        List<EmployeeForSOCKVDRBean> currentEmployeeSOOldBeanLi = this.sortEmployeeForReport(pcompanyPlantMapOld);
                        retroActiveTypeBeansLi.addAll(this.comperatorOldNew(currentEmployeeSONewBeanLi, currentEmployeeSOOldBeanLi));
                    }
                }
                retroactiveCorrectionValidFrom = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)retroactiveCorrectionValidFrom));
            }
        }
        if (!this.mNoInsuranceDataErrorList.isEmpty()) {
            String[] temp = new String[this.mNoInsuranceDataErrorList.size()];
            this.mNoInsuranceDataErrorList.toArray(temp);
            BusinessDomainException de = ReportExceptionMapper.makeNoInsuranceData((String[])temp);
            this.callback.setDomainException(CorbaExceptionMapper.toDomainExceptionStruct((BusinessDomainException)de));
        }
        List<StatementOfContributionTypeKVDRBean> employeesTypeBeansLi = new LinkedList<StatementOfContributionTypeKVDRBean>();
        List<EmployeeForSOCKVDRBean> currentsEmployeesSOBeanLi = this.sortEmployeeForReport(pcompanyPlantMap);
        if (currentsEmployeesSOBeanLi != null && !currentsEmployeesSOBeanLi.isEmpty()) {
            for (EmployeeForSOCKVDRBean employeeForSOCBean : currentsEmployeesSOBeanLi) {
                this.getDataForEmployee(employeeForSOCBean);
                StatementOfContributionTypeKVDRBean sOCTypeKVDRBean = this.addDataEmployeeForDetailCollections(employeeForSOCBean);
                sOCTypeKVDRBean.setStatus_int(0);
                sOCTypeKVDRBean.setF_status("");
                employeesTypeBeansLi.add(sOCTypeKVDRBean);
                this.resetBeanFileds();
            }
        }
        if (!retroActiveTypeBeansLi.isEmpty()) {
            employeesTypeBeansLi.addAll(retroActiveTypeBeansLi);
            employeesTypeBeansLi = this.setStatementOfContributionTypeKVDRBean(employeesTypeBeansLi);
        }
        return employeesTypeBeansLi;
    }

    private List<StatementOfContributionTypeKVDRBean> getOldStatementOfContributionKVDRBeanList(Map<String, Map<String, List<EmployeeForSOCKVDRBean>>> pcompanyPlantMapOld) throws BusinessDomainException {
        List<EmployeeForSOCKVDRBean> currentEmployeeSOOldBeanLi = this.sortEmployeeForReport(pcompanyPlantMapOld);
        List<StatementOfContributionTypeKVDRBean> oldStatementOfContributionTypeKVDRBeanLi = this.getStatementOfContributionTypeKVDRBeanLi(currentEmployeeSOOldBeanLi);
        this.setNewTypeBean(oldStatementOfContributionTypeKVDRBeanLi);
        return oldStatementOfContributionTypeKVDRBeanLi;
    }

    private List<StatementOfContributionTypeKVDRBean> getNewStatementOfContributionKVDRBeanList(Map<String, Map<String, List<EmployeeForSOCKVDRBean>>> pcompanyPlantMapNew) throws BusinessDomainException {
        List<EmployeeForSOCKVDRBean> currentEmployeeSONewBeanLi = this.sortEmployeeForReport(pcompanyPlantMapNew);
        List<StatementOfContributionTypeKVDRBean> newStatementOfContributionTypeKVDRBeanLi = this.getStatementOfContributionTypeKVDRBeanLi(currentEmployeeSONewBeanLi);
        this.setNewTypeBean(newStatementOfContributionTypeKVDRBeanLi);
        return newStatementOfContributionTypeKVDRBeanLi;
    }

    protected void setGlobalSocialInsuranceKVDRCollection() {
        this.mGlobalSocialInsuranceKVDRCollection = this.getGlobalSocialInsuranceCollection(this.mForEffectiveDate, DateHelper.getFirstDayOfYear((Date)this.mListFirstDate), DateHelper.getLastDayOfYear((Date)this.mListEndDate));
    }

    protected void setHealthFundKVDRCollection() {
        this.mHealthFundKVDRCollection = this.getHealthFundCollection(this.mSOCKVDRTypeBeanForReport.getOidHealthFund(), this.mForEffectiveDate, this.mForValidDate);
    }

    protected String getPurePersonnelNumber(String personnelNumber) {
        return StringMapper.removeLeftSideZero((String)personnelNumber);
    }

    protected void initCurrentObjects() {
        if (this.mInternalUse) {
            this.mStaticText_internalUse = "Interner Gebrauch";
        }
        if (this.mPayment) {
            this.mStaticText_internalUse = "Zahlungslauf";
        }
        this.mListFirstDate = DateHelper.getFirstDayOfMonth((Date)this.mForValidDate);
        this.mListEndDate = DateHelper.getLastDayOfMonth((Date)this.mForValidDate);
        this.mFstateregionallMap = this.getHashMapFstateregionall();
        this.mNoInsuranceDataErrorList = new LinkedList<String>();
    }

    public Map<String, Object> getParameters() {
        JasperParameterHashMap parameters = new JasperParameterHashMap();
        parameters.put(PARAMETER_USER, this.getUserID());
        parameters.put(staticText_internalUse, this.mStaticText_internalUse);
        parameters.put(staticText_sichtDatum, DateMapper.toDDMMYYYYPointSeparationString((Date)this.mForEffectiveDate));
        return parameters;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Integer value = null;
        String fieldName = field.getName();
        if (fieldName.equals("version")) {
            return Version.getVersion();
        }
        if (fieldName.equals("monat_bezeichnung")) {
            return this.FIELD_header_monat_bezeichnung;
        }
        if (fieldName.equals("jahr")) {
            return Integer.toString(new VDate(this.mForValidDate).getYear());
        }
        if (fieldName.equals("firma_bezeichnung")) {
            return this.FIELD_firma_bezeichnung;
        }
        if (fieldName.equals("firma_nr")) {
            return this.FIELD_firma_nr;
        }
        if (fieldName.equals("betriebsstaette_bezeichnung")) {
            return this.FIELD_betriebsstaette_bezeichnung;
        }
        if (fieldName.equals("betriebsstaette_nr")) {
            return this.FIELD_betriebsstaette_nr;
        }
        if (fieldName.equals("kk_bezeichnung")) {
            return this.FIELD_kk_bezeichnung;
        }
        if (fieldName.equals("kk_str_nr")) {
            return this.FIELD_kk_str_nr;
        }
        if (fieldName.equals("kk_plz_ort")) {
            return this.FIELD_kk_plz_ort;
        }
        if (fieldName.equals("kk_betriebs_nr")) {
            return this.FIELD_kk_betriebs_nr;
        }
        if (fieldName.equals("AG_str_nr")) {
            return this.FIELD_AG_str_nr;
        }
        if (fieldName.equals("AG_plz_ort")) {
            return this.FIELD_AG_plz_ort;
        }
        if (fieldName.equals("AG_bezeichnung")) {
            return this.FIELD_AG_bezeichnung;
        }
        if (fieldName.equals("AG_beitragskontonummer")) {
            return this.FIELD_AG_beitragskontonummer;
        }
        if (fieldName.equals("AG_betriebsnummer")) {
            return this.FIELD_AG_betriebsnummer;
        }
        if (fieldName.equals("AG_VWE_NR")) {
            return this.FIELD_AG_VWE_NR;
        }
        if (fieldName.equals("rk_header")) {
            return this.FIELD_rk_header;
        }
        if (fieldName.equals("AG_Nr_Bez_BetriebsNr_ZahlsStelleNr")) {
            int maxLength = 70;
            StringBuffer betriebsZahlstellenNrBuffer = new StringBuffer();
            betriebsZahlstellenNrBuffer.append(" Betriebs-Nr.: ");
            betriebsZahlstellenNrBuffer.append(this.FIELD_AG_betriebsnummer);
            betriebsZahlstellenNrBuffer.append(" Zahlstellen-Nr.: ");
            betriebsZahlstellenNrBuffer.append(this.FIELD_AG_beitragskontonummer);
            maxLength -= betriebsZahlstellenNrBuffer.length();
            StringBuffer aGKeyBezBuffer = new StringBuffer();
            aGKeyBezBuffer.append(this.FIELD_AG_VWE_NR);
            aGKeyBezBuffer.append(' ');
            aGKeyBezBuffer.append(this.FIELD_AG_bezeichnung);
            Object ag = aGKeyBezBuffer.toString();
            if (aGKeyBezBuffer.length() > maxLength) {
                ag = ((String)ag).substring(0, maxLength);
            }
            ag = (String)ag + betriebsZahlstellenNrBuffer.toString();
            return ag;
        }
        if (fieldName.equals("seitenwechsel")) {
            this.FIELD_seitenwechsel = this.FIELD_seitenwechsel.equals("Seitenwechesl_1") ? "Seitenwechesl_2" : "Seitenwechesl_1";
            return this.FIELD_seitenwechsel;
        }
        if (fieldName.equals("seitenzahl")) {
            value = this.FIELD_seitenzahl;
            this.FIELD_seitenzahl = 0;
            return value;
        }
        if (fieldName.equals("subreport_health_fund_bean")) {
            return this.mHealthFundKVDRCollection;
        }
        if (fieldName.equals("subreport_global_social_insurance_bean")) {
            return this.mGlobalSocialInsuranceKVDRCollection;
        }
        if (fieldName.equals("subreport_type_insured_bean")) {
            return this.mTypeInsuredCollection;
        }
        if (fieldName.equals("subreport_summ_bean")) {
            return this.mSummKVDRCollection;
        }
        if (fieldName.equals("summ_bean_collection")) {
            return this.mSummBeanCollection;
        }
        if (fieldName.equals("archi_string")) {
            ArchivingMetadata am = new ArchivingMetadata();
            am.setReportName(this.getReportName());
            am.setUserID(this.getUserID());
            am.setCompanyKey(this.mPCompanyKey);
            am.setValidFrom(DateHelper.getFirstDayOfMonth((Date)this.mForValidDate));
            am.setValidUntil(DateHelper.getLastDayOfMonth((Date)this.mForValidDate));
            am.setStdCompanyNr(this.mCompanyEmployerNumber);
            am.setName(this.getKkBezeichnung());
            am.setHealthFundNo(this.getKkBetriebsNr());
            return am.getArchiString();
        }
        return value;
    }

    private String getUserID() {
        return SessionContext.getInstance().getSession().getUserCode();
    }

    private String getReportName() {
        return "KVdR - Beitragslisten";
    }

    public int getCountIterations() {
        return this.mCountIterations;
    }

    private int getCountIterations(List<StatementOfContributionTypeKVDRBean> beans) {
        int count = 0;
        StatementOfContributionTypeKVDRBean bean1 = null;
        for (StatementOfContributionTypeKVDRBean bean2 : beans) {
            if (bean1 != null && !this.isChangeInTypeBeans(bean1, bean2)) continue;
            bean1 = bean2;
            ++count;
        }
        return count;
    }

    public boolean next() throws JRException {
        try {
            this.getHasNext();
            this.resetComponents();
            while (this.mHasNaxt) {
                if (!this.mFirstPurchase) {
                    this.mSOCKVDRTypeBeanForReport = this.mSOCKVDRTypeBeanForReportNext;
                    this.mSOCKVDRTypeBeanForReportNext = null;
                } else {
                    this.mSOCKVDRTypeBeanForReport = this.mEmployeeForReportIt.next();
                    this.mFirstPurchase = false;
                }
                if (this.mEmployeeForReportIt.hasNext()) {
                    this.mSOCKVDRTypeBeanForReportNext = this.mEmployeeForReportIt.next();
                }
                this.setFiledsFromBeanFields();
                this.addSummFields();
                this.leaveNext();
                if (!this.mLeaveNext) continue;
                this.buildSummCollection();
                this.fillSumBean();
                this.setHealthFundKVDRCollection();
                return true;
            }
            this.makePaymentForKVDRPaid();
            return false;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JRException((Throwable)e);
        }
    }

    protected void makePaymentForKVDRPaid() throws BusinessDomainException {
    }

    private void leaveNext() {
        this.mLeaveNext = false;
        if (this.mSOCKVDRTypeBeanForReportNext == null) {
            this.mLeaveNext = true;
        } else if (!this.mEmployeeForReportIt.hasNext() && this.isChnageInTypeBeans()) {
            this.mLeaveNext = true;
        } else if (this.mEmployeeForReportIt.hasNext() && this.isChnageInTypeBeans()) {
            this.mLeaveNext = true;
        }
    }

    private StatementOfContributionTypeKVDRBean addDataEmployeeForDetailCollections(EmployeeForSOCKVDRBean employeeForSOCBean) {
        StatementOfContributionTypeKVDRBean sOCTKVDRBean = new StatementOfContributionTypeKVDRBean(this.FIELD_firma_bezeichnung, this.FIELD_firma_nr, this.FIELD_betriebsstaette_bezeichnung, this.FIELD_betriebsstaette_beitragskonto_nr, this.FIELD_betriebsstaette_nr, this.FIELD_AG_bezeichnung, this.FIELD_AG_betriebsnummer, this.FIELD_AG_beitragskontonummer, this.FIELD_AG_VWE_NR, this.FIELD_AG_str_nr, this.FIELD_AG_plz_ort, this.FIELD_kk_bezeichnung, this.FIELD_kk_betriebs_nr, this.FIELD_kk_str_nr, this.FIELD_kk_plz_ort, this.FIELD_rk_header, "", this.FIELD_jahr, this.FIELD_header_monat_bezeichnung, this.FIELD_subreport_monat_bezeichnung, this.FIELD_Monat_int, "", 0, this.FIELD_pers_nr, this.FIELD_vorname, this.FIELD_familienname, this.FIELD_geb_datum, this.FIELD_aktenzeichen, this.FIELD_bgs_kv, this.FIELD_bgs_pv, this.FIELD_parent, this.FIELD_pgs, this.FIELD_versicherungsnummer, this.FIELD_sv_nummer, ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_129300_summierung), ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_130520_summierung), ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_129310_summierung), ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_350510_summierung), ReportHelper.toCurrencyFormatIfNullString((Object)(this.isAfter2014() ? this.FIELD_351516_summierung : BigDecimal.ZERO)), ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_354510_summierung), StringMapper.equal((String)this.FIELD_bgs_kv, (String)"1") ? ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_351510_summierung.add(this.isAfter2014() ? BigDecimal.ZERO : this.FIELD_351516_summierung)) : "", StringMapper.equal((String)this.FIELD_bgs_kv, (String)"2") ? ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_351510_summierung.add(this.isAfter2014() ? BigDecimal.ZERO : this.FIELD_351516_summierung)) : "", StringMapper.equal((String)this.FIELD_bgs_kv, (String)"3") ? ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_351510_summierung.add(this.isAfter2014() ? BigDecimal.ZERO : this.FIELD_351516_summierung)) : "", StringMapper.equal((String)this.FIELD_bgs_pv, (String)"1") ? ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_355510_summierung) : "", StringMapper.equal((String)this.FIELD_bgs_pv, (String)"2") ? ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_355510_summierung) : "", StringMapper.equal((String)this.FIELD_bgs_pv, (String)"3") ? ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_355510_summierung) : "", StringMapper.equal((String)this.FIELD_bgs_pv, (String)"4") ? ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_355510_summierung) : "", StringMapper.equal((String)this.FIELD_bgs_pv, (String)"5") ? ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_355510_summierung) : "", this.FIELD_351510_summierung.add(this.isAfter2014() ? BigDecimal.ZERO : this.FIELD_351516_summierung), this.isAfter2014() ? this.FIELD_351516_summierung : BigDecimal.ZERO, this.FIELD_355510_summierung, this.FIELD_350510_summierung, this.FIELD_354510_summierung, this.mPaymentCompHealthFundBean, this.FIELD_taxCode, this.FIELD_personalAccount);
        sOCTKVDRBean.setOidPCompany(employeeForSOCBean.getOidPCompany());
        sOCTKVDRBean.setOidPlant(!this.mStatementOfContributionProCompany ? employeeForSOCBean.getOidPlant() : "");
        sOCTKVDRBean.setOidHealthFund(employeeForSOCBean.getReferToOidHealthFund());
        sOCTKVDRBean.setOidEmployee(employeeForSOCBean.getOidEmployee());
        return sOCTKVDRBean;
    }

    private String changeHFDescriptionForKrKBundesknappschaft(String currentOidHealthFund, String healthFundDesciption, boolean addBundknappEFRContainer, Date forEffectiveDate, Date forValidDate) throws BusinessDomainException {
        HealthFundTP hFTP = this.getHealthFundTP(currentOidHealthFund, forEffectiveDate, forValidDate);
        Object changedBundesKnappschaftDescription = healthFundDesciption;
        if (StringMapper.equal((String)hFTP.getStandardCompanyNumber(), (String)mMinijobZentraleNumber) && !addBundknappEFRContainer) {
            changedBundesKnappschaftDescription = (String)changedBundesKnappschaftDescription + " ";
            if (StringMapper.equal((String)currentOidHealthFund, (String)this.mFFSOidHealthFund)) {
                this.mSelHFDesBuKnSpace = changedBundesKnappschaftDescription;
            }
        }
        return changedBundesKnappschaftDescription;
    }

    private void getHasNext() {
        this.mHasNaxt = false;
        if (this.mEmployeeForReportIt.hasNext() || this.mSOCKVDRTypeBeanForReportNext != null) {
            this.mHasNaxt = true;
        }
    }

    protected void resetComponents() {
        this.mTypeInsuredCollection.clear();
        this.mSummKVDRCollection.clear();
        this.resetSummFields();
        this.resetBeanFileds();
    }

    private boolean isChnageInTypeBeans() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("mSOCKVDRTypeBeanForReport.getFirma_bezeichnung(){}mSOCKVDRTypeBeanForReportNext.getFirma_bezeichnung() {}mSOCKVDRTypeBeanForReport.getBetriebsstaette_bezeichnung(){}mSOCKVDRTypeBeanForReportNext.getBetriebsstaette_bezeichnung(){}getArbeitgeber_bezeichnung={}getArbeitgeber_bezeichnung= {}getKk_bezeichnung={}getKk_bezeichnung={}getRechtskreis={}getRechtskreis={}", new Object[]{this.mSOCKVDRTypeBeanForReport.getFirma_bezeichnung(), this.mSOCKVDRTypeBeanForReportNext.getFirma_bezeichnung(), this.mSOCKVDRTypeBeanForReport.getBetriebsstaette_bezeichnung(), this.mSOCKVDRTypeBeanForReportNext.getBetriebsstaette_bezeichnung(), this.mSOCKVDRTypeBeanForReport.getArbeitgeber_bezeichnung(), this.mSOCKVDRTypeBeanForReportNext.getArbeitgeber_bezeichnung(), this.mSOCKVDRTypeBeanForReport.getKk_bezeichnung(), this.mSOCKVDRTypeBeanForReportNext.getKk_bezeichnung(), this.mSOCKVDRTypeBeanForReport.getRechtskreis(), this.mSOCKVDRTypeBeanForReportNext.getRechtskreis()});
        }
        return this.isChangeInTypeBeans(this.mSOCKVDRTypeBeanForReport, this.mSOCKVDRTypeBeanForReportNext);
    }

    private boolean isChangeInTypeBeans(StatementOfContributionTypeKVDRBean bean1, StatementOfContributionTypeKVDRBean bean2) {
        return !StringMapper.equal((String)bean1.getArbeitgeber_bezeichnung(), (String)bean2.getArbeitgeber_bezeichnung()) || !StringMapper.equal((String)bean1.getKk_betriebsnr(), (String)bean2.getKk_betriebsnr()) || !StringMapper.equal((String)bean1.getKk_bezeichnung(), (String)bean2.getKk_bezeichnung()) || !StringMapper.equal((String)bean1.getRechtskreis(), (String)bean2.getRechtskreis());
    }

    private List<ComphealthfunallContainer> getListCompHealthFundAll(String[] resultOidPCompany, Date forEffectiveDate, Date listFirstDate, Date listEndDate) {
        PersistencyDataSet compHealthFundallDatas = daoComphealthfunall.getDataSet(new Order[]{Order.asc((String)"oidplant"), Order.asc((String)"oidhealthfundroot"), Order.asc((String)"validfrom")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.in((String)"oidpcompany", (String[])resultOidPCompany), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)forEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)forEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)listEndDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)listFirstDate))}));
        ComphealthfunallContainer comphealthfunallContainer = new ComphealthfunallContainer();
        LinkedList<ComphealthfunallContainer> liste = null;
        if (compHealthFundallDatas != null) {
            liste = new LinkedList<ComphealthfunallContainer>();
            while (compHealthFundallDatas.hasNext()) {
                comphealthfunallContainer = (ComphealthfunallContainer)compHealthFundallDatas.getNext();
                liste.add(comphealthfunallContainer);
            }
        }
        return liste;
    }

    private GeneralEmploymentOffice getGeneralCompanyEmploymentOfficeTP() throws BusinessDomainException {
        if (this.mPCompanyGeneralEmploymentOffice == null) {
            CompanyEmploymentOffice compEmplOffice = null;
            try {
                compEmplOffice = this.getPCompany().getCompanyEmploymentOffice(this.mForEffectiveDate, this.mForValidDate);
            }
            catch (BusinessDomainException e) {
                throw ReportExceptionMapper.makeCompanyEmployeeOfficeMissingDomainException();
            }
            this.mPCompanyGeneralEmploymentOffice = compEmplOffice.getGeneralEmploymentOffice();
            if (this.mPCompanyGeneralEmploymentOffice == null) {
                throw ReportExceptionMapper.makeCompanyEmployeeOfficeMissingDomainException();
            }
        }
        return this.mPCompanyGeneralEmploymentOffice;
    }

    private String getCompanyEmployerNumber() throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.mCompanyEmployerNumber)) {
            GeneralEmploymentOffice genCompEmplOf = null;
            genCompEmplOf = this.getGeneralCompanyEmploymentOfficeTP();
            if (genCompEmplOf != null) {
                this.mCompanyEmployerNumber = genCompEmplOf.getEmployerNumber();
                if (StringMapper.isNullString((String)this.mCompanyEmployerNumber)) {
                    throw ReportExceptionMapper.makeCompanyEmployeeOfficeMissingDomainException();
                }
            }
        }
        return this.mCompanyEmployerNumber;
    }

    private String getCompanyKVDRZahlstellenNumber() throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.mCompanyKVDRZahlstellenNumber)) {
            GeneralEmploymentOffice genCompEmplOf = null;
            genCompEmplOf = this.getGeneralCompanyEmploymentOfficeTP();
            if (genCompEmplOf != null) {
                this.mCompanyKVDRZahlstellenNumber = genCompEmplOf.getStandardPaymentPointNumberPensionersHealthInsurance();
            }
        }
        return this.mCompanyKVDRZahlstellenNumber;
    }

    private String getPlantEmployerNumber(String oidPlant, Date effectiveDate, Date validDate) throws BusinessDomainException {
        String employerNumber = null;
        GeneralEmploymentOffice genPlantEmplOf = this.getGeneralPlantEmploymentOfficeTP(oidPlant, effectiveDate, validDate);
        if (genPlantEmplOf != null) {
            employerNumber = genPlantEmplOf.getEmployerNumber();
        }
        if (StringMapper.isNullString(employerNumber)) {
            throw ReportExceptionMapper.makePlantEmployeeOfficeMissingDomainException();
        }
        return employerNumber;
    }

    private String getPlantKVDRZahlstellenrNumber(String oidPlant, Date effectiveDate, Date validDate) throws BusinessDomainException {
        GeneralEmploymentOffice genPlantEmplOf = this.getGeneralPlantEmploymentOfficeTP(oidPlant, effectiveDate, validDate);
        if (genPlantEmplOf != null) {
            return genPlantEmplOf.getStandardPaymentPointNumberPensionersHealthInsurance();
        }
        return null;
    }

    private GeneralEmploymentOffice getGeneralPlantEmploymentOfficeTP(String oidPlant, Date effectiveDate, Date validDate) throws BusinessDomainException {
        GeneralEmploymentOffice genEmplOffice = null;
        Plant ePlant = this.getPlant(oidPlant);
        if (ePlant != null) {
            PlantEmploymentOffice plantEmplOffice = null;
            try {
                plantEmplOffice = ePlant.getPlantEmploymentOffice(effectiveDate, validDate);
            }
            catch (BusinessDomainException e) {
                throw ReportExceptionMapper.makePlantEmployeeOfficeMissingDomainException();
            }
            genEmplOffice = plantEmplOffice.getGeneralEmploymentOffice();
            if (genEmplOffice == null) {
                throw ReportExceptionMapper.makePlantEmployeeOfficeMissingDomainException();
            }
        }
        return genEmplOffice;
    }

    private String getPCompanyKey() {
        if (StringMapper.isNullString((String)this.mPCompanyKey)) {
            this.mPCompanyKey = this.getPCompany().getPCompanyKey();
        }
        return this.mPCompanyKey;
    }

    protected HealthFundTP getHealthFundTP(String healthFundOid, Date effectiveDate, Date validDate) throws BusinessDomainException {
        String healthfundEffectiveValid = healthFundOid + DateMapper.toDDMMYYYYPointSeparationString((Date)effectiveDate) + DateMapper.toDDMMYYYYPointSeparationString((Date)validDate);
        HealthFundTP hFTP = this.mHealthFundTPMap.get(healthfundEffectiveValid);
        if (hFTP == null) {
            HealthFund hF = this.getHealthFund(healthFundOid);
            try {
                hFTP = hF.getHealthFundTP(effectiveDate, validDate);
            }
            catch (BusinessDomainException e) {
                throw SOCRExceptionMapper.makeNoHealthfundExistent();
            }
            this.mHealthFundTPMap.put(healthfundEffectiveValid, hFTP);
        }
        return hFTP;
    }

    private HealthFund getHealthFund(String healthFundOid) {
        HealthFund hF = this.mHealthFundMap.get(healthFundOid);
        if (hF == null) {
            hF = this.mReportValues.getHealthFund(healthFundOid);
            this.mHealthFundMap.put(healthFundOid, hF);
        }
        return hF;
    }

    private String getLawArea(String oidPlant, Date forEffectiveDate, Date forValidDate) throws BusinessDomainException {
        if (DateHelper.before((Date)forValidDate, (Date)new VDate(2026, 0, 1).getDate())) {
            String key = oidPlant + DateMapper.toDDMMYYYYString((Date)forEffectiveDate) + DateMapper.toDDMMYYYYString((Date)forValidDate);
            String lawArea = this.mLawAreaMap.get(key);
            if (lawArea == null) {
                Foundations plantFoundation = this.getPlantFoundations(oidPlant, forEffectiveDate, forValidDate);
                FederalStateTP federalStateTP = null;
                try {
                    federalStateTP = plantFoundation.getFederalState().getFederalStateTP(forEffectiveDate, forValidDate);
                }
                catch (BusinessDomainException e) {
                    ExceptionMapper.printException((Throwable)e);
                    throw ReportExceptionMapper.makeNoPlantLawAreaDomainException((String)plantFoundation.getLongDescription());
                }
                lawArea = federalStateTP.getLawArea();
                lawArea = StringMapper.isNullString((String)lawArea) ? "" : (StringMapper.equal((String)lawArea, (String)"W") ? "West" : "Ost");
                this.mLawAreaMap.put(key, lawArea);
            }
            return lawArea;
        }
        return "";
    }

    private CompanyPlantPostalAddress getCompanyPostalAdress() throws BusinessDomainException {
        if (this.mPCompanyPlantPostalAddress == null) {
            this.mPCompanyPlantPostalAddress = this.getCompanyFoundations().getPostalAddress();
            if (this.mPCompanyPlantPostalAddress == null) {
                throw ReportExceptionMapper.makeNoCompanyAdressDomainException((String)this.getCompanyLongDescription());
            }
        }
        return this.mPCompanyPlantPostalAddress;
    }

    private String getCompanyLongDescription() throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.mPCompanyLongDescription)) {
            this.mPCompanyLongDescription = this.getCompanyFoundations().getLongDescription();
        }
        return this.mPCompanyLongDescription;
    }

    private String getPlantLongDescription(String oidPlant, Date forEffectiveDate, Date forValidDate) throws BusinessDomainException {
        String key = oidPlant + DateMapper.toDDMMYYYYString((Date)forEffectiveDate) + DateMapper.toDDMMYYYYString((Date)forValidDate);
        String plantLongDescription = this.mPlantLongDescriptionMap.get(key);
        if (plantLongDescription == null) {
            try {
                plantLongDescription = this.getPlantFoundations(oidPlant, forEffectiveDate, forValidDate).getLongDescription();
            }
            catch (BusinessDomainException e) {
                ExceptionMapper.printException((Throwable)e);
                throw ReportExceptionMapper.makeNoPlantLongDescriptionDomainException();
            }
            this.mPlantLongDescriptionMap.put(key, plantLongDescription);
        }
        return plantLongDescription;
    }

    private Foundations getCompanyFoundations() throws BusinessDomainException {
        if (this.mPCompanyFoundations == null) {
            CompanyFoundations companyFoundations = null;
            try {
                companyFoundations = this.getPCompany().getCompanyFoundations(this.mForEffectiveDate, this.mForValidDate);
            }
            catch (BusinessDomainException e) {
                ExceptionMapper.printException((Throwable)e);
                throw ReportExceptionMapper.makeCompanyFoundationsMissingDomainException((String)this.getCompanyLongDescription());
            }
            this.mPCompanyFoundations = companyFoundations.getFoundations();
            if (this.mPCompanyFoundations == null) {
                throw ReportExceptionMapper.makeCompanyFoundationsMissingDomainException((String)this.getCompanyLongDescription());
            }
        }
        return this.mPCompanyFoundations;
    }

    private void setEmployeePlantIsEast(String oidPlant) throws BusinessDomainException {
        if (DateHelper.before((Date)this.mForValidDate, (Date)new VDate(2026, 0, 1).getDate())) {
            Foundations plantFoundation = this.getPlantFoundations(oidPlant, this.mForEffectiveDate, this.mForValidDate);
            String lawArea = plantFoundation.getFederalState().getFederalStateTP(this.mForEffectiveDate, this.mForValidDate).getLawArea();
            if (StringMapper.equal((String)"O", (String)lawArea)) {
                this.mEmployeePlantIsEast = true;
            }
        } else {
            this.mEmployeePlantIsEast = false;
        }
    }

    private Foundations getPlantFoundations(String oidPlant, Date forEffectiveDate, Date forValidDate) throws BusinessDomainException {
        String key = oidPlant + DateMapper.toDDMMYYYYString((Date)forEffectiveDate) + DateMapper.toDDMMYYYYString((Date)forValidDate);
        Foundations plantFoundation = this.mPlantFoundationsMap.get(key);
        if (plantFoundation == null) {
            PlantFoundations plantFoundations = null;
            try {
                plantFoundations = this.getPlant(oidPlant).getPlantFoundations(forEffectiveDate, forValidDate);
            }
            catch (BusinessDomainException e) {
                ExceptionMapper.printException((Throwable)e);
                throw ReportExceptionMapper.makePlantFoundationsMissingDomainException((String)"");
            }
            plantFoundation = plantFoundations.getFoundations();
            if (plantFoundation == null) {
                throw ReportExceptionMapper.makePlantFoundationsMissingDomainException((String)"");
            }
            this.mPlantFoundationsMap.put(key, plantFoundation);
        }
        return plantFoundation;
    }

    private Plant getPlant(String oidPlant) throws BusinessDomainException {
        Plant plant = this.mPlantMap.get(oidPlant);
        if (plant == null) {
            plant = (Plant)this.generator.used((IPersistentObject)pm.getPlant(oidPlant));
            if (plant.isNew()) {
                throw ReportExceptionMapper.makeNoPlantDomainException();
            }
            this.mPlantMap.put(oidPlant, plant);
        }
        return plant;
    }

    private String getPlantKey(String oidPlant) throws BusinessDomainException {
        String plantKey = this.mPlantKeyMap.get(oidPlant);
        if (plantKey == null && StringMapper.isNullString((String)(plantKey = this.getPlant(oidPlant).getPlantKey()))) {
            throw ReportExceptionMapper.makeNoPlantKeyDomainException((String)"");
        }
        this.mPlantKeyMap.put(oidPlant, plantKey);
        return plantKey;
    }

    private PCompany getPCompany() {
        if (this.mPCompany == null) {
            this.mPCompany = (PCompany)this.generator.used((IPersistentObject)PCompanyPersistencyManager.getPCompany((String)this.mOidPCompany));
        }
        return this.mPCompany;
    }

    private Insurance getInsurance(String oidEmployee, Date forEffectiveDate, Date forValidDate) {
        Employee eE;
        String key = oidEmployee + DateMapper.toDDMMYYYYString((Date)forEffectiveDate) + DateMapper.toDDMMYYYYString((Date)forValidDate);
        Insurance insurance = this.mInsuranceMap.get(key);
        if (insurance == null && (eE = this.getEmployee(oidEmployee)) != null) {
            try {
                insurance = eE.getInsurance(forEffectiveDate, forValidDate);
                this.mInsuranceMap.put(key, insurance);
            }
            catch (BusinessDomainException businessDomainException) {
                // empty catch block
            }
        }
        return insurance;
    }

    private Employee getEmployee(String oidEmployee) {
        String key = oidEmployee;
        Employee eE = this.mEmployeeMap.get(key);
        if (eE == null) {
            eE = (Employee)this.generator.used((IPersistentObject)this.getIEmployeePM().getEmployee(oidEmployee));
            this.mEmployeeMap.put(key, eE);
        }
        return eE;
    }

    private String getHFShortDescription(String hfObjectId, Date forEffectiveDate, Date forValidDate) throws BusinessDomainException {
        String key = hfObjectId;
        String shortDescription = this.mHealthFundShortDescriptionMap.get(key);
        if (shortDescription == null) {
            HealthFundTP healthFundTP = null;
            try {
                healthFundTP = this.getHealthFundTP(hfObjectId, this.mForEffectiveDate, this.mForValidDate);
            }
            catch (BusinessDomainException e) {
                ReportExceptionMapper.ignoredException((Throwable)e);
            }
            if (healthFundTP == null) {
                healthFundTP = this.getHealthFundTP(hfObjectId, forEffectiveDate, forValidDate);
            }
            if (StringMapper.isNullString((String)(shortDescription = healthFundTP.getShortDescription()))) {
                throw SOCRExceptionMapper.makeNoHealthfundShortDescriptionExistent();
            }
            this.mHealthFundShortDescriptionMap.put(key, shortDescription);
        }
        return shortDescription;
    }

    private String getStandardCompanyNumber(String hfObjectId, Date forEffectiveDate, Date forValidDate) throws BusinessDomainException {
        String key = hfObjectId;
        String standardCompanyNumber = this.mStandardCompanyNumberMap.get(key);
        if (standardCompanyNumber == null) {
            HealthFundTP healthFundTP = null;
            try {
                healthFundTP = this.getHealthFundTP(hfObjectId, this.mForEffectiveDate, this.mForValidDate);
            }
            catch (BusinessDomainException e) {
                ReportExceptionMapper.ignoredException((Throwable)e);
            }
            if (healthFundTP == null) {
                healthFundTP = this.getHealthFundTP(hfObjectId, forEffectiveDate, forValidDate);
            }
            if (StringMapper.isNullString((String)(standardCompanyNumber = healthFundTP.getStandardCompanyNumber()))) {
                throw SOCRExceptionMapper.makeNoHealthfundStandardCompanyNumberExistent();
            }
            this.mStandardCompanyNumberMap.put(key, standardCompanyNumber);
        }
        return standardCompanyNumber;
    }

    private String gethFDescriptionStandardCompNumber(String hfObjectId, Date forEffectiveDate, Date forValidDate) throws BusinessDomainException {
        String shortDescription = this.getHFShortDescription(hfObjectId, forEffectiveDate, forValidDate);
        String standardCompanyNumber = this.getStandardCompanyNumber(hfObjectId, forEffectiveDate, forValidDate);
        return shortDescription + standardCompanyNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getEmployeeProperties(EmployeeForSOCKVDRBean employeeForSOCBean, HealthFund hfKVdR) throws BusinessDomainException {
        Date forEffectiveDate = employeeForSOCBean.getForEffectiveDate();
        Date forValidDate = employeeForSOCBean.getForValidFromDate();
        String hFDescriptionStandardCompNumber = this.gethFDescriptionStandardCompNumber(hfKVdR.getObjectid(), forEffectiveDate, forValidDate);
        employeeForSOCBean.setInsuranceHealthFundDesciption(hFDescriptionStandardCompNumber);
        employeeForSOCBean.setOidInsuranceHealthFund(hfKVdR.getObjectid());
        String companyKVDRZahlstellenNummer = "";
        String plantKVDRZahlstellenNummer = "";
        Plant plant = null;
        if (!StringMapper.isNullString((String)employeeForSOCBean.getOidPlant())) {
            employeeForSOCBean.setPlantLawArea(this.getLawArea(employeeForSOCBean.getOidPlant(), forEffectiveDate, forValidDate));
            if (!this.mStatementOfContributionProCompany) {
                plant = pm.getPlant(employeeForSOCBean.getOidPlant());
            }
        }
        if (plant != null) {
            PlantEmploymentOffice plantEmploymentOffice = null;
            try {
                plantEmploymentOffice = plant.getPlantEmploymentOffice(forEffectiveDate, forValidDate);
            }
            catch (BusinessDomainException e) {
                ExceptionMapper.printException((Throwable)e);
            }
            if (plantEmploymentOffice != null) {
                plantKVDRZahlstellenNummer = plantEmploymentOffice.getGeneralEmploymentOffice().getStandardPaymentPointNumberPensionersHealthInsurance();
            }
        }
        if (StringMapper.isNullString((String)plantKVDRZahlstellenNummer)) {
            CompanyEmploymentOffice companyEmploymentOffice = this.mPCompany.getCompanyEmploymentOffice(forEffectiveDate, forValidDate);
            if (companyEmploymentOffice != null) {
                companyKVDRZahlstellenNummer = companyEmploymentOffice.getGeneralEmploymentOffice().getStandardPaymentPointNumberPensionersHealthInsurance();
            }
            employeeForSOCBean.setKVDRZahlstellenNummer(companyKVDRZahlstellenNummer);
            ComphealthfunallContainer comphealthfunallData = null;
            comphealthfunallData = SOCDataSourceHelper.getComphealthfundContainer(this.mCompHealthFundAllList, (String)"", (String)hfKVdR.getObjectid(), (Date)forValidDate);
            if (comphealthfunallData == null) throw ReportExceptionMapper.makeNoComphealthdundForHealthfundDomainException((String)("Pers.-Nr.: " + employeeForSOCBean.getPersonnelNumber() + ";   " + employeeForSOCBean.getSurname() + ", " + employeeForSOCBean.getFirstName()));
            if (StringMapper.isNullString((String)comphealthfunallData.duesaccountnumber)) {
                throw ReportExceptionMapper.makeComphealthdundAccountNumberMissingDomainException();
            }
            employeeForSOCBean.setInsuranceComphealthfunallData(comphealthfunallData);
            employeeForSOCBean.setPCompanyDuesAccountnumber(comphealthfunallData.duesaccountnumber);
            employeeForSOCBean.setPlantDuesAccountnumber("");
            employeeForSOCBean.setPlantOidWhenPlantAccountnumber("");
            employeeForSOCBean.setEmployeeInsuranceToPlant(false);
            return;
        } else {
            employeeForSOCBean.setKVDRZahlstellenNummer(plantKVDRZahlstellenNummer);
            ComphealthfunallContainer comphealthfunallData = null;
            comphealthfunallData = SOCDataSourceHelper.getComphealthfundContainer(this.mCompHealthFundAllList, (String)employeeForSOCBean.getOidPlant(), (String)hfKVdR.getObjectid(), (Date)forValidDate);
            if (comphealthfunallData == null) {
                comphealthfunallData = SOCDataSourceHelper.getComphealthfundContainer(this.mCompHealthFundAllList, (String)"", (String)hfKVdR.getObjectid(), (Date)forValidDate);
            }
            if (comphealthfunallData == null) throw ReportExceptionMapper.makeNoComphealthdundForHealthfundDomainException((String)("Pers.-Nr.: " + employeeForSOCBean.getPersonnelNumber() + ";   " + employeeForSOCBean.getSurname() + ", " + employeeForSOCBean.getFirstName()));
            if (StringMapper.isNullString((String)comphealthfunallData.duesaccountnumber)) {
                throw ReportExceptionMapper.makeComphealthdundAccountNumberMissingDomainException();
            }
            employeeForSOCBean.setInsuranceComphealthfunallData(comphealthfunallData);
            employeeForSOCBean.setPlantDuesAccountnumber(comphealthfunallData.duesaccountnumber);
            employeeForSOCBean.setPCompanyDuesAccountnumber("");
            employeeForSOCBean.setPlantOidWhenPlantAccountnumber(employeeForSOCBean.getOidPlant());
            employeeForSOCBean.setEmployeeInsuranceToPlant(true);
        }
    }

    private void setEmployeeForSOCKVDRBean(EmployeeForSOCKVDRBean employeeForSOCKVDRBean, Map<String, Map<String, List<EmployeeForSOCKVDRBean>>> pcompanyPlantMap) throws BusinessDomainException {
        Map<String, List<EmployeeForSOCKVDRBean>> healthFundMap;
        String lawArea;
        String plantOidWhenPlantAccountnumber = employeeForSOCKVDRBean.getPlantOidWhenPlantAccountnumber();
        String healthFundDesciption = employeeForSOCKVDRBean.getInsuranceHealthFundDesciption();
        String string = lawArea = this.mEmployeePlantIsEast ? employeeForSOCKVDRBean.getPlantLawArea() : "";
        if (StringMapper.isNullString((String)plantOidWhenPlantAccountnumber) && this.mEmployeePlantIsEast) {
            plantOidWhenPlantAccountnumber = lawArea;
        }
        if ((healthFundMap = pcompanyPlantMap.get(plantOidWhenPlantAccountnumber)) == null) {
            healthFundMap = new HashMap<String, List<EmployeeForSOCKVDRBean>>();
            pcompanyPlantMap.put(plantOidWhenPlantAccountnumber, healthFundMap);
        }
        EmployeeForSOCKVDRBean employeeForSOCBeanCopy = employeeForSOCKVDRBean.createNew();
        healthFundDesciption = this.changeHFDescriptionForKrKBundesknappschaft(employeeForSOCBeanCopy.getOidInsuranceHealthFund(), healthFundDesciption, false, employeeForSOCBeanCopy.getForEffectiveDate(), employeeForSOCBeanCopy.getForValidFromDate());
        List<EmployeeForSOCKVDRBean> liste = healthFundMap.get(healthFundDesciption);
        employeeForSOCBeanCopy.setRefereToHealthFundDescription(healthFundDesciption);
        employeeForSOCBeanCopy.setReferToOidHealthFund(employeeForSOCBeanCopy.getOidInsuranceHealthFund());
        employeeForSOCBeanCopy.setRefeToComphealthfunallContainer(employeeForSOCBeanCopy.getInsuranceComphealthfunallContainer());
        if (liste == null) {
            liste = new LinkedList<EmployeeForSOCKVDRBean>();
            healthFundMap.put(healthFundDesciption, liste);
        }
        liste.add(employeeForSOCBeanCopy);
    }

    private List<StatementOfContributionTypeKVDRBean> setStatementOfContributionTypeKVDRBean(List<StatementOfContributionTypeKVDRBean> sOCTypeKVDRBeansLi) {
        Map<String, Map<String, Map<String, Map<String, List<StatementOfContributionTypeKVDRBean>>>>> pcompanyPlantMap = this.getStatementOfContributionTypeKVDRBeanMap(sOCTypeKVDRBeansLi);
        List<StatementOfContributionTypeKVDRBean> orderdSOCTypeKVDRBeansLi = this.setStatementOfContributionTypeKVDRBeanLi(pcompanyPlantMap);
        return orderdSOCTypeKVDRBeansLi;
    }

    private Map<String, Map<String, Map<String, Map<String, List<StatementOfContributionTypeKVDRBean>>>>> getStatementOfContributionTypeKVDRBeanMap(List<StatementOfContributionTypeKVDRBean> sOCTypeKVDRBeansLi) {
        HashMap<String, Map<String, Map<String, Map<String, List<StatementOfContributionTypeKVDRBean>>>>> pcompanyPlantMap = new HashMap<String, Map<String, Map<String, Map<String, List<StatementOfContributionTypeKVDRBean>>>>>();
        for (StatementOfContributionTypeKVDRBean sOCTypeKVDRBean : sOCTypeKVDRBeansLi) {
            Object monthValue;
            LinkedList<StatementOfContributionTypeKVDRBean> monthLi;
            HashMap<Object, LinkedList<StatementOfContributionTypeKVDRBean>> personnelNumberMap;
            HashMap healthFundMap;
            HashMap plantMap;
            String lawArea;
            String plantOidWhenPlantAccountnumber = sOCTypeKVDRBean.getBetriebsstaette_beitragskonto_nr();
            String healthFundDesciption = sOCTypeKVDRBean.getKk_bezeichnung();
            String string = lawArea = this.mEmployeePlantIsEast ? sOCTypeKVDRBean.getRechtskreis() : "";
            if (StringMapper.isNullString((String)plantOidWhenPlantAccountnumber) && this.mEmployeePlantIsEast) {
                plantOidWhenPlantAccountnumber = lawArea;
            }
            if ((plantMap = (HashMap)pcompanyPlantMap.get(plantOidWhenPlantAccountnumber)) == null) {
                plantMap = new HashMap();
                pcompanyPlantMap.put(plantOidWhenPlantAccountnumber, plantMap);
            }
            if ((healthFundMap = (HashMap)plantMap.get(healthFundDesciption)) == null) {
                healthFundMap = new HashMap();
                plantMap.put(healthFundDesciption, healthFundMap);
            }
            if ((personnelNumberMap = (HashMap<Object, LinkedList<StatementOfContributionTypeKVDRBean>>)healthFundMap.get(sOCTypeKVDRBean.getF_pers_nr())) == null) {
                personnelNumberMap = new HashMap<Object, LinkedList<StatementOfContributionTypeKVDRBean>>();
                healthFundMap.put(sOCTypeKVDRBean.getF_pers_nr(), personnelNumberMap);
            }
            if ((monthLi = (LinkedList<StatementOfContributionTypeKVDRBean>)personnelNumberMap.get(monthValue = sOCTypeKVDRBean.getMonat_int() < 10 ? "0" + Integer.toString(sOCTypeKVDRBean.getMonat_int()) : Integer.toString(sOCTypeKVDRBean.getMonat_int()))) == null) {
                monthLi = new LinkedList<StatementOfContributionTypeKVDRBean>();
                personnelNumberMap.put(monthValue, monthLi);
            }
            monthLi.add(sOCTypeKVDRBean);
        }
        return pcompanyPlantMap;
    }

    private List<StatementOfContributionTypeKVDRBean> setStatementOfContributionTypeKVDRBeanLi(Map<String, Map<String, Map<String, Map<String, List<StatementOfContributionTypeKVDRBean>>>>> pcompanyPlantMap) {
        LinkedList<StatementOfContributionTypeKVDRBean> orderdSOCTypeKVDRBeansLi = new LinkedList<StatementOfContributionTypeKVDRBean>();
        Iterator<String> plantMapIt = this.getIteratorNotSortedFromHashMap(pcompanyPlantMap.keySet());
        while (plantMapIt.hasNext()) {
            Map<String, Map<String, Map<String, List<StatementOfContributionTypeKVDRBean>>>> plantMap = pcompanyPlantMap.get(plantMapIt.next().toString());
            Iterator<String> healthFundIt = this.getIteratorNotSortedFromHashMap(plantMap.keySet());
            while (healthFundIt.hasNext()) {
                Map<String, Map<String, List<StatementOfContributionTypeKVDRBean>>> healthFundMap = plantMap.get(healthFundIt.next().toString());
                Iterator<String> personnelNumberIt = this.getIteratorNotSortedFromHashMap(healthFundMap.keySet());
                while (personnelNumberIt.hasNext()) {
                    Map<String, List<StatementOfContributionTypeKVDRBean>> personnelNumberMap = healthFundMap.get(personnelNumberIt.next().toString());
                    Iterator<String> montIt = this.getIteratorFromHashMap(personnelNumberMap.keySet());
                    while (montIt.hasNext()) {
                        List<StatementOfContributionTypeKVDRBean> monthLi = personnelNumberMap.get(montIt.next().toString());
                        if (monthLi == null || monthLi.isEmpty()) continue;
                        if (monthLi.size() > 1) {
                            int[] intArray = new int[]{3};
                            Collections.sort(monthLi, new SOCKVDRReportSortComparator(intArray));
                            orderdSOCTypeKVDRBeansLi.addAll(monthLi);
                            continue;
                        }
                        orderdSOCTypeKVDRBeansLi.addAll(monthLi);
                    }
                }
            }
        }
        return orderdSOCTypeKVDRBeansLi;
    }

    private List<EmployeeForSOCKVDRBean> sortEmployeeForReport(Map<String, Map<String, List<EmployeeForSOCKVDRBean>>> plantMap) {
        LinkedList<EmployeeForSOCKVDRBean> employeeForReportListAll = new LinkedList<EmployeeForSOCKVDRBean>();
        Iterator<String> plantMapIterator = this.getIteratorFromHashMap(plantMap.keySet());
        while (plantMapIterator.hasNext()) {
            Map<String, List<EmployeeForSOCKVDRBean>> healthFundMap = plantMap.get(plantMapIterator.next().toString());
            Iterator<String> healthFundMapIt = this.getIteratorFromHashMap(healthFundMap.keySet());
            while (healthFundMapIt.hasNext()) {
                List<EmployeeForSOCKVDRBean> employeeForReportTempList;
                String key = healthFundMapIt.next().toString();
                LOGGER.debug("key= {}", (Object)key);
                if (StringMapper.isNullString((String)this.mSelHFDes)) {
                    List<EmployeeForSOCKVDRBean> employeeForSOCKVDRBeanLi = healthFundMap.get(key);
                    for (EmployeeForSOCKVDRBean eSOCBean : employeeForSOCKVDRBeanLi) {
                        employeeForReportListAll.add(eSOCBean);
                    }
                    continue;
                }
                if (StringMapper.isNullString((String)this.mSelHFDesBuKnSpace)) {
                    if (!StringMapper.equal((String)this.mSelHFDes, (String)key)) continue;
                    employeeForReportTempList = healthFundMap.get(key);
                    for (EmployeeForSOCKVDRBean eSOCBean : employeeForReportTempList) {
                        employeeForReportListAll.add(eSOCBean);
                    }
                    continue;
                }
                if (!StringMapper.equal((String)this.mSelHFDes, (String)key) && !StringMapper.equal((String)this.mSelHFDesBuKnSpace, (String)key)) continue;
                employeeForReportTempList = healthFundMap.get(key);
                for (EmployeeForSOCKVDRBean eSOCBean : employeeForReportTempList) {
                    employeeForReportListAll.add(eSOCBean);
                }
            }
        }
        return employeeForReportListAll;
    }

    private List<StatementOfContributionTypeKVDRBean> comperatorOldNew(List<EmployeeForSOCKVDRBean> newEmployeeForSOCKVDRBeanLi, List<EmployeeForSOCKVDRBean> oldEmployeeForSOCKVDRBeanLi) throws BusinessDomainException {
        if (oldEmployeeForSOCKVDRBeanLi.isEmpty() && newEmployeeForSOCKVDRBeanLi.isEmpty()) {
            return new LinkedList<StatementOfContributionTypeKVDRBean>();
        }
        List<Object> newStatementOfContributionTypeKVDRBeanLi = new LinkedList();
        List<Object> oldStatementOfContributionTypeKVDRBeanLi = new LinkedList();
        if (!newEmployeeForSOCKVDRBeanLi.isEmpty()) {
            newStatementOfContributionTypeKVDRBeanLi = this.getStatementOfContributionTypeKVDRBeanLi(newEmployeeForSOCKVDRBeanLi);
            this.setNewTypeBean(newStatementOfContributionTypeKVDRBeanLi);
        }
        if (!oldEmployeeForSOCKVDRBeanLi.isEmpty()) {
            oldStatementOfContributionTypeKVDRBeanLi = this.getStatementOfContributionTypeKVDRBeanLi(oldEmployeeForSOCKVDRBeanLi);
            this.setNewTypeBean(oldStatementOfContributionTypeKVDRBeanLi);
        }
        if (newStatementOfContributionTypeKVDRBeanLi.isEmpty() && oldStatementOfContributionTypeKVDRBeanLi.isEmpty()) {
            return new LinkedList<StatementOfContributionTypeKVDRBean>();
        }
        if (newStatementOfContributionTypeKVDRBeanLi.size() != oldStatementOfContributionTypeKVDRBeanLi.size()) {
            if (!newStatementOfContributionTypeKVDRBeanLi.isEmpty()) {
                this.setNewTypeBean(newStatementOfContributionTypeKVDRBeanLi);
            }
            if (!oldStatementOfContributionTypeKVDRBeanLi.isEmpty()) {
                this.setOldTypeBean(oldStatementOfContributionTypeKVDRBeanLi);
            }
            newStatementOfContributionTypeKVDRBeanLi.addAll(oldStatementOfContributionTypeKVDRBeanLi);
            return newStatementOfContributionTypeKVDRBeanLi;
        }
        if (newStatementOfContributionTypeKVDRBeanLi.size() == oldStatementOfContributionTypeKVDRBeanLi.size()) {
            if (this.areEqualLists(newStatementOfContributionTypeKVDRBeanLi, oldStatementOfContributionTypeKVDRBeanLi)) {
                return new LinkedList<StatementOfContributionTypeKVDRBean>();
            }
            this.setNewTypeBean(newStatementOfContributionTypeKVDRBeanLi);
            this.setOldTypeBean(oldStatementOfContributionTypeKVDRBeanLi);
            oldStatementOfContributionTypeKVDRBeanLi.addAll(newStatementOfContributionTypeKVDRBeanLi);
            return oldStatementOfContributionTypeKVDRBeanLi;
        }
        return new LinkedList<StatementOfContributionTypeKVDRBean>();
    }

    private List<StatementOfContributionTypeKVDRBean> getStatementOfContributionTypeKVDRBeanLi(List<EmployeeForSOCKVDRBean> employeeForSOCKVDRBeanLi) throws BusinessDomainException {
        LinkedList<StatementOfContributionTypeKVDRBean> statementOfContributionTypeKVDRBeanLi = new LinkedList<StatementOfContributionTypeKVDRBean>();
        for (EmployeeForSOCKVDRBean employeeForSOCKVDRBean : employeeForSOCKVDRBeanLi) {
            this.getDataForEmployee(employeeForSOCKVDRBean);
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_130520_summierung)) {
                statementOfContributionTypeKVDRBeanLi.add(this.addDataEmployeeForDetailCollections(employeeForSOCKVDRBean));
            }
            this.resetBeanFileds();
        }
        return statementOfContributionTypeKVDRBeanLi;
    }

    private void setNewTypeBean(List<StatementOfContributionTypeKVDRBean> newTypeBeanLi) {
        for (StatementOfContributionTypeKVDRBean newTypeBean : newTypeBeanLi) {
            newTypeBean.setF_status("Neu");
            newTypeBean.setStatus_int(2);
        }
    }

    private void setOldTypeBean(List<StatementOfContributionTypeKVDRBean> oldTypeBeanLi) {
        for (StatementOfContributionTypeKVDRBean oldTypeBean : oldTypeBeanLi) {
            oldTypeBean.setF_status("Storno");
            oldTypeBean.setStatus_int(1);
            oldTypeBean.makeNegativeValues();
        }
    }

    private boolean areEqualTwoBeansFiveAttributes(StatementOfContributionTypeKVDRBean beanNew, StatementOfContributionTypeKVDRBean beanOld) {
        return StringMapper.equal((String)beanNew.getArbeitgeber_bezeichnung(), (String)beanOld.getArbeitgeber_bezeichnung()) && StringMapper.equal((String)beanNew.getKk_bezeichnung(), (String)beanOld.getKk_bezeichnung());
    }

    private boolean areEqualWerteBeans(String[] fieldsNew, String[] fieldsOld) {
        for (int i = 0; i < fieldsNew.length; ++i) {
            if (StringMapper.equal((String)fieldsNew[i], (String)fieldsOld[i])) continue;
            return false;
        }
        return true;
    }

    private boolean areEqualLists(List<StatementOfContributionTypeKVDRBean> newLinkedList, List<StatementOfContributionTypeKVDRBean> oldLinkedList) {
        StatementOfContributionTypeKVDRBean sOCTKVDRBeanOld;
        StatementOfContributionTypeKVDRBean sOCTKVDRBeanNew = newLinkedList.get(0);
        if (this.areEqualTwoBeansFiveAttributes(sOCTKVDRBeanNew, sOCTKVDRBeanOld = oldLinkedList.get(0))) {
            return this.areEqualWerteBeans(sOCTKVDRBeanNew.getFieldValues(), sOCTKVDRBeanOld.getFieldValues());
        }
        return false;
    }

    private void getDataForEmployee(EmployeeForSOCKVDRBean employeeForSOCBean) throws BusinessDomainException {
        Date currentValidFromDate;
        String currentOidPlant = !this.mStatementOfContributionProCompany ? employeeForSOCBean.getOidPlant() : "";
        String currentOidEmployee = employeeForSOCBean.getOidEmployee();
        Date currentEffectiveDate = employeeForSOCBean.getForEffectiveDate();
        Date employeeStartDate = currentValidFromDate = employeeForSOCBean.getForValidFromDate();
        this.FIELD_jahr = DateMapper.toYYYYString((Date)employeeStartDate);
        this.FIELD_pers_nr = this.getPurePersonnelNumber(employeeForSOCBean.getPersonnelNumber());
        this.FIELD_familienname = employeeForSOCBean.getSurname();
        this.FIELD_vorname = employeeForSOCBean.getFirstName();
        this.FIELD_geb_datum = employeeForSOCBean.getGebDatum();
        this.mCompHFAForPayment = employeeForSOCBean.getRefeToComphealthfunallContainer();
        if (this.mCompHFAForPayment != null) {
            String absenderCode = "";
            String absenderBezeichnung = "";
            if (!StringMapper.isNullString((String)this.mCompHFAForPayment.oidplant)) {
                absenderCode = this.mReportValues.getPlantKey(this.mCompHFAForPayment.oidplant);
                absenderBezeichnung = this.mReportValues.getPlantLongDescription(this.mCompHFAForPayment.oidplant, this.mForValidDate, this.mForValidDate);
            } else {
                absenderCode = this.mReportValues.getPCompanyKey(this.mCompHFAForPayment.oidpcompany);
                absenderBezeichnung = this.mReportValues.getCompanyLongDescription(this.mCompHFAForPayment.oidpcompany, this.mForValidDate, this.mForValidDate);
            }
            this.mPaymentCompHealthFundBean = new PaymentCompHealthFundBean(this.mCompHFAForPayment.oidcompaccount, this.mCompHFAForPayment.oidhealthfundroot, this.mCompHFAForPayment.oidbank, this.mCompHFAForPayment.nameofhealthfund, this.mCompHFAForPayment.reasonkvdrdues, this.mCompHFAForPayment.duesaccountnumber, employeeForSOCBean.getKVDRZahlstellenNummer(), this.mCompHFAForPayment.accountnumber, PaymentModeEnumMapper.toPaymentModeEnum((int)this.mCompHFAForPayment.paymodedueshipens), this.mCompHFAForPayment.signatureatproof, TypeOfBankTransferEnumMapper.toTypeOfBankTransferEnum((int)this.mCompHFAForPayment.typetransferhipens), this.mCompHFAForPayment.iban, "", this.mForValidDate, absenderCode, absenderBezeichnung, this.mReportValues.getPCompanyKey(this.mCompHFAForPayment.oidpcompany), this.mReportValues.getPlantKey(this.mCompHFAForPayment.oidplant));
        }
        this.FIELD_header_monat_bezeichnung = ReportHelper.getMonthDescription((int)new VDate(this.mForValidDate).getMonth());
        this.FIELD_subreport_monat_bezeichnung = ReportHelper.getMonthDescription((int)new VDate(currentValidFromDate).getMonth());
        this.FIELD_Monat_int = new VDate(currentValidFromDate).getMonth();
        Insurance currentInsurence = this.getInsurance(currentOidEmployee, employeeForSOCBean.getForEffectiveDate(), employeeForSOCBean.getForValidFromDate());
        this.FIELD_bgs_kv = Integer.toString(currentInsurence.getChoiseOfDuesHI().value());
        this.FIELD_bgs_pv = Integer.toString(currentInsurence.getChoiseOfDuesNI().value());
        this.FIELD_parent = currentInsurence.getNIChildOfEducKVdR() ? "E" : "";
        this.FIELD_pgs = Integer.toString(currentInsurence.getPersonGroup());
        this.FIELD_sv_nummer = currentInsurence.getInsuranceNo();
        this.FIELD_versicherungsnummer = currentInsurence.getMembershipKVdR();
        this.FIELD_aktenzeichen = currentInsurence.getReferenceNumberHealthFund();
        if (!StringMapper.isNullString((String)employeeForSOCBean.getReferToOidHealthFund())) {
            HealthFundTP healthFundTP = this.getHealthFundTP(employeeForSOCBean.getReferToOidHealthFund(), this.mForEffectiveDate, this.mForValidDate);
            AssignmentPCompanyHealthFundTP aPCHFTP = null;
            aPCHFTP = this.getAssignmentPCompanyHealthFundTP("", employeeForSOCBean.getPlantDuesAccountnumber(), employeeForSOCBean.getReferToOidHealthFund(), currentOidPlant, this.mForEffectiveDate, this.mForValidDate);
            this.FIELD_personalAccount = aPCHFTP.getPersonalAccount();
            if (aPCHFTP.getTaxCodeDE() != null) {
                String string = this.FIELD_taxCode = StringMapper.isNullString((String)aPCHFTP.getTaxCodeDE().getImportCode()) ? aPCHFTP.getTaxCodeDE().getCode() : aPCHFTP.getTaxCodeDE().getImportCode();
            }
            if (aPCHFTP.getDiffAddressHF()) {
                PostalAddress pAdress = aPCHFTP.getAddress();
                if (pAdress != null) {
                    this.FIELD_kk_bezeichnung = aPCHFTP.getNameOfHealthfund();
                    this.FIELD_kk_str_nr = pAdress.getStreet();
                    this.FIELD_kk_plz_ort = pAdress.getPostalCode() + " " + pAdress.getCity() + " " + pAdress.getDistrict();
                }
            } else {
                PostalAddress postalAdress = healthFundTP.getAddress();
                if (postalAdress != null) {
                    this.FIELD_kk_bezeichnung = healthFundTP.getShortDescription();
                    this.FIELD_kk_bezeichnung = this.changeHFDescriptionForKrKBundesknappschaft(employeeForSOCBean.getOidInsuranceHealthFund(), this.FIELD_kk_bezeichnung, false, employeeForSOCBean.getForEffectiveDate(), employeeForSOCBean.getForValidFromDate());
                    this.FIELD_kk_str_nr = postalAdress.getStreet();
                    this.FIELD_kk_plz_ort = postalAdress.getPostalCode() + " " + postalAdress.getCity();
                }
            }
            this.FIELD_kk_betriebs_nr = healthFundTP.getStandardCompanyNumber();
        }
        this.FIELD_firma_bezeichnung = StringMapper.isNullString((String)this.getCompanyLongDescription()) ? "" : this.getCompanyLongDescription();
        this.FIELD_firma_nr = this.getPCompanyKey();
        if (!StringMapper.isNullString((String)currentOidPlant)) {
            this.FIELD_betriebsstaette_bezeichnung = StringMapper.isNullString((String)this.getPlantLongDescription(currentOidPlant, this.mForEffectiveDate, this.mForValidDate)) ? "" : this.getPlantLongDescription(currentOidPlant, this.mForEffectiveDate, this.mForValidDate);
            String plantKey = this.getPlantKey(currentOidPlant);
            String string = this.FIELD_betriebsstaette_nr = StringMapper.isNullString((String)plantKey) ? "" : plantKey;
        }
        if (!StringMapper.isNullString((String)employeeForSOCBean.getPCompanyDuesAccountnumber())) {
            List<FstateregionallContainer> listeRegionKey = this.mFstateregionallMap.get(this.getCompanyFoundations().getFederalState().getObjectid());
            this.FIELD_rk_header = this.mEmployeePlantIsEast ? employeeForSOCBean.getPlantLawArea() : this.getFstateRegionLawArea(listeRegionKey);
            this.FIELD_AG_bezeichnung = this.FIELD_firma_bezeichnung;
            CompanyPlantPostalAddress pCompanyPostalAdress = this.getCompanyPostalAdress();
            String currentStreet = pCompanyPostalAdress.getStreet();
            String currentPostalCode = pCompanyPostalAdress.getPostalCode();
            String currentCity = pCompanyPostalAdress.getCity();
            this.FIELD_AG_str_nr = StringMapper.isNullString((String)currentStreet) ? "" : currentStreet;
            this.FIELD_AG_plz_ort = (StringMapper.isNullString((String)currentPostalCode) ? "" : currentPostalCode) + " " + (StringMapper.isNullString((String)currentCity) ? "" : currentCity);
            this.FIELD_AG_betriebsnummer = this.getCompanyEmployerNumber();
            this.FIELD_AG_VWE_NR = this.getPCompanyKey();
            this.FIELD_AG_beitragskontonummer = this.getCompanyKVDRZahlstellenNumber();
        } else {
            Foundations plantFoundations = null;
            plantFoundations = this.getPlantFoundations(currentOidPlant, this.mForEffectiveDate, this.mForValidDate);
            List<FstateregionallContainer> listeRegionKey = this.mFstateregionallMap.get(plantFoundations.getFederalState().getObjectid());
            this.FIELD_rk_header = this.getFstateRegionLawArea(listeRegionKey);
            this.FIELD_AG_bezeichnung = this.FIELD_betriebsstaette_bezeichnung;
            this.FIELD_AG_str_nr = StringMapper.isNullString((String)plantFoundations.getPostalAddress().getStreet()) ? "" : plantFoundations.getPostalAddress().getStreet();
            this.FIELD_AG_plz_ort = (StringMapper.isNullString((String)plantFoundations.getPostalAddress().getPostalCode()) ? "" : plantFoundations.getPostalAddress().getPostalCode()) + " " + (StringMapper.isNullString((String)plantFoundations.getPostalAddress().getCity()) ? "" : plantFoundations.getPostalAddress().getCity());
            this.FIELD_AG_betriebsnummer = this.getPlantEmployerNumber(currentOidPlant, currentEffectiveDate, currentValidFromDate);
            this.FIELD_AG_VWE_NR = this.FIELD_betriebsstaette_nr;
            this.FIELD_betriebsstaette_beitragskonto_nr = employeeForSOCBean.getPlantDuesAccountnumber();
            this.FIELD_AG_beitragskontonummer = this.getPlantKVDRZahlstellenrNumber(currentOidPlant, currentEffectiveDate, currentValidFromDate);
        }
        List liste = ReportEmployeesHandlingHelper.getValuePositionsLi((String)currentOidEmployee, (String[])this.mResultValueTypeNumber, (Date)currentEffectiveDate, (Date)currentValidFromDate, (Date)employeeForSOCBean.getForValidUntilDate());
        if (liste != null) {
            this.getValuePositionFieldValues(liste, currentValidFromDate, employeeForSOCBean.getForValidUntilDate());
        }
    }

    private AssignmentPCompanyHealthFundTP getAssignmentPCompanyHealthFundTP(String plantAssessmentAccountNumber, String plantAccountNumber, String currentOidHealthFund, String currentOidPlant, Date forEffectiveDate, Date employeeStartDate) throws BusinessDomainException {
        AssignmentPCompanyHealthFundTP aPCHFTP = null;
        aPCHFTP = !StringMapper.isNullString((String)plantAssessmentAccountNumber) || !StringMapper.isNullString((String)plantAccountNumber) ? this.getAssignmentCompHealthFundTP(currentOidHealthFund, currentOidPlant, forEffectiveDate, employeeStartDate) : this.getAssignmentCompHealthFundTP(currentOidHealthFund, "", forEffectiveDate, employeeStartDate);
        return aPCHFTP;
    }

    private AssignmentPCompanyHealthFundTP getAssignmentCompHealthFundTP(String oidHealthFund, String oidPlant, Date effectiveDate, Date validDate) throws BusinessDomainException {
        String hFundPlantEffectiveValid = oidHealthFund + oidPlant + VDate.toString((Date)effectiveDate) + VDate.toString((Date)validDate);
        AssignmentPCompanyHealthFundTP aPCHFTP = this.mCompHealthfundTPMap.get(hFundPlantEffectiveValid);
        if (aPCHFTP == null) {
            String oidHFoidPlant = oidHealthFund + oidPlant;
            AssignmentPCompanyHealthFund aPCHF = this.mCompHealthfundMap.get(oidHFoidPlant);
            if (aPCHF == null) {
                aPCHF = this.getAssignmentCompHealthFund(oidHealthFund, oidPlant);
            }
            aPCHFTP = aPCHF.getAssignmentPCompanyHealthFundTP(effectiveDate, validDate);
            this.mCompHealthfundTPMap.put(hFundPlantEffectiveValid, aPCHFTP);
        }
        return aPCHFTP;
    }

    private Map<String, List<FstateregionallContainer>> getHashMapFstateregionall() {
        PersistencyDataSet fstateregionallDataSet = daoFstateregionall.getDataSet(new Order[]{Order.asc((String)"fstateregionkey")}, null);
        FstateregionallContainer fstateregionallContainer = new FstateregionallContainer();
        HashMap<String, LinkedList<FstateregionallContainer>> fstateregionallMap = null;
        if (fstateregionallDataSet != null) {
            fstateregionallMap = new HashMap<String, LinkedList<FstateregionallContainer>>();
            while (fstateregionallDataSet.hasNext()) {
                fstateregionallContainer = (FstateregionallContainer)fstateregionallDataSet.getNext();
                LinkedList<FstateregionallContainer> liste = (LinkedList<FstateregionallContainer>)fstateregionallMap.get(Integer.toString(fstateregionallContainer.fstateregionkey));
                if (liste == null) {
                    liste = new LinkedList<FstateregionallContainer>();
                    fstateregionallMap.put(Integer.toString(fstateregionallContainer.fstateregionkey), liste);
                }
                liste.add(fstateregionallContainer);
            }
        }
        return fstateregionallMap;
    }

    private AssignmentPCompanyHealthFund getAssignmentCompHealthFund(String oidHealthFund, String oidPlant) throws BusinessDomainException {
        String oidHFoidPlant = oidHealthFund + oidPlant;
        AssignmentPCompanyHealthFund aPCHF = this.mCompHealthfundMap.get(oidHFoidPlant);
        if (aPCHF == null) {
            AssignmentPCompanyHealthFund[] aPCHFArray;
            HealthFund hF = this.getHealthFund(oidHealthFund);
            Plant pt = null;
            if (!StringMapper.isNullString((String)oidPlant)) {
                pt = pm.getPlant(oidPlant);
            }
            if ((aPCHFArray = AssignmentPCompanyHealthFund.getAssignmentPCompanyHealthFund((PCompany)this.mPCompany, (HealthFund)hF)).length > 0) {
                if (StringMapper.isNullString((String)oidPlant)) {
                    aPCHF = aPCHFArray[0];
                } else {
                    for (int i = 0; i < aPCHFArray.length; ++i) {
                        if (aPCHFArray[i].getPlant() == null || !StringMapper.equal((String)aPCHFArray[i].getPlant().getPlantKey(), (String)pt.getPlantKey())) continue;
                        aPCHF = aPCHFArray[i];
                    }
                }
                if (aPCHF == null) {
                    aPCHF = aPCHFArray[0];
                }
            } else {
                throw ReportExceptionMapper.makeNoComphealthdundForHealthfundDomainException((String)"Krankenkasse nicht zugeordnet in Zuordnungstabelle Firma-Krankenkasse ");
            }
            this.mCompHealthfundMap.put(oidHFoidPlant, aPCHF);
        }
        return aPCHF;
    }

    private String getFstateRegionLawArea(List<FstateregionallContainer> listeRegionKey) {
        if (DateHelper.before((Date)this.mForValidDate, (Date)new VDate(2026, 0, 1).getDate())) {
            FstateregionallContainer fstateregionallContainer = new FstateregionallContainer();
            if (listeRegionKey != null) {
                fstateregionallContainer = listeRegionKey.get(0);
                return StringMapper.isNullString((String)fstateregionallContainer.lawarea) ? "" : (StringMapper.equal((String)fstateregionallContainer.lawarea, (String)"W") ? "West" : "Ost");
            }
            return "";
        }
        return "";
    }

    private void getValuePositionFieldValues(List<ValuepositionContainer> liste, Date beginnDate, Date endDate) {
        Iterator<ValuepositionContainer> it = liste.iterator();
        while (it.hasNext()) {
            Date valueBeginnDate = beginnDate;
            Date valueEndDate = endDate;
            ValuepositionContainer valuepositionContainer = it.next();
            if (!DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)endDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)beginnDate)) continue;
            valueBeginnDate = DateHelper.after((Date)valuepositionContainer.validfrom, (Date)beginnDate) ? valuepositionContainer.validfrom : beginnDate;
            valueEndDate = DateHelper.before((Date)valuepositionContainer.validuntil, (Date)endDate) ? valuepositionContainer.validuntil : endDate;
            valueEndDate = DateHelper.getLastDayOfMonth((Date)valueEndDate);
            switch (valuepositionContainer.valuetypenumber) {
                case 129300: {
                    this.FIELD_129300_summierung = this.FIELD_129300_summierung.add(valuepositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)valueEndDate), (Date)valueBeginnDate))));
                    break;
                }
                case 129310: {
                    this.FIELD_129310_summierung = this.FIELD_129310_summierung.add(valuepositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)valueEndDate), (Date)valueBeginnDate))));
                    break;
                }
                case 102560: 
                case 130520: {
                    this.FIELD_130520_summierung = this.FIELD_130520_summierung.add(valuepositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)valueEndDate), (Date)valueBeginnDate))));
                    break;
                }
                case 350510: {
                    this.FIELD_350510_summierung = this.FIELD_350510_summierung.add(valuepositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)valueEndDate), (Date)valueBeginnDate))));
                    break;
                }
                case 351516: {
                    this.FIELD_351516_summierung = this.FIELD_351516_summierung.add(valuepositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)valueEndDate), (Date)valueBeginnDate))));
                    break;
                }
                case 351510: {
                    this.FIELD_351510_summierung = this.FIELD_351510_summierung.add(valuepositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)valueEndDate), (Date)valueBeginnDate))));
                    break;
                }
                case 354510: {
                    this.FIELD_354510_summierung = this.FIELD_354510_summierung.add(valuepositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)valueEndDate), (Date)valueBeginnDate))));
                    break;
                }
                case 355510: 
                case 355516: {
                    this.FIELD_355510_summierung = this.FIELD_355510_summierung.add(valuepositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)valueEndDate), (Date)valueBeginnDate))));
                }
            }
        }
    }

    protected void resetBeanFileds() {
        this.FIELD_header_monat_bezeichnung = "";
        this.FIELD_subreport_monat_bezeichnung = "";
        this.FIELD_kk_bezeichnung = "";
        this.FIELD_kk_str_nr = "";
        this.FIELD_kk_plz_ort = "";
        this.FIELD_kk_betriebs_nr = "";
        this.FIELD_firma_bezeichnung = "";
        this.FIELD_firma_nr = "";
        this.FIELD_betriebsstaette_bezeichnung = "";
        this.FIELD_betriebsstaette_nr = "";
        this.FIELD_betriebsstaette_beitragskonto_nr = "";
        this.FIELD_rk_header = "";
        this.FIELD_bgs_kv = "";
        this.FIELD_bgs_pv = "";
        this.FIELD_AG_str_nr = "";
        this.FIELD_AG_plz_ort = "";
        this.FIELD_AG_bezeichnung = "";
        this.FIELD_AG_beitragskontonummer = "";
        this.FIELD_AG_betriebsnummer = "";
        this.FIELD_AG_VWE_NR = "";
        this.FIELD_129300_summierung = BigDecimal.valueOf(0L, 2);
        this.FIELD_130520_summierung = BigDecimal.valueOf(0L, 2);
        this.FIELD_129310_summierung = BigDecimal.valueOf(0L, 2);
        this.FIELD_350510_summierung = BigDecimal.valueOf(0L, 2);
        this.FIELD_354510_summierung = BigDecimal.valueOf(0L, 2);
        this.FIELD_351510_summierung = BigDecimal.valueOf(0L, 2);
        this.FIELD_351516_summierung = BigDecimal.valueOf(0L, 2);
        this.FIELD_355510_summierung = BigDecimal.valueOf(0L, 2);
    }

    private void setFiledsFromBeanFields() {
        ++this.mTypeBeansSerialNumber;
        this.mSOCKVDRTypeBeanForReport.setF_employeeSerialNumber(Integer.toString(this.mTypeBeansSerialNumber));
        this.mTypeInsuredCollection.add(this.mSOCKVDRTypeBeanForReport);
        this.resetBeanFileds();
        this.FIELD_header_monat_bezeichnung = this.mSOCKVDRTypeBeanForReport.getHeader_monat_bezeichnung();
        this.FIELD_kk_bezeichnung = this.mSOCKVDRTypeBeanForReport.getKk_bezeichnung();
        this.FIELD_kk_str_nr = this.mSOCKVDRTypeBeanForReport.getKk_str_nr();
        this.FIELD_kk_plz_ort = this.mSOCKVDRTypeBeanForReport.getKk_plz_ort();
        this.FIELD_kk_betriebs_nr = this.mSOCKVDRTypeBeanForReport.getKk_betriebsnr();
        this.FIELD_personalAccount = this.mSOCKVDRTypeBeanForReport.getPersonnelAccount();
        this.FIELD_taxCode = this.mSOCKVDRTypeBeanForReport.getTaxCode();
        this.FIELD_firma_bezeichnung = this.mSOCKVDRTypeBeanForReport.getFirma_bezeichnung();
        this.FIELD_firma_nr = this.mSOCKVDRTypeBeanForReport.getFirma_VWE_Nr();
        if (StringMapper.equal((String)this.mSOCKVDRTypeBeanForReport.getArbeitgeber_bezeichnung(), (String)this.mSOCKVDRTypeBeanForReport.getBetriebsstaette_bezeichnung()) || this.mEmployeePlantIsEast) {
            this.FIELD_betriebsstaette_bezeichnung = this.mSOCKVDRTypeBeanForReport.getBetriebsstaette_bezeichnung();
            this.FIELD_betriebsstaette_nr = this.mSOCKVDRTypeBeanForReport.getBetriebsstaette_VWE_Nr();
            this.FIELD_betriebsstaette_beitragskonto_nr = this.mSOCKVDRTypeBeanForReport.getBetriebsstaette_beitragskonto_nr();
        }
        this.FIELD_rk_header = this.mSOCKVDRTypeBeanForReport.getRechtskreis();
        this.FIELD_bgs_kv = this.mSOCKVDRTypeBeanForReport.getF_bgs_kv();
        this.FIELD_bgs_pv = this.mSOCKVDRTypeBeanForReport.getF_bgs_pv();
        this.FIELD_351510_summierung = this.mSOCKVDRTypeBeanForReport.getFIELD_351510_summierung();
        this.FIELD_351516_summierung = this.mSOCKVDRTypeBeanForReport.getFIELD_351516_summierung();
        this.FIELD_355510_summierung = this.mSOCKVDRTypeBeanForReport.getFIELD_355510_summierung();
        this.FIELD_350510_summierung = this.mSOCKVDRTypeBeanForReport.getFIELD_350510_summierung();
        this.FIELD_354510_summierung = this.mSOCKVDRTypeBeanForReport.getFIELD_354510_summierung();
        this.FIELD_AG_str_nr = this.mSOCKVDRTypeBeanForReport.getArbeitgeber_str_nr();
        this.FIELD_AG_plz_ort = this.mSOCKVDRTypeBeanForReport.getArbeitgeber_plz_ort();
        this.FIELD_AG_bezeichnung = this.mSOCKVDRTypeBeanForReport.getArbeitgeber_bezeichnung();
        this.FIELD_AG_beitragskontonummer = this.mSOCKVDRTypeBeanForReport.getArbeitgeber_beitragskonto_nr();
        this.FIELD_AG_betriebsnummer = this.mSOCKVDRTypeBeanForReport.getArbeitgeber_betriebsnr();
        this.FIELD_AG_VWE_NR = this.mSOCKVDRTypeBeanForReport.getArbeitgeber_VWE_Nr();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("FIELD_subreport_monat_bezeichnungs = {}FIELD_jahr ={},FIELD_kk_bezeichnung={}FIELD_kk_betriebs_nr ={}FIELD_kk_str_nr ={}FIELD_kk_plz_ort ={}FIELD_firma_bezeichnung={}FIELD_firma_nr={}FIELD_betriebsstaette_bezeichnung={}FIELD_betriebsstaette_beitragskonto_nr= {}FIELD_betriebsstaette_nr= {}FIELD_AG_bezeichnung ={}FIELD_AG_betriebsnummer ={}FIELD_AG_beitragskontonummer ={}FIELD_AG_VWE_NR ={}FIELD_AG_str_nr ={}{}FIELD_AG_plz_ort ={}FIELD_rk_header={}getF_listen_typ ={}FIELD_header_monat_bezeichnung ={}getMonat_int = {}getF_status ={}getStatus_int ={}getF_pers_nr ={}getF_vorname ={}getF_familienname ={}getF_parent ={}getF_pgs ={}getF_KrK_Versicherungs_nr ={}getF_gesetzlicheRente={}getF_versorgungsbezug= {}getF_vb_max={}getF_kvdr_kv_entgelt={}getF_kvdr_pv_entgelt= {}", new Object[]{this.FIELD_subreport_monat_bezeichnung, this.FIELD_jahr, this.FIELD_kk_bezeichnung, this.mSOCKVDRTypeBeanForReport.getKk_betriebsnr(), this.mSOCKVDRTypeBeanForReport.getKk_str_nr(), this.mSOCKVDRTypeBeanForReport.getKk_plz_ort(), this.FIELD_firma_bezeichnung, this.FIELD_firma_nr, this.FIELD_betriebsstaette_bezeichnung, this.FIELD_betriebsstaette_beitragskonto_nr, this.FIELD_betriebsstaette_nr, this.FIELD_AG_bezeichnung, this.FIELD_AG_betriebsnummer, this.FIELD_AG_beitragskontonummer, this.FIELD_AG_VWE_NR, this.FIELD_AG_str_nr, System.getProperty("line.separator"), this.FIELD_AG_plz_ort, this.FIELD_rk_header, this.mSOCKVDRTypeBeanForReport.getF_listen_typ(), this.mSOCKVDRTypeBeanForReport.getHeader_monat_bezeichnung(), this.mSOCKVDRTypeBeanForReport.getMonat_int(), this.mSOCKVDRTypeBeanForReport.getF_status(), this.mSOCKVDRTypeBeanForReport.getStatus_int(), this.mSOCKVDRTypeBeanForReport.getF_pers_nr(), this.mSOCKVDRTypeBeanForReport.getF_vorname(), this.mSOCKVDRTypeBeanForReport.getF_familienname(), this.mSOCKVDRTypeBeanForReport.getF_parent(), this.mSOCKVDRTypeBeanForReport.getF_pgs(), this.mSOCKVDRTypeBeanForReport.getF_KrK_Versicherungs_nr(), this.mSOCKVDRTypeBeanForReport.getF_gesetzlicheRente(), this.mSOCKVDRTypeBeanForReport.getF_versorgungsbezug(), this.mSOCKVDRTypeBeanForReport.getF_vb_max(), this.mSOCKVDRTypeBeanForReport.getF_kvdr_kv_entgelt(), this.mSOCKVDRTypeBeanForReport.getF_kvdr_pv_entgelt()});
        }
    }

    private void addSummFields() {
        switch (Integer.parseInt(this.FIELD_bgs_kv)) {
            case 1: {
                this.f_summe_kv_1000_entgelt = this.f_summe_kv_1000_entgelt.add(this.FIELD_350510_summierung);
                this.f_summe_kv_1000_beitrag = this.f_summe_kv_1000_beitrag.add(this.FIELD_351510_summierung).add(this.isAfter2014() ? BigDecimal.ZERO : this.FIELD_351516_summierung);
                break;
            }
            case 2: {
                this.f_summe_kv_2000_entgelt = this.f_summe_kv_2000_entgelt.add(this.FIELD_350510_summierung);
                this.f_summe_kv_2000_beitrag = this.f_summe_kv_2000_beitrag.add(this.FIELD_351510_summierung).add(this.isAfter2014() ? BigDecimal.ZERO : this.FIELD_351516_summierung);
                break;
            }
            case 3: {
                this.f_summe_kv_3000_entgelt = this.f_summe_kv_3000_entgelt.add(this.FIELD_350510_summierung);
                this.f_summe_kv_3000_beitrag = this.f_summe_kv_3000_beitrag.add(this.FIELD_351510_summierung).add(this.isAfter2014() ? BigDecimal.ZERO : this.FIELD_351516_summierung);
            }
        }
        if (this.isAfter2014()) {
            this.f_summe_kv_zusatzbeitrag = this.f_summe_kv_zusatzbeitrag.add(this.FIELD_351516_summierung);
        }
        switch (Integer.parseInt(this.FIELD_bgs_pv)) {
            case 1: {
                this.f_summe_pv_0001_entgelt = this.f_summe_pv_0001_entgelt.add(this.FIELD_354510_summierung);
                this.f_summe_pv_0001_beitrag = this.f_summe_pv_0001_beitrag.add(this.FIELD_355510_summierung);
                break;
            }
            case 2: {
                this.f_summe_pv_0002_entgelt = this.f_summe_pv_0002_entgelt.add(this.FIELD_354510_summierung);
                this.f_summe_pv_0002_beitrag = this.f_summe_pv_0002_beitrag.add(this.FIELD_355510_summierung);
                break;
            }
            case 3: {
                this.f_summe_pv_0003_entgelt = this.f_summe_pv_0003_entgelt.add(this.FIELD_354510_summierung);
                this.f_summe_pv_0003_beitrag = this.f_summe_pv_0003_beitrag.add(this.FIELD_355510_summierung);
                break;
            }
            case 4: {
                this.f_summe_pv_0004_entgelt = this.f_summe_pv_0004_entgelt.add(this.FIELD_354510_summierung);
                this.f_summe_pv_0004_beitrag = this.f_summe_pv_0004_beitrag.add(this.FIELD_355510_summierung);
                break;
            }
            case 5: {
                this.f_summe_pv_0005_entgelt = this.f_summe_pv_0005_entgelt.add(this.FIELD_354510_summierung);
                this.f_summe_pv_0005_beitrag = this.f_summe_pv_0005_beitrag.add(this.FIELD_355510_summierung);
            }
        }
    }

    protected void resetSummFields() {
        this.f_summe_kv_1000_entgelt = BigDecimal.valueOf(0L, 2);
        this.f_summe_kv_2000_entgelt = BigDecimal.valueOf(0L, 2);
        this.f_summe_kv_3000_entgelt = BigDecimal.valueOf(0L, 2);
        this.f_summe_pv_0001_entgelt = BigDecimal.valueOf(0L, 2);
        this.f_summe_pv_0002_entgelt = BigDecimal.valueOf(0L, 2);
        this.f_summe_pv_0003_entgelt = BigDecimal.valueOf(0L, 2);
        this.f_summe_pv_0004_entgelt = BigDecimal.valueOf(0L, 2);
        this.f_summe_pv_0005_entgelt = BigDecimal.valueOf(0L, 2);
        this.f_summe_kv_1000_beitrag = BigDecimal.valueOf(0L, 2);
        this.f_summe_kv_2000_beitrag = BigDecimal.valueOf(0L, 2);
        this.f_summe_kv_3000_beitrag = BigDecimal.valueOf(0L, 2);
        this.f_summe_pv_0001_beitrag = BigDecimal.valueOf(0L, 2);
        this.f_summe_pv_0002_beitrag = BigDecimal.valueOf(0L, 2);
        this.f_summe_pv_0003_beitrag = BigDecimal.valueOf(0L, 2);
        this.f_summe_pv_0004_beitrag = BigDecimal.valueOf(0L, 2);
        this.f_summe_pv_0005_beitrag = BigDecimal.valueOf(0L, 2);
        this.f_summe_kv_zusatzbeitrag = BigDecimal.valueOf(0L, 2);
        this.f_summe_beitrag = BigDecimal.valueOf(0L, 2);
        this.mTypeBeansSerialNumber = 0;
    }

    protected void buildSummCollection() throws BusinessDomainException {
        this.f_summe_beitrag = BigDecimal.valueOf(0L, 2);
        this.f_summe_beitrag = this.f_summe_beitrag.add(this.f_summe_kv_1000_beitrag).add(this.f_summe_kv_2000_beitrag).add(this.f_summe_kv_3000_beitrag).add(this.f_summe_pv_0001_beitrag).add(this.f_summe_pv_0002_beitrag).add(this.f_summe_pv_0003_beitrag).add(this.f_summe_pv_0004_beitrag).add(this.f_summe_pv_0005_beitrag).add(this.isAfter2014() ? this.f_summe_kv_zusatzbeitrag : BigDecimal.ZERO);
        this.mSummKVDRCollection.add(new StatementOfContributionSummKVDRBean(ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_kv_1000_entgelt), ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_kv_2000_entgelt), ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_kv_3000_entgelt), ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_pv_0001_entgelt), ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_pv_0002_entgelt), ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_pv_0003_entgelt), ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_pv_0004_entgelt), ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_pv_0005_entgelt), "", ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_kv_1000_beitrag), ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_kv_2000_beitrag), ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_kv_3000_beitrag), ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_pv_0001_beitrag), ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_pv_0002_beitrag), ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_pv_0003_beitrag), ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_pv_0004_beitrag), ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_pv_0005_beitrag), ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_kv_zusatzbeitrag), ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_beitrag), this.FIELD_kk_bezeichnung));
    }

    public String getOidPCompany() {
        return this.mEmployees[0].getOidPCompany();
    }

    public StatementOfContributionTypeKVDRBean getSOCKVDRTypeBeanForReport() {
        return this.mSOCKVDRTypeBeanForReport;
    }

    public BigDecimal getSummeBeitrag() {
        return this.f_summe_beitrag;
    }

    public void setSummeBeitrag(BigDecimal value) {
        this.f_summe_beitrag = value;
    }

    public BigDecimal getPVBeitraege() {
        return this.f_summe_pv_0001_beitrag.add(this.f_summe_pv_0002_beitrag).add(this.f_summe_pv_0003_beitrag).add(this.f_summe_pv_0004_beitrag).add(this.f_summe_pv_0005_beitrag);
    }

    public BigDecimal getKVBeitraege() {
        return this.f_summe_kv_1000_beitrag.add(this.f_summe_kv_2000_beitrag).add(this.f_summe_kv_3000_beitrag);
    }

    public IPersonalAccount getPersonnelAccount() {
        return this.FIELD_personalAccount;
    }

    public String getTaxCode() {
        return this.FIELD_taxCode;
    }

    public BigDecimal getSummeKV3000Beitrag() {
        return this.f_summe_kv_3000_beitrag;
    }

    public boolean isPayment() {
        return this.mPayment;
    }

    public BigDecimal getF_summe_kv_zusatzbeitrag() {
        return this.f_summe_kv_zusatzbeitrag;
    }

    public String getAGBetriebsnummer() {
        return this.FIELD_AG_betriebsnummer;
    }

    public String getAGBezeichnung() {
        return this.FIELD_AG_bezeichnung;
    }

    public String getRKHeader() {
        return this.FIELD_rk_header;
    }

    public String getAgVweNr() {
        return this.FIELD_AG_VWE_NR;
    }

    public String getAGBeitragskontonummer() {
        return this.FIELD_AG_beitragskontonummer;
    }

    public String getAGPlzOrt() {
        return this.FIELD_AG_plz_ort;
    }

    public String getAGStrNr() {
        return this.FIELD_AG_str_nr;
    }

    public String getKkBetriebsNr() {
        return this.FIELD_kk_betriebs_nr;
    }

    public String getKkPlzOrt() {
        return this.FIELD_kk_plz_ort;
    }

    public String getKkStrNr() {
        return this.FIELD_kk_str_nr;
    }

    public String getFirmaNr() {
        return this.FIELD_firma_nr;
    }

    public String getKkBezeichnung() {
        return this.FIELD_kk_bezeichnung;
    }

    public void setPaymentCompHealthFundBean(PaymentCompHealthFundBean bean) {
        this.mPaymentCompHealthFundBean = bean;
    }

    public Date getForEffectiveDate() {
        return this.mForEffectiveDate;
    }

    public Date getForValidDate() {
        return this.mForValidDate;
    }

    private List<String> getOidUniqueOidPlantList(EmployeeForReport[] employees) {
        HashSet<String> distincts = new HashSet<String>();
        for (int i = 0; i < employees.length; ++i) {
            String oidPlant = employees[i].getOidPlant();
            if (StringMapper.isNullString((String)oidPlant)) continue;
            distincts.add(oidPlant);
        }
        return new LinkedList<String>(distincts);
    }

    private Collection<StatementOfContributionHealthFundKVDRBean> getHealthFundCollection(String oidHealthFund, Date effectiveDate, Date validDate) {
        LinkedList<StatementOfContributionHealthFundKVDRBean> healthFundKVDRCollection = null;
        HealthFundTP[] hfTPArray = ReportEmployeesHandlingHelper.getHealthFundsTP((String)oidHealthFund, (Date)effectiveDate, (Date)validDate, (Date)validDate);
        if (hfTPArray != null) {
            healthFundKVDRCollection = new LinkedList<StatementOfContributionHealthFundKVDRBean>();
            for (int i = 0; i < hfTPArray.length; ++i) {
                healthFundKVDRCollection.add(new StatementOfContributionHealthFundKVDRBean(DateMapper.toDDMMYYYYPointSeparationString((Date)hfTPArray[i].getValidFrom()), StringMapper.isNullString((String)ReportHelper.toCurrencyFormatIfNullString((Object)hfTPArray[i].getContributionForPensionersPercentage())) ? "0,00" : ReportHelper.toCurrencyFormatIfNullString((Object)hfTPArray[i].getContributionForPensionersPercentage()), StringMapper.isNullString((String)ReportHelper.toCurrencyFormatIfNullString((Object)hfTPArray[i].getContributionForPensionersPercentage())) ? "0,00" : (this.isAfter2014() ? ReportHelper.toCurrencyFormatIfNullString((Object)hfTPArray[i].getAdditionalDues()) : "0.00")));
            }
        }
        return healthFundKVDRCollection;
    }

    private List<SocialinsuranceContainer> getGlobalSocialInsuranceLi(Date forEffectiveDate, Date firstDateOfYear, Date lastDateOfYear) {
        try {
            PersistencyDataSet socialinsuranceDatas = daoSocialinsurance.getDataSet(new Order[]{Order.asc((String)"validfrom")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)forEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)forEffectiveDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)firstDateOfYear)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)lastDateOfYear))}));
            LinkedList<SocialinsuranceContainer> listGlobalSocialInsurance = null;
            if (socialinsuranceDatas != null) {
                listGlobalSocialInsurance = new LinkedList<SocialinsuranceContainer>();
                while (socialinsuranceDatas.hasNext()) {
                    listGlobalSocialInsurance.add((SocialinsuranceContainer)socialinsuranceDatas.getNext());
                }
            }
            return listGlobalSocialInsurance;
        }
        catch (Exception e) {
            ReportExceptionMapper.ignoredException((Throwable)e);
            return null;
        }
    }

    private List<StatementOfContributionGlobalSocialInsuranceKVDRBean> getGlobalSocialInsuranceCollection(Date forEffectiveDate, Date firstDayOfYear, Date lastDayOfYear) {
        LinkedList<StatementOfContributionGlobalSocialInsuranceKVDRBean> result = new LinkedList<StatementOfContributionGlobalSocialInsuranceKVDRBean>();
        BigDecimal kv_ana_beitragszuschalg = BigDecimal.valueOf(0L, 2);
        BigDecimal pv_percentage = BigDecimal.valueOf(0L, 2);
        BigDecimal pv_ana_beitragszuschlag = BigDecimal.valueOf(0L, 2);
        List<SocialinsuranceContainer> globalSocialInsuranceLi = this.getGlobalSocialInsuranceLi(forEffectiveDate, firstDayOfYear, lastDayOfYear);
        for (SocialinsuranceContainer socialinsuranceContainer : globalSocialInsuranceLi) {
            String date_valid_from = DateMapper.toDDMMYYYYPointSeparationString((Date)socialinsuranceContainer.validfrom);
            kv_ana_beitragszuschalg = socialinsuranceContainer.eesurchargehi;
            pv_percentage = socialinsuranceContainer.totalduepcni;
            pv_ana_beitragszuschlag = socialinsuranceContainer.eesurchargeni;
            result.add(new StatementOfContributionGlobalSocialInsuranceKVDRBean(date_valid_from, ReportHelper.toCurrencyFormatIfNullString((Object)kv_ana_beitragszuschalg), ReportHelper.toCurrencyFormatIfNullString((Object)pv_percentage) + "/ " + ReportHelper.toCurrencyFormatIfNullString((Object)pv_ana_beitragszuschlag)));
        }
        return result;
    }

    private Iterator<String> getIteratorFromHashMap(Set<String> keySet) {
        LinkedList<String> list = new LinkedList<String>(keySet);
        Collections.sort(list);
        return list.iterator();
    }

    private Iterator<String> getIteratorNotSortedFromHashMap(Set<String> keySet) {
        return new LinkedList<String>(keySet).iterator();
    }

    public Map<String, String> getEmployeeCorrectionMap() {
        return this.mEmployeeCorrectionMap;
    }

    private String getDateOfBirth(String oidPCompany, String personnelNumber) throws BusinessDomainException {
        Date dateOfBirth = this.getIEmployeePM().getEmployeeByKey(oidPCompany, personnelNumber).getMaster(this.mForEffectiveDate, this.mForValidDate).getDateOfBirth();
        return DateMapper.toDDMMYYYYPointSeparationString((Date)dateOfBirth);
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    protected void fillSumBean() {
        int size = this.mSummBeanCollection.size();
        this.mGesamtSumme = this.mGesamtSumme.add(this.f_summe_beitrag);
        this.mSummBeanCollection.add(new StatementOfContributionKVDRSumBean(Integer.toString(size + 1), this.FIELD_kk_betriebs_nr, this.FIELD_kk_bezeichnung, DateMapper.toDDMMYYYYPointSeparationString((Date)DateHelper.getFirstDayOfMonth((Date)this.getForValidDate())), DateMapper.toDDMMYYYYPointSeparationString((Date)DateHelper.getLastDayOfMonth((Date)this.getForValidDate())), this.FIELD_rk_header, this.FIELD_AG_beitragskontonummer, ReportHelper.toCurrencyFormatIfNullString((Object)this.f_summe_beitrag), this.f_summe_beitrag, ReportHelper.toCurrencyFormatIfNullString((Object)this.mGesamtSumme), this.f_zahlungsart, this.f_blz_krk, this.f_bankbez, this.f_kontonr_krk, Version.getVersion(), this.FIELD_firma_bezeichnung, this.FIELD_betriebsstaette_bezeichnung, "Arbeitgeber", "Betriebsst\u00e4tte", this.getUserID(), this.getReportName(), this.mStaticText_internalUse, "", this.FIELD_taxCode, this.FIELD_personalAccount));
    }

    protected boolean isAfter2014() {
        return DateHelper.afterOrEqual((Date)this.mForEffectiveDate, (Date)new VDate(2015, 0, 1).getDate());
    }
}

