/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.library;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.companyplant.CompanyPlantPostalAddress;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.global.federalstate.FederalState;
import com.varial.personnel.domain.global.federalstate.FederalStateTP;
import com.varial.personnel.domain.global.state.StateTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.emploffice.CompanyEmploymentOffice;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.plant.IPlantPersistencyManager;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.emploffice.PlantEmploymentOffice;
import com.varial.personnel.domain.plant.foundations.PlantFoundations;
import com.varial.personnel.domain.plant.place.PlantPlace;
import com.varial.personnel.domain.plant.place.PlantPlaceTP;
import com.varial.personnel.framework.basictypes.PostalAddress;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.util.Date;

public class EmployerBean {
    private static IPlantPersistencyManager pm = (IPlantPersistencyManager)UtilitiesManager.getBean((String)"plantPersistencyManager", IPlantPersistencyManager.class);
    protected String mOidEmployee;
    protected String mOidPCompany;
    protected String mOidPCompanyForSettings;
    protected String mOidPCompanyForFoundations;
    protected String mOidPlant;
    protected Date mEffectiveDate;
    protected Date mValidDate;
    protected String mPlantCode = "";
    protected String mPlantShortDescription = "";
    protected String mPlantLongDescription = "";
    protected String mPlantStreet = "";
    protected String mPlantPostalcode = "";
    protected String mPlantCity = "";
    protected String mPlantCountry = "";
    protected int mPlantFederalstateKey = 0;
    protected String mPlantFederalstateLongdescription = "";
    protected String mPlantFederalstateShortDescSocialInsuranceLaw = "";
    protected String mPlantLawareaShort = "";
    protected String mPlantLawareaLong = "";
    protected String mPlantBetriebsnummer = "";
    protected String mCompanyCode = "";
    protected String mCompanyShortDescription = "";
    protected String mCompanyLongDescription = "";
    protected String mCompanyStreet = "";
    protected String mCompanyPostalcode = "";
    protected String mCompanyCity = "";
    protected String mCompanyCountry = "";
    protected int mCompanyFederalstateKey = 0;
    protected String mCompanyFederalstateLongdescription = "";
    protected String mCompanyFederalstateShortDescSocialInsuranceLaw = "";
    protected String mCompanyLawareaShort = "";
    protected String mCompanyLawareaLong = "";
    protected String mCompanyBetriebsnummer = "";

    public void setOidEmployee(String oidEmployee) {
        this.mOidEmployee = oidEmployee;
    }

    public void setOidPCompany(String oidPCompany) {
        this.mOidPCompany = oidPCompany;
    }

    public void setOidPCompanyForSettings(String oidPCompanyForSettings) {
        this.mOidPCompanyForSettings = oidPCompanyForSettings;
    }

    public void setOidPCompanyForFoundations(String oidPCompanyForFoundations) {
        this.mOidPCompanyForFoundations = oidPCompanyForFoundations;
    }

    public void setOidPlant(String oidPlant) {
        this.mOidPlant = oidPlant;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.mEffectiveDate = effectiveDate;
    }

    public void setValidDate(Date validDate) {
        this.mValidDate = validDate;
    }

    public void createEmployerBean() throws BusinessDomainException {
        this.resetDatas();
        this.takePlantDatasForEmployer(true);
        this.takePCompanyDatasForEmployer();
    }

    public void createEmployerBeanWithoutPlantPlace() throws BusinessDomainException {
        this.resetDatas();
        this.takePlantDatasForEmployer(false);
        this.takePCompanyDatasForEmployer();
    }

    private void takePlantDatasForEmployer(boolean includedPlantPlace) throws BusinessDomainException {
        Plant plant;
        if (!StringMapper.isNullString((String)this.mOidPlant) && (plant = this.getPlant()) != null) {
            this.mPlantCode = plant.getPlantKey();
            PlantFoundations foundations = plant.getPlantFoundations(this.mEffectiveDate, this.mValidDate);
            if (foundations != null) {
                this.mPlantShortDescription = foundations.getFoundations().getShortDescription();
                this.mPlantLongDescription = foundations.getFoundations().getLongDescription();
                if (this.mPlantLongDescription.length() > 80) {
                    this.mPlantLongDescription = this.mPlantLongDescription.substring(0, 80);
                }
                PlantPlace plantPlace = null;
                PlantPlaceTP plantPlaceTP = null;
                if (includedPlantPlace && (plantPlace = this.getPlantPlace()) != null) {
                    plantPlaceTP = plantPlace.getPlantPlaceTP(this.mEffectiveDate, this.mValidDate);
                }
                if (plantPlaceTP != null && (plantPlaceTP.getClosingDate() == null || DateHelper.before((Date)DateHelper.getLastDayOfMonth((Date)this.mValidDate), (Date)DateHelper.getLastDayOfMonth((Date)plantPlaceTP.getClosingDate())))) {
                    FederalState federalState;
                    PostalAddress postalAddress = plantPlaceTP.getAddress();
                    if (postalAddress != null) {
                        this.mPlantStreet = postalAddress.getStreet();
                        this.mPlantPostalcode = postalAddress.getPostalCode();
                        this.mPlantCity = postalAddress.getCity();
                        this.mPlantCountry = foundations.getFoundations().getState().getStateTP(this.mEffectiveDate, this.mValidDate).getStateTag();
                    }
                    if ((federalState = plantPlaceTP.getFederalState()) != null) {
                        this.mPlantFederalstateKey = federalState.getFederalState();
                        FederalStateTP federalStateTP = federalState.getFederalStateTP(this.mEffectiveDate, this.mValidDate);
                        if (federalStateTP != null) {
                            this.mPlantFederalstateLongdescription = federalStateTP.getLongDescription();
                            this.mPlantFederalstateShortDescSocialInsuranceLaw = federalStateTP.getShortDescSocialInsuranceLaw();
                            if (DateHelper.afterOrEqual((Date)this.mValidDate, (Date)new VDate(2026, 0, 1).getDate())) {
                                this.mPlantLawareaShort = "";
                                this.mPlantLawareaLong = "";
                            } else {
                                this.mPlantLawareaShort = federalStateTP.getLawArea();
                                this.mPlantLawareaLong = StringMapper.equal((String)this.mPlantLawareaShort, (String)"W") ? "West" : "Ost";
                            }
                        }
                    }
                    this.mPlantBetriebsnummer = plantPlace.getStandardCompanyNumber();
                    if (StringMapper.isNullString((String)this.mPlantBetriebsnummer)) {
                        try {
                            PlantEmploymentOffice employmentOffice = this.getPlant().getPlantEmploymentOffice(this.mEffectiveDate, this.mValidDate);
                            if (employmentOffice != null) {
                                this.mPlantBetriebsnummer = employmentOffice.getGeneralEmploymentOffice().getEmployerNumber();
                            }
                        }
                        catch (BusinessDomainException de) {
                            ExceptionMapper.printException((Throwable)de);
                        }
                    }
                } else {
                    PlantEmploymentOffice employmentOffice;
                    FederalState federalState;
                    CompanyPlantPostalAddress postalAddress = foundations.getFoundations().getPostalAddress();
                    if (postalAddress != null) {
                        this.mPlantStreet = postalAddress.getStreet();
                        this.mPlantPostalcode = postalAddress.getPostalCode();
                        this.mPlantCity = postalAddress.getCity();
                        this.mPlantCountry = "D";
                        if (foundations.getFoundations().getState() != null && foundations.getFoundations().getState().getHistory().getItemOrNull(this.mEffectiveDate, this.mValidDate) != null) {
                            this.mPlantCountry = ((StateTP)foundations.getFoundations().getState().getHistory().getItemOrNull(this.mEffectiveDate, this.mValidDate)).getStateTag();
                        }
                    }
                    if ((federalState = foundations.getFoundations().getFederalState()) != null) {
                        this.mPlantFederalstateKey = federalState.getFederalState();
                        FederalStateTP federalStateTP = federalState.getFederalStateTP(this.mEffectiveDate, this.mValidDate);
                        if (federalStateTP != null) {
                            this.mPlantFederalstateLongdescription = federalStateTP.getLongDescription();
                            this.mPlantFederalstateShortDescSocialInsuranceLaw = federalStateTP.getShortDescSocialInsuranceLaw();
                            if (DateHelper.afterOrEqual((Date)this.mValidDate, (Date)new VDate(2026, 0, 1).getDate())) {
                                this.mPlantLawareaShort = "";
                                this.mPlantLawareaLong = "";
                            } else {
                                this.mPlantLawareaShort = federalStateTP.getLawArea();
                                String string = this.mPlantLawareaLong = StringMapper.equal((String)this.mPlantLawareaShort, (String)"W") ? "West" : "Ost";
                            }
                        }
                    }
                    if ((employmentOffice = (PlantEmploymentOffice)this.getPlant().getPlantEmploymentOfficeHistory().getItemOrNull(this.mEffectiveDate, this.mValidDate)) != null) {
                        this.mPlantBetriebsnummer = employmentOffice.getGeneralEmploymentOffice().getEmployerNumber();
                    }
                }
            }
        }
    }

    private void takePCompanyDatasForEmployer() throws BusinessDomainException {
        CompanyEmploymentOffice employmentOffice;
        FederalState federalState;
        CompanyFoundations foundations;
        PCompany pCompany;
        if (StringMapper.isNullString((String)this.mOidPCompanyForSettings)) {
            this.mOidPCompanyForSettings = this.mOidPCompany;
        }
        if (StringMapper.isNullString((String)this.mOidPCompanyForFoundations)) {
            this.mOidPCompanyForFoundations = this.mOidPCompany;
        }
        if (!StringMapper.isNullString((String)this.mOidPCompanyForFoundations) && (pCompany = this.getPCompany(this.mOidPCompanyForFoundations)) != null) {
            this.mCompanyCode = pCompany.getPCompanyKey();
            foundations = pCompany.getCompanyFoundations(this.mEffectiveDate, this.mValidDate);
            if (foundations != null) {
                CompanyPlantPostalAddress postalAddress;
                this.mCompanyShortDescription = foundations.getFoundations().getShortDescription();
                this.mCompanyLongDescription = foundations.getFoundations().getLongDescription();
                if (this.mCompanyLongDescription.length() > 80) {
                    this.mCompanyLongDescription = this.mCompanyLongDescription.substring(0, 80);
                }
                if ((postalAddress = foundations.getFoundations().getPostalAddress()) != null) {
                    this.mCompanyStreet = postalAddress.getStreet();
                    this.mCompanyPostalcode = postalAddress.getPostalCode();
                    this.mCompanyCity = postalAddress.getCity();
                    this.mCompanyCountry = foundations.getFoundations().getState().getStateTP(this.mEffectiveDate, this.mValidDate).getStateTag();
                }
            }
        }
        if (!StringMapper.isNullString((String)this.mOidPCompany) && (pCompany = this.getPCompany(this.mOidPCompany)) != null && (foundations = pCompany.getCompanyFoundations(this.mEffectiveDate, this.mValidDate)) != null && (federalState = foundations.getFoundations().getFederalState()) != null) {
            this.mCompanyFederalstateKey = federalState.getFederalState();
            FederalStateTP federalStateTP = federalState.getFederalStateTP(this.mEffectiveDate, this.mValidDate);
            if (federalStateTP != null) {
                this.mCompanyFederalstateLongdescription = federalStateTP.getLongDescription();
                this.mCompanyFederalstateShortDescSocialInsuranceLaw = federalStateTP.getShortDescSocialInsuranceLaw();
                if (DateHelper.afterOrEqual((Date)this.mValidDate, (Date)new VDate(2026, 0, 1).getDate())) {
                    this.mCompanyLawareaShort = "";
                    this.mCompanyLawareaLong = "";
                } else {
                    this.mCompanyLawareaShort = federalStateTP.getLawArea();
                    String string = this.mCompanyLawareaLong = StringMapper.equal((String)this.mCompanyLawareaShort, (String)"W") ? "West" : "Ost";
                }
            }
        }
        if (!StringMapper.isNullString((String)this.mOidPCompanyForSettings) && (pCompany = this.getPCompany(this.mOidPCompanyForSettings)) != null && (employmentOffice = pCompany.getCompanyEmploymentOffice(this.mEffectiveDate, this.mValidDate)) != null) {
            this.mCompanyBetriebsnummer = employmentOffice.getGeneralEmploymentOffice().getEmployerNumber();
        }
    }

    private PlantPlace getPlantPlace() throws BusinessDomainException {
        PlantPlace plantPlace = null;
        if (!StringMapper.isNullString((String)this.mOidEmployee)) {
            Employee employee = this.getEmployee();
            Date validDate = DateHelper.max((Date)employee.getStartOfHistory(), (Date)this.mValidDate);
            plantPlace = this.getEmployee().getEmployment(this.mEffectiveDate, validDate).getPlantPlace();
        }
        return plantPlace;
    }

    private Employee getEmployee() {
        return this.getIEmployeePM().getEmployee(this.mOidEmployee);
    }

    private void resetDatas() {
        this.mPlantCode = "";
        this.mPlantShortDescription = "";
        this.mPlantLongDescription = "";
        this.mPlantStreet = "";
        this.mPlantPostalcode = "";
        this.mPlantCity = "";
        this.mPlantFederalstateKey = 0;
        this.mPlantFederalstateLongdescription = "";
        this.mPlantFederalstateShortDescSocialInsuranceLaw = "";
        this.mPlantLawareaShort = "";
        this.mPlantLawareaLong = "";
        this.mPlantBetriebsnummer = "";
        this.mCompanyCode = "";
        this.mCompanyShortDescription = "";
        this.mCompanyLongDescription = "";
        this.mCompanyStreet = "";
        this.mCompanyPostalcode = "";
        this.mCompanyCity = "";
        this.mCompanyFederalstateKey = 0;
        this.mCompanyFederalstateLongdescription = "";
        this.mCompanyFederalstateShortDescSocialInsuranceLaw = "";
        this.mCompanyLawareaShort = "";
        this.mCompanyLawareaLong = "";
        this.mCompanyBetriebsnummer = "";
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    protected PCompany getPCompany(String oidPCompany) {
        PCompany pCompany = PCompanyPersistencyManager.getPCompany((String)oidPCompany);
        return pCompany;
    }

    public Plant getPlant() {
        Plant plant = pm.getPlant(this.mOidPlant);
        return plant;
    }

    public String getPlantCode() {
        return this.mPlantCode;
    }

    public String getPlantShortDescription() {
        return this.mPlantShortDescription;
    }

    public String getPlantLongDescription() {
        return this.mPlantLongDescription;
    }

    public String getPlantStreet() {
        return this.mPlantStreet;
    }

    public String getPlantPostalcode() {
        return this.mPlantPostalcode;
    }

    public String getPlantCity() {
        return this.mPlantCity;
    }

    public int getPlantFederalstateKey() {
        return this.mPlantFederalstateKey;
    }

    public String getPlantFederalstateLongdescription() {
        return this.mPlantFederalstateLongdescription;
    }

    public String getPlantLawareaShort() {
        return this.mPlantLawareaShort;
    }

    public String getPlantLawareaLong() {
        return this.mPlantLawareaLong;
    }

    public String getPlantBetriebsnummer() {
        return this.mPlantBetriebsnummer;
    }

    public String getCompanyCode() {
        return this.mCompanyCode;
    }

    public String getCompanyShortDescription() {
        return this.mCompanyShortDescription;
    }

    public String getCompanyLongDescription() {
        return this.mCompanyLongDescription;
    }

    public String getCompanyStreet() {
        return this.mCompanyStreet;
    }

    public String getCompanyPostalcode() {
        return this.mCompanyPostalcode;
    }

    public String getCompanyCity() {
        return this.mCompanyCity;
    }

    public int getCompanyFederalstateKey() {
        return this.mCompanyFederalstateKey;
    }

    public String getCompanyFederalstateLongdescription() {
        return this.mCompanyFederalstateLongdescription;
    }

    public String getCompanyLawareaShort() {
        return this.mCompanyLawareaShort;
    }

    public String getCompanyLawareaLong() {
        return this.mCompanyLawareaLong;
    }

    public String getCompanyBetriebsnummer() {
        return this.mCompanyBetriebsnummer;
    }

    public boolean isDBT() {
        return false;
    }

    public String getCompanyFederalstateShortDescSocialInsuranceLaw() {
        return this.mCompanyFederalstateShortDescSocialInsuranceLaw;
    }

    public void setCompanyFederalstateShortDescSocialInsuranceLaw(String mCompanyFederalstateShortDescSocialInsuranceLaw) {
        this.mCompanyFederalstateShortDescSocialInsuranceLaw = mCompanyFederalstateShortDescSocialInsuranceLaw;
    }

    public String getPlantFederalstateShortDescSocialInsuranceLaw() {
        return this.mPlantFederalstateShortDescSocialInsuranceLaw;
    }

    public void setPlantFederalstateShortDescSocialInsuranceLaw(String mPlantFederalstateShortDescSocialInsuranceLaw) {
        this.mPlantFederalstateShortDescSocialInsuranceLaw = mPlantFederalstateShortDescSocialInsuranceLaw;
    }

    public String getCompanyCountry() {
        return this.mCompanyCountry;
    }
}

