/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.eubp;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.dao.dcp.DataSourceFieldAccessor;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.AssignmentPCompanyHealthFundTP;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.AssignmentPCompanyHealthFundTPPersistencyManager;
import com.varial.personnel.domain.companyplant.GeneralTaxOffice;
import com.varial.personnel.domain.companyplant.Settings;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.paymentofcontributions.insurancedsbn.InsuranceDsbn;
import com.varial.personnel.domain.employee.paymentofcontributions.insurancedsbn.InsuranceDsbnPersistencyManager;
import com.varial.personnel.domain.eubp.EubpEmployee;
import com.varial.personnel.domain.eubp.EubpHelper;
import com.varial.personnel.domain.eubp.EubpMandant;
import com.varial.personnel.domain.eubp.EubpMandantTypeEnum;
import com.varial.personnel.domain.eubp.account.EubpAccount;
import com.varial.personnel.domain.eubp.basics.BasicRecord;
import com.varial.personnel.domain.eubp.dsag.EubpDsag;
import com.varial.personnel.domain.eubp.dsag.PartDsag;
import com.varial.personnel.domain.eubp.dsan.EubpDsan;
import com.varial.personnel.domain.eubp.dsbn.EubpDsbn;
import com.varial.personnel.domain.eubp.dsbn.PartDsbn;
import com.varial.personnel.domain.eubp.dsbn.dbrb.EubpDbrb;
import com.varial.personnel.domain.eubp.dsbn.dbsc.EubpDbsc;
import com.varial.personnel.domain.eubp.dsek.EubpDsek;
import com.varial.personnel.domain.eubp.dsek.PartDsek;
import com.varial.personnel.domain.eubp.dsfb.EubpDsfb;
import com.varial.personnel.domain.eubp.dsla.EubpDsla;
import com.varial.personnel.domain.eubp.dsst.EubpDsst;
import com.varial.personnel.domain.eubp.dsze.EubpDsze;
import com.varial.personnel.domain.eubp.mapper.EubpExceptionMapper;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.global.healthfund.Assessment;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.eubp.DslaCreator;
import com.varial.personnel.domain.reports.eubp.EmployeeWithPeriods;
import com.varial.personnel.domain.reports.eubp.EubpProgressbar;
import com.varial.personnel.domain.reports.eubp.EubpVersion;
import com.varial.personnel.domain.reports.eubp.EubpsCreator;
import com.varial.personnel.domain.reports.eubp.Mandanten;
import com.varial.personnel.domain.reports.statementofcontribution.StatementOfContributionHealthFundBean;
import com.varial.personnel.domain.reports.statementofcontribution.StatementOfContributionReportDataSource;
import com.varial.personnel.domain.reports.statementofcontribution.StatementOfContributionSummBean;
import com.varial.personnel.domain.reports.statementofcontribution.StatementOfContributionTypeEnum;
import com.varial.personnel.framework.ISpecialAccessPersistencyContext;
import com.varial.personnel.framework.Period;
import com.varial.personnel.framework.Periods;
import com.varial.personnel.framework.PersonnelHistory;
import com.varial.personnel.framework.SpecialAccess;
import com.varial.personnel.framework.basictypes.PostalAddress;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.query.AllCallback;
import com.varial.serverbase.query.PutDataException;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EubpCreator {
    public static Logger LOGGER = LoggerFactory.getLogger(EubpCreator.class);
    private final EubpsCreator mEubpsCreator;
    private final Date mValidFrom;
    private final Date mValidUntil;
    final Date mEffectiveDate;
    private final Writer mWriter;
    private final int mFileNumber;
    final String mBetriebsnummer;
    private final EubpMandant mEubpMandant;
    private final Mandanten mMandanten;
    private final DEUVSenderTP mDEUVSenderTP;
    final EubpAccount mEubpAccount;
    final BasicRecord mBasicRecord;
    private final SpecialAccess mSpecialAccess;
    private final ReportFileStructCallback mCallback;
    private final EubpProgressbar mProgressbar;
    private final Collection<EmployeeWithPeriods> mEmployees;
    private final boolean mIsFirst;
    private final boolean mIsLast;
    private int mCount = 0;
    private final EubpVersion mEubpVersion;

    public EubpCreator(EubpsCreator eubpsCreator, Writer writer, int fileNumber, String betriebsnummer, EubpMandant eubpMandant, Mandanten mandanten, Collection<EmployeeWithPeriods> employees, boolean isFirst, boolean isLast) throws BusinessDomainException {
        this.mEubpsCreator = eubpsCreator;
        this.mWriter = writer;
        this.mFileNumber = fileNumber;
        this.mBetriebsnummer = betriebsnummer;
        this.mEubpMandant = eubpMandant;
        this.mMandanten = mandanten;
        this.mValidFrom = eubpsCreator.getValidFrom();
        this.mValidUntil = eubpsCreator.getValidUntil();
        this.mEffectiveDate = eubpsCreator.getEffectiveDate();
        this.mDEUVSenderTP = eubpsCreator.getDEUVSenderTP();
        this.mEubpAccount = eubpsCreator.getEubpAccount();
        this.mBasicRecord = eubpsCreator.getBasicRecord();
        this.mSpecialAccess = eubpsCreator.getSpecialAccess();
        this.mCallback = eubpsCreator.getCallback();
        this.mProgressbar = eubpsCreator.getProgressbar();
        this.mEmployees = employees;
        this.mIsFirst = isFirst;
        this.mIsLast = isLast;
        this.mEubpVersion = EubpVersion.getVersion();
    }

    public EubpVersion getEubpVersion() {
        return this.mEubpVersion;
    }

    public Date getValidFrom() {
        return this.mValidFrom;
    }

    public void create() throws IOException, BusinessDomainException {
        LOGGER.debug("VOSZ");
        this.mProgressbar.initSubStep("VOSZ");
        this.mWriter.write(this.getVOSZ() + System.lineSeparator());
        LOGGER.debug("DSKO");
        this.mProgressbar.initSubStep("DSKO");
        this.addLine(this.getDSKO());
        EubpDsst dsst = this.createDSST();
        LOGGER.debug("DSST");
        this.mProgressbar.initSubStep("DSST");
        this.addLine(dsst.print());
        if (this.mIsFirst) {
            HealthFundTP healthFundTP;
            if (this.mEubpVersion.compareTo(EubpVersion.V_3_4_0) >= 0) {
                LOGGER.debug("DSZE");
                this.mProgressbar.initSubStep("DSZE");
                EubpDsze dsze = this.createDSZE();
                if (dsze != null) {
                    this.addLine(dsze.print());
                }
            }
            if (this.mEubpVersion.compareTo(EubpVersion.V_3_4_0) >= 0) {
                LOGGER.debug("DSFB");
                this.mProgressbar.initSubStep("DSFB");
                EubpDsfb dsfb = this.createDSFB();
                if (dsfb != null) {
                    this.addLine(dsfb.print());
                }
            }
            LOGGER.debug("DSAG");
            this.mProgressbar.initSubStep("DSAG");
            this.addLine(this.createDSAG(dsst).print());
            LOGGER.debug("DSEK");
            this.mProgressbar.initSubStep("DSEK");
            HashMap<String, AssignmentPCompanyHealthFundTP> assignmentHealthFundTPMap = new HashMap<String, AssignmentPCompanyHealthFundTP>();
            for (AssignmentPCompanyHealthFundTP assignmentHealthFundTP : this.queryHealthFundTPs(this.mEubpMandant)) {
                healthFundTP = (HealthFundTP)assignmentHealthFundTP.getAssignmentPCompanyHealthFund().getHealthFund().getHistory().getItemOrNull(this.mEffectiveDate);
                if (healthFundTP == null) continue;
                assignmentHealthFundTPMap.put(healthFundTP.getStandardCompanyNumber(), assignmentHealthFundTP);
            }
            if (this.mEubpMandant.getType() != EubpMandantTypeEnum.PCompany) {
                for (AssignmentPCompanyHealthFundTP assignmentHealthFundTP : this.queryHealthFundTPs(new EubpMandant(this.mEubpMandant.getPCompanyOfMandant()))) {
                    healthFundTP = (HealthFundTP)assignmentHealthFundTP.getAssignmentPCompanyHealthFund().getHealthFund().getHistory().getItemOrNull(this.mEffectiveDate);
                    if (healthFundTP == null) continue;
                    assignmentHealthFundTPMap.put(healthFundTP.getStandardCompanyNumber(), assignmentHealthFundTP);
                }
            }
            Collection assignmentPCompanyHealthFundTPs = assignmentHealthFundTPMap.values();
            this.mProgressbar.setTotal(assignmentPCompanyHealthFundTPs.size());
            for (AssignmentPCompanyHealthFundTP assignmentHealthFundTP : assignmentPCompanyHealthFundTPs) {
                EubpDsek dsek = this.createDSEK(assignmentHealthFundTP);
                if (dsek == null) continue;
                this.addLine(dsek.print());
                this.mProgressbar.nextProcessed();
            }
            LOGGER.debug("DSBN");
            Collection<EubpDsbn> eubpDsbns = this.getDSBNs();
            this.mProgressbar.initSubStep("DSBN", eubpDsbns.size());
            for (EubpDsbn eubpDsbn : eubpDsbns) {
                this.addLine(eubpDsbn.print());
                this.mProgressbar.nextProcessed();
            }
        }
        this.mProgressbar.initSubStep("DSAN", this.mEmployees.size());
        for (EmployeeWithPeriods employee : this.mEmployees) {
            EubpDsan dsan = null;
            LOGGER.debug("DSAN");
            dsan = this.createDSAN(employee);
            if (dsan != null) {
                this.addLine(dsan.print());
            }
            if (dsan != null) {
                LOGGER.debug("DSLA");
                this.addLine(this.createDSLA(employee).print());
            }
            this.mProgressbar.nextProcessed();
        }
        LOGGER.debug("NCSZ");
        this.mProgressbar.initSubStep("NCSZ");
        this.mWriter.write(this.getNCSZ());
    }

    private void addLine(String datensatz) throws IOException {
        this.mWriter.write(datensatz + System.lineSeparator());
        ++this.mCount;
    }

    private String getVOSZ() {
        return EubpHelper.getVOSZ((BasicRecord)this.mBasicRecord, (int)this.mFileNumber, (DEUVSenderTP)this.mDEUVSenderTP);
    }

    private String getDSKO() {
        return EubpHelper.getDSKO((BasicRecord)this.mBasicRecord, (DEUVSenderTP)this.mDEUVSenderTP);
    }

    private EubpDsst createDSST() {
        EubpDsst dsst = this.mEubpAccount.createEubpDsst();
        String versionsnr = this.mEubpVersion.getVersionDSST();
        dsst.setVersionsnr(versionsnr);
        dsst.setBasicRecord(this.mBasicRecord);
        dsst.setBbnrVU(this.mBetriebsnummer);
        dsst.setBbnrAS(this.mBetriebsnummer);
        dsst.setBbnrMS(this.mBetriebsnummer);
        dsst.setZrVon(this.mValidFrom);
        dsst.setZrBis(this.mValidUntil);
        dsst.setGddue(Integer.valueOf("02".equals(versionsnr) ? 0 : this.mEubpsCreator.getDeliveryReason().toInt()));
        dsst.setKennzSeKo(this.mIsLast ? "J" : "N");
        dsst.setKennzSt("N");
        dsst.setVerGes(this.mEubpVersion.toString());
        dsst.setFileNumber(this.mFileNumber);
        dsst.setAkAb("");
        return dsst;
    }

    private EubpDsze createDSZE() {
        if (!this.mEubpsCreator.getIsZustellung()) {
            return null;
        }
        EubpDsze dsze = this.mEubpAccount.createEubpDsze();
        dsze.setBasicRecord(this.mBasicRecord);
        dsze.setEmailElektronischesPruefergbnis(this.mEubpsCreator.getEmailAddress());
        return dsze;
    }

    private EubpDsfb createDSFB() {
        if (!this.mEubpsCreator.getIsFragebogen()) {
            return null;
        }
        EubpDsfb dsfb = this.mEubpAccount.createEubpDsfb();
        dsfb.setBasicRecord(this.mBasicRecord);
        dsfb.setKennzLstAp(this.mEubpsCreator.getKennzLstAp() ? "J" : "N");
        dsfb.setKennzWg(this.mEubpsCreator.getKennzWg());
        dsfb.setKennzFamilieMitarbeit(this.mEubpsCreator.getKennzFamilieMitarbeit() ? "J" : "N");
        dsfb.setNameAp(this.mEubpsCreator.getNameAp());
        dsfb.setTelAp(this.mEubpsCreator.getTelAp());
        dsfb.setEmailAp(this.mEubpsCreator.getEmailAp());
        return dsfb;
    }

    private EubpDsag createDSAG(EubpDsst dsst) throws BusinessDomainException {
        EubpDsag dsag = this.mEubpAccount.createEubpDsag();
        dsag.setBasicRecord(this.mBasicRecord);
        dsag.setMandant(this.mBetriebsnummer);
        dsag.setEubpDsst(dsst);
        dsst.setEubpDsag(dsag);
        dsag.setPCompany(this.mEubpMandant.getPCompany());
        dsag.setPlant(this.mEubpMandant.getPlant());
        dsag.setPlantPlace(this.mEubpMandant.getPlantPlace());
        PartDsag partdsag = new PartDsag();
        ArrayList<PartDsag> partList = new ArrayList<PartDsag>();
        Periods periods = this.mMandanten.getPeriods();
        String tmpPrintOhneGltab = null;
        for (Period month : periods.getMonths()) {
            partdsag = new PartDsag();
            Date validDate = month.until;
            PostalAddress address = this.mEubpMandant.getPostalAdress(validDate);
            String[] description = this.mEubpMandant.getDescriptions(validDate);
            partdsag.setGltAb(month.from);
            partdsag.setAenddat(DateMapper.toYYYYMMDDString((Date)this.mEubpMandant.getTimestamp()) + "000000000");
            partdsag.setNamebb1(description[0]);
            partdsag.setNamebb2(description[1]);
            partdsag.setNamebb3(description[2]);
            partdsag.setLdkz("D");
            partdsag.setPlz(address.getPostalCode());
            partdsag.setOrt(address.getCity());
            partdsag.setStr(address.getStreet());
            partdsag.setHnr("");
            Settings settings = this.mMandanten.getSettings(validDate);
            String kennzUm = "2";
            if (settings != null) {
                switch (settings.getAssessmentDuty()) {
                    case KEINE: {
                        kennzUm = "0";
                        break;
                    }
                    case U2: {
                        kennzUm = "1";
                        break;
                    }
                    case U1_UND_U2: {
                        kennzUm = "2";
                    }
                }
            }
            partdsag.setKennzUm(kennzUm);
            partdsag.setKennzUi(settings != null && settings.getInsolvencyAssessable() ? "1" : "0");
            GeneralTaxOffice generalTaxOffice = this.mMandanten.getGeneralTaxOffice(validDate);
            partdsag.setBuFANr(generalTaxOffice == null ? "" : generalTaxOffice.getTaxOffice().getTaxOffice());
            partdsag.setStnr(generalTaxOffice == null ? "" : generalTaxOffice.getTaxNumber());
            String currentPrintOhneGltab = partdsag.printOhneGltAb();
            if (currentPrintOhneGltab.equals(tmpPrintOhneGltab)) continue;
            partList.add(partdsag);
            tmpPrintOhneGltab = currentPrintOhneGltab;
        }
        dsag.setPartDsags((PartDsag[])partList.toArray(PartDsag[]::new));
        return dsag;
    }

    private EubpDsek createDSEK(AssignmentPCompanyHealthFundTP assignmentHealthFundTP) throws BusinessDomainException {
        EubpDsek dsek = this.mEubpAccount.createEubpDsek();
        dsek.setVersionsnr(this.mEubpVersion.getVersionDSEK());
        dsek.setBasicRecord(this.mBasicRecord);
        dsek.setMandant(this.mBetriebsnummer);
        PersonnelHistory healthFundTPHistory = assignmentHealthFundTP.getAssignmentPCompanyHealthFund().getHealthFund().getHistory();
        ArrayList<PartDsek> parts = new ArrayList<PartDsek>();
        BigDecimal lastRefundPercentage = null;
        for (Period month : this.mMandanten.getPeriods().getMonths()) {
            BigDecimal refundPercentage;
            Date validDate = month.until;
            HealthFundTP healthFundTP = (HealthFundTP)healthFundTPHistory.getItemOrNull(validDate);
            Settings settings = this.mMandanten.getSettings(validDate);
            if (healthFundTP == null || settings == null || !settings.getAssessable()) continue;
            dsek.setBbnrkk(healthFundTP.getStandardCompanyNumber());
            int assessment1 = assignmentHealthFundTP.getAssessment1();
            Assessment assessment = assessment1 == 0 ? null : healthFundTP.getAssessments()[assessment1 - 1];
            BigDecimal bigDecimal = refundPercentage = assessment == null ? BigDecimal.ZERO : assessment.getRefundPercentage();
            if (lastRefundPercentage != null && lastRefundPercentage.equals(refundPercentage)) continue;
            PartDsek part = new PartDsek(healthFundTP.getValidFrom(), DateMapper.toYYYYMMDDString((Date)healthFundTP.getTimestamp()) + "000000000", refundPercentage.intValue());
            parts.add(part);
            lastRefundPercentage = refundPercentage;
        }
        int countParts = parts.size();
        if (countParts == 0) {
            return null;
        }
        dsek.setAnsatz(countParts);
        dsek.setPartDseks(parts.toArray(new PartDsek[countParts]));
        return dsek;
    }

    /*
     * Unable to fully structure code
     */
    private Collection<EubpDsbn> getDSBNs() throws BusinessDomainException, IOException {
        dsbnMap = new HashMap<String, EubpDsbn>();
        firstFilter = new ReportFirstFilterStruct(this.mEubpMandant.getPCompanyOfMandant().getObjectid(), "", "", "", "", "", "", "", "", "", "", "", "");
        periods = this.mMandanten.getDSBNPeriods();
        this.mProgressbar.initSubStep("Beitragsnachweise", periods.getCountMonths());
        for (Period period : periods.getMonths()) {
            validDate = period.from;
            insuranceDsbns = InsuranceDsbnPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.mEubpMandant.getPCompanyOfMandant().getObjectid()), Restrictions.eq((String)"bbnrabs", (String)this.mEubpMandant.getSTDCompanyNumber(validDate)), Restrictions.le((String)"zrbeg", (String)DateMapper.toString((Date)validDate)), Restrictions.ge((String)"zrend", (String)DateMapper.toString((Date)validDate))}));
            if (insuranceDsbns.length > 0) {
                for (InsuranceDsbn insuranceDsbn : insuranceDsbns) {
                    bbnrkk = insuranceDsbn.getBbnrkk();
                    dsbn = (EubpDsbn)dsbnMap.get(bbnrkk);
                    if (dsbn == null) {
                        dsbn = this.createDSBN(bbnrkk);
                        dsbnMap.put(bbnrkk, dsbn);
                    }
                    dsbn.addPart(new PartDsbn(insuranceDsbn, bbnrkk));
                }
            } else {
                try {
                    block16: {
                        errorList = new ArrayList<String>();
                        EubpCreator.LOGGER.debug("Erzeugung StatementOfContributionReportDataSource");
                        dataSource = null;
                        try {
                            dataSource = new StatementOfContributionReportDataSource((AllCallback)this.mCallback, (ISpecialAccessPersistencyContext)this.mSpecialAccess, firstFilter, null, null, new ReportSortStruct[0], validDate, validDate, false, true, false, StatementOfContributionTypeEnum.SOCT_UebermitteltesBeitragssoll, errorList, null, false, true);
                        }
                        catch (BusinessDomainException e) {
                            if (e.getDomain().equals("PYReport") && e.getErrorNumber() == 103) break block16;
                            throw e;
                        }
                    }
                    if (!errorList.isEmpty()) {
                        throw EubpExceptionMapper.makeErrorInSocException(errorList);
                    }
                    if (dataSource == null) ** GOTO lbl85
                    agBetriebsnummer = new DataSourceFieldAccessor("ag_betriebsnummer");
                    kkBetriebsnummer = new DataSourceFieldAccessor("kk_betriebs_nr");
                    subreportSummBean = new DataSourceFieldAccessor("subreport_summ_bean");
                    subreportHealtFundBean = new DataSourceFieldAccessor("subreport_health_fund_bean");
                    rkHeader = new DataSourceFieldAccessor("rk_header");
                    while (dataSource.next()) {
                        EubpCreator.LOGGER.debug("StatementOfContributionReportDataSource.next()");
                        if (!dataSource.getFieldValue((JRField)agBetriebsnummer).equals(this.mEubpMandant.getSTDCompanyNumber(this.mValidFrom))) continue;
                        bbnrkk = (String)dataSource.getFieldValue((JRField)kkBetriebsnummer);
                        if (!dsbnMap.containsKey(bbnrkk)) {
                            dsbn = this.createDSBN(bbnrkk);
                            dsbnMap.put(bbnrkk, dsbn);
                        }
                        summCollection = (List)dataSource.getFieldValue((JRField)subreportSummBean);
                        healthFundCollection = (List)dataSource.getFieldValue((JRField)subreportHealtFundBean);
                        socSummBean = (StatementOfContributionSummBean)summCollection.get(0);
                        if (socSummBean == null) continue;
                        part = new PartDsbn();
                        part.fillFromSummBean(socSummBean, bbnrkk);
                        part.setKennzrk((String)dataSource.getFieldValue((JRField)rkHeader));
                        part.setLfdnr(1);
                        part.setDsid("");
                        part.setVamm("");
                        healthFund0 = (StatementOfContributionHealthFundBean)healthFundCollection.get(0);
                        part.setBeitrsa(BigDecimalMapper.toBigDecimal((BigDecimal)healthFund0.getKv_1000_percentage()).add(BigDecimalMapper.toBigDecimal((BigDecimal)healthFund0.getKv_additional_dues())));
                        part.setBeitrsh(BigDecimalMapper.toBigDecimal((BigDecimal)healthFund0.getKv_3000_percentage()).add(BigDecimalMapper.toBigDecimal((BigDecimal)healthFund0.getKv_additional_dues())));
                        part.setZrbeg(DateMapper.toYYYYMMDDString((Date)validDate));
                        end = DateHelper.getLastDayOfMonth((Date)validDate);
                        part.setZrend(DateMapper.toYYYYMMDDString((Date)end));
                        summeBeitragDiff = BigDecimalMapper.toBigDecimal((String)socSummBean.getF_summe_beitrag_diff(), (char)',', (char)'.');
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)summeBeitragDiff)) {
                            dbsc = new EubpDbsc();
                            dbsc.fillFromSumBean(socSummBean);
                            part.setDbsc(dbsc);
                            dbrb = new EubpDbrb();
                            dbrb.fillFromSumBean(socSummBean);
                            part.setDbrb(dbrb);
                        }
                        ((EubpDsbn)dsbnMap.get(bbnrkk)).addPart(part);
                    }
                }
                catch (PutDataException | JRException e) {
                    throw ExceptionMapper.makeApplicationException((Throwable)e);
                }
                catch (BusinessDomainException e) {
                    if (e.getDomain().equals("PYBeitragsabrechnung") && e.getErrorNumber() == 1006) {
                        for (EubpDsbn dsbn : dsbnMap.values()) {
                            emptyPart = new PartDsbn();
                            emptyPart.fillEmpty(validDate);
                            emptyPart.setKennzrk(this.mEubpAccount.getPCompany().getCompanySettings(this.mEffectiveDate, validDate).getSettings().getLawArea().substring(0, 1));
                            dsbn.addPart(emptyPart);
                        }
                    }
                    throw e;
                }
            }
lbl85:
            // 4 sources

            this.mProgressbar.nextProcessed();
        }
        return dsbnMap.values();
    }

    private EubpDsbn createDSBN(String bbnr) {
        EubpDsbn dsbn = this.mEubpAccount.createEubpDsbn();
        dsbn.setVersionsnr(this.mEubpVersion.getVersionDSBN());
        dsbn.setBasicRecord(this.mBasicRecord);
        dsbn.setMandant(this.mBetriebsnummer);
        dsbn.setBbnr(bbnr);
        return dsbn;
    }

    private EubpDsan createDSAN(EmployeeWithPeriods employeeWithPeriods) throws BusinessDomainException {
        Employee employee = employeeWithPeriods.getEmployee();
        Periods periods = employeeWithPeriods.getPeriods();
        if (periods.isEmpty()) {
            LOGGER.warn("Periods f\u00fcr Mitarbeiter ist leer. " + employeeWithPeriods);
            return null;
        }
        EubpDsan dsan = this.mEubpAccount.createEubpDsan();
        dsan.setVersionsnr(this.mEubpVersion.getVersionDSAN());
        EubpEmployee eubpEmployee = new EubpEmployee(this.mEubpAccount, employee, periods);
        eubpEmployee.fillDsan(dsan);
        if (dsan.getPartDsans().length == 0) {
            dsan.destroy();
            LOGGER.warn("DSAN f\u00fcr Mitarbeiter wurde nicht erzeugt. " + employeeWithPeriods);
            return null;
        }
        dsan.setBasicRecord(this.mBasicRecord);
        dsan.setMandant(this.mBetriebsnummer);
        this.mEubpAccount.addDsan(dsan);
        return dsan;
    }

    private EubpDsla createDSLA(EmployeeWithPeriods employeeWithPeriods) throws BusinessDomainException {
        Date endDate = this.mMandanten.getLimitedTotalPeriod((Date)this.mValidFrom, (Date)this.mValidUntil).until;
        DslaCreator dslaCreator = new DslaCreator(this, employeeWithPeriods, endDate);
        EubpDsla dsla = dslaCreator.create();
        return dsla;
    }

    private String getNCSZ() {
        return EubpHelper.getNCSZ((BasicRecord)this.mBasicRecord, (int)this.mFileNumber, (int)this.mCount);
    }

    private AssignmentPCompanyHealthFundTP[] queryHealthFundTPs(EubpMandant mandant) {
        switch (mandant.getType()) {
            case PCompany: {
                return AssignmentPCompanyHealthFundTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)mandant.getPCompany().getObjectid()), Restrictions.le((String)"validFrom", (String)DateMapper.toString((Date)this.mValidUntil)), Restrictions.ge((String)"validUntil", (String)DateMapper.toString((Date)this.mValidFrom))}));
            }
            case Plant: {
                return AssignmentPCompanyHealthFundTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidplant", (String)mandant.getPlant().getObjectid()), Restrictions.le((String)"validFrom", (String)DateMapper.toString((Date)this.mValidUntil)), Restrictions.ge((String)"validUntil", (String)DateMapper.toString((Date)this.mValidFrom))}));
            }
            case PlantPlace: {
                return this.queryHealthFundTPs(new EubpMandant(mandant.getPlantPlace().getPlant()));
            }
        }
        throw new IllegalStateException("Der Mandant hat keinen bekannten Typen " + mandant.getType());
    }
}

