/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.elstamdatatransferprotocol;

import com.varial.base.UtilitiesManager;
import com.varial.base.callback.TransactionMode;
import com.varial.base.corba.CorbaExceptionTranslatorFactory;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.ApplicationServiceAdapter;
import com.varial.base.service.TransactionalServiceAdapter;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.printservice.PrintProgress;
import com.varial.framework.domain.reports.JasperReportCompiler;
import com.varial.framework.domain.reports.JasperReportManager;
import com.varial.framework.domain.setting.Setting;
import com.varial.framework.domain.setting.SettingPersistencyManager;
import com.varial.personnel.domain.calculation.EmployeeCalculate;
import com.varial.personnel.domain.companyplant.GeneralTaxOffice;
import com.varial.personnel.domain.elo2.ReasonOfDeliveryEnum;
import com.varial.personnel.domain.elo2.transfer.Elo2Receive;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.taxoffice.CompanyTaxOffice;
import com.varial.personnel.domain.reports.ReportFormatFactory;
import com.varial.personnel.domain.reports.elstamdatatransferprotocol.Elo2ReceiveProtocolReportDataSource;
import com.varial.personnel.domain.reports.mapper.Elo2ExceptionMapper;
import com.varial.personnel.domain.reports.reportdatatransfer.mapper.ReportDataTransferExceptionMapper;
import com.varial.personnel.framework.D;
import com.varial.personnel.framework.ExclusiveExecutionLockHelper;
import com.varial.personnel.framework.ICustomerControls;
import com.varial.personnel.framework.IValuationManager;
import com.varial.personnel.framework.PFileHelper;
import com.varial.personnel.servantimpl.employee.SpecialAccessPrintCommand;
import com.varial.serverbase.applicationexception.DomainExceptionStruct;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.AllCallbackOperations;
import com.varial.serverbase.query.DatabaseExceptionStruct;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.transaction.TransactionStatus;

public class Elo2ReceiveProtocolReport
extends SpecialAccessPrintCommand<ReportFileStructCallback> {
    private static final String PROFILE_PREFIX = "ELO2RPR";
    private static final String PERFIDIA_RECEIVE_PATH = "/ofd/recv/";
    private static final String USER_PERFIDIA_PATH = "Perfidia";
    private static final String SECTION = "PW";
    private static final String PWPATHFILE = "Perfidia";
    private static final String PATHKEY = "PATH";
    private final String mOidPCompany;
    private static final String REPORT_FOLDER = "com/varial/personnel/jasperreport/elo2datatransferprotocol/";
    private String mDataTransferPath;
    private Map<ReasonOfDeliveryEnum, List<File>> filesPerReason;

    public Elo2ReceiveProtocolReport(AuthorizationToken token, ReportFileStructCallback callback, boolean protocolAll, String oidPCompany) {
        super(token, (AllCallbackOperations)callback, TransactionMode.NONE, true);
        this.mOidPCompany = oidPCompany;
    }

    private String getDataTransferPerfidiaPWPathValue() throws BusinessDomainException {
        Setting[] settings = SettingPersistencyManager.getSettings((String)"Perfidia", (String)"Perfidia");
        for (int i = 0; i < settings.length; ++i) {
            Setting s = settings[i];
            if (!StringMapper.equal((String)s.getKey(), (String)PATHKEY) || !StringMapper.equal((String)s.getSection(), (String)SECTION)) continue;
            return s.getValue();
        }
        throw ReportDataTransferExceptionMapper.makeNoPerfidiaPathExistantDomainException();
    }

    public void readElo2Files() throws BusinessDomainException {
        PCompany[] pCompanys = PCompany.getPCompany(null, null);
        if (this.mOidPCompany != null) {
            pCompanys = new PCompany[]{PCompanyPersistencyManager.getPCompany((String)this.mOidPCompany)};
        }
        HashSet<String> deviantPerfidiaPaths = new HashSet<String>();
        CompanyTaxOffice cto = null;
        GeneralTaxOffice gto = null;
        Date today = new Date();
        for (PCompany pComp : pCompanys) {
            try {
                cto = pComp.getActiveCompanyTaxOffice();
                if (cto == null || (gto = cto.getGeneralTaxOffice()) == null || gto.getDateStartELSTAM() == null || !DateHelper.after((Date)today, (Date)gto.getDateStartELSTAM()) || StringMapper.isNullString((String)cto.getPerfidiaPath())) continue;
                deviantPerfidiaPaths.add(cto.getPerfidiaPath());
            }
            catch (IncorrectResultSizeDataAccessException incorrectResultSizeDataAccessException) {
                // empty catch block
            }
        }
        if (deviantPerfidiaPaths.isEmpty() || this.isValidElo2Path(this.mDataTransferPath) && !deviantPerfidiaPaths.contains(this.mDataTransferPath)) {
            deviantPerfidiaPaths.add(this.mDataTransferPath);
        }
        this.filesPerReason = new HashMap<ReasonOfDeliveryEnum, List<File>>();
        ArrayList<File> allFilesToRead = new ArrayList<File>();
        File dir = null;
        File[] filesToRead = null;
        for (String string : deviantPerfidiaPaths) {
            dir = new File(string + PERFIDIA_RECEIVE_PATH);
            PFileHelper.checkFolder(dir, "Das Unterverzeichnis im Perfidia Datenordner");
            filesToRead = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String input = name.toUpperCase();
                    return (input.startsWith("EELAN0_") || input.startsWith("EELAB0_") || input.startsWith("EELUM0_") || input.startsWith("EELAF0_")) && input.endsWith(".DAT");
                }
            });
            if (filesToRead == null || filesToRead.length <= 0) continue;
            allFilesToRead.addAll(Arrays.asList(filesToRead));
        }
        if (allFilesToRead.isEmpty()) {
            throw Elo2ExceptionMapper.makeNoAnswerFileToReadDomainException();
        }
        for (File file : allFilesToRead) {
            String fileName = file.getName().toUpperCase();
            if (fileName.startsWith("EELAN0_")) {
                this.getFileListPerReason(ReasonOfDeliveryEnum.ANMELDUNG).add(file);
                continue;
            }
            if (fileName.startsWith("EELAB0_")) {
                this.getFileListPerReason(ReasonOfDeliveryEnum.ABMELDUNG).add(file);
                continue;
            }
            if (fileName.startsWith("EELUM0_")) {
                this.getFileListPerReason(ReasonOfDeliveryEnum.UMMELDUNG).add(file);
                continue;
            }
            if (!fileName.startsWith("EELAF0_")) continue;
            this.getFileListPerReason(ReasonOfDeliveryEnum.ELSTAM).add(file);
        }
        for (List list : this.filesPerReason.values()) {
            Collections.sort(list);
        }
    }

    private boolean isValidElo2Path(String dataTransferPath) {
        if (StringMapper.isNullString((String)dataTransferPath)) {
            return false;
        }
        try {
            PFileHelper.checkFolder(new File(dataTransferPath + PERFIDIA_RECEIVE_PATH), "");
        }
        catch (BusinessDomainException e) {
            return false;
        }
        return true;
    }

    private List<File> getFileListPerReason(ReasonOfDeliveryEnum rod) {
        List<File> fileList = this.filesPerReason.get(rod);
        if (fileList == null) {
            fileList = new ArrayList<File>();
            this.filesPerReason.put(rod, fileList);
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        TransactionalServiceAdapter txAdapter = new TransactionalServiceAdapter();
        ApplicationServiceAdapter applAdapter = new ApplicationServiceAdapter();
        TransactionStatus txStatus = null;
        try {
            applAdapter.beginUpdateService();
            D.enter();
            ExclusiveExecutionLockHelper.checkExclusiveExecutionLock((Object)((Object)this), (String)"receiveElo2DataTransfer");
            PrintProgress progress = new PrintProgress((ReportFileStructCallback)this.getCallback());
            progress.updateProgress(1, 2, "gestartet", 1, 2);
            this.mDataTransferPath = this.getDataTransferPerfidiaPWPathValue();
            this.readElo2Files();
            List<File> fileList = null;
            ReasonOfDeliveryEnum reasonOfDelivery = null;
            Elo2Receive receiver = null;
            HashMap<String, Integer> persNrList = new HashMap<String, Integer>();
            ArrayList<String> urlList = new ArrayList<String>();
            ICustomerControls control = (ICustomerControls)UtilitiesManager.getBean((String)"customerControls", ICustomerControls.class);
            ArrayList<EmployeeCalculate> emplCalculates = new ArrayList<EmployeeCalculate>();
            for (int i = 0; i <= 3; ++i) {
                reasonOfDelivery = ReasonOfDeliveryEnum.from_int((int)i);
                fileList = this.filesPerReason.get(reasonOfDelivery);
                if (fileList == null) continue;
                for (File file : fileList) {
                    txStatus = txAdapter.getUpdateTransaction();
                    receiver = new Elo2Receive(this.getToken(), file, persNrList, reasonOfDelivery);
                    receiver.readFile();
                    emplCalculates.addAll(receiver.createValuationCalculates());
                    applAdapter.getContext().flush();
                    Elo2ReceiveProtocolReportDataSource dataSource = new Elo2ReceiveProtocolReportDataSource(receiver);
                    File report = JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)this.compileReport("Elo2ReceiveProtocolReport"), this.createParameters(dataSource), (JRDataSource)dataSource, (String)PROFILE_PREFIX);
                    receiver.executeFileRenaming();
                    receiver.writePerfidiaFiles();
                    String url = JasperReportManager.getUrl((File)report);
                    if (control.mergeToOnePdf()) {
                        urlList.add(url);
                    } else {
                        String[] reports = new String[]{url};
                        ((ReportFileStructCallback)this.getCallback()).putData(reports);
                    }
                    txAdapter.commit(txStatus);
                }
            }
            if (control.mergeToOnePdf() && !urlList.isEmpty()) {
                String[] reports = new String[]{JasperReportManager.mergeToOnePDF(urlList, (String)PROFILE_PREFIX)};
                ((ReportFileStructCallback)this.getCallback()).putData(reports);
            }
            if (emplCalculates != null && !emplCalculates.isEmpty()) {
                ((IValuationManager)UtilitiesManager.getBean((String)"valuationManager", IValuationManager.class)).valuateSynchronous(this.getToken(), emplCalculates.toArray(new EmployeeCalculate[emplCalculates.size()]));
            }
        }
        catch (BusinessDomainException e) {
            if (txStatus != null) {
                txAdapter.rollbackOnException(txStatus, (Throwable)e);
            }
            DomainExceptionStruct struct = CorbaExceptionTranslatorFactory.getTranslator().translateIntoDomainExceptionStruct(e);
            struct.value = struct.value + " " + this;
            ((ReportFileStructCallback)this.getCallback()).setDomainException(struct);
        }
        catch (RuntimeException e) {
            if (txStatus != null) {
                txAdapter.rollbackOnException(txStatus, (Throwable)e);
            }
            DatabaseExceptionStruct struct = CorbaExceptionTranslatorFactory.getTranslator().translateIntoDatabaseExceptionStruct((Throwable)e);
            if (e.getMessage() == null) {
                struct.param1 = e.getClass().getSimpleName();
            }
            struct.param1 = struct.param1 + ", thrower: " + this;
            ((ReportFileStructCallback)this.getCallback()).setException(struct);
        }
        catch (Exception e) {
            if (txStatus != null) {
                txAdapter.rollbackOnException(txStatus, (Throwable)e);
            }
            DatabaseExceptionStruct struct = CorbaExceptionTranslatorFactory.getTranslator().translateIntoDatabaseExceptionStruct((Throwable)e);
            if (e.getMessage() == null) {
                struct.param1 = e.getClass().getSimpleName();
            }
            struct.param1 = struct.param1 + ", thrower: " + this;
            ((ReportFileStructCallback)this.getCallback()).setException(struct);
        }
        catch (Error e) {
            if (txStatus != null) {
                txAdapter.rollbackOnException(txStatus, (Throwable)e);
            }
            DatabaseExceptionStruct struct = CorbaExceptionTranslatorFactory.getTranslator().translateIntoDatabaseExceptionStruct((Throwable)e);
            if (e.getMessage() == null) {
                struct.param1 = e.getClass().getSimpleName();
            }
            struct.param1 = struct.param1 + ", thrower: " + this;
            ((ReportFileStructCallback)this.getCallback()).setException(struct);
        }
        finally {
            ExclusiveExecutionLockHelper.releaseExclusiveExecutionLock((Object)((Object)this), (String)"receiveElo2DataTransfer");
            D.leave();
            D.statistics();
            applAdapter.endService();
        }
    }

    private JasperReport compileReport(String reportName) {
        return JasperReportCompiler.compileReport((String)(REPORT_FOLDER + reportName + ".jrxml"));
    }

    private Map<String, Object> createParameters(Elo2ReceiveProtocolReportDataSource dataSource) {
        Map<String, Object> parameters = dataSource.getParameters();
        parameters.put("subreport_LastPage", this.compileReport("Elo2ReceiveProtocolLastReport"));
        parameters.put("subreport_AnKvPv", this.compileReport("Elo2ReceiveAnKvPvSubprotocolReport"));
        parameters.put("REPORT_FORMAT_FACTORY", new ReportFormatFactory());
        return parameters;
    }
}

