/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.deuvstatementofcontribution;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.companyplant.StatusByInsolvencyEnum;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuv.deuvsending.DEUVSending;
import com.varial.personnel.domain.deuv.deuvsending.DEUVSendingPersistencyManager;
import com.varial.personnel.domain.deuv.deuvsending.TypeOfSendingEnum;
import com.varial.personnel.domain.deuv.mapper.TypeOfSendingEnumMapper;
import com.varial.personnel.domain.deuvmessaging.DeuvRecipientMap;
import com.varial.personnel.domain.employee.paymentofcontributions.insurancedsbn.InsuranceDsbn;
import com.varial.personnel.domain.employee.paymentofcontributions.insurancedues.InsuranceDues;
import com.varial.personnel.domain.employee.paymentofcontributions.percentofassessment.PercentOfAssessment;
import com.varial.personnel.domain.employee.paymentofcontributions.percentofglobalsocialinsurance.PercentOfGlobalSocialInsurance;
import com.varial.personnel.domain.employee.paymentofcontributions.percentofhealthfund.PercentOfHealthFund;
import com.varial.personnel.domain.employee.paymentofcontributions.percentoftax.PercentOfTax;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipientTP;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurance;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurancePersistencyManager;
import com.varial.personnel.domain.global.socialinsurance.SocialInsuranceTP;
import com.varial.personnel.domain.reports.EmployeeForReport;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.deuvstatementofcontribution.DEUVSOCDataTransferBean;
import com.varial.personnel.domain.reports.reportdatatransfer.DEUVDataTransferHelper;
import com.varial.personnel.domain.reports.statementofcontribution.SOCDataSourceHelper;
import com.varial.personnel.domain.reports.statementofcontribution.StatementOfContributionHealthFundBean;
import com.varial.personnel.domain.reports.statementofcontribution.StatementOfContributionTypeBDBean;
import com.varial.personnel.domain.reports.statementofcontribution.StatementOfContributionTypeBean;
import com.varial.personnel.domain.reports.statementofcontribution.StatementOfContributionTypeEnum;
import com.varial.personnel.domain.reports.statementofcontribution.mapper.SOCRExceptionMapper;
import com.varial.personnel.domain.reports.statementofcontributionpaid.StatementOfContributionPaidReportDataSource;
import com.varial.personnel.framework.ISpecialAccessPersistencyContext;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.persistency.employee.insurancedues.IInsuranceduesDao;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.AllCallback;
import com.varial.serverbase.query.PutDataException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;

public class DEUVStatementOfContributionPaidDataSource
extends StatementOfContributionPaidReportDataSource {
    private static IInsuranceduesDao daoInsurancedues = (IInsuranceduesDao)UtilitiesManager.getApplicationContext().getBean("insuranceduesDao");
    private BigDecimal f_summe_erstattung = BigDecimal.ZERO;
    private BigDecimal f_summe_zahlender_beitrag = BigDecimal.ZERO;
    private BigDecimal mKVBsGfBPauschal = BigDecimal.ZERO;
    private boolean mNewKrKFirstPurchase = true;
    private final List<DEUVSOCDataTransferBean> mSOCPDataTransferBeanLi = new LinkedList<DEUVSOCDataTransferBean>();
    private List<DEUVSOCDataTransferBean> mDEUVSOCDataTransferBeanLi = new LinkedList<DEUVSOCDataTransferBean>();
    private final List<InsuranceDsbn> mInsuranceDsbnLi = new LinkedList<InsuranceDsbn>();
    private final String mDEUVSenderStdCompanyNumber;
    private final String mDEUVSenderDescription;
    private final String mDEUVSenderOid;
    private DEUVRecipientTP mDEUVRecipientTP;

    public DEUVStatementOfContributionPaidDataSource(AllCallback callback, ISpecialAccessPersistencyContext sapc, ReportFirstFilterStruct firstFilter, ReportSortStruct[] reportSortStruct, Date forEffectiveDate, Date forValidDate, String dEUVSenderOid, String dEUVSenderStdCompanyNumber, String dEUVSenderDescription, boolean rerun, ProgressBarUpdater progressBar, List<String> errorList) throws BusinessDomainException, PutDataException {
        super(callback, sapc, firstFilter, null, null, reportSortStruct, forEffectiveDate, forValidDate, "", false, true, true, StatementOfContributionTypeEnum.SOCT_Beitragsuebermittlung, false, rerun, errorList, progressBar);
        this.mDEUVSenderOid = dEUVSenderOid;
        this.mDEUVSenderStdCompanyNumber = dEUVSenderStdCompanyNumber;
        this.mDEUVSenderDescription = dEUVSenderDescription;
        this.mOidPCompany = firstFilter.oidPCompany;
    }

    protected StatementOfContributionTypeBean getReportTypeBeanFromReportTypeBDBean() throws BusinessDomainException {
        StatementOfContributionTypeBean typeBean = super.getReportTypeBeanFromReportTypeBDBean();
        if (this.mSOCTypeBDBean.getTypeOfBeitragEnum().value() != 1 && DateHelper.between((Date)this.mSOCTypeBDBean.getSortDateBSBI(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate), (Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))) {
            this.getInsuranceDuesFromEmployeeBean();
        }
        return typeBean;
    }

    private void getInsuranceDuesFromEmployeeBean() throws BusinessDomainException {
        InsuranceDues insuranceDues = new InsuranceDues();
        insuranceDues.isNew();
        insuranceDues.setTypeOfListEnum(this.mSOCTypeBDBean.getTypeOfListEnum());
        insuranceDues.setEffectiveFrom(DateHelper.getFirstDayOfMonth((Date)this.mSOCTypeBDBean.getEffectiveDate()));
        insuranceDues.setEffectiveUntil(DateHelper.getLastDayOfMonth((Date)this.mSOCTypeBDBean.getEffectiveDate()));
        insuranceDues.setValidFrom(DateHelper.getFirstDayOfMonth((Date)this.mSOCTypeBDBean.getSortDateBSBI()));
        insuranceDues.setValidUntil(DateHelper.getLastDayOfMonth((Date)this.mSOCTypeBDBean.getSortDateBSBI()));
        insuranceDues.setPCompany(this.mPCompany);
        insuranceDues.setCompanyDescription(this.Temp_FIELD_firma_bezeichnung);
        if (!StringMapper.isNullString((String)this.mSOCTypeBDBean.getOidPlant())) {
            insuranceDues.setPlant(this.mReportValues.getPlant(this.mSOCTypeBDBean.getOidPlant()));
        }
        insuranceDues.setPlantDescription(this.Temp_FIELD_betriebsstaette_bezeichnung);
        insuranceDues.setVarialShortString(this.Temp_FIELD_AG_bezeichnung);
        insuranceDues.setStreet(this.Temp_FIELD_AG_str_nr);
        insuranceDues.setCity(this.Temp_FIELD_AG_plz_ort);
        insuranceDues.setStdCompanyNumber(this.mSOCTypeBDBean.getPlantStdCompanyNumber());
        insuranceDues.setDuesAccountNumber(this.mSOCTypeBDBean.getPlantStdCompanyNumber());
        insuranceDues.setHealthFund(this.mReportValues.getHealthFund(this.mSOCTypeBDBean.getRefereToOidHealthFund()));
        insuranceDues.setHfStdCompanyNo(this.Temp_FIELD_kk_betriebs_nr);
        insuranceDues.setHfDescription(this.mSOCTypeBDBean.getRefereToHealthFundDescription());
        insuranceDues.setHfStreet(this.Temp_FIELD_kk_str_nr);
        insuranceDues.setHfCity(this.Temp_FIELD_kk_plz_ort);
        if (StringMapper.isNullString((String)this.mSOCTypeBDBean.getPlantLawArea())) {
            insuranceDues.setLawArea("");
        } else {
            insuranceDues.setLawArea(StringMapper.equal((String)"West", (String)this.mSOCTypeBDBean.getPlantLawArea()) ? "W" : "O");
        }
        insuranceDues.setEmployee(this.mReportValues.getEmployee(this.mSOCTypeBDBean.getOidEmployee()));
        insuranceDues.setFirstname(this.mSOCTypeBDBean.getFirstName());
        insuranceDues.setSurname(this.mSOCTypeBDBean.getSurname());
        insuranceDues.setPersonnelnumber(this.mSOCTypeBDBean.getPersonnelNumberInt());
        insuranceDues.setInsuranceNo(StringMapper.isNullString((String)this.mSOCTypeBDBean.getVersicherungsnummer()) ? "" : this.mSOCTypeBDBean.getVersicherungsnummer());
        insuranceDues.setDuesGroupHI(StringMapper.isNullString((String)this.mSOCTypeBDBean.getBgs_kv()) ? 0 : Integer.parseInt(this.mSOCTypeBDBean.getBgs_kv()));
        insuranceDues.setDuesGroupPI(StringMapper.isNullString((String)this.mSOCTypeBDBean.getBgs_rv()) ? 0 : Integer.parseInt(this.mSOCTypeBDBean.getBgs_rv()));
        insuranceDues.setDuesGroupUI(StringMapper.isNullString((String)this.mSOCTypeBDBean.getBgs_av()) ? 0 : Integer.parseInt(this.mSOCTypeBDBean.getBgs_av()));
        insuranceDues.setDuesGroupNI(StringMapper.isNullString((String)this.mSOCTypeBDBean.getBgs_pv()) ? 0 : Integer.parseInt(this.mSOCTypeBDBean.getBgs_pv()));
        insuranceDues.setNumberOfHIDay(StringMapper.isNullString((String)this.mSOCTypeBDBean.getBgs_kv_tage()) ? 0 : Integer.parseInt(this.mSOCTypeBDBean.getBgs_kv_tage()));
        insuranceDues.setNumberOfPIDay(StringMapper.isNullString((String)this.mSOCTypeBDBean.getBgs_rv_tage()) ? 0 : Integer.parseInt(this.mSOCTypeBDBean.getBgs_rv_tage()));
        insuranceDues.setNumberOfUIDay(StringMapper.isNullString((String)this.mSOCTypeBDBean.getBgs_av_tage()) ? 0 : Integer.parseInt(this.mSOCTypeBDBean.getBgs_av_tage()));
        insuranceDues.setNumberOfNIDay(StringMapper.isNullString((String)this.mSOCTypeBDBean.getBgs_pv_tage()) ? 0 : Integer.parseInt(this.mSOCTypeBDBean.getBgs_pv_tage()));
        insuranceDues.setPersonGroup(StringMapper.isNullString((String)this.mSOCTypeBDBean.getPgs()) ? 0 : Integer.parseInt(this.mSOCTypeBDBean.getPgs()));
        insuranceDues.setPayment(this.mSOCTypeBDBean.getArbeitsentgelt());
        insuranceDues.setTypeOfPaymentEnum(this.mSOCTypeBDBean.getTypeOfPaymentEnum());
        insuranceDues.setHiPayment(this.mSOCTypeBDBean.getKv_entgelt());
        insuranceDues.setPiPayment(this.mSOCTypeBDBean.getRv_entgelt());
        insuranceDues.setEeHi1000(this.mSOCTypeBDBean.getAna_1000());
        insuranceDues.setEeHi2000(this.mSOCTypeBDBean.getAna_2000());
        insuranceDues.setEeHi3000(this.mSOCTypeBDBean.getAna_3000());
        insuranceDues.setEePi0100(this.mSOCTypeBDBean.getAna_0100());
        insuranceDues.setEePi0200(this.mSOCTypeBDBean.getAna_0200());
        insuranceDues.setEeUi0010(this.mSOCTypeBDBean.getAna_0010());
        insuranceDues.setEeUi0020(this.mSOCTypeBDBean.getAna_0020());
        insuranceDues.setEeNi0001(this.mSOCTypeBDBean.getAna_0001());
        insuranceDues.setEeNi0002(this.mSOCTypeBDBean.getAna_0002());
        if (this.mSOCTypeBDBean.getTypeOfListEnum().value() == 0 && this.mSOCTypeBDBean.getTypeOfPaymentEnum().value() == 1) {
            insuranceDues.setEeLumpSumIncomeTax(this.mSOCTypeBDBean.getSfnZuschlaege());
        } else {
            insuranceDues.setEeLumpSumIncomeTax(this.mSOCTypeBDBean.getAna_st());
        }
        insuranceDues.setUiPayment(this.mSOCTypeBDBean.getAv_entgelt());
        insuranceDues.setNiPayment(this.mSOCTypeBDBean.getPv_entgelt());
        insuranceDues.setErHi1000(this.mSOCTypeBDBean.getAga_1000());
        insuranceDues.setErHi2000(this.mSOCTypeBDBean.getAga_2000());
        insuranceDues.setErHi3000(this.mSOCTypeBDBean.getAga_3000());
        insuranceDues.setErPi0100(this.mSOCTypeBDBean.getAga_0100());
        insuranceDues.setErPi0200(this.mSOCTypeBDBean.getAga_0200());
        insuranceDues.setErUi0010(this.mSOCTypeBDBean.getAga_0010());
        insuranceDues.setErUi0020(this.mSOCTypeBDBean.getAga_0020());
        insuranceDues.setErNi0001(this.mSOCTypeBDBean.getAga_0001());
        insuranceDues.setErNi0002(this.mSOCTypeBDBean.getAga_0002());
        insuranceDues.setErLumpSumIncomeTax(this.mSOCTypeBDBean.getAga_st());
        insuranceDues.setInsolvencyAssessmentDues(this.mSOCTypeBDBean.getAga_0050());
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mSOCTypeBDBean.getAga_0050())) {
            insuranceDues.setInsolvencyAssessmentPayment(BigDecimal.ZERO.setScale(2));
        } else {
            insuranceDues.setInsolvencyAssessmentPayment(this.mSOCTypeBDBean.getUmlageentgelt());
        }
        insuranceDues.setAssessmentPayment(this.mSOCTypeBDBean.getUmlageentgelt());
        insuranceDues.setPiDifference(this.mSOCTypeBDBean.getRv_unterschied());
        insuranceDues.setErHi5000(this.mSOCTypeBDBean.getAga_5000());
        insuranceDues.setErHi6000(this.mSOCTypeBDBean.getAga_6000());
        insuranceDues.setErPi0300(this.mSOCTypeBDBean.getAga_0300());
        insuranceDues.setErPi0400(this.mSOCTypeBDBean.getAga_0400());
        insuranceDues.setErPi0500(this.mSOCTypeBDBean.getAga_0500());
        insuranceDues.setErPi0600(this.mSOCTypeBDBean.getAga_0600());
        insuranceDues.setU1(this.mSOCTypeBDBean.getAga_u1());
        insuranceDues.setU2(this.mSOCTypeBDBean.getAga_u2());
        insuranceDues.setVhi(this.mSOCTypeBDBean.getAga_freiwillig_kv());
        insuranceDues.setVni(this.mSOCTypeBDBean.getAga_freiwillig_pv());
        insuranceDues.setDateOfList(this.mSOCTypeBDBean.getSortDate());
        insuranceDues.setNiChildEducation(StringMapper.equal((String)this.mSOCTypeBDBean.getParent(), (String)"E"));
        insuranceDues.setAdditionalInteger(this.mSOCTypeBDBean.getTypeOfStatusEnum().value());
        insuranceDues.setPlantIsEmployer(this.mSOCTypeBDBean.getReferToPLant());
        insuranceDues.setAddititionalDuesHI(this.mSOCTypeBDBean.getKv_ana_zusatzbeitrag());
        insuranceDues.setAdditionalDuesHIER(this.mSOCTypeBDBean.getKv_aga_zusatzbeitrag());
        insuranceDues.setAddititionalDuesVHI(this.mSOCTypeBDBean.getKv_fw_zusatzbeitrag());
        if (this.mSOCTypeBDBean.getStatementOfContributionSummBDBean() != null) {
            String value = StringMapper.replaceSubString((String)this.mSOCTypeBDBean.getStatementOfContributionSummBDBean().getF_summe_u1_erstattung().toString(), (String)".", (String)"");
            insuranceDues.setAdditionalString(value);
            insuranceDues.setAdditionalDecimal(this.mSOCTypeBDBean.getStatementOfContributionSummBDBean().getF_summe_u2_erstattung());
        } else {
            insuranceDues.setAdditionalString("000");
            insuranceDues.setAdditionalDecimal(BigDecimal.ZERO);
        }
        if (this.mSOCTypeBDBean.getTypeOfListEnum().value() == 11) {
            insuranceDues.setKUGPayment(this.mSOCTypeBDBean.getSfnZuschlaege());
        }
        if (this.mHealthFundCollection != null && !this.mHealthFundCollection.isEmpty()) {
            for (StatementOfContributionHealthFundBean bean : this.mHealthFundCollection) {
                PercentOfHealthFund percentOfHealthFund = new PercentOfHealthFund();
                percentOfHealthFund.setInsuranceDues(insuranceDues);
                percentOfHealthFund.setValidFrom(bean.getDate_from_1000_u());
                percentOfHealthFund.setPCGeneral(bean.getKv_1000_percentage());
                percentOfHealthFund.setPCIncreased(bean.getKv_2000_percentage());
                percentOfHealthFund.setPCReduced(bean.getKv_3000_percentage());
                percentOfHealthFund.makeSaveable();
            }
        }
        if (this.mHealthFundAssessmentCollection != null && !this.mHealthFundAssessmentCollection.isEmpty()) {
            for (StatementOfContributionHealthFundBean bean : this.mHealthFundAssessmentCollection) {
                PercentOfAssessment percentOfAssessment1 = new PercentOfAssessment();
                percentOfAssessment1.setInsuranceDues(insuranceDues);
                percentOfAssessment1.setValidFrom(bean.getDate_from_u1_u2());
                percentOfAssessment1.setAssessmentKey("U1");
                percentOfAssessment1.setSubmitPercentage(bean.getU1_factor());
                percentOfAssessment1.setRefundPercentage(bean.getU1_percentage());
                percentOfAssessment1.makeSaveable();
                PercentOfAssessment percentOfAssessment2 = new PercentOfAssessment();
                percentOfAssessment2.setInsuranceDues(insuranceDues);
                percentOfAssessment2.setValidFrom(bean.getDate_from_u1_u2());
                percentOfAssessment2.setAssessmentKey("U2");
                percentOfAssessment2.setSubmitPercentage(bean.getU2_factor());
                percentOfAssessment2.setRefundPercentage(bean.getU2_percentage());
                percentOfAssessment2.makeSaveable();
            }
        }
        if (this.mGlobalSocialInsuranceCollection != null && !this.mGlobalSocialInsuranceCollection.isEmpty()) {
            for (StatementOfContributionHealthFundBean bean : this.mGlobalSocialInsuranceCollection) {
                PercentOfGlobalSocialInsurance percentOfGlobalSocialInsurance = new PercentOfGlobalSocialInsurance();
                percentOfGlobalSocialInsurance.setInsuranceDues(insuranceDues);
                percentOfGlobalSocialInsurance.setValidFrom(bean.getDate_from_5000_6000());
                percentOfGlobalSocialInsurance.setPercentHI5000(bean.getKv5000_percentage());
                percentOfGlobalSocialInsurance.setPercentHI6000(bean.getKv6000_percentage());
                percentOfGlobalSocialInsurance.setPercentPI0500(bean.getRv0500_0600_percentage());
                percentOfGlobalSocialInsurance.setPercentPI(bean.getRv_reduced_percentage());
                percentOfGlobalSocialInsurance.setPercentPIaddOn(bean.getRv_full_percentage());
                percentOfGlobalSocialInsurance.setPercentUI(bean.getAv_percentage());
                percentOfGlobalSocialInsurance.setPercentNI(bean.getPv_percentage());
                percentOfGlobalSocialInsurance.setPercentNIaddOn(bean.getPv_ana_beitragszuschlag());
                percentOfGlobalSocialInsurance.makeSaveable();
            }
        }
        if (this.mTaxCollection != null && !this.mTaxCollection.isEmpty()) {
            for (StatementOfContributionHealthFundBean bean : this.mTaxCollection) {
                PercentOfTax percentOfTax = new PercentOfTax();
                percentOfTax.setInsuranceDues(insuranceDues);
                percentOfTax.setValidFrom(bean.getDate_from_tax());
                percentOfTax.setPercentST(bean.getTax());
                percentOfTax.makeSaveable();
            }
        }
        insuranceDues.makeSaveable();
    }

    protected void resetComponents() {
        super.resetComponents();
        this.mNewKrKFirstPurchase = true;
        this.mDEUVSOCDataTransferBeanLi.clear();
    }

    public List<DEUVSOCDataTransferBean> getSOCPDataTransferBeanLi() {
        return this.mSOCPDataTransferBeanLi;
    }

    public void buildSummCollection() throws BusinessDomainException {
        super.buildSummCollection();
        boolean isGfB = StringMapper.compareTo((String)this.mSOCTypeBDBean.getReferForSortHealthFundDescritionStdCompanyNr(), (String)this.mMinijobZDesBetriebsnummerSpace) == 0;
        this.mDEUVSOCDataTransferBeanLi = new LinkedList<DEUVSOCDataTransferBean>();
        DEUVSOCDataTransferBean dEUVSOCDataTransferBean = new DEUVSOCDataTransferBean();
        dEUVSOCDataTransferBean.setVKennung("VOSZ");
        dEUVSOCDataTransferBean.setVVverfIntMerkmal("BWNAC");
        dEUVSOCDataTransferBean.setVAbsenderNr(this.mDEUVSenderStdCompanyNumber);
        HealthFundTP healthFundTP = this.getHealthFundTP(this.mSOCTypeBDBean.getRefereToOidHealthFund(), this.mForEffectiveDate, this.mForValidDate);
        DEUVSender deuvSender = new DEUVSender(this.mDEUVSenderOid);
        DeuvRecipientMap deuvRecipientMap = new DeuvRecipientMap(deuvSender);
        DEUVRecipient dEUVRecipient = deuvRecipientMap.getDeuvRecipient(healthFundTP.getHealthFund());
        this.mDEUVRecipientTP = dEUVRecipient.getCurrentDEUVRecipientTP();
        int typeOfHealthFundInt = healthFundTP.getTypeOfHealthFundEnum().value();
        dEUVSOCDataTransferBean.setDEUVEmpfaengerForSort(DEUVDataTransferHelper.getNeededDEUVRecipientKey((String)Integer.toString(typeOfHealthFundInt)));
        dEUVSOCDataTransferBean.setVEmpfaengerNr(this.mDEUVRecipientTP.getStdCompanyNumber());
        dEUVSOCDataTransferBean.setDEUVRecipientName(this.mDEUVRecipientTP.getName());
        dEUVSOCDataTransferBean.setVErstDatumDati(DateMapper.toYYYYMMDDString((Date)new Date()));
        dEUVSOCDataTransferBean.setVDateiNr(Integer.toString(this.getFileNumberOfStatementOfContributions() + 1));
        dEUVSOCDataTransferBean.setVAbsender(this.mDEUVSenderDescription);
        dEUVSOCDataTransferBean.setVReserve(" ");
        dEUVSOCDataTransferBean.setVVersionNr("01");
        dEUVSOCDataTransferBean.setVSatzEnde("E");
        dEUVSOCDataTransferBean.setBKennung("BW02");
        dEUVSOCDataTransferBean.setBVerfIntMerkmal("BWNAC");
        dEUVSOCDataTransferBean.setBAbsenderNr(this.mDEUVSenderStdCompanyNumber);
        dEUVSOCDataTransferBean.setBKrKEmpfaengerBetriebsNr(healthFundTP.getStandardCompanyNumber());
        dEUVSOCDataTransferBean.setKrankenkasseBezeichnung(healthFundTP.getShortDescription());
        dEUVSOCDataTransferBean.setBKennzeichen1("0");
        Foundations companyFoundations = this.mPCompanyForSettings.getCompanyFoundations(this.mForEffectiveDate, this.mListEndDate).getFoundations();
        if (companyFoundations.getStatusByInsolvency() == StatusByInsolvencyEnum.SBIE_FUER_SOFORT_FREIGESTELLTE_AN || companyFoundations.getStatusByInsolvency() == StatusByInsolvencyEnum.SBIE_FUER_SPAETER_FREIGESTELLTE_AN) {
            dEUVSOCDataTransferBean.setBKennzeichenInsolvenz("1");
        } else {
            dEUVSOCDataTransferBean.setBKennzeichenInsolvenz("0");
        }
        dEUVSOCDataTransferBean.setBKennzeichen2("0");
        dEUVSOCDataTransferBean.setBKennzeichen3("0");
        dEUVSOCDataTransferBean.setBArbeitgeberBetriebsnummerNr(this.mAG_Betriebsnummer);
        dEUVSOCDataTransferBean.setArbeitgeberVWENr(this.Temp_FIELD_AG_Key);
        dEUVSOCDataTransferBean.setBZeitraumBeginn(DateMapper.toYYYYMMDDString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate)));
        dEUVSOCDataTransferBean.setBZeitraumEnde(DateMapper.toYYYYMMDDString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate)));
        dEUVSOCDataTransferBean.setForValidDate(this.mForValidDate);
        dEUVSOCDataTransferBean.setMonat(DateMapper.toMMYYYYPointSeparationString((Date)this.mForValidDate));
        this.getDEUVSOCDataTransferBeanAmounts(dEUVSOCDataTransferBean);
        dEUVSOCDataTransferBean.setBAGName1(this.Temp_FIELD_AG_bezeichnung);
        dEUVSOCDataTransferBean.setBAGName2("");
        dEUVSOCDataTransferBean.setBAGStrassePostfach(this.Temp_FIELD_AG_str_nr);
        dEUVSOCDataTransferBean.setBNationalitaetAnschrift(this.Temp_FIELD_AG_land);
        dEUVSOCDataTransferBean.setBAGPLZ(this.Temp_FIELD_AG_plz_ort.substring(0, 5));
        dEUVSOCDataTransferBean.setBAGOrt(this.Temp_FIELD_AG_plz_ort.substring(5, this.Temp_FIELD_AG_plz_ort.length()));
        dEUVSOCDataTransferBean.setBAbrechnnungsstelle1(this.Temp_FIELD_AG_Key);
        dEUVSOCDataTransferBean.setBAbrechnnungsstelle2("");
        dEUVSOCDataTransferBean.setBOrdnungsmerkmal("");
        dEUVSOCDataTransferBean.setBVerarbeitungsmerkmal("");
        if (isGfB && DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2026, 0, 1).getDate())) {
            dEUVSOCDataTransferBean.setBKVBeitragSatzAllg(this.getKVBsGfBPauschal().toString());
        } else {
            dEUVSOCDataTransferBean.setBKVBeitragSatzAllg(healthFundTP.getPercentageGeneral().add(healthFundTP.getAdditionalDues()).toString());
        }
        dEUVSOCDataTransferBean.setBKVBeitragSatzErh(BigDecimal.ZERO.toString());
        if (isGfB && DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2026, 0, 1).getDate())) {
            dEUVSOCDataTransferBean.setBKVBeitragSatzErm(BigDecimal.ZERO.toString());
        } else {
            dEUVSOCDataTransferBean.setBKVBeitragSatzErm(healthFundTP.getPercentageReduced().add(healthFundTP.getAdditionalDues()).toString());
        }
        dEUVSOCDataTransferBean.setBRechtskreis(this.mSOCTypeBDBean.getRechtskreis());
        dEUVSOCDataTransferBean.setBKennzeichenU12("0");
        dEUVSOCDataTransferBean.setBErstellungsdatum(DeuvBasics.getCurrentDeuvDateString());
        dEUVSOCDataTransferBean.setBLfdNummer("0");
        dEUVSOCDataTransferBean.setBVersion("12");
        dEUVSOCDataTransferBean.setBWaehrung("E");
        dEUVSOCDataTransferBean.setBPauschStBD(this.f_summe_st_beitrag);
        String agSteuernummer = BigDecimalMapper.compareTo((BigDecimal)this.f_summe_st_beitrag, (BigDecimal)BigDecimal.valueOf(0L)) != 0 ? this.Temp_FIELD_firma_steuernummer : "";
        dEUVSOCDataTransferBean.setBSteuernummer(agSteuernummer);
        dEUVSOCDataTransferBean.setBSatzende("E");
        dEUVSOCDataTransferBean.setNKennung("NCSZ");
        dEUVSOCDataTransferBean.setNVerfIntMerkmal("BWNAC");
        dEUVSOCDataTransferBean.setNAbsenderNr(this.mDEUVSenderStdCompanyNumber);
        dEUVSOCDataTransferBean.setNEmpfaengerNr(this.mDEUVRecipientTP.getStdCompanyNumber());
        dEUVSOCDataTransferBean.setNErstDatDatei(DateMapper.toYYYYMMDDString((Date)new Date()));
        dEUVSOCDataTransferBean.setNDateiNr(dEUVSOCDataTransferBean.getVDateiNr());
        dEUVSOCDataTransferBean.setNAnzahlSaetze("");
        dEUVSOCDataTransferBean.setNVorzeichenSummeZahlbetrag("");
        dEUVSOCDataTransferBean.setNSummeZahlbetrag("");
        dEUVSOCDataTransferBean.setNReserve("");
        dEUVSOCDataTransferBean.setNVersion("01");
        dEUVSOCDataTransferBean.setNSatzende("E");
        dEUVSOCDataTransferBean.setOidHealthFund(this.mSOCTypeBDBean.getRefereToOidHealthFund());
        dEUVSOCDataTransferBean.setGfB(isGfB);
        dEUVSOCDataTransferBean.setOidPCompany(this.mOidPCompany);
        this.mDEUVSOCDataTransferBeanLi.add(dEUVSOCDataTransferBean);
    }

    private void getDEUVSOCDataTransferBeanAmounts(DEUVSOCDataTransferBean dEUVSOCDataTransferBean) {
        this.f_summe_beitrag = BigDecimal.ZERO;
        this.f_summe_zahlender_beitrag = BigDecimal.ZERO;
        this.f_summe_beitrag = this.f_summe_beitrag.add(this.f_summe_kv_1000_beitrag).add(this.f_summe_kv_2000_beitrag).add(this.f_summe_kv_3000_beitrag).add(this.f_summe_kv_zusatzbeitrag).add(this.f_summe_kv_6000_beitrag);
        this.f_summe_beitrag = this.f_summe_beitrag.add(this.f_summe_rv_0100_beitrag).add(this.f_summe_rv_0200_beitrag).add(this.f_summe_rv_0300_beitrag).add(this.f_summe_rv_0400_beitrag).add(this.f_summe_rv_0500_beitrag).add(this.f_summe_rv_0600_beitrag);
        this.f_summe_beitrag = this.f_summe_beitrag.add(this.f_summe_av_0010_beitrag).add(this.f_summe_av_0020_beitrag).add(this.f_summe_av_0050_beitrag);
        this.f_summe_beitrag = this.f_summe_beitrag.add(this.f_summe_pv_0001_beitrag).add(this.f_summe_u1_beitrag).add(this.f_summe_u2_beitrag).add(this.f_summe_st_beitrag);
        this.f_summe_erstattung = this.f_summe_u1_u2_erstattung;
        this.f_summe_zahlender_beitrag = this.f_summe_zahlender_beitrag.add(this.f_summe_beitrag).add(this.f_summe_kv_frw_beitrag).add(this.f_summe_pv_frw_beitrag).add(this.f_summe_kv_frw_zusatzbeitrag).subtract(this.f_summe_erstattung);
        this.f_summe_rv_0200_beitrag = BigDecimal.ZERO;
        this.f_summe_rv_0400_beitrag = BigDecimal.ZERO;
        this.f_summe_rv_0600_beitrag = BigDecimal.ZERO;
        dEUVSOCDataTransferBean.setBD_1000(this.f_summe_kv_1000_beitrag);
        dEUVSOCDataTransferBean.setBD_2000(this.f_summe_kv_2000_beitrag);
        dEUVSOCDataTransferBean.setBD_3000(this.f_summe_kv_3000_beitrag);
        dEUVSOCDataTransferBean.setBD_0001(this.f_summe_pv_0001_beitrag);
        dEUVSOCDataTransferBean.setBD_0100(this.f_summe_rv_0100_beitrag);
        dEUVSOCDataTransferBean.setBD_0200(this.f_summe_rv_0200_beitrag);
        dEUVSOCDataTransferBean.setBD_0010(this.f_summe_av_0010_beitrag);
        dEUVSOCDataTransferBean.setBD_0300(this.f_summe_rv_0300_beitrag);
        dEUVSOCDataTransferBean.setBD_0020(this.f_summe_av_0020_beitrag);
        dEUVSOCDataTransferBean.setBD_0050(this.f_summe_av_0050_beitrag);
        dEUVSOCDataTransferBean.setBD_U1(this.f_summe_u1_beitrag);
        dEUVSOCDataTransferBean.setBD_U2(this.f_summe_u2_beitrag);
        dEUVSOCDataTransferBean.setBD_6000(this.f_summe_kv_6000_beitrag);
        dEUVSOCDataTransferBean.setBD_0500(this.f_summe_rv_0500_beitrag);
        dEUVSOCDataTransferBean.setBD_0600(this.f_summe_rv_0600_beitrag);
        dEUVSOCDataTransferBean.setBD_Gesamtsumme(this.f_summe_beitrag);
        dEUVSOCDataTransferBean.setBD_FreiwKV(this.f_summe_kv_frw_beitrag);
        dEUVSOCDataTransferBean.setBD_FreiwPV(this.f_summe_pv_frw_beitrag);
        dEUVSOCDataTransferBean.setBD_LFZG(this.f_summe_erstattung);
        dEUVSOCDataTransferBean.setBD_Betrag1(BigDecimal.ZERO);
        dEUVSOCDataTransferBean.setBD_Betrag2(BigDecimal.ZERO);
        dEUVSOCDataTransferBean.setBD_Betrag3(BigDecimal.ZERO);
        dEUVSOCDataTransferBean.setBD_Zahlbetrag(this.f_summe_zahlender_beitrag);
        dEUVSOCDataTransferBean.setBZahlbetragBD(this.f_summe_zahlender_beitrag);
        dEUVSOCDataTransferBean.setBD_Zusatzbeitrag(this.f_summe_kv_zusatzbeitrag);
        dEUVSOCDataTransferBean.setBD_FwZusatzbeitrag(this.f_summe_kv_frw_zusatzbeitrag);
        dEUVSOCDataTransferBean.setBD_PauschSt(this.f_summe_st_beitrag);
    }

    public void saveSummCollection() {
        String bbnr_abs = this.Temp_FIELD_AG_beitragskontonummer;
        String bbnr_kk = this.Temp_FIELD_kk_betriebs_nr;
        String stnr = this.Temp_FIELD_AG_steuernummer;
        Date zrbeg = DateHelper.getFirstDayOfMonth((Date)this.mForValidDate);
        Date zrend = DateHelper.getLastDayOfMonth((Date)this.mForValidDate);
        String kennzrk = StringMapper.equal((String)this.Temp_FIELD_rk_header, (String)"West") ? "W" : "O";
        BigDecimal kvbeitr1 = this.f_summe_kv_1000_beitrag;
        BigDecimal kvbeitr3 = this.f_summe_kv_3000_beitrag;
        BigDecimal pvbeitr = this.f_summe_pv_0001_beitrag;
        BigDecimal rvbeitr1 = this.f_summe_rv_0100_beitrag;
        BigDecimal zbp = this.f_summe_kv_zusatzbeitrag;
        BigDecimal avbeitr1 = this.f_summe_av_0010_beitrag;
        BigDecimal rvbeitr3 = this.f_summe_rv_0300_beitrag;
        BigDecimal insgu = this.f_summe_av_0050_beitrag;
        BigDecimal avbeitr2 = this.f_summe_av_0020_beitrag;
        BigDecimal u1 = this.f_summe_u1_beitrag;
        BigDecimal u2 = this.f_summe_u2_beitrag;
        BigDecimal kvbeitr6 = this.f_summe_kv_6000_beitrag;
        BigDecimal rvbeitr5 = this.f_summe_rv_0500_beitrag;
        BigDecimal kvbeitrf = this.f_summe_kv_frw_beitrag;
        BigDecimal pvbeitrf = this.f_summe_pv_frw_beitrag;
        BigDecimal erstaag = this.f_summe_u1_erstattung.add(this.f_summe_u2_erstattung);
        BigDecimal sum = this.f_summe_zahlender_beitrag.subtract(this.f_summe_st_beitrag).subtract(erstaag);
        BigDecimal beitr = this.f_summe_st_beitrag;
        BigDecimal beitr2 = BigDecimal.ZERO;
        BigDecimal beitr3 = BigDecimal.ZERO;
        BigDecimal zbf = this.f_summe_kv_frw_zusatzbeitrag;
        StatementOfContributionHealthFundBean healthFundBean = (StatementOfContributionHealthFundBean)this.mHealthFundCollection.get(0);
        BigDecimal beitrsa = BigDecimalMapper.toBigDecimal((BigDecimal)healthFundBean.getKv_1000_percentage()).add(BigDecimalMapper.toBigDecimal((BigDecimal)healthFundBean.getKv_additional_dues()));
        BigDecimal beitrsh = BigDecimalMapper.toBigDecimal((BigDecimal)healthFundBean.getKv_3000_percentage()).add(BigDecimalMapper.toBigDecimal((BigDecimal)healthFundBean.getKv_additional_dues()));
        BigDecimal kv1schaetz = this.f_summe_kv_1000_beitrag_bs;
        BigDecimal kv3schaetz = this.f_summe_kv_3000_beitrag_bs;
        BigDecimal pvschaetz = this.f_summe_pv_0001_beitrag_bs;
        BigDecimal rv1schaetz = this.f_summe_rv_0100_beitrag_bs;
        BigDecimal zbpschaetz = this.f_summe_kv_zusatzbeitrag_bs;
        BigDecimal av1schaetz = this.f_summe_av_0010_beitrag_bs;
        BigDecimal rv3schaetz = this.f_summe_rv_0300_beitrag_bs;
        BigDecimal insoschaetz = this.f_summe_av_0050_beitrag_bs;
        BigDecimal av2schaetz = this.f_summe_av_0020_beitrag_bs;
        BigDecimal u1schaetz = this.f_summe_u1_beitrag_bs;
        BigDecimal u2schaetz = this.f_summe_u2_beitrag_bs;
        BigDecimal kv6schaetz = this.f_summe_kv_6000_beitrag_bs;
        BigDecimal rv5schaetz = this.f_summe_rv_0500_beitrag_bs;
        BigDecimal kvfschaetz = this.f_summe_kv_frw_beitrag_bs;
        BigDecimal pvfschaetz = this.f_summe_pv_frw_beitrag_bs;
        BigDecimal zbfschaetz = this.f_summe_kv_frw_zusatzbeitrag_bs;
        BigDecimal beitr2schaetz = BigDecimal.ZERO;
        BigDecimal beitr3schaetz = BigDecimal.ZERO;
        BigDecimal beitrschaetz = this.f_summe_st_beitrag_bs;
        BigDecimal kv1rest = this.f_summe_kv_1000_beitrag_bivm.subtract(this.f_summe_kv_1000_beitrag_bsvm).add(this.f_summe_kv_1000_beitrag_sv_diff);
        BigDecimal kv3rest = this.f_summe_kv_3000_beitrag_bivm.subtract(this.f_summe_kv_3000_beitrag_bsvm).add(this.f_summe_kv_3000_beitrag_sv_diff);
        BigDecimal pvrest = this.f_summe_pv_0001_beitrag_bivm.subtract(this.f_summe_pv_0001_beitrag_bsvm).add(this.f_summe_pv_0001_beitrag_sv_diff);
        BigDecimal rv1rest = this.f_summe_rv_0100_beitrag_bivm.subtract(this.f_summe_rv_0100_beitrag_bsvm).add(this.f_summe_rv_0100_beitrag_sv_diff);
        BigDecimal zbprest = this.f_summe_kv_zusatzbeitrag_bivm.subtract(this.f_summe_kv_zusatzbeitrag_bsvm).add(this.f_summe_kv_zusatzbeitrag_diff);
        BigDecimal av1rest = this.f_summe_av_0010_beitrag_bivm.subtract(this.f_summe_av_0010_beitrag_bsvm).add(this.f_summe_av_0010_beitrag_sv_diff);
        BigDecimal rv3rest = this.f_summe_rv_0300_beitrag_bivm.subtract(this.f_summe_rv_0300_beitrag_bsvm).add(this.f_summe_rv_0300_beitrag_sv_diff);
        BigDecimal insorest = this.f_summe_av_0050_beitrag_bivm.subtract(this.f_summe_av_0050_beitrag_bsvm).add(this.f_summe_av_0050_beitrag_sv_diff);
        BigDecimal av2rest = this.f_summe_av_0020_beitrag_bivm.subtract(this.f_summe_av_0020_beitrag_bsvm).add(this.f_summe_av_0020_beitrag_sv_diff);
        BigDecimal u1rest = this.f_summe_u1_beitrag_bivm.subtract(this.f_summe_u1_beitrag_bsvm).add(this.f_summe_u1_beitrag_sv_diff);
        BigDecimal u2rest = this.f_summe_u2_beitrag_bivm.subtract(this.f_summe_u2_beitrag_bsvm).add(this.f_summe_u2_beitrag_sv_diff);
        BigDecimal kv6rest = this.f_summe_kv_6000_beitrag_bivm.subtract(this.f_summe_kv_6000_beitrag_bsvm).add(this.f_summe_kv_6000_beitrag_sv_diff);
        BigDecimal rv5rest = this.f_summe_rv_0500_beitrag_bivm.subtract(this.f_summe_rv_0500_beitrag_bsvm).add(this.f_summe_rv_0500_beitrag_sv_diff);
        BigDecimal kvfrest = this.f_summe_kv_frw_beitrag_bivm.subtract(this.f_summe_kv_frw_beitrag_bsvm).add(this.f_summe_kv_frw_beitrag_sv_diff);
        BigDecimal pvfrest = this.f_summe_pv_frw_beitrag_bivm.subtract(this.f_summe_pv_frw_beitrag_bsvm).add(this.f_summe_pv_frw_beitrag_sv_diff);
        BigDecimal zbfrest = this.f_summe_kv_frw_zusatzbeitrag_bivm.subtract(this.f_summe_kv_frw_zusatzbeitrag_bsvm).add(this.f_summe_kv_frw_zusatzbeitrag_diff);
        BigDecimal beitr2rest = BigDecimal.ZERO;
        BigDecimal beitr3rest = BigDecimal.ZERO;
        BigDecimal beitrrest = this.f_summe_st_beitrag_bivm.subtract(this.f_summe_st_beitrag_bsvm).add(this.f_summe_st_beitrag_sv_diff);
        InsuranceDsbn insDsbn = new InsuranceDsbn();
        insDsbn.setData(this.mPCompany, null, bbnr_abs, bbnr_kk, zrbeg, zrend, kvbeitr1, kvbeitr3, pvbeitr, rvbeitr1, zbp, avbeitr1, rvbeitr3, insgu, avbeitr2, u1, u2, kvbeitr6, rvbeitr5, kvbeitrf, pvbeitrf, erstaag, zbf, beitr2, beitr3, sum, beitrsa, beitrsh, kennzrk, beitr, stnr, kv1schaetz, kv3schaetz, pvschaetz, rv1schaetz, zbpschaetz, av1schaetz, rv3schaetz, insoschaetz, av2schaetz, u1schaetz, u2schaetz, kv6schaetz, rv5schaetz, kvfschaetz, pvfschaetz, zbfschaetz, beitr2schaetz, beitr3schaetz, beitrschaetz, kv1rest, kv3rest, pvrest, rv1rest, zbprest, av1rest, rv3rest, insorest, av2rest, u1rest, u2rest, kv6rest, rv5rest, kvfrest, pvfrest, zbfrest, beitr2rest, beitr3rest, beitrrest);
        this.mInsuranceDsbnLi.add(insDsbn);
    }

    public List<InsuranceDsbn> getInsuranceDsbnList() {
        return this.mInsuranceDsbnLi;
    }

    public void saveSOCPDataTransferBean() {
        this.mSOCPDataTransferBeanLi.addAll(this.mDEUVSOCDataTransferBeanLi);
    }

    private int getFileNumberOfStatementOfContributions() {
        return this.mDEUVRecipientTP.getFileNumberOfStatementOfContributions();
    }

    protected boolean checkBeitragssollExistent() throws BusinessDomainException {
        boolean deuvSendingRepaired = false;
        if (!this.mRerun) {
            long count;
            Conjunction filterStructs = SOCDataSourceHelper.getForActualMonthFilterStructs((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate));
            filterStructs = Restrictions.and((Criterion)filterStructs, (Criterion)Restrictions.eq((String)"oidpcompany", (String)this.mOidPCompany));
            try {
                count = daoInsurancedues.getRowCount((Criterion)filterStructs);
            }
            catch (Exception e) {
                throw ExceptionMapper.makeApplicationException((Throwable)e);
            }
            if (count != 0L && !(deuvSendingRepaired = this.tryToRepairDUEVSending())) {
                throw SOCRExceptionMapper.makeBeitragssollExistent();
            }
        }
        return deuvSendingRepaired;
    }

    private boolean tryToRepairDUEVSending() {
        Conjunction filterStructs = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.mOidPCompany), Restrictions.eq((String)"DATEOFSENDING", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))), Restrictions.eq((String)"TYPEOFSENDING", (String)TypeOfSendingEnumMapper.toString((TypeOfSendingEnum)TypeOfSendingEnum.TOSE_BEITRAGSNACHWEIS))});
        DEUVSending[] dEUVSendings = DEUVSendingPersistencyManager.query(null, (Criterion)filterStructs);
        return dEUVSendings.length <= 0;
    }

    protected void getOverSteuerungsModulEmployeeBeans(List<StatementOfContributionTypeBDBean> reportTypeBDBeansLi) throws BusinessDomainException {
        this.setClassVariablesForWorking();
        boolean firstMonat = false;
        Date vorMonatEffectiveDate = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate));
        Date vorMonatValidDate = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate));
        Date vorMonatListFirstDate = DateHelper.getFirstDayOfMonth((Date)vorMonatValidDate);
        if (this.mBeitragssollermittlungVormonat) {
            if (DateHelper.before((Date)vorMonatListFirstDate, (Date)this.mCalculationStartDate)) {
                firstMonat = true;
            }
            vorMonatListFirstDate = DateHelper.before((Date)vorMonatListFirstDate, (Date)this.mCalculationStartDate) ? this.mCalculationStartDate : vorMonatListFirstDate;
        }
        Date vorMonatListEndDate = DateHelper.getLastDayOfMonth((Date)vorMonatListFirstDate);
        if (!this.mRerun && !this.journalizedAll(this.mEmployees, vorMonatValidDate)) {
            throw SOCRExceptionMapper.makeEmployeeNotJournalizedLastMonth();
        }
        if (DateHelper.between((Date)vorMonatValidDate, (Date)vorMonatValidDate, (Date)this.mCalculationStartDate)) {
            Conjunction filterStructs = SOCDataSourceHelper.getForActualMonthFilterStructs((Date)vorMonatValidDate);
            filterStructs = SOCDataSourceHelper.getPCompanyFilterStructs((Criterion)filterStructs, (String)this.mOidPCompany);
            List bsvmKrKReportTypeBDBeansLi = this.getTypeBDBeanFromInsuranceDues((Criterion)filterStructs);
            for (StatementOfContributionTypeBDBean sOCTBDBean : bsvmKrKReportTypeBDBeansLi) {
                if (!DateHelper.before((Date)sOCTBDBean.getValidFromDate(), (Date)this.mCalculationStartDate)) continue;
                sOCTBDBean.setValidFromDate(this.mCalculationStartDate);
                sOCTBDBean.setValidUntilDate(this.mCalculationStartDate);
            }
            reportTypeBDBeansLi.addAll(bsvmKrKReportTypeBDBeansLi);
        }
        try {
            this.mProgressBar.nextStep("Ermittle Beitragsnachweise");
            this.mProgressBar.setTotal(this.mEmployees.length);
        }
        catch (PutDataException filterStructs) {
            // empty catch block
        }
        for (int i = 0; i < this.mEmployees.length; ++i) {
            EmployeeForReport currentEmployee = this.mEmployees[i];
            this.mEmployerBean.setOidPCompany(currentEmployee.getOidPCompany());
            this.mEmployerBean.setEffectiveDate(this.mForEffectiveDate);
            this.mEmployerBean.setValidDate(this.mForValidDate);
            this.mEmployerBean.setOidEmployee(currentEmployee.getOidEmployee());
            this.mEmployerBean.setOidPlant(currentEmployee.getOidPlant());
            this.mEmployerBean.createEmployerBean();
            if (!(!DateHelper.before((Date)this.mCalculationStartDate, (Date)vorMonatValidDate) || this.mRerun && firstMonat)) {
                Conjunction filterStructs = SOCDataSourceHelper.getForActualMonthFilterStructs((Date)vorMonatListEndDate);
                filterStructs = SOCDataSourceHelper.getEmployeeFilterStructs((Conjunction)filterStructs, (String)currentEmployee.getOidEmployee(), (String)this.mOidPCompany);
                List typeBDBeansLi = this.getTypeBDBeanFromInsuranceDues((Criterion)filterStructs);
                this.setBSDescriptionTypeBDBeans(typeBDBeansLi, vorMonatListEndDate);
                reportTypeBDBeansLi.addAll(typeBDBeansLi);
            }
            LinkedList timeReportTypeBDBeansLi = new LinkedList();
            if (this.mBeitragssollermittlungVormonat && DateHelper.before((Date)currentEmployee.getDateOfEntry(), (Date)this.mListFirstDate)) {
                this.managePaymentOfContributionWithPreviousMonth(timeReportTypeBDBeansLi, currentEmployee);
            } else {
                this.getEmployeeBeans(timeReportTypeBDBeansLi, currentEmployee, this.mForEffectiveDate, this.mListFirstDate, this.mListEndDate, false);
                this.getRueckrechnungsBeans(timeReportTypeBDBeansLi, currentEmployee, this.mForEffectiveDate, this.mForValidDate, this.mListFirstDate, false);
            }
            this.setBSDescriptionTypeBDBeans(timeReportTypeBDBeansLi, this.mForValidDate);
            reportTypeBDBeansLi.addAll(timeReportTypeBDBeansLi);
            if (DateHelper.before((Date)this.mCalculationStartDate, (Date)vorMonatValidDate)) {
                timeReportTypeBDBeansLi = new LinkedList();
                this.getEmployeeBeansBI(timeReportTypeBDBeansLi, currentEmployee, vorMonatEffectiveDate, vorMonatListFirstDate, vorMonatListEndDate);
                this.getRueckrechnungsBeans(timeReportTypeBDBeansLi, currentEmployee, vorMonatEffectiveDate, vorMonatValidDate, vorMonatListFirstDate, true);
                this.setBIDescriptionTypeBDBeans(timeReportTypeBDBeansLi, vorMonatValidDate);
                reportTypeBDBeansLi.addAll(timeReportTypeBDBeansLi);
            }
            try {
                this.mProgressBar.update();
                continue;
            }
            catch (PutDataException putDataException) {
                // empty catch block
            }
        }
    }

    public boolean next() throws JRException {
        try {
            this.resetComponents();
            while (this.getHasNext()) {
                boolean leaveNext;
                this.mSOCTypeBDBean = this.mSOCTypeBDBeanNext;
                this.mSOCTypeBDBeanNext = null;
                if (this.mStatementOfContributionTypeBDBeanIt.hasNext()) {
                    this.mSOCTypeBDBeanNext = (StatementOfContributionTypeBDBean)this.mStatementOfContributionTypeBDBeanIt.next();
                }
                if (leaveNext = this.isChangeInTypeBeans()) {
                    if (this.mNewKrKFirstPurchase) {
                        this.setHeaderFields();
                        this.buildHeaderSubReports();
                        this.mNewKrKFirstPurchase = false;
                    }
                    this.setFiledsFromBeanFieldsInReportLists();
                    this.steuerungAddSummFields();
                    this.buildSummCollection();
                    return true;
                }
                if (this.mNewKrKFirstPurchase) {
                    this.setHeaderFields();
                    this.buildHeaderSubReports();
                    this.mNewKrKFirstPurchase = false;
                }
                this.setFiledsFromBeanFieldsInReportLists();
                this.steuerungAddSummFields();
            }
            return false;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JRException((Throwable)e);
        }
    }

    private BigDecimal getKVBsGfBPauschal() throws BusinessDomainException {
        block3: {
            if (BigDecimalMapper.isZero((BigDecimal)this.mKVBsGfBPauschal)) {
                try {
                    SocialInsurance socialIns = SocialInsurancePersistencyManager.getInstance();
                    SocialInsuranceTP socialInsuranceTP = socialIns.getSocialInsurance(this.mForEffectiveDate, this.mForValidDate);
                    this.mKVBsGfBPauschal = socialInsuranceTP.getGlobal().getBlanketContributionRateForHealthInsuranceConcerningLowIncomeEarners();
                }
                catch (BusinessDomainException e) {
                    if (!FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block3;
                    throw EvaluationExceptionMapper.makeMissingSocialInsuranceDomainException(DateMapper.toString((Date)this.mForEffectiveDate) + DateMapper.toString((Date)this.mForValidDate));
                }
            }
        }
        return this.mKVBsGfBPauschal;
    }

    private class NewDEUVSending {
        String oidPCompany;
        String oidHealthFund;
        DEUVSending dEUVSending;

        NewDEUVSending(String oidPCompany, String oidHealthfund, DEUVSending dEUVSending) {
            this.oidPCompany = oidPCompany;
            this.oidHealthFund = oidHealthfund;
            this.dEUVSending = dEUVSending;
        }

        public boolean equals(Object object) {
            NewDEUVSending other = (NewDEUVSending)object;
            return this.oidPCompany.equals(other.oidPCompany) && this.oidHealthFund.equals(other.oidHealthFund);
        }
    }
}

