/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.deuvstatementofcontribution;

import com.infor.igf.core.util.CloneUtils;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.deuv.PerfidiaResult;
import com.varial.personnel.domain.deuv.deuvsending.DEUVSending;
import com.varial.personnel.domain.deuv.deuvsending.DEUVSendingPersistencyManager;
import com.varial.personnel.domain.deuv.deuvsending.TypeOfSendingEnum;
import com.varial.personnel.domain.deuv.mapper.TypeOfSendingEnumMapper;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.employee.paymentofcontributions.insurancedsbn.InsuranceDsbn;
import com.varial.personnel.domain.employee.paymentofcontributions.insurancedsbn.InsuranceDsbnPersistencyManager;
import com.varial.personnel.domain.employee.paymentofcontributions.insurancedues.InsuranceDues;
import com.varial.personnel.domain.employee.paymentofcontributions.insurancedues.InsuranceDuesPersistencyManager;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipientTP;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipientTPPersistencyManager;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.foundations.SpecificEnum;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.deuvstatementofcontribution.DEUVCompanyStruct;
import com.varial.personnel.domain.reports.deuvstatementofcontribution.DEUVSOCDataTransferBean;
import com.varial.personnel.domain.reports.deuvstatementofcontribution.DEUVStatementOfContributionDataTransferReport;
import com.varial.personnel.domain.reports.deuvstatementofcontribution.DEUVStatementOfContributionPaidDataSource;
import com.varial.personnel.domain.reports.deuvstatementofcontribution.DEUVStatementOfContributionPaidKVDRDataSource;
import com.varial.personnel.domain.reports.deuvstatementofcontribution.DEUVStatementOfContributionSubreportBean;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.library.ReportValues;
import com.varial.personnel.domain.reports.mapper.DEUVExceptionMapper;
import com.varial.personnel.domain.reports.reportdatatransfer.DEUVDataTransferHelper;
import com.varial.personnel.domain.reports.reportdatatransfer.ReportDataTransfer;
import com.varial.personnel.domain.reports.statementofcontribution.mapper.SOCRExceptionMapper;
import com.varial.personnel.framework.ISpecialAccessPersistencyContext;
import com.varial.personnel.persistency.deuv.deuvsending.DeuvsendingContainer;
import com.varial.personnel.persistency.deuv.deuvsending.IDeuvsendingDao;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.AllCallback;
import com.varial.serverbase.query.PutDataException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DEUVStatementOfContributionDataTransfer
implements JRDataSource {
    private static IDeuvsendingDao daoDeuvsending = (IDeuvsendingDao)UtilitiesManager.getApplicationContext().getBean("deuvsendingDao");
    private static Logger LOGGER = LoggerFactory.getLogger(DEUVStatementOfContributionDataTransferReport.class);
    private final DEUVCompanyStruct[] mDEUVCompanyStruct;
    private Map<String, List<DEUVSOCDataTransferBean>> mDEUVRecipientsDataTransferBeansHM;
    private final List<DEUVSOCDataTransferBean> mSOCPDataTransferBeanLi = new LinkedList<DEUVSOCDataTransferBean>();
    private String mDEUVSenderStdCompanyNumber;
    private String mDEUVSenderDescription;
    private ReportDataTransfer mReportDataTransfer;
    private BufferedWriter mDateiEinschreiben;
    private static final String STATIC_TEXT_PARAMETER_staticColumnHeaderFirma = "staticColumnHeaderFirma";
    private static final String STATIC_TEXT_PARAMETER_staticColumnHeaderKrK = "staticColumnHeaderKrK";
    private static final String STATIC_TEXT_PARAMETER_staticColumnHeaderMonat = "staticColumnHeaderMonat";
    private static final String STATIC_TEXT_PARAMETER_staticColumnHeaderSumme = "staticColumnHeaderSumme";
    private static final String STATIC_TEXT_PARAMETER_staticDEUEVMeldungen = "staticDEUEVMeldungen";
    private static final String STATIC_TEXT_PARAMETER_staticCompany = "staticCompany";
    private static final String STATIC_TEXT_PARAMETER_staticWaehrung = "staticWaehrung";
    private static final String STATIC_TEXT_PARAMETER_staticDatum = "staticDatum";
    private static final String STATIC_TEXT_PARAMETER_staticBenutzer = "staticBenutzer";
    private static final String STATIC_TEXT_PARAMETER_staticSeite = "staticSeite";
    private static final String STATIC_TEXT_PARAMETER_staticAbsender = "staticAbsender";
    private static final String STATIC_TEXT_PARAMETER_staticEmpfaenger = "staticEmpfaenger";
    private static final String STATIC_TEXT_PARAMETER_staticDateiname = "staticDateiname";
    private static final String STATIC_TEXT_PARAMETER_staticBetriebsNrAbsender = "staticBetriebsNrAbsender";
    private static final String STATIC_TEXT_PARAMETER_staticBetriebsNrEmpfaenger = "staticBetriebsNrEmpfaenger";
    private static final String STATIC_TEXT_PARAMETER_staticDateiNr = "staticDateiNr";
    private static final String STATIC_TEXT_PARAMETER_staticKassenart = "staticKassenart";
    private static String staticColumnHeaderFirma = "";
    private static String staticColumnHeaderKrK = "";
    private static String staticColumnHeaderMonat = "";
    private static String staticColumnHeaderSumme = "";
    private static String staticCompany = "";
    private static String staticWaehrung = "";
    private static String staticDatum = "";
    private static String staticBenutzer = "";
    private static String staticSeite = "";
    private static String staticReportTitel = "";
    private static String staticAbsender = "";
    private static String staticEmpfaenger = "";
    private static String staticDateiname = "";
    private static String staticBetriebsNrAbsender = "";
    private static String staticBetriebsNrEmpfaenger = "";
    private static String staticDateiNr = "";
    private static String staticKassenart = "";
    private String mField_Absender = "";
    private String mField_Empfaenger = "";
    private String mField_Dateiname = "";
    private String mField_BetriebsNrAbsender = "";
    private String mField_BetriebsNrEmpfaenger = "";
    private String mField_DateiNr = "";
    private String mField_Kassenart = "";
    private String mOidDEUVRecipient = "";
    private Iterator<String> mDEUVRecipientsIt;
    private int mCountDatas;
    private String mUserID;
    private DEUVSenderTP mDeuvSenderTP;
    private DEUVSender mDEUVSender;
    private final List<DEUVStatementOfContributionSubreportBean> mEmployerHealthfundSubreportLi = new LinkedList<DEUVStatementOfContributionSubreportBean>();
    private Iterator<DEUVSOCDataTransferBean> mDEUVRecipientDataTransferBeansIt;
    private BigDecimal mBundesKnappschaftBD = BigDecimal.ZERO;
    private boolean mKVDRDataTransfer = false;
    private String mVerfahren = "";
    private boolean mFirstPurchase = true;
    private final boolean mRerun;
    private final List<BufferedWriter> mDateienBufferedWriterLi = new LinkedList<BufferedWriter>();
    private final List<String> mOidPCompanyList = new LinkedList<String>();
    final List<InsuranceDsbn> mInsuranceDsbnLi = new LinkedList<InsuranceDsbn>();
    private Date mDate;
    private boolean mEnd = false;
    private final PerfidiaResult mPerfidiaResult;
    protected ProgressBarUpdater mProgressBar;
    private int mCountIterations;

    public DEUVStatementOfContributionDataTransfer(AllCallback callback, ISpecialAccessPersistencyContext sapc, DEUVCompanyStruct[] dEUVCompanyStruct, boolean kvdrDataTransfer, boolean rerun, PerfidiaResult perfidiaResult, ProgressBarUpdater progressBar) throws BusinessDomainException, JRException, PutDataException {
        this.mProgressBar = progressBar;
        this.mPerfidiaResult = perfidiaResult;
        this.mRerun = rerun;
        this.mKVDRDataTransfer = kvdrDataTransfer;
        this.mVerfahren = this.mKVDRDataTransfer ? "BWBNV" : "BWNAC";
        this.mDEUVCompanyStruct = dEUVCompanyStruct;
        String[] oidPCompanyies = new String[this.mDEUVCompanyStruct.length];
        Date forValidDate = DateMapper.toDate((String)this.mDEUVCompanyStruct[0].forValidDate);
        if (this.mRerun && !this.mKVDRDataTransfer) {
            for (int i = 0; i < this.mDEUVCompanyStruct.length; ++i) {
                oidPCompanyies[i] = this.mDEUVCompanyStruct[i].oidPCompany;
            }
            this.deleteInsuranceDues(oidPCompanyies, forValidDate);
            this.deleteInsuranceDsbn(oidPCompanyies, forValidDate);
        }
        SpecificEnum specificEnum = this.getSpecificEnum(dEUVCompanyStruct);
        for (int i = 0; i < this.mDEUVCompanyStruct.length; ++i) {
            boolean next;
            Date date = DateMapper.toDate((String)this.mDEUVCompanyStruct[i].forValidDate);
            LinkedList sOCPDataTransferBeanLi = new LinkedList();
            date = this.mDEUVCompanyStruct[i].manualDate ? DateHelper.getFirstDayOfMonth((Date)date) : (this.mRerun ? DateHelper.getLastDayOfMonth((Date)date) : DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)date)));
            this.mDate = date;
            String oidPCompany = this.mDEUVCompanyStruct[i].oidPCompany;
            if (StringMapper.isNullString((String)this.mDEUVSenderStdCompanyNumber)) {
                this.setDEUVSenderStdCompanyNumber(oidPCompany, date, date);
            }
            ArrayList<String> errorList = new ArrayList<String>();
            this.mProgressBar.nextStep("Erzeuge Mitarbeiter-Daten" + (String)(this.mDEUVCompanyStruct.length > 1 ? " " + (i + 1) : ""));
            if (!this.mKVDRDataTransfer) {
                DEUVStatementOfContributionPaidDataSource socpaidDS = new DEUVStatementOfContributionPaidDataSource(callback, sapc, this.getReportFirstFilterStruct(oidPCompany), this.getReportSortStruct(), date, date, this.mDEUVSender.getObjectid(), this.mDEUVSenderStdCompanyNumber, this.mDEUVSenderDescription, rerun, this.mProgressBar, errorList);
                this.mProgressBar.nextStep("F\u00fcge Beitragsnachweise hinzu" + (String)(this.mDEUVCompanyStruct.length > 1 ? " " + (i + 1) : ""));
                this.mProgressBar.setTotal(socpaidDS.getCountIterations());
                next = socpaidDS.next();
                while (next) {
                    socpaidDS.saveSOCPDataTransferBean();
                    socpaidDS.saveSummCollection();
                    next = socpaidDS.next();
                    this.mProgressBar.update();
                }
                sOCPDataTransferBeanLi.addAll(CloneUtils.clone(socpaidDS.getSOCPDataTransferBeanLi()));
                this.mInsuranceDsbnLi.addAll(CloneUtils.clone(socpaidDS.getInsuranceDsbnList()));
            } else {
                DEUVStatementOfContributionPaidKVDRDataSource socpaidKVDRDS = new DEUVStatementOfContributionPaidKVDRDataSource(callback, sapc, this.getReportFirstFilterStruct(oidPCompany), this.getReportSortStruct(), date, date, this.mDEUVSender.getObjectid(), this.mDEUVSenderStdCompanyNumber, this.mDEUVSenderDescription, this.mProgressBar, errorList);
                this.mProgressBar.nextStep("F\u00fcge Beitragsnachweise hinzu" + (String)(this.mDEUVCompanyStruct.length > 1 ? " " + (i + 1) : ""));
                this.mProgressBar.setTotal(socpaidKVDRDS.getCountIterations());
                next = socpaidKVDRDS.next();
                while (next) {
                    socpaidKVDRDS.saveSOCPDataTransferBean();
                    next = socpaidKVDRDS.next();
                    this.mProgressBar.update();
                }
                sOCPDataTransferBeanLi.addAll(CloneUtils.clone((List)socpaidKVDRDS.getSOCPDataTransferBeanLi()));
            }
            if (sOCPDataTransferBeanLi.isEmpty()) {
                this.mOidPCompanyList.add(oidPCompany);
                continue;
            }
            this.mSOCPDataTransferBeanLi.addAll(sOCPDataTransferBeanLi);
        }
        if (this.mSOCPDataTransferBeanLi != null && !this.mSOCPDataTransferBeanLi.isEmpty()) {
            String sendQuePathPem = "\\pem\\sendq\\";
            Object dEUVSOCPReportFilePrefix = "";
            String fallKennzeichen = "";
            fallKennzeichen = 1 == specificEnum.value() ? "T" : "E";
            dEUVSOCPReportFilePrefix = !this.mKVDRDataTransfer ? fallKennzeichen + "BNA" : fallKennzeichen + "BNZ";
            String perfidiaPath = this.mDeuvSenderTP.getPerfidiaPath();
            this.mReportDataTransfer = StringMapper.isNullString((String)perfidiaPath) ? new ReportDataTransfer("\\pem\\sendq\\", (String)dEUVSOCPReportFilePrefix, false) : new ReportDataTransfer("\\pem\\sendq\\", (String)dEUVSOCPReportFilePrefix, this.mDeuvSenderTP);
            this.setDataTransferBeanInProperHM();
            this.setDEUVRecipientsIterator();
            this.saveInsuranceDsbns();
        }
        this.initReportFields();
    }

    private SpecificEnum getSpecificEnum(DEUVCompanyStruct[] dEUVCompanySeq) throws BusinessDomainException {
        LinkedList<DEUVCompanyStruct> dEUVCompanySeqLi = new LinkedList<DEUVCompanyStruct>();
        for (int i = 0; i < dEUVCompanySeq.length; ++i) {
            dEUVCompanySeqLi.add(dEUVCompanySeq[i]);
        }
        ReportValues reportValues = new ReportValues();
        SpecificEnum spec = null;
        Boolean isMusterfirma = null;
        Boolean isNotMusterfirma = null;
        block4: for (DEUVCompanyStruct dEUVCompanyStruct : dEUVCompanySeqLi) {
            DEUVSender deuvSender = DeuvHelper.getDeuvSender((PCompany)new PCompany(dEUVCompanyStruct.oidPCompany));
            if (deuvSender != null && deuvSender.isTestSender()) {
                return SpecificEnum.SE_Musterfirma;
            }
            spec = reportValues.getPCompanyFoundations(dEUVCompanyStruct.oidPCompany, DateMapper.toDate((String)dEUVCompanyStruct.forValidDate), DateMapper.toDate((String)dEUVCompanyStruct.forValidDate)).getSpecific();
            switch (spec.value()) {
                case 1: {
                    isMusterfirma = Boolean.TRUE;
                    continue block4;
                }
            }
            isNotMusterfirma = Boolean.TRUE;
        }
        if (isMusterfirma != null && isNotMusterfirma != null && isMusterfirma.booleanValue() != isNotMusterfirma.booleanValue()) {
            throw DEUVExceptionMapper.makeNoSimultanousSelectionOfMusterfirmaAndNotMusterfirma();
        }
        return spec;
    }

    private void setDEUVRecipientsIterator() {
        LinkedList<String> dEUVRecipientsLi = new LinkedList<String>(this.mDEUVRecipientsDataTransferBeansHM.keySet());
        this.mDEUVRecipientsIt = dEUVRecipientsLi.iterator();
        this.mCountIterations = dEUVRecipientsLi.size();
    }

    private void manageKrKBeans(DEUVSOCDataTransferBean dEUVSOCDataTransferBean, List<StringBuilder> stringFileBeitragNachweisLi) {
        StringBuilder stringFileBeitragNachweis = new StringBuilder();
        this.appendBeitragsnachweisSatz(stringFileBeitragNachweis, dEUVSOCDataTransferBean);
        stringFileBeitragNachweisLi.add(stringFileBeitragNachweis);
    }

    private List<DEUVSOCDataTransferBean> buildDEUVRecipientFile(List<DEUVSOCDataTransferBean> dEUVRecipientDataTransferBeansLi, String dEUVRecipientsKey) throws NumberFormatException, BusinessDomainException, IOException {
        this.mDEUVRecipientDataTransferBeansIt = dEUVRecipientDataTransferBeansLi.iterator();
        HashMap<String, DEUVSOCDataTransferBean> pCompanydEUVSOCDataTransferBeanHM = new HashMap<String, DEUVSOCDataTransferBean>();
        DEUVSOCDataTransferBean dEUVSOCDataTransferBean = null;
        DEUVSOCDataTransferBean dEUVSOCDataTransferBeanTmp = null;
        int counterDatas = 0;
        BigDecimal zahlBetrag = BigDecimal.valueOf(0L, 2);
        LinkedList<StringBuilder> stringFileBeitragNachweisLi = new LinkedList<StringBuilder>();
        HashMap<CallSite, DEUVSOCDataTransferBean> konsDEUVSOCDataTransferBeanHM = new HashMap<CallSite, DEUVSOCDataTransferBean>();
        while (this.mDEUVRecipientDataTransferBeansIt.hasNext()) {
            dEUVSOCDataTransferBean = this.mDEUVRecipientDataTransferBeansIt.next();
            if (pCompanydEUVSOCDataTransferBeanHM.get(dEUVSOCDataTransferBean.getOidPCompany()) == null) {
                pCompanydEUVSOCDataTransferBeanHM.put(dEUVSOCDataTransferBean.getOidPCompany(), dEUVSOCDataTransferBean);
            }
            this.buildEmployerHealthFundSubreportList(dEUVSOCDataTransferBean);
            String key = dEUVSOCDataTransferBean.getBArbeitgeberBetriebsnummerNr() + "-" + dEUVSOCDataTransferBean.getBKrKEmpfaengerBetriebsNr() + "-" + dEUVSOCDataTransferBean.getBRechtskreis() + "-" + dEUVSOCDataTransferBean.getBKennzeichenInsolvenz();
            if ("98000006".equals(dEUVSOCDataTransferBean.getNEmpfaengerNr()) && dEUVSOCDataTransferBean.isGfB()) {
                key = key + "- GfB";
            }
            dEUVSOCDataTransferBeanTmp = (dEUVSOCDataTransferBeanTmp = (DEUVSOCDataTransferBean)konsDEUVSOCDataTransferBeanHM.get(key)) == null ? dEUVSOCDataTransferBean : this.sumUpSOCDataTransferBeans(dEUVSOCDataTransferBeanTmp, dEUVSOCDataTransferBean);
            konsDEUVSOCDataTransferBeanHM.put((CallSite)((Object)key), dEUVSOCDataTransferBeanTmp);
        }
        dEUVRecipientDataTransferBeansLi.clear();
        for (Map.Entry pair : konsDEUVSOCDataTransferBeanHM.entrySet()) {
            DEUVSOCDataTransferBean value = (DEUVSOCDataTransferBean)pair.getValue();
            dEUVRecipientDataTransferBeansLi.add(value);
        }
        this.mDEUVRecipientDataTransferBeansIt = dEUVRecipientDataTransferBeansLi.iterator();
        if (this.mDEUVRecipientDataTransferBeansIt.hasNext()) {
            dEUVSOCDataTransferBean = this.mDEUVRecipientDataTransferBeansIt.next();
        }
        if (dEUVSOCDataTransferBean != null) {
            StringBuilder stringFile;
            Date forValidDate = dEUVSOCDataTransferBean.getForValidDate();
            String fileNumberString = "";
            DEUVRecipientTP dEUVRecipientTP = this.getDEUVRecipientTP(dEUVSOCDataTransferBean.getVEmpfaengerNr());
            if (dEUVRecipientTP != null) {
                int fileNumber = 0;
                if (this.mRerun) {
                    Conjunction filterStructs = this.getDEUVSendingFilter(dEUVSOCDataTransferBean);
                    filterStructs.add(Restrictions.eq((String)"oidpcompany", (String)dEUVSOCDataTransferBean.getOidPCompany()));
                    DEUVSending[] deuvSending = DEUVSendingPersistencyManager.query(null, (Criterion)filterStructs);
                    if (deuvSending != null && deuvSending.length > 0) {
                        fileNumber = deuvSending[0].getCurrentFileNumber();
                    }
                    if (!this.isFileInPerfidiaSendQExsitant(dEUVRecipientsKey, fileNumberString = Integer.toString(fileNumber))) {
                        fileNumber = dEUVRecipientTP.getFileNumberOfStatementOfContributions();
                        this.setDEUVRecipientFileNumber(dEUVRecipientTP, ++fileNumber);
                        this.mDEUVRecipientDataTransferBeansIt = dEUVRecipientDataTransferBeansLi.iterator();
                        counterDatas += dEUVRecipientDataTransferBeansLi.size();
                        while (this.mDEUVRecipientDataTransferBeansIt.hasNext()) {
                            dEUVSOCDataTransferBean = this.mDEUVRecipientDataTransferBeansIt.next();
                            dEUVSOCDataTransferBean.setBVerarbeitungsmerkmal(" ");
                            this.manageKrKBeans(dEUVSOCDataTransferBean, stringFileBeitragNachweisLi);
                            zahlBetrag = zahlBetrag.add(dEUVSOCDataTransferBean.getBZahlbetragBD());
                        }
                    } else {
                        this.deleteFile(dEUVRecipientsKey, fileNumberString);
                        this.mDEUVRecipientDataTransferBeansIt = dEUVRecipientDataTransferBeansLi.iterator();
                        counterDatas += dEUVRecipientDataTransferBeansLi.size();
                        dEUVSOCDataTransferBean = this.setDEUVRecipientAllKrkBeans(zahlBetrag, stringFileBeitragNachweisLi);
                        zahlBetrag = dEUVSOCDataTransferBean.getBZahlbetragBD();
                    }
                    this.prepareToDeleteDEUVSendings(pCompanydEUVSOCDataTransferBeanHM, dEUVSOCDataTransferBean);
                } else {
                    fileNumber = this.mKVDRDataTransfer ? dEUVRecipientTP.getFileNumberKvdrStatementOfContributions() : dEUVRecipientTP.getFileNumberOfStatementOfContributions();
                    this.setDEUVRecipientFileNumber(dEUVRecipientTP, ++fileNumber);
                    this.mDEUVRecipientDataTransferBeansIt = dEUVRecipientDataTransferBeansLi.iterator();
                    counterDatas += dEUVRecipientDataTransferBeansLi.size();
                    dEUVSOCDataTransferBean = this.setDEUVRecipientAllKrkBeans(zahlBetrag, stringFileBeitragNachweisLi);
                    zahlBetrag = dEUVSOCDataTransferBean.getBZahlbetragBD();
                }
                ++counterDatas;
                fileNumberString = Integer.toString(fileNumber);
                stringFile = new StringBuilder();
                this.initNewFile(dEUVRecipientsKey, fileNumberString);
                this.appendVorlaufSatz(stringFile, dEUVSOCDataTransferBean, fileNumberString);
                this.mDateiEinschreiben.write(stringFile.toString());
                this.mDateiEinschreiben.newLine();
                stringFile = new StringBuilder();
                DEUVDataTransferHelper.appendDSKOSatz((StringBuilder)stringFile, (String)this.mVerfahren, (DEUVSOCDataTransferBean)dEUVSOCDataTransferBean, (DEUVSenderTP)this.getDEUVSenderTP(dEUVSOCDataTransferBean.getOidPCompany(), dEUVSOCDataTransferBean.getForValidDate(), dEUVSOCDataTransferBean.getForValidDate()));
                this.mDateiEinschreiben.write(stringFile.toString());
                this.mDateiEinschreiben.newLine();
                Iterator stringFileBeitragNachweisIt = stringFileBeitragNachweisLi.iterator();
                while (stringFileBeitragNachweisIt.hasNext()) {
                    StringBuilder stringFileBeitragNachweisTemp = new StringBuilder();
                    stringFileBeitragNachweisTemp = (StringBuilder)stringFileBeitragNachweisIt.next();
                    this.mDateiEinschreiben.write(stringFileBeitragNachweisTemp.toString());
                    this.mDateiEinschreiben.newLine();
                }
            } else {
                throw DEUVExceptionMapper.makeNoDEUVRecipientTPDomainException((String)(dEUVSOCDataTransferBean.getVEmpfaengerNr() + DateMapper.toDDMMYYYYPointSeparationString((Date)forValidDate)));
            }
            stringFile = new StringBuilder();
            this.appendNachlaufSatz(stringFile, dEUVSOCDataTransferBean, fileNumberString, counterDatas);
            this.mDateiEinschreiben.write(stringFile.toString());
            this.setReportHeaderFields(dEUVSOCDataTransferBean, fileNumberString);
            LinkedList pCompanydEUVSOCDataTransferBeanLi = new LinkedList(pCompanydEUVSOCDataTransferBeanHM.keySet());
            for (String oidPCompany : pCompanydEUVSOCDataTransferBeanLi) {
                DEUVSOCDataTransferBean pCompanydEUVSOCDataTransferBean = (DEUVSOCDataTransferBean)pCompanydEUVSOCDataTransferBeanHM.get(oidPCompany);
                this.createDEUVSending(pCompanydEUVSOCDataTransferBean, fileNumberString);
            }
        }
        return dEUVRecipientDataTransferBeansLi;
    }

    private DEUVSOCDataTransferBean sumUpSOCDataTransferBeans(DEUVSOCDataTransferBean dEUVSOCDTB1, DEUVSOCDataTransferBean dEUVSOCDTB2) {
        DEUVSOCDataTransferBean result = dEUVSOCDTB1;
        result.setBD_1000(dEUVSOCDTB1.getBD_1000().add(dEUVSOCDTB2.getBD_1000()));
        result.setBD_2000(dEUVSOCDTB1.getBD_2000().add(dEUVSOCDTB2.getBD_2000()));
        result.setBD_3000(dEUVSOCDTB1.getBD_3000().add(dEUVSOCDTB2.getBD_3000()));
        result.setBD_0001(dEUVSOCDTB1.getBD_0001().add(dEUVSOCDTB2.getBD_0001()));
        result.setBD_0100(dEUVSOCDTB1.getBD_0100().add(dEUVSOCDTB2.getBD_0100()));
        result.setBD_0200(dEUVSOCDTB1.getBD_0200().add(dEUVSOCDTB2.getBD_0200()));
        result.setBD_0010(dEUVSOCDTB1.getBD_0010().add(dEUVSOCDTB2.getBD_0010()));
        result.setBD_0300(dEUVSOCDTB1.getBD_0300().add(dEUVSOCDTB2.getBD_0300()));
        result.setBD_0400(dEUVSOCDTB1.getBD_0400().add(dEUVSOCDTB2.getBD_0400()));
        result.setBD_0020(dEUVSOCDTB1.getBD_0020().add(dEUVSOCDTB2.getBD_0020()));
        result.setBD_0050(dEUVSOCDTB1.getBD_0050().add(dEUVSOCDTB2.getBD_0050()));
        result.setBD_U1(dEUVSOCDTB1.getBD_U1().add(dEUVSOCDTB2.getBD_U1()));
        result.setBD_U2(dEUVSOCDTB1.getBD_U2().add(dEUVSOCDTB2.getBD_U2()));
        result.setBD_6000(dEUVSOCDTB1.getBD_6000().add(dEUVSOCDTB2.getBD_6000()));
        result.setBD_0500(dEUVSOCDTB1.getBD_0500().add(dEUVSOCDTB2.getBD_0500()));
        result.setBD_0600(dEUVSOCDTB1.getBD_0600().add(dEUVSOCDTB2.getBD_0600()));
        result.setBD_Gesamtsumme(dEUVSOCDTB1.getBD_Gesamtsumme().add(dEUVSOCDTB2.getBD_Gesamtsumme()));
        result.setBD_FreiwKV(dEUVSOCDTB1.getBD_FreiwKV().add(dEUVSOCDTB2.getBD_FreiwKV()));
        result.setBD_FreiwPV(dEUVSOCDTB1.getBD_FreiwPV().add(dEUVSOCDTB2.getBD_FreiwPV()));
        result.setBD_LFZG(dEUVSOCDTB1.getBD_LFZG().add(dEUVSOCDTB2.getBD_LFZG()));
        result.setBD_Betrag1(dEUVSOCDTB1.getBD_Betrag1().add(dEUVSOCDTB2.getBD_Betrag1()));
        result.setBD_Betrag2(dEUVSOCDTB1.getBD_Betrag2().add(dEUVSOCDTB2.getBD_Betrag2()));
        result.setBD_Betrag3(dEUVSOCDTB1.getBD_Betrag3().add(dEUVSOCDTB2.getBD_Betrag3()));
        result.setBD_Zahlbetrag(dEUVSOCDTB1.getBD_Zahlbetrag().add(dEUVSOCDTB2.getBD_Zahlbetrag()));
        result.setBD_PauschSt(dEUVSOCDTB1.getBD_PauschSt().add(dEUVSOCDTB2.getBD_PauschSt()));
        result.setBD_Zusatzbeitrag(dEUVSOCDTB1.getBD_Zusatzbeitrag().add(dEUVSOCDTB2.getBD_Zusatzbeitrag()));
        result.setBD_FwZusatzbeitrag(dEUVSOCDTB1.getBD_FwZusatzbeitrag().add(dEUVSOCDTB2.getBD_FwZusatzbeitrag()));
        return result;
    }

    private DEUVSOCDataTransferBean setDEUVRecipientAllKrkBeans(BigDecimal zahlBetrag, List<StringBuilder> stringFileBeitragNachweisLi) {
        DEUVSOCDataTransferBean dEUVSOCDataTransferBean = null;
        while (this.mDEUVRecipientDataTransferBeansIt.hasNext()) {
            dEUVSOCDataTransferBean = this.mDEUVRecipientDataTransferBeansIt.next();
            this.manageKrKBeans(dEUVSOCDataTransferBean, stringFileBeitragNachweisLi);
            zahlBetrag = zahlBetrag.add(dEUVSOCDataTransferBean.getBZahlbetragBD());
        }
        dEUVSOCDataTransferBean.setBZahlbetragBD(zahlBetrag);
        return dEUVSOCDataTransferBean;
    }

    private void deleteFile(String perfidiaSubFolder, String fileNumberString) throws BusinessDomainException {
        File file = this.mReportDataTransfer.getFile(perfidiaSubFolder, fileNumberString);
        file.delete();
    }

    private void prepareToDeleteDEUVSendings(Map<String, DEUVSOCDataTransferBean> pCompanydEUVSOCDataTransferBeanHM, DEUVSOCDataTransferBean dEUVSOCDataTransferBean) throws BusinessDomainException {
        Conjunction filterStructs = this.getDEUVSendingFilter(dEUVSOCDataTransferBean);
        filterStructs.add(Restrictions.in((String)"oidpcompany", pCompanydEUVSOCDataTransferBeanHM.keySet()));
        DEUVSending[] deuvSending = DEUVSendingPersistencyManager.query(null, (Criterion)filterStructs);
        for (int i = 0; i < deuvSending.length; ++i) {
            deuvSending[i].makeSaveable();
            deuvSending[i].destroy();
        }
        LOGGER.info("############################## Fuer den Zeitpunkt " + DateMapper.toDDMMYYYYPointSeparationString((Date)dEUVSOCDataTransferBean.getForValidDate()) + " wurden Daten aus der Tabelle DEUVSENDING_T geloescht!!!");
    }

    private Conjunction getDEUVSendingFilter(DEUVSOCDataTransferBean dEUVSOCDataTransferBean) {
        String typeOfSending = "1";
        if (this.mKVDRDataTransfer) {
            typeOfSending = "0";
        }
        return Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oiddeuvsender", (String)this.mDEUVSender.getObjectid()), Restrictions.eq((String)"oiddeuvrecipient", (String)this.mOidDEUVRecipient), Restrictions.eq((String)"dateofsending", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)dEUVSOCDataTransferBean.getForValidDate()))), Restrictions.eq((String)"typeofsending", (String)typeOfSending)});
    }

    private void setDEUVRecipientFileNumber(DEUVRecipientTP dEUVRecipientTP, int fileNumber) {
        if (this.mKVDRDataTransfer) {
            dEUVRecipientTP.setFileNumberKvdrStatementOfContributions(fileNumber);
        } else {
            dEUVRecipientTP.setFileNumberOfStatementOfContributions(fileNumber);
        }
        dEUVRecipientTP.makeSaveable();
    }

    private void createDEUVSending(DEUVSOCDataTransferBean dEUVSOCDataTransferBean, String fileNumberString) {
        DEUVSending deuvSending = new DEUVSending();
        deuvSending.setOidDEUVSender(this.mDEUVSender.getObjectid());
        deuvSending.setOidDEUVRecipient(this.mOidDEUVRecipient);
        deuvSending.setOidPCompany(dEUVSOCDataTransferBean.getOidPCompany());
        deuvSending.setOidPlant("");
        deuvSending.setOidHealthFund(dEUVSOCDataTransferBean.getOidHealthFund());
        deuvSending.setOidCostcenter("");
        deuvSending.setOidCostunit("");
        deuvSending.setOidDepartment("");
        deuvSending.setOidEmployeecircle("");
        deuvSending.setOidOrgunit("");
        deuvSending.setOidPersonincharge1("");
        deuvSending.setOidPersonincharge2("");
        deuvSending.setCompanyDescription(dEUVSOCDataTransferBean.getBAGName1());
        deuvSending.setPlantDescription(dEUVSOCDataTransferBean.getBAGName1());
        deuvSending.setDEUVRecipientDescription(this.mField_Empfaenger);
        deuvSending.setDEUVSenderDescription(this.mField_Absender);
        deuvSending.setDateofSending(dEUVSOCDataTransferBean.getForValidDate());
        deuvSending.setDateCreatedOn(new Date());
        deuvSending.setCurrentFileNumber(Integer.parseInt(fileNumberString));
        if (this.mKVDRDataTransfer) {
            deuvSending.setTypeofsending(TypeOfSendingEnum.TOSE_BEITRAGSNACHWEIS_KVDR);
        } else {
            deuvSending.setTypeofsending(TypeOfSendingEnum.TOSE_BEITRAGSNACHWEIS);
        }
        int serialNumber = this.getMaxDeuvSendingSerialNumber(deuvSending.getTypeofsending());
        deuvSending.setSerialNumber(++serialNumber);
        deuvSending.isNew();
        deuvSending.makeSaveable();
    }

    private int getMaxDeuvSendingSerialNumber(TypeOfSendingEnum typeOfSendingE) {
        PersistencyDataSet deuvsendingDatas;
        String typeOfSending = Integer.toString(TypeOfSendingEnumMapper.toInt((TypeOfSendingEnum)typeOfSendingE));
        Criterion filterStructs = Restrictions.and((Criterion)Restrictions.eq((String)"oiddeuvsender", (String)this.mDEUVSender.getObjectid()), (Criterion)Restrictions.eq((String)"typeofsending", (String)typeOfSending));
        Order[] sortierungStruct = new Order[]{Order.desc((String)"serialnumber")};
        try {
            deuvsendingDatas = daoDeuvsending.getDataSet(sortierungStruct, filterStructs);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (deuvsendingDatas != null && deuvsendingDatas.hasNext()) {
            int serialnumber = ((DeuvsendingContainer)deuvsendingDatas.getNext()).serialnumber;
            if (serialnumber < 0) {
                return 0;
            }
            return serialnumber;
        }
        return 0;
    }

    private void setReportHeaderFields(DEUVSOCDataTransferBean dEUVSOCDataTransferBean, String fileNumberString) {
        this.mField_Absender = this.mDeuvSenderTP.getName();
        this.mField_Empfaenger = dEUVSOCDataTransferBean.getDEUVRecipientName();
        this.mField_Dateiname = this.mReportDataTransfer.getFFile().getPath();
        this.mField_BetriebsNrAbsender = dEUVSOCDataTransferBean.getBAbsenderNr();
        this.mField_BetriebsNrEmpfaenger = dEUVSOCDataTransferBean.getVEmpfaengerNr();
        this.mField_DateiNr = fileNumberString;
        this.mField_Kassenart = DEUVDataTransferHelper.getNeededDEUVRecipientName((String)dEUVSOCDataTransferBean.getDEUVEmpfaengerForSort());
    }

    private void buildEmployerHealthFundSubreportList(DEUVSOCDataTransferBean dEUVSOCDataTransferBean) {
        ++this.mCountDatas;
        DEUVStatementOfContributionSubreportBean dEUVStatementOfContributionSubreportBean = new DEUVStatementOfContributionSubreportBean(dEUVSOCDataTransferBean.getArbeitgeberVWENr() + " / ", dEUVSOCDataTransferBean.getBRechtskreis() + " / ", dEUVSOCDataTransferBean.getBArbeitgeberBetriebsnummerNr() + " / ", dEUVSOCDataTransferBean.getBAGName1() + (String)(StringMapper.isNullString((String)dEUVSOCDataTransferBean.getBAGName2()) ? "" : " " + dEUVSOCDataTransferBean.getBAGName2()), dEUVSOCDataTransferBean.getBKrKEmpfaengerBetriebsNr() + " / ", dEUVSOCDataTransferBean.getKrankenkasseBezeichnung(), dEUVSOCDataTransferBean.getMonat(), ReportHelper.toCurrencyFormat((Object)dEUVSOCDataTransferBean.getBZahlbetragBD()));
        this.mEmployerHealthfundSubreportLi.add(dEUVStatementOfContributionSubreportBean);
        if (StringMapper.equal((String)dEUVSOCDataTransferBean.getBKrKEmpfaengerBetriebsNr(), (String)"98000001") || StringMapper.equal((String)dEUVSOCDataTransferBean.getBKrKEmpfaengerBetriebsNr(), (String)"98000006")) {
            this.mEmployerHealthfundSubreportLi.add(new DEUVStatementOfContributionSubreportBean("", "", "", "", "", "davon pausch.St. " + dEUVSOCDataTransferBean.getBSteuernummer(), "", ReportHelper.toCurrencyFormat((Object)dEUVSOCDataTransferBean.getBPauschStBD())));
            this.mBundesKnappschaftBD = this.mBundesKnappschaftBD.add(dEUVSOCDataTransferBean.getBZahlbetragBD());
            if (!this.mDEUVRecipientDataTransferBeansIt.hasNext()) {
                this.mEmployerHealthfundSubreportLi.add(new DEUVStatementOfContributionSubreportBean("", "", "", "", "", "Bundesknappschaft", "", ReportHelper.toCurrencyFormat((Object)this.mBundesKnappschaftBD)));
                this.mBundesKnappschaftBD = BigDecimal.valueOf(0L, 2);
            }
        }
    }

    private boolean isFileInPerfidiaSendQExsitant(String dEUVRecipientsKey, String fileNumberString) throws BusinessDomainException {
        return this.mReportDataTransfer.isFileExistant(dEUVRecipientsKey, fileNumberString);
    }

    private void initNewFile(String dEUVRecipientsKey, String fileNumberString) throws BusinessDomainException {
        File destination = this.mReportDataTransfer.getFile(dEUVRecipientsKey, fileNumberString);
        this.mReportDataTransfer.setFFile(destination);
        this.mDateiEinschreiben = this.mPerfidiaResult.initPerfidiaFile(destination);
    }

    public void setDataTransferBeanInProperHM() {
        this.mDEUVRecipientsDataTransferBeansHM = new HashMap<String, List<DEUVSOCDataTransferBean>>();
        for (DEUVSOCDataTransferBean dEUVSOCDataTransferBean : this.mSOCPDataTransferBeanLi) {
            String dEUVRecipient = dEUVSOCDataTransferBean.getVEmpfaengerNr();
            List<DEUVSOCDataTransferBean> dEUVSOCDataTransferBeanLi = this.mDEUVRecipientsDataTransferBeansHM.get(dEUVRecipient);
            if (dEUVSOCDataTransferBeanLi == null) {
                dEUVSOCDataTransferBeanLi = new LinkedList<DEUVSOCDataTransferBean>();
                this.mDEUVRecipientsDataTransferBeansHM.put(dEUVRecipient, dEUVSOCDataTransferBeanLi);
            }
            dEUVSOCDataTransferBeanLi.add(dEUVSOCDataTransferBean);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug(ReflectionToStringBuilder.toString((Object)dEUVSOCDataTransferBean));
        }
    }

    private DEUVRecipientTP getDEUVRecipientTP(String standardCompanyNumber) throws BusinessDomainException {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oiddeuvsender", (String)this.mDEUVSender.getObjectid()), Restrictions.eq((String)"STDCOMPANYNUMBER", (String)standardCompanyNumber), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())});
        DEUVRecipientTP[] dEUVRecipientTPs = DEUVRecipientTPPersistencyManager.queryAll(null, (Criterion)filter);
        if (dEUVRecipientTPs.length == 0) {
            String healthFundType = DEUVDataTransferHelper.getNeededDEUVRecipientName((String)standardCompanyNumber);
            throw DEUVExceptionMapper.makeNoDEUVRecipientForTypeOfHealthFundDomainException((String)healthFundType);
        }
        this.mOidDEUVRecipient = dEUVRecipientTPs[0].getDEUVRecipient().getObjectid();
        return dEUVRecipientTPs[0];
    }

    private void appendBeitragsnachweisSatz(StringBuilder sBuffer, DEUVSOCDataTransferBean dBean) {
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBKennung(), (int)4));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBVerfIntMerkmal(), (int)5));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBAbsenderNr(), (int)15));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBKrKEmpfaengerBetriebsNr(), (int)15));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBVersion(), (int)2));
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBErstellungsdatum(), (int)20));
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBKennzeichen3(), (int)1));
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBKennzeichen3(), (int)1));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)20));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)20));
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBKennzeichen1(), (int)1));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBKennzeichenInsolvenz(), (int)1));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"0", (int)1));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBArbeitgeberBetriebsnummerNr(), (int)15));
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBZeitraumBeginn(), (int)8));
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBZeitraumEnde(), (int)8));
        sBuffer.append(dBean.getBVorzeichen1000());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getB1000(), (int)11));
        sBuffer.append(dBean.getBVorzeichen2000());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getB2000(), (int)11));
        sBuffer.append(dBean.getBVorzeichen3000());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getB3000(), (int)11));
        sBuffer.append(dBean.getBVorzeichen0001());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getB0001(), (int)11));
        sBuffer.append(dBean.getBVorzeichen0100());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getB0100(), (int)11));
        sBuffer.append(dBean.getBVorzeichenZusatzbeitrag());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBZusatzbeitrag(), (int)11));
        sBuffer.append(dBean.getBVorzeichen0010());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getB0010(), (int)11));
        sBuffer.append(dBean.getBVorzeichen0300());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getB0300(), (int)11));
        sBuffer.append(dBean.getBVorzeichen0050());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getB0050(), (int)11));
        sBuffer.append(dBean.getBVorzeichen0020());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getB0020(), (int)11));
        sBuffer.append(dBean.getBVorzeichenU1());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBU1(), (int)11));
        sBuffer.append(dBean.getBVorzeichenU2());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBU2(), (int)11));
        sBuffer.append(dBean.getBVorzeichen6000());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getB6000(), (int)11));
        sBuffer.append(dBean.getBVorzeichen0500());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getB0500(), (int)11));
        sBuffer.append(dBean.getBVorzeichen0600());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getB0600(), (int)11));
        sBuffer.append(dBean.getBVorzeichenGesamtsumme());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBGesamtsumme(), (int)11));
        sBuffer.append(dBean.getBVorzeichenFreiwKV());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBFreiwKV(), (int)11));
        sBuffer.append(dBean.getBVorzeichenFreiwPV());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBFreiwPV(), (int)11));
        sBuffer.append(dBean.getBVorzeichenLFZG());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBLFZG(), (int)11));
        sBuffer.append(dBean.getBVorzeichenFwZusatzbeitrag());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBFwZusatzbeitrag(), (int)11));
        sBuffer.append(dBean.getBVorzeichenBetrag2());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBBetrag2(), (int)11));
        sBuffer.append(dBean.getBVorzeichenBetrag3());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBBetrag3(), (int)11));
        sBuffer.append(dBean.getBVorzeichenZahlbetrag());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBZahlbetrag(), (int)11));
        if (DateHelper.afterOrEqual((Date)this.mDate, (Date)new VDate(2026, 0, 1).getDate())) {
            sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)36));
        } else {
            sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)32));
            sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)"0", (int)4));
        }
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBAGName1(), (int)30));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBAGName2(), (int)30));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBAGStrassePostfach(), (int)30));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBNationalitaetAnschrift(), (int)3));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBAGPLZ(), (int)10));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBAGOrt(), (int)25));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBAbrechnnungsstelle1(), (int)15));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBAbrechnnungsstelle2(), (int)15));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBOrdnungsmerkmal(), (int)20));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBVerarbeitungsmerkmal(), (int)1));
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBKVBeitragSatzAllg(), (int)4));
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBKVBeitragSatzErh(), (int)4));
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBKVBeitragSatzErm(), (int)4));
        if (DateHelper.afterOrEqual((Date)this.mDate, (Date)new VDate(2026, 0, 1).getDate())) {
            sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)1));
        } else {
            sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBRechtskreis(), (int)1));
        }
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBKennzeichenU12(), (int)1));
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBLfdNummer(), (int)3));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBWaehrung(), (int)1));
        sBuffer.append(dBean.getBVorzeichenPauschSt());
        sBuffer.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)dBean.getBPauschSt(), (int)11));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getBSteuernummer(), (int)20));
    }

    private void appendVorlaufSatz(StringBuilder sBuffer, DEUVSOCDataTransferBean dBean, String fileNumber) {
        DEUVDataTransferHelper.appendVorlaufSatz((StringBuilder)sBuffer, (DEUVSOCDataTransferBean)dBean, (String)fileNumber);
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getVAbsender(), (int)50));
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getVVersionNr(), (int)2));
    }

    private void appendNachlaufSatz(StringBuilder sBuffer, DEUVSOCDataTransferBean dBean, String fileNumber, int counterDatas) {
        DEUVDataTransferHelper.appendNachlaufSatz((StringBuilder)sBuffer, (DEUVSOCDataTransferBean)dBean, (String)fileNumber, (int)counterDatas);
        sBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)dBean.getNVersion(), (int)2));
    }

    private ReportFirstFilterStruct getReportFirstFilterStruct(String oidPCompany) {
        ReportFirstFilterStruct struct = new ReportFirstFilterStruct();
        struct.oidPCompany = oidPCompany;
        return struct;
    }

    private ReportSortStruct[] getReportSortStruct() {
        return new ReportSortStruct[0];
    }

    private DEUVSenderTP getDEUVSenderTP(String oidPCompnay, Date forEffectiveDate, Date forValidDate) throws BusinessDomainException {
        this.mDEUVSender = this.getDEUVSender(oidPCompnay, forEffectiveDate, forValidDate);
        DEUVSenderTP deuvSenderTP = null;
        try {
            deuvSenderTP = this.mDEUVSender.getDEUVSenderTP(forEffectiveDate, forValidDate);
        }
        catch (BusinessDomainException e) {
            ExceptionMapper.printException((Throwable)e);
            throw DEUVExceptionMapper.makeNoDEUVSenderTPDomianException((String)DateMapper.toDDMMYYYYPointSeparationString((Date)forEffectiveDate));
        }
        return deuvSenderTP;
    }

    private void setDEUVSenderStdCompanyNumber(String oidPCompany, Date forEffectiveDate, Date forValidDate) throws BusinessDomainException {
        this.mDeuvSenderTP = this.getDEUVSenderTP(oidPCompany, forEffectiveDate, forValidDate);
        this.mDEUVSenderStdCompanyNumber = this.mDeuvSenderTP.getStdCompanyNumber();
        this.mDEUVSenderDescription = this.mDeuvSenderTP.getName();
    }

    private DEUVSender getDEUVSender(String oidPCompnay, Date forEffectiveDate, Date forValidDate) throws BusinessDomainException {
        DEUVSender dEUVSender = null;
        try {
            dEUVSender = PCompanyPersistencyManager.getPCompany((String)oidPCompnay).getCompanySettings(forEffectiveDate, forValidDate).getDEUVSender();
        }
        catch (BusinessDomainException e) {
            ExceptionMapper.printException((Throwable)e);
            throw DEUVExceptionMapper.makeNoDEUVSenderToSelectedCompanyDomainException();
        }
        return dEUVSender;
    }

    private void initReportFields() {
        this.mCountDatas = 0;
        staticReportTitel = this.mKVDRDataTransfer ? "Daten\u00fcbermittlung                  Beitragsnachweise KVDR" : "Daten\u00fcbermittlung                  Beitragsnachweise";
        staticColumnHeaderFirma = "Firmen-Nr. / Rechtskreis / Betriebs-Nr. / Firma";
        staticColumnHeaderKrK = "Betriebs-Nr. / Krankenkasse";
        staticColumnHeaderMonat = "Monat";
        staticColumnHeaderSumme = "Summe";
        staticCompany = "DE\u00dcV-Absender";
        staticWaehrung = "W\u00e4hrung";
        staticDatum = "Datum";
        staticBenutzer = "Benutzer";
        staticSeite = "Seite";
        staticAbsender = "DE\u00dcV-Absender: ";
        staticEmpfaenger = "DE\u00dcV-Empf\u00e4nger:";
        staticDateiname = "Dateipfad /-name:";
        staticBetriebsNrAbsender = "Betriebs-Nr. Absender: ";
        staticBetriebsNrEmpfaenger = "Betriebs-Nr. Empf\u00e4nger: ";
        staticDateiNr = "Dateinummer:";
        staticKassenart = "Kassenart:";
        this.mUserID = SessionContext.getInstance().getSession().getUserCode();
    }

    public Map<String, Object> getParameters() {
        JasperParameterHashMap parameters = new JasperParameterHashMap();
        parameters.put(STATIC_TEXT_PARAMETER_staticColumnHeaderFirma, staticColumnHeaderFirma);
        parameters.put(STATIC_TEXT_PARAMETER_staticColumnHeaderKrK, staticColumnHeaderKrK);
        parameters.put(STATIC_TEXT_PARAMETER_staticColumnHeaderMonat, staticColumnHeaderMonat);
        parameters.put(STATIC_TEXT_PARAMETER_staticColumnHeaderSumme, staticColumnHeaderSumme);
        parameters.put(STATIC_TEXT_PARAMETER_staticDEUEVMeldungen, staticReportTitel);
        parameters.put(STATIC_TEXT_PARAMETER_staticCompany, staticCompany);
        parameters.put(STATIC_TEXT_PARAMETER_staticWaehrung, staticWaehrung);
        parameters.put(STATIC_TEXT_PARAMETER_staticDatum, staticDatum);
        parameters.put(STATIC_TEXT_PARAMETER_staticBenutzer, staticBenutzer);
        parameters.put(STATIC_TEXT_PARAMETER_staticSeite, staticSeite);
        parameters.put(STATIC_TEXT_PARAMETER_staticAbsender, staticAbsender);
        parameters.put(STATIC_TEXT_PARAMETER_staticEmpfaenger, staticEmpfaenger);
        parameters.put(STATIC_TEXT_PARAMETER_staticDateiname, staticDateiname);
        parameters.put(STATIC_TEXT_PARAMETER_staticBetriebsNrAbsender, staticBetriebsNrAbsender);
        parameters.put(STATIC_TEXT_PARAMETER_staticBetriebsNrEmpfaenger, staticBetriebsNrEmpfaenger);
        parameters.put(STATIC_TEXT_PARAMETER_staticDateiNr, staticDateiNr);
        parameters.put(STATIC_TEXT_PARAMETER_staticKassenart, staticKassenart);
        return parameters;
    }

    private void resetReportValues() {
        this.mEmployerHealthfundSubreportLi.clear();
        this.mField_Absender = "";
        this.mField_Empfaenger = "";
        this.mField_Dateiname = "";
        this.mField_BetriebsNrAbsender = "";
        this.mField_BetriebsNrEmpfaenger = "";
        this.mField_DateiNr = "";
        this.mField_Kassenart = "";
    }

    private void closeDateienBufferedWriter() throws IOException {
        for (BufferedWriter dateiSchreibenBufferedWriter : this.mDateienBufferedWriterLi) {
            dateiSchreibenBufferedWriter.close();
        }
    }

    public int getCountIterations() {
        return this.mCountIterations;
    }

    public boolean next() throws JRException {
        try {
            if (this.mDEUVRecipientsIt != null) {
                if (this.mDEUVRecipientsIt.hasNext()) {
                    if (!this.mFirstPurchase) {
                        this.mDateienBufferedWriterLi.add(this.mDateiEinschreiben);
                    }
                    this.mFirstPurchase = false;
                    this.resetReportValues();
                    String dEUVRecipientsKey = this.mDEUVRecipientsIt.next();
                    List<DEUVSOCDataTransferBean> dEUVRecipientDataTransferBeansLi = this.mDEUVRecipientsDataTransferBeansHM.get(dEUVRecipientsKey);
                    if (dEUVRecipientDataTransferBeansLi != null) {
                        dEUVRecipientDataTransferBeansLi = this.buildDEUVRecipientFile(dEUVRecipientDataTransferBeansLi, dEUVRecipientsKey);
                    }
                    this.mDEUVRecipientsDataTransferBeansHM.put(dEUVRecipientsKey, dEUVRecipientDataTransferBeansLi);
                    this.mProgressBar.update();
                    return true;
                }
                this.mDateienBufferedWriterLi.add(this.mDateiEinschreiben);
                this.closeDateienBufferedWriter();
                this.createEmptySendings();
                return false;
            }
            if (this.mEnd) {
                return false;
            }
            this.createEmptySendings();
            this.mField_Absender = "Keine Daten f\u00fcr " + DateMapper.toMMYYYYPointSeparationString((Date)this.mDate) + " vorhanden!!!";
            this.mField_Empfaenger = "Keine Daten f\u00fcr " + DateMapper.toMMYYYYPointSeparationString((Date)this.mDate) + " vorhanden!!!";
            this.mField_Dateiname = "Keine Daten f\u00fcr " + DateMapper.toMMYYYYPointSeparationString((Date)this.mDate) + " vorhanden!!!";
            this.mEnd = true;
            return true;
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Exception t) {
            throw new JRException((Throwable)t);
        }
    }

    private void createEmptySendings() throws BusinessDomainException {
        if (!this.mOidPCompanyList.isEmpty()) {
            for (String oidPCompany : this.mOidPCompanyList) {
                DEUVSending[] deuvSendings;
                if (this.emptySettingExists(oidPCompany)) {
                    PCompany pCompany = new PCompany(oidPCompany);
                    throw SOCRExceptionMapper.makeBeitragssollExistent((String)("\n" + DateMapper.toMMYYYYPointSeparationString((Date)this.mDate) + " / " + pCompany.getPCompanyKey() + " " + pCompany.getActiveCompanyFoundation().getFoundations().getShortDescription() + "\n\nBitte aktualisieren Sie den Dialog."));
                }
                for (DEUVSending deuvSending : deuvSendings = DEUVSendingPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oiddeuvsender", (String)this.mDEUVSender.getObjectid()), Restrictions.eq((String)"dateofsending", (String)DateMapper.toString((Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mDate)))), Restrictions.eq((String)"typeofsending", (String)(this.mKVDRDataTransfer ? "0" : "1")), Restrictions.eq((String)"oidpcompany", (String)oidPCompany)}))) {
                    DEUVSending newDeuvSending = new DEUVSending();
                    newDeuvSending.setOidDEUVSender(deuvSending.getOidDEUVSender());
                    newDeuvSending.setOidDEUVRecipient(deuvSending.getOidDEUVRecipient());
                    newDeuvSending.setOidPCompany(deuvSending.getOidPCompany());
                    newDeuvSending.setOidPlant(deuvSending.getOidPlant());
                    newDeuvSending.setOidHealthFund(deuvSending.getOidHealthFund());
                    newDeuvSending.setOidCostcenter(deuvSending.getOidCostcenter());
                    newDeuvSending.setOidCostunit(deuvSending.getOidCostunit());
                    newDeuvSending.setOidDepartment(deuvSending.getOidDepartment());
                    newDeuvSending.setOidEmployeecircle(deuvSending.getOidEmployeecircle());
                    newDeuvSending.setOidOrgunit(deuvSending.getOidOrgunit());
                    newDeuvSending.setOidPersonincharge1(deuvSending.getOidPersonincharge1());
                    newDeuvSending.setOidPersonincharge2(deuvSending.getOidPersonincharge2());
                    newDeuvSending.setCompanyDescription(deuvSending.getCompanyDescription());
                    newDeuvSending.setPlantDescription(deuvSending.getPlantDescription());
                    newDeuvSending.setDEUVRecipientDescription(deuvSending.getDEUVRecipientDescription());
                    newDeuvSending.setDEUVSenderDescription(deuvSending.getDEUVSenderDescription());
                    newDeuvSending.setDateofSending(DateHelper.getLastDayOfMonth((Date)this.mDate));
                    newDeuvSending.setDateCreatedOn(new Date());
                    newDeuvSending.setCurrentFileNumber(deuvSending.getCurrentFileNumber());
                    newDeuvSending.setTypeofsending(deuvSending.getTypeofsending());
                    newDeuvSending.setSerialNumber(deuvSending.getSerialNumber());
                    newDeuvSending.isNew();
                    newDeuvSending.makeSaveable();
                }
            }
        }
    }

    private boolean emptySettingExists(String oidPCompany) {
        DEUVSending[] deuvSendings = DEUVSendingPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oiddeuvsender", (String)this.mDEUVSender.getObjectid()), Restrictions.eq((String)"dateofsending", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mDate))), Restrictions.eq((String)"typeofsending", (String)(this.mKVDRDataTransfer ? "0" : "1")), Restrictions.eq((String)"oidpcompany", (String)oidPCompany)}));
        return deuvSendings.length > 0;
    }

    private void deleteInsuranceDues(String[] oidPCompanyies, Date forValidDate) throws BusinessDomainException {
        InsuranceDues[] insuranceDues;
        Conjunction filterStructs = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.in((String)"oidpcompany", (String[])oidPCompanyies), Restrictions.le((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)forValidDate))), Restrictions.ge((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)forValidDate)))});
        for (InsuranceDues insDues : insuranceDues = InsuranceDuesPersistencyManager.query(null, (Criterion)filterStructs)) {
            insDues.makeSaveable();
            insDues.destroy();
        }
        LOGGER.info("############################## Fuer den Zeitpunkt " + DateMapper.toDDMMYYYYPointSeparationString((Date)forValidDate) + " wurden Daten aus der Tabelle INSURANCEDUES_T geloescht!!!");
    }

    private void deleteInsuranceDsbn(String[] oidPCompanyies, Date forValidDate) throws BusinessDomainException {
        InsuranceDsbn[] insuranceDsbns;
        Conjunction filterStructs = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.in((String)"oidpcompany", (String[])oidPCompanyies), Restrictions.le((String)"zrend", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)forValidDate))), Restrictions.ge((String)"zrbeg", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)forValidDate)))});
        for (InsuranceDsbn insuranceDsbn : insuranceDsbns = InsuranceDsbnPersistencyManager.query(null, (Criterion)filterStructs)) {
            insuranceDsbn.makeSaveable();
            insuranceDsbn.destroy();
        }
        LOGGER.info("############################## Fuer den Zeitpunkt " + DateMapper.toDDMMYYYYPointSeparationString((Date)forValidDate) + " wurden Daten aus der Tabelle INSURANCEDSBN_T geloescht!!!");
    }

    public Object getFieldValue(JRField field) throws JRException {
        String fieldName = field.getName();
        if (fieldName.equals("Field_Company")) {
            return this.mField_Absender;
        }
        if (fieldName.equals("Field_Waehrung")) {
            return "Euro";
        }
        if (fieldName.equals("Field_Datum")) {
            return DateMapper.toDDMMYYYYPointSeparationString((Date)new Date());
        }
        if (fieldName.equals("Field_Benutzer")) {
            return this.mUserID;
        }
        if (fieldName.equals("AG_KrK_subreport_Bean")) {
            return this.mEmployerHealthfundSubreportLi;
        }
        if (fieldName.equals("Field_Absender")) {
            return this.mField_Absender;
        }
        if (fieldName.equals("Field_Empfaenger")) {
            return this.mField_Empfaenger;
        }
        if (fieldName.equals("Field_Dateiname")) {
            return this.mField_Dateiname;
        }
        if (fieldName.equals("Field_BetriebsNrAbsender")) {
            return this.mField_BetriebsNrAbsender;
        }
        if (fieldName.equals("Field_BetriebsNrEmpfaenger")) {
            return this.mField_BetriebsNrEmpfaenger;
        }
        if (fieldName.equals("Field_DateiNr")) {
            return this.mField_DateiNr;
        }
        if (fieldName.equals("Field_Kassenart")) {
            return this.mField_Kassenart;
        }
        if (fieldName.equals("Field_CountDatas")) {
            return Integer.toString(this.mCountDatas);
        }
        return "";
    }

    public int getCountDatas() {
        return this.mCountDatas;
    }

    public void saveInsuranceDsbns() {
        for (InsuranceDsbn insuranceDsbn : this.mInsuranceDsbnLi) {
            insuranceDsbn.makeSaveable();
        }
    }
}

