/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.global.accidentinsurancefund.imports.xml;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencySession;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFund;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFundPersistencyManager;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFundTP;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFundTPPersistencyManager;
import com.varial.personnel.domain.global.accidentinsurancefund.imports.ImportedRoot;
import com.varial.personnel.domain.global.accidentinsurancefund.imports.ImportedTP;
import com.varial.personnel.domain.global.accidentinsurancefund.imports.Uvsd;
import com.varial.personnel.domain.global.accidentinsurancefund.imports.UvsdComparator;
import com.varial.personnel.domain.global.accidentinsurancefund.mapper.AccidentInsuranceFundExceptionMapper;
import com.varial.personnel.domain.global.masterdata.xmlimport.XmlImport;
import com.varial.personnel.domain.reports.Progressbar;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.serverbase.basictypes.VDate;
import de.gkv.masterdata.version1.Stammdatendatei;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AIFXmlImport
extends XmlImport {
    private final Date mValidFrom;
    private final Set<ImportedRoot> mImporteds;
    private final Set<ImportedRoot> mUpdateds;
    private Set<String> mKeys;

    public AIFXmlImport(Stammdatendatei stammdatendatei, Date validFrom) {
        super(stammdatendatei);
        this.mValidFrom = validFrom;
        this.mImporteds = new HashSet<ImportedRoot>();
        this.mUpdateds = new HashSet<ImportedRoot>();
    }

    public void create() throws BusinessDomainException {
        if (DateHelper.before((Date)this.mValidFrom, (Date)new VDate(new VDate().getYear() - 1, 0, 1).getDate())) {
            throw AccidentInsuranceFundExceptionMapper.makeThisValidfromIsNotAllowedDomainException();
        }
        ArrayList<Uvsd> uvsdList = new ArrayList<Uvsd>();
        for (Stammdatendatei.Unfallversicherung.StammdatenUVTraeger stammdatenUVTraeger : this.mMasterdata.getUnfallversicherung().getStammdatenUVTraeger()) {
            for (Date date : this.getDates(stammdatenUVTraeger, AIFXmlImport.toDate(stammdatenUVTraeger.getGueltigAb()))) {
                Stammdatendatei.Unfallversicherung.StammdatenUVTraeger.Abrechnungswerte abrechnW = this.getAbrechnW(date, stammdatenUVTraeger);
                Uvsd sd = new Uvsd(stammdatenUVTraeger, date, abrechnW, this.getVarw(date));
                uvsdList.add(sd);
            }
        }
        Collections.sort(uvsdList, new UvsdComparator());
        for (Uvsd uvsd : uvsdList) {
            ImportedRoot root = this.getRoot(uvsd.getBbnrUV());
            root.updateTimePeriods(uvsd, this.mValidFrom);
        }
    }

    private ImportedRoot getRoot(String bbnruv) {
        ImportedRoot tmp = new ImportedRoot(bbnruv);
        for (ImportedRoot each : this.mImporteds) {
            if (!each.equals((Object)tmp)) continue;
            return each;
        }
        this.mImporteds.add(tmp);
        return tmp;
    }

    public void resume(PersistencySession context) throws BusinessDomainException {
        this.resume(context, null);
    }

    public void resume(PersistencySession context, Progressbar<?> progressbar) throws BusinessDomainException {
        Progressbar.setTotal(progressbar, this.mImporteds);
        for (ImportedRoot each : this.mImporteds) {
            this.update(context, each);
            Progressbar.nextProcessed(progressbar);
        }
        this.mImporteds.removeAll(this.mUpdateds);
        Progressbar.setTotal(progressbar, this.mImporteds);
        for (ImportedRoot each : this.mImporteds) {
            this.create(context, each);
            Progressbar.nextProcessed(progressbar);
        }
    }

    private void create(PersistencySession context, ImportedRoot imported) throws BusinessDomainException {
        AccidentInsuranceFund bo = new AccidentInsuranceFund();
        bo.setAccidentInsuranceFundKey(this.getNextKey());
        for (ImportedTP each : imported.getTimePeriods()) {
            AccidentInsuranceFundTP tp = new AccidentInsuranceFundTP(bo);
            each.fillImportedValues(tp);
        }
        context.flush();
        this.getKeys().add(bo.getAccidentInsuranceFundKey());
    }

    private String getNextKey() {
        for (int i = 1; i < 1000; ++i) {
            String key = String.format("%04d", i);
            if (this.getKeys().contains(key)) continue;
            return key;
        }
        throw new IllegalStateException("Could not found key between 0001 and 9999.");
    }

    private Set<String> getKeys() {
        if (this.mKeys == null) {
            this.mKeys = new HashSet<String>();
            for (AccidentInsuranceFund each : AccidentInsuranceFundPersistencyManager.query(null, null)) {
                this.mKeys.add(each.getAccidentInsuranceFundKey());
            }
        }
        return this.mKeys;
    }

    private void update(PersistencySession context, ImportedRoot imported) throws BusinessDomainException {
        for (AccidentInsuranceFundTP each : AccidentInsuranceFundTPPersistencyManager.queryAll(null, (Criterion)Restrictions.eq((String)"STDCOMPNOACCINS", (String)imported.getIdentifier()))) {
            AccidentInsuranceFund aif = each.getAccidentInsuranceFund();
            this.update(context, imported, aif.getObjectid());
            this.mUpdateds.add(imported);
        }
    }

    private void update(PersistencySession context, ImportedRoot imported, String objectid) throws BusinessDomainException {
        for (ImportedTP each : imported.getTimePeriods()) {
            AccidentInsuranceFund reloaded = AccidentInsuranceFund.getAccidentInsuranceFund((String)objectid);
            AccidentInsuranceFundTP tp = reloaded.getAccidentInsuranceFundTP(VDate.getDateMax(), VDate.getDateMax());
            if (DateHelper.equal((Date)tp.getValidFrom(), (Date)each.getValidFrom())) {
                Date oldEffectiveFrom = tp.getEffectiveFrom();
                each.update(tp, tp.getClassesOfRisk());
                tp.registerForFirstExecute();
                reloaded.setHistory((PersonnelTimedPersistenceObject)tp, false, oldEffectiveFrom);
            } else {
                AccidentInsuranceFundTP insert = new AccidentInsuranceFundTP(reloaded);
                each.update(insert, tp.getClassesOfRisk());
                reloaded.addHistory((PersonnelTimedPersistenceObject)insert, true);
            }
            context.flush();
        }
    }

    private Stammdatendatei.Unfallversicherung.Vollarbeiterrichtwert getVarw(Date begin) {
        for (Stammdatendatei.Unfallversicherung.Vollarbeiterrichtwert each : this.mMasterdata.getUnfallversicherung().getVollarbeiterrichtwert()) {
            Date gueltigAb = AIFXmlImport.toDate(each.getGueltigAb());
            if (gueltigAb == null || gueltigAb.compareTo(begin) > 0) continue;
            return each;
        }
        return null;
    }

    private List<Date> getDates(Stammdatendatei.Unfallversicherung.StammdatenUVTraeger uv, Date from) {
        Date date;
        ArrayList<Date> result = new ArrayList<Date>();
        for (Stammdatendatei.Unfallversicherung.StammdatenUVTraeger.Abrechnungswerte each : uv.getAbrechnungswerte()) {
            date = AIFXmlImport.toDate(each.getGueltigAb());
            if (date == null || result.contains(date) || !DateHelper.afterOrEqual((Date)date, (Date)from)) continue;
            result.add(date);
        }
        for (Stammdatendatei.Unfallversicherung.StammdatenUVTraeger.Abrechnungswerte each : this.mMasterdata.getUnfallversicherung().getVollarbeiterrichtwert()) {
            date = AIFXmlImport.toDate(each.getGueltigAb());
            if (date == null || result.contains(date) || !DateHelper.afterOrEqual((Date)date, (Date)from)) continue;
            result.add(date);
        }
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    private Stammdatendatei.Unfallversicherung.StammdatenUVTraeger.Abrechnungswerte getAbrechnW(Date begin, Stammdatendatei.Unfallversicherung.StammdatenUVTraeger uv) {
        for (Stammdatendatei.Unfallversicherung.StammdatenUVTraeger.Abrechnungswerte each : uv.getAbrechnungswerte()) {
            Date gueltigAb = AIFXmlImport.toDate(each.getGueltigAb());
            if (gueltigAb == null || gueltigAb.compareTo(begin) > 0) continue;
            return each;
        }
        return null;
    }

    public int getImported() {
        return this.mImporteds.size();
    }

    public int getUpdated() {
        return this.mUpdateds.size();
    }
}

