/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eubp.dsbn;

import com.varial.base.BigDecimalHelper;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.paymentofcontributions.insurancedsbn.InsuranceDsbn;
import com.varial.personnel.domain.eubp.EubpHelper;
import com.varial.personnel.domain.eubp.dsbn.dbrb.EubpDbrb;
import com.varial.personnel.domain.eubp.dsbn.dbsc.EubpDbsc;
import com.varial.personnel.domain.reports.reportdatatransfer.ReportDataTransfer;
import com.varial.personnel.domain.reports.statementofcontribution.StatementOfContributionSummBean;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;

public class PartDsbn {
    private String mKeart = "0";
    private int mKeinsbn;
    private String mZrbeg;
    private String mZrend;
    private BigDecimal mKvbeitr1;
    private BigDecimal mKvbeitr3;
    private BigDecimal mPvbeitr;
    private BigDecimal mRvbeitr1;
    private BigDecimal mZbp;
    private BigDecimal mAvbeitr1;
    private BigDecimal mRvbeitr3;
    private BigDecimal mInsgu;
    private BigDecimal mAvbeitr2;
    private BigDecimal mU1;
    private BigDecimal mU2;
    private BigDecimal mKvbeitr6;
    private BigDecimal mRvbeitr5;
    private BigDecimal mZws;
    private BigDecimal mKvbeitrf;
    private BigDecimal mPvbeitrf;
    private BigDecimal mErstaag;
    private BigDecimal mZbf;
    private BigDecimal mBeitr2 = BigDecimal.ZERO;
    private BigDecimal mBeitr3 = BigDecimal.ZERO;
    private BigDecimal mSum;
    private String mDsid;
    private String mVamm;
    private BigDecimal mBeitrsa;
    private BigDecimal mBeitrsh;
    private String mKennzrk;
    private String mKennzuml = "0";
    private int mLfdnr;
    private BigDecimal mBeitr;
    private String mStnr = "";
    private EubpDbsc mDbsc;
    private EubpDbrb mDbrb;

    public PartDsbn() {
    }

    public PartDsbn(InsuranceDsbn insuranceDsbn, String bbnrkk) {
        boolean isGrundstellung = PartDsbn.isGrundstellung(bbnrkk);
        this.mKeinsbn = 0;
        this.mZrbeg = DateMapper.toYYYYMMDDString((Date)insuranceDsbn.getZrbeg());
        this.mZrend = DateMapper.toYYYYMMDDString((Date)insuranceDsbn.getZrend());
        this.mKvbeitr1 = insuranceDsbn.getKvbeitr1();
        this.mKvbeitr3 = insuranceDsbn.getKvbeitr3();
        this.mPvbeitr = insuranceDsbn.getPvbeitr();
        this.mRvbeitr1 = insuranceDsbn.getRvbeitr1();
        this.mZbp = insuranceDsbn.getZbp();
        this.mAvbeitr1 = insuranceDsbn.getAvbeitr1();
        this.mRvbeitr3 = insuranceDsbn.getRvbeitr3();
        this.mInsgu = insuranceDsbn.getInsgu();
        this.mAvbeitr2 = insuranceDsbn.getAvbeitr2();
        this.mU1 = insuranceDsbn.getU1();
        this.mU2 = insuranceDsbn.getU2();
        this.mKvbeitr6 = isGrundstellung ? BigDecimal.ZERO : insuranceDsbn.getKvbeitr6();
        this.mRvbeitr5 = isGrundstellung ? BigDecimal.ZERO : insuranceDsbn.getRvbeitr5();
        this.mZws = BigDecimalHelper.sum((BigDecimal[])new BigDecimal[]{this.mKvbeitr1, this.mKvbeitr3, this.mPvbeitr, this.mRvbeitr1, this.mZbp, this.mAvbeitr1, this.mRvbeitr3, this.mInsgu, this.mAvbeitr2, this.mU1, this.mU2, this.mKvbeitr6, this.mRvbeitr5});
        this.mKvbeitrf = insuranceDsbn.getKvbeitrf();
        this.mPvbeitrf = insuranceDsbn.getPvbeitrf();
        this.mErstaag = insuranceDsbn.getErstaag();
        this.mZbf = insuranceDsbn.getZbf();
        this.mBeitr2 = insuranceDsbn.getBeitr2();
        this.mBeitr3 = insuranceDsbn.getBeitr3();
        this.mSum = insuranceDsbn.getSumm();
        this.mDsid = "";
        this.mVamm = "";
        this.mBeitrsa = insuranceDsbn.getBeitrsa();
        this.mBeitrsh = insuranceDsbn.getBeitrsh();
        this.mKennzrk = insuranceDsbn.getKennzrk();
        this.mLfdnr = 1;
        BigDecimal bigDecimal = this.mBeitr = isGrundstellung ? BigDecimal.ZERO : insuranceDsbn.getBeitr();
        if (insuranceDsbn.hasDifference()) {
            this.mDbsc = new EubpDbsc(insuranceDsbn);
            this.mDbrb = new EubpDbrb(insuranceDsbn);
        }
    }

    public String getKeart() {
        return this.mKeart;
    }

    public void setKeart(String keart) {
        this.mKeart = keart;
    }

    public int getKeinsbn() {
        return this.mKeinsbn;
    }

    public void setKeinsbn(int keinsbn) {
        this.mKeinsbn = keinsbn;
    }

    public String getZrbeg() {
        return this.mZrbeg;
    }

    public void setZrbeg(String zrbeg) {
        this.mZrbeg = zrbeg;
    }

    public String getZrend() {
        return this.mZrend;
    }

    public void setZrend(String zrend) {
        this.mZrend = zrend;
    }

    public BigDecimal getKvbeitr1() {
        return this.mKvbeitr1;
    }

    public void setKvbeitr1(BigDecimal kvbeitr1) {
        this.mKvbeitr1 = kvbeitr1;
    }

    public BigDecimal getKvbeitr3() {
        return this.mKvbeitr3;
    }

    public void setKvbeitr3(BigDecimal kvbeitr3) {
        this.mKvbeitr3 = kvbeitr3;
    }

    public BigDecimal getPvbeitr() {
        return this.mPvbeitr;
    }

    public void setPvbeitr(BigDecimal pvbeitr) {
        this.mPvbeitr = pvbeitr;
    }

    public BigDecimal getRvbeitr1() {
        return this.mRvbeitr1;
    }

    public void setRvbeitr1(BigDecimal rvbeitr1) {
        this.mRvbeitr1 = rvbeitr1;
    }

    public BigDecimal getZbp() {
        return this.mZbp;
    }

    public void setZbp(BigDecimal zbp) {
        this.mZbp = zbp;
    }

    public BigDecimal getAvbeitr1() {
        return this.mAvbeitr1;
    }

    public void setAvbeitr1(BigDecimal avbeitr1) {
        this.mAvbeitr1 = avbeitr1;
    }

    public BigDecimal getRvbeitr3() {
        return this.mRvbeitr3;
    }

    public void setRvbeitr3(BigDecimal rvbeitr3) {
        this.mRvbeitr3 = rvbeitr3;
    }

    public BigDecimal getInsgu() {
        return this.mInsgu;
    }

    public void setInsgu(BigDecimal insgu) {
        this.mInsgu = insgu;
    }

    public BigDecimal getAvbeitr2() {
        return this.mAvbeitr2;
    }

    public void setAvbeitr2(BigDecimal avbeitr2) {
        this.mAvbeitr2 = avbeitr2;
    }

    public BigDecimal getU1() {
        return this.mU1;
    }

    public void setU1(BigDecimal u1) {
        this.mU1 = u1;
    }

    public BigDecimal getU2() {
        return this.mU2;
    }

    public void setU2(BigDecimal u2) {
        this.mU2 = u2;
    }

    public BigDecimal getKvbeitr6() {
        return this.mKvbeitr6;
    }

    public void setKvbeitr6(BigDecimal kvbeitr6) {
        this.mKvbeitr6 = kvbeitr6;
    }

    public BigDecimal getRvbeitr5() {
        return this.mRvbeitr5;
    }

    public void setRvbeitr5(BigDecimal rvbeitr5) {
        this.mRvbeitr5 = rvbeitr5;
    }

    public BigDecimal getZws() {
        return this.mZws;
    }

    public void setZws(BigDecimal zws) {
        this.mZws = zws;
    }

    public BigDecimal getKvbeitrf() {
        return this.mKvbeitrf;
    }

    public void setKvbeitrf(BigDecimal kvbeitrf) {
        this.mKvbeitrf = kvbeitrf;
    }

    public BigDecimal getPvbeitrf() {
        return this.mPvbeitrf;
    }

    public void setPvbeitrf(BigDecimal pvbeitrf) {
        this.mPvbeitrf = pvbeitrf;
    }

    public BigDecimal getErstaag() {
        return this.mErstaag;
    }

    public void setErstaag(BigDecimal erstaag) {
        this.mErstaag = erstaag;
    }

    public BigDecimal getZbf() {
        return this.mZbf;
    }

    public void setZbf(BigDecimal zbf) {
        this.mZbf = zbf;
    }

    public BigDecimal getBeitr2() {
        return this.mBeitr2;
    }

    public void setBeitr2(BigDecimal beitr2) {
        this.mBeitr2 = beitr2;
    }

    public BigDecimal getBeitr3() {
        return this.mBeitr3;
    }

    public void setBeitr3(BigDecimal beitr3) {
        this.mBeitr3 = beitr3;
    }

    public BigDecimal getSum() {
        return this.mSum;
    }

    public void setSum(BigDecimal sum) {
        this.mSum = sum;
    }

    public String getDsid() {
        return this.mDsid;
    }

    public void setDsid(String dsid) {
        this.mDsid = dsid;
    }

    public String getVamm() {
        return this.mVamm;
    }

    public void setVamm(String vamm) {
        this.mVamm = vamm;
    }

    public BigDecimal getBeitrsa() {
        return this.mBeitrsa;
    }

    public void setBeitrsa(BigDecimal beitrsa) {
        this.mBeitrsa = beitrsa;
    }

    public BigDecimal getBeitrsh() {
        return this.mBeitrsh;
    }

    public void setBeitrsh(BigDecimal beitrsh) {
        this.mBeitrsh = beitrsh;
    }

    public String getKennzrk() {
        return this.mKennzrk;
    }

    public void setKennzrk(String kennzrk) {
        this.mKennzrk = kennzrk;
    }

    public String getKennzuml() {
        return this.mKennzuml;
    }

    public void setKennzuml(String kennzuml) {
        this.mKennzuml = kennzuml;
    }

    public int getLfdnr() {
        return this.mLfdnr;
    }

    public void setLfdnr(int lfdnr) {
        this.mLfdnr = lfdnr;
    }

    public BigDecimal getBeitr() {
        return this.mBeitr;
    }

    public void setBeitr(BigDecimal beitr) {
        this.mBeitr = beitr;
    }

    public String getStnr() {
        return this.mStnr;
    }

    public void setStnr(String stnr) {
        this.mStnr = stnr;
    }

    public void setDbsc(EubpDbsc dbsc) {
        this.mDbsc = dbsc;
    }

    public EubpDbsc getDbsc() {
        return this.mDbsc;
    }

    public void setDbrb(EubpDbrb dbrb) {
        this.mDbrb = dbrb;
    }

    public EubpDbrb getDbrb() {
        return this.mDbrb;
    }

    public void fillEmpty(Date zrBegin) {
        this.mKeart = "0";
        this.mKeinsbn = 0;
        this.mZrbeg = DateMapper.toYYYYMMDDString((Date)zrBegin);
        this.mZrend = DateMapper.toYYYYMMDDString((Date)DateHelper.getLastDayOfMonth((Date)zrBegin));
        this.mKvbeitr1 = BigDecimal.ZERO;
        this.mKvbeitr3 = BigDecimal.ZERO;
        this.mPvbeitr = BigDecimal.ZERO;
        this.mRvbeitr1 = BigDecimal.ZERO;
        this.mZbp = BigDecimal.ZERO;
        this.mAvbeitr1 = BigDecimal.ZERO;
        this.mRvbeitr3 = BigDecimal.ZERO;
        this.mInsgu = BigDecimal.ZERO;
        this.mAvbeitr2 = BigDecimal.ZERO;
        this.mU1 = BigDecimal.ZERO;
        this.mU2 = BigDecimal.ZERO;
        this.mKvbeitr6 = BigDecimal.ZERO;
        this.mRvbeitr5 = BigDecimal.ZERO;
        this.mZws = BigDecimal.ZERO;
        this.mKvbeitrf = BigDecimal.ZERO;
        this.mPvbeitrf = BigDecimal.ZERO;
        this.mErstaag = BigDecimal.ZERO;
        this.mZbf = BigDecimal.ZERO;
        this.mBeitr2 = BigDecimal.ZERO;
        this.mBeitr3 = BigDecimal.ZERO;
        this.mSum = BigDecimal.ZERO;
        this.mDsid = "";
        this.mVamm = "";
        this.mBeitrsa = BigDecimal.ZERO;
        this.mBeitrsh = BigDecimal.ZERO;
        this.mKennzrk = "";
        this.mKennzuml = "0";
        this.mLfdnr = 1;
        this.mBeitr = BigDecimal.ZERO;
        this.mStnr = "";
    }

    public void fillFromSummBean(StatementOfContributionSummBean summBean, String bbnrkk) {
        boolean isGrundstellung = PartDsbn.isGrundstellung(bbnrkk);
        this.mKvbeitr1 = PartDsbn.toBigDecimal(summBean.getF_summe_kv_1000_beitrag());
        this.mKvbeitr3 = PartDsbn.toBigDecimal(summBean.getF_summe_kv_3000_beitrag());
        this.mPvbeitr = PartDsbn.toBigDecimal(summBean.getF_summe_pv_0001_beitrag());
        this.mRvbeitr1 = PartDsbn.toBigDecimal(summBean.getF_summe_rv_0100_beitrag());
        this.mZbp = PartDsbn.toBigDecimal(summBean.getF_summe_kv_zusatzbeitrag());
        this.mAvbeitr1 = PartDsbn.toBigDecimal(summBean.getF_summe_av_0010_beitrag());
        this.mRvbeitr3 = PartDsbn.toBigDecimal(summBean.getF_summe_rv_0300_beitrag());
        this.mInsgu = PartDsbn.toBigDecimal(summBean.getF_summe_av_0050_beitrag());
        this.mAvbeitr2 = PartDsbn.toBigDecimal(summBean.getF_summe_av_0020_beitrag());
        this.mU1 = PartDsbn.toBigDecimal(summBean.getF_summe_u1_beitrag());
        this.mU2 = PartDsbn.toBigDecimal(summBean.getF_summe_u2_beitrag());
        this.mKvbeitr6 = isGrundstellung ? BigDecimal.ZERO : PartDsbn.toBigDecimal(summBean.getF_summe_kv_6000_beitrag());
        this.mRvbeitr5 = isGrundstellung ? BigDecimal.ZERO : PartDsbn.toBigDecimal(summBean.getF_summe_rv_0500_beitrag());
        this.mKvbeitrf = PartDsbn.toBigDecimal(summBean.getF_summe_kv_frw_beitrag());
        this.mPvbeitrf = PartDsbn.toBigDecimal(summBean.getF_summe_pv_frw_beitrag());
        this.mSum = PartDsbn.toBigDecimal(summBean.getF_summe_beitrag()).subtract(PartDsbn.toBigDecimal(summBean.getF_summe_st_beitrag()));
        this.mBeitr = isGrundstellung ? BigDecimal.ZERO : PartDsbn.toBigDecimal(summBean.getF_summe_st_beitrag());
        this.mErstaag = PartDsbn.toBigDecimal(summBean.getF_summe_u1_erstattung()).add(PartDsbn.toBigDecimal(summBean.getF_summe_u2_erstattung()));
        this.mZbf = PartDsbn.toBigDecimal(summBean.getF_summe_kv_fw_zusatzbeitrag());
        this.mZws = BigDecimalHelper.sum((BigDecimal[])new BigDecimal[]{this.mKvbeitr1, this.mKvbeitr3, this.mPvbeitr, this.mRvbeitr1, this.mZbp, this.mAvbeitr1, this.mRvbeitr3, this.mInsgu, this.mAvbeitr2, this.mU1, this.mU2, this.mKvbeitr6, this.mRvbeitr5});
    }

    private static boolean isGrundstellung(String bbnrkk) {
        return !Arrays.asList("98000006", "98000001", "98094037", "98094032", "99086875").contains(bbnrkk);
    }

    private static BigDecimal toBigDecimal(String string) {
        return BigDecimalMapper.toBigDecimalZero((String)string, (char)',', (char)'.');
    }

    public String print() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKeart, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)("" + this.mKeinsbn), (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mZrbeg, (int)8));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mZrend, (int)8));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mKvbeitr1, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mKvbeitr3, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mPvbeitr, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mRvbeitr1, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mZbp, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mAvbeitr1, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mRvbeitr3, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mInsgu, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mAvbeitr2, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mU1, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mU2, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mKvbeitr6, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mRvbeitr5, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mZws, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mKvbeitrf, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mPvbeitrf, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mErstaag, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mZbf, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mBeitr2, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mBeitr3, (int)11));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mSum, (int)11));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mDsid, (int)32));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mVamm, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)BigDecimalMapper.toString((BigDecimal)this.mBeitrsa), (int)4));
        stringBuilder.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)BigDecimalMapper.toString((BigDecimal)this.mBeitrsh), (int)4));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzrk, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzuml, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)("" + this.mLfdnr), (int)3));
        stringBuilder.append(EubpHelper.makeStringWithSignRight((BigDecimal)this.mBeitr, (int)11));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mStnr, (int)20));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)(this.mDbsc != null ? "J" : "N"), (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)(this.mDbrb != null ? "J" : "N"), (int)1));
        if (this.mDbsc != null) {
            stringBuilder.append(this.mDbsc.print());
        }
        if (this.mDbrb != null) {
            stringBuilder.append(this.mDbrb.print());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return "PartDsbn [, mKeart\t= " + this.mKeart + ", mKeinsbn\t= " + this.mKeinsbn + ", mZrbeg\t= " + this.mZrbeg + ", mZrend\t= " + this.mZrend + ", mKvbeitr1\t= " + this.mKvbeitr1 + ", mKvbeitr3\t= " + this.mKvbeitr3 + ", mPvbeitr\t= " + this.mPvbeitr + ", mRvbeitr1\t= " + this.mRvbeitr1 + ", mZbp\t= " + this.mZbp + ", mAvbeitr1\t= " + this.mAvbeitr1 + ", mRvbeitr3\t= " + this.mRvbeitr3 + ", mInsgu\t= " + this.mInsgu + ", mAvbeitr2\t= " + this.mAvbeitr2 + ", mU1\t= " + this.mU1 + ", mU2\t= " + this.mU2 + ", mKvbeitr6\t= " + this.mKvbeitr6 + ", mRvbeitr5\t= " + this.mRvbeitr5 + ", mZws\t= " + this.mZws + ", mKvbeitrf\t= " + this.mKvbeitrf + ", mPvbeitrf = " + this.mPvbeitrf + ", mErstaag\t= " + this.mErstaag + ", mZbf\t= " + this.mZbf + ", mBeitr2\t= " + this.mBeitr2 + ", mBeitr3\t= " + this.mBeitr3 + ", mSum\t= " + this.mSum + ", mDsid\t= " + this.mDsid + ", mVamm\t= " + this.mVamm + ", mBeitrsa\t= " + this.mBeitrsa + ", mBeitrsh\t= " + this.mBeitrsh + ", mKennzrk\t= " + this.mKennzrk + ", mKennzuml\t= " + this.mKennzuml + ", mLfdnr\t= " + this.mLfdnr + ", mBeitr\t= " + this.mBeitr + ", mStnr\t= " + this.mStnr + "]";
    }
}

