/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eubp.dsbn;

import com.varial.personnel.domain.eubp.account.EubpAccount;
import com.varial.personnel.domain.eubp.basics.BasicRecord;
import com.varial.personnel.domain.eubp.dsbn.PartDsbn;
import com.varial.personnel.domain.reports.reportdatatransfer.ReportDataTransfer;
import java.util.ArrayList;
import java.util.List;

public class EubpDsbn {
    private static final String KENNUNG = "DSBN";
    private String mVersionsnr = "06";
    private BasicRecord mBasicRecord;
    private String mMandant;
    private String mBbnr;
    private List<PartDsbn> mPartDsbns = new ArrayList<PartDsbn>();
    private boolean mMmsc;
    private boolean mMmrb;
    private EubpAccount mEubpAccount;

    public String getVersionsnr() {
        return this.mVersionsnr;
    }

    public void setVersionsnr(String versionsnr) {
        this.mVersionsnr = versionsnr;
    }

    public BasicRecord getBasicRecord() {
        return this.mBasicRecord;
    }

    public void setBasicRecord(BasicRecord basicRecord) {
        this.mBasicRecord = basicRecord;
    }

    public String getMandant() {
        return this.mMandant;
    }

    public void setMandant(String mandant) {
        this.mMandant = mandant;
    }

    public String getBbnr() {
        return this.mBbnr;
    }

    public void setBbnr(String bbnr) {
        this.mBbnr = bbnr;
    }

    public List<PartDsbn> getPartDsbns() {
        return this.mPartDsbns;
    }

    public void setPartDsbns(List<PartDsbn> partDsbns) {
        this.mPartDsbns = partDsbns;
    }

    public void addPart(PartDsbn part) {
        this.mPartDsbns.add(part);
    }

    public EubpAccount getEubpAccount() {
        return this.mEubpAccount;
    }

    public void setEubpAccount(EubpAccount eubpAccount) {
        this.mEubpAccount = eubpAccount;
    }

    public String getKennung() {
        return KENNUNG;
    }

    public String print() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(KENNUNG);
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"EUBP", (int)5));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mBasicRecord.getAbsn(), (int)15));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mBasicRecord.getEpnr(), (int)15));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mVersionsnr, (int)2));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mBasicRecord.getEd(), (int)17));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)Integer.toString(this.mBasicRecord.getFekz()), (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)Integer.toString(this.mBasicRecord.getFean()), (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mMandant, (int)100));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mBbnr, (int)15));
        stringBuilder.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)Integer.toString(this.mPartDsbns.size()), (int)4));
        for (PartDsbn partDsbn : this.mPartDsbns) {
            stringBuilder.append(partDsbn.print());
        }
        stringBuilder.append("E");
        return stringBuilder.toString();
    }

    public String toString() {
        return "EubpDsbn [ , mBasicRecord = " + this.mBasicRecord + ", mMandant = " + this.mMandant + ", mBbnr = " + this.mBbnr + ", mAnbnw = " + this.mPartDsbns.size() + ", mPartDsbns = " + this.mPartDsbns + ", mMmsc = " + this.mMmsc + ", mMmrb = " + this.mMmrb + "]";
    }
}

