/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.deuvmessaging;

import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.deuv.DeuvAcknowledgement;
import com.varial.personnel.domain.deuv.DeuvBasicComponents;
import com.varial.personnel.domain.deuv.PerfidiaResult;
import com.varial.personnel.domain.deuvmessaging.DeuvRecipientMap;
import com.varial.personnel.domain.deuvmessaging.basiccomponents.Dban;
import com.varial.personnel.domain.deuvmessaging.basiccomponents.Dbgb;
import com.varial.personnel.domain.deuvmessaging.basiccomponents.Dbna;
import com.varial.personnel.domain.deuvmessaging.mapper.DeuvmessagingExceptionMapper;
import com.varial.personnel.domain.deuvmessaging.perfidia.PerfidiaHelper;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.framework.PFileHelper;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.mapper.StringMapper;
import java.io.File;
import java.io.FilenameFilter;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicReceive<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicReceive.class);
    public static String ISO_8859_1 = "ISO_8859_1";
    private static final String VOSZ_BASEPATTERN_V01 = ".{15}.{15}\\d{8}(\\d{6}).{50}01";
    protected static final int VOSZ_LENGTH = 105;
    protected final DEUVSender mDeuvSender;
    protected DEUVRecipient mRecipient;
    protected File mCurrent;
    protected Map<DEUVRecipient, List<File>> mFiles;
    protected List<T> mImporteds;
    protected final PerfidiaResult mPerfidiaResult;
    protected final DeuvAcknowledgement mAcknowledgement;

    protected BasicReceive(DEUVSender deuvSender) {
        this.mDeuvSender = deuvSender;
        this.mImporteds = new ArrayList<T>();
        this.mPerfidiaResult = new PerfidiaResult();
        this.mAcknowledgement = new DeuvAcknowledgement(deuvSender);
    }

    public abstract FilenameFilter getFilenameFilter();

    public List<File> getFilesForProcessing() throws BusinessDomainException {
        this.initFiles();
        return this.getFileList();
    }

    protected void initFiles() throws BusinessDomainException {
        if (this.mFiles == null) {
            this.initFiles(Arrays.asList(this.mDeuvSender.getDEUVRecipients()));
        }
    }

    protected void initFiles(TypeOfHealthFundEnum typeOfRecipient) throws BusinessDomainException {
        if (this.mFiles == null) {
            ArrayList<DEUVRecipient> deuvRecipients = new ArrayList<DEUVRecipient>();
            deuvRecipients.add(DeuvRecipientMap.getRecipientByTypeOfHealthFund((TypeOfHealthFundEnum)typeOfRecipient, (DEUVSender)this.mDeuvSender));
            this.initFiles(deuvRecipients);
        }
    }

    private void initFiles(List<DEUVRecipient> deuvRecipients) throws BusinessDomainException {
        this.mFiles = new HashMap<DEUVRecipient, List<File>>();
        for (DEUVRecipient deuvRecipient : deuvRecipients) {
            File dir = PerfidiaHelper.getPerfidiaRecvFolder((DEUVSender)this.mDeuvSender, (DEUVRecipient)deuvRecipient);
            for (File file : dir.listFiles(this.getFilenameFilter())) {
                if (!this.isFileValid(file, deuvRecipient)) continue;
                if (!this.mFiles.containsKey(deuvRecipient)) {
                    this.mFiles.put(deuvRecipient, new ArrayList());
                }
                this.mFiles.get(deuvRecipient).add(file);
            }
        }
        this.logInfoFiles();
    }

    protected List<File> getFileList() {
        ArrayList<File> files = new ArrayList<File>();
        for (List<File> fileList : this.mFiles.values()) {
            files.addAll(fileList);
        }
        return files;
    }

    protected abstract boolean isFileValid(File var1, DEUVRecipient var2) throws BusinessDomainException;

    public abstract String getProcedureName();

    public abstract String getFileDescription();

    public abstract String getActionName();

    protected String initDbna(String input, Dbna dbna) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 125, DeuvBasicComponents.DBNA);
        int i = 1;
        String familienname = this.asString(matcher.group(i++));
        String vorname = this.asString(matcher.group(i++));
        String vorsatzwort = this.asString(matcher.group(i++));
        String namenszusatz = this.asString(matcher.group(i++));
        String titel = this.asString(matcher.group(i++));
        dbna.setFamilienname(familienname);
        dbna.setVorname(vorname);
        dbna.setVorsatzwort(vorsatzwort);
        dbna.setNamenszusatz(namenszusatz);
        dbna.setTitel(titel);
        return matcher.group(++i);
    }

    protected String initDbgb(String input, Dbgb dbgb) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 120, DeuvBasicComponents.DBGB);
        int i = 1;
        String gebname = this.asString(matcher.group(i++));
        String gebvorsatzwort = this.asString(matcher.group(i++));
        String gebnamenszusatz = this.asString(matcher.group(i++));
        Date gebdatum = PDateHelper.toDateYYYYMMDD((String)matcher.group(i++));
        String geschlecht = this.asString(matcher.group(i++));
        String gebort = this.asString(matcher.group(i++));
        String gebland = this.asString(matcher.group(i++));
        dbgb.setGebname(gebname);
        dbgb.setGebvorsatzwort(gebvorsatzwort);
        dbgb.setGebnamenszusatz(gebnamenszusatz);
        dbgb.setGebdatum(gebdatum);
        dbgb.setGeschlecht(geschlecht);
        dbgb.setGebort(gebort);
        dbgb.setGebland(gebland);
        return matcher.group(i);
    }

    protected String initDban(String input, Dban dban) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 133, DeuvBasicComponents.DBAN);
        int i = 1;
        String ldkz = this.asString(matcher.group(i++));
        String plz = this.asString(matcher.group(i++));
        String ort = this.asString(matcher.group(i++));
        String str = this.asString(matcher.group(i++));
        String nr = this.asString(matcher.group(i++));
        String adrzu = this.asString(matcher.group(i++));
        dban.setLaenderkennz(ldkz);
        dban.setPostleitzahl(plz);
        dban.setWohnort(ort);
        dban.setStrasse(str);
        dban.setHausnummer(nr);
        dban.setAnschriftenzusatz(adrzu);
        return matcher.group(i);
    }

    protected Matcher checkInputGetMatcher(String input, int length, Pattern pattern) throws BusinessDomainException {
        return this.checkInputGetMatcher(input, length, pattern, true);
    }

    protected Matcher checkInputGetMatcher(String input, int length, Pattern pattern, boolean throwException) throws BusinessDomainException {
        if (input.length() < length) {
            if (throwException) {
                throw DeuvmessagingExceptionMapper.makeInputTooShortDomainException((File)this.mCurrent, (String)input);
            }
            return null;
        }
        Matcher matcher = pattern.matcher(input);
        if (!matcher.matches()) {
            if (throwException) {
                throw DeuvmessagingExceptionMapper.makeFalseFileContentForImportDomainException((File)this.mCurrent, (String)input.substring(0, length).replace(' ', '.'), (Pattern)pattern);
            }
            matcher = null;
        }
        return matcher;
    }

    public void writeAcknowledgements() throws BusinessDomainException {
        this.mAcknowledgement.writeAcknowledgements();
    }

    public void writePerfidiaFiles() {
        this.mAcknowledgement.writePerfidiaFiles();
        this.mPerfidiaResult.writePerfidiaFiles();
    }

    public DEUVSender getDeuvSender() {
        return this.mDeuvSender;
    }

    public Set<DEUVRecipient> getDeuvRecipients() throws BusinessDomainException {
        this.initFiles();
        return this.mFiles.keySet();
    }

    public boolean hasImporteds() {
        return !this.mImporteds.isEmpty();
    }

    public List<T> getImporteds() {
        return Collections.unmodifiableList(this.mImporteds);
    }

    protected String asString(String value) {
        return StringMapper.toStringWithTrim((String)value);
    }

    protected boolean asBoolean(String jn) {
        return "J".equals(jn);
    }

    protected int asInteger(String value) {
        return Integer.valueOf(value);
    }

    protected BigDecimal asBigDecimal(String value) {
        return StringMapper.isNullString((String)value) ? null : BigDecimal.valueOf(Integer.parseInt(value));
    }

    protected BigDecimal asBigDecimal(String value, int scale) {
        return StringMapper.isNullString((String)value) ? null : BigDecimal.valueOf(Integer.parseInt(value), scale);
    }

    protected BigDecimal asCents(String value) {
        return this.asBigDecimal(value, 2);
    }

    protected Date asDate(String value) {
        return PDateHelper.toDateYYYYMMDD((String)value);
    }

    protected int getFilenumber(File input) {
        CharSequence content = PFileHelper.getFileContent(input, ISO_8859_1, 105);
        Matcher matcher = BasicReceive.getVoszPattern(".{5}").matcher(content);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        throw new IllegalStateException(input.getPath() + " don't match: " + matcher);
    }

    protected boolean isDsidValid(String dsid) {
        return !StringMapper.isNullString((String)dsid) && dsid.length() <= 18 && StringUtils.isNumeric((CharSequence)dsid);
    }

    protected int getFileNumberFromFileName(String fileName) {
        String fileNumber = PFileHelper.getExtension(Path.of(fileName, new String[0]));
        return StringUtils.isNumeric((CharSequence)fileNumber) ? this.asInteger(fileNumber) : 0;
    }

    private void logInfoFiles() {
        String message = this.mFiles.values().stream().flatMap(list -> list.stream()).map(file -> file.getAbsolutePath()).collect(Collectors.joining(", "));
        LOGGER.info(this.getProcedureName() + " " + this.getActionName() + ": " + message);
    }

    protected static Pattern getVoszPattern(String deuvFeature) {
        return Pattern.compile("VOSZ" + deuvFeature + VOSZ_BASEPATTERN_V01);
    }
}

