/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.calculation;

import com.varial.base.BigDecimalHelper;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.taskreminder.TaskReminder;
import com.varial.personnel.domain.calculation.Calculation;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.calculation.CalculationBasicPersistencyManager;
import com.varial.personnel.domain.calculation.CalculationCaseData;
import com.varial.personnel.domain.calculation.CalculationCasePersistencyManager;
import com.varial.personnel.domain.calculation.CompressionKeyOfValuePosition;
import com.varial.personnel.domain.calculation.EmployeeCalculate;
import com.varial.personnel.domain.calculation.MKPosition;
import com.varial.personnel.domain.calculation.TypeOfCalculationCase;
import com.varial.personnel.domain.calculation.mapper.CalculationExceptionMapper;
import com.varial.personnel.domain.companyplant.StatusByInsolvencyEnum;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.advancepayment.AdvancePayment;
import com.varial.personnel.domain.employee.advancepayment.AdvancePaymentTP;
import com.varial.personnel.domain.employee.attachment.EEAttachment;
import com.varial.personnel.domain.employee.attachment.EEAttachmentTP;
import com.varial.personnel.domain.employee.attachment.EEAttachmentTPCalcComparator;
import com.varial.personnel.domain.employee.datacredit.EEDataCreditTP;
import com.varial.personnel.domain.employee.dataera.EEDataERA;
import com.varial.personnel.domain.employee.deuvdskk.EEDeuvDskkTP;
import com.varial.personnel.domain.employee.deuvdskk.EEDeuvDskkTPPersistencyManager;
import com.varial.personnel.domain.employee.deuvdskk.KennzGlzEnum;
import com.varial.personnel.domain.employee.eewagefactor.EEWageFactorTP;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.fixedpayment.FixedPayment;
import com.varial.personnel.domain.employee.fixedpayment.FixedPaymentTP;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.insurance.mapper.MultiplyEmploymentEnumMapper;
import com.varial.personnel.domain.employee.loan.EELoan;
import com.varial.personnel.domain.employee.loan.EELoanTP;
import com.varial.personnel.domain.employee.mapper.EmployeeExceptionMapper;
import com.varial.personnel.domain.employee.materialexpenses.EEMaterialExpenses;
import com.varial.personnel.domain.employee.materialexpenses.EEMaterialExpensesTP;
import com.varial.personnel.domain.employee.materialexpenses.TypeOfCalculation;
import com.varial.personnel.domain.employee.paymentdeduction.EEPaymentDeduction;
import com.varial.personnel.domain.employee.paymentdeduction.EEPaymentDeductionTP;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionScheme;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionSchemeTP;
import com.varial.personnel.domain.employee.piecework.EEPieceWork;
import com.varial.personnel.domain.employee.piecework.EEPieceWorkTP;
import com.varial.personnel.domain.employee.piecework.EEPieceWorkTPPersistencyManager;
import com.varial.personnel.domain.employee.relative.EERelativeTP;
import com.varial.personnel.domain.employee.relative.FlagCalculationEnum;
import com.varial.personnel.domain.employee.scalepayment.ScalePayment;
import com.varial.personnel.domain.employee.scalepayment.ScalePaymentTP;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.valueposition.ValuePositionHistory;
import com.varial.personnel.domain.employee.valueposition.ValuePositionPersistencyManager;
import com.varial.personnel.domain.employee.varpayment.VarPayment;
import com.varial.personnel.domain.employee.varpayment.VarPaymentTP;
import com.varial.personnel.domain.employee.vblu.EEVBLU;
import com.varial.personnel.domain.employee.zvk.EEZVK;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.domain.typeofvalue.ValueTypeTP;
import com.varial.personnel.domain.typeofvalue.basictypes.CategoryEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.ClassificationEnum;
import com.varial.personnel.domain.typeofvalue.consequenceofvaluetype.ConsequenceOfValueType;
import com.varial.personnel.domain.typeofvalue.foundation.general.FoundationGeneral;
import com.varial.personnel.domain.workingtime.WorkingTimeTP;
import com.varial.personnel.framework.DateComparator;
import com.varial.personnel.framework.PersonnelPersistenceObject;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.personnelbasic.PersonnelBasic;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObject;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculationCase
extends PersistentObject {
    protected static final ValuePosition[] EMPTY_VP_ARRAY = new ValuePosition[0];
    private static final int PRIORITY = 105;
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculationCase.class);
    private static final String CLASSNAME = CalculationCase.class.getName();
    protected Employee mEmployee;
    protected Date mEffectiveFrom;
    protected Date mValidFrom;
    protected boolean mSVTageEvaluate;
    protected boolean mSteuerTageEvaluate;
    protected BigDecimal mSVTage = null;
    protected BigDecimal mSteuerTage = null;
    protected BigDecimal mBufferTaxDays = BigDecimal.ZERO;
    protected BigDecimal mBufferSIDays = BigDecimal.ZERO;
    protected ValuePositionHistory mValuePositionHistory;
    protected boolean mGleitzoneChecked = false;
    protected boolean mGleitzoneKV = false;
    protected boolean mGleitzoneRV = false;
    protected boolean mGleitzoneAV = false;
    protected boolean mGleitzonePV = false;
    protected Calculation mCalculation;
    private boolean mStatus;
    private String mStatusMessage;
    private Date mCalculationUntil;
    private final List<ValuePosition> mOldValuePositionHistory = new LinkedList<ValuePosition>();
    private final List<ValuePosition> mNewOldValuePositionHistory = new LinkedList<ValuePosition>();
    private List<ValuePosition> mObjectsForDelete = new LinkedList<ValuePosition>();
    private final Map<ValueType, List<ValueType>> mGrossWageConversionMap = new HashMap<ValueType, List<ValueType>>();
    protected boolean mGrossWageConversion = false;
    protected Date mDateOfWithDrawal = null;
    protected final List<ValuePosition> limitedsInEffectiveness = new LinkedList<ValuePosition>();
    protected final List<ValuePosition> limitedsInValidness = new LinkedList<ValuePosition>();
    protected final List<ValuePosition> limitedsInEffectivenessAndValidness = new LinkedList<ValuePosition>();
    private boolean mOverPaymentPreviousMonthExist = false;
    private BigDecimal mOverPaymentPreviousMonthResult = BigDecimal.ZERO;
    private BigDecimal mSVTageUnterbrechung = BigDecimal.ZERO;
    private boolean mSVTageUnterbrechungEvaluate;
    private BigDecimal mSVFrei23cSGBIV = BigDecimal.ZERO;
    private boolean mSignedAs23cSGBIV = false;
    private boolean m23cSGBIVchecked = false;
    private boolean m23cVollerMonat = false;
    private boolean mZVKFoerderbetragChecked = false;
    private boolean mHasZVKFoerderbetrag = false;
    private BigDecimal mZVKFoerderbetrag = BigDecimal.ZERO;
    private List<TaskReminder> mTaskreminders;
    private BigDecimal mAnzurechnendeSteuer;
    private boolean mGleitzoneInsG;
    private boolean mUnchangedZvkBrutto = false;
    private boolean mZvkBruttoCheckedForCalculation = false;
    private boolean mZvkDiffVorjahrReset = false;
    private boolean mZvkDiffVorjahrResetDurchgefuehrt = false;
    private boolean mSAGChecked = false;
    private KennzGlzEnum mDbgzKENNZGLZ;
    private int mDbgzSVTG = 0;
    private BigDecimal mDbgzGAEG = BigDecimal.ZERO;
    private BigDecimal mDbgzEGAEG = BigDecimal.ZERO;
    private boolean mDbgzVorhanden = false;
    private BigDecimal mDbbgGAEGKV = BigDecimal.ZERO;
    private BigDecimal mDbbgGAEGRV = BigDecimal.ZERO;
    private BigDecimal mDbbgGAEGALV = BigDecimal.ZERO;
    private BigDecimal mDbbgEGAKV = BigDecimal.ZERO;
    private BigDecimal mDbbgEGARV = BigDecimal.ZERO;
    private BigDecimal mDbbgEGAALV = BigDecimal.ZERO;
    private String mDbbgKVLBBG = "";
    private String mDbbgRVLBBG = "";
    private String mDbbgAVLBBG = "";
    private String mDbbgKVEBBG = "";
    private String mDbbgRVEBBG = "";
    private String mDbbgAVEBBG = "";
    private String mDbbgKENNZRK;
    private int mDbbgSVTG = 0;
    private boolean mDbbgVorhanden = false;
    private String mDbgzRK;
    private boolean mDurchschnittlicherZusatzbeitrag = false;
    private int mCertificateNo = 0;
    private boolean mCheckIsStRRDiffVorjahrVorhanden = false;
    private boolean resetValuepositionHistoryIndex = false;
    protected TypeOfCalculationCase mTypeOfCalculationCase;
    private boolean mIsBerechnungNachAustritt = false;

    public CalculationCase() {
        super(105);
    }

    public CalculationCase(String objectid) {
        super(105, objectid);
    }

    public CalculationCase(String objectid, int version) {
        super(105, objectid, version);
    }

    public CalculationCase(boolean readOnly) {
        super(105, readOnly);
    }

    public void init(Calculation calculation, Employee employee, String triggerOfCalculation) throws BusinessDomainException {
        Date maximumDateOfEntry;
        Date firstDay;
        Date dateOfBanRetroactiveCalculation;
        this.mTypeOfCalculationCase = TypeOfCalculationCase.Standard;
        this.mCalculation = calculation;
        this.mEmployee = employee;
        this.mEffectiveFrom = DateHelper.getFirstDayOfMonth((Date)calculation.getEffectiveFrom());
        this.mValidFrom = calculation.getValidFrom();
        this.mEmployee.initCalculationBasics();
        Date currentMinDateOfRetroactiveCalculation = CalculationBasicPersistencyManager.getDateOfReverseProjection((String)this.mEmployee.getObjectid(), (Date)this.mEmployee.getJournalizedUntil());
        if (DateHelper.after((Date)this.mValidFrom, (Date)currentMinDateOfRetroactiveCalculation)) {
            this.mValidFrom = currentMinDateOfRetroactiveCalculation;
            new CalculationBasic(this.mEmployee, this.mEffectiveFrom, this.mValidFrom, triggerOfCalculation);
        }
        Date[] datesOfCalculation = this.mEmployee.checkAndCorrectStartOfCalculation(this.mEffectiveFrom, this.mValidFrom);
        this.mEffectiveFrom = datesOfCalculation[0];
        this.mValidFrom = datesOfCalculation[1];
        PersonnelBasic pb = PersonnelBasic.getPersonnelBasic();
        if (this.isCalculationAfterDefinedUntilAndTerminate(pb)) {
            calculation.setCancellation(true);
            this.setStatus(true);
            this.setStatusMessage("nach zuk\u00fcnftigem Berechnungsende");
            LOGGER.info("cancel calculation, because is after defined calculation until");
            return;
        }
        Date minDateOfRetroactiveCalculation = this.mEmployee.getMinDateOfRetroactiveCalculation();
        if (DateHelper.beforeOrEqual((Date)this.mValidFrom, (Date)this.mEmployee.getMinDateOfRetroactiveCalculation())) {
            this.mValidFrom = minDateOfRetroactiveCalculation;
        }
        if ((dateOfBanRetroactiveCalculation = this.mEmployee.getDateOfBanRetroactiveCalculation()) != null && DateHelper.before((Date)this.mValidFrom, (Date)dateOfBanRetroactiveCalculation)) {
            this.mValidFrom = dateOfBanRetroactiveCalculation;
        }
        boolean reasonDifferentFromEmployee = calculation.isReasonDifferentFromEmployee();
        Date dateOfWithdrawal = this.mEmployee.getLastDateOfWithdrawal();
        if (reasonDifferentFromEmployee && dateOfWithdrawal != null && DateHelper.before((Date)dateOfWithdrawal, (Date)minDateOfRetroactiveCalculation)) {
            calculation.setCancellation(true);
            this.setStatus(true);
            this.setStatusMessage("Austritt kleiner RR-Tiefe");
            LOGGER.info("cancel retroactive calculation, because last withdrawal before minimum date Of retroactive calculation", (Object)this);
            return;
        }
        if (reasonDifferentFromEmployee && !pb.getLimitRetroactiveCalculation() && DateHelper.before((Date)this.mValidFrom, (Date)(firstDay = DateHelper.getFirstDayOfMonth((Date)(maximumDateOfEntry = this.mEmployee.getMaximumDateOfEntry()))))) {
            EmployeeCalculate employeeCalculate = new EmployeeCalculate(this.mEmployee, this.mValidFrom, triggerOfCalculation, new Date());
            employeeCalculate.setDeselectionIsAllowed(true);
            this.mValidFrom = firstDay;
        }
        if (reasonDifferentFromEmployee && pb.getCancelRetroactiveCalculation() && dateOfWithdrawal != null) {
            Date lastDay = DateHelper.getLastDayOfMonth((Date)dateOfWithdrawal);
            if (DateHelper.afterOrEqual((Date)this.mEmployee.getJournalizedUntil(), (Date)lastDay) && DateHelper.beforeOrEqual((Date)this.mValidFrom, (Date)lastDay)) {
                EmployeeCalculate employeeCalculate = new EmployeeCalculate(this.mEmployee, this.mValidFrom, triggerOfCalculation, new Date());
                employeeCalculate.setDeselectionIsAllowed(true);
                calculation.setCancellation(true);
                this.setStatus(true);
                this.setStatusMessage("R\u00fcckrechnungssperre");
                LOGGER.info("cancel retroactive calculation", (Object)this);
                return;
            }
        }
        calculation.setCancellation(false);
        this.setStatus(true);
        this.setStatusMessage("");
        new CalculationBasic(employee, this.getEffectiveFrom(), this.getValidFrom(), CLASSNAME);
        this.initDBBG();
    }

    protected boolean isCalculationAfterDefinedUntilAndTerminate(PersonnelBasic pb) throws BusinessDomainException {
        Date calculationUntil = pb.getCalculationUntil(this.mEmployee.getJournalizedUntil());
        if (DateHelper.after((Date)this.mValidFrom, (Date)calculationUntil)) {
            throw CalculationExceptionMapper.makeStartCalculationCaseAfterCalculationUntilDomainException((Date)this.mValidFrom);
        }
        return false;
    }

    public void init(Calculation calculation, Employee employee, Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.mTypeOfCalculationCase = TypeOfCalculationCase.Standard;
        this.mCalculation = calculation;
        this.mEmployee = employee;
        this.mEffectiveFrom = DateHelper.getFirstDayOfMonth((Date)effectiveFrom);
        this.mValidFrom = validFrom;
        this.mEmployee.initCalculationBasics();
        Date[] datesOfCalculation = this.mEmployee.checkAndCorrectStartOfCalculation(this.mEffectiveFrom, this.mValidFrom);
        this.mEffectiveFrom = datesOfCalculation[0];
        this.mValidFrom = datesOfCalculation[1];
        this.setStatus(true);
        this.setStatusMessage("");
        this.mValuePositionHistory = new ValuePositionHistory(new ValuePosition[0]);
        new CalculationBasic(employee, this.getEffectiveFrom(), this.getValidFrom(), CLASSNAME);
        this.initDBBG();
    }

    protected void initDBBG() throws BusinessDomainException {
        EEDeuvDskkTP[] dskktpArray;
        if (DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)new VDate(2013, 0, 1).getDate())) {
            for (EEDeuvDskkTP dskktp : dskktpArray = EEDeuvDskkTPPersistencyManager.queryAll(null, (Criterion)new Conjunction(new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.eq((String)"kennung", (String)"DBBG"), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mEffectiveFrom)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mEffectiveFrom)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mValidFrom))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mValidFrom))), Restrictions.eq((String)"deleted", (String)"F")}), (boolean)true)) {
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dskktp.getGaegkv())) {
                    this.mDbbgGAEGKV = this.mDbbgGAEGKV.add(dskktp.getGaegkv());
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dskktp.getGaegrv())) {
                    this.mDbbgGAEGRV = this.mDbbgGAEGRV.add(dskktp.getGaegrv());
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dskktp.getGaegalv())) {
                    this.mDbbgGAEGALV = this.mDbbgGAEGALV.add(dskktp.getGaegalv());
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dskktp.getEgakv())) {
                    this.mDbbgEGAKV = this.mDbbgEGAKV.add(dskktp.getEgakv());
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dskktp.getEgarv())) {
                    this.mDbbgEGARV = this.mDbbgEGARV.add(dskktp.getEgarv());
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dskktp.getEgaalv())) {
                    this.mDbbgEGAALV = this.mDbbgEGAALV.add(dskktp.getEgaalv());
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mDbbgGAEGKV.add(this.mDbbgGAEGRV).add(this.mDbbgGAEGALV).add(this.mDbbgEGAKV).add(this.mDbbgEGARV).add(this.mDbbgEGAALV))) {
                    if (DateHelper.afterOrEqual((Date)dskktp.getValidFrom(), (Date)new VDate(2014, 5, 1).getDate())) {
                        this.mDbbgSVTG = dskktp.getSvtg();
                    }
                    this.mDbbgKENNZRK = dskktp.getKennzrk();
                    this.mDbbgVorhanden = true;
                    new CalculationBasic(this.getEmployee(), this.getEffectiveFrom(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)this.getValidFrom())), dskktp.getClassName());
                }
                if (!DateHelper.afterOrEqual((Date)dskktp.getValidFrom(), (Date)new VDate(2015, 0, 1).getDate())) continue;
                this.mDbbgKVLBBG = dskktp.getKennzLfdKV();
                this.mDbbgRVLBBG = dskktp.getKennzLfdRV();
                this.mDbbgAVLBBG = dskktp.getKennzLfdALV();
                this.mDbbgKVEBBG = dskktp.getKennzEgaKV();
                this.mDbbgRVEBBG = dskktp.getKennzEgaRV();
                this.mDbbgAVEBBG = dskktp.getKennzEgaALV();
            }
        } else if (DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)new VDate(2012, 0, 1).getDate())) {
            for (EEDeuvDskkTP dskktp : dskktpArray = EEDeuvDskkTPPersistencyManager.queryAll(null, (Criterion)new Conjunction(new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.eq((String)"kennung", (String)"DBGZ"), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mEffectiveFrom)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mEffectiveFrom)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mValidFrom))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mValidFrom))), Restrictions.eq((String)"deleted", (String)"F")}), (boolean)true)) {
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dskktp.getGaeg())) {
                    this.mDbgzGAEG = this.mDbgzGAEG.add(dskktp.getGaeg());
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dskktp.getEgaeg())) {
                    this.mDbgzEGAEG = this.mDbgzEGAEG.add(dskktp.getEgaeg());
                }
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mDbgzGAEG.add(this.mDbgzEGAEG))) continue;
                this.mDbgzSVTG = dskktp.getSvtg();
                this.mDbgzKENNZGLZ = dskktp.getKennzglz();
                this.mDbgzRK = dskktp.getKennzrk();
                this.mDbgzVorhanden = true;
                new CalculationBasic(this.getEmployee(), this.getEffectiveFrom(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)this.getValidFrom())), dskktp.getClassName());
            }
        }
        if (this.mDbbgVorhanden) {
            Insurance insurance = this.mEmployee.getInsurance(this.mEffectiveFrom, this.mValidFrom);
            if (insurance != null) {
                switch (insurance.getMultiplyEmployment().value()) {
                    case 0: 
                    case 1: {
                        throw EvaluationExceptionMapper.makeSAG_MehrfachbeschaeftigungDomainException(this.mValidFrom, MultiplyEmploymentEnumMapper.valueToString((int)insurance.getMultiplyEmployment().value()));
                    }
                }
            } else {
                throw EvaluationExceptionMapper.makeSAG_MehrfachbeschaeftigungDomainException(this.mValidFrom, "keine");
            }
        }
    }

    public static CalculationCase getCalculationCase(String objectid) {
        return new CalculationCase(objectid);
    }

    protected void load() {
        CalculationCasePersistencyManager.load((CalculationCase)this);
    }

    protected void saveImpl() {
        CalculationCasePersistencyManager.save((CalculationCase)this);
    }

    protected void deleteImpl() {
        CalculationCasePersistencyManager.delete((CalculationCase)this);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        return this.mCalculation.getDomainKey() + " / " + this.mEmployee.getDomainKey() + " / " + DateMapper.toString((Date)this.mEffectiveFrom) + " / " + DateMapper.toString((Date)this.mValidFrom);
    }

    protected void setData(CalculationCaseData data) {
        this.mEffectiveFrom = data.getEffectiveFrom();
        this.mValidFrom = data.getValidFrom();
        this.mStatus = data.getStatus();
        this.mStatusMessage = data.getStatusMessage();
    }

    public Calculation getCalculation() {
        this.requireLoaded();
        return this.mCalculation;
    }

    public void setCalculation(Calculation calculation) {
        this.mCalculation = calculation;
    }

    public Employee getEmployee() {
        this.requireLoaded();
        return this.mEmployee;
    }

    public void setEmployee(Employee employee) {
        this.mEmployee = employee;
    }

    public Date getEffectiveFrom() {
        this.requireLoaded();
        return this.mEffectiveFrom;
    }

    public void setEffectiveFrom(Date effectiveFrom) {
        this.mEffectiveFrom = effectiveFrom;
    }

    public Date getValidFrom() {
        this.requireLoaded();
        return this.mValidFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.mValidFrom = validFrom;
    }

    public boolean getStatus() {
        this.requireLoaded();
        return this.mStatus;
    }

    public void setStatus(boolean status) {
        this.mStatus = status;
    }

    public String getStatusMessage() {
        this.requireLoaded();
        return this.mStatusMessage;
    }

    public void setStatusMessage(String meldung) {
        this.mStatusMessage = meldung;
    }

    public BigDecimal getSVFrei23cSGBIV() {
        return this.mSVFrei23cSGBIV;
    }

    public void setSVFrei23cSGBIV(BigDecimal frei23cSGBIV) {
        this.mSVFrei23cSGBIV = frei23cSGBIV;
    }

    public boolean isSignedAs23cSGBIV() {
        return this.mSignedAs23cSGBIV;
    }

    public void setSignedAs23cSGBIV(boolean signedAs23cSGBIV) {
        this.mSignedAs23cSGBIV = signedAs23cSGBIV;
    }

    public boolean is23cVollerMonat() {
        return this.m23cVollerMonat;
    }

    public void set23cVollerMonat(boolean is23cVollerMonat) {
        this.m23cVollerMonat = is23cVollerMonat;
    }

    public boolean isSVTageEvaluate() {
        return this.mSVTageEvaluate;
    }

    public void setSVTageEvaluate(boolean svTageEvaluate) {
        this.mSVTageEvaluate = svTageEvaluate;
    }

    public boolean isSVTageUnterbrechungEvaluated() {
        return this.mSVTageUnterbrechungEvaluate;
    }

    public void setSVTageUnterbrechungEvaluated(boolean b) {
        this.mSVTageUnterbrechungEvaluate = b;
    }

    public boolean isSteuerTageEvaluate() {
        return this.mSteuerTageEvaluate;
    }

    public void setSteuerTageEvaluate(boolean steuerTageEvaluate) {
        this.mSteuerTageEvaluate = steuerTageEvaluate;
    }

    public BigDecimal getSVTage() {
        return this.mSVTage;
    }

    public void setSVTage(BigDecimal svTage) {
        this.mSVTage = svTage;
    }

    public BigDecimal getSVTageUnterbrechung() {
        return this.mSVTageUnterbrechung;
    }

    public void setSVTageUnterbrechung(BigDecimal decimal) {
        this.mSVTageUnterbrechung = decimal;
    }

    public BigDecimal getSteuerTage() {
        return this.mSteuerTage;
    }

    public void setSteuerTage(BigDecimal steuerTage) {
        this.mSteuerTage = steuerTage;
    }

    public ValuePositionHistory getValuePositionHistory() {
        return this.mValuePositionHistory;
    }

    public void start() throws BusinessDomainException {
        ValuePosition[] vpArray;
        Date calculationStart = this.getCalculationStart();
        this.mDateOfWithDrawal = this.getEmployee().getEmployment(this.getEffectiveFrom(), this.getValidFrom()).getDateOfWithDrawal();
        if (this.mDateOfWithDrawal != null && DateHelper.before((Date)this.mDateOfWithDrawal, (Date)calculationStart)) {
            return;
        }
        if (!DateHelper.after((Date)this.getValidFrom(), (Date)this.getEffectiveFrom()) && (vpArray = ValuePosition.getVPsOf99998(this.mEmployee.getObjectid(), this.getEffectiveFrom())).length != 0) {
            this.getCalculation().setSteuerlicheRueckrechnungsdifferenzAusVorjahrVorhanden(true);
        }
        if (!DateHelper.after((Date)this.getValidFrom(), (Date)this.getEffectiveFrom()) && (vpArray = ValuePosition.getVPsOf99992(this.mEmployee.getObjectid(), this.getEffectiveFrom())).length != 0) {
            this.getCalculation().setZVKRueckrechnungsdifferenzAusVorjahrVorhanden(true);
        }
        this.createOldValuePositionHistory();
        this.checkBeforeCalculation();
        this.createNewValuePositionHistory();
        if (DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.getValidFrom()), (Date)DateHelper.getFirstDayOfMonth((Date)this.getEffectiveFrom())) && this.mDateOfWithDrawal != null && DateHelper.before((Date)this.mDateOfWithDrawal, (Date)this.getEffectiveFrom())) {
            this.getDifferencesOfPayment(this.getEmployee().getObjectid(), this.getEffectiveFrom(), this.getValidFrom());
        }
        if (this.mDateOfWithDrawal != null) {
            this.limitOfValidityOfValuePositions();
        }
        this.mValuePositionHistory.sort();
        this.evaluateValuePositionHistory();
        this.checkAfterCalculation();
        if (!this.limitedsInEffectiveness.isEmpty()) {
            ValuePositionPersistencyManager.limitedforEffectiveness(this.limitedsInEffectiveness, (Date)DateHelper.yesterday((Date)this.getEffectiveFrom()));
        }
        if (!this.limitedsInValidness.isEmpty()) {
            ValuePositionPersistencyManager.limitedforValidness(this.limitedsInValidness, (Date)DateHelper.yesterday((Date)this.getValidFrom()));
        }
        if (!this.limitedsInEffectivenessAndValidness.isEmpty()) {
            ValuePositionPersistencyManager.limitedforEffectivenessAndValidness(this.limitedsInEffectivenessAndValidness, (Date)DateHelper.yesterday((Date)this.getEffectiveFrom()), (Date)DateHelper.yesterday((Date)this.getValidFrom()));
        }
        this.mValuePositionHistory.sort();
        this.calculateSummary();
        this.calculateSumOfBalanceOfNet();
        this.createAndEvaluateNetPay();
        if (this.mDateOfWithDrawal != null) {
            this.limitOfValuePositions();
        }
        this.registerForFirstExecute();
    }

    private void getDifferencesOfPayment(String oidEmployee, Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        Date currentMinDateOfRetroactiveCalculation = CalculationBasicPersistencyManager.getDateOfReverseProjection((String)this.mEmployee.getObjectid(), (Date)this.mEmployee.getJournalizedUntil());
        String[] wertarten = new String[]{Integer.toString(795062), Integer.toString(795063), Integer.toString(795072), Integer.toString(795082), Integer.toString(795092), Integer.toString(795552), Integer.toString(863112), Integer.toString(863122), Integer.toString(863132), Integer.toString(863142), Integer.toString(863152), Integer.toString(863162), Integer.toString(861112), Integer.toString(862112)};
        ValuePosition[] vps = ValuePositionPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.eq((String)"effectiveFrom", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.le((String)"validFrom", (String)DateMapper.toString((Date)currentMinDateOfRetroactiveCalculation)), Restrictions.in((String)"valuetypenumber", (String[])wertarten)}));
        if (vps.length > 0) {
            this.mIsBerechnungNachAustritt = true;
            for (ValuePosition vp : vps) {
                ValuePosition genesisVP = (ValuePosition)vp.getGenesisOfParentObjects();
                ValuePosition vpos = new ValuePosition(this.getEmployee(), genesisVP.getValueType(), genesisVP.getGenesisOfParentObjects(), genesisVP.getGenesisOfParentObjects());
                vpos.setEffectiveFrom(this.getEffectiveFrom());
                vpos.setEffectiveUntil(VDate.getDateMax());
                vpos.setValidFrom(this.getValidFrom());
                vpos.setValidUntil(DateHelper.getLastDayOfMonth((Date)this.getValidFrom()));
                vpos.setFactor1(BigDecimal.ZERO);
                vpos.setFactor2(BigDecimal.ZERO);
                vpos.setResult(BigDecimal.ZERO);
                vpos.setPercentage(BigDecimal.ZERO);
                vpos.setPerformanceFactor(BigDecimal.ZERO);
                vpos.setCostCenter(null);
                vpos.setCostUnit(null);
                vpos.setPersistentBuffer1(BigDecimal.ZERO);
                vpos.setPersistentBuffer2(BigDecimal.ZERO);
                vpos.setPersistentBuffer3(BigDecimal.ZERO);
                vpos.setPersistentBuffer4(BigDecimal.ZERO);
                vpos.setPersistentBuffer5(BigDecimal.ZERO);
                vpos.setEraCorrectionFactor(BigDecimal.ZERO);
                vpos.setEraValue(BigDecimal.ZERO);
                vpos.setBasicFactor1(BigDecimal.ZERO);
                vpos.setBasicFactor2(BigDecimal.ZERO);
                vpos.setBasicResult(BigDecimal.ZERO);
                vpos.setBasicPercentage(BigDecimal.ZERO);
                vpos.setBasicPerformanceFactor(BigDecimal.ZERO);
                vpos.setBasicCostCenter(null);
                vpos.setBasicCostUnit(null);
                vpos.setBufferFactor1(BigDecimal.ZERO);
                vpos.setBufferFactor2(BigDecimal.ZERO);
                vpos.setBufferResult(BigDecimal.ZERO);
                vpos.setBufferPercentage(BigDecimal.ZERO);
                vpos.setBufferPerformanceFactor(BigDecimal.ZERO);
                vpos.setBufferCostCenter(null);
                vpos.setBufferCostUnit(null);
                if (vpos == null) continue;
                this.getValuePositionHistory().addItem(vpos);
            }
        }
    }

    protected Date getCalculationStart() throws BusinessDomainException {
        return this.mEmployee.getPCompany().getCompanyFoundations(VDate.getDateMax(), VDate.getDateMax()).getCalculationStart();
    }

    protected void checkAfterCalculation() throws BusinessDomainException {
        Date aktBerechnungsMonatEnde;
        this.checkPaidOvertime();
        if (this.getEmployee().isContributory(this.mEffectiveFrom, this.mValidFrom) && this.mEmployee.checkattendance(this.mEffectiveFrom, this.mValidFrom)) {
            this.checkSocialInsuranceDaysVSGrossWage();
        }
        if (DateHelper.beforeOrEqual((Date)this.mValidFrom, (Date)(aktBerechnungsMonatEnde = DateHelper.getLastDayOfMonth((Date)DateHelper.tomorrow((Date)this.mEmployee.getJournalizedUntil()))))) {
            this.checkNegativeContributoryPayment();
        }
    }

    protected void checkSocialInsuranceDaysVSGrossWage() throws BusinessDomainException {
        Date aktBerechnungsMonatEnde;
        BigDecimal lfdSVBrutto = BigDecimal.ZERO;
        block5: for (int i = 0; i < this.mValuePositionHistory.getSize() && BigDecimalMapper.isZero((BigDecimal)lfdSVBrutto); ++i) {
            switch (this.mValuePositionHistory.getItem(i).getValueType().getValueTypeKey()) {
                case 130510: 
                case 130520: {
                    ValuePosition vP = this.mValuePositionHistory.getItem(i);
                    if (!DateHelper.between((Date)vP.getEffectiveFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)this.getEffectiveFrom()), (Date)DateHelper.getLastDayOfMonth((Date)this.getEffectiveFrom())) || !DateHelper.between((Date)vP.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)this.getValidFrom()), (Date)DateHelper.getLastDayOfMonth((Date)this.getValidFrom()))) continue block5;
                    lfdSVBrutto = lfdSVBrutto.add(vP.getResult());
                    continue block5;
                }
                case 870110: 
                case 870115: 
                case 871110: {
                    return;
                }
                case 230510: {
                    return;
                }
            }
        }
        if (BigDecimalMapper.isZero((BigDecimal)lfdSVBrutto) && DateHelper.beforeOrEqual((Date)this.mValidFrom, (Date)(aktBerechnungsMonatEnde = DateHelper.getLastDayOfMonth((Date)DateHelper.tomorrow((Date)this.mEmployee.getJournalizedUntil()))))) {
            this.checkSocialInsuranceDays();
        }
    }

    private void checkSocialInsuranceDays() throws BusinessDomainException {
        int pgs = this.mEmployee.getInsurance(this.mEffectiveFrom, this.mValidFrom).getPersonGroup();
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mSVTage) && this.mSVTage.compareTo(this.mSVTageUnterbrechung) > 0 && pgs != 107 && pgs != 111 && pgs != 102) {
            throw EvaluationExceptionMapper.makeNoPaymentWithSocialInsuranceDaysDomainException(this.getValidFrom());
        }
        Date neuesBerechnungsAb = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)this.mValidFrom));
        if (DateHelper.beforeOrEqual((Date)neuesBerechnungsAb, (Date)this.mEffectiveFrom)) {
            new CalculationBasic(this.mEmployee, this.mEffectiveFrom, neuesBerechnungsAb, this.getClassName());
        }
    }

    protected void evaluateValuePositionHistory() throws BusinessDomainException {
        this.bewertungslauf();
        if (DateHelper.beforeOrEqual((Date)this.getValidFrom(), (Date)DateHelper.yesterday((Date)this.getEffectiveFrom()))) {
            if (DateHelper.before((Date)this.getValidFrom(), (Date)DateHelper.yesterday((Date)this.getEffectiveFrom()))) {
                this.createBalanceOfNet();
            }
            if (DateHelper.equal((Date)this.getValidFrom(), (Date)DateHelper.yesterday((Date)this.getEffectiveFrom()))) {
                Date minimumDateOfEntry = this.getEmployee().getMinimumDateOfEntry();
                if (DateHelper.equal((Date)this.getValidFrom(), (Date)minimumDateOfEntry)) {
                    this.createBalanceOfNet();
                }
            }
        }
        this.bewertungslauf();
    }

    private void bewertungslauf() throws BusinessDomainException {
        for (int i = 0; i < this.mValuePositionHistory.getAll().size(); ++i) {
            ValuePosition vp = this.mValuePositionHistory.getAll().get(i);
            if (vp == null) continue;
            if (this.getTypeOfCalculationCase() == TypeOfCalculationCase.PkvPpVBerechnungOhneFZ && vp.getRanking() > 201150) {
                return;
            }
            ValueTypeTP vttp = vp.getValueType().getValueTypeTP(vp.getEffectiveFrom(), vp.getValidFrom());
            if (vttp.getValueTypeFoundation().getGeneral().getCategory().value() != 15 && !vp.getEvaluateComplete()) {
                vp.evaluate(this);
                if (this.mGrossWageConversion) {
                    this.evaluateGrossWageConversion(vp);
                }
                vp.setEvaluateComplete(true);
                this.mValuePositionHistory.addConsequenceOfValueType(vp, this);
            }
            if (this.resetValuepositionHistoryIndex) {
                i = -1;
                this.resetValuepositionHistoryIndex = false;
                continue;
            }
            i = this.mValuePositionHistory.getIndex(vp);
        }
    }

    protected void evaluateGrossWageConversion(ValuePosition vp) throws BusinessDomainException {
        if (this.mGrossWageConversionMap.containsKey(vp.getValueType())) {
            List<ValueType> valueTypeList = this.mGrossWageConversionMap.get(vp.getValueType());
            for (int i = 0; i < this.mValuePositionHistory.getAll().size(); ++i) {
                ValuePosition vpFromHistory = this.mValuePositionHistory.getAll().get(i);
                for (ValueType vt : valueTypeList) {
                    if (!StringMapper.equal((String)vpFromHistory.getValueType().getObjectid(), (String)vt.getObjectid())) continue;
                    if (!vpFromHistory.getEvaluateComplete()) {
                        vpFromHistory.evaluate(this);
                        vpFromHistory.setEvaluateComplete(true);
                        this.mValuePositionHistory.addConsequenceOfValueType(vpFromHistory, this);
                    }
                    if (vpFromHistory.getBufferResult().compareTo(vpFromHistory.getResult()) == 0) continue;
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)vpFromHistory.getBufferResult())) {
                        vpFromHistory.setBufferResult(BigDecimal.ZERO);
                        if (vp.getResult().compareTo(vpFromHistory.getResult()) < 0) {
                            vpFromHistory.setBufferResult(vp.getResult());
                            vp.setResult(BigDecimal.ZERO);
                            continue;
                        }
                        vp.setResult(vp.getResult().subtract(vpFromHistory.getResult()));
                        vpFromHistory.setBufferResult(vpFromHistory.getResult());
                        continue;
                    }
                    BigDecimal diff = vpFromHistory.getResult().subtract(vpFromHistory.getBufferResult());
                    if (vp.getResult().compareTo(diff) < 0) {
                        vpFromHistory.setBasicResult(vpFromHistory.getBufferResult().add(vp.getResult()));
                        vp.setResult(BigDecimal.ZERO);
                        continue;
                    }
                    vp.setResult(vp.getResult().subtract(diff));
                    vpFromHistory.setBufferResult(vpFromHistory.getResult());
                }
                i = this.mValuePositionHistory.getIndex(vpFromHistory);
            }
        }
    }

    protected void calculateSummary() throws BusinessDomainException {
        List<ValuePosition> mList = this.mValuePositionHistory.getAll();
        ValuePosition[] vps = new ValuePosition[mList.size()];
        for (int i = mList.size() - 1; i >= 0; --i) {
            if (ValuePosition.getCategory(mList.get(i), mList.get(i).getEffectiveFrom(), mList.get(i).getValidFrom()).value() != 15) continue;
            ValuePosition[] vpArray = ValuePosition.getConsequencesOfValueType(mList.toArray(vps), mList.get(i).getValueType().getObjectid(), mList.get(i).getEffectiveFrom(), mList.get(i).getEffectiveUntil(), mList.get(i).getValidFrom(), mList.get(i).getValidUntil());
            mList.get(i).setFactor1(BigDecimal.valueOf(0L));
            mList.get(i).setFactor2(BigDecimal.valueOf(0L));
            mList.get(i).setResult(BigDecimal.valueOf(0L));
            for (ValuePosition vp : vpArray) {
                if (vp.isReadOnly()) continue;
                if (vp.getValueType().getValueTypeTP(mList.get(i).getEffectiveFrom(), mList.get(i).getValidFrom()).getFactor1().getSpecification().getTotalsFormation()) {
                    mList.get(i).setFactor1(mList.get(i).getFactor1().add(vp.getFactor1()));
                }
                if (vp.getValueType().getValueTypeTP(mList.get(i).getEffectiveFrom(), mList.get(i).getValidFrom()).getFactor2().getSpecification().getTotalsFormation()) {
                    mList.get(i).setFactor2(mList.get(i).getFactor2().add(vp.getFactor2()));
                }
                mList.get(i).setResult(mList.get(i).getResult().add(vp.getResult()));
            }
        }
    }

    protected List<ValuePosition> createOldValuePositionHistory() throws BusinessDomainException {
        int i;
        ValuePosition.deleteValuePositions(this.getEffectiveFrom(), this.getValidFrom(), this.mEmployee.getObjectid());
        ValuePosition[] oldVPArray = ValuePosition.getNotJournalizeVPs(this.mEmployee.getObjectid(), this.getEffectiveFrom(), this.getValidFrom());
        for (i = 0; i < oldVPArray.length; ++i) {
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.getValidFrom()), (Date)this.getValidFrom())) {
                if (DateHelper.afterOrEqual((Date)oldVPArray[i].getEffectiveFrom(), (Date)this.getEffectiveFrom()) && DateHelper.afterOrEqual((Date)oldVPArray[i].getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)this.getValidFrom()))) {
                    this.addObjectForDelete(oldVPArray[i]);
                }
            } else if (DateHelper.afterOrEqual((Date)oldVPArray[i].getEffectiveFrom(), (Date)this.getEffectiveFrom()) && DateHelper.afterOrEqual((Date)oldVPArray[i].getValidFrom(), (Date)this.getValidFrom())) {
                this.addObjectForDelete(oldVPArray[i]);
            }
            if (DateHelper.beforeOrEqual((Date)oldVPArray[i].getEffectiveFrom(), (Date)this.getEffectiveFrom()) && DateHelper.afterOrEqual((Date)oldVPArray[i].getEffectiveUntil(), (Date)this.getEffectiveFrom()) && DateHelper.afterOrEqual((Date)oldVPArray[i].getValidUntil(), (Date)this.getValidFrom()) && !DateHelper.equal((Date)oldVPArray[i].getEffectiveFrom(), (Date)this.getEffectiveFrom())) {
                oldVPArray[i].setEffectiveUntil(DateHelper.yesterday((Date)this.getEffectiveFrom()));
                oldVPArray[i].setIsLimitedInCalculationCase(true);
                this.addObjectForLimitInEffectivness(oldVPArray[i]);
                oldVPArray[i].setIsLimitedInEffectivenessInCalculationCase(true);
            }
            if (DateHelper.equal((Date)oldVPArray[i].getEffectiveFrom(), (Date)this.getEffectiveFrom()) && DateHelper.before((Date)oldVPArray[i].getValidFrom(), (Date)this.getValidFrom()) && DateHelper.afterOrEqual((Date)oldVPArray[i].getValidUntil(), (Date)this.getValidFrom())) {
                oldVPArray[i].setValidUntil(DateHelper.yesterday((Date)this.getValidFrom()));
                if (oldVPArray[i].getIsLimitedInEffectivenessInCalculationCase()) {
                    this.removeObjectForLimitInEffectivness(oldVPArray[i]);
                    this.addObjectForLimitInEffectivenessAndValidness(oldVPArray[i]);
                    oldVPArray[i].setIsLimitedInValidnessInCalculationCase(true);
                } else {
                    this.addObjectForLimitInValidness(oldVPArray[i]);
                    oldVPArray[i].setIsLimitedInValidnessInCalculationCase(true);
                }
            }
            if (!oldVPArray[i].getIsLimitedInCalculationCase() || !DateHelper.before((Date)oldVPArray[i].getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)this.getValidFrom()))) continue;
            ValuePosition oldVP = oldVPArray[i].create(this.getEffectiveFrom(), VDate.getDateMax(), oldVPArray[i].getValidFrom(), DateHelper.yesterday((Date)this.getValidFrom()));
            oldVP.setToAnalyze(oldVPArray[i].isToAnalyze());
            this.mOldValuePositionHistory.add(oldVP);
            this.mNewOldValuePositionHistory.add(oldVP);
        }
        if (!this.mObjectsForDelete.isEmpty()) {
            ValuePositionPersistencyManager.delete(this.mObjectsForDelete);
        }
        for (i = 0; i < this.mNewOldValuePositionHistory.size(); ++i) {
            ValuePosition vp = this.mOldValuePositionHistory.get(i);
            if (vp.isNew() && vp.getValueType().getValueTypeTP(vp.getEffectiveFrom(), vp.getValidFrom()).getValueTypeFoundation().getGeneral().getCategory().value() != 15 && vp.getParentObject() != null && vp.getParentObject() instanceof ValuePosition) {
                vp.setParentObject(this.getOldValuePositionByObjectid(vp.getParentObject().getObjectid()));
            }
            if (!vp.isNew() || vp.getValueType().getValueTypeTP(vp.getEffectiveFrom(), vp.getValidFrom()).getValueTypeFoundation().getGeneral().getCategory().value() == 15 || vp.getGenesisOfParentObjects() == null || !(vp.getGenesisOfParentObjects() instanceof ValuePosition)) continue;
            vp.setGenesisOfParentObjects(this.getOldValuePositionByObjectid(vp.getGenesisOfParentObjects().getObjectid()));
        }
        return this.mOldValuePositionHistory;
    }

    private void addObjectForDelete(ValuePosition vp) {
        if (this.mObjectsForDelete.size() >= 250) {
            ValuePositionPersistencyManager.delete(this.mObjectsForDelete);
            this.mObjectsForDelete = new LinkedList<ValuePosition>();
        }
        this.mObjectsForDelete.add(vp);
        vp.setIsDeleteInCalculationCase(true);
    }

    private void addObjectForLimitInEffectivness(ValuePosition vp) {
        this.limitedsInEffectiveness.add(vp);
    }

    private void removeObjectForLimitInEffectivness(ValuePosition vp) {
        this.limitedsInEffectiveness.remove(vp);
    }

    private void addObjectForLimitInValidness(ValuePosition vp) {
        this.limitedsInValidness.add(vp);
    }

    private void addObjectForLimitInEffectivenessAndValidness(ValuePosition vp) {
        this.limitedsInEffectivenessAndValidness.add(vp);
    }

    private ValuePosition getOldValuePositionByObjectid(String objectid) {
        for (int i = 0; i < this.mNewOldValuePositionHistory.size(); ++i) {
            ValuePosition vp = this.mNewOldValuePositionHistory.get(i);
            if (!StringMapper.equal((String)vp.getOldObjectid(), (String)objectid)) continue;
            return vp;
        }
        return null;
    }

    protected void createNewValuePositionHistory() throws BusinessDomainException {
        Date monatRRSperre = this.getMonatFuerRRSperre();
        Date monatZVKRRSperre = VDate.getDateMax();
        if (this.isZVKpflichtig()) {
            monatZVKRRSperre = DateHelper.tomorrow((Date)DateHelper.getLastDayOfYear((Date)this.mValidFrom));
        }
        if (this.mDateOfWithDrawal != null && DateHelper.before((Date)this.mDateOfWithDrawal, (Date)this.getValidFrom())) {
            this.mValuePositionHistory = new ValuePositionHistory(EMPTY_VP_ARRAY);
            if (DateHelper.afterOrEqual((Date)this.getValidFrom(), (Date)new VDate(2009, 0, 1).getDate())) {
                if (DateHelper.afterOrEqual((Date)this.mEmployee.getJournalizedUntil(), (Date)DateHelper.getLastDayOfMonth((Date)monatRRSperre))) {
                    this.mValuePositionHistory.addItem(this.createValuePosition99997FromCalculationCase());
                    this.mValuePositionHistory.addItem(this.createValuePosition99998FromOldValueposition());
                } else if (DateHelper.before((Date)this.mValidFrom, (Date)this.mEffectiveFrom)) {
                    this.mValuePositionHistory.addItem(this.createValuePosition99998FromOldValueposition());
                } else if (this.mCalculation.isSteuerlicheRueckrechnungsdifferenzAusVorjahrVorhanden()) {
                    this.mValuePositionHistory.addItem(this.createValuePosition99998FromCalculationCase());
                    this.mCalculation.setSteuerlicheRueckrechnungsdifferenzAusVorjahrVorhanden(false);
                }
            }
            if (DateHelper.afterOrEqual((Date)this.getValidFrom(), (Date)new VDate(2016, 0, 1).getDate())) {
                if (DateHelper.afterOrEqual((Date)this.mEmployee.getJournalizedUntil(), (Date)DateHelper.getLastDayOfMonth((Date)monatZVKRRSperre))) {
                    this.mValuePositionHistory.addItem(this.createValuePosition99991FromCalculationCase());
                    this.mValuePositionHistory.addItem(this.createValuePosition99992FromOldValueposition());
                } else if (DateHelper.before((Date)this.mValidFrom, (Date)this.mEffectiveFrom)) {
                    this.mValuePositionHistory.addItem(this.createValuePosition99992FromOldValueposition());
                } else if (this.mCalculation.isZVKRueckrechnungsdifferenzAusVorjahrVorhanden()) {
                    this.mValuePositionHistory.addItem(this.createValuePosition99992FromCalculationCase());
                    this.mCalculation.setZVKRueckrechnungsdifferenzAusVorjahrVorhanden(false);
                }
            }
        } else {
            ValuePosition[] vpArray = this.createValuePositionFromFixedPayment();
            Date lastDayOfMonth = DateHelper.getLastDayOfMonth((Date)this.getValidFrom());
            LinkedList<ValuePosition> myList = new LinkedList<ValuePosition>();
            for (ValuePosition vp : vpArray) {
                if (DateHelper.after((Date)vp.getEffectiveFrom(), (Date)this.getEffectiveFrom())) continue;
                if (DateHelper.before((Date)this.getValidFrom(), (Date)this.getEffectiveFrom())) {
                    if (!DateHelper.beforeOrEqual((Date)vp.getValidFrom(), (Date)lastDayOfMonth)) continue;
                    myList.add(vp);
                    continue;
                }
                myList.add(vp);
            }
            vpArray = new ValuePosition[myList.size()];
            vpArray = myList.toArray(vpArray);
            this.mValuePositionHistory = new ValuePositionHistory(vpArray);
            vpArray = this.createValuePositionFromVarPayment();
            this.addValuePositionCompressedToHistory(vpArray, lastDayOfMonth);
            vpArray = this.createValuePositionFromAdvancePayment();
            this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            vpArray = this.createValuePositionFromEEPieceWork();
            this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            vpArray = this.createValuePositionFromERASettings();
            this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            vpArray = this.createValuePositionFromScalePayment();
            this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            vpArray = this.createValuePositionFromEEPaymentDeduction();
            this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            vpArray = this.createValuePositionFromEEAbsentTime();
            this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            vpArray = this.createValuePositionFromEEPensionScheme();
            this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            if (DateHelper.afterOrEqual((Date)this.getValidFrom(), (Date)new VDate(2011, 0, 1).getDate())) {
                vpArray = this.createValuePositionFromEEVblu();
                this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            }
            vpArray = this.createValuePositionFromEEAttachment();
            this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            vpArray = this.createValuePositionFromEELoan();
            this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            vpArray = this.createValuePositionFromEEMaterielExpenses();
            this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            vpArray = this.createValuePositionFromRelative();
            this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            vpArray = this.mEmployee.getInsurance(this.mEffectiveFrom, this.mValidFrom).getPersonGroup() == 103 ? (DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)new VDate(2009, 0, 1).getDate()) ? this.createValuePositionFromEEDataCredit() : this.createValuePositionForAgePartTime()) : this.createValuePositionFromEEDataCredit();
            for (ValuePosition vp : vpArray) {
                if (DateHelper.after((Date)vp.getEffectiveFrom(), (Date)this.getEffectiveFrom()) || !DateHelper.equal((Date)vp.getValidFrom(), (Date)this.getValidFrom())) continue;
                this.mValuePositionHistory.addItem(vp);
            }
            for (ValuePosition vp : vpArray = this.createValuePosition110595FromCalculationCase()) {
                if (DateHelper.after((Date)vp.getEffectiveFrom(), (Date)this.getEffectiveFrom()) || !DateHelper.equal((Date)vp.getValidFrom(), (Date)this.getValidFrom())) continue;
                this.mValuePositionHistory.addItem(vp);
            }
            if (this.getCalculation().getMaerzklauselGueltigAb() != null && DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.getValidFrom()), (Date)DateHelper.getFirstDayOfMonth((Date)this.getCalculation().getMaerzklauselGueltigAb())) && !this.getCalculation().getMaerzklauselExecuted()) {
                this.getCalculation().setMaerzklauselExecuted(true);
                MKPosition[] results = new MKPosition[this.getCalculation().getListOfMKPositions().size()];
                this.getCalculation().getListOfMKPositions().toArray(results);
                ValuePosition[] valuePositionArray = vpArray = this.createValuePosition99999FromCalculationCase(results);
                int n = valuePositionArray.length;
                for (int vp = 0; vp < n; ++vp) {
                    ValuePosition valueposition = valuePositionArray[vp];
                    this.mValuePositionHistory.addItem(valueposition);
                }
            }
            if (DateHelper.afterOrEqual((Date)this.mEmployee.getJournalizedUntil(), (Date)DateHelper.getLastDayOfMonth((Date)monatRRSperre))) {
                this.mValuePositionHistory.addItem(this.createValuePosition99997FromCalculationCase());
                this.mValuePositionHistory.addItem(this.createValuePosition99998FromOldValueposition());
            } else if (DateHelper.before((Date)this.mValidFrom, (Date)this.mEffectiveFrom)) {
                this.mValuePositionHistory.addItem(this.createValuePosition99998FromOldValueposition());
            } else if (this.mCalculation.isSteuerlicheRueckrechnungsdifferenzAusVorjahrVorhanden()) {
                this.mValuePositionHistory.addItem(this.createValuePosition99998FromCalculationCase());
                this.mCalculation.setSteuerlicheRueckrechnungsdifferenzAusVorjahrVorhanden(false);
            }
            this.checkOnlyInsolvenyPaymentAllowed();
            if (DateHelper.afterOrEqual((Date)this.getValidFrom(), (Date)new VDate(2016, 0, 1).getDate())) {
                if (DateHelper.afterOrEqual((Date)this.mEmployee.getJournalizedUntil(), (Date)DateHelper.getLastDayOfMonth((Date)monatZVKRRSperre))) {
                    this.mValuePositionHistory.addItem(this.createValuePosition99991FromCalculationCase());
                    this.mValuePositionHistory.addItem(this.createValuePosition99992FromOldValueposition());
                } else if (DateHelper.before((Date)this.mValidFrom, (Date)this.mEffectiveFrom)) {
                    this.mValuePositionHistory.addItem(this.createValuePosition99992FromOldValueposition());
                } else if (this.mCalculation.isZVKRueckrechnungsdifferenzAusVorjahrVorhanden()) {
                    this.mValuePositionHistory.addItem(this.createValuePosition99992FromCalculationCase());
                    this.mCalculation.setZVKRueckrechnungsdifferenzAusVorjahrVorhanden(false);
                }
            }
            if (DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)new VDate(2008, 0, 1).getDate()) && !this.checkForPermanentValue()) {
                if (this.mValuePositionHistory == null) {
                    this.mValuePositionHistory = new ValuePositionHistory(this.createValuePosition99993FromCalculationCase());
                } else {
                    this.mValuePositionHistory.addItem(this.createValuePosition99993FromCalculationCase());
                }
            }
            for (ValuePosition vp : vpArray = this.createValuePositionFromTransferDifferences()) {
                this.mValuePositionHistory.addItem(vp);
            }
            this.createCalculationBasicsFromEEWagefactor();
        }
        this.createCalculationBasicsFromEmployment();
    }

    private void checkOnlyInsolvenyPaymentAllowed() throws BusinessDomainException {
        StatusByInsolvencyEnum insolvencyStatus = this.mEmployee.getPCompany().getCompanyFoundations(VDate.getDateMax(), VDate.getDateMax()).getFoundations().getStatusByInsolvency();
        if (insolvencyStatus == StatusByInsolvencyEnum.SBIE_FUER_SOFORT_FREIGESTELLTE_AN || insolvencyStatus == StatusByInsolvencyEnum.SBIE_FUER_SPAETER_FREIGESTELLTE_AN) {
            for (ValuePosition vp : this.mValuePositionHistory.getAll()) {
                ConsequenceOfValueType[] consequenceForOrientations = vp.getValueType().getActiveValueTypeTP().getConsequenceForOrientation();
                if (consequenceForOrientations.length == 0) continue;
                boolean foundConseQuenceVT = false;
                boolean foundClassificationSI = false;
                for (ConsequenceOfValueType each : consequenceForOrientations) {
                    int vtKey;
                    if (each.getForClassification() == ClassificationEnum.CE_SV_Beitragspflicht) {
                        foundClassificationSI = true;
                    }
                    if ((vtKey = each.getConsequenceOfValueType().getValueTypeKey()) != 130530 && vtKey != 130635) continue;
                    foundConseQuenceVT = true;
                    break;
                }
                if (!foundClassificationSI || foundConseQuenceVT) continue;
                throw EmployeeExceptionMapper.makeOnlyInsolvenyPaymentDomainException();
            }
        }
    }

    protected boolean isZVKpflichtig() throws BusinessDomainException {
        boolean zvkPflichtig;
        block4: {
            zvkPflichtig = false;
            try {
                EEZVK eeZVK = this.mEmployee.getEEZVK(this.mEffectiveFrom, this.mValidFrom);
                if (eeZVK != null) {
                    Date austrittZVK;
                    Date eintrittZVK = eeZVK.getDateOfEntry();
                    Date date = austrittZVK = eeZVK.getDateOfWithdrawl() != null ? eeZVK.getDateOfWithdrawl() : VDate.getDateMax();
                    if (DateHelper.afterOrEqual((Date)austrittZVK, (Date)DateHelper.getFirstDayOfMonth((Date)this.mValidFrom)) && DateHelper.beforeOrEqual((Date)eintrittZVK, (Date)DateHelper.getLastDayOfMonth((Date)this.mValidFrom))) {
                        zvkPflichtig = true;
                    }
                }
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                throw e;
            }
        }
        return zvkPflichtig;
    }

    protected Date getMonatFuerRRSperre() {
        Date monatRRSperre = DateHelper.tomorrow((Date)DateHelper.getLastDayOfYear((Date)this.mValidFrom));
        return monatRRSperre;
    }

    protected boolean checkForPermanentValue() throws BusinessDomainException {
        ValuePosition[] items;
        for (ValuePosition valuePosition : items = this.mValuePositionHistory.getItems(this.mEffectiveFrom, this.mValidFrom)) {
            ConsequenceOfValueType[] covtArray;
            if (valuePosition == null) continue;
            for (ConsequenceOfValueType covt : covtArray = valuePosition.getValueType().getValueTypeTP(this.mEffectiveFrom, this.mValidFrom).getConsequenceForOrientation()) {
                switch (covt.getConsequenceOfValueType().getValueTypeKey()) {
                    case 130510: 
                    case 130520: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected ValuePosition createValuePosition99993FromCalculationCase() throws BusinessDomainException {
        return ValuePosition.create(this, 99993);
    }

    protected void addValuePositionToHistory(ValuePosition[] vpArray, Date lastDayOfMonth) {
        for (ValuePosition vp : vpArray) {
            if (!DateHelper.after((Date)vp.getEffectiveFrom(), (Date)this.getEffectiveFrom())) {
                if (DateHelper.before((Date)this.getValidFrom(), (Date)this.getEffectiveFrom())) {
                    if (DateHelper.beforeOrEqual((Date)vp.getValidFrom(), (Date)lastDayOfMonth)) {
                        this.mValuePositionHistory.addItem(vp);
                        continue;
                    }
                    vp.makeReadOnly();
                    continue;
                }
                this.mValuePositionHistory.addItem(vp);
                continue;
            }
            vp.makeReadOnly();
        }
    }

    protected void addValuePositionCompressedToHistory(ValuePosition[] vpArray, Date lastDayOfMonth) throws BusinessDomainException {
        HashMap<CompressionKeyOfValuePosition, ValuePosition> mMap = new HashMap<CompressionKeyOfValuePosition, ValuePosition>();
        ValuePosition oldVp = null;
        FoundationGeneral fg = null;
        for (ValuePosition vp : vpArray) {
            if (oldVp == null) {
                oldVp = vp;
                fg = vp.getValueType().getValueTypeTP(vp.getEffectiveFrom(), vp.getValidFrom()).getValueTypeFoundation().getGeneral();
            } else if (oldVp.getValueType().getValueTypeKey() != vp.getValueType().getValueTypeKey()) {
                oldVp = vp;
                fg = vp.getValueType().getValueTypeTP(vp.getEffectiveFrom(), vp.getValidFrom()).getValueTypeFoundation().getGeneral();
            }
            if (!DateHelper.after((Date)vp.getEffectiveFrom(), (Date)this.getEffectiveFrom())) {
                CompressionKeyOfValuePosition keyOfValuePosition;
                if (DateHelper.before((Date)this.getValidFrom(), (Date)this.getEffectiveFrom())) {
                    if (DateHelper.beforeOrEqual((Date)vp.getValidFrom(), (Date)lastDayOfMonth)) {
                        if (fg != null && fg.isCompressToSummary()) {
                            keyOfValuePosition = new CompressionKeyOfValuePosition(vp.getValueType(), vp.getValidFrom(), vp.getPerformanceFactor(), vp.getPercentage(), vp.getCostCenter(), vp.getCostUnit());
                            if (mMap.containsKey(keyOfValuePosition)) {
                                this.addValueToValuePosition((ValuePosition)mMap.get(keyOfValuePosition), vp);
                                continue;
                            }
                            mMap.put(keyOfValuePosition, vp);
                            continue;
                        }
                        this.mValuePositionHistory.addItem(vp);
                        continue;
                    }
                    vp.makeReadOnly();
                    continue;
                }
                if (fg != null && fg.isCompressToSummary()) {
                    keyOfValuePosition = new CompressionKeyOfValuePosition(vp.getValueType(), vp.getValidFrom(), vp.getPerformanceFactor(), vp.getPercentage(), vp.getCostCenter(), vp.getCostUnit());
                    if (mMap.containsKey(keyOfValuePosition)) {
                        this.addValueToValuePosition((ValuePosition)mMap.get(keyOfValuePosition), vp);
                        continue;
                    }
                    mMap.put(keyOfValuePosition, vp);
                    continue;
                }
                this.mValuePositionHistory.addItem(vp);
                continue;
            }
            vp.makeReadOnly();
        }
        for (CompressionKeyOfValuePosition key : mMap.keySet()) {
            this.mValuePositionHistory.addItem((ValuePosition)mMap.get(key));
        }
    }

    private void addValueToValuePosition(ValuePosition orgVp, ValuePosition vp) throws BusinessDomainException {
        ValueTypeTP vttp = vp.getValueType().getValueTypeTP(vp.getEffectiveFrom(), vp.getValidFrom());
        boolean addiert = false;
        if (vttp.getFactor1().getAssignment().getFixAssignment().value() == 1) {
            switch (vttp.getFactor1().getSpecification().getUnit().value()) {
                case 3: 
                case 5: {
                    orgVp.setBasicFactor1(this.kumulationEchtzeit(orgVp.getBasicFactor1(), vp.getBasicFactor1()));
                    orgVp.setFactor1(this.kumulationEchtzeit(orgVp.getFactor1(), vp.getFactor1()));
                    break;
                }
                default: {
                    orgVp.setBasicFactor1(orgVp.getBasicFactor1().add(vp.getBasicFactor1()));
                    orgVp.setFactor1(orgVp.getFactor1().add(vp.getFactor1()));
                }
            }
            addiert = true;
        }
        if (vttp.getFactor2().getAssignment().getFixAssignment().value() == 1) {
            switch (vttp.getFactor2().getSpecification().getUnit().value()) {
                case 3: 
                case 5: {
                    orgVp.setBasicFactor2(this.kumulationEchtzeit(orgVp.getBasicFactor2(), vp.getBasicFactor2()));
                    orgVp.setFactor2(this.kumulationEchtzeit(orgVp.getFactor2(), vp.getFactor2()));
                    break;
                }
                default: {
                    orgVp.setBasicFactor2(orgVp.getBasicFactor2().add(vp.getBasicFactor2()));
                    orgVp.setFactor2(orgVp.getFactor2().add(vp.getFactor2()));
                }
            }
            addiert = true;
        }
        if (vttp.getResult().getAssignment().getFixAssignment().value() == 1) {
            switch (vttp.getResult().getSpecification().getUnit().value()) {
                case 3: 
                case 5: {
                    orgVp.setBasicResult(this.kumulationEchtzeit(orgVp.getBasicResult(), vp.getBasicResult()));
                    orgVp.setResult(this.kumulationEchtzeit(orgVp.getResult(), vp.getResult()));
                    break;
                }
                default: {
                    orgVp.setBasicResult(orgVp.getBasicResult().add(vp.getBasicResult()));
                    orgVp.setResult(orgVp.getResult().add(vp.getResult()));
                }
            }
            addiert = true;
        }
        if (addiert) {
            vp.makeReadOnly();
        } else {
            this.mValuePositionHistory.addItem(vp);
        }
    }

    private BigDecimal kumulationEchtzeit(BigDecimal orgStunden, BigDecimal addStunden) {
        BigDecimal result = BigDecimal.ZERO;
        result = BigDecimalMapper.realTimeToDecimalTime((BigDecimal)orgStunden).add(BigDecimalMapper.realTimeToDecimalTime((BigDecimal)addStunden));
        result = BigDecimalMapper.decimalTimeToRealTime((BigDecimal)result);
        return result;
    }

    protected ValuePosition[] createValuePositionForAgePartTime() throws BusinessDomainException {
        this.checkSocialInsuranceDataForCalculationExist();
        Insurance ins = this.mEmployee.getInsurance(this.mEffectiveFrom, this.mValidFrom);
        if (ins != null) {
            if (ins.getPersonGroup() != 103 || ins.getTypeAgePartTime().value() != 1) {
                return EMPTY_VP_ARRAY;
            }
            Date gueltigAb = DateHelper.compare((Date)ins.getBeginWorkExemption(), (Date)DateHelper.getFirstDayOfMonth((Date)ins.getBeginWorkExemption())) == 0 ? ins.getBeginWorkExemption() : DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)ins.getBeginWorkExemption()));
            new CalculationBasic(this.getEmployee(), this.mEffectiveFrom, gueltigAb, this.getClassName());
            ValuePosition[] result = ValuePosition.create(this, new int[]{324130, 324170, 324210, 324250, 330130, 330170, 330210, 330250, 336130, 336170, 336210, 336250, 342130, 342170, 342210, 342250, 801140, 801180});
            return result;
        }
        return EMPTY_VP_ARRAY;
    }

    protected ValuePosition[] createValuePositionFromEEVblu() throws BusinessDomainException {
        ValuePosition[] vpArray = EMPTY_VP_ARRAY;
        EEVBLU vblu = (EEVBLU)this.mEmployee.getVBLUHistory().getItemOrNull(this.getEffectiveFrom(), this.getValidFrom());
        if (vblu != null) {
            if (vblu.getDateOfWithdrawal() != null) {
                if (DateHelper.between((Date)this.getValidFrom(), (Date)vblu.getDateOfEntry(), (Date)vblu.getDateOfWithdrawal()) || DateHelper.afterOrEqual((Date)this.getValidFrom(), (Date)vblu.getDateOfEntry())) {
                    vpArray = new ValuePosition[]{ValuePosition.create(this, 99960)};
                }
            } else if (DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)vblu.getDateOfEntry())) {
                vpArray = new ValuePosition[]{ValuePosition.create(this, 99960)};
            }
            if (DateHelper.after((Date)vblu.getDateOfEntry(), (Date)DateHelper.getLastDayOfMonth((Date)this.getValidFrom()))) {
                new CalculationBasic(this.getEmployee(), this.getEffectiveFrom(), DateHelper.getFirstDayOfMonth((Date)vblu.getDateOfEntry()), EEVBLU.class.getName());
            }
        } else {
            Date startOfHistory = this.mEmployee.getVBLUHistory().getMinValidFromOfHistory();
            if (startOfHistory != null && DateHelper.after((Date)startOfHistory, (Date)this.getValidFrom())) {
                new CalculationBasic(this.getEmployee(), this.getEffectiveFrom(), startOfHistory, EEVBLU.class.getName());
            }
        }
        return vpArray;
    }

    protected ValuePosition[] createValuePositionFromEEDataCredit() throws BusinessDomainException {
        EEDataCreditTP[] wghKonten = this.mEmployee.getEEDataCredits(this.mEffectiveFrom, this.mValidFrom);
        ArrayList<ValuePosition> mList = new ArrayList<ValuePosition>();
        block9: for (EEDataCreditTP dataCreditTP : wghKonten) {
            switch (dataCreditTP.getEEDataCredit().getCreditModel().getTypeOfCredit().value()) {
                case 0: {
                    ValuePosition[] vpArray = DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)new VDate(2009, 0, 1).getDate()) ? ValuePosition.create(this, new int[]{324130, 324170, 324210, 324250, 330130, 330170, 330210, 330250, 336130, 336170, 336210, 336250, 342130, 342170, 342210, 342250, 801180, 801140, 801185, 801145, 801410}) : ValuePosition.create(this, new int[]{324130, 324170, 324210, 324250, 330130, 330170, 330210, 330250, 336130, 336170, 336210, 336250, 342130, 342170, 342210, 342250, 801180, 801140});
                    for (ValuePosition valuePosition : vpArray) {
                        mList.add(valuePosition);
                    }
                    continue block9;
                }
                case 1: {
                    ValuePosition[] vpArray;
                    for (ValuePosition valuePosition : vpArray = ValuePosition.create(this, new int[]{802140, 802180})) {
                        mList.add(valuePosition);
                    }
                    continue block9;
                }
                case 2: {
                    ValuePosition[] vpArray;
                    for (ValuePosition valuePosition : vpArray = ValuePosition.create(this, new int[]{803140, 803180})) {
                        mList.add(valuePosition);
                    }
                    continue block9;
                }
                case 3: {
                    ValuePosition[] vpArray;
                    for (ValuePosition valuePosition : vpArray = ValuePosition.create(this, new int[]{804140, 804180})) {
                        mList.add(valuePosition);
                    }
                    continue block9;
                }
                case 4: {
                    ValuePosition[] vpArray;
                    for (ValuePosition valuePosition : vpArray = ValuePosition.create(this, new int[]{805140, 805180})) {
                        mList.add(valuePosition);
                    }
                    continue block9;
                }
                case 5: {
                    ValuePosition[] vpArray;
                    for (ValuePosition valuePosition : vpArray = ValuePosition.create(this, new int[]{806140, 806180})) {
                        mList.add(valuePosition);
                    }
                    continue block9;
                }
                case 6: {
                    ValuePosition[] vpArray;
                    for (ValuePosition valuePosition : vpArray = ValuePosition.create(this, new int[]{807140, 807180})) {
                        mList.add(valuePosition);
                    }
                    continue block9;
                }
                default: {
                    continue block9;
                }
            }
        }
        if (mList.isEmpty()) {
            return new ValuePosition[0];
        }
        return mList.toArray(new ValuePosition[mList.size()]);
    }

    protected void checkBeforeCalculation() throws BusinessDomainException {
        this.checkTaxDataForCalculationExist();
        this.checkSocialInsuranceDataForCalculationExist();
    }

    private void checkSocialInsuranceDataForCalculationExist() throws BusinessDomainException {
        try {
            Insurance ins = this.mEmployee.getInsurance(this.mEffectiveFrom, this.mValidFrom);
            if (ins == null) {
                throw CalculationExceptionMapper.makeNoSocialInsuranceDataForCalculationExistDomainException((Date)this.mValidFrom);
            }
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                throw CalculationExceptionMapper.makeNoSocialInsuranceDataForCalculationExistDomainException((Date)this.mValidFrom);
            }
            throw e;
        }
    }

    private void checkTaxDataForCalculationExist() throws BusinessDomainException {
        try {
            Tax tax = this.mEmployee.getTax(this.mEffectiveFrom, this.mValidFrom);
            if (tax == null) {
                throw CalculationExceptionMapper.makeNoTaxDataForCalculationExistDomainException((Date)this.mValidFrom);
            }
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                throw CalculationExceptionMapper.makeNoTaxDataForCalculationExistDomainException((Date)this.mValidFrom);
            }
            throw e;
        }
    }

    protected void checkNegativeContributoryPayment() throws BusinessDomainException {
        ValuePosition[] contributoryValuePositions;
        BigDecimal lfdSVBrutto = BigDecimal.ZERO;
        BigDecimal svBruttoEGA = BigDecimal.ZERO;
        block4: for (ValuePosition contributoryValuePosition : contributoryValuePositions = this.mValuePositionHistory.getItemsInside(this.mEffectiveFrom, DateHelper.getLastDayOfMonth((Date)this.mEffectiveFrom), this.mValidFrom, DateHelper.getLastDayOfMonth((Date)this.mValidFrom))) {
            switch (contributoryValuePosition.getValueType().getValueTypeKey()) {
                case 130510: 
                case 130520: {
                    ValuePosition genesisVPLfd = contributoryValuePosition.getValuePositionFromGenesisParent();
                    if (genesisVPLfd == null || genesisVPLfd.getValueType().getValueTypeKey() == 99992 || genesisVPLfd.getValueType().getValueTypeKey() == 99991) continue block4;
                    lfdSVBrutto = lfdSVBrutto.add(contributoryValuePosition.getResult());
                    continue block4;
                }
                case 130610: {
                    ValuePosition genesisVPEGA = contributoryValuePosition.getValuePositionFromGenesisParent();
                    if (genesisVPEGA == null || genesisVPEGA.getValueType().getValueTypeKey() == 99992 || genesisVPEGA.getValueType().getValueTypeKey() == 99991) continue block4;
                    svBruttoEGA = svBruttoEGA.add(contributoryValuePosition.getResult());
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        if (lfdSVBrutto.compareTo(BigDecimal.ZERO) < 0) {
            throw CalculationExceptionMapper.makeNegativeContributoryPaymentLfdDomainException((Date)this.mValidFrom);
        }
        if (svBruttoEGA.compareTo(BigDecimal.ZERO) < 0) {
            throw CalculationExceptionMapper.makeNegativeContributoryPaymentEGADomainException((Date)this.mValidFrom);
        }
    }

    protected ValuePosition[] createValuePosition110595FromCalculationCase() throws BusinessDomainException {
        return new ValuePosition[]{ValuePosition.create(this, 110595)};
    }

    protected ValuePosition[] createValuePosition99999FromCalculationCase(MKPosition[] mk) {
        ValuePosition[] vpArray = ValuePosition.createMKVP(this, 99999, mk);
        return vpArray;
    }

    protected ValuePosition createValuePosition99998FromCalculationCase() throws BusinessDomainException {
        return ValuePosition.create(this, 99998);
    }

    protected ValuePosition createValuePosition99992FromCalculationCase() throws BusinessDomainException {
        return ValuePosition.create(this, 99992);
    }

    protected ValuePosition createValuePosition99998FromOldValueposition() {
        ValuePosition[] vpArray = ValuePosition.getValuePositions(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getEmployee().getObjectid()), Restrictions.le((String)"effectiveFrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)this.mEffectiveFrom)))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.yesterday((Date)this.mEffectiveFrom))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mValidFrom)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.mValidFrom)), Restrictions.eq((String)"oidvaluetype", (String)ValueType.getValueType((int)99998).getObjectid())}));
        if (vpArray.length == 0) {
            return null;
        }
        ValuePosition vp = (ValuePosition)vpArray[0].createNew();
        vp.setEffectiveFrom(this.mEffectiveFrom);
        vp.setEffectiveUntil(VDate.getDateMax());
        return vp;
    }

    protected ValuePosition createValuePosition99992FromOldValueposition() {
        ValuePosition[] vpArray = ValuePosition.getValuePositions(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getEmployee().getObjectid()), Restrictions.le((String)"effectiveFrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)this.mEffectiveFrom)))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.yesterday((Date)this.mEffectiveFrom))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mValidFrom)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.mValidFrom)), Restrictions.eq((String)"oidvaluetype", (String)ValueType.getValueType((int)99992).getObjectid())}));
        if (vpArray.length == 0) {
            return null;
        }
        ValuePosition vp = (ValuePosition)vpArray[0].createNew();
        vp.setEffectiveFrom(this.mEffectiveFrom);
        vp.setEffectiveUntil(VDate.getDateMax());
        return vp;
    }

    protected ValuePosition createValuePosition99997FromCalculationCase() throws BusinessDomainException {
        return ValuePosition.create(this, 99997);
    }

    protected ValuePosition createValuePosition99991FromCalculationCase() throws BusinessDomainException {
        return ValuePosition.create(this, 99991);
    }

    private void ifNecessaryCreateFutureCalculationBasics(PersonnelTimedPersistenceObject boTP, String className) throws BusinessDomainException {
        if (DateHelper.after((Date)boTP.getValidFrom(), (Date)this.getValidFrom())) {
            new CalculationBasic(this.getEmployee(), this.getEffectiveFrom(), boTP.getValidFrom(), className);
        }
        if (!DateHelper.equal((Date)boTP.getValidUntil(), (Date)VDate.getDateMax())) {
            new CalculationBasic(this.getEmployee(), this.getEffectiveFrom(), PDateHelper.getFirstDayNextMonth((Date)boTP.getValidUntil()), className);
        }
        if (boTP instanceof VarPaymentTP || boTP instanceof FixedPaymentTP || boTP instanceof ScalePaymentTP || boTP instanceof EEAbsentTimeTP || boTP instanceof AdvancePaymentTP) {
            if (DateHelper.before((Date)this.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)boTP.getValidFrom()))) {
                new CalculationBasic(this.getEmployee(), this.getEffectiveFrom(), DateHelper.getFirstDayOfMonth((Date)boTP.getValidFrom()), className);
            }
            Date from = PDateHelper.getFirstDayNextMonth((Date)boTP.getValidFrom());
            Date until = boTP.getValidUntil();
            if (DateHelper.equal((Date)until, (Date)VDate.getDateMax())) {
                until = this.getCalculationUntil(this.getEmployee().getJournalizedUntil());
            }
            if (DateHelper.before((Date)this.getValidFrom(), (Date)from) && DateHelper.before((Date)from, (Date)this.getCalculationUntil(this.getEmployee().getJournalizedUntil()))) {
                new CalculationBasic(this.getEmployee(), this.getEffectiveFrom(), from, className);
            }
            if (DateHelper.after((Date)boTP.getValidUntil(), (Date)from) && DateHelper.before((Date)boTP.getValidUntil(), (Date)until)) {
                new CalculationBasic(this.getEmployee(), this.getEffectiveFrom(), DateHelper.getFirstDayOfMonth((Date)boTP.getValidUntil()), className);
            }
            if (DateHelper.before((Date)boTP.getValidUntil(), (Date)until)) {
                new CalculationBasic(this.getEmployee(), this.getEffectiveFrom(), PDateHelper.getFirstDayNextMonth((Date)boTP.getValidUntil()), className);
            }
        }
    }

    protected ValuePosition[] createValuePositionFromEEPensionScheme() throws BusinessDomainException {
        ValuePosition[] vpArray = EMPTY_VP_ARRAY;
        EEPensionSchemeTP[] array = this.mEmployee.getEffectivePensionSchemes(this.getEffectiveFrom(), this.getValidFrom());
        if (array.length > 0) {
            ArrayList<ValuePosition> vpList = new ArrayList<ValuePosition>();
            for (EEPensionSchemeTP each : array) {
                for (ValuePosition vPos : vpArray = ValuePosition.create(each, this)) {
                    vpList.add(vPos);
                }
                this.ifNecessaryCreateFutureCalculationBasics((PersonnelTimedPersistenceObject)each, EEPensionScheme.class.getName());
            }
            if (vpList.size() > 0) {
                vpArray = vpList.toArray(new ValuePosition[vpList.size()]);
            }
        }
        return vpArray;
    }

    protected ValuePosition[] createValuePositionFromERASettings() throws BusinessDomainException {
        ValuePosition[] vpArray = EMPTY_VP_ARRAY;
        EEDataERA dataERA = (EEDataERA)this.mEmployee.getDataERAHistory().getItemOrNull(this.getEffectiveFrom(), this.getValidFrom());
        if (dataERA != null) {
            vpArray = ValuePosition.create(dataERA, this);
        } else {
            Date startOfHistory = this.mEmployee.getDataERAHistory().getMinValidFromOfHistory();
            if (startOfHistory != null && DateHelper.after((Date)startOfHistory, (Date)this.getValidFrom())) {
                new CalculationBasic(this.getEmployee(), this.getEffectiveFrom(), startOfHistory, EEDataERA.class.getName());
            }
        }
        return vpArray;
    }

    protected ValuePosition[] createValuePositionFromFixedPayment() throws BusinessDomainException {
        ValuePosition[] vpArray = EMPTY_VP_ARRAY;
        FixedPaymentTP[] array = this.mEmployee.getEffectiveFixedPayments(this.getEffectiveFrom(), this.getValidFrom());
        if (array.length > 0) {
            ArrayList<ValuePosition> vpList = new ArrayList<ValuePosition>();
            for (FixedPaymentTP each : array) {
                ValuePosition vp = ValuePosition.create(each, this);
                if (vp != null) {
                    vpList.add(vp);
                }
                this.ifNecessaryCreateFutureCalculationBasics((PersonnelTimedPersistenceObject)each, FixedPayment.class.getName());
            }
            if (vpList.size() > 0) {
                vpArray = vpList.toArray(new ValuePosition[vpList.size()]);
            }
        }
        return vpArray;
    }

    protected ValuePosition[] createValuePositionFromVarPayment() throws BusinessDomainException {
        ValuePosition[] vpArray = EMPTY_VP_ARRAY;
        VarPaymentTP[] array = this.mEmployee.getEffectiveVarPayments(this.getEffectiveFrom(), this.getValidFrom());
        if (array.length > 0) {
            ArrayList<ValuePosition> vpList = new ArrayList<ValuePosition>();
            for (VarPaymentTP each : array) {
                ValuePosition vp = ValuePosition.create(each, this);
                if (vp != null) {
                    vpList.add(vp);
                }
                this.ifNecessaryCreateFutureCalculationBasics((PersonnelTimedPersistenceObject)each, VarPayment.class.getName());
            }
            if (vpList.size() > 0) {
                vpArray = vpList.toArray(new ValuePosition[vpList.size()]);
            }
        }
        return vpArray;
    }

    protected ValuePosition[] createValuePositionFromAdvancePayment() throws BusinessDomainException {
        ValuePosition[] vpArray = EMPTY_VP_ARRAY;
        AdvancePaymentTP[] array = this.mEmployee.getEffectiveAdvancePayments(this.getEffectiveFrom(), this.getValidFrom());
        if (array.length > 0) {
            ArrayList<ValuePosition> vpList = new ArrayList<ValuePosition>();
            for (AdvancePaymentTP each : array) {
                ValuePosition vp = ValuePosition.create(each, this);
                if (vp != null) {
                    vpList.add(vp);
                }
                this.ifNecessaryCreateFutureCalculationBasics((PersonnelTimedPersistenceObject)each, AdvancePayment.class.getName());
            }
            if (vpList.size() > 0) {
                vpArray = vpList.toArray(new ValuePosition[vpList.size()]);
            }
        }
        return vpArray;
    }

    protected ValuePosition[] createValuePositionFromEEPieceWork() throws BusinessDomainException {
        ValuePosition[] vpArray = EMPTY_VP_ARRAY;
        EEPieceWorkTP[] array = EEPieceWorkTPPersistencyManager.getEEPieceWorkTPs((String)this.mEmployee.getObjectid(), (Date)this.getEffectiveFrom(), (Date)this.getValidFrom());
        if (array.length > 0) {
            ArrayList<ValuePosition> vpList = new ArrayList<ValuePosition>();
            for (EEPieceWorkTP each : array) {
                ValuePosition vp = ValuePosition.create(each, this);
                if (vp != null) {
                    vpList.add(vp);
                }
                this.ifNecessaryCreateFutureCalculationBasics((PersonnelTimedPersistenceObject)each, EEPieceWork.class.getName());
            }
            if (vpList.size() > 0) {
                vpArray = vpList.toArray(new ValuePosition[vpList.size()]);
            }
        }
        return vpArray;
    }

    protected ValuePosition[] createValuePositionFromScalePayment() throws BusinessDomainException {
        ValuePosition[] vpArray = EMPTY_VP_ARRAY;
        ScalePaymentTP[] array = this.mEmployee.getEffectiveScalePayments(this.getEffectiveFrom(), this.getValidFrom());
        if (array.length > 0) {
            ArrayList<ValuePosition> vpList = new ArrayList<ValuePosition>();
            for (ScalePaymentTP each : array) {
                ValuePosition vp = ValuePosition.create(each, this);
                if (vp != null) {
                    vpList.add(vp);
                }
                this.ifNecessaryCreateFutureCalculationBasics((PersonnelTimedPersistenceObject)each, ScalePayment.class.getName());
            }
            if (vpList.size() > 0) {
                vpArray = vpList.toArray(new ValuePosition[vpList.size()]);
            }
        }
        return vpArray;
    }

    protected ValuePosition[] createValuePositionFromEEPaymentDeduction() throws BusinessDomainException {
        ValuePosition[] vpArray = EMPTY_VP_ARRAY;
        EEPaymentDeductionTP[] array = this.mEmployee.getEffectiveEEPaymentDeductions(this.getEffectiveFrom(), this.getValidFrom());
        if (array.length > 0) {
            ArrayList<ValuePosition> vpList = new ArrayList<ValuePosition>();
            for (EEPaymentDeductionTP each : array) {
                ValuePosition vp = ValuePosition.create(each, this);
                if (vp != null) {
                    vpList.add(vp);
                }
                this.ifNecessaryCreateFutureCalculationBasics((PersonnelTimedPersistenceObject)each, EEPaymentDeduction.class.getName());
            }
            if (vpList.size() > 0) {
                vpArray = vpList.toArray(new ValuePosition[vpList.size()]);
            }
        }
        return vpArray;
    }

    protected ValuePosition[] createValuePositionFromEELoan() throws BusinessDomainException {
        ValuePosition[] vpArray = EMPTY_VP_ARRAY;
        EELoanTP[] array = this.mEmployee.getEffectiveEELoans(this.getEffectiveFrom(), this.getValidFrom());
        if (array.length > 0) {
            ArrayList<ValuePosition> vpList = new ArrayList<ValuePosition>();
            for (EELoanTP each : array) {
                ValuePosition vp = ValuePosition.create(each, this);
                if (vp != null) {
                    vpList.add(vp);
                }
                this.ifNecessaryCreateFutureCalculationBasics((PersonnelTimedPersistenceObject)each, EELoan.class.getName());
            }
            if (vpList.size() > 0) {
                vpArray = vpList.toArray(new ValuePosition[vpList.size()]);
            }
        }
        return vpArray;
    }

    protected ValuePosition[] createValuePositionFromEEAttachment() throws BusinessDomainException {
        ValuePosition[] vpArray;
        EEAttachmentTP[] array = this.mEmployee.getEffectiveEEAttachments(this.getEffectiveFrom(), this.getValidFrom());
        if (array.length > 0) {
            block3: for (EEAttachmentTP eatp : array) {
                switch (eatp.getModeOfAttachment().value()) {
                    case 0: {
                        if (eatp.getOrderFrom() != null) continue block3;
                        throw EvaluationExceptionMapper.makeNoOrderDateInAttachment(eatp, this.getValidFrom());
                    }
                    default: {
                        if (eatp.getReceptDate() != null) continue block3;
                        throw EvaluationExceptionMapper.makeNoReceptDateInAttachment(eatp, this.getValidFrom());
                    }
                }
            }
            Arrays.sort(array, new EEAttachmentTPCalcComparator());
            int rowCount = 1;
            LinkedList<ValuePosition> vpList = new LinkedList<ValuePosition>();
            for (EEAttachmentTP eeATP : array) {
                ValuePosition vp = ValuePosition.create(eeATP, this);
                if (DateHelper.after((Date)eeATP.getValidFrom(), (Date)this.getValidFrom())) {
                    new CalculationBasic(this.mEmployee, this.getEffectiveFrom(), eeATP.getValidFrom(), eeATP.getClassName());
                }
                if (DateHelper.before((Date)eeATP.getValidUntil(), (Date)VDate.getDateMax())) {
                    new CalculationBasic(this.getEmployee(), vp.getEffectiveFrom(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)vp.getValidUntil())), eeATP.getClassName());
                }
                if (vp == null) continue;
                vp.setSecondaryRankingnumber(rowCount);
                vpList.add(vp);
                ++rowCount;
            }
            vpArray = vpList.size() > 0 ? vpList.toArray(new ValuePosition[vpList.size()]) : EMPTY_VP_ARRAY;
        } else {
            vpArray = EMPTY_VP_ARRAY;
        }
        return vpArray;
    }

    protected ValuePosition[] createValuePositionFromEEMaterielExpenses() throws BusinessDomainException {
        ValuePosition[] vpArray = EMPTY_VP_ARRAY;
        EEMaterialExpensesTP[] array = this.mEmployee.getEffectiveEEMaterialExpenses(this.getEffectiveFrom(), this.getValidFrom());
        if (array.length > 0) {
            LinkedList<ValuePosition> vpList = new LinkedList<ValuePosition>();
            for (EEMaterialExpensesTP each : array) {
                if (each.getTypeOfCalculation() != TypeOfCalculation.KEINE) {
                    vpList.addAll(ValuePosition.create(each, this));
                }
                this.ifNecessaryCreateFutureCalculationBasics((PersonnelTimedPersistenceObject)each, EEMaterialExpenses.class.getName());
            }
            if (vpList.size() > 0) {
                vpArray = vpList.toArray(new ValuePosition[vpList.size()]);
            }
        }
        return vpArray;
    }

    protected ValuePosition[] createValuePositionFromEEAbsentTime() throws BusinessDomainException {
        ValuePosition[] vpArray = EMPTY_VP_ARRAY;
        EEAbsentTimeTP[] array = this.mEmployee.getEffectiveEEAbsentTimes(this.getEffectiveFrom(), this.getValidFrom());
        if (array.length > 0) {
            LinkedList<ValuePosition> vpList = new LinkedList<ValuePosition>();
            for (EEAbsentTimeTP each : array) {
                if (this.mDateOfWithDrawal == null || DateHelper.beforeOrEqual((Date)each.getValidFrom(), (Date)this.mDateOfWithDrawal)) {
                    Date validFrom;
                    Date date = validFrom = DateHelper.beforeOrEqual((Date)each.getValidFrom(), (Date)this.getValidFrom()) ? this.getValidFrom() : each.getValidFrom();
                    if (each.getEEAbsentTime().getAbsentTime().getAbsentTimeTP(this.getEffectiveFrom(), validFrom).getValueType() != null) {
                        ValuePosition vp = ValuePosition.create(each, this);
                        if (vp != null) {
                            vpList.add(vp);
                        }
                        this.ifNecessaryCreateFutureCalculationBasics(each, each.getEEAbsentTime().getClassName());
                    }
                    Date from = DateHelper.getFirstDayOfMonth((Date)new VDate(each.getValidFrom()).addMonths(1).getDate());
                    Date until = each.getValidUntil();
                    if (DateHelper.equal((Date)until, (Date)VDate.getDateMax())) {
                        until = this.getCalculationUntil(this.getEmployee().getJournalizedUntil());
                    }
                    if (each.getEEAbsentTime().getAbsentTime().getAbsentTimeTP(each.getEffectiveFrom(), each.getValidFrom()).getDeliminationOfMonth() && DateHelper.before((Date)from, (Date)until)) {
                        int monthDiff = PDateHelper.countAffectedMonths((Date)until, (Date)from);
                        for (int j = 0; j < monthDiff; ++j) {
                            if (!DateHelper.before((Date)this.getValidFrom(), (Date)new VDate(from).addMonths(j).getDate()) || !DateHelper.before((Date)new VDate(from).addMonths(j).getDate(), (Date)this.getCalculationUntil(this.getEmployee().getJournalizedUntil()))) continue;
                            new CalculationBasic(this.getEmployee(), this.getEffectiveFrom(), new VDate(from).addMonths(j).getDate(), each.getClassName());
                        }
                    }
                }
                if (vpList.size() <= 0) continue;
                vpArray = vpList.toArray(new ValuePosition[vpList.size()]);
            }
        }
        return vpArray;
    }

    protected ValuePosition[] createValuePositionFromTransferDifferences() throws BusinessDomainException {
        Date maxRR;
        LinkedList<ValuePosition> resultList = new LinkedList<ValuePosition>();
        ValueType[] valueTypes = ValueTypeHelper.getValueTypes((int[])new int[]{795062, 795063, 795072, 795082, 795092, 795552, 863112, 863122, 863132, 863142, 863152, 863162, 861112, 862112});
        HashSet<CallSite> usedObjectSet = new HashSet<CallSite>();
        Date suchdatum = maxRR = this.tiefsteRR();
        while (DateHelper.before((Date)suchdatum, (Date)this.mValidFrom)) {
            Date validFrom = DateHelper.getFirstDayOfMonth((Date)suchdatum);
            Date validUntil = DateHelper.getLastDayOfMonth((Date)suchdatum);
            ValuePosition[] vpArray = this.getValuePositionHistory().getItems(this.mEffectiveFrom, this.mEffectiveFrom, validFrom, validUntil);
            ArrayList<String> values = new ArrayList<String>(valueTypes.length);
            for (ValueType lValueType : valueTypes) {
                values.add(Integer.toString(lValueType.getValueTypeKey()));
            }
            if (vpArray.length == 0) {
                vpArray = ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.in((String)"valuetypenumber", values), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mEffectiveFrom)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mEffectiveFrom)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validUntil)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validFrom))}));
            }
            if (vpArray.length > 0) {
                ValuePosition[] vpArrayVormonat = this.getValuePostionsSichtVormonat(values, validFrom, validUntil);
                for (ValuePosition element : vpArray) {
                    for (ValueType valueType : valueTypes) {
                        if (element.getValueType().getValueTypeKey() != valueType.getValueTypeKey()) continue;
                        ValuePosition genesisParent = (ValuePosition)element.getGenesisOfParentObjects();
                        PersistentObject rootObject = this.getRootObject(genesisParent);
                        String idRootObject = rootObject.getObjectid() + genesisParent.getValueType().getValueTypeKey();
                        if (this.isGenesisInThisCalculation(rootObject, genesisParent, element, vpArrayVormonat) || usedObjectSet.contains(idRootObject)) continue;
                        ValuePosition vp = (ValuePosition)genesisParent.createNew();
                        vp.setEffectiveFrom(this.mEffectiveFrom);
                        vp.setEffectiveUntil(VDate.getDateMax());
                        vp.setValidFrom(this.mValidFrom);
                        vp.setValidUntil(DateHelper.getLastDayOfMonth((Date)this.mValidFrom));
                        vp.setResult(BigDecimal.ZERO);
                        vp.setBasicResult(BigDecimal.ZERO);
                        vp.setRanking(-1);
                        resultList.add(vp);
                        usedObjectSet.add((CallSite)((Object)idRootObject));
                    }
                }
            }
            suchdatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchdatum));
        }
        ValuePosition[] result = new ValuePosition[resultList.size()];
        return resultList.toArray(result);
    }

    private Date tiefsteRR() throws BusinessDomainException {
        CalculationBasic[] basics = CalculationBasicPersistencyManager.query((Order[])new Order[]{Order.asc((String)"validfrom")}, (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), (Criterion)Restrictions.eq((String)"effectivefrom", (String)DateMapper.toString((Date)this.mValidFrom))), (boolean)true);
        if (basics.length != 0) {
            return basics[0].getValidFrom();
        }
        return this.mValidFrom;
    }

    private ValuePosition[] getValuePostionsSichtVormonat(ArrayList<String> values, Date validFrom, Date validUntil) {
        Date effectiveFrom = DateHelper.addMonths((Date)this.mEffectiveFrom, (int)-1);
        return ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.in((String)"valuetypenumber", values), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveFrom)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveFrom)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validUntil)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validFrom))}));
    }

    private boolean isGenesisInThisCalculation(PersistentObject po, ValuePosition genesisParent, ValuePosition valuePosition, ValuePosition[] vpArrayVormonat) {
        boolean isGenesisInThisCalculation = false;
        for (ValuePosition vp : vpArrayVormonat) {
            ValuePosition genesis;
            if (valuePosition.getValueType().getValueTypeKey() != vp.getValueType().getValueTypeKey() || BigDecimalMapper.compareTo((BigDecimal)valuePosition.getResult(), (BigDecimal)vp.getResult()) != 0 || !PersonnelPersistenceObject.isEqual((IPersistentObject)po, (IPersistentObject)this.getRootObject(genesis = (ValuePosition)vp.getGenesisOfParentObjects()))) continue;
            isGenesisInThisCalculation = true;
        }
        if (!isGenesisInThisCalculation) {
            ValuePosition[] vpArray;
            for (ValuePosition element : vpArray = this.getValuePositionHistory().getItems(this.mEffectiveFrom, this.mEffectiveFrom, this.mValidFrom, this.mValidFrom)) {
                if (genesisParent.getValueType().getValueTypeKey() != element.getValueType().getValueTypeKey() || !PersonnelPersistenceObject.isEqual((IPersistentObject)po, (IPersistentObject)this.getRootObject(element))) continue;
                isGenesisInThisCalculation = true;
            }
        }
        return isGenesisInThisCalculation;
    }

    private PersistentObject getRootObject(ValuePosition valuePosition) {
        PersistentObject genesisRoot = valuePosition.getRootGenesisOfParentObjects();
        PersistentObject genesis = valuePosition.getGenesisOfParentObjects();
        if (genesis instanceof EEAttachment) {
            return genesis;
        }
        if (genesis instanceof EEPensionSchemeTP) {
            EEPensionScheme pensionScheme = null;
            pensionScheme = genesisRoot != null ? (EEPensionScheme)genesisRoot : ((EEPensionSchemeTP)genesis).getEEPensionScheme();
            return pensionScheme;
        }
        if (genesis instanceof EEPaymentDeductionTP) {
            EEPaymentDeduction paymentDeduction = null;
            paymentDeduction = genesisRoot != null ? (EEPaymentDeduction)genesisRoot : ((EEPaymentDeductionTP)genesis).getEEPaymentDeduction();
            return paymentDeduction;
        }
        return genesis;
    }

    private void createOverPaymentPreviousMonth(Date effectiveFrom, Date validFrom) {
        Date ef = null;
        Date vf = null;
        if (DateHelper.after((Date)validFrom, (Date)effectiveFrom)) {
            ef = effectiveFrom;
            vf = DateHelper.yesterday((Date)validFrom);
        } else {
            ef = DateHelper.yesterday((Date)effectiveFrom);
            vf = DateHelper.yesterday((Date)validFrom);
        }
        ValuePosition[] vpArray = ValuePosition.getValuePositions(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getEmployee().getObjectid()), Restrictions.le((String)"effectiveFrom", (String)DateMapper.toString((Date)ef)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)ef)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)vf)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)vf)), Restrictions.eq((String)"valuetypenumber", (String)"890100")}));
        if (vpArray.length > 0) {
            this.mOverPaymentPreviousMonthExist = true;
            this.mOverPaymentPreviousMonthResult = vpArray[0].getResult();
            ValuePosition newVP = new ValuePosition(this.getEmployee(), ValueType.getValueType((int)880000), null, null);
            newVP.setEffectiveFrom(effectiveFrom);
            newVP.setEffectiveUntil(VDate.getDateMax());
            newVP.setValidFrom(validFrom);
            newVP.setValidUntil(DateHelper.getLastDayOfMonth((Date)validFrom));
            newVP.setFactor1(BigDecimal.ZERO);
            newVP.setFactor2(BigDecimal.ZERO);
            newVP.setResult(vpArray[0].getResult());
            this.mValuePositionHistory.addItem(newVP);
            new CalculationBasic(this.mEmployee, this.getEffectiveFrom(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)this.mValidFrom)), this.getClassName());
        }
    }

    protected void createBalanceOfNet() {
        Date until = DateHelper.getFirstDayOfMonth((Date)this.getEffectiveFrom());
        Date from = this.getValidFrom();
        while (DateHelper.before((Date)from, (Date)until)) {
            Date validUntil = DateHelper.getLastDayOfMonth((Date)from);
            ValuePosition newVP = new ValuePosition(this.getEmployee(), ValueType.getValueType((int)882110), null, null);
            newVP.setEffectiveFrom(this.getEffectiveFrom());
            newVP.setEffectiveUntil(VDate.getDateMax());
            newVP.setValidFrom(from);
            newVP.setValidUntil(validUntil);
            newVP.setFactor1(BigDecimal.ZERO);
            newVP.setFactor2(BigDecimal.ZERO);
            newVP.setResult(BigDecimal.ZERO);
            this.mValuePositionHistory.addItem(newVP);
            newVP = new ValuePosition(this.getEmployee(), ValueType.getValueType((int)881000), null, null);
            newVP.setEffectiveFrom(this.getEffectiveFrom());
            newVP.setEffectiveUntil(VDate.getDateMax());
            newVP.setValidFrom(from);
            newVP.setValidUntil(validUntil);
            newVP.setFactor1(BigDecimal.ZERO);
            newVP.setFactor2(BigDecimal.ZERO);
            newVP.setResult(BigDecimal.ZERO);
            this.mValuePositionHistory.addItem(newVP);
            from = this.addMonth(from, 1);
        }
    }

    protected void calculateSumOfBalanceOfNet() {
        ValuePosition[] newVPs = EMPTY_VP_ARRAY;
        ValuePosition[] oldVPs = EMPTY_VP_ARRAY;
        BigDecimal result = BigDecimal.valueOf(0L);
        if (DateHelper.after((Date)this.getEffectiveFrom(), (Date)this.getValidFrom())) {
            for (ValuePosition newVP : newVPs = this.mValuePositionHistory.getItems(882000)) {
                newVP.makeReadOnly();
                result = result.add(newVP.getResult());
            }
            for (ValuePosition oldVP : oldVPs = ValuePosition.getDifferencesOfNet(this.getEmployee().getObjectid(), this.getEffectiveFrom(), DateHelper.getLastDayOfMonth((Date)new VDate(this.getValidFrom()).addMonths(-1).getDate()))) {
                result = result.add(oldVP.getResult());
            }
        }
        if (DateHelper.equal((Date)this.getEffectiveFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)this.getValidFrom()))) {
            for (ValuePosition oldVP : oldVPs = ValuePosition.getDifferencesOfNet(this.getEmployee().getObjectid(), this.getEffectiveFrom(), this.getValidFrom())) {
                result = result.add(oldVP.getResult());
            }
        }
        if (newVPs.length > 0 || oldVPs.length > 0) {
            ValuePosition newVP = new ValuePosition(this.getEmployee(), ValueType.getValueType((int)882000), null, null);
            newVP.setEffectiveFrom(this.getEffectiveFrom());
            newVP.setEffectiveUntil(VDate.getDateMax());
            newVP.setValidFrom(this.getEffectiveFrom());
            newVP.setValidUntil(DateHelper.getLastDayOfMonth((Date)this.getEffectiveFrom()));
            newVP.setFactor1(BigDecimal.ZERO);
            newVP.setFactor2(BigDecimal.ZERO);
            newVP.setResult(result);
            this.mValuePositionHistory.addItem(newVP);
        }
    }

    protected void createAndEvaluateNetPay() throws BusinessDomainException {
        ValuePosition vpnp;
        int j;
        Date maximumDateOfEntry = this.getEmployee().getMinimumDateOfEntry();
        Date calculationStart = this.getEmployee().getPCompany().getCompanyFoundations(VDate.getDateMax(), VDate.getDateMax()).getCalculationStart();
        Date potentialStart = null;
        potentialStart = DateHelper.beforeOrEqual((Date)maximumDateOfEntry, (Date)calculationStart) ? calculationStart : maximumDateOfEntry;
        HashMap<Date, Date> map = new HashMap<Date, Date>();
        Date mDate = null;
        for (int i = 0; i < this.mValuePositionHistory.getSize(); ++i) {
            Date mDate1;
            ValuePosition vp = this.mValuePositionHistory.getAll().get(i);
            if (vp.getValueType().getValueTypeKey() == 881000 || vp.getValueType().getValueTypeKey() == 882110) continue;
            mDate = DateHelper.before((Date)vp.getValidFrom(), (Date)vp.getEffectiveFrom()) ? DateHelper.getFirstDayOfMonth((Date)vp.getEffectiveFrom()) : DateHelper.getFirstDayOfMonth((Date)vp.getValidFrom());
            if (DateHelper.before((Date)mDate, (Date)potentialStart)) {
                mDate = potentialStart;
                mDate1 = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)potentialStart));
                if (!map.containsKey(mDate1)) {
                    map.put(mDate1, mDate1);
                }
            }
            if (!map.containsKey(mDate)) {
                map.put(mDate, mDate);
            }
            if (new VDate(vp.getValidUntil()).getYear() == 2099 || map.containsKey(mDate1 = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)vp.getValidUntil())))) continue;
            map.put(mDate1, mDate1);
        }
        if (DateHelper.afterOrEqual((Date)this.getEffectiveFrom(), (Date)this.getValidFrom()) && !map.containsKey(mDate = new VDate(this.getEffectiveFrom()).addMonths(1).getDate())) {
            map.put(mDate, mDate);
        }
        Date effective = this.getEffectiveFrom();
        Date valid = null;
        ArrayList mList = new ArrayList(map.keySet());
        if (this.mDateOfWithDrawal != null) {
            for (int j2 = 0; j2 < mList.size(); ++j2) {
                if ((!DateHelper.beforeOrEqual((Date)this.getEffectiveFrom(), (Date)this.mDateOfWithDrawal) || !DateHelper.after((Date)((Date)mList.get(j2)), (Date)this.mDateOfWithDrawal)) && (!DateHelper.after((Date)this.getEffectiveFrom(), (Date)this.mDateOfWithDrawal) || !DateHelper.after((Date)((Date)mList.get(j2)), (Date)this.getEffectiveFrom()))) continue;
                mList.remove(j2);
            }
        }
        Date[] datesFrom = new Date[mList.size()];
        datesFrom = mList.toArray(datesFrom);
        Arrays.sort(datesFrom, new DateComparator());
        Date[] datesUntil = new Date[datesFrom.length];
        if (datesFrom.length > 0) {
            for (j = 0; j < datesFrom.length - 1; ++j) {
                datesUntil[j] = DateHelper.yesterday((Date)datesFrom[j + 1]);
            }
            datesUntil[datesUntil.length - 1] = VDate.getDateMax();
        }
        for (j = 0; j < datesFrom.length; ++j) {
            ValuePosition[] subVPArray;
            ValuePosition[] dedVPArray;
            ValuePosition[] vpArray;
            valid = datesFrom[j];
            if (DateHelper.beforeOrEqual((Date)effective, (Date)datesFrom[j])) {
                this.createOverPaymentPreviousMonth(effective, datesFrom[j]);
            }
            vpnp = new ValuePosition(this.getEmployee(), ValueType.getValueType((int)890000), null, null);
            vpnp.setEffectiveFrom(effective);
            vpnp.setEffectiveUntil(VDate.getDateMax());
            vpnp.setValidFrom(datesFrom[j]);
            vpnp.setValidUntil(datesUntil[j]);
            vpnp.setFactor1(BigDecimal.ZERO);
            vpnp.setFactor2(BigDecimal.ZERO);
            vpnp.setResult(BigDecimal.ZERO);
            for (ValuePosition vPos : vpArray = this.mValuePositionHistory.getItemsInside(DateHelper.getFirstDayOfMonth((Date)effective), DateHelper.getLastDayOfMonth((Date)effective), DateHelper.getFirstDayOfMonth((Date)valid), DateHelper.getLastDayOfMonth((Date)valid))) {
                if (vPos.getValueType().getValueTypeKey() != 700100) continue;
                vpnp.setResult(vpnp.getResult().add(vPos.getResult()));
            }
            for (ValuePosition vPos : dedVPArray = ValuePosition.getValuePositionsCategory(vpArray, CategoryEnum.CE_SYS_Abzug_nach_Nettolohn, effective, valid)) {
                vpnp.setResult(vpnp.getResult().subtract(vPos.getResult()));
            }
            for (ValuePosition valuePosition : subVPArray = ValuePosition.getValuePositionsCategory(vpArray, CategoryEnum.CE_SYS_Bezug_nach_Nettolohn, effective, valid)) {
                vpnp.setResult(vpnp.getResult().add(valuePosition.getResult()));
            }
            if (DateHelper.afterOrEqual((Date)this.getEffectiveFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)this.getValidFrom())) && DateHelper.equal((Date)this.getEffectiveFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)valid))) {
                ValuePosition[] array;
                LinkedList<ValuePosition> list = new LinkedList<ValuePosition>();
                for (ValuePosition vPos2 : array = ValuePosition.getDifferencesOfNet(this.getEmployee().getObjectid(), this.getEffectiveFrom(), valid)) {
                    list.add(vPos2);
                }
                array = this.mValuePositionHistory.getItems(882000);
                for (int i = 0; i < array.length; ++i) {
                    if (DateHelper.equal((Date)array[i].getEffectiveFrom(), (Date)array[i].getValidFrom())) continue;
                    list.add(array[i]);
                }
                ValuePosition[] vpDiffOfNetArray = new ValuePosition[list.size()];
                for (ValuePosition vPos3 : vpDiffOfNetArray = list.toArray(vpDiffOfNetArray)) {
                    vpnp.setResult(vpnp.getResult().add(vPos3.getResult()));
                }
            }
            if (this.mOverPaymentPreviousMonthExist) {
                if (vpnp.getResult().compareTo(this.mOverPaymentPreviousMonthResult.negate()) != 0) {
                    new CalculationBasic(this.getEmployee(), this.getEffectiveFrom(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)vpnp.getValidFrom())), this.getClassName());
                    this.mOverPaymentPreviousMonthExist = false;
                }
            } else if (vpnp.getResult().compareTo(BigDecimal.ZERO) < 0) {
                new CalculationBasic(this.getEmployee(), this.getEffectiveFrom(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)vpnp.getValidFrom())), this.getClassName());
            }
            if (vpnp.getResult().compareTo(BigDecimal.ZERO) < 0) {
                vpnp.makeReadOnly();
                if (!DateHelper.beforeOrEqual((Date)vpnp.getEffectiveFrom(), (Date)vpnp.getValidFrom())) continue;
                ValuePosition vpop = new ValuePosition(this.getEmployee(), ValueType.getValueType((int)890100), null, null);
                vpop.setEffectiveFrom(vpnp.getEffectiveFrom());
                vpop.setEffectiveUntil(vpnp.getEffectiveUntil());
                vpop.setValidFrom(vpnp.getValidFrom());
                vpop.setValidUntil(VDate.getDateMax());
                vpop.setFactor1(BigDecimal.ZERO);
                vpop.setFactor2(BigDecimal.ZERO);
                vpop.setResult(BigDecimal.ZERO);
                vpop.setResult(vpnp.getResult().negate());
                this.addNetPayToValuePositionHistory(vpop);
                Date ef = vpop.getEffectiveFrom();
                Date eu = VDate.getDateMax();
                Date date = new VDate(vpop.getValidFrom()).addMonths(1).getDate();
                Date vu = VDate.getDateMax();
                ValuePosition vpopPreviousMonth = new ValuePosition(this.getEmployee(), ValueType.getValueType((int)880000), null, null);
                vpopPreviousMonth.setEffectiveFrom(ef);
                vpopPreviousMonth.setEffectiveUntil(eu);
                vpopPreviousMonth.setValidFrom(date);
                vpopPreviousMonth.setValidUntil(vu);
                vpopPreviousMonth.setFactor1(BigDecimal.ZERO);
                vpopPreviousMonth.setFactor2(BigDecimal.ZERO);
                vpopPreviousMonth.setResult(BigDecimal.ZERO);
                vpopPreviousMonth.setResult(vpop.getResult());
                this.mValuePositionHistory.addItem(vpopPreviousMonth);
                continue;
            }
            if (!DateHelper.beforeOrEqual((Date)vpnp.getEffectiveFrom(), (Date)vpnp.getValidFrom())) continue;
            this.addNetPayToValuePositionHistory(vpnp);
        }
        if (DateHelper.afterOrEqual((Date)this.getValidFrom(), (Date)new VDate(2013, 0, 1).getDate()) && datesFrom.length == 0) {
            this.createOverPaymentPreviousMonth(this.getEffectiveFrom(), this.getValidFrom());
            if (this.mValuePositionHistory.getSize() > 0) {
                ValuePosition vpop = new ValuePosition(this.getEmployee(), ValueType.getValueType((int)890100), null, null);
                vpop.setEffectiveFrom(this.getEffectiveFrom());
                vpop.setEffectiveUntil(VDate.getDateMax());
                vpop.setValidFrom(this.getValidFrom());
                vpop.setValidUntil(VDate.getDateMax());
                vpop.setFactor1(BigDecimal.ZERO);
                vpop.setFactor2(BigDecimal.ZERO);
                vpop.setResult(BigDecimal.ZERO);
                vpnp = this.mValuePositionHistory.getItem(0);
                vpop.setResult(vpnp.getResult());
                this.mValuePositionHistory.addItem(vpop);
            }
        }
    }

    private void addNetPayToValuePositionHistory(ValuePosition vp) throws BusinessDomainException {
        Employee successor;
        if (this.mDateOfWithDrawal != null && DateHelper.afterOrEqual((Date)this.mDateOfWithDrawal, (Date)new VDate(2019, 0, 1).getDate()) && DateHelper.beforeOrEqual((Date)this.mDateOfWithDrawal, (Date)vp.getValidUntil()) && (successor = this.mEmployee.getSuccessor()) != null && DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)vp.getEffectiveFrom()), (Date)DateHelper.getFirstDayOfMonth((Date)vp.getValidFrom()))) {
            BigDecimal uebertrag = BigDecimal.ZERO;
            switch (vp.getValueType().getValueTypeKey()) {
                case 890000: {
                    uebertrag = vp.getResult();
                    break;
                }
                case 890100: {
                    uebertrag = vp.getResult().negate();
                }
            }
            Date successorValidFrom = this.getSucceccorValidFrom(successor, vp);
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)uebertrag)) {
                uebertrag = uebertrag.setScale(2, RoundingMode.HALF_UP);
                ValuePosition uebergabeVP = new ValuePosition(this.getEmployee(), ValueType.getValueType((int)889991), null, null);
                uebergabeVP.setEffectiveFrom(this.getEffectiveFrom());
                uebergabeVP.setEffectiveUntil(VDate.getDateMax());
                uebergabeVP.setValidFrom(vp.getValidFrom());
                uebergabeVP.setValidUntil(vp.getValidUntil());
                uebergabeVP.setFactor1(BigDecimal.ZERO);
                uebergabeVP.setFactor2(BigDecimal.ZERO);
                uebergabeVP.setResult(uebertrag);
                this.mValuePositionHistory.addItem(uebergabeVP);
                ValuePosition summeUebergabe = new ValuePosition(this.getEmployee(), ValueType.getValueType((int)889990), null, null);
                summeUebergabe.setEffectiveFrom(this.getEffectiveFrom());
                summeUebergabe.setEffectiveUntil(VDate.getDateMax());
                summeUebergabe.setValidFrom(vp.getValidFrom());
                summeUebergabe.setValidUntil(vp.getValidUntil());
                summeUebergabe.setFactor1(BigDecimal.ZERO);
                summeUebergabe.setFactor2(BigDecimal.ZERO);
                summeUebergabe.setResult(uebertrag);
                this.mValuePositionHistory.addItem(summeUebergabe);
                this.createVarPayment(successor, uebertrag, successorValidFrom);
                vp.setResult(BigDecimal.ZERO);
            } else {
                this.deleteVarPayment(successor, uebertrag, successorValidFrom);
            }
            this.mCalculation.setSuccessor(successor);
            this.mCalculation.setSuccessorEvaluationValidFrom(successorValidFrom);
        }
        this.mValuePositionHistory.addItem(vp);
    }

    private Date getSucceccorValidFrom(Employee successor, ValuePosition vp) {
        Employment[] empls;
        Date validFrom = vp.getValidFrom();
        for (Employment empl : empls = successor.getEmploymentHistory(vp.getEffectiveFrom(), vp.getValidFrom(), vp.getValidUntil())) {
            Date dateOfWithDrawal = empl.getDateOfWithDrawal();
            if (dateOfWithDrawal == null || !DateHelper.before((Date)dateOfWithDrawal, (Date)validFrom)) continue;
            Date dateOfEntry = empl.getDateOfEntry();
            validFrom = DateHelper.between((Date)dateOfEntry, (Date)DateHelper.getFirstDayOfMonth((Date)dateOfWithDrawal), (Date)DateHelper.getLastDayOfMonth((Date)dateOfWithDrawal)) ? dateOfEntry : DateHelper.getFirstDayOfMonth((Date)dateOfWithDrawal);
        }
        return validFrom;
    }

    private void createVarPayment(Employee successor, BigDecimal uebertrag, Date validFrom) throws BusinessDomainException {
        boolean hatVarpayment = this.updateVarPayment(successor, uebertrag, validFrom);
        if (!hatVarpayment) {
            VarPayment varPayment = new VarPayment(successor);
            varPayment.setValueType(ValueType.getValueType((int)99950));
            VarPaymentTP varPaymentTP = new VarPaymentTP(varPayment);
            varPaymentTP.setEffectiveFrom(DateHelper.tomorrow((Date)successor.getJournalizedUntil()));
            varPaymentTP.setEffectiveUntil(VDate.getDateMax());
            varPaymentTP.setValidFrom(validFrom);
            varPaymentTP.setValidUntil(DateHelper.getLastDayOfMonth((Date)validFrom));
            varPaymentTP.setResult(uebertrag);
            varPayment.addHistory(varPaymentTP, true);
        }
    }

    private boolean updateVarPayment(Employee successor, BigDecimal uebertrag, Date validFrom) throws BusinessDomainException {
        Date effectiveDateSuccessor = DateHelper.tomorrow((Date)successor.getJournalizedUntil());
        VarPaymentTP[] array = successor.getEffectiveVarPayments(effectiveDateSuccessor, validFrom);
        boolean hatVarpayment = false;
        for (VarPaymentTP vptp : array) {
            if (vptp.getVarPayment().getValueType().getValueTypeKey() != 99950 || !DateHelper.equal((Date)vptp.getEffectiveFrom(), (Date)effectiveDateSuccessor)) continue;
            vptp.setResult(uebertrag);
            vptp.getVarPayment().setHistory(vptp, false, effectiveDateSuccessor);
            hatVarpayment = true;
        }
        return hatVarpayment;
    }

    private void deleteVarPayment(Employee successor, BigDecimal uebertrag, Date validFrom) throws BusinessDomainException {
        VarPaymentTP[] array;
        Date effectiveDateSuccessor = DateHelper.tomorrow((Date)successor.getJournalizedUntil());
        for (VarPaymentTP vptp : array = successor.getEffectiveVarPayments(effectiveDateSuccessor, validFrom)) {
            VarPayment varPayment = vptp.getVarPayment();
            if (varPayment.getValueType().getValueTypeKey() != 99950 || !DateHelper.equal((Date)vptp.getEffectiveFrom(), (Date)effectiveDateSuccessor)) continue;
            varPayment.makeSaveable();
            varPayment.deleteVarPayment();
        }
    }

    protected void limitOfValidityOfValuePositions() {
        if (this.mValuePositionHistory.getSize() > 0) {
            for (int i = this.mValuePositionHistory.getSize() - 1; i >= 0; --i) {
                ValuePosition vp = this.mValuePositionHistory.getItem(i);
                if (!DateHelper.between((Date)this.mDateOfWithDrawal, (Date)vp.getValidFrom(), (Date)vp.getValidUntil())) continue;
                vp.setValidUntil(this.mDateOfWithDrawal);
            }
        }
    }

    protected void limitOfValuePositions() {
        if (this.mValuePositionHistory.getSize() > 0) {
            for (ValuePosition vp : this.mValuePositionHistory.getAll()) {
                if (DateHelper.after((Date)vp.getValidFrom(), (Date)this.mDateOfWithDrawal)) {
                    if (vp.getValueType().getValueTypeKey() == 890100 || vp.getValueType().getValueTypeKey() == 880000) continue;
                    vp.setValidUntil(DateHelper.getLastDayOfMonth((Date)vp.getValidFrom()));
                    continue;
                }
                if (vp.getValueType().getValueTypeKey() == 890100 || vp.getValueType().getValueTypeKey() == 880000 || !DateHelper.between((Date)this.mDateOfWithDrawal, (Date)vp.getValidFrom(), (Date)vp.getValidUntil())) continue;
                vp.setValidUntil(this.mDateOfWithDrawal);
            }
        }
    }

    private Date addMonth(Date date, int month) {
        return new VDate(date).addMonths(month).getDate();
    }

    private void checkPaidOvertime() throws BusinessDomainException {
        int checkArbZG;
        HashMap<String, ValueType> vtHashMap;
        LinkedList<Object> paidOvertimeVTList;
        BigDecimal wochenDurchschnitt;
        BigDecimal sollArbeitsStunden;
        BigDecimal stunden;
        int months;
        WorkingTimeTP workingTimeTP;
        block20: {
            workingTimeTP = null;
            months = 0;
            stunden = BigDecimal.ZERO;
            sollArbeitsStunden = BigDecimal.ZERO;
            wochenDurchschnitt = BigDecimal.ZERO;
            paidOvertimeVTList = new LinkedList();
            vtHashMap = new HashMap<String, ValueType>();
            checkArbZG = 0;
            try {
                checkArbZG = this.mEmployee.getEEWork(this.mEffectiveFrom, this.mValidFrom).getControlOvertimeHour().value();
            }
            catch (BusinessDomainException de) {
                if (this.isHistoryException(de)) break block20;
                throw de;
            }
        }
        if (checkArbZG > 0) {
            ValuePosition[] vpArray;
            switch (checkArbZG) {
                case 1: {
                    months = 1;
                    break;
                }
                case 2: {
                    months = 6;
                    break;
                }
                case 3: {
                    months = 12;
                }
            }
            for (ValuePosition valuePosition : vpArray = this.mValuePositionHistory.getItems(this.mEffectiveFrom, this.mValidFrom)) {
                ValueType vt = valuePosition.getValueType();
                ValueTypeTP vttp = vt.getValueTypeTP(this.mEffectiveFrom, this.mValidFrom);
                if (!vttp.getValueTypeFoundation().getGeneral().getPaidOvertimeHour() || vtHashMap.get(vt.getObjectid()) != null) continue;
                vtHashMap.put(vt.getObjectid(), vt);
            }
            if (!vtHashMap.isEmpty()) {
                int i;
                paidOvertimeVTList = new LinkedList(vtHashMap.values());
                Date validTimePoint = this.mValidFrom;
                for (i = 0; i < months; ++i) {
                    vpArray = this.getValuePositionHistory().getItems(this.mEffectiveFrom, this.mEffectiveFrom, validTimePoint, validTimePoint);
                    if (vpArray.length == 0) {
                        ArrayList<String> values = new ArrayList<String>(paidOvertimeVTList.size());
                        for (ValueType valueType : paidOvertimeVTList) {
                            values.add(Integer.toString(valueType.getValueTypeKey()));
                        }
                        vpArray = ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getEmployee().getObjectid()), Restrictions.in((String)"valuetypenumber", values), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mEffectiveFrom)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mEffectiveFrom)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validTimePoint)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validTimePoint))}));
                    }
                    for (ValuePosition element : vpArray) {
                        for (ValueType valueType : paidOvertimeVTList) {
                            if (element.getValueType().getValueTypeKey() != valueType.getValueTypeKey()) continue;
                            stunden = stunden.add(element.getFactor1());
                        }
                    }
                    validTimePoint = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)validTimePoint));
                }
                if (!BigDecimalMapper.isZero((BigDecimal)stunden)) {
                    validTimePoint = this.mValidFrom;
                    for (i = 0; i < months; ++i) {
                        workingTimeTP = this.mEmployee.getWorkingTimeTP(this.mEffectiveFrom, validTimePoint);
                        if (workingTimeTP != null) {
                            sollArbeitsStunden = sollArbeitsStunden.add(workingTimeTP.getMonthlyTargetHours());
                        }
                        validTimePoint = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)validTimePoint));
                    }
                    if (!BigDecimalMapper.isZero((BigDecimal)sollArbeitsStunden)) {
                        BigDecimal stundenSumme = sollArbeitsStunden.add(stunden);
                        BigDecimal monatsDurchschnitt = stundenSumme.divide(BigDecimal.valueOf(months), 2, RoundingMode.HALF_UP);
                        wochenDurchschnitt = monatsDurchschnitt.divide(BigDecimal.valueOf(4333L, 3), 2, RoundingMode.HALF_UP);
                    }
                }
                if (BigDecimalMapper.compareTo((BigDecimal)wochenDurchschnitt, (BigDecimal)BigDecimal.valueOf(48L)) > 0) {
                    BigDecimal anzahl = wochenDurchschnitt.subtract(BigDecimal.valueOf(48L)).multiply(BigDecimal.valueOf(4333L, 3));
                    anzahl = anzahl.multiply(BigDecimal.valueOf(months)).setScale(2, RoundingMode.HALF_UP);
                    String monat = DateMapper.toDDMMYYYYPointSeparationString((Date)this.mValidFrom).substring(3);
                    throw EvaluationExceptionMapper.makeNumberOfPaidOvertimeExceededDomainException(BigDecimalHelper.toString((BigDecimal)anzahl).replace('.', ',') + " Std. f\u00fcr den Monat " + monat);
                }
            }
        }
    }

    public void setGrossWageConversion(ValueType lGrossWage, ValueType lGrossWageCut) {
        if (!this.mGrossWageConversion) {
            this.mGrossWageConversion = true;
            LinkedList<ValueType> grossWageCutList = new LinkedList<ValueType>();
            grossWageCutList.add(lGrossWageCut);
            this.mGrossWageConversionMap.put(lGrossWage, grossWageCutList);
        } else if (this.mGrossWageConversionMap.containsKey(lGrossWage)) {
            List<ValueType> grossWageCutList = this.mGrossWageConversionMap.get(lGrossWage);
            grossWageCutList.add(lGrossWageCut);
        } else {
            LinkedList<ValueType> grossWageCutList = new LinkedList<ValueType>();
            grossWageCutList.add(lGrossWageCut);
            this.mGrossWageConversionMap.put(lGrossWage, grossWageCutList);
        }
    }

    public BigDecimal getBufferSIDays() {
        return this.mBufferSIDays;
    }

    public void setBufferSIDays(BigDecimal bufferSIDays) {
        this.mBufferSIDays = bufferSIDays;
    }

    public BigDecimal getBufferTaxDays() {
        return this.mBufferTaxDays;
    }

    public void setBufferTaxDays(BigDecimal bufferTaxDays) {
        this.mBufferTaxDays = bufferTaxDays;
    }

    public Date getCalculationUntil(Date journalizedUntil) throws BusinessDomainException {
        if (this.mCalculationUntil == null) {
            PersonnelBasic pb = PersonnelBasic.getPersonnelBasic();
            this.mCalculationUntil = pb.getCalculationUntil(journalizedUntil);
        }
        return this.mCalculationUntil;
    }

    public boolean isGleitzoneChecked() {
        return this.mGleitzoneChecked;
    }

    public void setGleitzoneChecked(boolean b) {
        this.mGleitzoneChecked = b;
    }

    public void setGleitzoneKV(boolean b) {
        this.mGleitzoneKV = b;
    }

    public void setGleitzoneRV(boolean b) {
        this.mGleitzoneRV = b;
    }

    public void setGleitzoneAV(boolean b) {
        this.mGleitzoneAV = b;
    }

    public void setGleitzonePV(boolean b) {
        this.mGleitzonePV = b;
    }

    public void setGleitzoneInsG(boolean b) {
        this.mGleitzoneInsG = b;
    }

    public boolean isGleitzoneKV() {
        return this.mGleitzoneKV;
    }

    public boolean isGleitzoneRV() {
        return this.mGleitzoneRV;
    }

    public boolean isGleitzoneAV() {
        return this.mGleitzoneAV;
    }

    public boolean isGleitzonePV() {
        return this.mGleitzonePV;
    }

    public boolean isGleitzoneInsG() {
        return this.mGleitzoneInsG;
    }

    public void set23cSGBIVchecked(boolean b) {
        this.m23cSGBIVchecked = b;
    }

    public boolean is23cSGBIVchecked() {
        return this.m23cSGBIVchecked;
    }

    public void setZVKFoerderbetragChecked(boolean b) {
        this.mZVKFoerderbetragChecked = b;
    }

    public boolean isZVKFoerderbetragChecked() {
        return this.mZVKFoerderbetragChecked;
    }

    public void setHasZVKFoerderbetrag(boolean b) {
        this.mHasZVKFoerderbetrag = b;
    }

    public boolean hasZVKFoerderbetrag() {
        return this.mHasZVKFoerderbetrag;
    }

    public void setZVKFoerderbetrag(BigDecimal betrag) {
        this.mZVKFoerderbetrag = betrag;
    }

    public BigDecimal getZVKFoerderbetrag() {
        return this.mZVKFoerderbetrag;
    }

    public List<TaskReminder> getTaskReminderList() {
        if (this.mTaskreminders == null) {
            this.mTaskreminders = new ArrayList<TaskReminder>();
        }
        return this.mTaskreminders;
    }

    public void addTaskreminder(TaskReminder reminder) {
        if (this.mTaskreminders == null) {
            this.mTaskreminders = new ArrayList<TaskReminder>();
        }
        this.mTaskreminders.add(reminder);
    }

    public void setAnzurechnendeSteuer(BigDecimal anzurechnendeSteuer) {
        this.mAnzurechnendeSteuer = anzurechnendeSteuer;
    }

    public BigDecimal getAnzurechnendeSteuer() {
        return this.mAnzurechnendeSteuer;
    }

    protected void toStringValues(StringBuilder b) {
        b.append((Object)this.mEmployee).append(',');
        b.append(DateMapper.toString((Date)this.mEffectiveFrom)).append(',');
        b.append(DateMapper.toString((Date)this.mValidFrom)).append(',');
    }

    public boolean isUnchangedZVKBrutto() {
        return this.mUnchangedZvkBrutto;
    }

    public void setUnchangedZVKBrutto(boolean b) {
        this.mUnchangedZvkBrutto = b;
    }

    public boolean isZVKBruttoCheckedForCalculationCase() {
        return this.mZvkBruttoCheckedForCalculation;
    }

    public void setZVKBruttoCheckedForCalculationCase(boolean b) {
        this.mZvkBruttoCheckedForCalculation = b;
    }

    public boolean isZvkDiffVorjahrReset() {
        return this.mZvkDiffVorjahrReset;
    }

    public void setZvkDiffVorjahrReset(boolean b) {
        this.mZvkDiffVorjahrReset = b;
    }

    public boolean hatZvkDiffVorjahrResetDurchgefuehrt() {
        return this.mZvkDiffVorjahrResetDurchgefuehrt;
    }

    public void setZvkDiffVorjahrResetDurchgefuehrt(boolean b) {
        this.mZvkDiffVorjahrResetDurchgefuehrt = b;
    }

    public boolean isSAGChecked() {
        return this.mSAGChecked;
    }

    public void setSAGChecked(boolean check) {
        this.mSAGChecked = check;
    }

    private boolean isHistoryException(BusinessDomainException e) {
        return FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e);
    }

    public KennzGlzEnum getDbgzKENNZGLZ() {
        return this.mDbgzKENNZGLZ;
    }

    public int getDbgzSVTG() {
        return this.mDbgzSVTG;
    }

    public BigDecimal getDbgzGAEG() {
        return this.mDbgzGAEG;
    }

    public BigDecimal getDbgzEGAEG() {
        return this.mDbgzEGAEG;
    }

    public String getDbgzRK() {
        return this.mDbgzRK;
    }

    public boolean isDbgzVorhanden() {
        return this.mDbgzVorhanden;
    }

    public BigDecimal getDbbgGAEGKV() {
        return this.mDbbgGAEGKV;
    }

    public BigDecimal getDbbgGAEGRV() {
        return this.mDbbgGAEGRV;
    }

    public BigDecimal getDbbgGAEGALV() {
        return this.mDbbgGAEGALV;
    }

    public BigDecimal getDbbgEGAKV() {
        return this.mDbbgEGAKV;
    }

    public BigDecimal getDbbgEGARV() {
        return this.mDbbgEGARV;
    }

    public BigDecimal getDbbgEGAALV() {
        return this.mDbbgEGAALV;
    }

    public String getDbbgKVLBBG() {
        return this.mDbbgKVLBBG;
    }

    public String getDbbgRVLBBG() {
        return this.mDbbgRVLBBG;
    }

    public String getDbbgAVLBBG() {
        return this.mDbbgAVLBBG;
    }

    public String getDbbgKVEBBG() {
        return this.mDbbgKVEBBG;
    }

    public String getDbbgRVEBBG() {
        return this.mDbbgRVEBBG;
    }

    public String getDbbgAVEBBG() {
        return this.mDbbgAVEBBG;
    }

    public int getDbbgSVTG() {
        return this.mDbbgSVTG;
    }

    public String getDbbgKENNZRK() {
        return this.mDbbgKENNZRK;
    }

    public boolean isDbbgVorhanden() {
        return this.mDbbgVorhanden;
    }

    public void setIsDbbgVorhanden(boolean isDbbgVorhanden) {
        this.mDbbgVorhanden = isDbbgVorhanden;
    }

    public void setDurchschnittlicherZusatzbeitrag(boolean durchschnittlicherZusatzbeitrag) {
        this.mDurchschnittlicherZusatzbeitrag = durchschnittlicherZusatzbeitrag;
    }

    public boolean isDurchschnittlicherZusatzbeitrag() {
        return this.mDurchschnittlicherZusatzbeitrag;
    }

    public int GetCertificateNo() {
        return this.mCertificateNo;
    }

    public void SetCertificateNo(int certificateNo) {
        this.mCertificateNo = certificateNo;
    }

    public boolean isCheckIsStRRDiffVorjahrVorhandenDurchgefuehrt() {
        return this.mCheckIsStRRDiffVorjahrVorhanden;
    }

    public void setCheckIsStRRDiffVorjahrVorhandenDurchgefuehrt(boolean checkIsStRRDiffVorjahrVorhanden) {
        this.mCheckIsStRRDiffVorjahrVorhanden = checkIsStRRDiffVorjahrVorhanden;
    }

    public void checkVblu(Date arbVbluEintritt, Date arbGeburtstag, Date berchnungGueltigAb) throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)arbVbluEintritt, (Date)DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)new VDate(arbGeburtstag).addYears(64).getDate()))) || DateHelper.before((Date)arbVbluEintritt, (Date)new VDate(arbGeburtstag).addYears(17).getDate())) {
            throw EvaluationExceptionMapper.makeVBLUAlterskonfliktDomainException(berchnungGueltigAb);
        }
    }

    protected ValuePosition[] createValuePositionFromRelative() throws BusinessDomainException {
        ValuePosition[] vpArray = EMPTY_VP_ARRAY;
        EERelativeTP[] array = this.mEmployee.getEffectiveEERelativesForEvaluation(this.getEffectiveFrom(), this.getValidFrom());
        if (array.length > 0) {
            BigDecimal sequence = BigDecimal.ZERO;
            LinkedList<ValuePosition> vpList = new LinkedList<ValuePosition>();
            for (EERelativeTP each : array) {
                ValuePosition vp;
                sequence = sequence.add(BigDecimal.ONE);
                if (each.getDoPayment() && each.getCAFlagCalculation() == FlagCalculationEnum.FCE_FULL && (vp = ValuePosition.create(each, this)) != null) {
                    vp.setBufferField01(sequence);
                    vpList.add(vp);
                }
                this.ifNecessaryCreateFutureCalculationBasics((PersonnelTimedPersistenceObject)each, each.getEERelative().getClassName());
            }
            if (vpList.size() > 0) {
                vpArray = vpList.toArray(new ValuePosition[vpList.size()]);
            }
        }
        return vpArray;
    }

    public TypeOfCalculationCase getTypeOfCalculationCase() {
        return this.mTypeOfCalculationCase;
    }

    public boolean isBerechnungNachAustritt() {
        return this.mIsBerechnungNachAustritt;
    }

    protected void createCalculationBasicsFromEEWagefactor() throws BusinessDomainException {
        EEWageFactorTP[] array = this.getEmployee().getEffectiveEEWageFactors(this.getEffectiveFrom(), this.getValidFrom());
        for (int i = 0; i < array.length; ++i) {
            if (!DateHelper.after((Date)array[i].getValidFrom(), (Date)this.getValidFrom())) continue;
            new CalculationBasic(this.getEmployee(), this.getEffectiveFrom(), array[i].getValidFrom(), array[i].getEEWageFactor().getClass().getName());
        }
    }

    protected void createCalculationBasicsFromEmployment() throws BusinessDomainException {
        Employment[] array = this.getEmployee().getEmploymentHistory(this.getEffectiveFrom());
        for (int i = 0; i < array.length; ++i) {
            if (!DateHelper.after((Date)array[i].getValidFrom(), (Date)this.getValidFrom())) continue;
            new CalculationBasic(this.getEmployee(), this.getEffectiveFrom(), array[i].getValidFrom(), array[i].getClass().getName());
        }
    }

    public void resetValuepositionHistoryIndex() {
        this.resetValuepositionHistoryIndex = true;
    }
}

