/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.servantimpl.employee.zvk;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.idl.SortierungStructMapper;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.LazyRunnableHolder;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.IEmployeeReferenced;
import com.varial.personnel.domain.employee.zvk.EEZVK;
import com.varial.personnel.domain.employee.zvk.EEZVKFilterStruct;
import com.varial.personnel.domain.employee.zvk.EEZVKPersistencyManager;
import com.varial.personnel.domain.employee.zvk.EEZVKStruct;
import com.varial.personnel.domain.employee.zvk.EEZVKStructCallback;
import com.varial.personnel.domain.employee.zvk.mapper.EEZVKFilterStructMapper;
import com.varial.personnel.domain.employee.zvk.mapper.EEZVKMapper;
import com.varial.personnel.framework.IValuationManager;
import com.varial.personnel.framework.access.PersonnelRightList;
import com.varial.personnel.servantimpl.employee.SpecialAccessServantBase;
import com.varial.personnel.servantimpl.employee.zvk.EEZVKQueryCommand;
import com.varial.personnel.servantimpl.employee.zvk.EEZVKServantService;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.query.SortierungElementStruct;
import com.varial.serverbase.query.SortierungStruct;
import java.util.Date;
import java.util.List;

public class EEZVKServantImpl
extends SpecialAccessServantBase
implements EEZVKServantService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EEZVKStruct createEEZVK(AuthorizationToken token, EEZVKStruct struct) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateEEZVKRight(), struct.root.oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            Employee ee = this.getIEmployeePM().getEmployee(struct.root.oidTs.objectid);
            EEZVK eeZVK = new EEZVK(ee);
            EEZVKMapper.fillEEZVK((EEZVK)eeZVK, (EEZVKStruct)struct);
            ee.addEEZVKHistory(eeZVK, true);
            if (ee.getRetroactiveEntry()) {
                eeZVK.setEffectiveFrom(ee.getStartEffectiveFrom());
            }
            ((IValuationManager)UtilitiesManager.getBean((String)"valuationManager", IValuationManager.class)).valuate(token, ee, eeZVK.getEffectiveFrom(), eeZVK.getValidFrom(), eeZVK.getClass().getName());
            EEZVKStruct eEZVKStruct = EEZVKMapper.toIdl((EEZVK)ee.getActiveEEZVK());
            return eEZVKStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EEZVKStruct addEEZVK(AuthorizationToken token, EEZVKStruct struct, boolean removeNew) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateInsuranceRight(), struct.root.oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            Employee ee = this.getIEmployeePM().getEmployee(struct.root.oidTs.objectid);
            EEZVK eeZVK = new EEZVK(ee);
            EEZVKMapper.fillEEZVK((EEZVK)eeZVK, (EEZVKStruct)struct);
            EEZVK eeZVKOld = EEZVK.getEEZVK((String)struct.history.oidTs.objectid);
            eeZVK.compareToOld(eeZVKOld);
            ee.addEEZVKHistory(eeZVK, true);
            if (eeZVK.getValuateNeeded()) {
                Date valuateEffectiveFrom = eeZVK.getEffectiveFrom();
                Date valuateValidFrom = eeZVK.getValidFrom();
                valuateValidFrom = eeZVK.getEmployee().checkAndCorrectValidFromStartOfValuate(valuateEffectiveFrom, valuateValidFrom);
                ((IValuationManager)UtilitiesManager.getBean((String)"valuationManager", IValuationManager.class)).valuate(token, ee, valuateEffectiveFrom, valuateValidFrom, eeZVK.getClass().getName());
            } else {
                this.getContext().flush();
            }
            String message = "";
            try {
                eeZVK.checkEntryAndWithdrawal();
            }
            catch (BusinessDomainException e) {
                message = e.getMessage();
            }
            EEZVKStruct eEZVKStruct = EEZVKMapper.toIdl((EEZVK)ee.getActiveEEZVK(), (String)message);
            return eEZVKStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EEZVKStruct setEEZVK(AuthorizationToken token, EEZVKStruct struct, boolean removeNew) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateEEZVKRight(), struct.root.oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            Employee ee = this.getIEmployeePM().getEmployee(struct.root.oidTs.objectid);
            EEZVK eeZVK = new EEZVK(struct.history.oidTs.objectid, struct.history.oidTs.version, ee);
            EEZVKMapper.fillEEZVK((EEZVK)eeZVK, (EEZVKStruct)struct);
            EEZVK eeZVKOld = EEZVK.getEEZVK((String)struct.history.oidTs.objectid);
            eeZVK.compareToOld(eeZVKOld);
            ee.setEEZVKHistory(eeZVK, false, DateMapper.toDate((String)struct.history.timePeriod.effectiveFrom));
            if (eeZVK.getValuateNeeded()) {
                Date valuateEffectiveFrom = eeZVK.getEffectiveFrom();
                Date valuateValidFrom = eeZVK.getValidFrom();
                if (eeZVK.getOnlyDateOfWithdrawalChanged()) {
                    Date oldDateOfWithdrawal = eeZVKOld.getDateOfWithdrawl();
                    Date newDateOfWithdrawal = eeZVK.getDateOfWithdrawl();
                    if (oldDateOfWithdrawal == null && newDateOfWithdrawal != null) {
                        valuateValidFrom = DateHelper.getFirstDayOfMonth((Date)newDateOfWithdrawal);
                    }
                    if (oldDateOfWithdrawal != null && newDateOfWithdrawal == null) {
                        valuateValidFrom = DateHelper.getFirstDayOfMonth((Date)oldDateOfWithdrawal);
                    }
                    if (oldDateOfWithdrawal != null && newDateOfWithdrawal != null) {
                        valuateValidFrom = DateHelper.getFirstDayOfMonth((Date)DateHelper.min((Date[])new Date[]{oldDateOfWithdrawal, newDateOfWithdrawal, DateHelper.tomorrow((Date)eeZVK.getEmployee().getJournalizedUntil())}));
                    }
                }
                valuateValidFrom = eeZVK.getEmployee().checkAndCorrectValidFromStartOfValuate(valuateEffectiveFrom, valuateValidFrom);
                ((IValuationManager)UtilitiesManager.getBean((String)"valuationManager", IValuationManager.class)).valuate(token, ee, valuateEffectiveFrom, valuateValidFrom, eeZVK.getClass().getName());
            } else {
                this.getContext().flush();
            }
            String message = "";
            try {
                eeZVK.checkEntryAndWithdrawal();
            }
            catch (BusinessDomainException e) {
                message = e.getMessage();
            }
            EEZVKStruct eEZVKStruct = EEZVKMapper.toIdl((EEZVK)ee.getActiveEEZVK(), (String)message);
            return eEZVKStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEEZVK(AuthorizationToken token, EEZVKStruct struct) throws BusinessDomainException {
        try {
            this.beginUpdateService();
            Employee ee = this.getIEmployeePM().getEmployee(struct.history.oidEmployee);
            token.checkAccess(PersonnelRightList.getUpdateEEZVKRight(), ee.getPCompany().getObjectid());
            this.setTokenForSpecialAccess(token);
            EEZVK eeZVK = EEZVK.getEEZVK((String)struct.history.oidTs.objectid);
            Date minimumValidFrom = ee.getZVKHistory().getMinValidFromOfHistory();
            ee.deleteEEZVKHistory();
            ((IValuationManager)UtilitiesManager.getBean((String)"valuationManager", IValuationManager.class)).valuate(token, ee, DateHelper.tomorrow((Date)ee.getJournalizedUntil()), minimumValidFrom, eeZVK.getClass().getName());
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EEZVKStruct[] getActiveEEZVKs(AuthorizationToken token, EEZVKFilterStruct[] filter, SortierungStruct sortierung) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getReadEEZVKRight(), filter[0].oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            EEZVK[] actives = EEZVKPersistencyManager.getActiveEEZVK((EEZVKFilterStruct[])filter, (Order[])SortierungStructMapper.map((SortierungStruct)sortierung));
            EEZVKStruct[] eEZVKStructArray = EEZVKMapper.toIdl((EEZVK[])((EEZVK[])this.filterSpecialAccess((IEmployeeReferenced[])actives)));
            return eEZVKStructArray;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getActiveEEZVKsCB(AuthorizationToken token, EEZVKFilterStruct[] filter, SortierungStruct sortierung, EEZVKStructCallback cb, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getReadEEZVKRight(), filter[0].oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            if (sortierung.sortierungElements.length == 0) {
                sortierung = new SortierungStruct(new SortierungElementStruct[]{new SortierungElementStruct("personnelnumber", true)});
            }
            int maxRows = 50;
            EEZVKQueryCommand command = new EEZVKQueryCommand(token, SortierungStructMapper.map((SortierungStruct)sortierung), EEZVKFilterStructMapper.toFilter((EEZVKFilterStruct[])filter), cb, 50);
            lazyHolder.setStandardRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EEZVKStruct[] getActiveEffectiveEEZVKHistory(AuthorizationToken token, String oidEmployee) throws BusinessDomainException {
        try {
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            Employee ee = this.getIEmployeePM().getEmployee(oidEmployee);
            token.checkAccess(PersonnelRightList.getReadEEZVKRight(), ee.getPCompany().getObjectid());
            EEZVKStruct[] eEZVKStructArray = EEZVKMapper.toIdl((EEZVK[])ee.getActiveEffectiveEEZVKHistory());
            return eEZVKStructArray;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EEZVKStruct[] getAllEEZVKHistory(AuthorizationToken token, String oidEmployee) throws BusinessDomainException {
        try {
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            Employee ee = this.getIEmployeePM().getEmployee(oidEmployee);
            token.checkAccess(PersonnelRightList.getReadEEZVKRight(), ee.getPCompany().getObjectid());
            EEZVKStruct[] eEZVKStructArray = EEZVKMapper.toIdl((EEZVK[])ee.getEEZVKHistory());
            return eEZVKStructArray;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EEZVKStruct[] getEffectiveEEZVKHistory(AuthorizationToken token, String oidEmployee, String effectiveTimePoint) throws BusinessDomainException {
        try {
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            Employee ee = this.getIEmployeePM().getEmployee(oidEmployee);
            token.checkAccess(PersonnelRightList.getReadEEZVKRight(), ee.getPCompany().getObjectid());
            EEZVKStruct[] eEZVKStructArray = EEZVKMapper.toIdl((EEZVK[])ee.getEffectiveZVKHistory(DateMapper.toDate((String)effectiveTimePoint)));
            return eEZVKStructArray;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EEZVKStruct getObjectFromObjectId(AuthorizationToken token, String oidEmployee, String effectiveTimePoint, String validTimePoint) throws BusinessDomainException {
        try {
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            Employee employee = this.getIEmployeePM().getEmployee(oidEmployee);
            EEZVKStruct eEZVKStruct = EEZVKMapper.toIdl((EEZVK)employee.getEEZVK(DateMapper.toDate((String)effectiveTimePoint), DateMapper.toDate((String)validTimePoint)));
            return eEZVKStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EEZVKStruct[] getZVKsForEmployeeCopy(AuthorizationToken token, String oidEmployee, String validFrom) throws BusinessDomainException {
        try {
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            Employee ee = this.getIEmployeePM().getEmployee(oidEmployee);
            token.checkAccess(PersonnelRightList.getReadEEZVKRight(), ee.getPCompany().getObjectid());
            List result = ee.getZVKHistory().getPeriods(VDate.getDateMax(), DateMapper.toDate((String)validFrom), VDate.getDateMax());
            EEZVKStruct[] eEZVKStructArray = EEZVKMapper.toIdl((EEZVK[])result.toArray(new EEZVK[result.size()]));
            return eEZVKStructArray;
        }
        finally {
            this.endService();
        }
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }
}

