/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.framework.taskreminder;

import com.varial.base.UtilitiesManager;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.taskreminder.TaskFolder;
import com.varial.framework.domain.taskreminder.TaskFolderPersistencyManager;
import com.varial.framework.domain.taskreminder.TaskReminder;
import com.varial.framework.domain.taskreminder.TaskReminderPersistencyManager;
import com.varial.framework.domain.taskreminder.TaskReminderType;
import com.varial.personnel.domain.calculation.CalculationCase;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.plant.Plant;
import com.varial.serverbase.domain.user.IUserPersistencyManager;
import com.varial.serverbase.domain.user.User;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.util.Date;
import java.util.List;

public final class TaskReminderHelper {
    public static final String _1 = "";
    public static final String _2 = "Ablauf der Probezeit ";
    public static final String _3 = "Ablauf befristetes Arbeitsverh\u00e4ltnis ";
    public static final String _4 = "Ablauf befristete Arbeitserlaubnis ";
    public static final String _5 = "Ablauf befristete Aufenthaltserlaubnis ";
    public static final String _6 = "Austritt ";
    public static final String _7 = "Ablauf Studienbescheinigung ";
    public static final String _8 = "Mit Mitarbeiteraustritt auch Enddatum Versorgungsbezug pr\u00fcfen ";
    public static final String _9 = "Mit Mitarbeiteraustritt auch ZVK-Austritt pr\u00fcfen ";
    public static final String _10 = "Mit Mitarbeiteraustritt auch VBLU-Austritt pr\u00fcfen ";
    public static final String _11 = "Verzicht auf RV-Freiheit ";
    public static final String _12 = "Elterneigenschaft PV ";
    public static final String _13 = "R\u00fcckgabe des Sachmittels ";
    public static final String _14 = "In den ERA-Angaben des Mitarbeiters mu\u00df die Entgeltgruppe erh\u00f6ht werden ";
    public static final String _15 = "Die Tarifdaten des Mitarbeiters m\u00fcssen angepasst werden, denn die Tarifstufe l\u00e4uft aus. Anpassung zum: ";
    public static final String _16 = "gew\u00fcnschte Kontaktaufnahme mit: ";
    public static final String _17 = "Notiz beachten zum Betreff: ";
    public static final String _18 = "Im Beginnmonat der ATZ-Freistellungsphase sind ggf. noch nicht verbeitragte Altwertguthaben als UV-Brutto zu verbeitragen";
    public static final String _19 = "bitte \u00fcberpr\u00fcfen VBLU-Vertrag ohne RV ";
    public static final String _20 = "bitte \u00fcberpr\u00fcfen VBLU-Neuvertrag und StKl 6 ";
    public static final String _21 = "bitte \u00fcberpr\u00fcfen VBLU-Altvertrag und StKl 6 ";
    public static final String _22 = "bitte \u00fcberpr\u00fcfen steuer- und SV-pflichtigen VBLU-Vertrag und Steuerklasse ungleich 6 ";
    public static final String _23 = "bitte \u00fcberpr\u00fcfen VBLU-Vertrag und Beitragsgruppe RV Halber Beitrag (AG) ";
    public static final String _24 = "bitte \u00fcberpr\u00fcfen VBLU-Vertrag und Beitragsgruppe RV Pauschalbeitrag GfB (AG) ";
    public static final String _25 = "bitte \u00fcberpr\u00fcfen Steuerklasse 6 und BAV mit AN-finanzierter Aufwendung: ";
    public static final String _26 = "bitte \u00fcberpr\u00fcfen BAV-Vertrag und Beitragsgruppe RV: ";
    public static final String _27 = "bitte \u00fcberpr\u00fcfen BAV-Vertrag ohne Versorgungseinrichtung ";
    public static final String _28 = "fehlen Werte zur Berechnung des \u00a7 23c SGB IV in der Fehlzeit: ";
    public static final String _29 = "Mehrfachabrechnung mit BAV";
    public static final String _30 = "Mehrfachabrechnung mit VBLU";
    public static final String _31 = "Es existieren Fehlzeiten, die nicht mit dem Austrittsdatum begrenzt sind bzw. nach dem Austritt beginnen.";
    public static final String _32 = "Fehler in der Berechnung bei der Ermittlung der Steuer-Vortragswerte.";
    public static final String _33 = "Der Wertart ";
    public static final String _35 = "\nBitte wenden Sie sich mit Ihren Fragen an Ihren Fachberater.";
    public static final String _34 = " ist eine falsche Eigenschaft f\u00fcr die Pf\u00e4ndungsermittlung zugeordnet.";
    public static final String _36 = " ist f\u00fcr die Pf\u00e4ndungsermittlung die falsche Eigenschaft zugeordnet. Seit Jan. 2011 soll nur die Eigenschaft Lohnpf\u00e4ndung/-abtretung verwendet werden.";
    public static final String _37 = " produziert Bruchteile von Cent im Bruttolohn.";
    public static final String _38 = " mu\u00df in ihrer Beschreibung so modifiziert werden, dass keine Bruchteile von Cent-Betr\u00e4gen in den Bruttolohn gelangen k\u00f6nnen.";
    public static final String _39 = "Das Vergleichsnetto und das kalendert\u00e4gliche Krankengeld sind notwendige Werte f\u00fcr die Berechnung des beitragspflichtigen Anteils \neiner Arbeitgeberleistung au\u00dferhalb der Entgeltfortzahlung";
    public static final String _40 = " ist eine falsche Eigenschaft EFZ-Versicherung zugeordnet.";
    public static final String _41 = "Seit Jul. 2011 soll die Eigenschaft EFZ-Versicherung mit der Wertart ";
    public static final String _42 = " nicht mehr verwendet werden.";
    public static final String _43 = "Mehrfachabrechnung mit ZVK";
    public static final String _44 = " ist f\u00fcr die Darlehensermittlung die falsche Eigenschaft zugeordnet. ";
    public static final String _46 = "Pr\u00fcfung der Schl\u00fcsselung des Kennzeichens 'InsG-umlagepfl. Betrieb erforderlich'";
    public static final String _47 = "Mit Status der Insolvenz = 'f\u00fcr sofort bzw. sp\u00e4ter freigestellte AN' d\u00fcrfen die zugeordneten Betriebsst\u00e4tten nicht als InsG-umlagepfl. Betrieb gekennzeichent sein.";
    public static final String _48 = "Mit Status der Insolvenz = 'f\u00fcr sofort bzw. sp\u00e4ter freigestellte AN' darf die Firma nicht als InsG-umlagepfl. Betrieb gekennzeichent sein.";
    public static final String _49 = "Das 2-fache der GfB-Grenze wird \u00fcberschritten. Bitte GfB-Status pr\u00fcfen.";
    public static final String _50 = "Das gesamte RV-pflichtige Arbeitsentgelt ist geringer als die Mindestbeitragsbemessungsgrundlage f\u00fcr GfB.";
    public static final String _51 = "WICHTIG! Der Lohnnachweis muss innerhalb von 6 Wochen ab Bekanntgabe des Ereignisses \u00fcber die Funktion \"Aufbau/Daten\u00fcbermittlung Lohnnachweis\" an den UV-Tr\u00e4ger gesendet werden.";
    public static final String _52 = "Bei vollst\u00e4ndiger Betriebsaufgabe ist ein Lohnnachweis mit Grund 05 zu \u00fcbermitteln.";
    public static final String _53 = "Nach Insolvenz ist ein Lohnnachweis mit Grund 08 zu \u00fcbermitteln.";
    public static final String _54 = "Bei beendeter Zust\u00e4ndigkeit des UV-Tr\u00e4gers ist ein Lohnnachweis mit Grund 03 oder 05 zu \u00fcbermitteln";
    public static final String _55 = "Beim Wechsel der Zust\u00e4ndigkeit des UV-Tr\u00e4gers muss ein Nachfolge-UV-Tr\u00e4ger zugeordnet werden";
    public static final String _56 = "zum Betriebsende Mitarbeiteraustritte erfassen!";
    public static final String _57 = "Zum Tag der Betriebsbeendigung m\u00fcssen alle aktiv Besch\u00e4ftigten abgemeldet werden \u2013 Austrittsdatum erfassen und DE\u00dcV-Meldungen erstellen!";
    public static final String _58 = "Bei System-/DL-Wechsel ist ein DSBD mit besonderem Grund zu erstellen";
    public static final String _59 = "Bei einem Wechsel des Dienstleisters oder Abrechnungssystem muss das DSBD-Feld 'Bes. Abgabegrund' in den Firmen/Betriebsst\u00e4tten \u2013 Grundlagen mit 'Abrechnungssystem-/Dienstleisterwechsel' eingestellt werden.";
    public static final String _60 = "Mit Erfassung Enddatum Versorgungsbezug auch Austrittsdatum erfassen";
    public static final String _100 = "Ablauf der Anwartschaft Versorgung ";
    public static final String _101 = "Ablauf der Anwartschaft Versorgungsabfindung ";

    private TaskReminderHelper() {
    }

    public static String getFixedMessageWithCompanyCodeAndPersonnelnumber(Employee employee, String number) {
        return TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber(employee.getPCompany(), employee.getPersonnelnumber(), number);
    }

    public static String getFixedMessageWithCompanyCodeAndPersonnelnumber(PCompany pCompany, int personalnumber, String number) {
        return TaskReminderHelper.getCompanyCodeAndPersonnelnumber(pCompany, personalnumber).append(number).toString();
    }

    public static String getIndividualMessageWithCompanyCodeAndPersonnelnumber(Employee employee, String message) {
        return TaskReminderHelper.getIndividualMessageWithCompanyCodeAndPersonnelnumber(employee.getPCompany(), employee.getPersonnelnumber(), message);
    }

    public static String getIndividualMessageWithCompanyCodeAndPersonnelnumber(PCompany pCompany, int personalnumber, String message) {
        return TaskReminderHelper.getCompanyCodeAndPersonnelnumber(pCompany, personalnumber).append(message).toString();
    }

    public static String getIndividualMessageWithCompanyCodeAndPersonnelnumber(Employee employee, String number, String message) {
        return TaskReminderHelper.getIndividualMessageWithCompanyCodeAndPersonnelnumber(employee.getPCompany(), employee.getPersonnelnumber(), number, message);
    }

    public static String getIndividualMessageWithCompanyCodeAndPersonnelnumber(PCompany pCompany, int personalnumber, String number, String message) {
        return TaskReminderHelper.getCompanyCodeAndPersonnelnumber(pCompany, personalnumber).append(number).append(message).toString();
    }

    public static String getIndividualMessageWithCompanyCode(PCompany pCompany, String message) {
        return TaskReminderHelper.getCompanyCode(pCompany).append(message).toString();
    }

    public static String getIndividualMessageWithCompanyAndPlantCode(PCompany pCompany, Plant plant, String message) {
        return TaskReminderHelper.getCompanyAndPlantCode(pCompany, plant).append(message).toString();
    }

    public static String getFixedMessageWithCompanyCodePersonnelnumberAndBillingMonth(Employee employee, Date billingMonth, String number) {
        return TaskReminderHelper.getFixedMessageWithCompanyCodePersonnelnumberAndBillingMonth(employee.getPCompany(), employee.getPersonnelnumber(), billingMonth, number);
    }

    public static String getFixedMessageWithCompanyCodePersonnelnumberAndBillingMonth(PCompany pCompany, int personalnumber, Date billingMonth, String number) {
        return TaskReminderHelper.getCompanyCodePersonnelnumberAndBillingMonth(pCompany, personalnumber, billingMonth).append(number).toString();
    }

    public static StringBuilder getCompanyCode(PCompany pCompany) {
        return new StringBuilder("f\u00fcr  ").append(pCompany.getPCompanyKey()).append(": ");
    }

    public static StringBuilder getCompanyAndPlantCode(PCompany pCompany, Plant plant) {
        if (plant == null) {
            return TaskReminderHelper.getCompanyCode(pCompany);
        }
        return new StringBuilder("f\u00fcr  ").append(pCompany.getPCompanyKey()).append(" / ").append(plant.getPlantKey()).append(": ");
    }

    public static StringBuilder getCompanyCodeAndPersonnelnumber(PCompany pCompany, int personalnumber) {
        return new StringBuilder("f\u00fcr  ").append(pCompany.getPCompanyKey()).append(" / ").append(personalnumber).append(": ");
    }

    public static StringBuilder getCompanyCodePersonnelnumberAndBillingMonth(PCompany pCompany, int personalnumber, Date billingMonth) {
        return new StringBuilder("f\u00fcr  ").append(pCompany.getPCompanyKey()).append(" / ").append(personalnumber).append(" / ").append(DateMapper.toMMYYYYPointSeparationString((Date)billingMonth)).append(": ");
    }

    public static TaskReminder createTaskReminder(String reminderName, Date reminderDate) {
        return TaskReminderHelper.createTaskReminder(reminderName, reminderDate, null, SessionContext.getInstance().getSession().getUserCode());
    }

    public static TaskReminder createTaskReminder(String reminderName, Date reminderDate, String reminderNote) {
        return TaskReminderHelper.createTaskReminder(reminderName, reminderDate, reminderNote, SessionContext.getInstance().getSession().getUserCode());
    }

    public static TaskReminder createTaskReminder(String reminderName, Date reminderDate, String reminderNote, String userID) {
        TaskReminder reminder = new TaskReminder();
        User creatorReminder = TaskReminderHelper.getUserPM().query(SessionContext.getInstance().getSession().getUserCode());
        reminder.setCreator(creatorReminder);
        TaskFolder creatorTodoFolder = TaskFolderPersistencyManager.getTodoFolder((String)creatorReminder.getObjectid());
        reminder.setCreatorFolder(creatorTodoFolder);
        User recipientReminder = TaskReminderHelper.getUserPM().query(userID);
        reminder.setRecipient(recipientReminder);
        TaskFolder recipientTodoFolder = TaskFolderPersistencyManager.getTodoFolder((String)recipientReminder.getObjectid());
        reminder.setRecipientFolder(recipientTodoFolder);
        reminder.setName(reminderName);
        reminder.setNote(reminderNote);
        reminder.setIsDone(false);
        reminder.setRecurringTask(null);
        reminder.setTaskType(TaskReminderType.SINGLE);
        reminder.setDueDate(reminderDate);
        reminder.setEntryDate(DateHelper.today());
        return reminder;
    }

    public static void deleteTaskReminder(String reminderName, Date reminderDate) {
        TaskReminder[] trs = TaskReminderPersistencyManager.getTaskReminders((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"name", (String)reminderName), (Criterion)Restrictions.eq((String)"duedate", (String)DateMapper.toString((Date)reminderDate))));
        if (trs.length > 0) {
            for (int i = 0; i < trs.length; ++i) {
                TaskReminderPersistencyManager.delete((TaskReminder)trs[i]);
            }
        }
    }

    public static boolean existsTaskReminder(String reminderName) {
        TaskReminder[] reminders;
        User user = TaskReminderHelper.getUserPM().query(SessionContext.getInstance().getSession().getUserCode());
        for (TaskReminder reminder : reminders = TaskReminderPersistencyManager.queryAllTaskReminders((String)user.getObjectid())) {
            if (!StringMapper.equal((String)reminderName.trim(), (String)reminder.getName().trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean existsTaskReminder(String reminderName, Date reminderDate) {
        TaskReminder[] reminders;
        User user = TaskReminderHelper.getUserPM().query(SessionContext.getInstance().getSession().getUserCode());
        for (TaskReminder reminder : reminders = TaskReminderPersistencyManager.queryAllTaskReminders((String)user.getObjectid())) {
            if (!StringMapper.equal((String)reminderName.trim(), (String)reminder.getName().trim()) || !DateHelper.beforeOrEqual((Date)reminder.getDueDate(), (Date)reminderDate)) continue;
            return true;
        }
        return false;
    }

    public static boolean existsTaskReminderInCalculationCase(CalculationCase calculationCase, String reminderName, Date reminderDate) {
        List reminders = calculationCase.getTaskReminderList();
        for (TaskReminder reminder : reminders) {
            if (!StringMapper.equal((String)reminderName.trim(), (String)reminder.getName().trim()) || !DateHelper.beforeOrEqual((Date)reminder.getDueDate(), (Date)reminderDate)) continue;
            return true;
        }
        return false;
    }

    private static IUserPersistencyManager getUserPM() {
        return (IUserPersistencyManager)UtilitiesManager.getGenericAccessor().getBean("userPersistencyManager", IUserPersistencyManager.class);
    }
}

