/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.redhhcompensationreport;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.absenttime.AbsentTime;
import com.varial.personnel.domain.absenttime.AbsentTimePersistencyManager;
import com.varial.personnel.domain.companyplant.CompanyPlantCommunication;
import com.varial.personnel.domain.companyplant.CompanyPlantPostalAddress;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.SexEnum;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTPPersistencyManager;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.insurance.StatusCodeEnum;
import com.varial.personnel.domain.global.bank.Bank;
import com.varial.personnel.domain.global.employmentoffice.EmploymentOfficeTP;
import com.varial.personnel.domain.pcompany.account.CompanyAccount;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.foundations.PlantFoundations;
import com.varial.personnel.domain.reports.EmployeeForReport;
import com.varial.personnel.domain.reports.library.EmployeeForReportGenerator;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.redhhcompensationreport.RedHHEmployee;
import com.varial.personnel.domain.reports.redhhcompensationreport.RedHHListHelper;
import com.varial.personnel.framework.basictypes.PostalAddress;
import com.varial.personnel.framework.checkup.CheckUp;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.data.JRAbstractBeanDataSource;

public class RedHHAntragDataSource
extends JRAbstractBeanDataSource {
    private final NumberFormat amountFormat = RedHHAntragDataSource.createNumberFormat(2);
    private boolean done;
    private final EmployeeForReportGenerator generator;
    private final List<RedHHEmployee> eeSV100;
    private final List<RedHHEmployee> eeSV50;
    private final boolean internalUse;
    private final boolean more6month;
    private final boolean forPlantDepartment;
    private final String plantDepartment;
    private final boolean correctionAntrag;
    private final BigDecimal sumDebit;
    private final BigDecimal sumActual;
    private final String oidPlant;
    private final RedHHListHelper redHHListHelper;
    private final boolean mRequesterFromCompany;

    public RedHHAntragDataSource(EmployeeForReportGenerator generator, List<RedHHEmployee> eeSV50, List<RedHHEmployee> eeSV100, boolean internalUse, boolean more6month, boolean forPlantDepartment, String plantDepartment, boolean correctionAntrag, BigDecimal sumDebit, BigDecimal sumActual, String oidPlant, boolean requesterFromCompany) {
        super(false);
        this.generator = generator;
        this.eeSV100 = eeSV100;
        this.eeSV50 = eeSV50;
        this.internalUse = internalUse;
        this.more6month = more6month;
        this.forPlantDepartment = forPlantDepartment;
        this.plantDepartment = plantDepartment;
        this.correctionAntrag = correctionAntrag;
        this.sumDebit = sumDebit;
        this.sumActual = sumActual;
        this.oidPlant = oidPlant;
        this.mRequesterFromCompany = requesterFromCompany;
        this.redHHListHelper = new RedHHListHelper(oidPlant, this.getEmployee(), generator, requesterFromCompany);
    }

    private static NumberFormat createNumberFormat(int scale) {
        NumberFormat result = NumberFormat.getInstance(Locale.GERMANY);
        result.setMinimumFractionDigits(scale);
        result.setMaximumFractionDigits(scale);
        return result;
    }

    protected String format(BigDecimal bigDecimalValue) {
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)bigDecimalValue)) {
            return this.amountFormat.format(BigDecimal.ZERO);
        }
        return this.amountFormat.format(bigDecimalValue);
    }

    protected String format(boolean booleanValue) {
        if (booleanValue) {
            return "X";
        }
        return "";
    }

    protected String format(Object fallback) {
        if (fallback == null) {
            return "";
        }
        return String.valueOf(fallback);
    }

    public String get00InternerGebrauch() {
        if (this.internalUse) {
            return "Interner Gebrauch";
        }
        return "";
    }

    public String get00AgenturName() throws BusinessDomainException {
        return this.getActiveEmploymentOfficeTP().getLongDescription();
    }

    private EmploymentOfficeTP getActiveEmploymentOfficeTP() throws BusinessDomainException {
        Date max = VDate.getDateMax();
        return this.redHHListHelper.getGeneralEmploymentOffice().getEmploymentOffice().getEmploymentOfficeTP(max, max);
    }

    private Employee getEmployee() {
        Iterator<RedHHEmployee> iterator = this.eeSV100.iterator();
        if (iterator.hasNext()) {
            RedHHEmployee each = iterator.next();
            return each.getEmployee();
        }
        iterator = this.eeSV50.iterator();
        if (iterator.hasNext()) {
            RedHHEmployee each = iterator.next();
            return each.getEmployee();
        }
        throw new IllegalStateException("no employees");
    }

    public String get00AgenturStrNr() throws BusinessDomainException {
        return this.format(this.getEmployerPostalAddress().getStreet());
    }

    public String get00AgenturPostfach() {
        return this.format("");
    }

    public String get00AgenturPlz() throws BusinessDomainException {
        return this.format(this.getEmployerPostalAddress().getPostalCode());
    }

    public String get00AgenturOrt() throws BusinessDomainException {
        return this.format(this.getEmployerPostalAddress().getCity());
    }

    private PostalAddress getEmployerPostalAddress() throws BusinessDomainException {
        PostalAddress address = this.getActiveEmploymentOfficeTP().getAddress();
        if (address == null) {
            address = new PostalAddress("", "", "", "");
        }
        return address;
    }

    public String get00ArbeitsausfallNr() throws BusinessDomainException {
        return this.format(this.redHHListHelper.getGeneralEmploymentOffice().getWorkingLossNumber());
    }

    public String get00StammNrKug() throws BusinessDomainException {
        return this.format(this.redHHListHelper.getStammnummer());
    }

    public String get00Betriebsnummer() throws BusinessDomainException {
        return this.format(this.redHHListHelper.getGeneralEmploymentOffice().getEmployerNumber());
    }

    private CompanyPlantCommunication getEmployerCommunication() throws BusinessDomainException {
        CompanyPlantCommunication cpc = this.getFoundations().getCommunication();
        if (cpc == null) {
            cpc = new CompanyPlantCommunication("", "", "", "", "");
        }
        return cpc;
    }

    private CompanyFoundations getCompanyFoundations() throws BusinessDomainException {
        return this.redHHListHelper.getPCompany().getCompanyFoundations(this.redHHListHelper.getForEffectiveDate(), this.redHHListHelper.getForValidDate());
    }

    private PlantFoundations getPlantFoundations() throws BusinessDomainException {
        Plant plant = this.redHHListHelper.getPlant();
        if (plant == null) {
            return null;
        }
        return plant.getPlantFoundations(this.redHHListHelper.getForEffectiveDate(), this.redHHListHelper.getForValidDate());
    }

    private Foundations getFoundations() throws BusinessDomainException {
        PlantFoundations pf;
        if (!StringMapper.isNullString((String)this.oidPlant) && (pf = this.getPlantFoundations()) != null && !this.mRequesterFromCompany) {
            return pf.getFoundations();
        }
        return this.getCompanyFoundations().getFoundations();
    }

    public String get00Telefon() throws BusinessDomainException {
        return this.format(this.getEmployerCommunication().getPhone());
    }

    public String get00Telefax() throws BusinessDomainException {
        return this.format(this.getEmployerCommunication().getFax());
    }

    public String get00EMail() throws BusinessDomainException {
        return this.format(this.getEmployerCommunication().getEMail());
    }

    public String get00ArbeitgeberName() throws BusinessDomainException {
        return this.format(this.getFoundations().getLongDescription());
    }

    private CompanyPlantPostalAddress getCompanyAdress() throws BusinessDomainException {
        return this.getFoundations().getPostalAddress();
    }

    public String get00ArbeitgeberStr() throws BusinessDomainException {
        return this.format(this.getCompanyAdress().getStreet());
    }

    public String get00ArbeitgeberStrOhneHnr() throws BusinessDomainException {
        return this.format(this.getCompanyAdress().getSeparateStreet());
    }

    public String get00Hnr() throws BusinessDomainException {
        return this.format(this.getCompanyAdress().getSeparateNumber());
    }

    public String get00ArbeitgeberPostfach() throws BusinessDomainException {
        return this.format("");
    }

    public String get00ArbeitgeberPlz() throws BusinessDomainException {
        return this.format(this.getCompanyAdress().getPostalCode());
    }

    public String get00ArbeitgeberOrt() throws BusinessDomainException {
        return this.format(this.getCompanyAdress().getCity());
    }

    public String get00KontoNr() throws BusinessDomainException {
        return this.format(this.getCompanyAccountNumber());
    }

    private String getCompanyAccountNumber() throws BusinessDomainException {
        CompanyAccount ca = this.redHHListHelper.getGeneralEmploymentOffice().getAssignedCompanyAccount();
        if (ca != null) {
            return ca.getCompanyAccountTP(this.redHHListHelper.getForEffectiveDate(), this.redHHListHelper.getForValidDate()).getAccountNumber();
        }
        return null;
    }

    public String get00beiKreditinstitut() throws BusinessDomainException {
        return this.format(this.getCompanyAccountBankName());
    }

    private String getCompanyAccountBankName() throws BusinessDomainException {
        Bank bank;
        CompanyAccount ca = this.redHHListHelper.getGeneralEmploymentOffice().getAssignedCompanyAccount();
        if (ca != null && (bank = ca.getBank()) != null) {
            return bank.getBankTP(this.redHHListHelper.getForEffectiveDate(), this.redHHListHelper.getForValidDate()).getLongDescription();
        }
        return null;
    }

    public String get00Bankleitzahl() throws BusinessDomainException {
        return this.format(this.getCompanyAccountBankCode());
    }

    private String getCompanyAccountBankCode() throws BusinessDomainException {
        Bank bank;
        CompanyAccount ca = this.redHHListHelper.getGeneralEmploymentOffice().getAssignedCompanyAccount();
        if (ca != null && (bank = ca.getBank()) != null) {
            return bank.getBankTP(this.redHHListHelper.getForEffectiveDate(), this.redHHListHelper.getForValidDate()).getBankCodeNumber();
        }
        return null;
    }

    public String get00KorrekturAntrag() {
        return this.format(this.correctionAntrag);
    }

    public String get00Ableitungsnr() throws BusinessDomainException {
        return this.format(this.redHHListHelper.getAbleitungsnummer());
    }

    public String get00Betriebsabteilung() {
        return this.format(this.plantDepartment);
    }

    public String get00desBetriebes() {
        return this.format(!this.forPlantDepartment);
    }

    public String get00derBetriebsabteilung() {
        return this.format(this.forPlantDepartment);
    }

    public String get00Beschaeftigungsanzahl() {
        return this.format(this.getCurrentEmployees());
    }

    public String get00Zielgebiet1() {
        return this.format("");
    }

    public String get00Zielgebiet2() {
        return this.format("");
    }

    public String get00Uebergangsgebiet() {
        return this.format("");
    }

    public String get00Abrechnungsmonat() {
        return this.format(this.getMonthYear());
    }

    public String get00SummeSoll() {
        return this.format(this.sumDebit);
    }

    public String get00SummeIst() {
        return this.format(this.sumActual);
    }

    private String getMonthYear() {
        VDate aktMonJahr = new VDate(this.redHHListHelper.getForValidDate());
        int mon = aktMonJahr.getMonth();
        return ReportHelper.getMonthDescription((int)mon) + " " + Integer.toString(aktMonJahr.getYear());
    }

    public String get00Kurzarbeitergeld() {
        return this.format(true);
    }

    public String get00PauschalierteSVErst100() {
        return this.format(!this.eeSV100.isEmpty());
    }

    public String get00PauschalierteSVErst6Month() {
        return this.format(this.more6month && !this.eeSV50.isEmpty());
    }

    public String get00PauschalierteSVErst50() {
        return this.format(!this.more6month && !this.eeSV50.isEmpty());
    }

    public String get00KurzarbeitergeldEuro() {
        return this.format(this.getTotal());
    }

    private BigDecimal getTotal() {
        BigDecimal result = BigDecimal.ZERO;
        for (RedHHEmployee each : this.eeSV100) {
            result = result.add(each.getAuszuKug());
        }
        for (RedHHEmployee each : this.eeSV50) {
            result = result.add(each.getAuszuKug());
        }
        return result;
    }

    public String get00PauschalierteSVErst50Euro() {
        return this.format(this.more6month ? BigDecimal.ZERO : this.getTotal50());
    }

    private BigDecimal getTotal50() {
        BigDecimal result = BigDecimal.ZERO;
        for (RedHHEmployee each : this.eeSV50) {
            if (each.getPauschalierteSV() == null || each.getPauschalierteSV().signum() == -1) continue;
            result = result.add(each.getPauschalierteSV());
        }
        return result;
    }

    public String get00PauschalierteSVErst100Euro() {
        return this.format(this.getTotal100().add(this.getTotal50()));
    }

    public String get00PauschalierteSVWeiterbildung() {
        return this.format(this.getTotalQualifikation());
    }

    public String get00PauschalierteSVErst6MonthEuro() {
        return this.format(this.more6month ? this.getTotal50() : BigDecimal.ZERO);
    }

    private BigDecimal getTotal100() {
        BigDecimal result = BigDecimal.ZERO;
        for (RedHHEmployee each : this.eeSV100) {
            if (each.getPauschalierteSV() == null || each.getPauschalierteSV().signum() == -1) continue;
            result = result.add(each.getPauschalierteSV());
        }
        return result;
    }

    private BigDecimal getTotalQualifikation() {
        BigDecimal result = BigDecimal.ZERO;
        for (RedHHEmployee each : this.eeSV100) {
            if (each.getPauschalierteSVWeiterb() == null || each.getPauschalierteSVWeiterb().signum() == -1) continue;
            result = result.add(each.getPauschalierteSVWeiterb());
        }
        for (RedHHEmployee each : this.eeSV50) {
            if (each.getPauschalierteSVWeiterb() == null || each.getPauschalierteSVWeiterb().signum() == -1) continue;
            result = result.add(each.getPauschalierteSVWeiterb());
        }
        return result;
    }

    public String get00Gesamtbetrag() {
        return this.format(this.getTotal().add(this.getTotal100()).add(this.getTotal50()).add(this.getTotalQualifikation()));
    }

    public String get00AnzahlMaennlich() throws BusinessDomainException {
        return this.format(this.getCountOfMale());
    }

    private int getCountOfMale() throws BusinessDomainException {
        int result = 0;
        for (RedHHEmployee each : this.eeSV100) {
            if (!CheckUp.isMale((SexEnum)each.getMaster().getSex())) continue;
            ++result;
        }
        for (RedHHEmployee each : this.eeSV50) {
            if (!CheckUp.isMale((SexEnum)each.getMaster().getSex())) continue;
            ++result;
        }
        return result;
    }

    public String get00AnzahlWeiblich() throws BusinessDomainException {
        return this.format(this.getCountOfFemale());
    }

    private int getCountOfFemale() throws BusinessDomainException {
        int result = 0;
        for (RedHHEmployee each : this.eeSV100) {
            if (!CheckUp.isFemale((SexEnum)each.getMaster().getSex())) continue;
            ++result;
        }
        for (RedHHEmployee each : this.eeSV50) {
            if (!CheckUp.isFemale((SexEnum)each.getMaster().getSex())) continue;
            ++result;
        }
        return result;
    }

    public String get00AnzahlDivers() throws BusinessDomainException {
        return this.format(this.getCountOfDivers());
    }

    private int getCountOfDivers() throws BusinessDomainException {
        int result = 0;
        for (RedHHEmployee each : this.eeSV100) {
            if (!CheckUp.isDivers((SexEnum)each.getMaster().getSex())) continue;
            ++result;
        }
        for (RedHHEmployee each : this.eeSV50) {
            if (!CheckUp.isDivers((SexEnum)each.getMaster().getSex())) continue;
            ++result;
        }
        return result;
    }

    public String get00AnzahlOA() throws BusinessDomainException {
        return this.format(this.getCountOfUnkown());
    }

    private int getCountOfUnkown() throws BusinessDomainException {
        int result = 0;
        for (RedHHEmployee each : this.eeSV100) {
            if (!CheckUp.isUnkown((SexEnum)each.getMaster().getSex())) continue;
            ++result;
        }
        for (RedHHEmployee each : this.eeSV50) {
            if (!CheckUp.isUnkown((SexEnum)each.getMaster().getSex())) continue;
            ++result;
        }
        return result;
    }

    public String get00AnzahlMitTeilnahme() {
        return this.format(this.getCountOfQualification());
    }

    public String get04AnzahlAltersrente() {
        return "";
    }

    public String get04AnzahlAufhebung() {
        return "";
    }

    private int getCountOfQualification() {
        int result = 0;
        result += this.getCountOfQualification(this.eeSV100);
        return result += this.getCountOfQualification(this.eeSV50);
    }

    private int getCountOfQualification(List<RedHHEmployee> employees) {
        int result = 0;
        for (RedHHEmployee each : employees) {
            if (!each.hasQualification()) continue;
            ++result;
        }
        return result;
    }

    public String get00insgesamtArbeitnehmer() {
        return this.format(this.getCurrentEmployees());
    }

    private int getCurrentEmployees() {
        EmployeeForReport[] efrs = this.generator.getEmployeesForReport();
        int result = efrs.length;
        Date firstOfMonth = DateHelper.getFirstDayOfMonth((Date)this.generator.getForValidFromDate());
        for (EmployeeForReport each : efrs) {
            RedHHEmployee current = new RedHHEmployee(each, this.generator, this.more6month);
            Date entry = each.getDateOfEntry();
            Date withDrawal = each.getDateOfWithDrawal();
            if (withDrawal != null && DateHelper.before((Date)withDrawal, (Date)firstOfMonth)) {
                --result;
                continue;
            }
            if (this.isKugListRelevant(current.getEmployee(), entry)) continue;
            --result;
        }
        return result;
    }

    private boolean isKugListRelevant(Employee employee, Date enty) {
        Insurance ins;
        try {
            ins = DateHelper.after((Date)enty, (Date)this.redHHListHelper.getForValidDate()) ? employee.getInsurance(this.redHHListHelper.getForEffectiveDate(), enty) : employee.getInsurance(this.redHHListHelper.getForEffectiveDate(), this.redHHListHelper.getForValidDate());
        }
        catch (BusinessDomainException e) {
            return false;
        }
        if (ins.getPersonGroup() == 124) {
            return false;
        }
        if (ins.getPersonGroup() == 102 || ins.getPersonGroup() == 105 || ins.getPersonGroup() == 121 || ins.getPersonGroup() == 122 || ins.getPersonGroup() == 123) {
            return false;
        }
        if (ins.getPersonGroup() == 107 || ins.getPersonGroup() == 111 || ins.getPersonGroup() == 127) {
            return false;
        }
        if (ins.getPersonGroup() == 190) {
            return false;
        }
        if (ins.getPersonGroup() >= 900 && ins.getPersonGroup() <= 999) {
            return false;
        }
        if (ins.getStatusCode() != null && ins.getStatusCode().equals(StatusCodeEnum.SCE_GESCHAEFTSFUEHRENDER_GMBH_GESELLSCHAFTER)) {
            return false;
        }
        return !this.hasFullAbsentTime(employee);
    }

    private boolean hasFullAbsentTime(Employee employee) {
        Date from = DateHelper.getFirstDayOfMonth((Date)this.redHHListHelper.getForValidDate());
        Date until = DateHelper.getLastDayOfMonth((Date)this.redHHListHelper.getForValidDate());
        AbsentTime[] absentTimes = AbsentTimePersistencyManager.query(null, (Criterion)Restrictions.in((String)"DEUVABSENTTIMEKEY", (String[])new String[]{"1.5", "1.6", "2.8", "2.9", "5.1", "6.1", "6.2", "9.8"}));
        EEAbsentTimeTP[] eeAbsentTimeTPs = EEAbsentTimeTPPersistencyManager.queryAll((Order[])new Order[]{Order.asc((String)"validfrom")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)employee.getObjectid()), Restrictions.in((String)"oidabsenttime", (String[])PersistentObjectUtils.getObjectIdsArray((IPersistentObject[])absentTimes)), Restrictions.eq((String)"deleted", (String)"F"), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.redHHListHelper.getForEffectiveDate())), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.redHHListHelper.getForEffectiveDate())), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)until)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)from))}), (boolean)true);
        if (eeAbsentTimeTPs.length == 0) {
            return false;
        }
        if (DateHelper.after((Date)eeAbsentTimeTPs[0].getValidFrom(), (Date)from)) {
            return false;
        }
        if (DateHelper.beforeOrEqual((Date)eeAbsentTimeTPs[0].getValidFrom(), (Date)from) && DateHelper.afterOrEqual((Date)eeAbsentTimeTPs[0].getValidUntil(), (Date)until)) {
            return true;
        }
        Date newEEAbsenttimeUntil = eeAbsentTimeTPs[0].getValidUntil();
        for (int i = 1; i < eeAbsentTimeTPs.length; ++i) {
            if (!DateHelper.equal((Date)eeAbsentTimeTPs[i].getValidFrom(), (Date)DateHelper.tomorrow((Date)newEEAbsenttimeUntil))) {
                return false;
            }
            newEEAbsenttimeUntil = eeAbsentTimeTPs[i].getValidUntil();
            if (!DateHelper.afterOrEqual((Date)newEEAbsenttimeUntil, (Date)until)) continue;
            return true;
        }
        return false;
    }

    public String get00DrittelErfordernis() {
        return this.format(false);
    }

    public String get00Entgeltausfall() {
        return this.format(false);
    }

    public String get04aJa() {
        return this.format(false);
    }

    public String get04aNein() {
        return this.format(false);
    }

    public String get04bJa() {
        return this.format(false);
    }

    public String get04bNein() {
        return this.format(false);
    }

    public String get06Ja() {
        return this.format(false);
    }

    public String get06Nein() {
        return this.format(false);
    }

    public String get07Ja() {
        return this.format(false);
    }

    public String get07Nein() {
        return this.format(false);
    }

    public String get05Bargeldlos() {
        return this.format(true);
    }

    public String get05mindestens50() {
        return this.format(false);
    }

    public String get99OrtUndDatum() throws BusinessDomainException {
        return this.format(this.get00ArbeitgeberOrt() + ", " + DateMapper.toDDMMYYYYPointSeparationString((Date)VDate.getCurrentLocalizedDateAndTime()));
    }

    public String get99Ort() throws BusinessDomainException {
        return this.format(this.get00ArbeitgeberOrt());
    }

    public String get99Datum() throws BusinessDomainException {
        return this.format(DateMapper.toDDMMYYYYPointSeparationString((Date)VDate.getCurrentLocalizedDateAndTime()));
    }

    public String get00BIC() throws BusinessDomainException {
        return this.format(this.getBIC());
    }

    private String getBIC() throws BusinessDomainException {
        Bank bank;
        CompanyAccount ca = this.redHHListHelper.getGeneralEmploymentOffice().getAssignedCompanyAccount();
        if (ca != null && (bank = ca.getBank()) != null) {
            return bank.getBankTP(this.redHHListHelper.getForEffectiveDate(), this.redHHListHelper.getForValidDate()).getBicCode();
        }
        return null;
    }

    public String get00IBAN() throws BusinessDomainException {
        return this.format(this.getIBAN());
    }

    private String getIBAN() throws BusinessDomainException {
        CompanyAccount ca = this.redHHListHelper.getGeneralEmploymentOffice().getAssignedCompanyAccount();
        if (ca != null) {
            return ca.getCompanyAccountTP(this.redHHListHelper.getForEffectiveDate(), this.redHHListHelper.getForValidDate()).getIban();
        }
        return null;
    }

    public void moveFirst() throws JRException {
        this.done = false;
    }

    public Object getFieldValue(JRField field) throws JRException {
        return this.getFieldValue((Object)this, field);
    }

    public boolean next() throws JRException {
        boolean hasNext = !this.done;
        this.done = true;
        return hasNext;
    }
}

