/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.deuvaccountprotocol;

import com.varial.base.UtilitiesManager;
import com.varial.base.callback.TransactionMode;
import com.varial.base.corba.CorbaExceptionTranslatorFactory;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.ApplicationServiceAdapter;
import com.varial.base.service.TransactionalServiceAdapter;
import com.varial.framework.basictypes.ReportExportFormatEnum;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.reports.JasperReportCompiler;
import com.varial.framework.domain.reports.JasperReportManager;
import com.varial.personnel.domain.deuv.DbkvEmployee;
import com.varial.personnel.domain.deuv.DbuvEmployee;
import com.varial.personnel.domain.deuv.DeuvDsbdCreate;
import com.varial.personnel.domain.deuv.DsfzEmployee;
import com.varial.personnel.domain.deuv.IDeuvSettings;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccount;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAdvice;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVEmployee;
import com.varial.personnel.domain.deuv.deuvdsbd.DEUVDsbd;
import com.varial.personnel.domain.deuv.dsak.DeuvDsakCreator;
import com.varial.personnel.domain.deuv.dsak.DeuvDsakHelper;
import com.varial.personnel.domain.deuv.dsak.DeuvDsakReportDS;
import com.varial.personnel.domain.deuv.dsak.dsak.DeuvDsak;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.deuvmessaging.SiVersionCheck;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportBeanDataSource;
import com.varial.personnel.domain.reports.ReportFormatFactory;
import com.varial.personnel.domain.reports.deuvaccountprotocol.DeuvAccountProtocolReportDataSource;
import com.varial.personnel.domain.reports.mapper.DEUVExceptionMapper;
import com.varial.personnel.framework.ExclusiveExecutionLockHelper;
import com.varial.personnel.servantimpl.employee.SpecialAccessPrintCommand;
import com.varial.serverbase.applicationexception.DomainExceptionStruct;
import com.varial.serverbase.query.AllCallbackOperations;
import com.varial.serverbase.query.DatabaseExceptionStruct;
import com.varial.serverbase.query.PutDataException;
import java.io.File;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;

public class DeuvAccountProtocolReport
extends SpecialAccessPrintCommand<ReportFileStructCallback> {
    private static final String PROFILE_PREFIX = "DEACCPR";
    private static final String PROFILE_PREFIX_DSAK = "DSAKR";
    private static final String REPORT_FOLDER = "com/varial/personnel/jasperreport/deuvdatatransferprotokoll/";
    private static Logger LOGGER = LoggerFactory.getLogger(DeuvAccountProtocolReport.class);
    private final ReportExportFormatEnum mReportExportFormat;
    List<PCompany> mPCompanies;
    List<String> mOidEmployees;
    private DEUVSender mDeuvSender;
    private Object mThrower;
    private DEUVAdvice mDeuvAdvice;
    private List<DEUVDsbd> mDsbds;
    private List<DeuvDsak> mDsaks;
    private final boolean mAlphabetical;
    private final boolean mAnonymised;
    private final boolean mPreview;
    private final boolean mIsSpecialAccess;
    private boolean mCreateDsbd = true;
    private final ProgressBarUpdater mProgressBar;

    public DeuvAccountProtocolReport(ReportFileStructCallback callback, AuthorizationToken token, List<PCompany> pCompanies, List<String> oidEmployees, boolean preview, boolean alphabetical, boolean anonymised, ReportExportFormatEnum format) {
        super(token, (AllCallbackOperations)callback, TransactionMode.NONE, false);
        this.mPCompanies = pCompanies;
        this.mOidEmployees = oidEmployees;
        this.mReportExportFormat = format;
        this.mPreview = preview;
        this.mAlphabetical = alphabetical;
        this.mAnonymised = anonymised;
        this.mIsSpecialAccess = this.getSpecialAccess().isActive();
        this.mThrower = this;
        this.mProgressBar = new ProgressBarUpdater((ReportFileStructCallback)this.getCallback(), 1, pCompanies.size() + 1, "Initialisierung...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        ApplicationServiceAdapter applAdapter = new ApplicationServiceAdapter();
        TransactionalServiceAdapter txAdapter = new TransactionalServiceAdapter();
        TransactionStatus txStatus = null;
        try {
            ExclusiveExecutionLockHelper.checkExclusiveExecutionLock((Object)((Object)this), (String)PROFILE_PREFIX);
            SiVersionCheck.checkVersionValidness(SiVersionCheck.Type.DEUV);
            if (this.mAlphabetical && this.mAnonymised) {
                throw DEUVExceptionMapper.makeNotAlphabeticalAndAnonymisedDomainException();
            }
            if (this.isEmployeeSelection()) {
                this.mProgressBar.setStepsTotal(this.mPCompanies.size());
            } else {
                this.mProgressBar.setStepsTotal(this.mPCompanies.size() + 1);
            }
            applAdapter.beginUpdateService();
            this.mDeuvSender = DeuvHelper.getDeuvSender((PCompany)this.mPCompanies.get(0));
            ArrayList<PCompany> emptycompanies = new ArrayList<PCompany>();
            for (PCompany each : this.mPCompanies) {
                txStatus = txAdapter.getUpdateTransaction();
                if (this.mPreview) {
                    txStatus.setRollbackOnly();
                }
                if (!this.executeCompany(each)) {
                    emptycompanies.add(each);
                    txStatus.setRollbackOnly();
                }
                txAdapter.commit(txStatus);
                this.mProgressBar.nextStep();
            }
            this.mThrower = this;
            if (!this.isEmployeeSelection()) {
                SiVersionCheck.checkVersionValidness(SiVersionCheck.Type.DSBD);
                SiVersionCheck.checkVersionValidness(SiVersionCheck.Type.DSAK);
                txStatus = txAdapter.getUpdateTransaction();
                this.createDsak();
                this.getContext().flush();
                txAdapter.commit(txStatus);
            }
            if (emptycompanies.size() == this.mPCompanies.size() && (this.mDsaks == null || this.mDsaks.isEmpty())) {
                throw DEUVExceptionMapper.makeNoDeuvAccountsCreatedDomainException();
            }
        }
        catch (BusinessDomainException de) {
            LOGGER.error(String.valueOf(this.mThrower), (Throwable)de);
            this.rollback(txAdapter, txStatus, de);
            DomainExceptionStruct struct = CorbaExceptionTranslatorFactory.getTranslator().translateIntoDomainExceptionStruct(de);
            struct.value = struct.value + " " + this.mThrower;
            ((ReportFileStructCallback)this.getCallback()).setDomainException(struct);
        }
        catch (Throwable t) {
            LOGGER.error(String.valueOf(this.mThrower), t);
            this.rollback(txAdapter, txStatus, t);
            DatabaseExceptionStruct struct = CorbaExceptionTranslatorFactory.getTranslator().translateIntoDatabaseExceptionStruct(t);
            if (t.getMessage() == null) {
                struct.param1 = t.getClass().getSimpleName();
            }
            struct.param1 = struct.param1 + ", thrower: " + this.mThrower;
            ((ReportFileStructCallback)this.getCallback()).setException(struct);
        }
        finally {
            ExclusiveExecutionLockHelper.releaseExclusiveExecutionLock((Object)((Object)this), (String)PROFILE_PREFIX);
            applAdapter.endService();
        }
    }

    private boolean executeCompany(PCompany pCompany) throws BusinessDomainException, PutDataException {
        this.mDeuvAdvice = new DEUVAdvice(pCompany, this.mPreview);
        this.mThrower = this.mDeuvAdvice;
        Deque<Employee> employees = this.mDeuvAdvice.getEmployeeList(this.mOidEmployees);
        this.mProgressBar.setTotal(employees.size() + (this.mCreateDsbd ? 2 : 1));
        while (!employees.isEmpty()) {
            Employee employee = employees.removeFirst();
            this.mProgressBar.update(this.getPnrString(pCompany, employee));
            this.mThrower = employee;
            if (this.mIsSpecialAccess && employee.getSpecialAccess()) {
                this.mDeuvAdvice.setAffectedBySpecialAccess(true);
                continue;
            }
            this.createDeuv(employee);
            this.createDbuv(employee);
            this.createDbkv(employee);
            this.createDsfz(employee);
        }
        if (!this.isEmployeeSelection()) {
            this.mDeuvAdvice.makeWithdrawalEmpAccounts();
            if (this.mCreateDsbd) {
                this.mProgressBar.update("Erstelle DSBD...");
                this.createDsbd();
                this.mCreateDsbd = false;
            } else {
                this.mDsbds = null;
            }
            this.getContext().flush();
        }
        return this.createReport();
    }

    private void createDeuv(Employee employee) throws BusinessDomainException, PutDataException {
        DEUVEmployee de = new DEUVEmployee(this.mDeuvAdvice, employee);
        this.mThrower = de;
        de.initTriggers();
        de.initEEAbsenttimes();
        de.makeDEUVTriggers();
        de.makeAdviceables();
        de.makeStoerfall();
        de.processEgas();
        de.makeResults();
        if (this.mPreview) {
            this.mDeuvAdvice.addPreviewAccounts(de.getResult());
        }
        this.getContext().flush();
    }

    private void createDbuv(Employee employee) throws BusinessDomainException, PutDataException {
        if (this.mDeuvAdvice.isInsolvencyLeaveCompany()) {
            return;
        }
        DbuvEmployee de = new DbuvEmployee(this.mDeuvAdvice, employee);
        this.mThrower = de;
        de.createAccounts();
        de.makeResults();
        if (this.mPreview) {
            this.mDeuvAdvice.addPreviewAccounts(de.getResult());
        }
        this.getContext().flush();
    }

    private void createDbkv(Employee employee) throws BusinessDomainException, PutDataException {
        DbkvEmployee de = new DbkvEmployee(this.mDeuvAdvice, employee);
        this.mThrower = de;
        de.createAccounts();
        de.makeResults();
        if (this.mPreview) {
            this.mDeuvAdvice.addPreviewAccounts(de.getResult());
        }
        this.getContext().flush();
    }

    private void createDsfz(Employee employee) throws BusinessDomainException {
        DsfzEmployee de = new DsfzEmployee(this.mDeuvAdvice, employee);
        this.mThrower = de;
        de.createAccounts();
        de.makeResults();
        if (this.mPreview) {
            this.mDeuvAdvice.addPreviewAccounts(de.getResult());
        }
        this.getContext().flush();
    }

    private void createDsbd() throws BusinessDomainException, PutDataException {
        DeuvDsbdCreate dsbdCreate = this.getDsbdCreate(this.mDeuvSender);
        this.mThrower = dsbdCreate;
        this.mDsbds = dsbdCreate.createDsbds();
        this.getContext().flush();
    }

    private void createDsak() throws PutDataException, BusinessDomainException {
        this.mProgressBar.setTotal(2);
        this.mProgressBar.update("Erstelle DSAK...");
        DeuvDsakCreator dsakCreator = new DeuvDsakCreator(this.mDeuvSender);
        this.mThrower = dsakCreator;
        this.mDsaks = dsakCreator.createDsaks();
        if (!this.mDsaks.isEmpty()) {
            this.getContext().flush();
            this.mProgressBar.update("Erstelle Report...");
            this.createDsakReport(dsakCreator);
        }
    }

    private boolean createReport() throws BusinessDomainException, PutDataException {
        this.mProgressBar.update("Erstelle Report...");
        List<DEUVAccount> accounts = this.mDeuvAdvice.getUntransmitteds(this.mIsSpecialAccess);
        this.getContext().flush();
        accounts = this.mDeuvAdvice.updateForReport(accounts, this.mAlphabetical);
        if (accounts.isEmpty() && (this.mDsbds == null || this.mDsbds.isEmpty())) {
            return false;
        }
        DeuvAccountProtocolReportDataSource dAccProDataSource = new DeuvAccountProtocolReportDataSource(this.mDeuvAdvice, accounts, this.mDsbds, this.mAnonymised);
        this.mThrower = dAccProDataSource;
        Map parameter = dAccProDataSource.getParameters();
        parameter.put("subreport_DBME", this.compileReport("DEUVDataTransferProtocolDBMESubreport"));
        parameter.put("subreport_DBSO", this.compileReport("DEUVDataTransferProtocolDBSOSubreport"));
        parameter.put("subreport_DBUV", this.compileReport("DEUVDataTransferProtocolDBUVSubreport"));
        parameter.put("subreport_DBKV", this.compileReport("DEUVDataTransferProtocolDBKVSubreport"));
        parameter.put("subreport_DSBD", this.compileReport("DEUVDataTransferProtocolDSBDSubreport"));
        parameter.put("subreport_DBUVDaten", this.compileReport("DEUVDataTransferProtocolDBUVDatenSubreport"));
        parameter.put("subreport_AnzahlMeldungen", this.compileReport("DEUVDataTransferProtocolAnzMeldSubreport"));
        parameter.put("subreport_AnzahlMeldungenGesamt", this.compileReport("DEUVDataTransferProtocolAnzMeldGesSubreport"));
        parameter.put("subreport_DSFZ", this.compileReport("DEUVDataTransferProtocolDSFZSubreport"));
        if (this.mAnonymised) {
            parameter.put("subreport_DSME", this.compileReport("DEUVDataTransferProtocolDSMEAnomSubreport"));
            parameter.put("subreport_DBAN", this.compileReport("DEUVDataTransferProtocolDBANAnomSubreport"));
            parameter.put("subreport_DBGB", this.compileReport("DEUVDataTransferProtocolDBGBAnomSubreport"));
            parameter.put("subreport_DBNA", this.compileReport("DEUVDataTransferProtocolDBNAAnomSubreport"));
            parameter.put("subreport_DBST", this.compileReport("DEUVDataTransferProtocolDBSTAnomSubreport"));
        } else {
            parameter.put("subreport_DSME", this.compileReport("DEUVDataTransferProtocolDSMESubreport"));
            parameter.put("subreport_DBAN", this.compileReport("DEUVDataTransferProtocolDBANSubreport"));
            parameter.put("subreport_DBGB", this.compileReport("DEUVDataTransferProtocolDBGBSubreport"));
            parameter.put("subreport_DBNA", this.compileReport("DEUVDataTransferProtocolDBNASubreport"));
            parameter.put("subreport_DBST", this.compileReport("DEUVDataTransferProtocolDBSTSubreport"));
        }
        parameter.put("REPORT_FORMAT_FACTORY", new ReportFormatFactory());
        File file = this.createFile(dAccProDataSource, parameter, this.compileReport("DEUVAccountProtocolReport"));
        String[] reports = new String[]{JasperReportManager.getUrl((File)file)};
        LOGGER.debug("File name: {}", (Object)reports[0]);
        ((ReportFileStructCallback)this.getCallback()).putData(reports);
        return true;
    }

    private void createDsakReport(DeuvDsakCreator dsakCreator) throws BusinessDomainException, PutDataException {
        HashMap<String, ReportFormatFactory> parameters = new HashMap<String, ReportFormatFactory>();
        parameters.put("REPORT_FORMAT_FACTORY", new ReportFormatFactory());
        final DeuvDsakReportDS dsakDS = new DeuvDsakReportDS(dsakCreator, null);
        ReportBeanDataSource dataSource = new ReportBeanDataSource(dsakDS){

            protected boolean doNext() throws JRException {
                return dsakDS.next();
            }
        };
        File file = JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)JasperReportCompiler.compileReport((String)(DeuvDsakHelper.getDsakReportFolder() + DeuvDsakHelper.getDsakReportName())), parameters, (JRDataSource)dataSource, (String)PROFILE_PREFIX_DSAK);
        String[] reports = new String[]{JasperReportManager.getUrl((File)file)};
        ((ReportFileStructCallback)this.getCallback()).putData(reports);
    }

    private JasperReport compileReport(String reportName) {
        return JasperReportCompiler.compileReport((String)(REPORT_FOLDER + reportName + ".jrxml"));
    }

    private File createFile(DeuvAccountProtocolReportDataSource dAccProDataSource, Map<String, Object> parameter, JasperReport jasperReport) throws BusinessDomainException {
        if (this.mReportExportFormat == ReportExportFormatEnum.REFE_ARCHIVE) {
            return JasperReportManager.runReportToArchive((JasperReport)jasperReport, parameter, (JRDataSource)dAccProDataSource, (String)PROFILE_PREFIX, (byte[])new byte[0], (boolean)false, (int)0, (int)0, (int)0, (int)0);
        }
        return JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)jasperReport, parameter, (JRDataSource)dAccProDataSource, (String)PROFILE_PREFIX);
    }

    private String getPnrString(PCompany pCompany, Employee employee) {
        return "Aufbau DE\u00dcV-Meldungen: " + pCompany.getPCompanyKey() + "/" + employee.getPersonnelnumber();
    }

    private boolean isEmployeeSelection() {
        return !this.mOidEmployees.isEmpty();
    }

    private void rollback(TransactionalServiceAdapter txAdapter, TransactionStatus txStatus, Throwable throwable) {
        if (txAdapter != null && txStatus != null) {
            txAdapter.rollbackOnException(txStatus, throwable);
        }
    }

    private DeuvDsbdCreate getDsbdCreate(DEUVSender deuvSender) throws BusinessDomainException {
        return ((IDeuvSettings)UtilitiesManager.getBean((String)"deuvSettings", IDeuvSettings.class)).getDeuvDsbdCreate(deuvSender);
    }
}

