/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.global.healthfund;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.service.ExceptionHolder;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.taskreminder.TaskFolder;
import com.varial.framework.domain.taskreminder.TaskFolderPersistencyManager;
import com.varial.framework.domain.taskreminder.TaskReminder;
import com.varial.framework.domain.taskreminder.TaskReminderType;
import com.varial.personnel.domain.employee.insurance.IInsurancePersistencyManager;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipientTPPersistencyManager;
import com.varial.personnel.domain.global.healthfund.AnswerBackEnum;
import com.varial.personnel.domain.global.healthfund.Assessment;
import com.varial.personnel.domain.global.healthfund.DuesHI;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTPPersistencyManager;
import com.varial.personnel.domain.global.healthfund.RefundSIEREnum;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.global.healthfund.itsg.Difference;
import com.varial.personnel.domain.global.healthfund.itsg.HealthFundTPItsgPersistencyManager;
import com.varial.personnel.domain.global.healthfund.mapper.HealthFundExceptionMapper;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurance;
import com.varial.personnel.domain.global.socialinsurance.SocialInsuranceTP;
import com.varial.personnel.domain.pcompany.emploffice.CompanyEmploymentOfficePersistencyManager;
import com.varial.personnel.domain.plant.emploffice.PlantEmploymentOfficePersistencyManager;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.basictypes.PostalAddress;
import com.varial.personnel.framework.checkup.CheckUp;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.mapper.PBigDecimalMapper;
import com.varial.personnel.framework.personnelbasic.PersonnelBasic;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.user.IUserPersistencyManager;
import com.varial.serverbase.domain.user.User;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class HealthFundTP
extends PersonnelTimedPersistenceObject {
    private static final IUserPersistencyManager userPersistencyManager = (IUserPersistencyManager)UtilitiesManager.getGenericAccessor().getBean("userPersistencyManager", IUserPersistencyManager.class);
    private static final BigDecimal TWO = new BigDecimal(2);
    private static final int PRIORITY = 2;
    private static final int COUNT_ASSESSMENT = 18;
    public static final int U1_1 = 0;
    public static final int U1_2 = 1;
    public static final int U1_3 = 2;
    public static final int U2_1 = 3;
    public static final int U2_2 = 4;
    public static final int U2_3 = 5;
    public static final int U3_1 = 6;
    public static final int U3_2 = 7;
    public static final int U3_3 = 8;
    private static final Date BEGIN_18_ASSESSMENTS = new VDate(2006, 6, 1).getDate();
    private static final BigDecimal BD100 = BigDecimal.valueOf(10000L, 2);
    private HealthFund mHealthFund;
    private String mShortDescription;
    private String mLongDescription;
    private AnswerBackEnum mAnswerBackEnum;
    private TypeOfHealthFundEnum mTypeOfHealthFundEnum;
    private String mStandardCompanyNumber;
    private String mStandardCompanyNumberSuccessor;
    private Date mStandardCompanyNumberValidUntil;
    private PostalAddress mAddress;
    private BigDecimal mContributionForPensionersPercentage;
    private BigDecimal mContributionForPensionersPercentageEE;
    private BigDecimal mContributionForPensionersPercentageER;
    private BigDecimal mPercentageGeneral;
    private BigDecimal mPercentageReduced;
    private BigDecimal mPercentageIncreased;
    private BigDecimal mPercentageGeneralEE;
    private BigDecimal mPercentageReducedEE;
    private BigDecimal mPercentageIncreasedEE;
    private BigDecimal mPercentageGeneralER;
    private BigDecimal mPercentageReducedER;
    private BigDecimal mPercentageIncreasedER;
    private BigDecimal mDuesVHIGeneral;
    private BigDecimal mDuesVHIReduced;
    private BigDecimal mDuesVHIIncreased;
    private BigDecimal mDuesVHIGeneralGrant;
    private BigDecimal mDuesVHIReducedGrant;
    private BigDecimal mDuesVHIIncreasedGrant;
    private BigDecimal mDuesVNIGeneral;
    private BigDecimal mVNIableForGrantGen;
    protected boolean mValuateNeededAssessment = false;
    private boolean mAdministrateByUser;
    private HealthFund mHealthFundDAV;
    private boolean mU1Limitation;
    private RefundSIEREnum mU1RefundSocialInsuranceER;
    private BigDecimal mU1RefundPercentageFact;
    private boolean mU2LimittationMother;
    private boolean mU2LimitationProhibitionToEmploy;
    private RefundSIEREnum mU2RefundSocialInsuranceER;
    private BigDecimal mU2RefundPercentageFact;
    private BigDecimal mAdditionalDues;
    private BigDecimal mAdditionalDuesEE;
    private BigDecimal mAdditionalDuesER;
    private Date mAdditionalDuesValidFrom;
    private String mCreditorId;
    private HealthFundTP mOld;
    private Assessment[] mAssessments;

    private void initAssessments() {
        if (this.mAssessments == null) {
            this.mAssessments = new Assessment[18];
        }
    }

    public HealthFundTP(HealthFund healthFund) {
        super(2);
        this.mHealthFund = healthFund;
        this.initAssessments();
    }

    protected HealthFundTP(String objectID) {
        super(2, objectID);
        this.initAssessments();
    }

    public HealthFundTP(String objectID, int version, HealthFund healthFund) {
        super(2, objectID, version);
        this.mHealthFund = healthFund;
        this.initAssessments();
    }

    protected HealthFundTP(boolean readOnly) {
        super(2, readOnly);
        this.initAssessments();
    }

    protected HealthFundTP(HealthFund healthFund, boolean readOnly) {
        super(2, readOnly);
        this.mHealthFund = healthFund;
        this.initAssessments();
    }

    public static HealthFundTP getHealthFundTP(String objectID) {
        return new HealthFundTP(objectID);
    }

    protected void load() {
        HealthFundTPPersistencyManager.load((HealthFundTP)this);
    }

    protected void saveImpl() {
        HealthFundTPPersistencyManager.save((HealthFundTP)this);
    }

    protected void deleteImpl() {
        HealthFundTPPersistencyManager.delete((HealthFundTP)this);
    }

    protected void destroyImpl() throws BusinessDomainException {
        if (this.mHealthFund.getSkipCheckAttributes()) {
            return;
        }
        this.checkAnswerBackEnum();
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        return this.mHealthFund.getDomainKey() + " / " + DateMapper.toString((Date)this.mEffectiveFrom) + " / " + DateMapper.toString((Date)this.mValidFrom);
    }

    public void setData(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, String shortDescription, String longDescription, TypeOfHealthFundEnum typeOfHealthFundEnum, AnswerBackEnum answerBackEnum, String standardCompanyNumber, String standardCompanyNumberSuccessor, Date standardCompanyNumberValidUntil, PostalAddress address, BigDecimal contributionForPensionersPercentage, BigDecimal contributionForPensionersPercentageEE, BigDecimal contributionForPensionersPercentageER, BigDecimal percentageGeneral, BigDecimal percentageReduced, BigDecimal percentageIncreased, BigDecimal percentageGeneralEE, BigDecimal percentageReducedEE, BigDecimal percentageIncreasedEE, BigDecimal percentageGeneralER, BigDecimal percentageReducedER, BigDecimal percentageIncreasedER, BigDecimal duesVHIGeneral, BigDecimal duesVHIReduced, BigDecimal duesVHIIncreased, BigDecimal duesVHIGeneralGrant, BigDecimal duesVHIReducedGrant, BigDecimal duesVHIIncreasedGrant, BigDecimal duesVNIGeneral, Assessment[] assessments, BigDecimal vniAbleForGrantGen, boolean administrateByUser, HealthFund healthFundDAV, boolean u1Limitation, RefundSIEREnum u1RefundSocialInsuranceER, BigDecimal u1RefundPercentageFact, boolean u2LimittationMother, boolean u2LimitationProhibitionToEmploy, RefundSIEREnum u2RefundSocialInsuranceER, BigDecimal u2RefundPercentageFact, BigDecimal additionalDues, BigDecimal additionalDuesEE, BigDecimal additionalDuesER, Date additionalDuesValidFrom, String creditorId) {
        this.mEffectiveFrom = effectiveFrom;
        this.mEffectiveUntil = effectiveUntil;
        this.mValidFrom = validFrom;
        this.mValidUntil = validUntil;
        this.mShortDescription = shortDescription;
        this.mLongDescription = longDescription;
        this.mAnswerBackEnum = answerBackEnum;
        this.mTypeOfHealthFundEnum = typeOfHealthFundEnum;
        this.mStandardCompanyNumber = standardCompanyNumber;
        this.mStandardCompanyNumberSuccessor = standardCompanyNumberSuccessor;
        this.mStandardCompanyNumberValidUntil = standardCompanyNumberValidUntil;
        this.mAddress = address;
        this.mContributionForPensionersPercentage = contributionForPensionersPercentage;
        this.mContributionForPensionersPercentageEE = contributionForPensionersPercentageEE;
        this.mContributionForPensionersPercentageER = contributionForPensionersPercentageER;
        this.mPercentageGeneral = percentageGeneral;
        this.mPercentageReduced = percentageReduced;
        this.mPercentageIncreased = percentageIncreased;
        this.mPercentageGeneralEE = percentageGeneralEE;
        this.mPercentageReducedEE = percentageReducedEE;
        this.mPercentageIncreasedEE = percentageIncreasedEE;
        this.mPercentageGeneralER = percentageGeneralER;
        this.mPercentageReducedER = percentageReducedER;
        this.mPercentageIncreasedER = percentageIncreasedER;
        this.mDuesVHIGeneral = duesVHIGeneral;
        this.mDuesVHIReduced = duesVHIReduced;
        this.mDuesVHIIncreased = duesVHIIncreased;
        this.mDuesVHIGeneralGrant = duesVHIGeneralGrant;
        this.mDuesVHIReducedGrant = duesVHIReducedGrant;
        this.mDuesVHIIncreasedGrant = duesVHIIncreasedGrant;
        this.mDuesVNIGeneral = duesVNIGeneral;
        this.setAssessments(assessments);
        this.mVNIableForGrantGen = vniAbleForGrantGen;
        this.mAdministrateByUser = administrateByUser;
        this.mHealthFundDAV = healthFundDAV;
        this.mU1Limitation = u1Limitation;
        this.mU1RefundSocialInsuranceER = u1RefundSocialInsuranceER;
        this.mU1RefundPercentageFact = u1RefundPercentageFact;
        this.mU2LimittationMother = u2LimittationMother;
        this.mU2LimitationProhibitionToEmploy = u2LimitationProhibitionToEmploy;
        this.mU2RefundSocialInsuranceER = u2RefundSocialInsuranceER;
        this.mU2RefundPercentageFact = u2RefundPercentageFact;
        this.mAdditionalDues = additionalDues;
        this.mAdditionalDuesEE = additionalDuesEE;
        this.mAdditionalDuesER = additionalDuesER;
        this.mAdditionalDuesValidFrom = additionalDuesValidFrom;
        this.mCreditorId = creditorId;
    }

    @Override
    public void checkAttributes() throws BusinessDomainException {
        this.requireLoaded();
        this.checkDates();
        this.checkHealthFundKey();
        if (this.mAdministrateByUser) {
            FrameWorkExceptionMapper.makeInputNotAllowedDomainException((String)"selbstverwaltet = ja");
        }
        if (this.mHealthFund.getSkipCheckAttributes()) {
            return;
        }
        this.checkAnswerBackEnum();
        this.checkStandardCompanyNumber();
        this.checkStandardCompanyNumberSuccessor();
        this.checkTypeOfHealthFundEnum();
        this.checkPercentage();
        this.checkAssessments();
        SocialInsuranceTP socialInsuranceTP = SocialInsurance.getSocialInsuranceHistory((Date)this.getEffectiveFrom(), (Date)this.getValidFrom());
        if (socialInsuranceTP == null) {
            throw HealthFundExceptionMapper.makeSocialInsuranceTPMissingDomainException();
        }
        this.checkDuesVHI(socialInsuranceTP);
        this.checkDuesVNI(socialInsuranceTP);
        this.checkHealthFundDAV();
    }

    private void checkHealthFundDAV() throws BusinessDomainException {
        if (this.mHealthFundDAV != null && this.mHealthFundDAV.getHealthFundTP(VDate.getDateMax(), this.mValidFrom).getAnswerBackEnum() != AnswerBackEnum.ABE_DatenAnnahmeStelle) {
            throw HealthFundExceptionMapper.makeAssignmentNotAllowedDomainException();
        }
    }

    @Override
    public void checkDates() throws BusinessDomainException {
        super.checkDates();
        PersonnelBasic pb = PersonnelBasic.getPersonnelBasic();
        if (DateHelper.before((Date)this.mValidFrom, (Date)pb.getSystemStart())) {
            throw FrameWorkExceptionMapper.makeStartHistoryBeforeSystemStartDomainException();
        }
        if (this.mHealthFund.isNew()) {
            this.setEffectiveFrom(pb.getSystemStart());
        }
    }

    void checkAnswerBackEnum() throws BusinessDomainException {
        this.requireLoaded();
        if (this.mAnswerBackEnum == AnswerBackEnum.ABE_DatenAnnahmeStelle) {
            if (this.mHealthFund.isNew()) {
                throw HealthFundExceptionMapper.makeCreateNotAllowedDomainException();
            }
            throw HealthFundExceptionMapper.makeSaveNotAllowedDomainException();
        }
    }

    private void checkHealthFundKey() throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.mHealthFund.getHealthFund())) {
            throw HealthFundExceptionMapper.makeHealthFundMissingDomainException();
        }
    }

    private void checkStandardCompanyNumber() throws BusinessDomainException {
        long rowCount;
        if (StringMapper.isNullString((String)this.mStandardCompanyNumber)) {
            throw HealthFundExceptionMapper.makeStandardCompanyNumberMissingDomainException();
        }
        CheckUp.stdCompanyNumberCheckup((String)this.mStandardCompanyNumber);
        if (this.mAnswerBackEnum.value() == 0 && this.mTypeOfHealthFundEnum.value() == 6 && (rowCount = HealthFundTPPersistencyManager.getRowCount((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"stdcompanyno", (String)this.mStandardCompanyNumber), Restrictions.eq((String)"answerback", (String)Integer.toString(0)), Restrictions.ne((String)"oidhealthfund", (String)this.getHealthFund().getObjectid())}))) > 0L) {
            throw HealthFundExceptionMapper.makeOnlyOneHFofBundesknappschaftAllowedDomainException();
        }
    }

    private void checkStandardCompanyNumberSuccessor() throws BusinessDomainException {
        if (!StringMapper.isNullString((String)this.mStandardCompanyNumberSuccessor)) {
            if (this.mStandardCompanyNumberValidUntil == null) {
                throw HealthFundExceptionMapper.makeStandardCompanyNumberAndValidUntilDontCorrespondingDomainException();
            }
            CheckUp.stdCompanyNumberCheckup((String)this.mStandardCompanyNumberSuccessor);
        }
        if (StringMapper.equal((String)this.mStandardCompanyNumber, (String)this.mStandardCompanyNumberSuccessor)) {
            throw HealthFundExceptionMapper.makeStandardCompanyNumbersEqualDomainException();
        }
    }

    private void checkTypeOfHealthFundEnum() throws BusinessDomainException {
        if (this.mTypeOfHealthFundEnum.value() == 5 && this.getAssessmentU11() != null && !BigDecimalMapper.isZero((BigDecimal)this.getAssessmentU11().getRefundPercentage())) {
            throw HealthFundExceptionMapper.makeTypeOfHealthFundAndValuesDontCorrespondingDomainException();
        }
    }

    private void checkPercentage() throws BusinessDomainException {
        if (this.mTypeOfHealthFundEnum.value() != 5 && (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPercentageGeneral) || BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPercentageReduced))) {
            throw HealthFundExceptionMapper.makePercentageMissingDomainException();
        }
        if (!BigDecimalMapper.isZero((BigDecimal)this.mPercentageGeneral) && BigDecimalMapper.compareTo((BigDecimal)this.mPercentageGeneral, (BigDecimal)this.mPercentageReduced) != 1) {
            throw HealthFundExceptionMapper.makePercentageGeneralAndReducedDontCorrespondingDomainException();
        }
    }

    private void checkDuesVHI(SocialInsuranceTP socialInsuranceTP) throws BusinessDomainException {
        if (this.mTypeOfHealthFundEnum.value() == 5 && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPercentageGeneral) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPercentageIncreased) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPercentageReduced)) {
            return;
        }
        if (DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)DateHelper.parse((String)"2016-01-01")) && (this.mStandardCompanyNumberValidUntil == null || DateHelper.after((Date)this.mStandardCompanyNumberValidUntil, (Date)this.mValidFrom))) {
            if (!PBigDecimalMapper.isEqual((BigDecimal)this.mPercentageGeneral, (BigDecimal)socialInsuranceTP.getGlobal().getAverageGeneralContributionRateForAllowanceInPHI())) {
                FrameWorkExceptionMapper.makeInputNotValidDomainException((String)"Beitragssatz allgemein [1]");
            }
            if (!PBigDecimalMapper.isEqual((BigDecimal)this.mPercentageReduced, (BigDecimal)socialInsuranceTP.getGlobal().getAverageReducedContributionRateForAllowanceInPHI())) {
                FrameWorkExceptionMapper.makeInputNotValidDomainException((String)"Beitragssatz erm\u00e4\u00dfigt [3]");
            }
            if (!PBigDecimalMapper.isEqual((BigDecimal)this.mContributionForPensionersPercentage, (BigDecimal)socialInsuranceTP.getGlobal().getAverageGeneralContributionRateForAllowanceInPHI())) {
                FrameWorkExceptionMapper.makeInputNotValidDomainException((String)"Beitragssatz Versorgungsbez\u00fcge");
            }
        }
        if (!BigDecimalMapper.isZero((BigDecimal)this.mDuesVHIGeneral)) {
            if (!BigDecimalMapper.isZero((BigDecimal)this.mDuesVHIReduced) && BigDecimalMapper.compareTo((BigDecimal)this.mDuesVHIGeneral, (BigDecimal)this.mDuesVHIReduced) != 1) {
                throw HealthFundExceptionMapper.makeDuesVHIGeneralAndReducedDontCorrespondingDomainException();
            }
        } else if (!BigDecimalMapper.isZero((BigDecimal)this.mDuesVHIIncreased) || !BigDecimalMapper.isZero((BigDecimal)this.mDuesVHIReduced)) {
            throw HealthFundExceptionMapper.makeDuesVHIGeneralAndDuesVHIDontCorrespondingDomainException();
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mAdditionalDues)) {
            this.mAdditionalDues = BigDecimal.valueOf(0L);
        }
        DuesHI duesHI = new DuesHI(socialInsuranceTP, this.mPercentageGeneral, this.mAdditionalDues);
        if (!BigDecimalMapper.isZero((BigDecimal)this.mDuesVHIGeneral)) {
            if (BigDecimalMapper.compareTo((BigDecimal)this.mDuesVHIGeneral, (BigDecimal)duesHI.getDuesVHI().add(TWO)) == 1) {
                throw HealthFundExceptionMapper.makeDuesVHIGeneralToGreatDomainException((String)BigDecimalMapper.toString((BigDecimal)duesHI.getDuesVHI().add(TWO)));
            }
            if (BigDecimalMapper.compareTo((BigDecimal)this.mDuesVHIGeneral, (BigDecimal)duesHI.getDuesVHI().subtract(TWO)) == -1) {
                throw HealthFundExceptionMapper.makeDuesVHIGeneralToLowDomainException((String)BigDecimalMapper.toString((BigDecimal)duesHI.getDuesVHI().subtract(TWO)));
            }
        }
        if (!BigDecimalMapper.isZero((BigDecimal)this.mDuesVHIGeneral)) {
            if (BigDecimalMapper.compareTo((BigDecimal)this.mDuesVHIGeneralGrant, (BigDecimal)duesHI.getDuesVHIGrant().add(TWO)) == 1) {
                throw HealthFundExceptionMapper.makeDuesVHIGeneralGrantToGreatDomainException((String)BigDecimalMapper.toString((BigDecimal)duesHI.getDuesVHIGrant().add(TWO)));
            }
            if (BigDecimalMapper.compareTo((BigDecimal)this.mDuesVHIGeneralGrant, (BigDecimal)duesHI.getDuesVHIGrant().subtract(TWO)) == -1) {
                throw HealthFundExceptionMapper.makeDuesVHIGeneralGrantToLowDomainException((String)BigDecimalMapper.toString((BigDecimal)duesHI.getDuesVHIGrant().subtract(TWO)));
            }
        }
        duesHI.setPercentage(this.mPercentageReduced);
        if (!BigDecimalMapper.isZero((BigDecimal)this.mDuesVHIReduced)) {
            if (BigDecimalMapper.compareTo((BigDecimal)this.mDuesVHIReduced, (BigDecimal)duesHI.getDuesVHI().add(TWO)) == 1) {
                throw HealthFundExceptionMapper.makeDuesVHIReducedToGreatDomainException((String)BigDecimalMapper.toString((BigDecimal)duesHI.getDuesVHI().add(TWO)));
            }
            if (BigDecimalMapper.compareTo((BigDecimal)this.mDuesVHIReduced, (BigDecimal)duesHI.getDuesVHI().subtract(TWO)) == -1) {
                throw HealthFundExceptionMapper.makeDuesVHIReducedToLowDomainException((String)BigDecimalMapper.toString((BigDecimal)duesHI.getDuesVHI().subtract(TWO)));
            }
        }
        if (!BigDecimalMapper.isZero((BigDecimal)this.mDuesVHIReduced)) {
            if (BigDecimalMapper.compareTo((BigDecimal)this.mDuesVHIReducedGrant, (BigDecimal)duesHI.getDuesVHIGrant().add(TWO)) == 1) {
                throw HealthFundExceptionMapper.makeDuesVHIReducedGrantToGreatDomainException((String)BigDecimalMapper.toString((BigDecimal)duesHI.getDuesVHIGrant().add(TWO)));
            }
            if (BigDecimalMapper.compareTo((BigDecimal)this.mDuesVHIReducedGrant, (BigDecimal)duesHI.getDuesVHIGrant().subtract(TWO)) == -1) {
                throw HealthFundExceptionMapper.makeDuesVHIReducedGrantToLowDomainException((String)BigDecimalMapper.toString((BigDecimal)duesHI.getDuesVHIGrant().subtract(TWO)));
            }
        }
        duesHI.setPercentage(this.mPercentageIncreased);
        if (!BigDecimalMapper.isZero((BigDecimal)this.mDuesVHIIncreased)) {
            if (BigDecimalMapper.compareTo((BigDecimal)this.mDuesVHIIncreased, (BigDecimal)duesHI.getDuesVHI().add(TWO)) == 1) {
                throw HealthFundExceptionMapper.makeDuesVHIIncreasedToGreatDomainException((String)BigDecimalMapper.toString((BigDecimal)duesHI.getDuesVHI().add(TWO)));
            }
            if (BigDecimalMapper.compareTo((BigDecimal)this.mDuesVHIIncreased, (BigDecimal)duesHI.getDuesVHI().subtract(TWO)) == -1) {
                throw HealthFundExceptionMapper.makeDuesVHIIncreasedToLowDomainException((String)BigDecimalMapper.toString((BigDecimal)duesHI.getDuesVHI().subtract(TWO)));
            }
        }
        if (!BigDecimalMapper.isZero((BigDecimal)this.mDuesVHIIncreased)) {
            if (BigDecimalMapper.compareTo((BigDecimal)this.mDuesVHIIncreasedGrant, (BigDecimal)duesHI.getDuesVHIGrant().add(TWO)) == 1) {
                throw HealthFundExceptionMapper.makeDuesVHIIncreasedGrantToGreatDomainException((String)BigDecimalMapper.toString((BigDecimal)duesHI.getDuesVHIGrant().add(TWO)));
            }
            if (BigDecimalMapper.compareTo((BigDecimal)this.mDuesVHIIncreasedGrant, (BigDecimal)duesHI.getDuesVHIGrant().subtract(TWO)) == -1) {
                throw HealthFundExceptionMapper.makeDuesVHIIncreasedGrantToLowDomainException((String)BigDecimalMapper.toString((BigDecimal)duesHI.getDuesVHIGrant().subtract(TWO)));
            }
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mDuesVHIGeneral) || BigDecimalMapper.isZeroOrNull((BigDecimal)this.mDuesVHIReduced) || BigDecimalMapper.isZeroOrNull((BigDecimal)this.mDuesVHIGeneralGrant) || BigDecimalMapper.isZeroOrNull((BigDecimal)this.mDuesVHIReducedGrant)) {
            throw HealthFundExceptionMapper.makeDuesVHIMissingDomainException();
        }
    }

    private void checkAssessments() throws BusinessDomainException {
        int i;
        if (this.getTypeOfHealthFundEnum().value() == 5) {
            if (this.assessmentsAvailable()) {
                throw HealthFundExceptionMapper.makeLKKAndAssessmentsDontCorrespondingDomainException();
            }
            return;
        }
        if (DateHelper.compare((Date)this.mValidFrom, (Date)new VDate(2006, 0, 1).getDate()) < 0) {
            if (this.mTypeOfHealthFundEnum.value() == 3 && this.assessmentsAvailable()) {
                throw HealthFundExceptionMapper.makeVdAKAndAssessmentsDontCorrespondingDomainException();
            }
            return;
        }
        Assessment[] as = this.getAssessments();
        this.checkAssessments(as);
        if (as[0] == null || as[3] == null || BigDecimalMapper.isZeroOrNull((BigDecimal)as[0].getRefundPercentage()) || BigDecimalMapper.isZeroOrNull((BigDecimal)as[3].getRefundPercentage())) {
            throw HealthFundExceptionMapper.makeRefundPercentageOfAssessmentMissingDomainException();
        }
        for (i = 0; i < 3; ++i) {
            if (as[i] == null || BigDecimalMapper.compareTo((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)as[i].getRefundPercentage()) != 0) continue;
            throw HealthFundExceptionMapper.makeAssessmentU1FalseDomainException();
        }
        i = 3;
        if (as[3] != null && !BigDecimalMapper.isZeroOrNull((BigDecimal)as[3].getRefundPercentage()) && BigDecimalMapper.compareTo((BigDecimal)as[3].getRefundPercentage(), (BigDecimal)BigDecimal.valueOf(100L)) != 0) {
            throw HealthFundExceptionMapper.makeAssessmentU2FalseDomainException();
        }
        if (this.mU1RefundSocialInsuranceER == RefundSIEREnum.RS_PAUSCHALER_ZUSCHLAG_AE_BEGRENZT_SV_AGA) {
            throw HealthFundExceptionMapper.makeRefundSIERnotAllowedDomainException();
        }
    }

    public Assessment[] getAssessments() {
        return this.mAssessments;
    }

    private void checkAssessments(Assessment[] as) throws BusinessDomainException {
        if (DateHelper.before((Date)this.mValidFrom, (Date)DateMapper.toDate((String)"2007-01-01"))) {
            for (int i = 0; i < as.length; ++i) {
                Assessment a = as[i];
                if (a == null) continue;
                a.checkValues();
            }
        }
        BigDecimal[][] ordereds = new BigDecimal[3][6];
        int u1 = 0;
        int u2 = 0;
        int u3 = 0;
        for (int i = 0; i < as.length; ++i) {
            Assessment a = as[i];
            if (a == null) continue;
            String key = a.getAssessmentKey();
            BigDecimal refund = a.getRefundPercentage();
            if ("U1".equals(key)) {
                ordereds[0][u1++] = refund;
                continue;
            }
            if ("U2".equals(key) && BigDecimalMapper.compareTo((BigDecimal)refund, (BigDecimal)BD100) <= 0) {
                ordereds[1][u2++] = refund;
                continue;
            }
            if (!"U3".equals(key)) continue;
            ordereds[2][u3++] = refund;
        }
        this.checkOrdering(ordereds[0], u1);
        this.checkOrdering(ordereds[1], u2);
        this.checkOrdering(ordereds[2], u3);
    }

    private void checkOrdering(BigDecimal[] ordereds, int after) throws BusinessDomainException {
        if (after < 2) {
            return;
        }
        BigDecimal previous = ordereds[--after];
        while (after >= 0) {
            BigDecimal current = ordereds[after];
            if (BigDecimalMapper.compareTo((BigDecimal)previous, (BigDecimal)current) > 0) {
                throw HealthFundExceptionMapper.makeAssessmentSortFalseDomainException();
            }
            previous = current;
            --after;
        }
    }

    private void checkDuesVNI(SocialInsuranceTP socialInsuranceTP) throws BusinessDomainException {
        if (this.mTypeOfHealthFundEnum.value() == 5 && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPercentageGeneral) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPercentageIncreased) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPercentageReduced)) {
            return;
        }
        BigDecimal duesVNI = HealthFund.getDuesVNI((SocialInsuranceTP)socialInsuranceTP);
        BigDecimal vniAbleForGrant = HealthFund.getVNIableForGrant((SocialInsuranceTP)socialInsuranceTP);
        if (!BigDecimalMapper.isZero((BigDecimal)this.getDuesVNIGeneral())) {
            if (BigDecimalMapper.compareTo((BigDecimal)this.getDuesVNIGeneral(), (BigDecimal)duesVNI.add(TWO)) == 1) {
                throw HealthFundExceptionMapper.makeDuesVNIGeneralToGreatDomainException();
            }
            if (BigDecimalMapper.compareTo((BigDecimal)this.getDuesVHIGeneral(), (BigDecimal)duesVNI.subtract(TWO)) == -1) {
                throw HealthFundExceptionMapper.makeDuesVNIGeneralToLowDomainException();
            }
        }
        if (!BigDecimalMapper.isZero((BigDecimal)this.getVNIableForGrantGen())) {
            if (BigDecimalMapper.compareTo((BigDecimal)this.getVNIableForGrantGen(), (BigDecimal)vniAbleForGrant.add(TWO)) == 1) {
                throw HealthFundExceptionMapper.makeVNIableForGrantGenToGreatDomainException();
            }
            if (BigDecimalMapper.compareTo((BigDecimal)this.getVNIableForGrantGen(), (BigDecimal)vniAbleForGrant.subtract(TWO)) == -1) {
                throw HealthFundExceptionMapper.makeVNIableForGrantGenToLowDomainException();
            }
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mDuesVNIGeneral) || BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVNIableForGrantGen)) {
            throw HealthFundExceptionMapper.makeDuesVNIMissingDomainException();
        }
    }

    @Override
    public PersonnelTimedPersistenceObject createNew() {
        HealthFundTP result = new HealthFundTP(this.mHealthFund);
        this.fill(result);
        return result;
    }

    protected void fill(HealthFundTP result) {
        this.requireLoaded();
        result.mEffectiveFrom = this.mEffectiveFrom;
        result.mEffectiveUntil = this.mEffectiveUntil;
        result.mValidFrom = this.mValidFrom;
        result.mValidUntil = this.mValidUntil;
        result.mShortDescription = this.mShortDescription;
        result.mLongDescription = this.mLongDescription;
        result.mAnswerBackEnum = this.mAnswerBackEnum;
        result.mTypeOfHealthFundEnum = this.mTypeOfHealthFundEnum;
        result.mStandardCompanyNumber = this.mStandardCompanyNumber;
        result.mStandardCompanyNumberSuccessor = this.mStandardCompanyNumberSuccessor;
        result.mStandardCompanyNumberValidUntil = this.mStandardCompanyNumberValidUntil;
        result.mAddress = this.mAddress;
        result.mContributionForPensionersPercentage = this.mContributionForPensionersPercentage;
        result.mContributionForPensionersPercentageEE = this.mContributionForPensionersPercentageEE;
        result.mContributionForPensionersPercentageER = this.mContributionForPensionersPercentageER;
        result.mPercentageGeneral = this.mPercentageGeneral;
        result.mPercentageReduced = this.mPercentageReduced;
        result.mPercentageIncreased = this.mPercentageIncreased;
        result.mPercentageGeneralEE = this.mPercentageGeneralEE;
        result.mPercentageReducedEE = this.mPercentageReducedEE;
        result.mPercentageIncreasedEE = this.mPercentageIncreasedEE;
        result.mPercentageGeneralER = this.mPercentageGeneralER;
        result.mPercentageReducedER = this.mPercentageReducedER;
        result.mPercentageIncreasedER = this.mPercentageIncreasedER;
        result.mDuesVHIGeneral = this.mDuesVHIGeneral;
        result.mDuesVHIReduced = this.mDuesVHIReduced;
        result.mDuesVHIIncreased = this.mDuesVHIIncreased;
        result.mDuesVHIGeneralGrant = this.mDuesVHIGeneralGrant;
        result.mDuesVHIReducedGrant = this.mDuesVHIReducedGrant;
        result.mDuesVHIIncreasedGrant = this.mDuesVHIIncreasedGrant;
        result.mDuesVNIGeneral = this.mDuesVNIGeneral;
        for (int i = 0; i < 18; ++i) {
            Assessment a = this.mAssessments[i];
            if (a == null) continue;
            result.mAssessments[i] = a.createNew(result);
        }
        result.mVNIableForGrantGen = this.mVNIableForGrantGen;
        result.mAdministrateByUser = this.mAdministrateByUser;
        result.mHealthFundDAV = this.mHealthFundDAV;
        result.mU1Limitation = this.mU1Limitation;
        result.mU1RefundSocialInsuranceER = this.mU1RefundSocialInsuranceER;
        result.mU1RefundPercentageFact = this.mU1RefundPercentageFact;
        result.mU2LimittationMother = this.mU2LimittationMother;
        result.mU2LimitationProhibitionToEmploy = this.mU2LimitationProhibitionToEmploy;
        result.mU2RefundSocialInsuranceER = this.mU2RefundSocialInsuranceER;
        result.mU2RefundPercentageFact = this.mU2RefundPercentageFact;
        result.mAdditionalDues = this.mAdditionalDues;
        result.mAdditionalDuesEE = this.mAdditionalDuesEE;
        result.mAdditionalDuesER = this.mAdditionalDuesER;
        result.mAdditionalDuesValidFrom = this.mAdditionalDuesValidFrom;
        result.mCreditorId = this.mCreditorId;
    }

    public HealthFund getHealthFund() {
        this.requireLoaded();
        return this.mHealthFund;
    }

    public String getShortDescription() {
        this.requireLoaded();
        return this.mShortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.mShortDescription = shortDescription;
    }

    public String getLongDescription() {
        this.requireLoaded();
        return this.mLongDescription;
    }

    public void setLongDescription(String longDescription) {
        this.mLongDescription = longDescription;
    }

    public AnswerBackEnum getAnswerBackEnum() {
        this.requireLoaded();
        return this.mAnswerBackEnum;
    }

    public void setAnswerBackEnum(AnswerBackEnum answerBackEnum) {
        this.mAnswerBackEnum = answerBackEnum;
    }

    public TypeOfHealthFundEnum getTypeOfHealthFundEnum() {
        this.requireLoaded();
        return this.mTypeOfHealthFundEnum;
    }

    public void setTypeOfHealthFundEnum(TypeOfHealthFundEnum typeOfHealthFundEnum) {
        this.mTypeOfHealthFundEnum = typeOfHealthFundEnum;
    }

    public String getStandardCompanyNumber() {
        this.requireLoaded();
        return this.mStandardCompanyNumber;
    }

    public void setStandardCompanyNumber(String standardCompanyNumber) {
        this.mStandardCompanyNumber = standardCompanyNumber;
    }

    public String getStandardCompanyNumberSuccessor() {
        this.requireLoaded();
        return this.mStandardCompanyNumberSuccessor;
    }

    public void setStandardCompanyNumberSuccessor(String standardCompanyNumberSuccessor) {
        this.mStandardCompanyNumberSuccessor = standardCompanyNumberSuccessor;
    }

    public Date getStandardCompanyNumberValidUntil() {
        this.requireLoaded();
        return this.mStandardCompanyNumberValidUntil;
    }

    public void setStandardCompanyNumberValidUntil(Date standardCompanyNumberValidUntil) {
        this.mStandardCompanyNumberValidUntil = standardCompanyNumberValidUntil;
    }

    public PostalAddress getAddress() {
        this.requireLoaded();
        return this.mAddress;
    }

    public void setAddress(PostalAddress address) {
        this.mAddress = address;
    }

    public BigDecimal getContributionForPensionersPercentage() {
        this.requireLoaded();
        return this.mContributionForPensionersPercentage;
    }

    public void setContributionForPensionersPercentage(BigDecimal value) {
        this.mContributionForPensionersPercentage = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getContributionForPensionersPercentageEE() {
        this.requireLoaded();
        return this.mContributionForPensionersPercentageEE;
    }

    public void setContributionForPensionersPercentageEE(BigDecimal value) {
        this.mContributionForPensionersPercentageEE = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getContributionForPensionersPercentageER() {
        this.requireLoaded();
        return this.mContributionForPensionersPercentageER;
    }

    public void setContributionForPensionersPercentageER(BigDecimal value) {
        this.mContributionForPensionersPercentageER = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getPercentageGeneral() {
        this.requireLoaded();
        return this.mPercentageGeneral;
    }

    public void setPercentageGeneral(BigDecimal value) {
        this.mPercentageGeneral = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public void setPercentageReduced(BigDecimal value) {
        this.mPercentageReduced = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getPercentageReduced() {
        this.requireLoaded();
        return this.mPercentageReduced;
    }

    public BigDecimal getPercentageIncreased() {
        this.requireLoaded();
        return this.mPercentageIncreased;
    }

    public void setPercentageIncreased(BigDecimal value) {
        this.mPercentageIncreased = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getPercentageGeneralEE() {
        this.requireLoaded();
        return this.mPercentageGeneralEE;
    }

    public void setPercentageGeneralEE(BigDecimal value) {
        this.mPercentageGeneralEE = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getPercentageReducedEE() {
        this.requireLoaded();
        return this.mPercentageReducedEE;
    }

    public void setPercentageReducedEE(BigDecimal value) {
        this.mPercentageReducedEE = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getPercentageIncreasedEE() {
        this.requireLoaded();
        return this.mPercentageIncreasedEE;
    }

    public void setPercentageIncreasedEE(BigDecimal value) {
        this.mPercentageIncreasedEE = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getPercentageGeneralER() {
        this.requireLoaded();
        return this.mPercentageGeneralER;
    }

    public void setPercentageGeneralER(BigDecimal value) {
        this.mPercentageGeneralER = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getPercentageReducedER() {
        this.requireLoaded();
        return this.mPercentageReducedER;
    }

    public void setPercentageReducedER(BigDecimal value) {
        this.mPercentageReducedER = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getPercentageIncreasedER() {
        this.requireLoaded();
        return this.mPercentageIncreasedER;
    }

    public void setPercentageIncreasedER(BigDecimal value) {
        this.mPercentageIncreasedER = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getDuesVHIGeneral() {
        this.requireLoaded();
        return this.mDuesVHIGeneral;
    }

    public void setDuesVHIGeneral(BigDecimal value) {
        this.mDuesVHIGeneral = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getDuesVHIReduced() {
        this.requireLoaded();
        return this.mDuesVHIReduced;
    }

    public void setDuesVHIReduced(BigDecimal value) {
        this.mDuesVHIReduced = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getDuesVHIIncreased() {
        this.requireLoaded();
        return this.mDuesVHIIncreased;
    }

    public void setDuesVHIIncreased(BigDecimal value) {
        this.mDuesVHIIncreased = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getDuesVHIGeneralGrant() {
        this.requireLoaded();
        return this.mDuesVHIGeneralGrant;
    }

    public void setDuesVHIGeneralGrant(BigDecimal value) {
        this.mDuesVHIGeneralGrant = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getDuesVHIReducedGrant() {
        this.requireLoaded();
        return this.mDuesVHIReducedGrant;
    }

    public void setDuesVHIReducedGrant(BigDecimal value) {
        this.mDuesVHIReducedGrant = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getDuesVHIIncreasedGrant() {
        this.requireLoaded();
        return this.mDuesVHIIncreasedGrant;
    }

    public void setDuesVHIIncreasedGrant(BigDecimal value) {
        this.mDuesVHIIncreasedGrant = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getDuesVNIGeneral() {
        this.requireLoaded();
        return this.mDuesVNIGeneral;
    }

    public void setDuesVNIGeneral(BigDecimal value) {
        this.mDuesVNIGeneral = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public BigDecimal getVNIableForGrantGen() {
        this.requireLoaded();
        return this.mVNIableForGrantGen;
    }

    public void setVNIableForGrantGen(BigDecimal value) {
        this.mVNIableForGrantGen = BigDecimalMapper.toBigDecimal((BigDecimal)value);
    }

    public Assessment getAssessmentU11() {
        this.requireLoaded();
        return this.mAssessments[0];
    }

    public void setAssessmentU11(Assessment u11) {
        this.mAssessments[0] = u11;
    }

    public Assessment getAssessmentU12() {
        this.requireLoaded();
        return this.mAssessments[1];
    }

    public void setAssessmentU12(Assessment u12) {
        this.mAssessments[1] = u12;
    }

    public Assessment getAssessmentU13() {
        this.requireLoaded();
        return this.mAssessments[2];
    }

    public void setAssessmentU13(Assessment u13) {
        this.mAssessments[2] = u13;
    }

    public Assessment getAssessmentU21() {
        this.requireLoaded();
        return this.mAssessments[3];
    }

    public void setAssessmentU21(Assessment u21) {
        this.mAssessments[3] = u21;
    }

    public Assessment getAssessmentU22() {
        this.requireLoaded();
        return this.mAssessments[4];
    }

    public void setAssessmentU22(Assessment u22) {
        this.mAssessments[4] = u22;
    }

    public Assessment getAssessmentU23() {
        this.requireLoaded();
        return this.mAssessments[5];
    }

    public void setAssessmentU23(Assessment u23) {
        this.mAssessments[5] = u23;
    }

    public Assessment getAssessmentU31() {
        this.requireLoaded();
        return this.mAssessments[6];
    }

    public void setAssessmentU31(Assessment u31) {
        this.mAssessments[6] = u31;
    }

    public Assessment getAssessmentU32() {
        this.requireLoaded();
        return this.mAssessments[7];
    }

    public void setAssessmentU32(Assessment u32) {
        this.mAssessments[7] = u32;
    }

    public Assessment getAssessmentU33() {
        this.requireLoaded();
        return this.mAssessments[8];
    }

    public void setAssessmentU33(Assessment u33) {
        this.mAssessments[8] = u33;
    }

    public boolean getAdministrateByUser() {
        this.requireLoaded();
        return this.mAdministrateByUser;
    }

    public void setAdministrateByUser(boolean administrateByUser) {
        this.mAdministrateByUser = administrateByUser;
    }

    public HealthFund getHealthFundDAV() {
        this.requireLoaded();
        return this.mHealthFundDAV;
    }

    public void setHealthFundDAV(HealthFund healthFundDAV) {
        this.mHealthFundDAV = healthFundDAV;
    }

    public boolean getU1Limitation() {
        this.requireLoaded();
        return this.mU1Limitation;
    }

    public void setU1Limitation(boolean u1Limitation) {
        this.mU1Limitation = u1Limitation;
    }

    public RefundSIEREnum getU1RefundSocialInsuranceER() {
        this.requireLoaded();
        return this.mU1RefundSocialInsuranceER;
    }

    public void setU1RefundSocialInsuranceER(RefundSIEREnum u1RefundSocialInsuranceER) {
        this.mU1RefundSocialInsuranceER = u1RefundSocialInsuranceER;
    }

    public BigDecimal getU1RefundPercentageFact() {
        this.requireLoaded();
        return this.mU1RefundPercentageFact;
    }

    public void setU1RefundPercentageFact(BigDecimal u1RefundPercentageFact) {
        this.mU1RefundPercentageFact = BigDecimalMapper.toBigDecimal((BigDecimal)u1RefundPercentageFact);
    }

    public boolean getU2LimittationMother() {
        this.requireLoaded();
        return this.mU2LimittationMother;
    }

    public void setU2LimittationMother(boolean u2LimittationMother) {
        this.mU2LimittationMother = u2LimittationMother;
    }

    public boolean getU2LimitationProhibitionToEmploy() {
        this.requireLoaded();
        return this.mU2LimitationProhibitionToEmploy;
    }

    public void setU2LimitationProhibitionToEmploy(boolean u2LimitationProhibitionToEmploy) {
        this.mU2LimitationProhibitionToEmploy = u2LimitationProhibitionToEmploy;
    }

    public RefundSIEREnum getU2RefundSocialInsuranceER() {
        this.requireLoaded();
        return this.mU2RefundSocialInsuranceER;
    }

    public void setU2RefundSocialInsuranceER(RefundSIEREnum u2RefundSocialInsuranceER) {
        this.mU2RefundSocialInsuranceER = u2RefundSocialInsuranceER;
    }

    public BigDecimal getU2RefundPercentageFact() {
        this.requireLoaded();
        return this.mU2RefundPercentageFact;
    }

    public void setU2RefundPercentageFact(BigDecimal u2RefundPercentageFact) {
        this.mU2RefundPercentageFact = BigDecimalMapper.toBigDecimal((BigDecimal)u2RefundPercentageFact);
    }

    public BigDecimal getAdditionalDues() {
        this.requireLoaded();
        return this.mAdditionalDues;
    }

    public void setAdditionalDues(BigDecimal additionalDues) {
        this.mAdditionalDues = additionalDues;
    }

    public BigDecimal getAdditionalDuesEE() {
        this.requireLoaded();
        return this.mAdditionalDuesEE;
    }

    public void setAdditionalDuesEE(BigDecimal additionalDuesEE) {
        this.mAdditionalDuesEE = additionalDuesEE;
    }

    public BigDecimal getAdditionalDuesER() {
        this.requireLoaded();
        return this.mAdditionalDuesER;
    }

    public void setAdditionalDuesER(BigDecimal additionalDuesER) {
        this.mAdditionalDuesER = additionalDuesER;
    }

    public Date getAdditionalDuesValidFrom() {
        this.requireLoaded();
        return this.mAdditionalDuesValidFrom;
    }

    public void setAdditionalDuesValidFrom(Date additionalDuesValidFrom) {
        this.mAdditionalDuesValidFrom = additionalDuesValidFrom;
    }

    public String getCreditorId() {
        this.requireLoaded();
        return this.mCreditorId;
    }

    public void setCreditorId(String creditorId) {
        this.mCreditorId = creditorId;
    }

    public boolean getValuateNeededAssessment() {
        return this.mValuateNeededAssessment;
    }

    public void setValuateNeededAssessment(boolean valuateNeededAssessment) {
        this.mValuateNeededAssessment = valuateNeededAssessment;
    }

    public boolean compareToOld(HealthFundTP old) {
        this.mOld = old;
        old.requireLoaded();
        this.mValuateNeededAssessment = false;
        this.mValuateNeeded = !PBigDecimalMapper.isEqual((BigDecimal)old.mContributionForPensionersPercentage, (BigDecimal)this.mContributionForPensionersPercentage) || !PBigDecimalMapper.isEqual((BigDecimal)old.mContributionForPensionersPercentageEE, (BigDecimal)this.mContributionForPensionersPercentageEE) || !PBigDecimalMapper.isEqual((BigDecimal)old.mContributionForPensionersPercentageER, (BigDecimal)this.mContributionForPensionersPercentageER) || !PBigDecimalMapper.isEqual((BigDecimal)old.mPercentageGeneral, (BigDecimal)this.mPercentageGeneral) || !PBigDecimalMapper.isEqual((BigDecimal)old.mPercentageReduced, (BigDecimal)this.mPercentageReduced) || !PBigDecimalMapper.isEqual((BigDecimal)old.mPercentageIncreased, (BigDecimal)this.mPercentageIncreased) || !PBigDecimalMapper.isEqual((BigDecimal)old.mPercentageGeneralEE, (BigDecimal)this.mPercentageGeneralEE) || !PBigDecimalMapper.isEqual((BigDecimal)old.mPercentageReducedEE, (BigDecimal)this.mPercentageReducedEE) || !PBigDecimalMapper.isEqual((BigDecimal)old.mPercentageIncreasedEE, (BigDecimal)this.mPercentageIncreasedEE) || !PBigDecimalMapper.isEqual((BigDecimal)old.mPercentageGeneralER, (BigDecimal)this.mPercentageGeneralER) || !PBigDecimalMapper.isEqual((BigDecimal)old.mPercentageReducedER, (BigDecimal)this.mPercentageReducedER) || !PBigDecimalMapper.isEqual((BigDecimal)old.mPercentageIncreasedER, (BigDecimal)this.mPercentageIncreasedER) || !PBigDecimalMapper.isEqual((BigDecimal)old.mDuesVHIGeneral, (BigDecimal)this.mDuesVHIGeneral) || !PBigDecimalMapper.isEqual((BigDecimal)old.mDuesVHIReduced, (BigDecimal)this.mDuesVHIReduced) || !PBigDecimalMapper.isEqual((BigDecimal)old.mDuesVHIIncreased, (BigDecimal)this.mDuesVHIIncreased) || !PBigDecimalMapper.isEqual((BigDecimal)old.mDuesVHIGeneralGrant, (BigDecimal)this.mDuesVHIGeneralGrant) || !PBigDecimalMapper.isEqual((BigDecimal)old.mDuesVHIReducedGrant, (BigDecimal)this.mDuesVHIReducedGrant) || !PBigDecimalMapper.isEqual((BigDecimal)old.mDuesVHIIncreasedGrant, (BigDecimal)this.mDuesVHIIncreasedGrant) || !PBigDecimalMapper.isEqual((BigDecimal)old.mDuesVNIGeneral, (BigDecimal)this.mDuesVNIGeneral) || !PBigDecimalMapper.isEqual((BigDecimal)old.mVNIableForGrantGen, (BigDecimal)this.mVNIableForGrantGen) || this.compareToOldAssessments(old) || old.mU1Limitation != this.mU1Limitation || old.mU1RefundSocialInsuranceER.value() != this.mU1RefundSocialInsuranceER.value() || !PBigDecimalMapper.isEqual((BigDecimal)old.mU1RefundPercentageFact, (BigDecimal)this.mU1RefundPercentageFact) || old.mU2LimittationMother != this.mU2LimittationMother || old.mU2LimitationProhibitionToEmploy != this.mU2LimitationProhibitionToEmploy || old.mU2RefundSocialInsuranceER.value() != this.mU2RefundSocialInsuranceER.value() || !PBigDecimalMapper.isEqual((BigDecimal)old.mU2RefundPercentageFact, (BigDecimal)this.mU2RefundPercentageFact) || !PBigDecimalMapper.isEqual((BigDecimal)old.mAdditionalDues, (BigDecimal)this.mAdditionalDues) || !PBigDecimalMapper.isEqual((BigDecimal)old.mAdditionalDuesEE, (BigDecimal)this.mAdditionalDuesEE) || !PBigDecimalMapper.isEqual((BigDecimal)old.mAdditionalDuesER, (BigDecimal)this.mAdditionalDuesER) || !DateHelper.equal((Date)old.mAdditionalDuesValidFrom, (Date)this.mAdditionalDuesValidFrom);
        return this.mValuateNeeded;
    }

    private boolean compareToOldAssessments(HealthFundTP old) {
        int count = DateHelper.before((Date)this.mValidUntil, (Date)BEGIN_18_ASSESSMENTS) ? 9 : 18;
        for (int i = 0; i < count; ++i) {
            Assessment first = this.mAssessments[i];
            Assessment second = old.mAssessments[i];
            if (first == second || first == null || !first.compareToOld(second)) continue;
            return true;
        }
        return false;
    }

    public final void makeSaveable() {
        super.makeSaveable();
        for (int i = 0; i < 18; ++i) {
            Assessment a = this.mAssessments[i];
            if (a == null) continue;
            a.makeSaveable();
        }
    }

    public final void makeReadOnly() {
        super.makeReadOnly();
        for (int i = 0; i < 18; ++i) {
            Assessment a = this.mAssessments[i];
            if (a == null) continue;
            a.makeReadOnly();
        }
    }

    public void registerForLastExecute() {
        super.registerForLastExecute();
        for (int i = 0; i < 18; ++i) {
            Assessment a = this.mAssessments[i];
            if (a == null) continue;
            a.registerForLastExecute();
        }
    }

    public boolean assessmentsAvailable() {
        for (int i = 0; i < 18; ++i) {
            Assessment a = this.mAssessments[i];
            if (a == null || a.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void setAssessments(Assessment[] assessments) {
        if (assessments == null) {
            return;
        }
        this.initAssessments();
        for (int i = 0; i < 18; ++i) {
            int sn;
            if (i == assessments.length) {
                return;
            }
            Assessment a = assessments[i];
            if (a == null || (sn = a.getSerialNumber()) < 1 || sn > 18) continue;
            this.mAssessments[sn - 1] = a;
        }
    }

    public List<Difference> differences(HealthFundTP other) {
        return this.differences(other, new ArrayList<Difference>());
    }

    public List<Difference> differences(HealthFundTP other, List<Difference> result) {
        String[] code = this.mHealthFund.getHealthFund().split("\\s[(]\\d{1,}[)]$");
        Difference.diffOne((String)"mHealthFund", (Object)code[0], (Object)other.getHealthFund().getHealthFund(), result);
        Field[] fields = ((Object)((Object)this)).getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Object thisField = this.fieldByReflexion(fields[i], (Object)this);
            Object otherField = this.fieldByReflexion(fields[i], (Object)other);
            String fieldName = fields[i].getName();
            if (thisField == otherField || this.isDifferenceIgnored(fieldName)) continue;
            if (fieldName.equals("mAddress")) {
                Difference.diff((Object)thisField, (Object)otherField, result);
                continue;
            }
            if (fieldName.equals("mAnswerBackEnum")) {
                Difference.diffOne((String)fieldName, (Object)this.mAnswerBackEnum.value(), (Object)other.mAnswerBackEnum.value(), result);
                continue;
            }
            if (fieldName.equals("mTypeOfHealthFundEnum")) {
                Difference.diffOne((String)fieldName, (Object)this.mTypeOfHealthFundEnum.value(), (Object)other.mTypeOfHealthFundEnum.value(), result);
                continue;
            }
            if (fieldName.equals("mAssessments")) {
                for (int j = 0; j < this.mAssessments.length; ++j) {
                    Difference.diffOne((String)fieldName, (Object)Assessment.valueStringOf(this.mAssessments[j]), (Object)Assessment.valueStringOf(other.mAssessments[j]), result);
                }
                continue;
            }
            Difference.diffOne((String)fieldName, (Object)thisField, (Object)otherField, result);
        }
        return result;
    }

    private boolean isDifferenceIgnored(String fieldName) {
        return fieldName.equals("mHealthFund") || fieldName.equals("mOld") || fieldName.equals("mU1Limitation") || fieldName.equals("mU1RefundSocialInsuranceER") || fieldName.equals("mU1RefundPercentageFact") || fieldName.equals("mU2LimittationMother") || fieldName.equals("mU2LimitationProhibitionToEmploy") || fieldName.equals("mU2RefundSocialInsuranceER") || fieldName.equals("mU2RefundPercentageFact");
    }

    private Object fieldByReflexion(Field field, Object obj) {
        try {
            return field.get(obj);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(256);
        b.append(((Object)((Object)this)).getClass().getSimpleName());
        b.append(',').append(DateMapper.toString((Date)this.mValidFrom));
        b.append(',').append(this.mPercentageGeneral);
        b.append(',').append(this.mContributionForPensionersPercentage);
        b.append(',').append((Object)this.mAssessments[0]);
        b.append('}');
        return b.toString();
    }

    public String toStringKey() {
        StringBuffer b = new StringBuffer(256);
        b.append(((Object)((Object)this)).getClass().getSimpleName());
        b.append('{').append(this.mStandardCompanyNumber);
        b.append(',').append(this.mValidFrom);
        b.append('}');
        return b.toString();
    }

    public void fillDues(SocialInsuranceTP si) {
        if (si == null) {
            return;
        }
        DuesHI dh = new DuesHI(si, this.mPercentageGeneral, this.mAdditionalDues);
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPercentageGeneral)) {
            this.mPercentageGeneral = new BigDecimal("0.00");
            this.mPercentageGeneralEE = new BigDecimal("0.00");
            this.mPercentageGeneralER = new BigDecimal("0.00");
        } else {
            dh.setPercentage(this.mPercentageGeneral);
            this.mDuesVHIGeneral = dh.getDuesVHI();
            this.mDuesVHIGeneralGrant = dh.getDuesVHIGrant();
            this.mPercentageGeneralEE = dh.getPercentageEE();
            this.mPercentageGeneralER = dh.getPercentageER();
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPercentageReduced)) {
            this.mPercentageReduced = new BigDecimal("0.00");
            this.mPercentageReducedEE = new BigDecimal("0.00");
            this.mPercentageReducedER = new BigDecimal("0.00");
        } else {
            dh.setPercentage(this.mPercentageReduced);
            this.mDuesVHIReduced = dh.getDuesVHI();
            this.mDuesVHIReducedGrant = dh.getDuesVHIGrant();
            this.mPercentageReducedEE = dh.getPercentageEE();
            this.mPercentageReducedER = dh.getPercentageER();
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPercentageIncreased)) {
            this.mPercentageIncreased = new BigDecimal("0.00");
            this.mPercentageIncreasedEE = new BigDecimal("0.00");
            this.mPercentageIncreasedER = new BigDecimal("0.00");
        } else {
            dh.setPercentage(this.mPercentageIncreased);
            this.mDuesVHIIncreased = dh.getDuesVHI();
            this.mDuesVHIIncreasedGrant = dh.getDuesVHIGrant();
            this.mPercentageIncreasedEE = dh.getPercentageEE();
            this.mPercentageIncreasedER = dh.getPercentageER();
        }
        if (DateHelper.before((Date)si.getValidFrom(), (Date)new VDate(2005, 0, 1).getDate())) {
            this.setDuesVNIGeneral(HealthFund.getVNIableForGrant((SocialInsuranceTP)si));
            this.setVNIableForGrantGen(HealthFund.getVNIableForGrant((SocialInsuranceTP)si));
        } else {
            this.setDuesVNIGeneral(HealthFund.getDuesVNI((SocialInsuranceTP)si));
            this.setVNIableForGrantGen(HealthFund.getVNIableForGrant((SocialInsuranceTP)si));
        }
    }

    public void alertEmployerNumberHealthFund(ExceptionHolder exceptionHolder) {
        if (this.mOld == null || !this.mStandardCompanyNumber.equals(this.mOld.mStandardCompanyNumber)) {
            this.alertEmployerNumberHealthFund(this.mStandardCompanyNumber, exceptionHolder);
        }
        if (StringMapper.isNullString((String)this.mStandardCompanyNumberSuccessor)) {
            return;
        }
        if (this.mOld == null || !this.mStandardCompanyNumberSuccessor.equals(this.mOld.mStandardCompanyNumberSuccessor)) {
            this.alertEmployerNumberHealthFund(this.mStandardCompanyNumberSuccessor, exceptionHolder);
        }
    }

    public void alertEmployerNumberHealthFund(String number, ExceptionHolder exceptionHolder) {
        Criterion filters;
        if (HealthFundTPItsgPersistencyManager.getRowCount((Criterion)this.filters("stdcompanyno", number)) == 0L) {
            exceptionHolder.setException(HealthFundExceptionMapper.makeMissGkvCompanyNumberDomainException());
        }
        if (PlantEmploymentOfficePersistencyManager.getRowCount((Criterion)(filters = this.filters("employernumber", number))) != 0L) {
            exceptionHolder.setException(HealthFundExceptionMapper.makeIsEmployerNumberInPlantDomainException());
        }
        if (CompanyEmploymentOfficePersistencyManager.getRowCount((Criterion)filters) != 0L) {
            exceptionHolder.setException(HealthFundExceptionMapper.makeIsEmployerNumberInCompanyDomainException());
        }
        if (this.getIInsurancePM().getRowCount(this.filters("diffemployernumber", number)) != 0L) {
            exceptionHolder.setException(HealthFundExceptionMapper.makeIsEmployerNumberInEmployeeDomainException());
        }
    }

    private Criterion filters(String field, String value) {
        String effectiveTimePoint = DateMapper.toString((Date)this.mEffectiveFrom);
        String validTimePoint = DateMapper.toString((Date)this.mValidFrom);
        return Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)field, (String)value), Restrictions.le((String)"effectivefrom", (String)effectiveTimePoint), Restrictions.ge((String)"effectiveuntil", (String)effectiveTimePoint), Restrictions.le((String)"validfrom", (String)validTimePoint), Restrictions.ge((String)"validuntil", (String)validTimePoint)});
    }

    public void destroyEmptyAssessments() {
        for (int i = 0; i < this.mAssessments.length; ++i) {
            Assessment a = this.mAssessments[i];
            if (a == null || !a.isEmpty() || !a.isNew()) continue;
            a.makeReadOnly();
        }
    }

    public void fillAssessments(Assessment[] assessments) {
        if (assessments == null) {
            return;
        }
        this.initAssessments();
        for (int i = 0; i < 18; ++i) {
            if (i == assessments.length) {
                return;
            }
            Assessment a = assessments[i];
            if (a == null) continue;
            if (this.mAssessments[i] == null) {
                this.mAssessments[i] = new Assessment(this);
            }
            this.mAssessments[i].setSerialNumber(a.getSerialNumber());
            this.mAssessments[i].setRefundPercentage(a.getRefundPercentage());
            this.mAssessments[i].setSubmitPercentage(a.getSubmitPercentage());
        }
    }

    public boolean isUnused() {
        this.requireLoaded();
        String max = VDate.getDateMaxAsString();
        String oidHealthFund = this.mHealthFund.getObjectid();
        return DEUVRecipientTPPersistencyManager.getRowCount((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidhealthfund", (String)oidHealthFund), Restrictions.eq((String)"effectiveuntil", (String)max), Restrictions.eq((String)"validuntil", (String)max)})) == 0L;
    }

    public Assessment[] getAssessmentsU1() {
        int i;
        Assessment[] assessments = new Assessment[6];
        int j = 0;
        for (i = 0; i < 3; ++i) {
            assessments[j++] = this.mAssessments[i];
        }
        if (j > this.mAssessments.length) {
            return assessments;
        }
        for (i = 9; i < 12; ++i) {
            assessments[j++] = this.mAssessments[i];
        }
        return assessments;
    }

    public Assessment[] getAssessmentsU2() {
        int i;
        Assessment[] assessments = new Assessment[6];
        int j = 0;
        for (i = 3; i < 6; ++i) {
            assessments[j++] = this.mAssessments[i];
        }
        if (j > this.mAssessments.length) {
            return assessments;
        }
        for (i = 13; i < 15; ++i) {
            assessments[j++] = this.mAssessments[i];
        }
        return assessments;
    }

    @Override
    public String getRootDomainKey() {
        return this.getHealthFund().getDomainKey();
    }

    @Override
    public String getNaturalLanguageClassName() {
        return "Krankenkasse";
    }

    public boolean isFusionReminder(HealthFundTP old) {
        return this.hasSuccessor() && old != null && !old.hasSuccessor();
    }

    public boolean hasSuccessor() {
        this.requireLoaded();
        return !StringMapper.isNullString((String)this.mStandardCompanyNumberSuccessor) && this.mStandardCompanyNumberValidUntil != null;
    }

    public void createFusionReminder() {
        TaskReminder reminder = new TaskReminder();
        User user = userPersistencyManager.query(SessionContext.getInstance().getSession().getUserCode());
        reminder.setCreator(user);
        TaskFolder todoFolder = TaskFolderPersistencyManager.getTodoFolder((String)user.getObjectid());
        reminder.setCreatorFolder(todoFolder);
        reminder.setRecipient(user);
        reminder.setRecipientFolder(todoFolder);
        String name = "Krankenkassenfusion, neue Betriebsnummer verwenden";
        reminder.setName("Krankenkassenfusion, neue Betriebsnummer verwenden");
        String message = "Die Krankenkasse " + this.mShortDescription + " geht in einer Fusion auf. \r\n\r\nStatt der Betriebsnummer " + this.mStandardCompanyNumber + " soll nach dem " + DateMapper.toDDMMYYYYPointSeparationString((Date)this.mStandardCompanyNumberValidUntil) + " die Betriebsnummer " + this.mStandardCompanyNumberSuccessor + " verwendet werden. \r\n\r\n\u00dcberpr\u00fcfen Sie bitte ebenfalls die Umlageprozents\u00e4tze und passen Sie diese ggf. an.";
        reminder.setNote(StringMapper.maxLength((String)message, (int)253));
        reminder.setIsDone(false);
        reminder.setRecurringTask(null);
        reminder.setTaskType(TaskReminderType.SINGLE);
        reminder.setDueDate(this.mStandardCompanyNumberValidUntil);
        reminder.setEntryDate(DateHelper.today());
        if (user.getTRgeneratingForDeputizing()) {
            List deputizings = userPersistencyManager.getDeputizings(user);
            for (User each : deputizings) {
                reminder = new TaskReminder();
                reminder.setCreator(each);
                todoFolder = TaskFolderPersistencyManager.getTodoFolder((String)each.getObjectid());
                reminder.setCreatorFolder(todoFolder);
                reminder.setRecipient(each);
                reminder.setRecipientFolder(todoFolder);
                reminder.setName("Krankenkassenfusion, neue Betriebsnummer verwenden");
                reminder.setNote(StringMapper.maxLength((String)message, (int)253));
                reminder.setIsDone(false);
                reminder.setRecurringTask(null);
                reminder.setTaskType(TaskReminderType.SINGLE);
                reminder.setDueDate(this.mStandardCompanyNumberValidUntil);
                reminder.setEntryDate(DateHelper.today());
            }
        }
    }

    private IInsurancePersistencyManager getIInsurancePM() {
        return (IInsurancePersistencyManager)UtilitiesManager.getBean((String)"insurancePersistencyManager", IInsurancePersistencyManager.class);
    }
}

