/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.datacredit.EEDataCreditTP;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.global.creditmodel.TypeOfCreditEnum;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class SteuerungWGHFormula {
    private static final BigDecimal ZWEI = BigDecimal.valueOf(2L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private final CalculationLibrary callib;
    private final EmployeeLibrary eelib;
    private final GlobalLibrary gllib;
    private final ValuePositionLibrary wplib;
    private ValuePosition[] vpArray;
    private BigDecimal stunden = BigDecimal.ZERO;
    private BigDecimal betrag = BigDecimal.ZERO;
    private boolean kzStunden;
    private int mVTNumberWGHWest;
    private int mVTNumberWGHOst;
    private int mVTNumberWGHAbgangOst;
    private int mVTNumberWGHAbgangWest = 0;
    private BigDecimal mStoerfallBruttoRV = BigDecimal.ZERO;
    private BigDecimal mStoerfallBruttoKV = BigDecimal.ZERO;
    private BigDecimal mStoerfallBruttoAV = BigDecimal.ZERO;
    private BigDecimal mStoerfallBruttoPV = BigDecimal.ZERO;

    public SteuerungWGHFormula(CalculationLibrary calculationLibrary, EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, ValuePositionLibrary valuePositionLibrary) throws BusinessDomainException {
        this.callib = calculationLibrary;
        this.eelib = employeeLibrary;
        this.gllib = globalLibrary;
        this.wplib = valuePositionLibrary;
    }

    public void steuerung() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2009, 0, 1).getDate())) {
            switch (this.wplib.wertartenNummer()) {
                case 801140: 
                case 801145: 
                case 801180: 
                case 801185: 
                case 801410: 
                case 802140: 
                case 802180: 
                case 803140: 
                case 803180: 
                case 804140: 
                case 804180: 
                case 805140: 
                case 805180: 
                case 806140: 
                case 806180: 
                case 807140: 
                case 807180: {
                    this.holeVormonatsWertAb2009();
                    break;
                }
                case 801142: 
                case 801182: {
                    this.uebertragAltwertguthaben();
                    break;
                }
                case 801310: 
                case 802250: 
                case 803250: 
                case 804250: 
                case 805250: 
                case 806250: 
                case 807250: {
                    this.bewegungWertguthabenAufbau();
                    this.wplib.wertPosition().makeReadOnly();
                    break;
                }
                case 801320: 
                case 802260: 
                case 803260: 
                case 804260: 
                case 805260: 
                case 806260: 
                case 807260: {
                    if (!BigDecimalMapper.isZero((BigDecimal)this.wplib.factor1())) {
                        this.kzStunden = true;
                    }
                    this.bewegungWertguthabenAbbau();
                    this.wplib.wertPosition().makeReadOnly();
                    break;
                }
                case 801420: {
                    this.ermittleKvAga();
                    break;
                }
                case 801430: {
                    this.ermittleRvAga();
                    break;
                }
                case 801440: {
                    this.ermittleAvAga();
                    break;
                }
                case 801450: {
                    this.ermittlePvAga();
                    break;
                }
            }
        } else {
            if (this.eelib.marbPgs() == 103) {
                if (this.eelib.marbAtzModellArt().value() == 0) {
                    this.wplib.wertPosition().makeReadOnly();
                    return;
                }
            } else if (this.eelib.marbWertguthaben(TypeOfCreditEnum.TOCBE_SV_PFLICHTIG) == null) {
                this.wplib.wertPosition().makeReadOnly();
                return;
            }
            switch (this.wplib.wertartenNummer()) {
                case 801140: 
                case 801180: {
                    this.holeVormonatsWert();
                    break;
                }
                case 801310: 
                case 801320: {
                    this.bewegungWertguthaben();
                    break;
                }
                case 801230: 
                case 801270: {
                    this.callib.factor1(this.wplib.genesisParentWPFaktor1());
                    this.callib.result(this.wplib.genesisParentWPErgebnis());
                    break;
                }
            }
        }
    }

    private void uebertragAltwertguthaben() throws BusinessDomainException {
        this.vpArray = this.wplib.wertartenNummer() == 801142 ? this.wplib.wpAusWPListeBisUebergebeneWP(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.wplib.wertPosition(), ValueTypeHelper.getValueTypes((int[])new int[]{801140})) : this.wplib.wpAusWPListeBisUebergebeneWP(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.wplib.wertPosition(), ValueTypeHelper.getValueTypes((int[])new int[]{801180}));
        BigDecimal altwertguthaben = BigDecimal.ZERO;
        for (ValuePosition vPos : this.vpArray) {
            altwertguthaben = altwertguthaben.add(vPos.getResult());
        }
        if (altwertguthaben.compareTo(BigDecimal.ZERO) != 0) {
            this.callib.result(this.callib.result().add(altwertguthaben.negate()));
            if (this.wplib.wertartenNummer() == 801142) {
                this.wplib.addNeueWertPosition(801210, altwertguthaben);
            } else {
                this.wplib.addNeueWertPosition(801250, altwertguthaben);
            }
        } else {
            this.wplib.wertPosition().makeReadOnly();
        }
    }

    private void ermittlePvAga() throws BusinessDomainException {
        BigDecimal pvBeitragssatz = this.ermittlePvAgBeitragssatz();
        BigDecimal wgh = BigDecimal.ZERO;
        this.wertguthabenVeraenderung();
        block4: for (ValuePosition vPos : this.vpArray) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 801210: 
                case 801250: {
                    wgh = wgh.add(vPos.getResult());
                    continue block4;
                }
                case 801220: 
                case 801260: {
                    wgh = !this.stoerfallAbbauPV(vPos) ? wgh.add(vPos.getResult()) : wgh.add(this.mStoerfallBruttoPV.negate());
                }
            }
        }
        if (wgh.compareTo(BigDecimal.ZERO) == 0) {
            this.wplib.wertPosition().makeReadOnly();
        } else {
            this.callib.result(wgh.multiply(pvBeitragssatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
            this.callib.percentage(pvBeitragssatz);
            this.callib.factor1(wgh);
        }
    }

    private boolean stoerfallAbbauPV(ValuePosition vp) throws BusinessDomainException {
        ValuePosition[] tempVPArray;
        boolean result = false;
        block4: for (ValuePosition valuePosition : tempVPArray = this.wplib.parentUndFolgen(vp)) {
            switch (valuePosition.getValueType().getValueTypeKey()) {
                case 130750: {
                    result = true;
                    continue block4;
                }
                case 339730: {
                    this.mStoerfallBruttoPV = this.mStoerfallBruttoPV.add(valuePosition.getResult());
                }
            }
        }
        return result;
    }

    private BigDecimal ermittlePvAgBeitragssatz() throws BusinessDomainException {
        BigDecimal pv_beitragssatz_ag = BigDecimal.ZERO;
        pv_beitragssatz_ag = this.gllib.bundeslandSchluesselBeschaeftigungsort() != 15 ? pv_beitragssatz_ag.add(this.gllib.svBsGesamtPV().divide(ZWEI, 4, RoundingMode.HALF_UP)) : pv_beitragssatz_ag.add(this.gllib.bulaPvAga());
        return pv_beitragssatz_ag;
    }

    private void ermittleAvAga() throws BusinessDomainException {
        BigDecimal avBeitragssatz = this.ermittleAvAgBeitragssatz();
        BigDecimal wgh = BigDecimal.ZERO;
        this.wertguthabenVeraenderung();
        block4: for (ValuePosition vPos : this.vpArray) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 801210: 
                case 801250: {
                    wgh = wgh.add(vPos.getResult());
                    continue block4;
                }
                case 801220: 
                case 801260: {
                    wgh = !this.stoerfallAbbauAV(vPos) ? wgh.add(vPos.getResult()) : wgh.add(this.mStoerfallBruttoAV.negate());
                }
            }
        }
        if (wgh.compareTo(BigDecimal.ZERO) == 0) {
            this.wplib.wertPosition().makeReadOnly();
        } else {
            this.callib.result(wgh.multiply(avBeitragssatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
            this.callib.percentage(avBeitragssatz);
            this.callib.factor1(wgh);
        }
    }

    private boolean stoerfallAbbauAV(ValuePosition vp) throws BusinessDomainException {
        ValuePosition[] tempVPArray;
        boolean result = false;
        block4: for (ValuePosition valuePosition : tempVPArray = this.wplib.parentUndFolgen(vp)) {
            switch (valuePosition.getValueType().getValueTypeKey()) {
                case 130750: {
                    result = true;
                    continue block4;
                }
                case 333730: {
                    this.mStoerfallBruttoAV = this.mStoerfallBruttoAV.add(valuePosition.getResult());
                }
            }
        }
        return result;
    }

    private BigDecimal ermittleAvAgBeitragssatz() throws BusinessDomainException {
        BigDecimal beitragssatz_aga = this.gllib.svBsGesamtAv().divide(ZWEI, 2, RoundingMode.HALF_UP);
        return beitragssatz_aga;
    }

    private void ermittleRvAga() throws BusinessDomainException {
        BigDecimal rvBeitragssatz = this.ermittleRvAgBeitragssatz();
        BigDecimal wgh = BigDecimal.ZERO;
        this.wertguthabenVeraenderung();
        block4: for (ValuePosition vPos : this.vpArray) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 801210: 
                case 801250: {
                    wgh = wgh.add(vPos.getResult());
                    continue block4;
                }
                case 801220: 
                case 801260: {
                    wgh = !this.stoerfallAbbauRV(vPos) ? wgh.add(vPos.getResult()) : wgh.add(this.mStoerfallBruttoRV.negate());
                }
            }
        }
        if (wgh.compareTo(BigDecimal.ZERO) == 0) {
            this.wplib.wertPosition().makeReadOnly();
        } else {
            this.callib.result(wgh.multiply(rvBeitragssatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
            this.callib.percentage(rvBeitragssatz);
            this.callib.factor1(wgh);
        }
    }

    private void wertguthabenVeraenderung() throws BusinessDomainException {
        this.vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{801220, 801210, 801260, 801250}));
    }

    private BigDecimal ermittleRvAgBeitragssatz() throws BusinessDomainException {
        BigDecimal beitragssatz_aga = BigDecimal.ZERO;
        switch (this.gllib.krkTyp()) {
            case 6: {
                if (this.eelib.marbErhBeitrErmKnappschRV()) {
                    BigDecimal beitragssatz_ana = this.gllib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP);
                    beitragssatz_aga = this.gllib.svBsKnappschaftGesamt().subtract(beitragssatz_ana);
                    break;
                }
            }
            default: {
                beitragssatz_aga = this.gllib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP);
            }
        }
        return beitragssatz_aga;
    }

    private boolean stoerfallAbbauRV(ValuePosition vp) throws BusinessDomainException {
        ValuePosition[] tempVPArray;
        boolean result = false;
        block4: for (ValuePosition valuePosition : tempVPArray = this.wplib.parentUndFolgen(vp)) {
            switch (valuePosition.getValueType().getValueTypeKey()) {
                case 130750: {
                    result = true;
                    continue block4;
                }
                case 327730: {
                    this.mStoerfallBruttoRV = this.mStoerfallBruttoRV.add(valuePosition.getResult());
                }
            }
        }
        return result;
    }

    private void ermittleKvAga() throws BusinessDomainException {
        BigDecimal kvBeitragssatz = this.ermittleKvAgBeitragssatz();
        BigDecimal wgh = BigDecimal.ZERO;
        this.wertguthabenVeraenderung();
        block4: for (ValuePosition vPos : this.vpArray) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 801210: 
                case 801250: {
                    wgh = wgh.add(vPos.getResult());
                    continue block4;
                }
                case 801220: 
                case 801260: {
                    wgh = !this.stoerfallAbbauKV(vPos) ? wgh.add(vPos.getResult()) : wgh.add(this.mStoerfallBruttoKV.negate());
                }
            }
        }
        if (wgh.compareTo(BigDecimal.ZERO) == 0) {
            this.wplib.wertPosition().makeReadOnly();
        } else {
            this.callib.result(wgh.multiply(kvBeitragssatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
            this.callib.percentage(kvBeitragssatz);
            this.callib.factor1(wgh);
        }
    }

    private boolean stoerfallAbbauKV(ValuePosition vp) throws BusinessDomainException {
        ValuePosition[] tempVPArray;
        boolean result = false;
        block4: for (ValuePosition valuePosition : tempVPArray = this.wplib.parentUndFolgen(vp)) {
            switch (valuePosition.getValueType().getValueTypeKey()) {
                case 130750: {
                    result = true;
                    continue block4;
                }
                case 321730: {
                    this.mStoerfallBruttoKV = this.mStoerfallBruttoKV.add(valuePosition.getResult());
                }
            }
        }
        return result;
    }

    private BigDecimal ermittleKvAgBeitragssatz() throws BusinessDomainException {
        BigDecimal kvBeitragssatz = BigDecimal.ZERO;
        switch (this.eelib.marbBgrKv()) {
            case 1: {
                kvBeitragssatz = this.gllib.krkBsAllgemein();
                break;
            }
            case 2: {
                throw EvaluationExceptionMapper.makeIncreaseDuesGroupHIAfter2008NotAllowedDomainException();
            }
            case 3: {
                kvBeitragssatz = this.gllib.krkBsErmaessigt();
                break;
            }
            case 5: {
                kvBeitragssatz = this.gllib.svBsDurchschnittlich();
                break;
            }
        }
        kvBeitragssatz = kvBeitragssatz.multiply(BigDecimal.valueOf(50L, 2).setScale(2, RoundingMode.HALF_UP));
        if (DateHelper.afterOrEqual((Date)this.wplib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
            kvBeitragssatz = kvBeitragssatz.add(this.eelib.marbKrkAgaBsZusatzbeitrag());
        }
        return kvBeitragssatz;
    }

    private void bewegungWertguthabenAbbau() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2009, 0, 1).getDate())) {
            switch (this.wplib.wertartenNummer()) {
                case 801320: {
                    this.bewegungWertguthabenAbbauSvPfl();
                    return;
                }
            }
        }
        Date letzterTagVM = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()));
        BigDecimal lWGHAbbau = BigDecimal.ZERO;
        BigDecimal lWGHWest = BigDecimal.ZERO;
        BigDecimal lWGHOst = BigDecimal.ZERO;
        lWGHAbbau = this.kzStunden ? this.wplib.factor1() : this.wplib.result();
        this.fuelleWertartenNrFuerWghArt();
        for (ValuePosition vp : this.vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), DateHelper.getFirstDayOfMonth((Date)letzterTagVM), letzterTagVM, ValueTypeHelper.getValueTypes((int[])new int[]{this.mVTNumberWGHWest, this.mVTNumberWGHOst}))) {
            if (vp.getValueType().getValueTypeKey() == this.mVTNumberWGHWest) {
                if (this.kzStunden) {
                    lWGHWest = lWGHWest.add(vp.getFactor1());
                    continue;
                }
                lWGHWest = lWGHWest.add(vp.getResult());
                continue;
            }
            if (vp.getValueType().getValueTypeKey() == this.mVTNumberWGHOst) {
                if (this.kzStunden) {
                    lWGHOst = lWGHOst.add(vp.getFactor1());
                    continue;
                }
                lWGHOst = lWGHOst.add(vp.getResult());
                continue;
            }
            throw EvaluationExceptionMapper.makeWrongValueTypeDomaineException(this.getClass().getName(), vp.getValueType().getValueTypeKey());
        }
        switch (this.gllib.marbRechtskreis()) {
            case 'W': 
            case 'w': {
                BigDecimal diff;
                if (lWGHOst.compareTo(BigDecimal.ZERO) > 0) {
                    if (lWGHOst.compareTo(lWGHAbbau) > 0) {
                        if (this.kzStunden) {
                            this.wplib.addNeueWertPositionMitGleichemParent(this.mVTNumberWGHAbgangOst, BigDecimal.ZERO, BigDecimal.ZERO, lWGHAbbau.negate(), BigDecimal.ZERO, BigDecimal.ZERO, false);
                            break;
                        }
                        this.wplib.addNeueWertPositionMitGleichemParent(this.mVTNumberWGHAbgangOst, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, lWGHAbbau.negate(), false);
                        break;
                    }
                    diff = lWGHAbbau.subtract(lWGHWest);
                    if (this.kzStunden) {
                        this.wplib.addNeueWertPositionMitGleichemParent(this.mVTNumberWGHAbgangOst, BigDecimal.ZERO, BigDecimal.ZERO, lWGHWest.negate(), BigDecimal.ZERO, BigDecimal.ZERO, false);
                        this.wplib.addNeueWertPositionMitGleichemParent(this.mVTNumberWGHAbgangWest, BigDecimal.ZERO, BigDecimal.ZERO, diff.negate(), BigDecimal.ZERO, BigDecimal.ZERO, false);
                        break;
                    }
                    this.wplib.addNeueWertPositionMitGleichemParent(this.mVTNumberWGHAbgangOst, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, lWGHWest.negate(), false);
                    this.wplib.addNeueWertPositionMitGleichemParent(this.mVTNumberWGHAbgangWest, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, diff.negate(), false);
                    break;
                }
                if (this.kzStunden) {
                    this.wplib.addNeueWertPositionMitGleichemParent(this.mVTNumberWGHAbgangWest, BigDecimal.ZERO, BigDecimal.ZERO, lWGHAbbau.negate(), BigDecimal.ZERO, BigDecimal.ZERO, false);
                    break;
                }
                this.wplib.addNeueWertPositionMitGleichemParent(this.mVTNumberWGHAbgangWest, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, lWGHAbbau.negate(), false);
                break;
            }
            default: {
                BigDecimal diff;
                if (lWGHWest.compareTo(BigDecimal.ZERO) > 0) {
                    if (lWGHWest.compareTo(lWGHAbbau) > 0) {
                        if (this.kzStunden) {
                            this.wplib.addNeueWertPositionMitGleichemParent(this.mVTNumberWGHAbgangWest, BigDecimal.ZERO, BigDecimal.ZERO, lWGHAbbau.negate(), BigDecimal.ZERO, BigDecimal.ZERO, false);
                            break;
                        }
                        this.wplib.addNeueWertPositionMitGleichemParent(this.mVTNumberWGHAbgangWest, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, lWGHAbbau.negate(), false);
                        break;
                    }
                    diff = lWGHAbbau.subtract(lWGHWest);
                    if (this.kzStunden) {
                        this.wplib.addNeueWertPositionMitGleichemParent(this.mVTNumberWGHAbgangWest, BigDecimal.ZERO, BigDecimal.ZERO, lWGHWest.negate(), BigDecimal.ZERO, BigDecimal.ZERO, false);
                        this.wplib.addNeueWertPositionMitGleichemParent(this.mVTNumberWGHAbgangOst, BigDecimal.ZERO, BigDecimal.ZERO, diff.negate(), BigDecimal.ZERO, BigDecimal.ZERO, false);
                        break;
                    }
                    this.wplib.addNeueWertPositionMitGleichemParent(this.mVTNumberWGHAbgangWest, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, lWGHWest.negate(), false);
                    this.wplib.addNeueWertPositionMitGleichemParent(this.mVTNumberWGHAbgangOst, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, diff.negate(), false);
                    break;
                }
                if (this.kzStunden) {
                    this.wplib.addNeueWertPositionMitGleichemParent(this.mVTNumberWGHAbgangOst, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1().negate(), BigDecimal.ZERO, BigDecimal.ZERO, false);
                    break;
                }
                this.wplib.addNeueWertPositionMitGleichemParent(this.mVTNumberWGHAbgangOst, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result().negate(), false);
            }
        }
    }

    private void bewegungWertguthabenAbbauSvPfl() throws BusinessDomainException {
        Date letzterTagVM = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()));
        BigDecimal lWGHAbbau = BigDecimal.ZERO;
        BigDecimal lWGHWestNeu = BigDecimal.ZERO;
        BigDecimal lWGHWest = BigDecimal.ZERO;
        BigDecimal lWGHOstNeu = BigDecimal.ZERO;
        BigDecimal lWGHOst = BigDecimal.ZERO;
        lWGHAbbau = this.kzStunden ? this.wplib.factor1() : this.wplib.result();
        this.vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{801140, 801142, 801145, 801180, 801182, 801185, 801210, 801220, 801225, 801230, 801250, 801260, 801265, 801270}));
        if (this.vpArray.length != 0) {
            block12: for (ValuePosition vp : this.vpArray) {
                BigDecimal wert = this.kzStunden ? vp.getFactor1() : vp.getResult();
                switch (vp.getValueType().getValueTypeKey()) {
                    case 801225: {
                        wert = wert.negate();
                    }
                    case 801140: 
                    case 801142: 
                    case 801230: {
                        lWGHWest = lWGHWest.add(wert);
                        continue block12;
                    }
                    case 801220: {
                        wert = wert.negate();
                    }
                    case 801145: 
                    case 801210: {
                        lWGHWestNeu = lWGHWestNeu.add(wert);
                        continue block12;
                    }
                    case 801180: 
                    case 801182: 
                    case 801270: {
                        lWGHOst = lWGHOst.add(wert);
                        continue block12;
                    }
                    case 801260: 
                    case 801265: {
                        wert = wert.negate();
                    }
                    case 801185: 
                    case 801250: {
                        lWGHOstNeu = lWGHOstNeu.add(wert);
                        continue block12;
                    }
                    default: {
                        throw EvaluationExceptionMapper.makeWrongValueTypeDomaineException(this.getClass().getName(), vp.getValueType().getValueTypeKey());
                    }
                }
            }
        } else if (DateHelper.between((Date)this.gllib.firmaBerechnungsStart(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            EEDataCreditTP eeDataCreditTP = this.eelib.marbWertguthaben(TypeOfCreditEnum.TOCBE_SV_PFLICHTIG);
            if (this.kzStunden) {
                lWGHOst = eeDataCreditTP.getHoursCarriedForwardEast();
                lWGHWest = eeDataCreditTP.getHoursCarriedForwardWest();
            } else {
                lWGHOst = eeDataCreditTP.getAmountCarriedForwardEast();
                lWGHOstNeu = eeDataCreditTP.getAmountCarriedForwardEastNew();
                lWGHWest = eeDataCreditTP.getAmountCarriedForwardWest();
                lWGHWestNeu = eeDataCreditTP.getAmountCarriedForwardWestNew();
            }
        }
        BigDecimal lAbbauAltOst = BigDecimal.ZERO;
        BigDecimal lAbbauAltWest = BigDecimal.ZERO;
        BigDecimal lAbbauNeuOst = BigDecimal.ZERO;
        BigDecimal lAbbauNeuWest = BigDecimal.ZERO;
        switch (this.gllib.marbRechtskreis()) {
            case 'W': 
            case 'w': {
                if (lWGHOst.compareTo(lWGHAbbau) >= 0) {
                    lAbbauAltOst = lWGHAbbau;
                    break;
                }
                lAbbauAltOst = lWGHOst;
                if (lWGHWest.compareTo(lWGHAbbau = lWGHAbbau.subtract(lWGHOst)) >= 0) {
                    lAbbauAltWest = lWGHAbbau;
                    break;
                }
                lAbbauAltWest = lWGHWest;
                if (lWGHOstNeu.compareTo(lWGHAbbau = lWGHAbbau.subtract(lWGHWest)) >= 0) {
                    lAbbauNeuOst = lWGHAbbau;
                    break;
                }
                lAbbauNeuOst = lWGHOstNeu;
                if (lWGHWestNeu.compareTo(lWGHAbbau = lWGHAbbau.subtract(lWGHOstNeu)) >= 0) {
                    lAbbauNeuWest = lWGHAbbau;
                    break;
                }
                lAbbauNeuWest = lWGHWestNeu;
                break;
            }
            default: {
                if (lWGHWest.compareTo(lWGHAbbau) >= 0) {
                    lAbbauAltWest = lWGHAbbau;
                    break;
                }
                lAbbauAltWest = lWGHWest;
                if (lWGHOst.compareTo(lWGHAbbau = lWGHAbbau.subtract(lWGHWest)) >= 0) {
                    lAbbauAltOst = lWGHAbbau;
                    break;
                }
                lAbbauAltOst = lWGHOst;
                if (lWGHWestNeu.compareTo(lWGHAbbau = lWGHAbbau.subtract(lWGHOst)) >= 0) {
                    lAbbauNeuWest = lWGHAbbau;
                    break;
                }
                lAbbauNeuWest = lWGHWestNeu;
                lAbbauNeuOst = lWGHOstNeu.compareTo(lWGHAbbau = lWGHAbbau.subtract(lWGHWestNeu)) >= 0 ? lWGHAbbau : lWGHOstNeu;
            }
        }
        if (lAbbauAltOst.compareTo(BigDecimal.ZERO) > 0) {
            if (this.kzStunden) {
                this.wplib.addNeueWertPositionMitGleichemParent(801265, BigDecimal.ZERO, BigDecimal.ZERO, lAbbauAltOst.negate(), BigDecimal.ZERO, BigDecimal.ZERO, false);
            } else {
                this.wplib.addNeueWertPositionMitGleichemParent(801265, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, lAbbauAltOst.negate(), false);
            }
        }
        if (lAbbauAltWest.compareTo(BigDecimal.ZERO) > 0) {
            if (this.kzStunden) {
                this.wplib.addNeueWertPositionMitGleichemParent(801225, BigDecimal.ZERO, BigDecimal.ZERO, lAbbauAltWest.negate(), BigDecimal.ZERO, BigDecimal.ZERO, false);
            } else {
                this.wplib.addNeueWertPositionMitGleichemParent(801225, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, lAbbauAltWest.negate(), false);
            }
        }
        if (lAbbauNeuOst.compareTo(BigDecimal.ZERO) > 0) {
            if (this.kzStunden) {
                this.wplib.addNeueWertPositionMitGleichemParent(801260, BigDecimal.ZERO, BigDecimal.ZERO, lAbbauNeuOst.negate(), BigDecimal.ZERO, BigDecimal.ZERO, false);
            } else {
                this.wplib.addNeueWertPositionMitGleichemParent(801260, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, lAbbauNeuOst.negate(), false);
            }
        }
        if (lAbbauNeuWest.compareTo(BigDecimal.ZERO) > 0) {
            if (this.kzStunden) {
                this.wplib.addNeueWertPositionMitGleichemParent(801220, BigDecimal.ZERO, BigDecimal.ZERO, lAbbauNeuWest.negate(), BigDecimal.ZERO, BigDecimal.ZERO, false);
            } else {
                this.wplib.addNeueWertPositionMitGleichemParent(801220, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, lAbbauNeuWest.negate(), false);
            }
        }
        if (lAbbauNeuOst.add(lAbbauNeuWest).compareTo(BigDecimal.ZERO) > 0 && !this.kzStunden) {
            this.erzeugeAgaWertarten(lAbbauNeuOst.add(lAbbauNeuWest).negate());
        }
    }

    private void fuelleWertartenNrFuerWghArt() throws BusinessDomainException {
        switch (this.wplib.wertartenNummer()) {
            case 801320: {
                this.mVTNumberWGHWest = 801010;
                this.mVTNumberWGHOst = 801020;
                this.mVTNumberWGHAbgangWest = 801220;
                this.mVTNumberWGHAbgangOst = 801260;
                break;
            }
            case 802260: {
                this.mVTNumberWGHWest = 802010;
                this.mVTNumberWGHOst = 802020;
                this.mVTNumberWGHAbgangWest = 802220;
                this.mVTNumberWGHAbgangOst = 802240;
                break;
            }
            case 803260: {
                this.mVTNumberWGHWest = 803010;
                this.mVTNumberWGHOst = 803020;
                this.mVTNumberWGHAbgangWest = 803220;
                this.mVTNumberWGHAbgangOst = 803240;
                break;
            }
            case 804260: {
                this.mVTNumberWGHWest = 804010;
                this.mVTNumberWGHOst = 804020;
                this.mVTNumberWGHAbgangWest = 804220;
                this.mVTNumberWGHAbgangOst = 804240;
                break;
            }
            case 805260: {
                this.mVTNumberWGHWest = 805010;
                this.mVTNumberWGHOst = 805020;
                this.mVTNumberWGHAbgangWest = 805220;
                this.mVTNumberWGHAbgangOst = 805240;
                break;
            }
            case 806260: {
                this.mVTNumberWGHWest = 806010;
                this.mVTNumberWGHOst = 806020;
                this.mVTNumberWGHAbgangWest = 806220;
                this.mVTNumberWGHAbgangOst = 806240;
                break;
            }
            case 807260: {
                this.mVTNumberWGHWest = 807010;
                this.mVTNumberWGHOst = 807020;
                this.mVTNumberWGHAbgangWest = 807220;
                this.mVTNumberWGHAbgangOst = 807240;
                break;
            }
            default: {
                throw EvaluationExceptionMapper.makeWrongValueTypeDomaineException(this.getClass().getName(), this.wplib.wertartenNummer());
            }
        }
    }

    private void bewegungWertguthabenAufbau() throws BusinessDomainException {
        block0 : switch (this.gllib.marbRechtskreis()) {
            case 'W': 
            case 'w': {
                switch (this.wplib.wertartenNummer()) {
                    case 801310: {
                        this.wplib.addNeueWertPositionMitGleichemParent(801210, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1(), BigDecimal.ZERO, this.wplib.result(), false);
                        if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2009, 0, 1).getDate())) break block0;
                        this.erzeugeAgaWertarten(this.wplib.result());
                        break;
                    }
                    case 802250: {
                        this.wplib.addNeueWertPosition(802210, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1(), BigDecimal.ZERO, this.wplib.result(), false);
                        break;
                    }
                    case 803250: {
                        this.wplib.addNeueWertPosition(803210, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1(), BigDecimal.ZERO, this.wplib.result(), false);
                        break;
                    }
                    case 804250: {
                        this.wplib.addNeueWertPosition(804210, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1(), BigDecimal.ZERO, this.wplib.result(), false);
                        break;
                    }
                    case 805250: {
                        this.wplib.addNeueWertPosition(805210, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1(), BigDecimal.ZERO, this.wplib.result(), false);
                        break;
                    }
                    case 806250: {
                        this.wplib.addNeueWertPosition(806210, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1(), BigDecimal.ZERO, this.wplib.result(), false);
                        break;
                    }
                    case 807250: {
                        this.wplib.addNeueWertPosition(807210, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1(), BigDecimal.ZERO, this.wplib.result(), false);
                        break;
                    }
                }
                break;
            }
            default: {
                switch (this.wplib.wertartenNummer()) {
                    case 801310: {
                        this.wplib.addNeueWertPositionMitGleichemParent(801250, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1(), BigDecimal.ZERO, this.wplib.result(), false);
                        if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2009, 0, 1).getDate())) break block0;
                        this.erzeugeAgaWertarten(this.wplib.result());
                        break block0;
                    }
                    case 802250: {
                        this.wplib.addNeueWertPosition(802230, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1(), BigDecimal.ZERO, this.wplib.result(), false);
                        break block0;
                    }
                    case 803250: {
                        this.wplib.addNeueWertPosition(803230, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1(), BigDecimal.ZERO, this.wplib.result(), false);
                        break block0;
                    }
                    case 804250: {
                        this.wplib.addNeueWertPosition(804230, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1(), BigDecimal.ZERO, this.wplib.result(), false);
                        break block0;
                    }
                    case 805250: {
                        this.wplib.addNeueWertPosition(805230, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1(), BigDecimal.ZERO, this.wplib.result(), false);
                        break block0;
                    }
                    case 806250: {
                        this.wplib.addNeueWertPosition(806230, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1(), BigDecimal.ZERO, this.wplib.result(), false);
                        break block0;
                    }
                    case 807250: {
                        this.wplib.addNeueWertPosition(807230, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1(), BigDecimal.ZERO, this.wplib.result(), false);
                        break block0;
                    }
                }
            }
        }
    }

    private void holeVormonatsWertAb2009() throws BusinessDomainException {
        if (DateHelper.equal((Date)this.eelib.marbJournalisiertBis(), (Date)new VDate(2008, 11, 31).getDate()) || DateHelper.between((Date)this.eelib.marbEintritt(), (Date)this.callib.berchnungGueltigAb(), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb())) || DateHelper.between((Date)this.gllib.firmaBerechnungsStart(), (Date)this.callib.berchnungGueltigAb(), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            this.ermittleVMAusVortrag();
        } else {
            ValuePosition[] lVpArray;
            Date letzterTagVormonat = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()));
            block19: for (ValuePosition valuePosition : lVpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), DateHelper.getFirstDayOfMonth((Date)letzterTagVormonat), letzterTagVormonat, ValueTypeHelper.getValueTypes((int[])new int[]{801010, 801015, 801020, 801025, 801400, 802010, 802020, 803010, 803020, 804010, 804020, 805010, 805020, 806010, 806020, 807010, 807020}))) {
                switch (valuePosition.getValueType().getValueTypeKey()) {
                    case 801010: {
                        if (this.wplib.wertartenNummer() != 801140) continue block19;
                        this.stunden = this.stunden.add(valuePosition.getFactor1());
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    case 801020: {
                        Date beginEast;
                        EEDataCreditTP eeDataCreditTP = this.eelib.marbWertguthaben(TypeOfCreditEnum.TOCBE_SV_PFLICHTIG);
                        Date date = beginEast = eeDataCreditTP != null ? eeDataCreditTP.getBeginEast() : null;
                        if (beginEast == null || DateHelper.before((Date)beginEast, (Date)new VDate(2009, 0, 1).getDate())) {
                            if (this.wplib.wertartenNummer() != 801180) continue block19;
                            this.stunden = this.stunden.add(valuePosition.getFactor1());
                            this.betrag = this.betrag.add(valuePosition.getResult());
                            continue block19;
                        }
                        if (this.wplib.wertartenNummer() != 801185) continue block19;
                        this.stunden = this.stunden.add(valuePosition.getFactor1());
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    case 801015: {
                        if (this.wplib.wertartenNummer() != 801145) continue block19;
                        this.stunden = this.stunden.add(valuePosition.getFactor1());
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    case 801025: {
                        if (this.wplib.wertartenNummer() != 801185) continue block19;
                        this.stunden = this.stunden.add(valuePosition.getFactor1());
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    case 801400: {
                        if (this.wplib.wertartenNummer() != 801410) continue block19;
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    case 802010: {
                        if (this.wplib.wertartenNummer() != 802140) continue block19;
                        this.stunden = this.stunden.add(valuePosition.getFactor1());
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    case 802020: {
                        if (this.wplib.wertartenNummer() != 802180) continue block19;
                        this.stunden = this.stunden.add(valuePosition.getFactor1());
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    case 803010: {
                        if (this.wplib.wertartenNummer() != 803140) continue block19;
                        this.stunden = this.stunden.add(valuePosition.getFactor1());
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    case 803020: {
                        if (this.wplib.wertartenNummer() != 803180) continue block19;
                        this.stunden = this.stunden.add(valuePosition.getFactor1());
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    case 804010: {
                        if (this.wplib.wertartenNummer() != 804140) continue block19;
                        this.stunden = this.stunden.add(valuePosition.getFactor1());
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    case 804020: {
                        if (this.wplib.wertartenNummer() != 804180) continue block19;
                        this.stunden = this.stunden.add(valuePosition.getFactor1());
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    case 805010: {
                        if (this.wplib.wertartenNummer() != 805140) continue block19;
                        this.stunden = this.stunden.add(valuePosition.getFactor1());
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    case 805020: {
                        if (this.wplib.wertartenNummer() != 805180) continue block19;
                        this.stunden = this.stunden.add(valuePosition.getFactor1());
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    case 806010: {
                        if (this.wplib.wertartenNummer() != 806140) continue block19;
                        this.stunden = this.stunden.add(valuePosition.getFactor1());
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    case 806020: {
                        if (this.wplib.wertartenNummer() != 806180) continue block19;
                        this.stunden = this.stunden.add(valuePosition.getFactor1());
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    case 807010: {
                        if (this.wplib.wertartenNummer() != 807140) continue block19;
                        this.stunden = this.stunden.add(valuePosition.getFactor1());
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    case 807020: {
                        if (this.wplib.wertartenNummer() != 807180) continue block19;
                        this.stunden = this.stunden.add(valuePosition.getFactor1());
                        this.betrag = this.betrag.add(valuePosition.getResult());
                        continue block19;
                    }
                    default: {
                        throw EvaluationExceptionMapper.makeWrongValueTypeDomaineException(this.getClass().getName(), valuePosition.getValueType().getValueTypeKey());
                    }
                }
            }
        }
        if (BigDecimalMapper.isZero((BigDecimal)this.betrag) && BigDecimalMapper.isZero((BigDecimal)this.stunden)) {
            this.wplib.wertPosition().makeReadOnly();
        } else {
            this.callib.factor1(this.stunden);
            this.callib.result(this.betrag);
        }
        if (this.wplib.wertartenNummer() == 801410) {
            this.checkWGHgegenSVLuft();
        }
    }

    private void checkWGHgegenSVLuft() throws BusinessDomainException {
        this.vpArray = this.wplib.wpAusWPListeBisUebergebeneWP(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.wplib.wertPosition(), ValueTypeHelper.getValueTypes((int[])new int[]{801260, 801220, 801250, 801210, 801180, 801185, 801140, 801145}));
        BigDecimal gesamtesWGH = BigDecimal.ZERO;
        for (ValuePosition vPos : this.vpArray) {
            gesamtesWGH = gesamtesWGH.add(vPos.getResult());
        }
        if (gesamtesWGH.compareTo(BigDecimal.ZERO) == 0) {
            this.l\u00f6scheSVLuefte();
        }
    }

    private void l\u00f6scheSVLuefte() throws BusinessDomainException {
        for (ValuePosition vPos : this.vpArray = this.wplib.wpAusWPListeBisUebergebeneWP(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.wplib.wertPosition(), ValueTypeHelper.getValueTypes((int[])new int[]{324250, 324210, 324130, 324170, 330250, 330210, 330130, 330170, 336250, 336210, 336130, 336170, 342250, 342210, 342130, 342170}))) {
            vPos.setResult(BigDecimal.ZERO);
            vPos.makeReadOnly();
        }
    }

    private void ermittleVMAusVortrag() throws BusinessDomainException {
        EEDataCreditTP dataCreditTP = null;
        switch (this.wplib.wertartenNummer()) {
            case 801140: 
            case 801145: 
            case 801180: 
            case 801185: 
            case 801410: {
                dataCreditTP = this.eelib.marbWertguthaben(TypeOfCreditEnum.TOCBE_SV_PFLICHTIG);
                break;
            }
            case 802140: 
            case 802180: {
                dataCreditTP = this.eelib.marbWertguthaben(TypeOfCreditEnum.TOCBE_STEUER_UND_SV_FREI);
                break;
            }
            case 803140: 
            case 803180: {
                dataCreditTP = this.eelib.marbWertguthaben(TypeOfCreditEnum.TOCBE_GLEITZEIT_BIS_250_H);
                break;
            }
            case 804140: 
            case 804180: {
                dataCreditTP = this.eelib.marbWertguthaben(TypeOfCreditEnum.TOCBE_BIS_31_12_2000);
                break;
            }
            case 805140: 
            case 805180: {
                dataCreditTP = this.eelib.marbWertguthaben(TypeOfCreditEnum.TOCBE_BAV);
                break;
            }
            case 806140: 
            case 806180: {
                dataCreditTP = this.eelib.marbWertguthaben(TypeOfCreditEnum.TOCBE_WERTSTEIGERUNG_STEUER_UND_SV_PFLICHTIG);
                break;
            }
            default: {
                dataCreditTP = this.eelib.marbWertguthaben(TypeOfCreditEnum.TOCBE_VON_DRITTEN);
            }
        }
        if (dataCreditTP != null) {
            switch (this.wplib.wertartenNummer()) {
                case 801140: 
                case 802140: 
                case 803140: 
                case 804140: 
                case 805140: 
                case 806140: 
                case 807140: {
                    this.stunden = dataCreditTP.getHoursCarriedForwardWest();
                    this.betrag = dataCreditTP.getAmountCarriedForwardWest();
                    break;
                }
                case 801180: 
                case 802180: 
                case 803180: 
                case 804180: 
                case 805180: 
                case 806180: 
                case 807180: {
                    this.stunden = dataCreditTP.getHoursCarriedForwardEast();
                    this.betrag = dataCreditTP.getAmountCarriedForwardEast();
                    break;
                }
                case 801145: {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)dataCreditTP.getAmountCarriedForwardWestNew())) {
                        this.betrag = BigDecimal.ZERO;
                        break;
                    }
                    this.betrag = dataCreditTP.getAmountCarriedForwardWestNew();
                    break;
                }
                case 801185: {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)dataCreditTP.getAmountCarriedForwardEastNew())) {
                        this.betrag = BigDecimal.ZERO;
                        break;
                    }
                    this.betrag = dataCreditTP.getAmountCarriedForwardEastNew();
                    break;
                }
                case 801410: {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)dataCreditTP.getAmountCarriedForwardAGANew())) {
                        this.betrag = BigDecimal.ZERO;
                        break;
                    }
                    this.betrag = dataCreditTP.getAmountCarriedForwardAGANew();
                    break;
                }
            }
        }
    }

    private void erzeugeAgaWertarten(BigDecimal glAGA) throws BusinessDomainException {
        if (this.checkBgrKv()) {
            this.wplib.addNeueWertPositionMitGleichemParent(801420, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, glAGA, true);
        }
        if (this.checkBgrRV()) {
            this.wplib.addNeueWertPositionMitGleichemParent(801430, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, glAGA, true);
        }
        if (this.checkBgrAV()) {
            this.wplib.addNeueWertPositionMitGleichemParent(801440, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, glAGA, true);
        }
        if (this.checkBgrPV()) {
            this.wplib.addNeueWertPositionMitGleichemParent(801450, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, glAGA, true);
        }
    }

    private void bewegungWertguthaben() throws BusinessDomainException {
        block0 : switch (this.wplib.wertartenNummer()) {
            case 801320: {
                switch (this.gllib.marbRechtskreis()) {
                    case 'W': 
                    case 'w': {
                        if (this.wplib.factor1().compareTo(BigDecimal.ZERO) != 0) {
                            this.wplib.addNeueWertPosition(801220, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1().negate(), BigDecimal.ZERO, BigDecimal.ZERO, false);
                            break block0;
                        }
                        this.wplib.addNeueWertPosition(801220, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result().negate(), false);
                        break block0;
                    }
                }
                if (this.wplib.factor1().compareTo(BigDecimal.ZERO) != 0) {
                    this.wplib.addNeueWertPosition(801260, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1().negate(), BigDecimal.ZERO, BigDecimal.ZERO, false);
                    break;
                }
                this.wplib.addNeueWertPosition(801260, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result().negate(), false);
                break;
            }
            case 801310: {
                switch (this.gllib.marbRechtskreis()) {
                    case 'W': 
                    case 'w': {
                        if (this.wplib.factor1().compareTo(BigDecimal.ZERO) != 0) {
                            this.wplib.addNeueWertPosition(801210, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1(), BigDecimal.ZERO, BigDecimal.ZERO, false);
                            break block0;
                        }
                        this.wplib.addNeueWertPosition(801210, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result(), false);
                        break block0;
                    }
                }
                if (this.wplib.factor1().compareTo(BigDecimal.ZERO) != 0) {
                    this.wplib.addNeueWertPosition(801250, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.factor1(), BigDecimal.ZERO, BigDecimal.ZERO, false);
                    break;
                }
                this.wplib.addNeueWertPosition(801250, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result(), false);
                break;
            }
            default: {
                throw EvaluationExceptionMapper.makeWrongValueTypeDomaineException(this.getClass().getName(), this.wplib.wertartenNummer());
            }
        }
        this.callib.factor1(this.wplib.factor1());
        this.callib.result(this.wplib.result());
    }

    private void holeVormonatsWert() throws BusinessDomainException {
        Date letzterDesVormonats = DateHelper.yesterday((Date)this.callib.berchnungGueltigAb());
        ValuePosition[] lVpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), DateHelper.getFirstDayOfMonth((Date)letzterDesVormonats), letzterDesVormonats, new ValueType[]{ValueType.getValueType((int)801010), ValueType.getValueType((int)801020)});
        if (lVpArray.length != 0) {
            block8: for (ValuePosition vp : lVpArray) {
                switch (vp.getValueType().getValueTypeKey()) {
                    case 801010: {
                        if (this.wplib.wertartenNummer() != 801140) continue block8;
                        this.callib.factor1(this.callib.factor1().add(vp.getFactor1()));
                        this.callib.result(this.callib.result().add(vp.getResult()));
                        continue block8;
                    }
                    case 801020: {
                        if (this.wplib.wertartenNummer() != 801180) continue block8;
                        this.callib.factor1(this.callib.factor1().add(vp.getFactor1()));
                        this.callib.result(this.callib.result().add(vp.getResult()));
                        continue block8;
                    }
                }
            }
        } else {
            EEDataCreditTP eedctp = this.eelib.marbWertguthaben(TypeOfCreditEnum.TOCBE_SV_PFLICHTIG);
            if (eedctp != null) {
                switch (this.wplib.wertartenNummer()) {
                    case 801140: {
                        this.callib.factor1(eedctp.getHoursCarriedForwardWest());
                        this.callib.result(eedctp.getAmountCarriedForwardWest());
                        break;
                    }
                    case 801180: {
                        this.callib.factor1(eedctp.getHoursCarriedForwardEast());
                        this.callib.result(eedctp.getAmountCarriedForwardEast());
                        break;
                    }
                    default: {
                        throw EvaluationExceptionMapper.makeWrongValueTypeDomaineException(this.getClass().getName(), this.wplib.wertartenNummer());
                    }
                }
            }
        }
        if (BigDecimalMapper.isZero((BigDecimal)this.callib.result()) && BigDecimalMapper.isZero((BigDecimal)this.callib.factor1())) {
            this.wplib.wertPosition().makeReadOnly();
        }
    }

    private boolean checkBgrKv() throws BusinessDomainException {
        boolean result = false;
        switch (this.eelib.marbBgrKv()) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean checkBgrRV() throws BusinessDomainException {
        boolean result = false;
        switch (this.eelib.marbBgrRv()) {
            case 1: 
            case 3: {
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean checkBgrAV() throws BusinessDomainException {
        boolean result = false;
        switch (this.eelib.marbBgrAv()) {
            case 1: 
            case 2: {
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean checkBgrPV() throws BusinessDomainException {
        boolean result = false;
        block0 : switch (this.eelib.marbBgrKv()) {
            case 0: 
            case 9: {
                break;
            }
            default: {
                switch (this.eelib.marbBgrPv()) {
                    case 1: 
                    case 2: {
                        result = true;
                        break block0;
                    }
                }
            }
        }
        return result;
    }
}

