/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.deuv.deuvaccount;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFund;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundPersistencyManager;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundTP;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.accidentinsurancefundvaluetype.AccidentInsuranceFundValuetype;
import com.varial.personnel.domain.companyplant.GeneralEmploymentOffice;
import com.varial.personnel.domain.companyplant.StatusByInsolvencyEnum;
import com.varial.personnel.domain.companyplant.TypeOfBusinessEnum;
import com.varial.personnel.domain.deuv.DbuvEmployee;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccount;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccountPersistencyManager;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVEmployee;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.AbsenceImpl;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.Adviceable;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.ChangeImpl;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.ContinuationImpl;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.DeceasedImpl;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.DiseasedEntryImpl;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.DisruptionImpl;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.EndAbsenceImpl;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.EntryImpl;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.IgnoreImpl;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.WithdrawalImpl;
import com.varial.personnel.domain.deuv.deuvaccount.mapper.DEUVAccountExceptionMapper;
import com.varial.personnel.domain.deuv.deuvtrigger.DEUVTrigger;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.deuvmessaging.DeuvRecipientMap;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEECalculationHistoric;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.carriedforward.system.accidentinsurancefund.EECarriedForwardSystemAI;
import com.varial.personnel.domain.employee.carriedforward.system.accidentinsurancefund.EECarriedForwardSystemAIPersistencyManager;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFund;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurance;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurancePersistencyManager;
import com.varial.personnel.domain.global.socialinsurance.SocialInsuranceTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.emploffice.CompanyEmploymentOffice;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.emploffice.PlantEmploymentOffice;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.domain.uv.UvHelper;
import com.varial.personnel.domain.uv.dssd.UvDssd;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class DEUVAdvice {
    private static final Date START_OF_CALCULATION_IS_DEUV_BEGIN = DateMapper.toDate((String)"2011-12-01");
    private static final Date START_OF_CALCULATION_IS_2015 = DateMapper.toDate((String)"2015-01-01");
    public static final Date START_OF_2009 = DateMapper.toDate((String)"2009-01-01");
    public static final Date START_OF_2010 = DateMapper.toDate((String)"2010-01-01");
    public static final Date START_OF_2013 = DateMapper.toDate((String)"2013-01-01");
    public static final Date START_OF_2014 = DateMapper.toDate((String)"2014-01-01");
    public static final Date START_OF_2015 = DateMapper.toDate((String)"2015-01-01");
    public static final Date START_OF_2017 = DateMapper.toDate((String)"2017-01-01");
    public static final Date START_OF_2018 = DateMapper.toDate((String)"2018-01-01");
    public static final Date MID_OF_2019 = DateMapper.toDate((String)"2019-07-01");
    public static final Date START_OF_2020 = DateMapper.toDate((String)"2020-01-01");
    public static final Date START_OF_2022 = DateMapper.toDate((String)"2022-01-01");
    public static final Date START_OF_2023 = DateMapper.toDate((String)"2023-01-01");
    public static final Date START_BESTANDSSCHUTZ_2022 = DateMapper.toDate((String)"2022-10-01");
    public static final Date START_OF_2025 = DateMapper.toDate((String)"2025-01-01");
    public static final Date NO_MESSAGES_BEFORE = DateHelper.tomorrow((Date)DateMapper.toDate((String)"2021-01-01"));
    @Deprecated
    public static final Adviceable[] ADVICEABLES = new Adviceable[]{new AbsenceImpl(), new EntryImpl(), new DiseasedEntryImpl(), new DisruptionImpl(), new DeceasedImpl(), new EndAbsenceImpl(), new WithdrawalImpl(), new ChangeImpl(), new ContinuationImpl(), new IgnoreImpl()};
    private static final String BBNR_MINIJOB = "98000006";
    private static final String BBNR_MINIJOB_EVPT = "99300933";
    private final PCompany mPCompany;
    private final DEUVSender mDEUVSender;
    private Deque<Employee> mEmployees;
    private boolean mAffectedBySpecialAccess;
    private final String mCreatedOn;
    private int mCounter;
    private final SocialInsurance mSocialInsurance;
    private final Date mCreatedOnDate;
    private final Date mDEUVStart;
    private final boolean mPreview;
    private final List<DEUVAccount> mPreviewAccounts;
    private ValueType[] mGleitzoneValueTypes;
    private ValueType[] mEgaValueTypes;
    private ValueType[] mPaymentValueTypes;
    private ValueType[] mPaymentDeductions;
    private ValueType[] mStoerfallValueTypes;
    private ValueType[] mDifferenceValueTypes;
    private ValueType[] mMbbglValueTypes;
    private ValueType[] mEgaMkValueTypes;
    private ValueType[] mEgaMkSysValueTypes;
    private ValueType[] mAtzZbeValueTypes;
    private ValueType[] mKugValueTypes;
    private ValueType[] mQuarantineVT;
    private ValueType[] mVoluntaryHIValueTypes;
    private ValueType[] mPaymentBvValueTypes;
    private ValueType[] mMidijobBemessungValueTypes;
    private ValueType mPar23cValueType;
    private ValueType mSIDaysValueType;
    private ValueType[] mAGZuschussBeitragspflValueType;
    private AssignmentPCompanyAccidentInsuranceFund[] mUVAssignments;
    private final List<AssignmentPCompanyAccidentInsuranceFundTP> mAssAifTPs;
    private UvDssd[] mUvDssds;
    private Date mMaxAifDate;
    private final DeuvRecipientMap mDEUVRecipients;
    private HashSet<String> mInsuranceNoBlackList;
    private final Date mPensionPayingStart;

    public DEUVAdvice(PCompany pCompany, boolean preview) throws BusinessDomainException {
        this.mPCompany = pCompany;
        this.mCreatedOnDate = VDate.getCurrentLocalizedDateAndTime();
        this.mCreatedOn = DeuvBasics.getCurrentDeuvDateString();
        this.mSocialInsurance = SocialInsurancePersistencyManager.getInstance();
        DEUVSenderTP tp = DeuvHelper.getDeuvSenderTP((PCompany)pCompany);
        if (tp.getDateOfAdmission() == null) {
            throw DEUVAccountExceptionMapper.makeMissDEUVStartException();
        }
        this.mDEUVSender = tp.getDEUVSender();
        this.mDEUVRecipients = new DeuvRecipientMap(this.mDEUVSender);
        this.mDEUVStart = DateHelper.afterOrEqual((Date)tp.getDateOfAdmission(), (Date)START_OF_CALCULATION_IS_DEUV_BEGIN) || DateHelper.afterOrEqual((Date)this.getCalculationStart(), (Date)START_OF_CALCULATION_IS_2015) ? DateHelper.max((Date)tp.getDateOfAdmission(), (Date)this.getCalculationHistoric()) : tp.getDateOfAdmission();
        this.mPensionPayingStart = tp.getDateOfStartPension();
        this.mPreview = preview;
        this.mPreviewAccounts = new ArrayList<DEUVAccount>();
        this.mAssAifTPs = new ArrayList<AssignmentPCompanyAccidentInsuranceFundTP>();
        this.mMaxAifDate = null;
    }

    public Date getDEUVStart() {
        return this.mDEUVStart;
    }

    public String getCreatedOn() {
        return this.mCreatedOn;
    }

    public Date getCreatedOnDate() {
        return this.mCreatedOnDate;
    }

    public DEUVSender getDEUVSender() {
        return this.mDEUVSender;
    }

    public SocialInsuranceTP getSocialInsuranceTP(Date validFrom) throws BusinessDomainException {
        return this.mSocialInsurance.getSocialInsurance(this.getEffectiveTimePoint(), validFrom);
    }

    public Deque<Employee> getEmployeeList(List<String> oidEmployees) {
        this.mEmployees = new LinkedList<Employee>();
        if (oidEmployees.isEmpty()) {
            Order[] sort = new Order[]{Order.asc((String)"PERSONNELNUMBER")};
            Criterion filter = Restrictions.eq((String)"OIDPCOMPANY", (String)this.getPCompany().getObjectid());
            for (Employee each : this.getIEmployeePM().query(sort, filter, true)) {
                this.mEmployees.add(each);
            }
        } else {
            for (String each : oidEmployees) {
                this.mEmployees.add(this.getIEmployeePM().getEmployee(each));
            }
        }
        return this.mEmployees;
    }

    private static List<DEUVAccount> getOpenAccounts(PCompany pCompany, boolean isSpecialAccess, boolean readOnly) {
        ArrayList<DEUVAccount> result = new ArrayList<DEUVAccount>();
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.isNull((String)DEUVAccountPersistencyManager.OIDEMPLOYEE), Restrictions.eq((String)DEUVAccountPersistencyManager.OIDPCOMPANYOFDEUVACCOUNT, (String)pCompany.getObjectid()), Restrictions.eq((String)DEUVAccountPersistencyManager.REASONOFDELIVERY, (String)"92"), Restrictions.eq((String)DEUVAccountPersistencyManager.TRANSMITTED, (String)BooleanMapper.toString((boolean)false))});
        Order[] sort = new Order[]{Order.asc((String)DEUVAccountPersistencyManager.INSURANCENO), Order.asc((String)DEUVAccountPersistencyManager.SERIALNUMBER)};
        DEUVAccount[] uvyearlies = DEUVAccountPersistencyManager.query((Order[])sort, (Criterion)filter);
        result.addAll(Arrays.asList(uvyearlies));
        filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)DEUVAccountPersistencyManager.OIDPCOMPANY, (String)pCompany.getObjectid()), Restrictions.eq((String)DEUVAccountPersistencyManager.TRANSMITTED, (String)BooleanMapper.toString((boolean)false))});
        if (isSpecialAccess) {
            filter = Restrictions.and((Criterion)filter, (Criterion)Restrictions.eq((String)DEUVAccountPersistencyManager.SPECIALACCESS, (String)"F"));
        }
        DEUVAccount[] openAccounts = DEUVAccountPersistencyManager.queryAll((Order[])new Order[]{Order.asc((String)DEUVAccountPersistencyManager.PERSONNELNUMBER), Order.asc((String)DEUVAccountPersistencyManager.SERIALNUMBER)}, (Criterion)filter, (boolean)readOnly);
        result.addAll(Arrays.asList(openAccounts));
        return result;
    }

    public int incrementCounter() {
        return ++this.mCounter;
    }

    public PCompany getPCompany() {
        return this.mPCompany;
    }

    public static List<DEUVAccount> getUntransmittedsForExternalCheck(PCompany pCompany) {
        ArrayList<DEUVAccount> accounts = new ArrayList<DEUVAccount>(DEUVAdvice.getOpenAccounts(pCompany, false, true));
        ArrayList<DEUVAccount> errors = new ArrayList<DEUVAccount>();
        for (DEUVAccount each : accounts) {
            if (!each.hasError()) continue;
            errors.add(each);
        }
        if (!errors.isEmpty()) {
            accounts.removeAll(errors);
        }
        return accounts;
    }

    public List<DEUVAccount> getUntransmitteds(boolean isSpecialAccess) {
        List<DEUVAccount> accounts;
        if (this.mPreview) {
            this.removeStatusAccounts(this.mPreviewAccounts);
            this.orderByPnr(this.mPreviewAccounts);
            accounts = this.mPreviewAccounts;
        } else {
            accounts = new ArrayList<DEUVAccount>(DEUVAdvice.getOpenAccounts(this.mPCompany, isSpecialAccess, false));
        }
        ArrayList<DEUVAccount> errors = new ArrayList<DEUVAccount>();
        for (DEUVAccount each : accounts) {
            if (!each.hasError()) continue;
            errors.add(each);
        }
        if (!errors.isEmpty()) {
            accounts.removeAll(errors);
            accounts.addAll(0, errors);
        }
        for (int i = 0; i < accounts.size(); ++i) {
            DEUVAccount account = accounts.get(i);
            if (this.mPreview) {
                account.setSerialNumber(i);
                continue;
            }
            account.updateUntransmitted(i + 1, this.mCreatedOn);
        }
        return accounts;
    }

    public List<DEUVAccount> updateForReport(List<DEUVAccount> accounts, boolean alphabetical) {
        ArrayList<DEUVAccount> oldErrors = new ArrayList<DEUVAccount>();
        Date hideErrorDate = new VDate().setDaysToMinimumDayOfYear().addYears(-2).getDate();
        for (DEUVAccount each : accounts) {
            if (!each.hasError() || !DateHelper.before((Date)each.getValidFrom(), (Date)hideErrorDate) || each.getManually()) continue;
            oldErrors.add(each);
        }
        accounts.removeAll(oldErrors);
        if (alphabetical) {
            this.orderByName(accounts);
        }
        return accounts;
    }

    private void orderByPnr(List<DEUVAccount> accounts) {
        Collections.sort(accounts, new Comparator<DEUVAccount>(){

            @Override
            public int compare(DEUVAccount acc1, DEUVAccount acc2) {
                int pnr2;
                int pnr1 = acc1.getEmployee() == null ? 0 : acc1.getEmployee().getPersonnelnumber();
                int result = pnr1 - (pnr2 = acc2.getEmployee() == null ? 0 : acc2.getEmployee().getPersonnelnumber());
                if (result == 0) {
                    result = acc1.getSerialNumber() - acc2.getSerialNumber();
                }
                return result;
            }
        });
    }

    private void orderByName(List<DEUVAccount> accounts) {
        Collections.sort(accounts, new Comparator<DEUVAccount>(){

            @Override
            public int compare(DEUVAccount acc1, DEUVAccount acc2) {
                int result = StringMapper.compareTo((String)this.getName(acc1), (String)this.getName(acc2));
                if (result == 0) {
                    result = acc1.getSerialNumber() - acc2.getSerialNumber();
                }
                return result;
            }

            private String getName(DEUVAccount account) {
                Object result = "";
                if (account.getEmployee() == null) {
                    EECarriedForwardSystemAI eeCarriedForwardSystemAI = EECarriedForwardSystemAI.getEECarriedForwardSystemAIByInsuranceNo((String)account.getInsuranceNo());
                    if (eeCarriedForwardSystemAI != null) {
                        result = eeCarriedForwardSystemAI.getSurname() + eeCarriedForwardSystemAI.getFirstname();
                    }
                } else {
                    Master master = (Master)account.getEmployee().getMasterHistory().getItemOrNull(VDate.getDateMax(), VDate.getDateMax());
                    if (master != null) {
                        result = master.getSurname() + master.getFirstname();
                    }
                }
                return result;
            }
        });
    }

    private void removeStatusAccounts(List<DEUVAccount> accounts) {
        ArrayList<DEUVAccount> toRemove = new ArrayList<DEUVAccount>();
        for (DEUVAccount account : accounts) {
            if (!account.getTransmitted()) continue;
            toRemove.add(account);
        }
        accounts.removeAll(toRemove);
    }

    private CompanyFoundations getCompanyFoundations(PCompany pCompany) throws BusinessDomainException {
        return pCompany.getCompanyFoundations(this.getEffectiveTimePoint(), this.getValidTimePoint());
    }

    public Date getCalculationStart() throws BusinessDomainException {
        return this.getCompanyFoundations(this.mPCompany).getCalculationStart();
    }

    public boolean isInsolvencyLeaveCompany() throws BusinessDomainException {
        StatusByInsolvencyEnum insolvencyEnum = this.getCompanyFoundations(this.mPCompany).getFoundations().getStatusByInsolvency();
        return insolvencyEnum == StatusByInsolvencyEnum.SBIE_FUER_SOFORT_FREIGESTELLTE_AN || insolvencyEnum == StatusByInsolvencyEnum.SBIE_FUER_SPAETER_FREIGESTELLTE_AN;
    }

    public Date getTerminationDate() throws BusinessDomainException {
        Date result = null;
        if (this.getCompanyFoundations(this.mPCompany).getFoundations().getTypeOfBusiness() == TypeOfBusinessEnum.TYBE_BETRIEBSAUFGABE) {
            result = DateHelper.yesterday((Date)this.getCompanyFoundations(this.mPCompany).getValidFrom());
        }
        return result;
    }

    public Date getInsolvencyDate() throws BusinessDomainException {
        Date result = null;
        if (this.getCompanyFoundations(this.mPCompany).getFoundations().getStatusByInsolvency() == StatusByInsolvencyEnum.SBIE_INSOLVENT) {
            result = DateHelper.yesterday((Date)this.getCompanyFoundations(this.mPCompany).getFoundations().getInsolventlyFrom());
        }
        return result;
    }

    public ValueType[] getLowWageValueTypes() throws BusinessDomainException {
        if (this.mGleitzoneValueTypes == null) {
            this.mGleitzoneValueTypes = new ValueType[]{this.getValueType(327514), this.getValueType(327614)};
        }
        return this.mGleitzoneValueTypes;
    }

    public ValueType getOtherEmployerValueType() throws BusinessDomainException {
        return this.getValueType(129200);
    }

    public ValueType getValueType(int number) throws BusinessDomainException {
        ValueType vt = ValueType.getValueType((int)number);
        if (vt == null) {
            throw DEUVAccountExceptionMapper.makeMissValueTypeDomainException((int)number);
        }
        return vt;
    }

    public ValueType[] getEgaValueTypes() throws BusinessDomainException {
        if (this.mEgaValueTypes == null) {
            this.mEgaValueTypes = new ValueType[]{this.getValueType(327200), this.getValueType(333200), this.getValueType(321200), this.getValueType(339200)};
        }
        return this.mEgaValueTypes;
    }

    public ValueType[] getPaymentValueTypes() throws BusinessDomainException {
        if (this.mPaymentValueTypes == null) {
            this.mPaymentValueTypes = new ValueType[]{this.getValueType(327050), this.getValueType(333050), this.getValueType(321050), this.getValueType(339050), this.getValueType(401100), this.getValueType(401150)};
        }
        return this.mPaymentValueTypes;
    }

    public ValueType[] getPaymentBvValueTypes() throws BusinessDomainException {
        if (this.mPaymentBvValueTypes == null) {
            this.mPaymentBvValueTypes = new ValueType[]{this.getValueType(773050)};
        }
        return this.mPaymentBvValueTypes;
    }

    public ValueType[] getPaymentDeductions() throws BusinessDomainException {
        if (this.mPaymentDeductions == null) {
            this.mPaymentDeductions = new ValueType[]{this.getValueType(327680), this.getValueType(327730)};
        }
        return this.mPaymentDeductions;
    }

    public ValueType[] getEgaMkValueTypes() throws BusinessDomainException {
        if (this.mEgaMkValueTypes == null) {
            this.mEgaMkValueTypes = new ValueType[]{this.getValueType(327620), this.getValueType(333620), this.getValueType(321620), this.getValueType(339620), this.getValueType(773620)};
        }
        return this.mEgaMkValueTypes;
    }

    public ValueType[] getEgaMkSysValueTypes() throws BusinessDomainException {
        if (this.mEgaMkSysValueTypes == null) {
            this.mEgaMkSysValueTypes = new ValueType[]{this.getValueType(327630), this.getValueType(333630), this.getValueType(321630), this.getValueType(339630), this.getValueType(773630)};
        }
        return this.mEgaMkSysValueTypes;
    }

    public ValueType[] getMidijobBemessungValueTypes() throws BusinessDomainException {
        if (this.mMidijobBemessungValueTypes == null) {
            this.mMidijobBemessungValueTypes = new ValueType[]{this.getValueType(327616), this.getValueType(333616), this.getValueType(321616), this.getValueType(339616)};
        }
        return this.mMidijobBemessungValueTypes;
    }

    private DEUVRecipient getDEUVRecipient(TypeOfHealthFundEnum type, boolean considereVpT) throws BusinessDomainException {
        return this.mDEUVRecipients.getDeuvRecipient(type, considereVpT);
    }

    public DEUVRecipient getBuknRecipient() throws BusinessDomainException {
        return this.getDEUVRecipient(TypeOfHealthFundEnum.TOHF_KNAPPSCHAFT, true);
    }

    public DEUVRecipient getPensionPayingRecipient() throws BusinessDomainException {
        return this.getDEUVRecipient(TypeOfHealthFundEnum.TOHF_VERSORGUNG, true);
    }

    public DEUVRecipient getPromptRecipient() throws BusinessDomainException {
        return this.getDEUVRecipient(TypeOfHealthFundEnum.TOHF_RENTENVERSICHERUNG, false);
    }

    public DEUVRecipient getDEUVRecipient(HealthFund healthFund) throws BusinessDomainException {
        return this.mDEUVRecipients.getDeuvRecipient(healthFund);
    }

    public void updateDeuvRecipient(DEUVAccount account) throws BusinessDomainException {
        String standardCompanyNumberHf = account.getDEUVDsme().getBbnrKrankenkasse();
        account.setDEUVRecipient(this.getupdatedDeuvRecipient(account.getDEUVRecipient(), standardCompanyNumberHf));
    }

    public DEUVRecipient getupdatedDeuvRecipient(DEUVRecipient old, String standardCompanyNumberHf) throws BusinessDomainException {
        return this.mDEUVRecipients.updateDeuvRecipient(old, standardCompanyNumberHf);
    }

    public ValueType getPar23cValueType() throws BusinessDomainException {
        if (this.mPar23cValueType == null) {
            this.mPar23cValueType = this.getValueType(129530);
        }
        return this.mPar23cValueType;
    }

    public ValueType[] getAGZuschussBeitragspflValueType() throws BusinessDomainException {
        if (this.mAGZuschussBeitragspflValueType == null) {
            this.mAGZuschussBeitragspflValueType = new ValueType[]{this.getValueType(129512), this.getValueType(129513)};
        }
        return this.mAGZuschussBeitragspflValueType;
    }

    private Adviceable[] getAdviceables() {
        return ADVICEABLES;
    }

    public ValueType getSIDaysValueType() throws BusinessDomainException {
        if (this.mSIDaysValueType == null) {
            this.mSIDaysValueType = this.getValueType(130590);
        }
        return this.mSIDaysValueType;
    }

    public ValueType[] getStoerfallValueTypes() throws BusinessDomainException {
        if (this.mStoerfallValueTypes == null) {
            this.mStoerfallValueTypes = new ValueType[]{this.getValueType(130750), this.getValueType(327730)};
        }
        return this.mStoerfallValueTypes;
    }

    public ValueType[] getDifferenceValueTypes() throws BusinessDomainException {
        if (this.mDifferenceValueTypes == null) {
            this.mDifferenceValueTypes = new ValueType[]{this.getValueType(327680)};
        }
        return this.mDifferenceValueTypes;
    }

    public ValueType[] getAtzZBbeValueTypes() throws BusinessDomainException {
        if (this.mAtzZbeValueTypes == null) {
            this.mAtzZbeValueTypes = new ValueType[]{this.getValueType(327550), this.getValueType(327555)};
        }
        return this.mAtzZbeValueTypes;
    }

    public ValueType[] getKugValuesTypes() throws BusinessDomainException {
        if (this.mKugValueTypes == null) {
            this.mKugValueTypes = new ValueType[]{this.getValueType(327720)};
        }
        return this.mKugValueTypes;
    }

    public ValueType[] getQuarantineValuesTypes() throws BusinessDomainException {
        if (this.mQuarantineVT == null) {
            this.mQuarantineVT = new ValueType[]{this.getValueType(327740)};
        }
        return this.mQuarantineVT;
    }

    public ValueType[] getMbbglGfBValueTypes() throws BusinessDomainException {
        if (this.mMbbglValueTypes == null) {
            this.mMbbglValueTypes = new ValueType[]{this.getValueType(328513), this.getValueType(774513)};
        }
        return this.mMbbglValueTypes;
    }

    public ValueType[] getVoluntaryHIValueTypes() throws BusinessDomainException {
        if (this.mVoluntaryHIValueTypes == null) {
            this.mVoluntaryHIValueTypes = new ValueType[]{this.getValueType(770090)};
        }
        return this.mVoluntaryHIValueTypes;
    }

    public AssignmentPCompanyAccidentInsuranceFundTP getAssignmentPCompanyAccidentInsuranceFundTP(AccidentInsuranceFund aif, Plant plant, Date validFrom) {
        if (this.mUVAssignments == null) {
            this.mUVAssignments = AssignmentPCompanyAccidentInsuranceFundPersistencyManager.query(null, (Criterion)Restrictions.eq((String)"OIDPCOMPANY", (String)this.mPCompany.getObjectid()));
        }
        for (AssignmentPCompanyAccidentInsuranceFund aaif : this.mUVAssignments) {
            if (!aif.equals((Object)aaif.getAccidentInsuranceFund()) || !this.isEqual(plant, aaif.getPlant())) continue;
            try {
                return aaif.getAssignmentPCompanyAccidentInsuranceFundTP(VDate.getDateMax(), validFrom);
            }
            catch (BusinessDomainException businessDomainException) {
                // empty catch block
            }
        }
        for (AssignmentPCompanyAccidentInsuranceFund aaif : this.mUVAssignments) {
            if (!aif.equals((Object)aaif.getAccidentInsuranceFund()) || aaif.getPlant() != null) continue;
            try {
                return aaif.getAssignmentPCompanyAccidentInsuranceFundTP(VDate.getDateMax(), validFrom);
            }
            catch (BusinessDomainException businessDomainException) {
                // empty catch block
            }
        }
        return null;
    }

    public AccidentInsuranceFundValuetype[] getAifValueTypes(AssignmentPCompanyAccidentInsuranceFundTP tp) {
        int index = this.mAssAifTPs.indexOf(tp);
        if (index == -1) {
            this.mAssAifTPs.add(tp);
            index = this.mAssAifTPs.indexOf(tp);
        }
        return this.mAssAifTPs.get(index).getValueTypes();
    }

    public UvDssd getUvDssd(AccidentInsuranceFund aif, String mnr, String unrs, Date validTP) {
        if (this.mUvDssds == null) {
            this.mUvDssds = UvHelper.getUvDssdPM().query(new Order[]{Order.desc((String)"JAHR"), Order.desc((String)"ED")}, Restrictions.eq((String)"OIDPCOMPANY", (String)this.mPCompany.getObjectid()), true);
        }
        UvDssd result = null;
        for (UvDssd dssd : this.mUvDssds) {
            if (!aif.equals((Object)dssd.getAccidentInsuranceFund()) || !UvHelper.areEqualMnrUnrs((String)dssd.getMnr(), (String)mnr, (String)dssd.getUnrs(), (String)unrs, (int)DateHelper.toLocalDate((Date)validTP).getYear())) continue;
            if (PDateHelper.between((Date)validTP, (Date)dssd.getMnrgvon(), (Date)dssd.getMnrgbis())) {
                result = dssd;
                break;
            }
            if (dssd.getBeitragsmassstab() <= 3 || !DateHelper.beforeOrEqual((Date)dssd.getMnrgbis(), (Date)validTP)) continue;
            result = dssd;
            break;
        }
        return result;
    }

    private boolean isEqual(Object one, Object other) {
        return one == other || one != null && one.equals(other);
    }

    public boolean isMinijobStdCompanyNo(String bbnr) {
        return DEUVAdvice.isMinijobStdCompanyNo(bbnr, this.mDEUVSender.isTestSender());
    }

    public String getMinijobStdCompanyNo() {
        return DEUVAdvice.getMinijobStdCompanyNo(this.mDEUVSender.isTestSender());
    }

    public static boolean isMinijobStdCompanyNo(DEUVAccount account) {
        return DEUVAdvice.isMinijobStdCompanyNo(DEUVAdvice.getBbnrKrk(account), false);
    }

    public static String getBbnrKrk(DEUVAccount account) {
        if (account.getDEUVDsme() != null) {
            return account.getDEUVDsme().getBbnrKrankenkasse();
        }
        if (account.getDeuvDsfz() != null) {
            return account.getDeuvDsfz().getEpnr();
        }
        return "";
    }

    private static boolean isMinijobStdCompanyNo(String bbnr, boolean isTestsender) {
        return DEUVAdvice.getMinijobStdCompanyNo(isTestsender).equals(bbnr);
    }

    private static String getMinijobStdCompanyNo(boolean isTestsender) {
        return isTestsender ? BBNR_MINIJOB_EVPT : BBNR_MINIJOB;
    }

    public Date getPensionPayingStart() {
        return this.mPensionPayingStart;
    }

    public void make(DEUVTrigger trigger, DEUVEmployee de) throws BusinessDomainException {
        for (Adviceable a : this.getAdviceables()) {
            if (!a.isAdviceable(trigger.getTypeOfDeuvTrigger())) continue;
            a.makeAccount(de, trigger);
            return;
        }
    }

    public DEUVSenderTP getDEUVSenderTP() {
        try {
            return this.getDEUVSender().getDEUVSenderTP(this.getEffectiveTimePoint(), this.getValidTimePoint());
        }
        catch (BusinessDomainException e) {
            throw new IllegalStateException(e);
        }
    }

    private Date getValidTimePoint() {
        return VDate.getDateMax();
    }

    private Date getEffectiveTimePoint() {
        return VDate.getDateMax();
    }

    public void updateAifDate(DEUVAccount account92) {
        this.mMaxAifDate = this.mMaxAifDate == null ? account92.getValidUntil() : DateHelper.max((Date)this.mMaxAifDate, (Date)account92.getValidUntil());
    }

    public void makeWithdrawalEmpAccounts() throws BusinessDomainException {
        ArrayList<DEUVAccount> createds = new ArrayList<DEUVAccount>();
        for (EECarriedForwardSystemAI each : this.getEECfAifs()) {
            if (!this.isMessageAllowed(each)) continue;
            DEUVAccount account = DbuvEmployee.createReason92((EECarriedForwardSystemAI)each, (DEUVAdvice)this);
            if (account.getDEUVDbuv() != null && account.getDEUVDbuv().getUVRiskPeriods().length > 0) {
                createds.add(account);
                DbuvEmployee.checkCfForErrors((DEUVAccount)account, (EECarriedForwardSystemAI)each);
                continue;
            }
            account.makeReadOnly();
        }
        List<DEUVAccount> result = this.makeResults(createds);
        if (this.isPreview()) {
            this.addPreviewAccounts(result);
        }
    }

    private EECarriedForwardSystemAI[] getEECfAifs() {
        Criterion filters = Restrictions.eq((String)"OIDPCOMPANY", (String)this.mPCompany.getObjectid());
        Order[] sort = new Order[]{Order.asc((String)"INSURANCENO"), Order.asc((String)"VALIDFROM")};
        return EECarriedForwardSystemAIPersistencyManager.query((Order[])sort, (Criterion)filters);
    }

    private List<DEUVAccount> makeResults(List<DEUVAccount> toCompare) throws BusinessDomainException {
        DEUVAccount storno;
        LinkedList<DEUVAccount> existing = new LinkedList<DEUVAccount>(this.getReferences());
        LinkedList<DEUVAccount> createds = new LinkedList<DEUVAccount>(toCompare);
        ArrayList<DEUVAccount> results = new ArrayList<DEUVAccount>();
        block5: while (!createds.isEmpty() && !existing.isEmpty()) {
            DEUVAccount existent = (DEUVAccount)((Object)existing.getFirst());
            DEUVAccount created = (DEUVAccount)((Object)createds.getFirst());
            switch (DbuvEmployee.compareAccountsWithInsNo((DEUVAccount)existent, (DEUVAccount)created)) {
                case 0: {
                    created.makeReadOnly();
                    existing.removeFirst();
                    createds.removeFirst();
                    continue block5;
                }
                case -1: {
                    storno = DbuvEmployee.makeCancellation((DEUVAccount)existent, (DEUVAdvice)this);
                    results.add(storno);
                    existing.removeFirst();
                    continue block5;
                }
                case 1: {
                    created.makeErrors(false, this);
                    created.setSerialNumber(this.incrementCounter());
                    results.add(created);
                    createds.removeFirst();
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Compare returned invalid result");
        }
        for (DEUVAccount account : existing) {
            storno = DbuvEmployee.makeCancellation((DEUVAccount)account, (DEUVAdvice)this);
            results.add(storno);
        }
        for (DEUVAccount account : createds) {
            account.makeErrors(false, this);
            account.setSerialNumber(this.incrementCounter());
            results.add(account);
        }
        return results;
    }

    private List<DEUVAccount> getReferences() throws BusinessDomainException {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.isNull((String)DEUVAccountPersistencyManager.OIDEMPLOYEE), Restrictions.eq((String)DEUVAccountPersistencyManager.OIDPCOMPANYOFDEUVACCOUNT, (String)this.mPCompany.getObjectid()), Restrictions.eq((String)DEUVAccountPersistencyManager.REASONOFDELIVERY, (String)"92")});
        ArrayList<DEUVAccount> references = new ArrayList<DEUVAccount>(Arrays.asList(DEUVAccountPersistencyManager.query(null, (Criterion)filter)));
        for (DEUVAccount each : new ArrayList<DEUVAccount>(references)) {
            if (!each.getTransmitted()) {
                references.remove((Object)each);
                each.makeSaveable();
                each.destroy();
                continue;
            }
            if (each.getDEUVDbme() == null || !each.getDEUVDbme().getStornokennzeichen().equals("J")) continue;
            each.reorgCancelled("J");
        }
        Collections.sort(references, new Comparator<DEUVAccount>(){

            @Override
            public int compare(DEUVAccount acc1, DEUVAccount acc2) {
                int comp = StringMapper.compareTo((String)acc1.getInsuranceNo(), (String)acc2.getInsuranceNo());
                if (comp == 0) {
                    comp = DateHelper.compare((Date)acc1.getValidFrom(), (Date)acc2.getValidFrom());
                }
                if (comp == 0) {
                    comp = StringMapper.compareTo((String)acc1.getCreatedOn(), (String)acc2.getCreatedOn());
                }
                return comp;
            }
        });
        LinkedList<DEUVAccount> toCheck = new LinkedList<DEUVAccount>(references);
        ArrayList<DEUVAccount> obsoletes = new ArrayList<DEUVAccount>();
        while (!toCheck.isEmpty()) {
            DEUVAccount current = (DEUVAccount)((Object)toCheck.remove(0));
            if (current.getCanceled().equals("X")) {
                for (DEUVAccount each : toCheck) {
                    if (!each.getCanceled().equals("J") || DbuvEmployee.compareAccountsWithInsNo((DEUVAccount)current, (DEUVAccount)each) != 0) continue;
                    toCheck.remove((Object)each);
                    obsoletes.add(each);
                    obsoletes.add(current);
                    current = null;
                    break;
                }
                if (current == null) continue;
                current.reorgCancelled("N");
                continue;
            }
            if (!current.getCanceled().equals("J")) continue;
            obsoletes.add(current);
        }
        references.removeAll(obsoletes);
        for (DEUVAccount each : references) {
            each.loadAdvicedState(null);
        }
        return references;
    }

    private boolean isMessageAllowed(EECarriedForwardSystemAI cfAif) throws BusinessDomainException {
        return this.mMaxAifDate != null && DateHelper.afterOrEqual((Date)this.mMaxAifDate, (Date)cfAif.getValidUntil()) && DateHelper.afterOrEqual((Date)cfAif.getValidFrom(), (Date)DateHelper.getFirstDayOfYear((Date)this.getCalculationHistoric()));
    }

    public static String getCompanyNumber(PCompany pCompany, Plant plant, Date validTP) {
        return DEUVAdvice.getGeneralEmploymentOffice(pCompany, plant, validTP).getEmployerNumber();
    }

    public static GeneralEmploymentOffice getGeneralEmploymentOffice(PCompany pCompany, Plant plant, Date validTP) {
        CompanyEmploymentOffice ceo;
        PlantEmploymentOffice peo;
        GeneralEmploymentOffice result = null;
        Date effectiveTP = VDate.getDateMax();
        if (plant != null && (peo = (PlantEmploymentOffice)plant.getPlantEmploymentOfficeHistory().getItemOrNull(effectiveTP, validTP)) != null && !StringMapper.isNullString((String)peo.getGeneralEmploymentOffice().getEmployerNumber())) {
            result = peo.getGeneralEmploymentOffice();
        }
        if (result == null && (ceo = (CompanyEmploymentOffice)pCompany.getCompanyEmploymentOfficeHistory().getItemOrNull(effectiveTP, validTP)) != null) {
            result = ceo.getGeneralEmploymentOffice();
        }
        return result;
    }

    public static String getMainEmployerNumber(Employee employee, Date effectiveTP, Date validTP) throws BusinessDomainException {
        Plant plant = employee.getAppurtenantPlant(effectiveTP, validTP);
        return DEUVAdvice.getMainEmployerNumber(employee.getPCompany(), plant, validTP);
    }

    public static String getMainEmployerNumber(PCompany pCompany, Plant plant, Date validTP) throws BusinessDomainException {
        boolean soCForCompany = pCompany.getCompanySettings(VDate.getDateMax(), validTP).getStatementOfContributionProCompany();
        GeneralEmploymentOffice geo = soCForCompany ? DEUVAdvice.getGeneralEmploymentOffice(pCompany, null, validTP) : DEUVAdvice.getGeneralEmploymentOffice(pCompany, plant, validTP);
        String mainEmployerNumber = StringMapper.isNullString((String)geo.getDifferentMainEmployerNumber()) ? geo.getEmployerNumber() : geo.getDifferentMainEmployerNumber();
        return mainEmployerNumber;
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    public boolean isPreview() {
        return this.mPreview;
    }

    public void addPreviewAccounts(Collection<DEUVAccount> accounts) {
        for (DEUVAccount account : accounts) {
            account.setDEUVEmployee(null);
            account.makeReadOnly();
            this.mPreviewAccounts.add(account);
        }
    }

    public boolean isAffectedBySpecialAccess() {
        return this.mAffectedBySpecialAccess;
    }

    public void setAffectedBySpecialAccess(boolean affectedBySpecialAccess) {
        this.mAffectedBySpecialAccess = affectedBySpecialAccess;
    }

    public HashSet<String> getInsuranceNoBlackList() {
        if (this.mInsuranceNoBlackList == null) {
            this.mInsuranceNoBlackList = DeuvHelper.getInsuranceNoBlackList();
        }
        return this.mInsuranceNoBlackList;
    }

    public String toString() {
        return this.mCreatedOn + " " + this.mCounter;
    }

    public Date getCalculationHistoric() throws BusinessDomainException {
        IEECalculationHistoric ch = (IEECalculationHistoric)UtilitiesManager.getBean((String)"eeCalculationHistoric", IEECalculationHistoric.class);
        return ch.getCalculationHistoric(this.getCalculationStart());
    }
}

