/*
 * Decompiled with CFR 0.152.
 */
package com.varial.transfer.domain.accounting.invoicetransaction;

import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBasePersistencyManager;
import com.varial.accounting.domain.personalaccount.Supplier;
import com.varial.accounting.domain.purchaseregister.PurchaseInvoiceRegisterStatus;
import com.varial.accounting.domain.purchaseregister.PurchaseRegisterInvoice;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.framework.domain.transfer.TransferConfigPersistencyManager;
import com.varial.transfer.base.TransferExceptionMapper;
import com.varial.transfer.domain.accounting.invoicetransaction.AbstractPurchaseRegisterReplacer;
import com.varial.transfer.domain.accounting.invoicetransaction.TransferInvoice;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class InvoicePurchaseRegisterReplacer
extends AbstractPurchaseRegisterReplacer {
    public InvoicePurchaseRegisterReplacer(TransferInvoice invoice) {
        super(invoice);
    }

    protected void searchOldInvoice() throws BusinessDomainException {
        List invoices = Collections.emptyList();
        boolean checkRefNumber = false;
        boolean allowNew = false;
        if (TransferConfigPersistencyManager.getTransferConfig().isPurchaseInvoiceRegisterImport()) {
            invoices = NominalTransactionBasePersistencyManager.getPurchaseRegisterInvoices((Supplier)this.getSupplier(), (String)this.transferInvoice.getReferenceNumber(), (Date)this.transferInvoice.getDocumentDate());
            checkRefNumber = false;
            allowNew = TransferConfigPersistencyManager.getTransferConfig().isPurchaseInvoiceRegisterAllowNew();
        } else if (ISoftware.getUpdatePurchaseRegister()) {
            invoices = NominalTransactionBasePersistencyManager.getPurchaseRegisterInvoicesISW((Supplier)this.getSupplier(), (String)this.transferInvoice.getSequenceNumber());
            checkRefNumber = true;
            allowNew = false;
        }
        if (invoices.size() > 1) {
            throw TransferExceptionMapper.makeSeveralPurchaseRegisterInvoicesFoundDomainException((String)this.transferInvoice.getReferenceNumber());
        }
        if (!invoices.isEmpty()) {
            this.oldInvoice = (PurchaseRegisterInvoice)invoices.get(0);
            if (checkRefNumber && !this.oldInvoice.getReferenceNumber().equals(this.transferInvoice.getReferenceNumber())) {
                throw TransferExceptionMapper.makeReferenceNumberDoesNotMatchDomainException((String)this.transferInvoice.getReferenceNumber());
            }
        } else if (!allowNew) {
            throw TransferExceptionMapper.makeNoPurchaseRegisterInvoiceFoundDomainException((String)this.transferInvoice.getReferenceNumber());
        }
    }

    protected PurchaseInvoiceRegisterStatus getStatus() {
        if (ISoftware.getImportREBWithStatusNEW()) {
            return this.oldInvoice == null ? PurchaseInvoiceRegisterStatus.NEW : PurchaseInvoiceRegisterStatus.UPDATED_BY_ERP;
        }
        return this.oldInvoice == null ? PurchaseInvoiceRegisterStatus.CREATED_BY_ERP : PurchaseInvoiceRegisterStatus.UPDATED_BY_ERP;
    }
}

