/*
 * Decompiled with CFR 0.152.
 */
package com.varial.transfer.domain.accounting.invoicetransaction;

import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBasePersistencyManager;
import com.varial.accounting.domain.personalaccount.Supplier;
import com.varial.accounting.domain.purchaseregister.PurchaseInvoiceRegisterStatus;
import com.varial.accounting.domain.purchaseregister.PurchaseRegisterInvoice;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.framework.domain.transfer.TransferConfigPersistencyManager;
import com.varial.transfer.base.TransferExceptionMapper;
import com.varial.transfer.domain.accounting.invoicetransaction.AbstractPurchaseRegisterReplacer;
import com.varial.transfer.domain.accounting.invoicetransaction.TransferInvoice;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class CreditNotePurchaseRegisterReplacer
extends AbstractPurchaseRegisterReplacer {
    public CreditNotePurchaseRegisterReplacer(TransferInvoice invoice) {
        super(invoice);
    }

    protected void searchOldInvoice() throws BusinessDomainException {
        List creditNotes = Collections.emptyList();
        boolean allowNew = false;
        if (TransferConfigPersistencyManager.getTransferConfig().isPurchaseInvoiceRegisterImport()) {
            creditNotes = NominalTransactionBasePersistencyManager.getPurchaseRegisterCreditNotes((Supplier)this.getSupplier(), (String)this.transferInvoice.getReferenceNumber(), (Date)this.transferInvoice.getDocumentDate());
            allowNew = TransferConfigPersistencyManager.getTransferConfig().isPurchaseInvoiceRegisterAllowNew();
        } else if (ISoftware.getUpdatePurchaseRegister()) {
            creditNotes = NominalTransactionBasePersistencyManager.getPurchaseRegisterCreditNotesISW((Supplier)this.getSupplier(), (String)this.transferInvoice.getReferenceNumber());
            allowNew = true;
        }
        if (creditNotes.size() > 1) {
            throw TransferExceptionMapper.makeSeveralPurchaseRegisterInvoicesFoundDomainException((String)this.transferInvoice.getReferenceNumber());
        }
        if (!creditNotes.isEmpty()) {
            this.oldInvoice = (PurchaseRegisterInvoice)creditNotes.get(0);
        } else if (!allowNew) {
            throw TransferExceptionMapper.makeNoPurchaseRegisterInvoiceFoundDomainException((String)this.transferInvoice.getReferenceNumber());
        }
    }

    protected PurchaseInvoiceRegisterStatus getStatus() {
        if (ISoftware.getImportREBWithStatusNEW()) {
            return this.oldInvoice == null ? PurchaseInvoiceRegisterStatus.NEW : PurchaseInvoiceRegisterStatus.UPDATED_BY_ERP;
        }
        return this.oldInvoice == null ? PurchaseInvoiceRegisterStatus.CREATED_BY_ERP : PurchaseInvoiceRegisterStatus.UPDATED_BY_ERP;
    }
}

