/*
 * Decompiled with CFR 0.152.
 */
package com.varial.framework.servantimpl.printdocument;

import com.infor.igf.ca.model.common.ObjectIdentifierModel;
import com.infor.igf.ca.model.printdocument.EInvoiceArchiveModel;
import com.infor.igf.ca.model.printdocument.EInvoiceModel;
import com.infor.igf.ca.model.printdocument.PrintArchiveModel;
import com.infor.igf.ca.model.printdocument.PrintDocumentModel;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.AbstractApplicationService;
import com.varial.framework.domain.company.Company;
import com.varial.framework.domain.company.CompanyPersistencyManager;
import com.varial.framework.domain.printdocument.DocumentCategoryArchivType;
import com.varial.framework.domain.printdocument.EInvoiceDocType;
import com.varial.framework.domain.printdocument.IPrintDocumentManager;
import com.varial.framework.domain.printdocument.PrintDocument;
import com.varial.framework.domain.printdocument.PrintDocumentExceptionMapper;
import com.varial.framework.domain.systemoptions.SystemOptionsExt;
import com.varial.framework.domain.systemoptions.SystemOptionsExtPersistencyManager;
import com.varial.framework.servantimpl.printdocument.PrintDocumentMapper;
import com.varial.framework.servantimpl.printdocument.PrintDocumentServantService;
import com.varial.license.service.ILicenseService;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PrintDocumentServantImpl
extends AbstractApplicationService
implements PrintDocumentServantService {
    private final IPrintDocumentManager manager = (IPrintDocumentManager)UtilitiesManager.getApplicationContext().getBean("printDocumentManager");
    private static final ILicenseService licenseService = (ILicenseService)UtilitiesManager.getBean((String)"licenseService", ILicenseService.class);
    private static final String licenceForEInvoice = "AC5034";
    private static final String EMPTY_STRING = "";
    private static DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PrintDocumentModel> getPrintDocuments(AuthorizationToken token) throws BusinessDomainException {
        try {
            this.beginQueryService();
            String userid = token.getUserId();
            List printDocuments = this.manager.getPrintDocumentsByUser(userid);
            List list = PrintDocumentMapper.getInstance().toModel(printDocuments);
            return list;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PrintDocumentModel> getAllPrintDocuments(AuthorizationToken token) throws BusinessDomainException {
        try {
            this.beginQueryService();
            List printDocuments = this.manager.getPrintDocuments();
            List list = PrintDocumentMapper.getInstance().toModel(printDocuments);
            return list;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintDocumentModel getPrintDocumentByCode(AuthorizationToken token, String code) throws BusinessDomainException {
        try {
            this.beginQueryService();
            String userid = token.getUserId();
            PrintDocument printDocument = this.manager.getPrintDocumentByUserAndCode(userid, code);
            PrintDocumentModel printDocumentModel = PrintDocumentMapper.getInstance().toModel(printDocument);
            return printDocumentModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prepareDisplayAdhocJob(AuthorizationToken token, String oidPrintDocument) throws BusinessDomainException {
        try {
            this.beginUpdateService();
            String userid = token.getUserId();
            String url = this.manager.prepareAdhocJob(userid, oidPrintDocument);
            this.getContext().flush();
            String string = url;
            return string;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePrintDocuments(AuthorizationToken token, List<ObjectIdentifierModel> oidTs) throws BusinessDomainException {
        try {
            this.beginUpdateService();
            ArrayList<String> objectids = new ArrayList<String>();
            for (int i = 0; i < oidTs.size(); ++i) {
                String objectid = oidTs.get(i).getObjectID();
                objectids.add(objectid);
            }
            this.manager.deletePrintDocuments(objectids);
            this.getContext().flush();
        }
        finally {
            this.endService();
        }
    }

    public void deletePrintDocumentsByPrintDocument(AuthorizationToken token, List<PrintDocumentModel> printDocuments) throws BusinessDomainException {
        try {
            this.beginUpdateService();
            this.manager.deletePrintDocumentsByPrintDocument(token.getUserId(), PrintDocumentMapper.getInstance().toPrintDocument(printDocuments));
            this.getContext().flush();
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintArchiveModel getPrintArchiveZip(AuthorizationToken token, List<String> documentIds) throws BusinessDomainException {
        try {
            this.beginQueryService();
            PrintArchiveModel printArchiveModel = PrintDocumentMapper.getInstance().toModel(this.manager.getPrintArchiveZip(token.getUserId(), documentIds));
            return printArchiveModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintArchiveModel getArchivedReceipt(AuthorizationToken token, String companyCode, String financialYearCode, String accountCode, String referenceNumber, String sequenceNumber, String orderNumber, DocumentCategoryArchivType documentCategoryArchivType) throws BusinessDomainException {
        try {
            this.beginQueryService();
            if (!licenseService.isLicensed("WARFW")) {
                throw PrintDocumentExceptionMapper.makeOnlineSearchNotLicensedDomainException();
            }
            SystemOptionsExt soExt = SystemOptionsExtPersistencyManager.load();
            SystemOptionsExt.OnlineSearchMode searchMode = soExt.getOnlineSearchMode();
            String searchNumber = EMPTY_STRING;
            if (searchMode != null) {
                switch (searchMode) {
                    case SEQUENCENUMBER: {
                        searchNumber = sequenceNumber;
                        break;
                    }
                    case REFERENCENUMBER: {
                        searchNumber = referenceNumber;
                        break;
                    }
                    case ORDERNUMBER: {
                        searchNumber = orderNumber;
                        break;
                    }
                }
            }
            if (StringMapper.isNullString((String)searchNumber)) {
                throw PrintDocumentExceptionMapper.makeNoValidSearchForOnlineRechercheDomainException();
            }
            String receiptKey = "FB BELEG \"" + companyCode + "\" \"" + financialYearCode + "\" \"" + accountCode + "\" \"" + searchNumber + "\"";
            if (documentCategoryArchivType != DocumentCategoryArchivType.OTHER) {
                receiptKey = receiptKey + " " + documentCategoryArchivType.persistentValue();
            }
            PrintArchiveModel printArchiveModel = PrintDocumentMapper.getInstance().toModel(this.manager.getArchivedReceipt(receiptKey));
            return printArchiveModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EInvoiceModel> getEInvoices(AuthorizationToken token, String oidCompany, String fromDate, String toDate, EInvoiceDocType eInvoiceType) throws BusinessDomainException {
        try {
            this.beginQueryService();
            if (!licenseService.isLicensed(licenceForEInvoice)) {
                throw PrintDocumentExceptionMapper.makeEInvoiceNotLicensedDomainException();
            }
            Company company = CompanyPersistencyManager.getCompany((String)oidCompany);
            Date fromEInvoiceDate = DateMapper.toDate((String)fromDate);
            Date toEInvoiceDate = DateMapper.toDate((String)toDate);
            List list = this.manager.getEInvoiceModels(company.getCode(), fromEInvoiceDate, toEInvoiceDate, eInvoiceType);
            return list;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EInvoiceArchiveModel getEInvoiceZIP(AuthorizationToken token, String oidCompany, String fileName) throws BusinessDomainException {
        try {
            this.beginQueryService();
            if (!licenseService.isLicensed(licenceForEInvoice)) {
                throw PrintDocumentExceptionMapper.makeEInvoiceNotLicensedDomainException();
            }
            Company company = CompanyPersistencyManager.getCompany((String)oidCompany);
            EInvoiceArchiveModel eInvoiceArchiveModel = this.manager.getArchivedEInvoice(company.getCode(), fileName);
            return eInvoiceArchiveModel;
        }
        finally {
            this.endService();
        }
    }
}

