/*
 * Decompiled with CFR 0.152.
 */
package com.varial.framework.domain.country.vatcheck.bzst;

import com.varial.base.vat.VATNumber;
import com.varial.base.vat.bzstrestclient.BZStRestClient;
import com.varial.base.vat.bzstrestclient.VATRestMapper;
import com.varial.base.vat.bzstrestclient.VatQualifiedRestRequest;
import com.varial.base.vat.bzstrestclient.VatRestResponse;
import com.varial.framework.domain.country.vatcheck.IVATQualifiedCheckService;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheck;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheckRequest;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheckResultType;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheckService;
import com.varial.interfaces.IAccountingCompany;
import com.varial.serverbase.mapper.StringMapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BzstVATRestQualifiedCheckService
extends VATQualifiedCheckService
implements IVATQualifiedCheckService {
    private static final Pattern EVATR_CODE_PATTERN = Pattern.compile("evatr[-\\.]\\d{4}", 2);

    private BzstVATRestQualifiedCheckService() {
    }

    public static BzstVATRestQualifiedCheckService getInstance() {
        return SingletonHelper.INSTANCE;
    }

    @Override
    public VATQualifiedCheck checkVat(VATNumber requesterVAT, VATQualifiedCheckRequest request, IAccountingCompany company) {
        String traderName = this.toBzstString(request.getTraderName());
        String traderCity = this.toBzstString(request.getTraderCity());
        String traderPostcode = this.toBzstString(request.getTraderPostcode());
        String traderStreet = this.toBzstString(request.getTraderStreet());
        try {
            VatQualifiedRestRequest restReq = new VatQualifiedRestRequest(requesterVAT.getCountryCode() + requesterVAT.getVatNumber(), request.getLookupVAT().getCountryCode() + request.getLookupVAT().getVatNumber(), traderName, traderStreet, traderPostcode, traderCity);
            BZStRestClient client = new BZStRestClient();
            VatRestResponse restResp = client.checkQualified(restReq);
            VATQualifiedCheck result = VATRestMapper.toVATQualifiedCheckMapper(restResp, traderName, traderStreet, traderPostcode, traderCity, request.getLookupVAT().getVatNumber());
            if (request.isWithCofirmationLetter()) {
                result.setConfirmLetter(true);
            }
            if (!company.getNote().contains("show_evatr-codes")) {
                BzstVATRestQualifiedCheckService.applyLegacyResponseCode(result, restResp);
            }
            return result;
        }
        catch (IOException e) {
            String code = BzstVATRestQualifiedCheckService.extractEvatrCode(e);
            return this.toUncheckedResponse(code != null ? code : "io_exception", request, company);
        }
        catch (RuntimeException e) {
            String code = BzstVATRestQualifiedCheckService.extractEvatrCode(e);
            return this.toUncheckedResponse(code != null ? code : "runtime_exception", request, company);
        }
    }

    private static String extractEvatrCode(Throwable t) {
        while (t != null) {
            Matcher m2;
            try {
                String s;
                Matcher mm;
                Method m = t.getClass().getMethod("getDetailMessage", new Class[0]);
                Object v = m.invoke((Object)t, new Object[0]);
                if (v instanceof String && (mm = EVATR_CODE_PATTERN.matcher(s = (String)v)).find()) {
                    return mm.group().toLowerCase().replace('.', '-');
                }
            }
            catch (Exception m) {
                // empty catch block
            }
            String msg = t.getMessage();
            if (msg != null && (m2 = EVATR_CODE_PATTERN.matcher(msg)).find()) {
                return m2.group().toLowerCase().replace('.', '-');
            }
            t = t.getCause();
        }
        return null;
    }

    private static String mapRestStatusToLegacyVatCode(String status) {
        String s;
        if (status == null) {
            return "VAT-999";
        }
        switch (s = status.trim().toLowerCase(Locale.ROOT)) {
            case "evatr-0000": 
            case "evatr-2008": {
                return "VAT-200";
            }
            case "evatr-0004": 
            case "evatr-2005": {
                return "VAT-206";
            }
            case "evatr-0005": 
            case "evatr-0012": {
                return "VAT-209";
            }
            case "evatr-2003": {
                return "VAT-201";
            }
            case "evatr-2001": {
                return "VAT-202";
            }
            case "evatr-2002": {
                return "VAT-203";
            }
            case "evatr-2006": {
                return "VAT-204";
            }
            case "evatr-0006": {
                return "VAT-103";
            }
            case "evatr-0002": {
                return "VAT-215";
            }
            case "evatr-0003": {
                return "VAT-216";
            }
            case "evatr-0007": {
                return "VAT-221";
            }
            case "evatr-2007": {
                return "VAT-217";
            }
            case "evatr-0001": 
            case "evatr-0008": 
            case "evatr-0011": 
            case "evatr-0013": 
            case "evatr-1001": 
            case "evatr-1002": 
            case "evatr-1003": 
            case "evatr-1004": 
            case "evatr-2004": 
            case "evatr-2011": 
            case "evatr-3011": {
                return "VAT-999";
            }
        }
        return "VAT-999";
    }

    private static void applyLegacyResponseCode(VATQualifiedCheck result, VatRestResponse restResp) {
        String code = BzstVATRestQualifiedCheckService.mapRestStatusToLegacyVatCode(restResp != null ? restResp.status : null);
        result.setResponseCode(code);
    }

    private String toBzstString(String s) {
        return StringMapper.toStringWithTrim((String)s);
    }

    private VATQualifiedCheck toUncheckedResponse(String responseCode, VATQualifiedCheckRequest req, IAccountingCompany company) {
        if (!company.getNote().contains("show_evatr-codes")) {
            responseCode = BzstVATRestQualifiedCheckService.mapRestStatusToLegacyVatCode(responseCode);
        }
        return new VATQualifiedCheck(VATQualifiedCheckResultType.UNCHECKED, VATQualifiedCheckResultType.UNCHECKED, VATQualifiedCheckResultType.UNCHECKED, VATQualifiedCheckResultType.UNCHECKED, VATQualifiedCheckResultType.UNCHECKED, new Date(), responseCode, req.getLookupVAT().getVatNumber(), null, null, null, req.isWithCofirmationLetter());
    }

    private static class SingletonHelper {
        private static final BzstVATRestQualifiedCheckService INSTANCE = new BzstVATRestQualifiedCheckService();

        private SingletonHelper() {
        }
    }
}

