/*
 * Decompiled with CFR 0.152.
 */
package com.varial.base.vat.bzstrestclient;

import com.varial.base.vat.bzstrestclient.VatRestResponse;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheck;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheckResultType;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class VATRestMapper {
    private static final Map<String, VATQualifiedCheckResultType> STATUS_MAP;

    private VATRestMapper() {
    }

    public static VATQualifiedCheck toVATQualifiedCheckMapper(VatRestResponse resp, String reqName, String reqStreet, String reqPlz, String reqTown, String lookupVatId) {
        VATQualifiedCheckResultType nameMatch = VATRestMapper.mapToVATQualifiedCeckResultTypeFromResponseAOrB(resp.ergFirmenname);
        VATQualifiedCheckResultType streetMatch = VATRestMapper.mapToVATQualifiedCeckResultTypeFromResponseAOrB(resp.ergStrasse);
        VATQualifiedCheckResultType plzMatch = VATRestMapper.mapToVATQualifiedCeckResultTypeFromResponseAOrB(resp.ergPlz);
        VATQualifiedCheckResultType townMatch = VATRestMapper.mapToVATQualifiedCeckResultTypeFromResponseAOrB(resp.ergOrt);
        VATQualifiedCheckResultType responseMatch = VATRestMapper.interpretStatus(resp.status);
        Date responseDateTime = resp.anfrageZeitpunkt == null ? null : Date.from(resp.anfrageZeitpunkt.toInstant());
        Date validFrom = resp.gueltigAb == null ? null : Date.from(resp.gueltigAb.atStartOfDay(ZoneId.systemDefault()).toInstant());
        Date validTo = resp.gueltigBis == null ? null : Date.from(resp.gueltigBis.atStartOfDay(ZoneId.systemDefault()).toInstant());
        return new VATQualifiedCheck(nameMatch, streetMatch, plzMatch, townMatch, responseMatch, responseDateTime, resp.status, lookupVatId, validFrom, validTo, null, false);
    }

    private static VATQualifiedCheckResultType mapToVATQualifiedCeckResultTypeFromResponseAOrB(String v) {
        if (v == null || v.trim().isEmpty()) {
            return VATQualifiedCheckResultType.UNCHECKED;
        }
        return v.trim().equalsIgnoreCase("A") ? VATQualifiedCheckResultType.VALID : VATQualifiedCheckResultType.INVALID;
    }

    private static VATQualifiedCheckResultType interpretStatus(String status) {
        if (status == null) {
            return VATQualifiedCheckResultType.UNCHECKED;
        }
        String key = status.trim().toLowerCase(Locale.ROOT);
        return STATUS_MAP.getOrDefault(key, VATQualifiedCheckResultType.UNCHECKED);
    }

    static {
        HashMap<String, VATQualifiedCheckResultType> m = new HashMap<String, VATQualifiedCheckResultType>();
        m.put("evatr-0000", VATQualifiedCheckResultType.VALID);
        m.put("evatr-2008", VATQualifiedCheckResultType.VALID);
        m.put("evatr-0004", VATQualifiedCheckResultType.INVALID);
        m.put("evatr-0005", VATQualifiedCheckResultType.INVALID);
        m.put("evatr-0012", VATQualifiedCheckResultType.INVALID);
        m.put("evatr-2001", VATQualifiedCheckResultType.INVALID);
        m.put("evatr-2002", VATQualifiedCheckResultType.INVALID);
        m.put("evatr-2003", VATQualifiedCheckResultType.INVALID);
        m.put("evatr-2005", VATQualifiedCheckResultType.INVALID);
        m.put("evatr-2006", VATQualifiedCheckResultType.INVALID);
        m.put("evatr-0001", VATQualifiedCheckResultType.UNCHECKED);
        m.put("evatr-0002", VATQualifiedCheckResultType.UNCHECKED);
        m.put("evatr-0003", VATQualifiedCheckResultType.UNCHECKED);
        m.put("evatr-0006", VATQualifiedCheckResultType.UNCHECKED);
        m.put("evatr-0007", VATQualifiedCheckResultType.UNCHECKED);
        m.put("evatr-0008", VATQualifiedCheckResultType.UNCHECKED);
        m.put("evatr-0011", VATQualifiedCheckResultType.UNCHECKED);
        m.put("evatr-0013", VATQualifiedCheckResultType.UNCHECKED);
        m.put("evatr-1001", VATQualifiedCheckResultType.UNCHECKED);
        m.put("evatr-1002", VATQualifiedCheckResultType.UNCHECKED);
        m.put("evatr-1003", VATQualifiedCheckResultType.UNCHECKED);
        m.put("evatr-1004", VATQualifiedCheckResultType.UNCHECKED);
        m.put("evatr-2004", VATQualifiedCheckResultType.UNCHECKED);
        m.put("evatr-2007", VATQualifiedCheckResultType.UNCHECKED);
        m.put("evatr-2011", VATQualifiedCheckResultType.UNCHECKED);
        m.put("evatr-3011", VATQualifiedCheckResultType.UNCHECKED);
        STATUS_MAP = Collections.unmodifiableMap(m);
    }
}

