/*
 * Decompiled with CFR 0.152.
 */
package com.varial.base.vat.bzstrestclient;

import com.varial.base.vat.VATException;
import com.varial.base.vat.VATNumber;
import com.varial.base.vat.support.VATExceptionMessages;
import java.util.ArrayList;
import java.util.List;

public class BZStRestSimpleRequestBuilder {
    private final VATNumber lookupVAT;
    private final VATNumber requesterVAT;

    public BZStRestSimpleRequestBuilder(VATNumber lookupVAT, VATNumber requesterVAT) throws VATException {
        if (requesterVAT == null) {
            throw new VATException(VATExceptionMessages.getRequesterVatIdEmpty());
        }
        if (!requesterVAT.isGermany()) {
            throw new VATException(VATExceptionMessages.getRequesterVatIdMustBeGerman());
        }
        if (lookupVAT == null) {
            throw new VATException(VATExceptionMessages.getLookupVatIdEmpty());
        }
        if (lookupVAT.isGermany()) {
            throw new VATException(VATExceptionMessages.getLookupVatIdMustNotBeGerman());
        }
        this.lookupVAT = lookupVAT;
        this.requesterVAT = requesterVAT;
    }

    public List<String> build() {
        ArrayList<String> request = new ArrayList<String>();
        request.add(this.requesterVAT.getCountryCode() + this.requesterVAT.getVatNumber());
        request.add(this.lookupVAT.getCountryCode() + this.lookupVAT.getVatNumber());
        request.add("");
        request.add("");
        request.add("");
        request.add("");
        request.add("");
        return request;
    }

    public String toString() {
        return String.format("BZStRestSimpleValidationRequestBuilder [lookupVAT=%s, requesterVAT=%s]", this.lookupVAT, this.requesterVAT);
    }
}

