/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.personalaccountreport;

import com.varial.accounting.domain.openitem.OpenItemDataSelector;
import com.varial.accounting.domain.personalaccountreport.PersonalAccountReportFilterMapper;
import com.varial.accounting.domain.personalaccountreport.PersonalAccountReportHelper;
import com.varial.accounting.domain.personalaccountreport.PersonalAccountReportPresetData;
import com.varial.accounting.domain.personalaccountreport.PersonalAccountReportPresetHelper;
import com.varial.accounting.domain.personalaccountreport.PersonalAccountStatementOfAccountReportDataSource;
import com.varial.accounting.domain.personalaccountreport.ShippmentTypeEnum;
import com.varial.accounting.domain.personalaccountreport.protocol.PresetProtocolHelperBalanceAcknowledgement;
import com.varial.accounting.personalaccountreport.AnswerPrintSequenceEnum;
import com.varial.accounting.personalaccountreport.BalancedOpenItemsEnum;
import com.varial.accounting.personalaccountreport.OIHistoryTypeEnum;
import com.varial.accounting.personalaccountreport.PrintAssociationEnum;
import com.varial.base.UtilitiesManager;
import com.varial.base.callback.TransactionMode;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.mail.Credentials;
import com.varial.base.mail.EmailAddress;
import com.varial.base.mail.EmailAddressFactory;
import com.varial.base.mail.MailException;
import com.varial.base.mail.MailManager;
import com.varial.base.persistency.PersistencySession;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.ApplicationServiceAdapter;
import com.varial.base.service.TransactionStatusHolder;
import com.varial.base.service.TransactionalServiceAdapter;
import com.varial.base.session.SessionContext;
import com.varial.base.text.TextFactory;
import com.varial.base.types.enums.PersistentEnumUtils;
import com.varial.dao.dcp.DCPModel;
import com.varial.framework.basictypes.ReportMediaType;
import com.varial.framework.basictypes.ServiceTypeEnum;
import com.varial.framework.domain.mail.MailChecker;
import com.varial.framework.domain.mail.MailExceptionMapper;
import com.varial.framework.domain.mailprotocol.MailProtocol;
import com.varial.framework.domain.mailprotocol.MailProtocolEntry;
import com.varial.framework.domain.mailprotocol.MailProtocolProgramEnum;
import com.varial.framework.domain.mailprotocol.MailProtocolReportDataSource;
import com.varial.framework.domain.printdocument.ReportType;
import com.varial.framework.domain.printservice.PrintService;
import com.varial.framework.domain.printservice.PrintServicePersistencyManager;
import com.varial.framework.domain.protocolreports.PresetProtocolReportContainer;
import com.varial.framework.domain.protocolreports.PresetProtocolReportDataSource;
import com.varial.framework.domain.reports.JasperReportCompiler;
import com.varial.framework.domain.reports.JasperReportFaxDataSource;
import com.varial.framework.domain.reports.JasperReportManager;
import com.varial.framework.domain.reports.JasperReportTranslateableResource;
import com.varial.framework.domain.reports.MergePrintoutToOneFileEnum;
import com.varial.framework.domain.reports.PrintJob;
import com.varial.framework.domain.reports.ReportExceptionMapper;
import com.varial.framework.domain.reports.ReportPresetInterface;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.domain.language.LanguageManager;
import com.varial.serverbase.domain.sort.Sort;
import com.varial.serverbase.domain.sort.SortElement;
import com.varial.serverbase.domain.user.IUserPersistencyManager;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.SelectGeneratorDataSet;
import com.varial.serverbase.query.PutDataException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRSwapFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonalAccountStatementOfAccountReportPrint {
    private static final IUserPersistencyManager userPersistencyManager = (IUserPersistencyManager)UtilitiesManager.getBean((String)"userPersistencyManager", IUserPersistencyManager.class);
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)PersonalAccountStatementOfAccountReportPrint.class.getName());
    protected static final String PDFFILE_PROTOCOL_PREFIX = "PPR";
    private final Configuration configuration = (Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class);
    private String[] mErrorMessagesLanguageForTextNotFound = null;
    protected JasperReport mJasperReportMailProtocol;
    protected MailProtocol mMailProtocol;
    protected EmailAddress mFromEmailAddress;
    protected MailManager mMailManager;
    protected String mEmailBCC;
    public static final String STATEMENTOFACCOUNT_DEFAULT_XML = "com/varial/accounting/jasperreport/personalaccountreport/PersonalAccountStatementOfAccountReport.jrxml";
    public static final String PROPKEY_STATEMENTOFACCOUNTXML = "com.varial.reports.AlternativeAgingStatementXML";
    private static final String PDFFILE_PREFIX = "SOA";
    private static final String PDFFILE_EMAILPREFIX = "ByEmail_SOA";
    private static final String PDFFILE_FAXPREFIX = "FAX";
    private static final String PDFFILE_ANSWERLETTER_PREFIX = "AWL";
    private static final String EMAIL_CC_MARKER = "cc";
    private static final String XML_PATH = "com/varial/accounting/jasperreport/personalaccountreport/";
    protected final AuthorizationToken mToken;
    private final ApplicationServiceAdapter mAdapter;
    protected final String mRight;
    protected final PersonalAccountReportPresetData mPreset;
    protected Language mGlobalLanguage;
    protected Language mSelectedLanguage;
    protected String mPrintTime;
    protected ReportMediaType mOutputFormat;
    protected boolean mIsAdditionalOutputArchive;
    protected boolean mPrintHeaderCSV;
    protected final TransactionMode mMode;
    protected ServiceTypeEnum mServiceType;
    protected PersonalAccountReportPresetData[] mPresets;
    protected List<String> mResultList;
    protected List<String> mMergedResultList;
    protected List<URL> mURLs;
    public PersonalAccountStatementOfAccountReportDataSource mDataSource;
    protected List<String> mProtocolMessages;
    protected boolean mIsMultiCompanyPrintout = false;
    protected boolean mExceptionIsThrown = false;
    protected boolean mMergePrintoutToOneFile = false;
    protected List<String> mOidsCheckedFurtherCompanies;
    protected ReportType mReportTypeForOutputManager;
    protected PrintJob.PrintJobType mPrintJobType;
    protected PrintService mPrintService;
    protected int mLeftMargin;
    protected int mTopMargin;
    protected String mOidUserReport;
    protected List<String> mHasAccessToPrivateAccounts;
    private final ReportType mReportType;
    private String mReportDescrWIN = "";

    public PersonalAccountStatementOfAccountReportPrint(AuthorizationToken token, String right, PersonalAccountReportPresetData preset, String oidGlobalLanguage, ReportMediaType outputFormat, String printTime, TransactionMode mode, List<String> oidsCheckedFurtherCompanies, ReportType reportType, PrintJob.PrintJobType printJobType, String oidReportingService, boolean isAdditionalOutputArchive, boolean printHeaderCSV, int leftMargin, int topMargin, String oidUserReport) throws BusinessDomainException {
        this.mToken = token;
        this.mAdapter = new ApplicationServiceAdapter();
        this.mRight = right;
        this.mPreset = preset;
        this.mOutputFormat = outputFormat;
        this.mIsAdditionalOutputArchive = isAdditionalOutputArchive;
        this.mPrintHeaderCSV = printHeaderCSV;
        this.mPrintTime = printTime;
        this.mMode = mode;
        this.mGlobalLanguage = LanguageManager.getInstance().getLanguage(oidGlobalLanguage);
        this.mReportTypeForOutputManager = reportType;
        this.mPrintJobType = printJobType;
        this.mResultList = new ArrayList<String>();
        this.mMergedResultList = new ArrayList<String>();
        this.mURLs = new ArrayList<URL>();
        this.mProtocolMessages = new ArrayList<String>();
        this.mOidsCheckedFurtherCompanies = oidsCheckedFurtherCompanies;
        this.mPresets = this.getReportPresets(this.mPreset);
        this.mSelectedLanguage = this.mPresets[0].getReportLanguage();
        this.mIsMultiCompanyPrintout = this.mPresets.length > 1 || this.mPreset.getIsMultiCompanyPrintout();
        MergePrintoutToOneFileEnum mergePrintoutToOneFile = (MergePrintoutToOneFileEnum)PersistentEnumUtils.persistentValueOf(MergePrintoutToOneFileEnum.class, (int)this.configuration.mergePrintoutToOneFile());
        this.mMergePrintoutToOneFile = this.mOutputFormat == ReportMediaType.PDF && (mergePrintoutToOneFile == MergePrintoutToOneFileEnum.ALWAYS || mergePrintoutToOneFile == MergePrintoutToOneFileEnum.IF_MULTI_COMPANY_PRINTOUT && this.mIsMultiCompanyPrintout);
        this.mReportDescrWIN = preset.getName();
        this.mPrintService = null;
        if (!StringMapper.isNullString((String)oidReportingService)) {
            this.mPrintService = PrintServicePersistencyManager.getPrintService((String)oidReportingService);
            if (this.mPrintService != null) {
                this.mReportDescrWIN = this.mReportDescrWIN.concat(" / ").concat(this.mPrintService.getName());
            }
        }
        this.mReportType = reportType;
        this.mLeftMargin = leftMargin;
        this.mTopMargin = topMargin;
        this.mOidUserReport = oidUserReport;
    }

    public PersistencySession getContext() {
        return this.mAdapter.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BusinessDomainException, JRException, IOException {
        for (int i = 0; i < this.mPresets.length; ++i) {
            if (this.mIsMultiCompanyPrintout) {
                if (i == 0) {
                    this.mPresets[i].setIsFurtherCompanyPreset(false);
                } else {
                    this.mPresets[i].setIsFurtherCompanyPreset(true);
                }
            }
            if (this.mMode != TransactionMode.NONE) {
                this.runOutputCreation(this.mPresets[i], null);
                continue;
            }
            TransactionalServiceAdapter txAdapter = new TransactionalServiceAdapter();
            TransactionStatusHolder txHolder = new TransactionStatusHolder();
            try {
                txHolder.setTransactionStatus(txAdapter.getUpdateTransaction());
                this.mAdapter.beginUpdateService();
                try {
                    this.runOutputCreation(this.mPresets[i], txHolder);
                    this.mAdapter.getContext().flush();
                }
                finally {
                    this.mAdapter.endService();
                }
                if (!txHolder.hasTransactionStatus()) continue;
                txAdapter.commit(txHolder.getTransactionStatus());
                continue;
            }
            catch (RuntimeException e) {
                LOGGER.error(TextFactory.makeErrorMethod((String)"ReportPrintBase", (String)"execute"), (Throwable)e);
                if (txHolder.hasTransactionStatus()) {
                    txAdapter.rollbackOnException(txHolder.getTransactionStatus(), (Throwable)e);
                }
                throw e;
            }
            catch (Error e) {
                LOGGER.error(TextFactory.makeErrorMethod((String)"ReportPrintBase", (String)"execute"), (Throwable)e);
                if (txHolder.hasTransactionStatus()) {
                    txAdapter.rollbackOnException(txHolder.getTransactionStatus(), (Throwable)e);
                }
                throw e;
            }
            catch (BusinessDomainException e) {
                LOGGER.error(TextFactory.makeErrorMethod((String)"ReportPrintBase", (String)"execute"), (Throwable)e);
                if (txHolder.hasTransactionStatus()) {
                    txAdapter.rollbackOnException(txHolder.getTransactionStatus(), (Throwable)e);
                }
                throw e;
            }
        }
        if (this.mMergePrintoutToOneFile) {
            File mergedFile = JasperReportManager.mergeToOnePDFFromScheduler(this.mMergedResultList, (String)this.getPdfPrefix(), (String)this.mToken.getUserId(), (String)this.getDescription(), (PrintJob.PrintJobType)this.mPrintJobType);
            this.mURLs = new ArrayList<URL>();
            this.mURLs.add(JasperReportManager.toHttpServerURL((File)mergedFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOutputCreation(PersonalAccountReportPresetData preset, TransactionStatusHolder txHolder) throws BusinessDomainException {
        boolean hasDataToPrint;
        block39: {
            JRSwapFileVirtualizer virtualizer = null;
            this.mResultList = new ArrayList<String>();
            try {
                this.mDataSource = this.getDataSource((ReportPresetInterface)preset, txHolder);
                this.mErrorMessagesLanguageForTextNotFound = new String[this.mDataSource.getErrorMessagesLanguageForTextNotFound().size()];
                this.mDataSource.getErrorMessagesLanguageForTextNotFound().toArray(this.mErrorMessagesLanguageForTextNotFound);
                if (this.mDataSource.getHasDataToPrintBeforeRun()) {
                    Map parameters = this.mDataSource.getParameters(true);
                    virtualizer = new JRSwapFileVirtualizer(200, new JRSwapFile(this.configuration.getVirtualizerWorkDir(), 100, 100));
                    parameters.put("REPORT_VIRTUALIZER", virtualizer);
                    JasperReport jasperReport = this.getReportDefinition(parameters, (ReportPresetInterface)preset);
                    this.mResultList = new ArrayList<String>();
                    File file = null;
                    if (this.mOutputFormat.equals((Object)ReportMediaType.PDF)) {
                        String result;
                        this.mDataSource.setDataSourceForShippmentType(ShippmentTypeEnum.PDF);
                        if (this.mDataSource.getSortContainersSize() > 0) {
                            file = JasperReportManager.runReportToPdfWithReportTypeAndOptionalArchiveAndMargins((String)this.mToken.getUserId(), (JasperReport)jasperReport, (Map)parameters, (JRDataSource)this.mDataSource, (ReportType)this.mReportType, (String)PDFFILE_PREFIX, (PrintJob.PrintJobType)this.mPrintJobType, (boolean)this.mIsAdditionalOutputArchive, (boolean)this.mMergePrintoutToOneFile, (byte[])preset.getCompany().getLetterTemplate(), (boolean)true, (int)this.mLeftMargin, (int)this.mTopMargin, (int)0, (int)0);
                            if (this.mDataSource.getHasDataToPrintAfterRun()) {
                                this.mURLs.add(JasperReportManager.toHttpServerURL((File)file));
                                result = file.getName();
                                this.mResultList.add(result);
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("File name: {}", (Object)result);
                                }
                            }
                            if (preset.getPrintAnswerSequence() == AnswerPrintSequenceEnum.APSE_SEPARATE) {
                                this.mDataSource.setIsForAnswerLetter(true);
                                this.mDataSource.setSubReport(true);
                                this.mDataSource.setZaehler(0);
                                this.mDataSource.initializeTitlePages();
                                file = JasperReportManager.runReportToPdfWithReportTypeAndOptionalArchiveAndMargins((String)this.mToken.getUserId(), (JasperReport)jasperReport, (Map)parameters, (JRDataSource)this.mDataSource, (ReportType)this.mReportType, (String)PDFFILE_ANSWERLETTER_PREFIX, (PrintJob.PrintJobType)this.mPrintJobType, (boolean)this.mIsAdditionalOutputArchive, (boolean)this.mMergePrintoutToOneFile, (byte[])preset.getCompany().getLetterTemplate(), (boolean)true, (int)this.mLeftMargin, (int)this.mTopMargin, (int)0, (int)0);
                                if (this.mDataSource.getHasDataToPrintAfterRun()) {
                                    this.mURLs.add(JasperReportManager.toHttpServerURL((File)file));
                                    result = file.getName();
                                    this.mResultList.add(result);
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug("File name: {}", (Object)result);
                                    }
                                }
                            }
                        }
                        this.mDataSource.setDataSourceForShippmentType(ShippmentTypeEnum.EMAIL);
                        if (this.mDataSource.getSortContainersSize() > 0) {
                            this.initMailProtocol();
                            this.mDataSource.setFilePerAccount(true);
                            while (this.mDataSource.getZaehler() < this.mDataSource.getSortContainersSize()) {
                                file = JasperReportManager.runReportToPdfWithReportTypeAndOptionalArchiveAndMargins((String)this.mToken.getUserId(), (JasperReport)jasperReport, (Map)parameters, (JRDataSource)this.mDataSource, (ReportType)this.mReportType, (String)PDFFILE_PREFIX, (PrintJob.PrintJobType)this.mPrintJobType, (boolean)this.mIsAdditionalOutputArchive, (boolean)this.mMergePrintoutToOneFile, (byte[])preset.getCompany().getLetterTemplate(), (boolean)true, (int)this.mLeftMargin, (int)this.mTopMargin, (int)0, (int)0);
                                String toEmail = this.mDataSource.getCurrentEmail();
                                LOGGER.debug("toEmail: {}", (Object)toEmail);
                                String toEmailCC = this.mDataSource.getCurrentEmailCC();
                                LOGGER.debug("toEmailCC: {}", (Object)toEmailCC);
                                String paCode = this.mDataSource.getCurrentPersonalAccount().getCode();
                                String subject = paCode + "; " + this.mDataSource.getCurrentSubject();
                                String messageText = StringMapper.toString((String)this.mDataSource.getCurrentMessageText());
                                if (this.mFromEmailAddress == null) {
                                    ExceptionMapper.printException((Throwable)MailExceptionMapper.makeNoFromDomainException());
                                    this.mMailProtocol.addFailedList(new MailProtocolEntry(toEmail, paCode, subject, "", false));
                                    continue;
                                }
                                if (MailChecker.wrongEmailAddress((String)toEmail)) {
                                    ExceptionMapper.printException((Throwable)MailExceptionMapper.makeNoToDomainException());
                                    this.mMailProtocol.addFailedList(new MailProtocolEntry(toEmail, paCode, subject, this.mMailProtocol.getWrongMailToText(), false));
                                    continue;
                                }
                                if (MailChecker.hasWrongEmailAddresses((String)toEmailCC)) {
                                    ExceptionMapper.printException((Throwable)MailExceptionMapper.makeNoCCDomainException());
                                    MailChecker.getWrongEmailAddresses((String)toEmailCC).forEach(address -> this.mMailProtocol.addFailedList(new MailProtocolEntry("cc " + address.asInternetAddress().getAddress(), paCode, subject, this.mMailProtocol.getWrongMailToText(), false)));
                                    continue;
                                }
                                try {
                                    File newFile = new File(file.getParent(), this.mDataSource.getCurrentPersonalAccount().getAccountingCompany().getCode() + "_" + paCode + "_" + file.getName());
                                    file.renameTo(newFile);
                                    file = newFile;
                                    this.mMailManager.send((Credentials)null, this.mFromEmailAddress, (Collection)EmailAddressFactory.create((String)toEmail), (Collection)EmailAddressFactory.create((String)toEmailCC), (Collection)EmailAddressFactory.create((String)this.mEmailBCC), subject, messageText, file);
                                    this.mMailProtocol.addSuccessfulList(new MailProtocolEntry(toEmail, paCode, subject, "", true));
                                    List ccAddresses = EmailAddressFactory.create((String)toEmailCC);
                                    ccAddresses.forEach(ccAddress -> this.mMailProtocol.addSuccessfulList(new MailProtocolEntry("cc " + ccAddress.asInternetAddress().getAddress(), paCode, subject, "", true)));
                                    this.mMailManager.waitAfterMail();
                                }
                                catch (MailException e) {
                                    ExceptionMapper.printException((Throwable)MailExceptionMapper.makeMailFailedDomainException((MailException)e));
                                    this.mMailProtocol.addFailedList(new MailProtocolEntry(toEmail, paCode, subject, this.mMailProtocol.getMailFailedText(), false));
                                }
                            }
                            this.mDataSource.setFilePerAccount(false);
                            if (preset.getPrintLetterInAddToEmail()) {
                                this.mDataSource.setDataSourceForShippmentType(ShippmentTypeEnum.EMAIL);
                                file = JasperReportManager.runReportToPdfWithReportTypeAndOptionalArchiveAndMargins((String)this.mToken.getUserId(), (JasperReport)jasperReport, (Map)parameters, (JRDataSource)this.mDataSource, (ReportType)this.mReportType, (String)PDFFILE_EMAILPREFIX, (PrintJob.PrintJobType)this.mPrintJobType, (boolean)this.mIsAdditionalOutputArchive, (boolean)this.mMergePrintoutToOneFile, (byte[])preset.getCompany().getLetterTemplate(), (boolean)true, (int)this.mLeftMargin, (int)this.mTopMargin, (int)0, (int)0);
                                if (this.mDataSource.getHasDataToPrintAfterRun()) {
                                    this.mURLs.add(JasperReportManager.toHttpServerURL((File)file));
                                    result = file.getName();
                                    this.mResultList.add(result);
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug("File name: {}", (Object)result);
                                    }
                                }
                            }
                        }
                        this.mDataSource.setDataSourceForShippmentType(ShippmentTypeEnum.FAX);
                        if (this.mDataSource.getSortContainersSize() > 0) {
                            this.mDataSource.setFilePerAccount(true);
                            while (this.mDataSource.getZaehler() < this.mDataSource.getSortContainersSize()) {
                                file = JasperReportManager.runReportToFaxWithReportTypeAndAndMargins((String)this.mToken.getUserId(), (JasperReport)jasperReport, (Map)parameters, (JRDataSource)this.mDataSource, (ReportType)this.mReportType, (String)("FAX_" + this.mDataSource.getFaxSoftwareCode() + "_"), (PrintJob.PrintJobType)this.mPrintJobType, (byte[])preset.getCompany().getLetterTemplate(), (boolean)true, (int)this.mLeftMargin, (int)this.mTopMargin, (int)0, (int)0, (JasperReportFaxDataSource)this.mDataSource);
                            }
                            this.mDataSource.setFilePerAccount(false);
                            if (preset.getPrintLetterInAddToFax()) {
                                this.mDataSource.setDataSourceForShippmentType(ShippmentTypeEnum.FAX);
                                file = JasperReportManager.runReportToPdfWithReportTypeAndOptionalArchiveAndMargins((String)this.mToken.getUserId(), (JasperReport)jasperReport, (Map)parameters, (JRDataSource)this.mDataSource, (ReportType)this.mReportType, (String)"ByFax_SOA", (PrintJob.PrintJobType)this.mPrintJobType, (boolean)this.mIsAdditionalOutputArchive, (boolean)this.mMergePrintoutToOneFile, (byte[])preset.getCompany().getLetterTemplate(), (boolean)true, (int)this.mLeftMargin, (int)this.mTopMargin, (int)0, (int)0);
                                if (this.mDataSource.getHasDataToPrintAfterRun()) {
                                    this.mURLs.add(JasperReportManager.toHttpServerURL((File)file));
                                    result = file.getName();
                                    this.mResultList.add(result);
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug("File name: {}", (Object)result);
                                    }
                                }
                            }
                        }
                    }
                    if (this.mErrorMessagesLanguageForTextNotFound.length > 0 && !this.mIsMultiCompanyPrintout) {
                        if (preset.getPrintProtocol()) {
                            for (int i = 0; i < this.mErrorMessagesLanguageForTextNotFound.length; ++i) {
                                this.mProtocolMessages.add(this.mErrorMessagesLanguageForTextNotFound[i]);
                            }
                            this.mProtocolMessages.add(ExceptionMapper.toString((Throwable)ReportExceptionMapper.makeMissingLanguageVariantForTextException()));
                        } else {
                            this.mProtocolMessages.add(ExceptionMapper.toString((Throwable)ReportExceptionMapper.makeMissingLanguageVariantForTextException((String[])this.mErrorMessagesLanguageForTextNotFound)));
                        }
                    }
                }
                if (virtualizer == null) break block39;
            }
            catch (Exception e) {
                boolean hasDataToPrint2;
                block40: {
                    try {
                        LOGGER.error(TextFactory.makeErrorMethod((String)"ReportPrintBase", (String)"runReportCreation"), (Throwable)e);
                        if (!e.toString().contains("Report/1500")) {
                            String errorMessText = this.mDataSource == null ? "*FEHLER* " : JasperReportTranslateableResource.getErrorMessageText((ILanguage)this.mGlobalLanguage);
                            this.mProtocolMessages.add(errorMessText);
                            this.mProtocolMessages.add(ExceptionMapper.toString((Throwable)e));
                            this.mExceptionIsThrown = true;
                            this.mPrintJobType = PrintJob.PrintJobType.ADHOCKEEPAFTERPRINTING;
                        }
                        if (virtualizer == null) break block40;
                    }
                    catch (Throwable throwable) {
                        boolean hasDataToPrint3;
                        if (virtualizer != null) {
                            virtualizer.cleanup();
                        }
                        this.printMailProtocol();
                        boolean bl = hasDataToPrint3 = this.mDataSource != null && this.mDataSource.getHasDataToPrintBeforeRun() && this.mDataSource.getHasDataToPrintAfterRun();
                        if (preset.getPrintProtocol() || !hasDataToPrint3 && !this.mIsMultiCompanyPrintout || this.mExceptionIsThrown) {
                            String[] moreProtocolMessages = new String[this.mProtocolMessages.size()];
                            this.mProtocolMessages.toArray(moreProtocolMessages);
                            String result = this.printProtocolReport(hasDataToPrint3, (ReportPresetInterface)preset, moreProtocolMessages);
                            this.mProtocolMessages.clear();
                            this.mResultList.add(result);
                        }
                        if (this.mMergePrintoutToOneFile) {
                            this.mMergedResultList.addAll(this.mResultList);
                        }
                        throw throwable;
                    }
                    virtualizer.cleanup();
                }
                this.printMailProtocol();
                boolean bl = hasDataToPrint2 = this.mDataSource != null && this.mDataSource.getHasDataToPrintBeforeRun() && this.mDataSource.getHasDataToPrintAfterRun();
                if (preset.getPrintProtocol() || !hasDataToPrint2 && !this.mIsMultiCompanyPrintout || this.mExceptionIsThrown) {
                    String[] moreProtocolMessages = new String[this.mProtocolMessages.size()];
                    this.mProtocolMessages.toArray(moreProtocolMessages);
                    String result = this.printProtocolReport(hasDataToPrint2, (ReportPresetInterface)preset, moreProtocolMessages);
                    this.mProtocolMessages.clear();
                    this.mResultList.add(result);
                }
                if (this.mMergePrintoutToOneFile) {
                    this.mMergedResultList.addAll(this.mResultList);
                }
            }
            virtualizer.cleanup();
        }
        this.printMailProtocol();
        boolean bl = hasDataToPrint = this.mDataSource != null && this.mDataSource.getHasDataToPrintBeforeRun() && this.mDataSource.getHasDataToPrintAfterRun();
        if (preset.getPrintProtocol() || !hasDataToPrint && !this.mIsMultiCompanyPrintout || this.mExceptionIsThrown) {
            String[] moreProtocolMessages = new String[this.mProtocolMessages.size()];
            this.mProtocolMessages.toArray(moreProtocolMessages);
            String result = this.printProtocolReport(hasDataToPrint, (ReportPresetInterface)preset, moreProtocolMessages);
            this.mProtocolMessages.clear();
            this.mResultList.add(result);
        }
        if (this.mMergePrintoutToOneFile) {
            this.mMergedResultList.addAll(this.mResultList);
        }
    }

    public PersonalAccountStatementOfAccountReportDataSource getDataSource(ReportPresetInterface presetI, TransactionStatusHolder txHolder) throws PutDataException, BusinessDomainException {
        PersonalAccountReportPresetData preset = (PersonalAccountReportPresetData)presetI;
        if (preset.getIsAssociation()) {
            preset.setPrintAssociation(PrintAssociationEnum.PAE_ONLY_ASSOCIATIONS);
        }
        if (preset.getIgnoreAssociationAccounts()) {
            preset.setPrintAssociation(PrintAssociationEnum.PAE_NONE_ASSOCIATIONS);
        }
        OpenItemDataSelector oiDataSelector = new OpenItemDataSelector(preset.getCompany(), preset.getFinancialYear().getObjectid(), preset.getAmountsAsOf(), preset.getAccountType(), preset.getPrintAssociation(), BalancedOpenItemsEnum.BOIE_NOT_BALANCED, OIHistoryTypeEnum.OIHTE_INVOICES);
        this.setFilter(oiDataSelector, preset);
        this.makeOpenItemSort(preset);
        int rowCount = oiDataSelector.getRowCount();
        int numberOfSteps = 2;
        if (preset.getPrintAnswerSequence() == AnswerPrintSequenceEnum.APSE_SEPARATE) {
            numberOfSteps = 3;
        }
        SelectGeneratorDataSet dataset = oiDataSelector.getDataSet();
        return new PersonalAccountStatementOfAccountReportDataSource(dataset, preset, this.mGlobalLanguage, rowCount, oiDataSelector, this.mOutputFormat);
    }

    public JasperReport getReportDefinition(Map<String, Object> parameters, ReportPresetInterface presetI) {
        String statementXML = null;
        statementXML = this.configuration.getString(PROPKEY_STATEMENTOFACCOUNTXML);
        if (StringMapper.isNullString((String)statementXML)) {
            statementXML = STATEMENTOFACCOUNT_DEFAULT_XML;
        }
        return JasperReportCompiler.compileReport((String)this.mOidUserReport, (String)statementXML);
    }

    public String getPdfPrefix() {
        if (this.mPreset.getAccountType().value() == 1) {
            return ReportType.PERSACCREP_SOA_CUST.getPrefix();
        }
        return ReportType.PERSACCREP_SOA_SUPP.getPrefix();
    }

    public String getDescription() {
        return this.mPreset.getReportName(this.mGlobalLanguage);
    }

    public PresetProtocolReportContainer[] getPresetProtocolReportConainers(ReportPresetInterface presetI, String[] moreProtocolMessages) throws BusinessDomainException {
        int arrayLength = 0;
        if (moreProtocolMessages != null && moreProtocolMessages.length > 0) {
            arrayLength = moreProtocolMessages.length;
        }
        if (this.mErrorMessagesLanguageForTextNotFound != null && this.mErrorMessagesLanguageForTextNotFound.length > 0) {
            arrayLength += this.mErrorMessagesLanguageForTextNotFound.length;
        }
        String[] moreProtMessages = new String[arrayLength];
        if (arrayLength > 0 && moreProtocolMessages != null && moreProtocolMessages.length > 0) {
            System.arraycopy(moreProtocolMessages, 0, moreProtMessages, 0, moreProtocolMessages.length);
        }
        if (arrayLength > 0 && this.mErrorMessagesLanguageForTextNotFound != null && this.mErrorMessagesLanguageForTextNotFound.length > 0) {
            System.arraycopy(this.mErrorMessagesLanguageForTextNotFound, 0, moreProtMessages, moreProtocolMessages.length, this.mErrorMessagesLanguageForTextNotFound.length);
        }
        PresetProtocolHelperBalanceAcknowledgement helper = new PresetProtocolHelperBalanceAcknowledgement(presetI, this.mGlobalLanguage, moreProtocolMessages, this.mOutputFormat, "");
        return helper.getContainersArray();
    }

    public DCPModel getDCPModel() {
        return null;
    }

    private void initMailProtocol() {
        String fromEmail = this.mPreset.getEmailAdvisor();
        if (StringMapper.isNullString((String)fromEmail) && this.mPreset.getAdvisor() != null) {
            fromEmail = this.mPreset.getAdvisor().getEmail();
        }
        if (StringMapper.isNullString((String)fromEmail)) {
            fromEmail = userPersistencyManager.query(SessionContext.getInstance().getSession().getUserCode()).getEmail();
        }
        this.mFromEmailAddress = MailChecker.getCheckedEmailAddress((String)fromEmail);
        this.mJasperReportMailProtocol = MailProtocol.getReport();
        this.mMailProtocol = new MailProtocol(MailProtocolProgramEnum.BALANCE_CONFIRMATION, this.mPreset.getName(), this.mGlobalLanguage, this.mFromEmailAddress);
        this.mEmailBCC = this.mMailProtocol.getEmailBCC();
        this.mMailManager = (MailManager)UtilitiesManager.getBean((String)"emailManager", MailManager.class);
    }

    private void printMailProtocol() throws BusinessDomainException {
        if (this.mMailProtocol != null && this.mMailProtocol.hasDataToPrint()) {
            MailProtocolReportDataSource mailProtocolReportDataSource = new MailProtocolReportDataSource(this.mGlobalLanguage, this.mMailProtocol, this.mPreset.getCompany().getCurrentAddress());
            Map parametersMailProtocol = mailProtocolReportDataSource.getParameters();
            File file = JasperReportManager.runReportToPdf((String)this.mToken.getUserId(), (JasperReport)this.mJasperReportMailProtocol, (Map)parametersMailProtocol, (JRDataSource)mailProtocolReportDataSource, (String)"MAILPROT");
            String result = JasperReportManager.getUrl((File)file);
            if (this.mFromEmailAddress != null) {
                try {
                    this.mMailManager.send((Credentials)null, this.mFromEmailAddress, this.mFromEmailAddress, this.mMailProtocol.getSubjectText(), this.mMailProtocol.getMessageText(), file);
                }
                catch (MailException e) {
                    throw MailExceptionMapper.makeMailFailedDomainException((MailException)e);
                }
            } else {
                this.mResultList.add(result);
            }
        }
    }

    public PersonalAccountReportPresetData[] getReportPresets(PersonalAccountReportPresetData preset) throws BusinessDomainException {
        return PersonalAccountReportPresetHelper.getPresetsForFurtherCompaniesScheduler((PersonalAccountReportPresetData)preset, this.mProtocolMessages, (Language)this.mGlobalLanguage, this.mOidsCheckedFurtherCompanies);
    }

    private void setFilter(OpenItemDataSelector oiDataSelector, PersonalAccountReportPresetData preset) {
        PersonalAccountReportHelper.setDefaultFilter((OpenItemDataSelector)oiDataSelector, (PersonalAccountReportPresetData)preset);
        oiDataSelector.setDownPaymentFilter(preset.getDownPaymentFilter());
        oiDataSelector.setDownPaymentFilterType(preset.getDownPaymentFilterType());
        oiDataSelector.setOneOfAccountDisabled();
        if (preset.getWithZeroBalancedAccounts()) {
            oiDataSelector.setWithBalancedOI(BalancedOpenItemsEnum.BOIE_ALL);
        }
    }

    private void makeOpenItemSort(PersonalAccountReportPresetData preset) {
        Sort openitemSort = new Sort(true);
        SortElement[] sortElem = new SortElement[2];
        SortElement sortByCurrency = new SortElement(true, openitemSort);
        sortByCurrency.setAttribute(PersonalAccountReportFilterMapper.getFIELD_CURRENCY());
        sortElem[0] = sortByCurrency;
        SortElement sortByDocDate = new SortElement(true, openitemSort);
        sortByDocDate.setAttribute(PersonalAccountReportFilterMapper.getFIELD_DOCUMENTDATE());
        sortElem[1] = sortByDocDate;
        if (preset.getSortKey() != null) {
            switch (preset.getSortKey().value()) {
                case 1: {
                    SortElement sortByDueDate = new SortElement(true, openitemSort);
                    sortByDueDate.setAttribute(PersonalAccountReportFilterMapper.getFIELD_DUEDATE());
                    sortElem[1] = sortByDueDate;
                    break;
                }
                case 0: {
                    SortElement sortByReferenceNo = new SortElement(true, openitemSort);
                    sortByReferenceNo.setAttribute(PersonalAccountReportFilterMapper.getFIELD_REFERENCENUMBER());
                    sortElem[1] = sortByReferenceNo;
                }
            }
            openitemSort.setSortElements(sortElem);
            preset.setSortOpenItem(openitemSort);
        }
    }

    protected String printProtocolReport(boolean hasDataToPrint, ReportPresetInterface preset, String[] moreMessages) throws BusinessDomainException {
        PresetProtocolReportContainer[] containers = this.getPresetProtocolReportConainers(preset, moreMessages);
        PresetProtocolReportDataSource protocolDataSource = new PresetProtocolReportDataSource(preset.getReportName(this.mGlobalLanguage), preset.getCompany(), this.mGlobalLanguage, this.mPrintTime, containers, hasDataToPrint);
        Map parameters = protocolDataSource.getParameters();
        File file = JasperReportManager.runReportToPdfWithStdProtection((String)this.mToken.getUserId(), (JasperReport)PersonalAccountStatementOfAccountReportPrint.getProtocolReportDefinition(), (Map)parameters, (JRDataSource)protocolDataSource, (String)PDFFILE_PROTOCOL_PREFIX, (String)("Protokoll " + this.getDescription()), (PrintJob.PrintJobType)this.mPrintJobType, (boolean)this.mMergePrintoutToOneFile);
        this.mURLs.add(JasperReportManager.toHttpServerURL((File)file));
        return file.getName();
    }

    public List<URL> getURLs() {
        return this.mURLs;
    }

    private static JasperReport getProtocolReportDefinition() {
        return JasperReportCompiler.compileReport((String)"com/varial/framework/jasperreport/protocolreports/PresetProtocolReport.jrxml");
    }
}

