/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.validators;

import ch.varial.accounting.domain.payment.iso.ISO20022PaymentExporter;
import com.varial.accounting.domain.openitem.SwissReferenceType;
import com.varial.accounting.domain.openitem.SwissReferenceUtil;
import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.accounting.domain.payment.GeneratePayment;
import com.varial.accounting.domain.payment.PaymentHelper;
import com.varial.accounting.domain.payment.ibp.IbpPaymentExporter;
import com.varial.accounting.domain.payment.validators.BankDetailsValidator;
import com.varial.accounting.payment.GeneratePaymentErrormessageEnum;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.company.JurisdictionFactory;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.country.CountryHelper;
import com.varial.framework.domain.country.ICountry;
import com.varial.framework.domain.paymentbase.BankDataChecker;
import com.varial.framework.domain.paymentbase.ModeOfPayment;
import com.varial.framework.domain.paymentbase.ibancheck.IBANCheck;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.StringMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class BankDetailsValidatorImpl
implements BankDetailsValidator {
    public List<GeneratePaymentErrormessageEnum> checkBacs(FinancePayment payment) {
        ArrayList<GeneratePaymentErrormessageEnum> errorMessages = new ArrayList<GeneratePaymentErrormessageEnum>();
        if (this.isBacsTransferDataMissing(payment)) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_BACSTRANSFERDATA_MISSING);
        } else if (payment.getEsrPayment() != null) {
            errorMessages.addAll(this.checkEsrPayment(payment));
        } else if (payment.getSwissReferenceType() == SwissReferenceType.QR_REFERENCE || payment.getSwissReferenceType() == SwissReferenceType.ISO_CREDITOR_REFERENCE) {
            errorMessages.addAll(this.checkSwissPaymentWithReference());
        } else if (!StringMapper.isNullString((String)payment.getPostChequeAccount())) {
            errorMessages.addAll(this.checkPostChequeAccount(payment));
        } else {
            errorMessages.addAll(this.checkBankData(payment));
        }
        return errorMessages;
    }

    private List<GeneratePaymentErrormessageEnum> checkBankData(FinancePayment payment) {
        HashMap<GeneratePaymentErrormessageEnum, GeneratePaymentErrormessageEnum> errorMessages = new HashMap<GeneratePaymentErrormessageEnum, GeneratePaymentErrormessageEnum>();
        if (this.useSwiftIban(payment)) {
            if (StringMapper.isNullString((String)payment.getSwift()) && StringMapper.isNullString((String)payment.getShortAddressOwner())) {
                if (StringMapper.isNullString((String)payment.getBankAccountNumber())) {
                    errorMessages.put(GeneratePaymentErrormessageEnum.GPET_BACSTRANSFERDATA_MISSING, GeneratePaymentErrormessageEnum.GPET_BACSTRANSFERDATA_MISSING);
                } else if (StringMapper.isNullString((String)payment.getBankSortingCode()) && this.isBankCountryCH(payment) && !payment.getIsForeignPayment()) {
                    errorMessages.put(GeneratePaymentErrormessageEnum.GPET_BACSTRANSFERDATA_MISSING, GeneratePaymentErrormessageEnum.GPET_BACSTRANSFERDATA_MISSING);
                }
            }
        } else {
            if (StringMapper.isNullString((String)payment.getBankAccountNumber())) {
                errorMessages.put(GeneratePaymentErrormessageEnum.GPET_BANKACCOUNTNUMBER_MISSING, GeneratePaymentErrormessageEnum.GPET_BANKACCOUNTNUMBER_MISSING);
            }
            if (StringMapper.isNullString((String)payment.getBankSortingCode()) && !this.isBankCountryNL(payment) && !this.isBankCountryDK(payment)) {
                errorMessages.put(GeneratePaymentErrormessageEnum.GPET_BANKACSORTINGCODE_MISSING, GeneratePaymentErrormessageEnum.GPET_BANKACSORTINGCODE_MISSING);
            }
        }
        if (this.isIso20022CHPaymentFormat(payment)) {
            if (StringMapper.isNullString((String)payment.getSwift()) && StringMapper.isNullString((String)payment.getBankSortingCode())) {
                errorMessages.put(GeneratePaymentErrormessageEnum.GPET_BACSTRANSFERDATA_MISSING, GeneratePaymentErrormessageEnum.GPET_BACSTRANSFERDATA_MISSING);
            }
            if (StringMapper.isNullString((String)payment.getSwift()) && !this.isBankCountryCH(payment)) {
                errorMessages.put(GeneratePaymentErrormessageEnum.GPET_BACSTRANSFERDATA_MISSING, GeneratePaymentErrormessageEnum.GPET_BACSTRANSFERDATA_MISSING);
            }
            if (SwissReferenceUtil.isQRIban((String)payment.getShortAddressOwner()) && !SwissReferenceUtil.isQRReference((String)payment.getSwissReference())) {
                errorMessages.put(GeneratePaymentErrormessageEnum.GPET_A_QR_REFERNCE_IS_REQUIRED_WHEN_USING_A_QR_IBAN, GeneratePaymentErrormessageEnum.GPET_A_QR_REFERNCE_IS_REQUIRED_WHEN_USING_A_QR_IBAN);
            }
        }
        return new ArrayList<GeneratePaymentErrormessageEnum>(errorMessages.values());
    }

    private List<GeneratePaymentErrormessageEnum> checkPostChequeAccount(FinancePayment payment) {
        String validPostChequeAccount;
        ArrayList<GeneratePaymentErrormessageEnum> errorMessages = new ArrayList<GeneratePaymentErrormessageEnum>();
        if (!StringMapper.isNullString((String)payment.getBankAccountNumber()) || !StringMapper.isNullString((String)payment.getShortAddressOwner())) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_ONLY_ONE_OF_THREE_OPTIONS_ALLOWED_FOR_BACS);
        }
        if (StringMapper.isNullString((String)(validPostChequeAccount = this.getValidPostChequeAccount(payment)))) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_INVALID_POSTCHEQUEACCOUNT);
        }
        return errorMessages;
    }

    private String getValidPostChequeAccount(FinancePayment payment) {
        return BankDataChecker.checkPostChequeAccount((String)payment.getPostChequeAccount());
    }

    private List<GeneratePaymentErrormessageEnum> checkEsrPayment(FinancePayment payment) {
        ArrayList<GeneratePaymentErrormessageEnum> errorMessages = new ArrayList<GeneratePaymentErrormessageEnum>();
        if (!(StringMapper.isNullString((String)payment.getPostChequeAccount()) && StringMapper.isNullString((String)payment.getBankAccountNumber()) && StringMapper.isNullString((String)payment.getShortAddressOwner()))) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_ONLY_ONE_OF_THREE_OPTIONS_ALLOWED_FOR_BACS);
        }
        if (!this.isBankAccountCountryCH(payment)) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_BACSTRANSFERDATA_MISSING);
        }
        if (StringMapper.isNullString((String)payment.getEsrPayment().getEsrNumber())) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_ESRNUMBER_MISSING);
        } else if (!payment.getEsrPayment().checkEsrNumber()) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_INVALID_ESRNUMBER);
        }
        if (StringMapper.isNullString((String)payment.getEsrPayment().getMemberNumber())) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_USERNUMBER_MISSING);
        } else if (!payment.getEsrPayment().checkMemberNumber()) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_INVALID_USERNUMBER);
        }
        return errorMessages;
    }

    private boolean isBacsTransferDataMissing(FinancePayment payment) {
        return StringMapper.isNullString((String)payment.getBankAccountNumber()) && StringMapper.isNullString((String)payment.getPostChequeAccount()) && payment.getEsrPayment() == null && StringMapper.isNullString((String)payment.getShortAddressOwner());
    }

    private boolean usePostChequeAccount(FinancePayment payment) {
        return JurisdictionFactory.getJurisdiction((JurisdictionType)payment.getFinancePaymentSession().getCompany().getJurisdictionType()).hasPostChequeAccount();
    }

    private boolean useSwiftIban(FinancePayment payment) {
        return payment.getIsForeignPayment() || payment.isSepaPayment() || this.isBankCountryCH(payment) || this.isBankCountryLV(payment) || this.isBankCountryDK(payment) || this.isIbpPymentFormat(payment);
    }

    private boolean isBankCountryDK(FinancePayment payment) {
        return CountryHelper.isDK((ICountry)payment.getBankCountry());
    }

    private boolean isBankCountryIT(FinancePayment payment) {
        return CountryHelper.isIT((ICountry)payment.getBankCountry());
    }

    private boolean isBankCountryCH(FinancePayment payment) {
        return CountryHelper.isCH((ICountry)payment.getBankCountry());
    }

    private boolean isBankCountryLV(FinancePayment payment) {
        return CountryHelper.isLV((ICountry)payment.getBankCountry());
    }

    private boolean isBankCountryNL(FinancePayment payment) {
        return CountryHelper.isNL((ICountry)payment.getBankCountry());
    }

    private boolean isBankAccountCountryCH(FinancePayment payment) {
        return CountryHelper.isCH((ICountry)payment.getBankAccount().getCountry());
    }

    private boolean isIbpPymentFormat(FinancePayment payment) {
        boolean result = false;
        if (payment.getBankAccount() != null && payment.getBankAccount().getExportFormat() != null) {
            result = StringMapper.equalWithTrim((String)payment.getBankAccount().getExportFormat().getExporterClass(), (String)IbpPaymentExporter.class.getName());
        }
        return result;
    }

    private boolean isIso20022CHPaymentFormat(FinancePayment payment) {
        return payment.getBankAccount() != null && payment.getBankAccount().getExportFormat() != null && StringMapper.equalWithTrim((String)payment.getBankAccount().getExportFormat().getExporterClass(), (String)ISO20022PaymentExporter.class.getName());
    }

    private List<GeneratePaymentErrormessageEnum> checkDirectDebit(FinancePayment payment) {
        ArrayList<GeneratePaymentErrormessageEnum> errorMessages = new ArrayList<GeneratePaymentErrormessageEnum>();
        if (this.usePostChequeAccount(payment)) {
            if (!StringMapper.isNullString((String)payment.getBankAccountNumber()) && !StringMapper.isNullString((String)payment.getPostChequeAccount())) {
                errorMessages.add(GeneratePaymentErrormessageEnum.GPET_ONLY_BANK_OR_POST_CHEQUE_ACCOUNT_ALLOWED);
            } else if (StringMapper.isNullString((String)payment.getBankAccountNumber()) && StringMapper.isNullString((String)payment.getPostChequeAccount()) && StringMapper.isNullString((String)payment.getShortAddressOwner())) {
                errorMessages.add(GeneratePaymentErrormessageEnum.GPET_BANKACCOUNTNUMBER_OR_POSTCHEQUEDACCOUNT_MISSING);
            }
            if (this.isIso20022CHPaymentFormat(payment)) {
                if (StringMapper.isNullString((String)payment.getBankSortingCode())) {
                    errorMessages.add(GeneratePaymentErrormessageEnum.GPET_BANKACSORTINGCODE_MISSING);
                }
                if (StringMapper.isNullString((String)payment.getPostChequeAccount()) && StringMapper.isNullString((String)payment.getShortAddressOwner())) {
                    errorMessages.add(GeneratePaymentErrormessageEnum.GPET_IBAN_IS_MISSING);
                }
            }
        } else {
            if (StringMapper.isNullString((String)payment.getBankSortingCode()) && !this.isBankCountryNL(payment) && !this.isIbpPymentFormat(payment) && !this.isBankCountryDK(payment)) {
                errorMessages.add(GeneratePaymentErrormessageEnum.GPET_BANKACSORTINGCODE_MISSING);
            }
            if (this.isBankCountryIT(payment)) {
                if (payment.getTypeOfPayment() == ModeOfPayment.BANK_COLLECTION && StringMapper.isNullString((String)payment.getBankAccountNumber())) {
                    errorMessages.add(GeneratePaymentErrormessageEnum.GPET_BANKACCOUNTNUMBER_MISSING);
                }
            } else if (StringMapper.isNullString((String)payment.getBankAccountNumber()) && !this.isIbpPymentFormat(payment)) {
                errorMessages.add(GeneratePaymentErrormessageEnum.GPET_BANKACCOUNTNUMBER_MISSING);
            }
        }
        return errorMessages;
    }

    private List<GeneratePaymentErrormessageEnum> checkSwissPaymentWithReference() {
        return new ArrayList<GeneratePaymentErrormessageEnum>();
    }

    private List<GeneratePaymentErrormessageEnum> checkBacsData(GeneratePayment payment) {
        if (payment.isSepaPayment()) {
            return new ArrayList<GeneratePaymentErrormessageEnum>();
        }
        ArrayList<GeneratePaymentErrormessageEnum> errorMessages = new ArrayList<GeneratePaymentErrormessageEnum>();
        if (payment.getEsrPayment() != null) {
            errorMessages.addAll(this.checkBacs(payment));
        } else if (this.useSepaFormat(payment)) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_ONLY_SEPA_PAYMENT_IS_ALLOWED);
            errorMessages.addAll(this.checkSepaBacs(payment));
        } else if (!payment.getIsForeignPayment() && payment.isForeignAccount() || payment.getIsForeignPayment() && !payment.isForeignAccount() && payment.getCurrency().equals(payment.getBaseCurrency())) {
            errorMessages.add(this.makeOnlySepaPaymentAllowedErrorMessage(payment));
            if (this.meetsBasicSepaCriteria(payment)) {
                errorMessages.addAll(this.checkSepaBacs(payment));
            }
        } else {
            errorMessages.addAll(this.checkBacs(payment));
        }
        return errorMessages;
    }

    private List<GeneratePaymentErrormessageEnum> checkSepaBacs(GeneratePayment payment) {
        ArrayList<GeneratePaymentErrormessageEnum> errorMessages = new ArrayList<GeneratePaymentErrormessageEnum>();
        if (!PaymentHelper.checkSepaSwift(payment.getSwift(), payment.getBankAccount(), payment.getBankCountry())) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_SWIFT_IS_MISSING);
        }
        if (StringMapper.isNullString((String)payment.getShortAddressOwner())) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_IBAN_IS_MISSING);
        }
        return errorMessages;
    }

    private List<GeneratePaymentErrormessageEnum> checkSepaDirectDebit(GeneratePayment payment) {
        ArrayList<GeneratePaymentErrormessageEnum> errorMessages = new ArrayList<GeneratePaymentErrormessageEnum>();
        errorMessages.addAll(this.checkSepaBacs(payment));
        if (StringMapper.isNullString((String)payment.getGeneratePaymentSession().getAccountingCompany().getUniqueCreditorIdent())) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_SEPA_DIRECT_DEBIT_NUMBER_IS_MISSING_IN_COMPANY_MASTER_DATA);
        }
        if (StringMapper.isNullString((String)payment.getSepaMandate())) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_SEPA_MANDATE_IS_MISSING_IN_BANK_ADDRESS);
        }
        if (payment.getSepaMandateDate() == null) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_SEPA_MANDATE_DATE_IS_MISSING_IN_BANK_ADDRESS);
        }
        return errorMessages;
    }

    private List<GeneratePaymentErrormessageEnum> checkSepaMandate(GeneratePayment payment) {
        ArrayList<GeneratePaymentErrormessageEnum> errorList = new ArrayList<GeneratePaymentErrormessageEnum>();
        if (payment.getSepaLastUsage() != null) {
            if (payment.getIsSepaOneOffDirectDebit()) {
                errorList.add(GeneratePaymentErrormessageEnum.GPET_ONE_OFF_DIRECT_DEBIT_HAS_ALREADY_BEEN_USED);
            } else {
                VDate baseDate = new VDate(payment.getSepaLastUsage());
                VDate validUntil = baseDate.addMonths(36);
                Date executeDate = payment.getSepaDirectDebitExecuteDate();
                if (executeDate != null && DateHelper.after((Date)executeDate, (Date)validUntil.getDate())) {
                    errorList.add(GeneratePaymentErrormessageEnum.GPET_LAST_USE_OF_SEPA_MANDATE_WAS_36_MONTHS_AGO);
                }
            }
        } else if (payment.getSepaMandateDate() != null) {
            VDate baseDate = new VDate(payment.getSepaMandateDate());
            VDate validUntil = baseDate.addMonths(36);
            Date executeDate = payment.getSepaDirectDebitExecuteDate();
            if (executeDate != null && DateHelper.after((Date)executeDate, (Date)validUntil.getDate())) {
                errorList.add(GeneratePaymentErrormessageEnum.GPET_LAST_USE_OF_SEPA_MANDATE_WAS_36_MONTHS_AGO);
            }
        }
        return errorList;
    }

    private List<GeneratePaymentErrormessageEnum> checkDirectDebitData(GeneratePayment payment) {
        ArrayList<GeneratePaymentErrormessageEnum> errorMessages = new ArrayList<GeneratePaymentErrormessageEnum>();
        boolean isSepaDirectDebit = payment.isSepaPayment();
        if (isSepaDirectDebit) {
            errorMessages.addAll(this.checkSepaMandate(payment));
        } else if (this.useSepaFormat(payment)) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_ONLY_SEPA_PAYMENT_IS_ALLOWED);
            errorMessages.addAll(this.checkSepaDirectDebit(payment));
        } else if (payment.isForeignAccount()) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_FOR_FOREIGN_CUSTOMERS_ONLY_SEPA_DIRECT_DEBIT_IS_ALLOWED);
            if (this.meetsBasicSepaCriteria(payment)) {
                errorMessages.addAll(this.checkSepaDirectDebit(payment));
            }
        } else {
            errorMessages.addAll(this.checkDirectDebit(payment));
        }
        return errorMessages;
    }

    private GeneratePaymentErrormessageEnum makeOnlySepaPaymentAllowedErrorMessage(GeneratePayment payment) {
        if (payment.isForeignAccount()) {
            return payment.getPersonalAccount().isCustomer() ? GeneratePaymentErrormessageEnum.GPET_ONLY_SEPA_PAYMENT_IS_ALLOWED_FOR_A_FOREIGN_CUSTOMER : GeneratePaymentErrormessageEnum.GPET_ONLY_SEPA_PAYMENT_IS_ALLOWED_FOR_A_FOREIGN_SUPPLIER;
        }
        return GeneratePaymentErrormessageEnum.GPET_ONLY_SEPA_PAYMENT_IS_ALLOWED_FOR_A_DOMESTIC_SUPPLIER;
    }

    public List<GeneratePaymentErrormessageEnum> checkBankDetails(GeneratePayment payment) {
        ArrayList<GeneratePaymentErrormessageEnum> errorMessages = new ArrayList<GeneratePaymentErrormessageEnum>();
        switch (payment.getTypeOfPayment()) {
            case BILL_OF_EXCHANGE: 
            case BILL_WITHOUT_ACCEPTANCE: {
                if (!this.isBillBankDataMissing(payment)) break;
                errorMessages.add(GeneratePaymentErrormessageEnum.GPET_BANK_DATA_FOR_BILL_MISSING);
                break;
            }
            case BACS: 
            case BACS_BILL_OF_EXCHANGE: {
                errorMessages.addAll(this.checkBacsData(payment));
                break;
            }
            case DIRECT_DEBIT: 
            case BANK_COLLECTION: 
            case DIRECT_DEBIT_ANTICIPATED: {
                errorMessages.addAll(this.checkDirectDebitData(payment));
                break;
            }
            case CHECK: 
            case CHECK_BILL_OF_EXCHANGE: {
                if (payment.getPostalAddress().isComplete()) break;
                errorMessages.add(GeneratePaymentErrormessageEnum.GPET_CHEQUEADDRESS_NOT_COMPLETE);
                break;
            }
        }
        if (!StringMapper.isNullString((String)payment.getShortAddressOwner()) && !IBANCheck.validIBAN((String)payment.getShortAddressOwner())) {
            errorMessages.add(GeneratePaymentErrormessageEnum.GPET_IBAN_IS_INCORRECT);
        }
        return errorMessages;
    }

    private boolean useSepaFormat(GeneratePayment payment) {
        return this.meetsBasicSepaCriteria(payment) && !payment.getIsForeignPayment() && payment.getGeneratePaymentSession().getIgnoreNationalPaymentFormat();
    }

    private boolean isBillBankDataMissing(FinancePayment payment) {
        return StringMapper.isNullString((String)payment.getBankAccountNumber()) || StringMapper.isNullString((String)payment.getBankSortingCode()) || StringMapper.isNullString((String)payment.getBankName());
    }

    private boolean meetsBasicSepaCriteria(FinancePayment payment) {
        return PaymentHelper.meetsBasicSepaCriteria(payment.getFinancePaymentSession(), payment.getCurrency(), payment.getBankAccount(), payment.getBankCountry());
    }
}

