/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.reversefactoring.primerevenue;

import com.infor.igf.core.util.StringUtil;

public class PrimeRevenueUtils {
    private static final String UNKNOWN_BUYER_ID = "unknown";
    private static final int MAX_LENGTH_BUYER_ID = 15;

    private PrimeRevenueUtils() {
    }

    public static String toSequenceNumber(int index) {
        return index < 10 ? "0" + String.valueOf(index) : String.valueOf(index);
    }

    public static String toBuyerId(String input) {
        if (StringUtil.isEmpty((String)input)) {
            return UNKNOWN_BUYER_ID;
        }
        String sanitized = input.replaceAll("[^0-9.]", "");
        if (sanitized.isBlank() || !sanitized.matches(".*\\d.*")) {
            return UNKNOWN_BUYER_ID;
        }
        if (sanitized.length() > 15) {
            sanitized = sanitized.substring(0, 15);
        }
        return sanitized;
    }
}

