/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.reversefactoring.primerevenue;

import com.varial.accounting.domain.payment.GeneratePayment;
import com.varial.accounting.domain.payment.GeneratePaymentRemittance;
import com.varial.accounting.domain.payment.reversefactoring.ReverseFactoringLineGeneratorImpl;
import com.varial.accounting.domain.payment.reversefactoring.format.ReverseFactoringFormatType;
import com.varial.accounting.domain.payment.reversefactoring.format.ReverseFactoringFormatterFactory;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.textoutput.FieldSeparatorType;
import com.varial.serverbase.domain.textoutput.OutputField;
import com.varial.serverbase.domain.textoutput.TextField;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PrimeRevenueReverseFactoringLineGeneratorImpl
extends ReverseFactoringLineGeneratorImpl {
    private final String buyerId;

    public PrimeRevenueReverseFactoringLineGeneratorImpl(GeneratePayment payment, String buyerId) {
        super(payment, FieldSeparatorType.COMMA, ReverseFactoringFormatterFactory.createFormatter(ReverseFactoringFormatType.PRIME_REVENUE));
        this.buyerId = buyerId;
    }

    @Override
    protected List<OutputField> createHeaderLineFields() {
        return Stream.of("BuyerID", "SupplierRefNumber", "DocType", "OrgInvDate", "Currency", "MaturityDate", "Amount", "Reference", "BuyerUniqueDocID").map(TextField::new).collect(Collectors.toList());
    }

    @Override
    protected List<OutputField> createOpenItemExportFields(GeneratePaymentRemittance remittance) {
        return List.of(this.createBuyerId(), this.createSupplierRefNumber(), this.createDocType(remittance), this.createOrgInvDate(remittance), this.createCurrency(remittance), this.createMaturityDate(remittance), this.createAmount(remittance), this.createReference(remittance), this.createBuyerUniqueDocId(remittance));
    }

    private OutputField createReference(GeneratePaymentRemittance remittance) {
        return this.createLimitedTextField(remittance.getOpenItem().getReferenceNumber(), 50);
    }

    private OutputField createBuyerUniqueDocId(GeneratePaymentRemittance remittance) {
        return this.createLimitedTextField(StringMapper.toStringWithTrim((String)this.payment.getNumberAtFactoringCompany()) + "_" + StringMapper.toStringWithTrim((String)remittance.getOpenItem().getReferenceNumber()), 100);
    }

    private OutputField createAmount(GeneratePaymentRemittance remittance) {
        BigDecimal amount = BigDecimalMapper.abs((BigDecimal)remittance.getAmountOfPayment());
        return this.createAmountField(amount, this.getOriginalCurrency(remittance));
    }

    private OutputField createMaturityDate(GeneratePaymentRemittance remittance) {
        return this.createDateField(this.getDueDate(remittance));
    }

    private OutputField createOrgInvDate(GeneratePaymentRemittance remittance) {
        return this.createDateField(remittance.getOpenItem().getDocumentDate());
    }

    private OutputField createCurrency(GeneratePaymentRemittance remittance) {
        return this.createLimitedTextField(this.getOriginalCurrency(remittance).getSwift(), 14);
    }

    private OutputField createDocType(GeneratePaymentRemittance remittance) {
        return this.createFixedTextField(remittance.isCreditNote() ? "CM" : "PO");
    }

    private OutputField createSupplierRefNumber() {
        return this.createLimitedTextField(this.payment.getNumberAtFactoringCompany(), 35);
    }

    private OutputField createBuyerId() {
        return this.createTextField(this.buyerId);
    }

    private ICurrency getOriginalCurrency(GeneratePaymentRemittance remittance) {
        return remittance.getOpenItem().getEnteredCurrency();
    }
}

