/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.reversefactoring.primerevenue;

import com.varial.accounting.domain.payment.reversefactoring.format.ReverseFactoringFormattingStrategy;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.textoutput.converter.OutputTextCleaner;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class PrimeRevenueFormattingStrategy
implements ReverseFactoringFormattingStrategy {
    @Override
    public String formatText(String value, char fieldSeparatorCharacter) {
        if (StringMapper.isNullString((String)value)) {
            return "";
        }
        String cleaned = OutputTextCleaner.cleanControlChars((String)value);
        if (cleaned.indexOf(fieldSeparatorCharacter) >= 0) {
            return "\"" + cleaned + "\"";
        }
        return cleaned;
    }

    @Override
    public String formatAmount(BigDecimal amount, ICurrency currency) {
        if (amount == null) {
            return "";
        }
        return amount.setScale(2, RoundingMode.HALF_UP).toPlainString();
    }

    @Override
    public String formatDate(Date date) {
        return DateMapper.toString((Date)date);
    }
}

