/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.reversefactoring.format;

import com.varial.accounting.domain.payment.reversefactoring.format.ReverseFactoringFormattingStrategy;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.textoutput.converter.OutputTextCleaner;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.Date;

public class ReverseFactoringFormatter {
    private final ReverseFactoringFormattingStrategy strategy;

    public ReverseFactoringFormatter(ReverseFactoringFormattingStrategy strategy) {
        this.strategy = strategy;
    }

    public String formatText(String value, char fieldSeparatorCharacter) {
        return this.strategy.formatText(value, fieldSeparatorCharacter);
    }

    public String formatAmount(BigDecimal amount, ICurrency currency) {
        return this.strategy.formatAmount(amount, currency);
    }

    public String formatDate(Date date) {
        return this.strategy.formatDate(date);
    }

    public String formatLimitedText(String value, int maxLength, char fieldSeparatorCharacter) {
        return this.prepareText(value, maxLength, fieldSeparatorCharacter);
    }

    protected String prepareText(String value, int maxLength, char fieldSeparatorCharacter) {
        if (StringMapper.isNullString((String)value)) {
            return "";
        }
        String cleaned = OutputTextCleaner.cleanControlChars((String)value);
        String truncated = cleaned.length() > maxLength ? cleaned.substring(0, maxLength) : cleaned;
        return this.strategy.formatText(truncated, fieldSeparatorCharacter);
    }
}

