/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.reversefactoring.creditagricole;

import com.varial.accounting.domain.payment.GeneratePayment;
import com.varial.accounting.domain.payment.reversefactoring.ReverseFactoringExportFactory;
import com.varial.accounting.domain.payment.reversefactoring.ReverseFactoringFileNameContext;
import com.varial.accounting.domain.payment.reversefactoring.creditagricole.CreditAgricolePaymentContext;
import com.varial.accounting.domain.payment.reversefactoring.creditagricole.CreditAgricoleReverseFactoringLineGeneratorImpl;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.serverbase.domain.textoutput.LineGenerator;
import com.varial.serverbase.mapper.DateMapper;
import java.util.Date;

public class CreditAgricoleFactory
implements ReverseFactoringExportFactory {
    private final Configuration configuration;

    public CreditAgricoleFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public LineGenerator createLineGenerator(GeneratePayment payment) throws BusinessDomainException {
        return new CreditAgricoleReverseFactoringLineGeneratorImpl(payment, new CreditAgricolePaymentContext(payment, this.configuration));
    }

    @Override
    public String createFileName(GeneratePayment payment, ReverseFactoringFileNameContext fileNameContext) {
        CreditAgricolePaymentContext context = new CreditAgricolePaymentContext(payment, this.configuration);
        return context.getContractNumber() + "_" + context.getContractType().fileName() + "_" + DateMapper.toYYYYMMDDString((Date)context.getUploadDate()) + ".csv";
    }
}

