/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.reversefactoring;

import com.infor.igf.core.util.StringUtil;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.reversefactoring.ReverseFactoringExporter;
import com.varial.accounting.domain.payment.reversefactoring.creditagricole.CreditAgricoleReverseFactoringExporter;
import com.varial.accounting.domain.payment.reversefactoring.eurofactor.EurofactorReverseFactoringExporter;
import com.varial.accounting.domain.payment.reversefactoring.format.ReverseFactoringFormatType;
import com.varial.accounting.domain.payment.reversefactoring.primerevenue.PrimeRevenueReverseFactoringExporter;
import com.varial.base.configuration.Configuration;
import com.varial.serverbase.mapper.StringMapper;

public class ReverseFactoringExporterFactory {
    private final Configuration configuration;

    public ReverseFactoringExporterFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    public ReverseFactoringExporter getReverseFactoringExporter(GeneratePaymentSession session) {
        ReverseFactoringFormatType type = this.determineFormatType();
        switch (type) {
            case CREDIT_AGRICOLE: {
                return new CreditAgricoleReverseFactoringExporter(session, this.configuration);
            }
            case PRIME_REVENUE: {
                return new PrimeRevenueReverseFactoringExporter(session);
            }
        }
        return new EurofactorReverseFactoringExporter(session);
    }

    private ReverseFactoringFormatType determineFormatType() {
        String alternativeFormat = this.configuration.getAlternativeReverseFactoringFormat();
        if (this.isCreditAgricoleFormat(alternativeFormat)) {
            return ReverseFactoringFormatType.CREDIT_AGRICOLE;
        }
        if (this.isPrimeRevenueFormat(alternativeFormat)) {
            return ReverseFactoringFormatType.PRIME_REVENUE;
        }
        return ReverseFactoringFormatType.EUROFACTOR;
    }

    private boolean isCreditAgricoleFormat(String format) {
        return StringUtil.isNotEmpty((String)format) && StringMapper.equalWithTrim((String)format, (String)CreditAgricoleReverseFactoringExporter.class.getSimpleName());
    }

    private boolean isPrimeRevenueFormat(String format) {
        return StringUtil.isNotEmpty((String)format) && StringMapper.equalWithTrim((String)format, (String)PrimeRevenueReverseFactoringExporter.class.getSimpleName());
    }
}

