/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.report.settlementadvice;

import com.infor.igf.core.util.ImageUtil;
import com.infor.igf.core.util.StringUtil;
import com.varial.accounting.domain.accountingcheck.AccountingCheckHelper;
import com.varial.accounting.domain.bankaccount.BankAccount;
import com.varial.accounting.domain.bankaccount.BankAccountPersistencyManager;
import com.varial.accounting.domain.factoringbase.FactoringHelper;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.export.PaymentExporterFactory;
import com.varial.accounting.domain.payment.report.SepaPaymentReportTranslator;
import com.varial.accounting.domain.payment.report.bacspaymentrunlist.BacsPaymentContainer;
import com.varial.accounting.servantimpl.paymentrun.PaymentRunSessionMapper;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.base.jasperreports.ReportFlags;
import com.varial.base.jasperreports.TitlePages;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.company.AddressPositionType;
import com.varial.framework.domain.company.ICompany;
import com.varial.framework.domain.correspondencetext.CorrespondenceText;
import com.varial.framework.domain.correspondencetext.LanguageVariant;
import com.varial.framework.domain.correspondencetext.LanguageVariantPlaceholderMapper;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.framework.domain.payment.sepa.data.SepaLocalInstrumentTypeEnum;
import com.varial.framework.domain.payment.sepa.data.SepaSequenceTypeEnum;
import com.varial.framework.domain.payment.sepa.data.ServiceLevelType;
import com.varial.framework.domain.printservice.ProgressInterface;
import com.varial.framework.domain.reports.JasperReportFaxDataSource;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.domain.resource.TranslatableEnum;
import com.varial.serverbase.domain.resource.TranslatableEnumUtils;
import com.varial.serverbase.domain.resource.TranslateableResourceList;
import com.varial.serverbase.domain.user.IUserPersistencyManager;
import com.varial.serverbase.domain.user.User;
import com.varial.serverbase.mapper.BigDecimalFormatter;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettlementAdviceDataSource
implements JRDataSource,
JasperReportFaxDataSource {
    private static final IUserPersistencyManager userPersistencyManager = (IUserPersistencyManager)UtilitiesManager.getBean((String)"userPersistencyManager", IUserPersistencyManager.class);
    protected static Logger LOGGER = LoggerFactory.getLogger(SettlementAdviceDataSource.class);
    private static final String EXECUTEDATE_PLACEHOLDER = "DDDA";
    private static final String PAYDATE_PLACEHOLDER = "DDDD";
    private static final String PAYTYPE_PLACEHOLDER = "TTTT";
    private static final String OWNBANKSHORTADDRESS_PLACEHOLDER = "BBBB";
    private static final String OWNBANKACCOUNTNUMBER_PLACEHOLDER = "####";
    private static final String FOREIGNBANKSHORTADDRESS_PLACEHOLDER = "CCCC";
    private static final String FOREIGNBANKACCOUNTNUMBER_PLACEHOLDER = "****";
    private static final String COMPANY_PLACEHOLDER = "ZZZZ";
    private static final String PAYEEFAX_PLACEHOLDER = "#1";
    private static final String PAYEEPHONE_PLACEHOLDER = "#2";
    private static final String FOREIGNBANKIBAN_PLACEHOLDER = "#3";
    private static final String FOREIGNBANKSWIFT_PLACEHOLDER = "#4";
    private static final String TITLE_PLACEHOLDER = "#5";
    private static final String ADVISOR_PLACEHOLDER = "#6";
    private static final String COMPANY_NAME_PLACEHOLDER = "#7";
    private static final String SEPA_CREDITOR_ID_PLACEHOLDER = "#8";
    private static final String SEPA_MANDATE = "#9";
    private static final String CONTACT_NAME_PLACEHOLDER = "#10";
    private static final String NUMBER_AT_FACTORING_COMPANY_PLACEHOLDER = "#11";
    private static final String OWNNUMBERATPARTNER_PLACEHOLDER = "#12";
    private final Language mLanguage;
    private Language mPALanguage;
    private final AccountingCompany mCompany;
    private final FinancePaymentSession mSession;
    private final boolean mIsGeneratePayment;
    private final ReportFlags mReportFlags;
    private final TitlePages mTitlePages;
    private BigDecimalFormatter mFormatter;
    private String mPersonalAccountCode;
    private String mPersonalAccountShortAddress;
    private String mEmail;
    private String mEmailCC;
    private String mFax;
    private boolean mMergeWithTemplate;
    private final LanguageVariantPlaceholderMapper mLanguageVariantPlaceholderMapper;
    private String mPAOid = "";
    private String mPayOid = "";
    private final boolean mNewDocumentIfGroupChanged;
    private boolean mGroupChanged = false;
    private boolean mHasNext = true;
    private final Iterator<BacsPaymentContainer> mIterator;
    private BacsPaymentContainer mContainer;
    private final int mRowCount;
    private int mRowsProcessed = 0;
    private final int mStepForProgressbar;
    private final String mMessagePrintData;
    private final boolean mPrintToArchive;
    private final ProgressInterface mProgressInterface;
    private List<String> mBodyTextList;
    private List<String> mFooterTextList;
    private static final String P_ADDRESSPOSITIONLEFT = "P_AddressPosition";
    private static final String P_COMPANYADDRESS = "P_CompanyAddress";
    private static final String P_COMPANYADDRESS1 = "P_CompanyAddress1";
    private static final String P_COMPANYADDRESSROW = "P_CompanyAddressRow";
    private static final String P_COMPANYSHORTNAME = "P_CompanyShortName";
    private static final String P_CURRENCY = "P_Currency";
    private static final String P_ISHEIDENHAIN = "P_IsHeidenhain";
    private static final String P_JASPERHELPER = "P_ReportFlags";
    private static final String P_LOGOOFCOMPANY = "P_LogoOfCompany";
    private static final String P_TITLEPAGES = "TitlePages";
    private static final String P_USERNAME = "P_UserName";
    private static final String P_USERPHONEFAX = "P_UserPhoneFax";
    private static final String P_USEREMAIL = "P_UserEmail";
    private static final String P_PHONEOFCOMPANY1 = "P_PhoneOfCompany1";
    private static final String P_FAXOFCOMPANY1 = "P_FaxOfCompany1";
    private static final String P_EMAILOFCOMPANY1 = "P_EmailOfCompany1";
    private static final String P_WEBOFCOMPANY1 = "P_WebOfCompany1";
    private static final String S_ACCOUNTNUMBER = "S_AccountNumber";
    private static final String S_BACS = "S_Bacs";
    private static final String S_BANKACCOUNT = "S_BankAccount";
    private static final String S_BANKNAME = "S_BankName";
    private static final String S_COMPANYNAME = "S_CompanyName";
    private static final String S_DATE = "S_Date";
    private static final String S_DISCOUNTAMOUNT = "S_DiscountAmount";
    private static final String S_LISTOFPAYMENTS = "S_ListOfPayments";
    private static final String S_OPENAMOUNT = "S_OpenAmount";
    private static final String S_OWNNUMBERATPARTNER = "S_OwnNumberAtPartner";
    private static final String S_PAGE = "S_Page";
    private static final String S_PAYMENTAMOUNT = "S_PaymentAmount";
    private static final String S_PAYMENTCURRENCY = "S_PaymentCurrency";
    private static final String S_PAYMENTDATE = "S_PaymentDate";
    private static final String S_PAYMENTTYPE = "S_PaymentType";
    private static final String S_REASON_FOR_PAYMENT = "S_ReasonForPayment";
    private static final String S_REFERENCEAMOUNT = "S_ReferenceAmount";
    private static final String S_REFERENCEDATE = "S_ReferenceDate";
    private static final String S_REFERENCENUMBER = "S_ReferenceNumber";
    private static final String S_SEQUENCENUMBER = "S_SequenceNumber";
    private static final String S_SESSIONNAME = "S_SessionName";
    private static final String S_SUBTOTAL = "S_SubTotal";
    private static final String S_SUM = "S_Sum";
    private static final String S_SUPPLIERSHORTNAME = "S_SupplierShortName";
    private static final String S_USERNAME = "S_UserName";
    private static final String S_USERPHONEFAX = "S_UserPhoneFax";
    private static final String S_USEREMAIL = "S_UserEmail";
    private static final String S_CURRENCY = "S_Currency";
    private static final String S_DEBIT = "S_Debit";
    private static final String S_CREDIT = "S_Credit";
    private static final String S_PABANKCONNECTION = "S_PABankConnection";
    private static final String S_PABANKSORTINGCODE = "S_PABankSortingCode";
    private static final String S_PABANKACCOUNT = "S_PABankAccount";
    private static final String S_PAFAX = "S_PAFax";
    private static final String S_PROCESSID = "S_ProcessId";
    private static final String S_ADVISORNAME = "S_AdvisorName";
    private static final String S_ADVISORPHONE = "S_AdvisorPhone";
    private static final String S_ADVISOREMAIL = "S_AdvisorEmail";
    private static final String S_REFERENCEDESCRIPTION = "S_ReferenceDescription";
    private static final String S_REMITTANCEDESCRIPTION = "S_RemittanceDescription";
    private static final int PAYMENTAMOUNT = 0;
    private static final int DATE = 1;
    private static final int PAGE = 2;
    private static final int REFERENCENUMBER = 3;
    private static final int SEQUENCENUMBER = 4;
    private static final int LISTOFPAYMENTS = 5;
    private static final int PAYMENTTYPE = 6;
    private static final int PAYMENTDATE = 7;
    private static final int PAYMENTCURRENCY = 8;
    private static final int BANKACCOUNT = 9;
    private static final int BANKNAME = 10;
    private static final int SESSIONNAME = 11;
    private static final int SUPPLIERSHORTNAME = 12;
    private static final int REFERENCEDATE = 13;
    private static final int REFERENCEAMOUNT = 14;
    private static final int OPENAMOUNT = 15;
    private static final int COMPANYNAME = 16;
    private static final int BACS = 17;
    private static final int DISCOUNTAMOUNT = 18;
    private static final int SUBTOTAL = 19;
    private static final int SUM = 20;
    private static final int REASONFORPAYMENT = 21;
    private static final int OWNNUMBERATPARTNER = 22;
    private static final int ACCOUNTNUMBER = 23;
    private static final int ESRREFERENZNO = 24;
    private static final int ESRATTENDANT = 25;
    private static final int USERNAME = 26;
    private static final int USERPHONEFAX = 27;
    private static final int USEREMAIL = 28;
    private static final int CURRENCY = 29;
    private static final int DEBIT = 30;
    private static final int CREDIT = 31;
    private static final int PABANKCONNECTION = 32;
    private static final int PABANKSORTINGCODE = 33;
    private static final int PABANKACCOUNT = 34;
    private static final int PAFAX = 35;
    private static final int PROCESSID = 36;
    private static final int ADVISORNAME = 37;
    private static final int ADVISORPHONE = 38;
    private static final int ADVISOREMAIL = 39;
    private static final int REFERENCEDESCRIPTION = 40;
    private static final int REMITTANCEDESCRIPTION = 41;
    private static final int REFERENCENUMBER_DE = 42;
    private static final int REFERENCENUMBER_IT = 43;
    private static final int REFERENCENUMBER_FR = 44;
    private static final int REFERENCEAMOUNT_DE = 45;
    private static final int REFERENCEAMOUNT_IT = 46;
    private static final int REFERENCEAMOUNT_FR = 47;
    private static final int PAYMENTAMOUNT_DE = 48;
    private static final int PAYMENTAMOUNT_IT = 49;
    private static final int PAYMENTAMOUNT_FR = 50;
    private static final int TOTALPAYMENTAMOUNT_DE = 51;
    private static final int TOTALPAYMENTAMOUNT_IT = 52;
    private static final int TOTALPAYMENTAMOUNT_FR = 53;
    private static TranslateableResourceList mReportList = TranslateableResourceList.createTranslateableResourceList((String)"SettlementAdviseReportList", (String[])new String[]{"Zahlbetrag", "Datum", "Seite", "Belegnummer", "Sequenznummer", "Auflistung bezahlter Rechnungen", "Zahlart", "Zahldatum", "Zahlw\u00e4hrung", "von Konto", "bei Bank", "Name der Zahlungssitzung", "Kurzname Kreditor", "Rechnungsdatum", "Rechnungsbetrag", "noch offen", "Firmenname", "\u00dcberweisung", "Skt-Betr.", "Zwischensumme", "Summen", "Verwendungszweck:", "Own Number at Partner", "Account Number", "ESR-Referenznummer", "ESR/BESR-Teilnehmer", "Kontakt", "Tel./Fax", "e-Mail", "W\u00e4hrung", "Soll", "Haben", "Ihre Bankverbindung", "Bankleitzahl", "Kontonummer", "Fax", "Auftragsnummer", "Sachbearbeiter", "Durchwahl", "E-Mail", "Beschreibung", "Verwendungszweck OP", "Vertrags-Nr.", "Numero di contratto", "Num\u00e9ro de contrat", "Betrag inkl. MwSt", "Importo IVA incl.", "Montant TVA incl.", "Einzug Betrag", "Importo addebitato", "Montant pr\u00e9lev\u00e9", "Total Einzug", "Addebito totale", "Total pr\u00e9lev\u00e9"});
    private static final String STATIC_ADVICE = "S_Advice";
    private static final int ADVICE = 0;
    private static TranslateableResourceList mBACSAdviceText = TranslateableResourceList.createTranslateableResourceList((String)"SettlementAdviseText", (String[])new String[]{"Sehr geehrte Damen und Herren,", "nachfolgend aufgef\u00fchrte Rechnungen wurden von uns am <Date> per \u00dcberweisung beglichen.", "Die Zahlung erfolgte auf Ihr Konto <BankAccount> bei <BankName>.", "Zahlungsavis", "f\u00fcr nachfolgend aufgef\u00fchrte Rechnungen f\u00fchrten wir am <Date> eine/n Lastschrift/Bankeinzug von Ihrem Konto <BankAccount> bei <BankName> durch."});
    private static final String F_ACCOUNTNUMBER = "F_AccountNumber";
    private static final String F_BANKACCOUNT = "F_BankAccount";
    private static final String F_BANKSORTCODE = "F_BankSortCode";
    private static final String F_CURRENCY = "F_Currency";
    private static final String F_DATE = "F_Date";
    private static final String F_DISCOUNTAMOUNT = "F_DiscountAmount";
    private static final String F_FORMATTER = "F_Amount_Formatter";
    private static final String F_ISDEBIT = "F_IsDebit";
    private static final String F_OIDSESSION = "F_OidSession";
    private static final String F_OPENAMOUNT = "F_OpenAmount";
    private static final String F_OWNNUMBERATPARTNER = "F_OwnNumberAtPartner";
    private static final String F_PABANKNAME = "F_PABankName";
    private static final String F_PAFAX = "F_PAFax";
    private static final String F_PAYMENTAMOUNT = "F_PaymentAmount";
    private static final String F_PAYMENTDATE = "F_PaymentDate";
    private static final String F_PAYOBJECTID = "F_PayObjectId";
    private static final String F_REFERENCEAMOUNT = "F_ReferenceAmount";
    private static final String F_REFERENCEDATE = "F_ReferenceDate";
    private static final String F_REFERENCEDESCRIPTION = "F_ReferenceDescription";
    private static final String F_REFERENCENUMBER = "F_ReferenceNumber";
    private static final String F_REMITTANCE_DESCRIPTION = "F_RemittanceDescription";
    private static final String F_SEQUENCENUMBER = "F_SequenceNumber";
    private static final String F_SESSIONNAME = "F_SessionName";
    private static final String F_SETTLEMENTAMOUNT = "F_SettlementAmount";
    private static final String F_SUPPLIERSHORTNAME = "F_SupplierShortName";
    private static final String F_SUPPLIERPOSTALADDRESS = "F_SupplierPostalAddress";
    private static final String F_SUPPLIERPOSTALADDRESSROW = "F_SupplierPostalAddressRow";
    private static final String F_SUBJECT = "F_Subject";
    private static final String F_BODYTEXT = "F_BodyText";
    private static final String F_FOOTERTEXT = "F_FooterText";
    private static final String F_ISFOREIGNPAYMENT = "F_IsForeignPayment";
    private static final String F_EXECUTEDATE = "F_ExecuteDate";
    private static final String F_EXECUTEDATEFORLANGUAGE = "F_ExecuteDateForLanguage";
    private static final String F_PROCESSID = "F_ProcessId";
    private static final String F_ADVISORNAME = "F_AdvisorName";
    private static final String F_ADVISORPHONE = "F_AdvisorPhone";
    private static final String F_ADVISOREMAIL = "F_AdvisorEmail";
    private static final String FIELD_SEPAPAYMENTINFOID = "Field_SepaPaymentInfoId";
    private static final String FIELD_SEPAFILETYPE = "Field_SepaFileType";
    private static final String FIELD_SEPASERVICELEVELTYPE = "Field_SepaServiceLevelType";
    private static final String FIELD_SEPALOCALINSTRUMENTTYPE = "Field_SepaLocalInstrumentType";
    private static final String FIELD_SEPASEQUENCETYPE = "Field_SepaSequenceType";
    private static final String FIELD_SEPAEXECUTIONDATE = "Field_SepaExecutionDate";
    private static final String F_NOTE = "F_Note";
    public static final String F_ARCHIVEKEYWORDS = "F_ArchiveKeywords";
    private static TranslateableResourceList mTitleText = TranslateableResourceList.createTranslateableResourceList((String)"TitleText", (String[])new String[]{"Sehr geehrte Damen und Herren"});

    public SettlementAdviceDataSource(List<BacsPaymentContainer> containerList, FinancePaymentSession session, boolean isGeneratePayment, Language language, boolean newDocumentIfGroupChanged, ProgressInterface progressInterface, boolean printToArchive) {
        this.mLanguage = language;
        this.mSession = session;
        this.mIsGeneratePayment = isGeneratePayment;
        this.mCompany = this.mSession.getAccountingCompany();
        this.mIterator = containerList.iterator();
        this.mProgressInterface = progressInterface;
        this.mRowCount = containerList.size();
        this.mMessagePrintData = SepaPaymentReportTranslator.getPrintData((ILanguage)language);
        this.mStepForProgressbar = AccountingCheckHelper.getStepForProgressbar((int)containerList.size());
        this.mFormatter = this.mLanguage.hasLocale() ? new BigDecimalFormatter(this.mLanguage.getLocale()) : new BigDecimalFormatter();
        this.mReportFlags = new ReportFlags();
        this.mTitlePages = new TitlePages();
        this.mTitlePages.setGroupName("ObjectGroup");
        this.mLanguageVariantPlaceholderMapper = new LanguageVariantPlaceholderMapper();
        this.mNewDocumentIfGroupChanged = newDocumentIfGroupChanged;
        this.mPrintToArchive = printToArchive;
    }

    public Map<String, Object> getParameters() throws BusinessDomainException {
        byte[] bytes = this.mCompany.getLetterTemplate();
        this.mMergeWithTemplate = bytes != null && bytes.length > 0;
        byte[] pictureInBytes = this.mCompany.getLogoAsPicture();
        Image image = null;
        if (pictureInBytes.length > 0) {
            try {
                image = ImageUtil.loadAwtImage((byte[])pictureInBytes);
            }
            catch (IOException e) {
                LOGGER.warn("Cannot convert logo bytes into an image for company {}!", (Object)this.mCompany.getCode());
            }
        }
        JasperParameterHashMap parameters = new JasperParameterHashMap();
        parameters.put(P_COMPANYADDRESS, this.mMergeWithTemplate ? null : this.mCompany.getCurrentAddress().getPostalAddress().getFormatedAddress((ICompany)this.mCompany, (ILanguage)this.mLanguage));
        parameters.put(P_COMPANYADDRESS1, this.mCompany.getCurrentAddress().getPostalAddress().getFormatedAddress((ICompany)this.mCompany, (ILanguage)this.mLanguage));
        parameters.put(P_COMPANYADDRESSROW, this.getCompanyAddressRow());
        parameters.put(P_COMPANYSHORTNAME, this.mCompany.getCurrentAddress().getShortName());
        parameters.put(P_CURRENCY, this.mCompany.getFinanceSetup().getBaseCurrency().getCode().toString());
        parameters.put(P_JASPERHELPER, this.mReportFlags);
        parameters.put(P_LOGOOFCOMPANY, this.mMergeWithTemplate ? null : image);
        parameters.put(P_TITLEPAGES, this.mTitlePages);
        parameters.put(S_BACS, mReportList.getString((ILanguage)this.mLanguage, 17));
        parameters.put(S_BANKACCOUNT, mReportList.getString((ILanguage)this.mLanguage, 9));
        parameters.put(S_BANKNAME, mReportList.getString((ILanguage)this.mLanguage, 10));
        parameters.put(S_COMPANYNAME, mReportList.getString((ILanguage)this.mLanguage, 16));
        parameters.put(S_DATE, mReportList.getString((ILanguage)this.mLanguage, 1));
        parameters.put(S_DISCOUNTAMOUNT, mReportList.getString((ILanguage)this.mLanguage, 18));
        parameters.put(S_LISTOFPAYMENTS, mReportList.getString((ILanguage)this.mLanguage, 5));
        parameters.put(S_OPENAMOUNT, mReportList.getString((ILanguage)this.mLanguage, 15));
        parameters.put(S_OWNNUMBERATPARTNER, mReportList.getString((ILanguage)this.mLanguage, 22));
        parameters.put(S_PAGE, mReportList.getString((ILanguage)this.mLanguage, 2));
        parameters.put(S_PAYMENTAMOUNT, mReportList.getString((ILanguage)this.mLanguage, 0));
        parameters.put(S_PAYMENTCURRENCY, mReportList.getString((ILanguage)this.mLanguage, 8));
        parameters.put(S_PAYMENTDATE, mReportList.getString((ILanguage)this.mLanguage, 7));
        parameters.put(S_PAYMENTTYPE, mReportList.getString((ILanguage)this.mLanguage, 6));
        parameters.put(S_REASON_FOR_PAYMENT, mReportList.getString((ILanguage)this.mLanguage, 21));
        parameters.put(S_REFERENCEAMOUNT, mReportList.getString((ILanguage)this.mLanguage, 14));
        parameters.put(S_REFERENCEDATE, mReportList.getString((ILanguage)this.mLanguage, 13));
        parameters.put(S_REFERENCENUMBER, mReportList.getString((ILanguage)this.mLanguage, 3));
        parameters.put(S_SEQUENCENUMBER, mReportList.getString((ILanguage)this.mLanguage, 4));
        parameters.put(S_SESSIONNAME, mReportList.getString((ILanguage)this.mLanguage, 11));
        parameters.put(S_SUBTOTAL, mReportList.getString((ILanguage)this.mLanguage, 19));
        parameters.put(S_SUM, mReportList.getString((ILanguage)this.mLanguage, 20));
        parameters.put(S_SUPPLIERSHORTNAME, mReportList.getString((ILanguage)this.mLanguage, 12));
        parameters.put(STATIC_ADVICE, mBACSAdviceText.getString((ILanguage)this.mLanguage, 0));
        parameters.put(P_ADDRESSPOSITIONLEFT, this.mCompany.getAddressPositionType() == AddressPositionType.LEFT);
        parameters.put(P_ISHEIDENHAIN, Boolean.FALSE);
        parameters.put(P_PHONEOFCOMPANY1, this.mCompany.getElectronicAddress().getPhoneNumber());
        parameters.put(P_FAXOFCOMPANY1, this.mCompany.getElectronicAddress().getFax());
        parameters.put(P_EMAILOFCOMPANY1, this.mCompany.getElectronicAddress().getEMail());
        parameters.put(P_WEBOFCOMPANY1, this.mCompany.getElectronicAddress().getHomepageURL());
        User user = userPersistencyManager.query(SessionContext.getInstance().getSession().getUserCode());
        parameters.put(P_USERNAME, user.getName());
        parameters.put(P_USERPHONEFAX, user.getPhone());
        parameters.put(P_USEREMAIL, user.getEmail());
        parameters.put(S_REFERENCEDESCRIPTION, mReportList.getString((ILanguage)this.mLanguage, 40));
        parameters.put(S_REMITTANCEDESCRIPTION, mReportList.getString((ILanguage)this.mLanguage, 41));
        return parameters;
    }

    private String getCompanyAddressRow() throws BusinessDomainException {
        String result = this.mCompany.getCurrentAddress().getPostalAddress().getFormatedAddressRow((ICompany)this.mCompany, (ILanguage)this.mLanguage, " - ");
        return result;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (this.mContainer != null) {
            try {
                if (F_FORMATTER.equals(field.getName())) {
                    value = new BigDecimalFormatter(this.mPALanguage.getLocale(), Integer.valueOf(Math.abs(this.mContainer.getCurrency().getDecimalplaces())));
                } else if (F_NOTE.equals(field.getName())) {
                    value = this.mContainer.getNote();
                } else if (F_BANKSORTCODE.equals(field.getName())) {
                    value = this.mContainer.getBankSortingCode();
                } else if (F_BANKACCOUNT.equals(field.getName())) {
                    value = this.mContainer.getBankAccountNumber();
                } else if (F_REFERENCENUMBER.equals(field.getName())) {
                    value = this.mContainer.getReferenceNumber();
                } else if (F_SEQUENCENUMBER.equals(field.getName())) {
                    value = this.mContainer.getSequenceNumber();
                } else if (F_REFERENCEDESCRIPTION.equals(field.getName())) {
                    value = this.mContainer.getReferenceDescription();
                } else if (F_OIDSESSION.equals(field.getName())) {
                    value = this.mSession.getObjectid();
                } else if (F_SESSIONNAME.equals(field.getName())) {
                    value = this.mSession.getName();
                } else if (F_SUPPLIERSHORTNAME.equals(field.getName())) {
                    value = this.mContainer.getPAShortName();
                } else if (F_SUPPLIERPOSTALADDRESS.equals(field.getName())) {
                    value = this.mContainer.getPAPostalAddress().getFormatedAddressWithPostOfficeBox((ICompany)this.mCompany, (ILanguage)this.mLanguage);
                } else if (F_SUPPLIERPOSTALADDRESSROW.equals(field.getName())) {
                    value = this.mContainer.getPAPostalAddress().getFormatedAddressRow((ICompany)this.mCompany, (ILanguage)this.mLanguage, " - ");
                } else if (F_CURRENCY.equals(field.getName())) {
                    value = this.mContainer.getCurrency().getCode();
                } else if (F_PAYOBJECTID.equals(field.getName())) {
                    value = this.mContainer.getPayObjectId();
                } else if (F_REMITTANCE_DESCRIPTION.equals(field.getName())) {
                    value = this.mContainer.getRemittanceDescription();
                } else if (F_SUBJECT.equals(field.getName())) {
                    value = this.mLanguageVariantPlaceholderMapper.getSubject();
                } else if (F_BODYTEXT.equals(field.getName())) {
                    value = this.mLanguageVariantPlaceholderMapper.getBodyText();
                } else if (field.getName().startsWith("F_BodyTextAscii")) {
                    int count = Integer.parseInt(field.getName().substring(field.getName().indexOf("F_BodyTextAscii") + "F_BodyTextAscii".length()));
                    if (this.mBodyTextList.size() >= count) {
                        value = this.mBodyTextList.get(count);
                    }
                } else if (F_FOOTERTEXT.equals(field.getName())) {
                    value = this.mLanguageVariantPlaceholderMapper.getFooterText();
                } else if (field.getName().startsWith("F_FooterTextAscii")) {
                    int count = Integer.parseInt(field.getName().substring(field.getName().indexOf("F_FooterTextAscii") + "F_FooterTextAscii".length()));
                    if (this.mFooterTextList.size() >= count) {
                        value = this.mFooterTextList.get(count);
                    }
                } else if (F_OWNNUMBERATPARTNER.equals(field.getName())) {
                    value = this.mContainer.getOwnNumberAtPartner();
                } else if (F_ACCOUNTNUMBER.equals(field.getName())) {
                    value = this.mContainer.getPACode();
                } else if (F_ISFOREIGNPAYMENT.equals(field.getName())) {
                    value = this.mSession.getIsForeignPayment();
                } else if (F_EXECUTEDATE.equals(field.getName())) {
                    value = "";
                } else if (F_EXECUTEDATEFORLANGUAGE.equals(field.getName())) {
                    value = DateMapper.toString((ILanguage)this.mLanguage, (Date)this.mContainer.getSepaExecutionDate());
                } else if (F_PAYMENTAMOUNT.equals(field.getName())) {
                    value = this.mContainer.getPaymentAmount();
                } else if (F_SETTLEMENTAMOUNT.equals(field.getName())) {
                    value = this.mContainer.getRemittanceSettlementAmount();
                } else if (F_REFERENCEAMOUNT.equals(field.getName())) {
                    value = this.mContainer.getAmount();
                } else if (F_OPENAMOUNT.equals(field.getName())) {
                    value = this.mContainer.getOpenAmount();
                } else if (F_DISCOUNTAMOUNT.equals(field.getName())) {
                    value = this.mContainer.getDiscountAmount();
                } else if (F_PAYMENTDATE.equals(field.getName())) {
                    value = DateMapper.toString((ILanguage)this.mPALanguage, (Date)this.mContainer.getDocumentDate());
                } else if (F_REFERENCEDATE.equals(field.getName())) {
                    value = DateMapper.toString((ILanguage)this.mPALanguage, (Date)this.mContainer.getRemittanceDate());
                } else if (F_DATE.equals(field.getName())) {
                    value = DateMapper.toString((ILanguage)this.mPALanguage, (Date)this.getRemittanceAdviceDate());
                } else if (F_ISDEBIT.equals(field.getName())) {
                    value = this.mContainer.isDebit() ? Boolean.TRUE : Boolean.FALSE;
                } else if (F_PABANKNAME.equals(field.getName())) {
                    value = this.mContainer.getBankName();
                } else if (F_PAFAX.equals(field.getName())) {
                    value = this.mContainer.getPayeeFaxNo();
                } else if (F_PROCESSID.equals(field.getName())) {
                    value = this.mContainer.getProcessId();
                } else if (F_ADVISORNAME.equals(field.getName())) {
                    value = this.mContainer.getAdvisorName();
                } else if (F_ADVISORPHONE.equals(field.getName())) {
                    value = this.mContainer.getAdvisorPhone();
                } else if (F_ADVISOREMAIL.equals(field.getName())) {
                    value = this.mContainer.getAdvisorEmail();
                } else if (FIELD_SEPAPAYMENTINFOID.equals(field.getName())) {
                    value = this.mContainer.getSepaPaymentInfoId();
                } else if (FIELD_SEPAFILETYPE.equals(field.getName())) {
                    value = SepaPaymentReportTranslator.getSepaFileType((ServiceLevelType)this.mContainer.getSepaServiceLevelType(), (SepaLocalInstrumentTypeEnum)this.mContainer.getSepaLocalInstrumentType(), (PaymentExporterFactory.PaymentExporterType)this.mContainer.getPaymentExporterType(), (ILanguage)this.mLanguage);
                } else if (FIELD_SEPASERVICELEVELTYPE.equals(field.getName())) {
                    value = SepaPaymentReportTranslator.getServiceLevelType((ILanguage)this.mLanguage, (ServiceLevelType)this.mContainer.getSepaServiceLevelType());
                } else if (FIELD_SEPALOCALINSTRUMENTTYPE.equals(field.getName())) {
                    value = SepaPaymentReportTranslator.getSepaLocalInstrumentType((ILanguage)this.mLanguage, (SepaLocalInstrumentTypeEnum)this.mContainer.getSepaLocalInstrumentType());
                } else if (FIELD_SEPASEQUENCETYPE.equals(field.getName())) {
                    value = SepaPaymentReportTranslator.getSepaSequenceType((ILanguage)this.mLanguage, (SepaSequenceTypeEnum)this.mContainer.getSepaSequenceType());
                } else if (FIELD_SEPAEXECUTIONDATE.equals(field.getName())) {
                    value = DateMapper.toString((ILanguage)this.mLanguage, (Date)this.mContainer.getSepaExecutionDate());
                } else if (this.mPrintToArchive && F_ARCHIVEKEYWORDS.equals(field.getName())) {
                    value = this.getArchiveKeywords();
                } else if (STATIC_ADVICE.equals(field.getName())) {
                    value = mBACSAdviceText.getString((ILanguage)this.mPALanguage, 0);
                } else if (S_DATE.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 1);
                } else if (S_PAGE.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 2);
                } else if (S_OPENAMOUNT.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 15);
                } else if (S_DISCOUNTAMOUNT.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 18);
                    if (ISoftware.useAlternativePaymentAVISForRaiffeisenCH() && this.mContainer.getPersonalAccount().isCustomer()) {
                        if (this.mPALanguage.getIsoLocale().equals("de-DE")) {
                            value = mReportList.getString((ILanguage)this.mPALanguage, 51);
                        }
                        if (this.mPALanguage.getIsoLocale().equals("it-IT")) {
                            value = mReportList.getString((ILanguage)this.mPALanguage, 52);
                        }
                        if (this.mPALanguage.getIsoLocale().equals("fr-FR")) {
                            value = mReportList.getString((ILanguage)this.mPALanguage, 53);
                        }
                    }
                } else if (S_OWNNUMBERATPARTNER.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 22);
                } else if (S_ACCOUNTNUMBER.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 23);
                } else if (S_REASON_FOR_PAYMENT.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 21);
                } else if (S_PAYMENTAMOUNT.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 0);
                    if (ISoftware.useAlternativePaymentAVISForRaiffeisenCH() && this.mContainer.getPersonalAccount().isCustomer()) {
                        if (this.mPALanguage.getIsoLocale().equals("de-DE")) {
                            value = mReportList.getString((ILanguage)this.mPALanguage, 48);
                        }
                        if (this.mPALanguage.getIsoLocale().equals("it-IT")) {
                            value = mReportList.getString((ILanguage)this.mPALanguage, 49);
                        }
                        if (this.mPALanguage.getIsoLocale().equals("fr-FR")) {
                            value = mReportList.getString((ILanguage)this.mPALanguage, 50);
                        }
                    }
                } else if (S_REFERENCEDATE.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 13);
                } else if (S_REFERENCEAMOUNT.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 14);
                    if (ISoftware.useAlternativePaymentAVISForRaiffeisenCH() && this.mContainer.getPersonalAccount().isCustomer()) {
                        if (this.mPALanguage.getIsoLocale().equals("de-DE")) {
                            value = mReportList.getString((ILanguage)this.mPALanguage, 45);
                        }
                        if (this.mPALanguage.getIsoLocale().equals("it-IT")) {
                            value = mReportList.getString((ILanguage)this.mPALanguage, 46);
                        }
                        if (this.mPALanguage.getIsoLocale().equals("fr-FR")) {
                            value = mReportList.getString((ILanguage)this.mPALanguage, 47);
                        }
                    }
                } else if (S_REFERENCENUMBER.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 3);
                    if (ISoftware.useAlternativePaymentAVISForRaiffeisenCH() && this.mContainer.getPersonalAccount().isCustomer()) {
                        if (this.mPALanguage.getIsoLocale().equals("de-DE")) {
                            value = mReportList.getString((ILanguage)this.mPALanguage, 42);
                        }
                        if (this.mPALanguage.getIsoLocale().equals("it-IT")) {
                            value = mReportList.getString((ILanguage)this.mPALanguage, 43);
                        }
                        if (this.mPALanguage.getIsoLocale().equals("fr-FR")) {
                            value = mReportList.getString((ILanguage)this.mPALanguage, 44);
                        }
                    }
                } else if (S_SEQUENCENUMBER.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 4);
                } else if (S_SUBTOTAL.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 19);
                } else if (S_SUM.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 20);
                } else if (S_USERNAME.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 26);
                } else if (S_USERPHONEFAX.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 27);
                } else if (S_USEREMAIL.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 28);
                } else if (S_CURRENCY.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 29);
                } else if (S_DEBIT.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 30);
                } else if (S_CREDIT.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 31);
                } else if (S_PABANKCONNECTION.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 32);
                } else if (S_PABANKSORTINGCODE.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 33);
                } else if (S_PABANKACCOUNT.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 34);
                } else if (S_PAFAX.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 35);
                } else if (S_PROCESSID.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 36);
                } else if (S_ADVISORNAME.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 37);
                } else if (S_ADVISORPHONE.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 38);
                } else if (S_ADVISOREMAIL.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 39);
                } else if (S_REFERENCEDESCRIPTION.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 40);
                } else if (S_REMITTANCEDESCRIPTION.equals(field.getName())) {
                    value = mReportList.getString((ILanguage)this.mPALanguage, 41);
                }
                if (value instanceof String) {
                    value = StringUtil.toJasperString((String)value);
                }
            }
            catch (Exception e) {
                ExceptionMapper.printException((Throwable)e);
            }
        }
        return value;
    }

    public boolean next() throws JRException {
        boolean result = false;
        try {
            if (this.mNewDocumentIfGroupChanged) {
                if (this.mGroupChanged) {
                    this.mGroupChanged = false;
                    result = true;
                } else {
                    this.mHasNext = this.mIterator.hasNext();
                    result = this.mHasNext;
                    if (result) {
                        BacsPaymentContainer container = this.mIterator.next();
                        if (this.mContainer == null || container.getOidPersonalAccount().equals(this.mContainer.getOidPersonalAccount())) {
                            this.mGroupChanged = false;
                        } else {
                            this.mGroupChanged = true;
                            result = false;
                        }
                        this.mContainer = container;
                        ++this.mRowsProcessed;
                        if (this.mRowsProcessed % this.mStepForProgressbar == 0) {
                            this.mProgressInterface.updateProgress(this.mRowsProcessed, this.mRowCount, this.mMessagePrintData, 3, 3);
                        }
                    }
                }
            } else {
                this.mHasNext = this.mIterator.hasNext();
                result = this.mHasNext;
                if (result) {
                    this.mContainer = this.mIterator.next();
                }
            }
            if (result && this.mContainer != null && !this.mGroupChanged) {
                this.initCurrentObject();
                if (this.mIsGeneratePayment) {
                    this.buildMessageStrings();
                }
                ++this.mRowsProcessed;
                if (this.mRowsProcessed % this.mStepForProgressbar == 0) {
                    this.mProgressInterface.updateProgress(this.mRowsProcessed, this.mRowCount, this.mMessagePrintData, 3, 3);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return result;
    }

    private void buildMessageStrings() throws BusinessDomainException {
        if (this.mContainer != null && (this.personalAccountChanged(this.mContainer.getOidPersonalAccount()) || this.payObjectIdChanged(this.mContainer.getPayObjectId()))) {
            CorrespondenceText corrText;
            LanguageVariant lv;
            BankAccount companyBankAccount = ((BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class)).getBankAccountOrNull(this.mContainer.getOidBankAccount());
            GeneratePaymentSession gps = PaymentRunSessionMapper.getGeneratePaymentSession((String)this.mSession.getObjectid());
            if (gps.getCorrespondenceText() != null && (lv = (corrText = gps.getCorrespondenceText()).getLanguageVariant(this.mPALanguage)) != null) {
                this.mLanguageVariantPlaceholderMapper.setLanguageVariant(lv);
                this.replaceOwnNumberAtPartnerPlaceholder();
                this.replaceNumberAtFactoringCompanyPlaceholder();
                this.replaceContactNamePlaceholder();
                this.replaceSepaMandatePlaceholder();
                this.replaceSepaCreditorIdPlaceholder();
                this.replaceCompanyNamePlaceholder();
                this.replaceAdvisorPlaceholder();
                this.replaceTitlePlaceholder();
                this.replaceForeignBankSwiftPlaceholder();
                this.replaceForeignBankIBANPlaceholder();
                this.replacePayeePhonePlaceholder();
                this.replacePayeeFaxPlaceholder();
                this.replacePayDatePlaceholder();
                this.replaceExecuteDatePlaceholder();
                this.replacePayTypePlaceholder();
                this.replaceOwnBankShortAddressPlaceholder(companyBankAccount);
                this.replaceOwnBankAccountNumberPlaceholder(companyBankAccount);
                this.replaceForeignBankShortAddressPlaceholder();
                this.replaceForeignBankAccountNumberPlaceholder();
                this.replaceCompanyPlaceholder();
                this.makeBodyAndFooterLists(this.mLanguageVariantPlaceholderMapper);
            }
        }
    }

    private void makeBodyAndFooterLists(LanguageVariantPlaceholderMapper lv) {
        this.mBodyTextList = new ArrayList<String>();
        this.mFooterTextList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(lv.getBodyText(), "\n");
        while (tokenizer.hasMoreElements()) {
            this.mBodyTextList.add((String)tokenizer.nextElement());
        }
        tokenizer = new StringTokenizer(lv.getFooterText(), "\n");
        while (tokenizer.hasMoreElements()) {
            this.mFooterTextList.add((String)tokenizer.nextElement());
        }
    }

    private boolean personalAccountChanged(String oidPA) {
        if (this.mPAOid.equals(oidPA)) {
            return false;
        }
        this.mPAOid = oidPA;
        return true;
    }

    private boolean payObjectIdChanged(String payObjectId) {
        if (this.mPayOid.equals(payObjectId)) {
            return false;
        }
        this.mPayOid = payObjectId;
        return true;
    }

    private void initCurrentObject() {
        this.mPersonalAccountCode = this.mContainer.getPACode();
        this.mPersonalAccountShortAddress = this.mContainer.getPAShortAddress();
        this.mEmail = this.mContainer.getEmail();
        if (StringMapper.isNullString((String)this.mEmail)) {
            this.mEmail = this.mContainer.getDefaultEmail();
        }
        this.mEmailCC = this.mContainer.getEmailCC();
        this.mFax = this.mContainer.getFax();
        if (StringMapper.isNullString((String)this.mFax)) {
            this.mFax = this.mContainer.getDefaultFax();
        }
        this.mPALanguage = this.mContainer.getPALanguage();
        this.mFormatter.setLocale(this.mPALanguage.getLocale());
    }

    public String getSubjectText() {
        return this.mLanguageVariantPlaceholderMapper.getSubject();
    }

    public String getBodyText() {
        return this.mLanguageVariantPlaceholderMapper.getBodyText();
    }

    public String getFooterText() {
        return this.mLanguageVariantPlaceholderMapper.getFooterText();
    }

    public String getEmailText() {
        return this.mLanguageVariantPlaceholderMapper.getEmailText();
    }

    public String getPersonalAccountCode() {
        return this.mPersonalAccountCode;
    }

    public String getPersonalAccountShortAddress() {
        return this.mPersonalAccountShortAddress;
    }

    public String getEmail() {
        return this.mEmail;
    }

    public String getEmailCC() {
        return this.mEmailCC;
    }

    public String getFaxNumber() {
        return this.mFax;
    }

    public static String getTitleText(Language language) {
        return mTitleText.getString((ILanguage)language, 0);
    }

    public boolean hasNext() {
        return this.mHasNext;
    }

    private void replaceExecuteDatePlaceholder() {
        String value = DateMapper.toString((ILanguage)this.mPALanguage, (Date)this.mSession.getExecuteDate());
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(EXECUTEDATE_PLACEHOLDER, value);
    }

    private void replacePayDatePlaceholder() {
        Date executeDate = this.mContainer.getSepaExecutionDate();
        if (executeDate == null) {
            executeDate = this.mContainer.getDocumentDate();
        }
        String value = DateMapper.toString((ILanguage)this.mPALanguage, (Date)executeDate);
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(PAYDATE_PLACEHOLDER, value);
    }

    private void replacePayTypePlaceholder() {
        String value = TranslatableEnumUtils.getInstance().toString((ILanguage)this.mPALanguage, (TranslatableEnum)this.mContainer.getPaymentType());
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(PAYTYPE_PLACEHOLDER, value);
    }

    private void replaceOwnBankShortAddressPlaceholder(BankAccount companyBankAccount) {
        if (companyBankAccount != null) {
            String value = companyBankAccount.getBankData().getBankName();
            this.mLanguageVariantPlaceholderMapper.replacePlaceholder(OWNBANKSHORTADDRESS_PLACEHOLDER, value);
        }
    }

    private void replaceOwnBankAccountNumberPlaceholder(BankAccount companyBankAccount) {
        if (companyBankAccount != null) {
            String value = companyBankAccount.getBankAccountNumber();
            this.mLanguageVariantPlaceholderMapper.replacePlaceholder(OWNBANKACCOUNTNUMBER_PLACEHOLDER, value);
        }
    }

    private void replaceForeignBankShortAddressPlaceholder() {
        String value = this.mContainer.getBankName();
        if (!StringMapper.isNullString((String)this.mContainer.getMemberNumber())) {
            value = mReportList.getString((ILanguage)this.mLanguage, 25).concat(" ").concat(this.mContainer.getMemberNumber());
        }
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(FOREIGNBANKSHORTADDRESS_PLACEHOLDER, value);
    }

    private void replaceForeignBankAccountNumberPlaceholder() {
        String value = this.mContainer.getBankAccountNumber();
        if (!StringMapper.isNullString((String)this.mContainer.getEsrNumber())) {
            value = mReportList.getString((ILanguage)this.mLanguage, 24).concat(" ").concat(this.mContainer.getEsrNumber());
        } else if (!StringMapper.isNullString((String)this.mContainer.getPostchequeAccount())) {
            value = this.mContainer.getPostchequeAccount();
        }
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(FOREIGNBANKACCOUNTNUMBER_PLACEHOLDER, value);
    }

    private void replaceForeignBankIBANPlaceholder() {
        String value = this.mContainer.getPAIban();
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(FOREIGNBANKIBAN_PLACEHOLDER, value);
    }

    private void replaceForeignBankSwiftPlaceholder() {
        String value = this.mContainer.getSwift();
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(FOREIGNBANKSWIFT_PLACEHOLDER, value);
    }

    private void replaceCompanyPlaceholder() throws BusinessDomainException {
        String value = this.mCompany.getCurrentAddress().getShortName();
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(COMPANY_PLACEHOLDER, value);
    }

    private void replacePayeePhonePlaceholder() {
        String value = this.mContainer.getPayeePhoneNo();
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(PAYEEPHONE_PLACEHOLDER, value);
    }

    private void replacePayeeFaxPlaceholder() {
        String value = this.mContainer.getPayeeFaxNo();
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(PAYEEFAX_PLACEHOLDER, value);
    }

    private void replaceTitlePlaceholder() {
        String value = SettlementAdviceDataSource.getTitleText(this.mLanguage);
        if (!StringMapper.isNullString((String)this.mContainer.getTitle())) {
            value = this.mContainer.getTitle();
        }
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(TITLE_PLACEHOLDER, value);
    }

    private void replaceAdvisorPlaceholder() {
        String value = this.mContainer.getAdvisorName();
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(ADVISOR_PLACEHOLDER, value);
    }

    private void replaceCompanyNamePlaceholder() throws BusinessDomainException {
        String value = "";
        if (this.mCompany.getCurrentAddress() != null && this.mCompany.getCurrentAddress().getPostalAddress() != null && !StringMapper.isNullString((String)this.mCompany.getCurrentAddress().getPostalAddress().getName())) {
            value = FactoringHelper.checkField((String)this.mCompany.getCurrentAddress().getPostalAddress().getName());
        }
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(COMPANY_NAME_PLACEHOLDER, value);
    }

    private void replaceSepaCreditorIdPlaceholder() throws BusinessDomainException {
        String value = this.mCompany.getUniqueCreditorIdent();
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(SEPA_CREDITOR_ID_PLACEHOLDER, value);
    }

    private void replaceSepaMandatePlaceholder() throws BusinessDomainException {
        String value = this.mContainer.getSepaMandat();
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(SEPA_MANDATE, value);
    }

    private void replaceNumberAtFactoringCompanyPlaceholder() {
        String value = this.mContainer.getNumberAtFactoringCompany();
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(NUMBER_AT_FACTORING_COMPANY_PLACEHOLDER, value);
    }

    private void replaceContactNamePlaceholder() {
        String value = this.mContainer.getContactName();
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(CONTACT_NAME_PLACEHOLDER, value);
    }

    private void replaceOwnNumberAtPartnerPlaceholder() {
        String value = this.mContainer.getOwnNumberAtPartner();
        this.mLanguageVariantPlaceholderMapper.replacePlaceholder(OWNNUMBERATPARTNER_PLACEHOLDER, value);
    }

    private Date getRemittanceAdviceDate() {
        Date remittanceAdviceDate = null;
        if (this.mSession.isGeneratePaymentSession()) {
            remittanceAdviceDate = ((GeneratePaymentSession)this.mSession).getRemittanceAdviceDate();
        }
        if (remittanceAdviceDate == null) {
            remittanceAdviceDate = DateHelper.today();
        }
        return remittanceAdviceDate;
    }

    private Object getArchiveKeywords() throws BusinessDomainException {
        StringBuilder strBuffer = new StringBuilder();
        strBuffer.append("C21003:");
        strBuffer.append(DateMapper.toDDMMYYYYPointSeparationString((Date)((GeneratePaymentSession)this.mSession).getBaseDatePayment())).append(' ');
        strBuffer.append("C21004:");
        strBuffer.append(this.mCompany.getCode()).append(' ');
        strBuffer.append("C21005:");
        strBuffer.append(((GeneratePaymentSession)this.mSession).getFinancialYear().getCode()).append(' ');
        strBuffer.append("C21007:");
        strBuffer.append(this.mPersonalAccountCode).append(' ');
        strBuffer.append("C21008:");
        strBuffer.append(this.mPersonalAccountShortAddress).append(' ');
        strBuffer.append("C21042:");
        strBuffer.append(DateMapper.toDDMMYYYYPointSeparationString((Date)((GeneratePaymentSession)this.mSession).getRemittanceAdviceDate())).append(' ');
        strBuffer.append("C21030:Zahlungsavis ");
        return strBuffer.toString();
    }
}

