/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.iso20022.schema.v10.credit.sepa;

import com.varial.accounting.domain.payment.export.xml.XmlPaymentDataUtils;
import com.varial.accounting.domain.payment.iso20022.core.schema.IsoPaymentProfile;
import com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common.CreditPartyIdentificationBuilder10;
import com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common.CreditPostalAddressBuilder10;
import com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common.CreditSchemaMapper;
import com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common.CreditSchemaMappingContextFactory;
import com.varial.framework.domain.payment.sepa.data.PartyData;
import com.varial.framework.domain.payment.sepa.data.PaymentData;
import com.varial.framework.domain.payment.sepa.schema.PartyIdentificationBuilder;
import com.varial.framework.domain.payment.sepa.schema.PostalAddressBuilder;
import iso.sepa.version10.credit.BranchAndFinancialInstitutionIdentification6;
import iso.sepa.version10.credit.GenericOrganisationIdentification1;
import iso.sepa.version10.credit.OrganisationIdentification29;
import iso.sepa.version10.credit.OrganisationIdentificationSchemeName1Choice;
import iso.sepa.version10.credit.Party38Choice;
import iso.sepa.version10.credit.PartyIdentification135;

public class SepaCreditSchemaMapper
extends CreditSchemaMapper {
    public SepaCreditSchemaMapper(IsoPaymentProfile paymentProfile) {
        super(new CreditSchemaMappingContextFactory().createSepaContext(paymentProfile));
    }

    @Override
    public PartyIdentification135 mapDebtor(PartyData debtor) {
        PartyIdentification135 result;
        PartyIdentificationBuilder builder = new CreditPartyIdentificationBuilder10().setName(debtor.getName());
        if (this.context.getDebtorAddressPresenceStrategy().isPostalAddressRequired()) {
            builder.setPostalAddressBuilder((PostalAddressBuilder)new CreditPostalAddressBuilder10(XmlPaymentDataUtils.getAddress((PartyData)debtor)));
        }
        if ((result = (PartyIdentification135)builder.build()) != null && this.context.getDebtorStrategy().isDebtorIdApplicable()) {
            this.context.getDebtorStrategy().getDebtorId(debtor).map(this::mapDebtorId).ifPresent(arg_0 -> ((PartyIdentification135)result).setId(arg_0));
        }
        return result;
    }

    private Party38Choice mapDebtorId(String serviceID) {
        Party38Choice id = new Party38Choice();
        id.setOrgId(this.mapDebtorOrgId(serviceID));
        return id;
    }

    private OrganisationIdentification29 mapDebtorOrgId(String serviceID) {
        OrganisationIdentification29 orgId = new OrganisationIdentification29();
        GenericOrganisationIdentification1 othr = new GenericOrganisationIdentification1();
        othr.setId(serviceID);
        OrganisationIdentificationSchemeName1Choice schemeName = new OrganisationIdentificationSchemeName1Choice();
        schemeName.setCd("BANK");
        othr.setSchmeNm(schemeName);
        orgId.getOthr().add(othr);
        return orgId;
    }

    @Override
    protected BranchAndFinancialInstitutionIdentification6 mapCreditorAgent(PaymentData payment) {
        return this.mapFinancialInstitution(payment.getBic());
    }

    @Override
    public PartyIdentification135 mapInitiatingParty(PartyData initiatingParty) {
        PartyIdentification135 result = (PartyIdentification135)new CreditPartyIdentificationBuilder10().setName(initiatingParty.getName()).build();
        if (result != null && this.context.getInitiatingPartyStrategy().isCompanyIdApplicable()) {
            this.context.getInitiatingPartyStrategy().getCompanyId(initiatingParty).map(this::mapCompanyId).ifPresent(arg_0 -> ((PartyIdentification135)result).setId(arg_0));
        }
        return result;
    }

    private Party38Choice mapCompanyId(String companyId) {
        Party38Choice id = new Party38Choice();
        OrganisationIdentification29 orgId = new OrganisationIdentification29();
        GenericOrganisationIdentification1 genOrgId = new GenericOrganisationIdentification1();
        genOrgId.setId(companyId);
        orgId.getOthr().add(genOrgId);
        id.setOrgId(orgId);
        return id;
    }
}

