/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common;

import com.varial.accounting.domain.payment.iso20022.common.strategy.CreDtTmStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.PostalAddressPresenceStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.BatchBookingStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.CashAccountStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.ChargesStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.DebtorAccountCurrencyPresenceStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.DebtorStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.InitiatingPartyStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.IntermediaryAccountStrategy;
import com.varial.framework.domain.payment.sepa.schema.PostalAddressStrategy;
import iso.sepa.version10.credit.PostalAddress24;

public class CreditSchemaMappingContext {
    private final IntermediaryAccountStrategy intermediaryAccountStrategy;
    private final ChargesStrategy chargesStrategy;
    private final BatchBookingStrategy batchBookingStrategy;
    private final PostalAddressStrategy<PostalAddress24> creditorAddressStrategy;
    private final DebtorStrategy debtorStrategy;
    private final InitiatingPartyStrategy initiatingPartyStrategy;
    private final CashAccountStrategy cashAccountStrategy;
    private final CreDtTmStrategy creDtTmStrategy;
    private final PostalAddressPresenceStrategy debtorAddressPresenceStrategy;
    private final DebtorAccountCurrencyPresenceStrategy debtorAccountCurrencyPresenceStrategy;

    private CreditSchemaMappingContext(Builder builder) {
        this.intermediaryAccountStrategy = builder.intermediaryAccountStrategy;
        this.chargesStrategy = builder.chargesStrategy;
        this.batchBookingStrategy = builder.batchBookingStrategy;
        this.creditorAddressStrategy = builder.creditorAddressStrategy;
        this.debtorStrategy = builder.debtorStrategy;
        this.initiatingPartyStrategy = builder.initiatingPartyStrategy;
        this.cashAccountStrategy = builder.cashAccountStrategy;
        this.creDtTmStrategy = builder.creDtTmStrategy;
        this.debtorAddressPresenceStrategy = builder.debtorAddressPresenceStrategy;
        this.debtorAccountCurrencyPresenceStrategy = builder.debtorAccountCurrencyPresenceStrategy != null ? builder.debtorAccountCurrencyPresenceStrategy : DebtorAccountCurrencyPresenceStrategy.none();
    }

    public IntermediaryAccountStrategy getIntermediaryAccountStrategy() {
        return this.intermediaryAccountStrategy;
    }

    public ChargesStrategy getChargesStrategy() {
        return this.chargesStrategy;
    }

    public BatchBookingStrategy getBatchBookingStrategy() {
        return this.batchBookingStrategy;
    }

    public PostalAddressStrategy<PostalAddress24> getCreditorAddressStrategy() {
        return this.creditorAddressStrategy;
    }

    public DebtorStrategy getDebtorStrategy() {
        return this.debtorStrategy;
    }

    public InitiatingPartyStrategy getInitiatingPartyStrategy() {
        return this.initiatingPartyStrategy;
    }

    public CashAccountStrategy getCashAccountStrategy() {
        return this.cashAccountStrategy;
    }

    public CreDtTmStrategy getCreDtTmStrategy() {
        return this.creDtTmStrategy;
    }

    public PostalAddressPresenceStrategy getDebtorAddressPresenceStrategy() {
        return this.debtorAddressPresenceStrategy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DebtorAccountCurrencyPresenceStrategy getDebtorAccountCurrencyPresenceStrategy() {
        return this.debtorAccountCurrencyPresenceStrategy;
    }

    public static class Builder {
        private IntermediaryAccountStrategy intermediaryAccountStrategy;
        private ChargesStrategy chargesStrategy;
        private BatchBookingStrategy batchBookingStrategy;
        private PostalAddressStrategy<PostalAddress24> creditorAddressStrategy;
        private DebtorStrategy debtorStrategy;
        private InitiatingPartyStrategy initiatingPartyStrategy;
        private CashAccountStrategy cashAccountStrategy;
        private CreDtTmStrategy creDtTmStrategy;
        private PostalAddressPresenceStrategy debtorAddressPresenceStrategy;
        private DebtorAccountCurrencyPresenceStrategy debtorAccountCurrencyPresenceStrategy;

        public Builder setIntermediaryAccountStrategy(IntermediaryAccountStrategy intermediaryAccountStrategy) {
            this.intermediaryAccountStrategy = intermediaryAccountStrategy;
            return this;
        }

        public Builder setChargesStrategy(ChargesStrategy chargesStrategy) {
            this.chargesStrategy = chargesStrategy;
            return this;
        }

        public Builder setBatchBookingStrategy(BatchBookingStrategy batchBookingStrategy) {
            this.batchBookingStrategy = batchBookingStrategy;
            return this;
        }

        public Builder setCreditorAddressStrategy(PostalAddressStrategy<PostalAddress24> creditorAddressStrategy) {
            this.creditorAddressStrategy = creditorAddressStrategy;
            return this;
        }

        public Builder setDebtorStrategy(DebtorStrategy debtorStrategy) {
            this.debtorStrategy = debtorStrategy;
            return this;
        }

        public Builder setInitiatingPartyStrategy(InitiatingPartyStrategy initiatingPartyStrategy) {
            this.initiatingPartyStrategy = initiatingPartyStrategy;
            return this;
        }

        public Builder setCashAccountStrategy(CashAccountStrategy cashAccountStrategy) {
            this.cashAccountStrategy = cashAccountStrategy;
            return this;
        }

        public Builder setCreDtTmStrategy(CreDtTmStrategy creDtTmStrategy) {
            this.creDtTmStrategy = creDtTmStrategy;
            return this;
        }

        public Builder setDebtorAddressPresenceStrategy(PostalAddressPresenceStrategy debtorAddressPresenceStrategy) {
            this.debtorAddressPresenceStrategy = debtorAddressPresenceStrategy;
            return this;
        }

        public CreditSchemaMappingContext build() {
            return new CreditSchemaMappingContext(this);
        }

        public Builder setDebtorAccountCurrencyPresenceStrategy(DebtorAccountCurrencyPresenceStrategy debtorAccountCurrencyPresenceStrategy) {
            this.debtorAccountCurrencyPresenceStrategy = debtorAccountCurrencyPresenceStrategy;
            return this;
        }
    }
}

