/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common;

import com.varial.accounting.domain.payment.export.xml.XmlPaymentDataUtils;
import com.varial.accounting.domain.payment.iso20022.common.util.IsoPaymentUtil;
import com.varial.accounting.domain.payment.iso20022.core.schema.IsoChargesType;
import com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common.CreditPartyIdentificationBuilder10;
import com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common.CreditSchemaMappingContext;
import com.varial.base.text.TextFactory;
import com.varial.framework.domain.payment.sepa.base.DateAdapter;
import com.varial.framework.domain.payment.sepa.data.PartyData;
import com.varial.framework.domain.payment.sepa.data.PaymentData;
import com.varial.framework.domain.payment.sepa.data.PaymentInfoData;
import com.varial.framework.domain.payment.sepa.data.SepaData;
import com.varial.framework.domain.payment.sepa.data.SepaHeaderData;
import com.varial.framework.domain.payment.sepa.schema.PaymentSchemaMapper;
import com.varial.serverbase.mapper.StringMapper;
import iso.sepa.version10.credit.AccountIdentification4Choice;
import iso.sepa.version10.credit.AccountSchemeName1Choice;
import iso.sepa.version10.credit.ActiveOrHistoricCurrencyAndAmount;
import iso.sepa.version10.credit.AmountType4Choice;
import iso.sepa.version10.credit.BranchAndFinancialInstitutionIdentification6;
import iso.sepa.version10.credit.CashAccount38;
import iso.sepa.version10.credit.ChargeBearerType1Code;
import iso.sepa.version10.credit.CreditTransferTransaction34;
import iso.sepa.version10.credit.CustomerCreditTransferInitiationV09;
import iso.sepa.version10.credit.DateAndDateTime2Choice;
import iso.sepa.version10.credit.FinancialInstitutionIdentification18;
import iso.sepa.version10.credit.GenericAccountIdentification1;
import iso.sepa.version10.credit.GroupHeader85;
import iso.sepa.version10.credit.PartyIdentification135;
import iso.sepa.version10.credit.PaymentIdentification6;
import iso.sepa.version10.credit.PaymentInstruction30;
import iso.sepa.version10.credit.PaymentMethod3Code;
import iso.sepa.version10.credit.PaymentTypeInformation26;
import iso.sepa.version10.credit.RemittanceInformation16;
import iso.sepa.version10.credit.ServiceLevel8Choice;
import java.math.BigDecimal;
import java.util.Optional;

public abstract class CreditSchemaMapper
implements PaymentSchemaMapper<CustomerCreditTransferInitiationV09> {
    protected final CreditSchemaMappingContext context;

    protected CreditSchemaMapper(CreditSchemaMappingContext context) {
        this.context = context;
    }

    public CustomerCreditTransferInitiationV09 toSchema(SepaData sepaData) {
        CustomerCreditTransferInitiationV09 creditTransfer = new CustomerCreditTransferInitiationV09();
        creditTransfer.setGrpHdr(this.mapHeader(sepaData.getHeader()));
        sepaData.getPaymentInfos().stream().map(this::mapPaymentInformation).forEach(creditTransfer.getPmtInf()::add);
        return creditTransfer;
    }

    private GroupHeader85 mapHeader(SepaHeaderData header) {
        GroupHeader85 result = new GroupHeader85();
        result.setCreDtTm(this.context.getCreDtTmStrategy().format(header.getCreationDateTime()));
        result.setInitgPty(this.mapInitiatingParty(header.getInitiatingParty()));
        result.setMsgId(header.getMessageID());
        result.setNbOfTxs(Integer.toString(header.getNumberOfTransactions()));
        result.setCtrlSum(header.getControlSum());
        return result;
    }

    private PaymentInstruction30 mapPaymentInformation(PaymentInfoData paymentInfo) {
        PaymentInstruction30 result = new PaymentInstruction30();
        result.setPmtInfId(paymentInfo.getPaymentInfoID());
        result.setPmtMtd(PaymentMethod3Code.TRF);
        result.setReqdExctnDt(this.mapReqdExctnDt(paymentInfo));
        result.setCtrlSum(paymentInfo.getControlSum());
        result.setNbOfTxs(String.valueOf(paymentInfo.getNumberOfTransactions()));
        this.context.getBatchBookingStrategy().getBtchBookgValue().ifPresent(arg_0 -> ((PaymentInstruction30)result).setBtchBookg(arg_0));
        result.setPmtTpInf(this.mapPaymentTypeInformation(paymentInfo));
        result.setDbtr(this.mapDebtor(paymentInfo.getPartyData()));
        result.setDbtrAcct(this.createDebtorAccount(paymentInfo));
        result.setDbtrAgt(this.mapFinancialInstitution(paymentInfo.getCompanyBic()));
        paymentInfo.getPayments().stream().map(tx -> this.mapTxInfo((PaymentData)tx, paymentInfo)).forEach(result.getCdtTrfTxInf()::add);
        return result;
    }

    private CreditTransferTransaction34 mapTxInfo(PaymentData payment, PaymentInfoData paymentInfo) {
        CreditTransferTransaction34 result = new CreditTransferTransaction34();
        result.setPmtId(this.mapPaymentIdentification(payment));
        result.setAmt(this.mapAmount(payment.getAmount(), payment.getCurrencyCode()));
        this.getChargeBearerType(payment, paymentInfo).ifPresent(arg_0 -> ((CreditTransferTransaction34)result).setChrgBr(arg_0));
        result.setCdtrAgt(this.mapCreditorAgent(payment));
        result.setCdtrAcct(this.mapCreditorAccount(payment));
        result.setCdtr(this.mapCreditor(payment.getPartyData()));
        if (!StringMapper.isNullString((String)payment.getDeviatingOwner())) {
            result.setUltmtCdtr((PartyIdentification135)new CreditPartyIdentificationBuilder10().setName(payment.getDeviatingOwner()).build());
        }
        this.setIntermediaryAccount(result, payment);
        result.setRmtInf(this.mapRemittanceInfo(payment));
        return result;
    }

    private PartyIdentification135 mapCreditor(PartyData creditor) {
        return (PartyIdentification135)new CreditPartyIdentificationBuilder10().setName(creditor.getName()).setPostalAddressBuilder(this.context.getCreditorAddressStrategy().getAddress(XmlPaymentDataUtils.getAddress((PartyData)creditor))).build();
    }

    private void setIntermediaryAccount(CreditTransferTransaction34 tx, PaymentData payment) {
        if (this.context.getIntermediaryAccountStrategy().isIntermediaryAccountApplicable()) {
            tx.setIntrmyAgt1(this.mapFinancialInstitution(payment.getIntermediaryAgentBic1()));
            tx.setIntrmyAgt2(this.mapFinancialInstitution(payment.getIntermediaryAgentBic2()));
            tx.setIntrmyAgt3(this.mapFinancialInstitution(payment.getIntermediaryAgentBic3()));
            tx.setIntrmyAgt1Acct(this.createCashAccountWithIBAN(payment.getIntermediaryAgentAccount1()));
            tx.setIntrmyAgt2Acct(this.createCashAccountWithIBAN(payment.getIntermediaryAgentAccount2()));
            tx.setIntrmyAgt3Acct(this.createCashAccountWithIBAN(payment.getIntermediaryAgentAccount3()));
        }
    }

    protected abstract PartyIdentification135 mapDebtor(PartyData var1);

    protected abstract PartyIdentification135 mapInitiatingParty(PartyData var1);

    private RemittanceInformation16 mapRemittanceInfo(PaymentData payment) {
        RemittanceInformation16 result = new RemittanceInformation16();
        result.getUstrd().add(payment.getUnstructuredRemittanceInfoID());
        return result;
    }

    private CashAccount38 mapCreditorAccount(PaymentData payment) {
        if (!StringMapper.isNullString((String)payment.getIban())) {
            return this.createCashAccountWithIBAN(payment.getIban());
        }
        return this.createCashAccountBBAN(payment.getBankAccountNumber());
    }

    private CashAccount38 createCashAccountBBAN(String bban) {
        CashAccount38 result = new CashAccount38();
        GenericAccountIdentification1 genericId = new GenericAccountIdentification1();
        genericId.setId(bban);
        if (this.context.getCashAccountStrategy().includeSchemeName()) {
            AccountSchemeName1Choice schemeName = new AccountSchemeName1Choice();
            schemeName.setCd("BBAN");
            genericId.setSchmeNm(schemeName);
        }
        AccountIdentification4Choice idChoice = new AccountIdentification4Choice();
        idChoice.setOthr(genericId);
        result.setId(idChoice);
        return result;
    }

    protected abstract BranchAndFinancialInstitutionIdentification6 mapCreditorAgent(PaymentData var1);

    private Optional<ChargeBearerType1Code> getChargeBearerType(PaymentData payment, PaymentInfoData paymentInfo) {
        return this.context.getChargesStrategy().getChargesType(payment, paymentInfo).map(this::mapToChargeBearerType);
    }

    private ChargeBearerType1Code mapToChargeBearerType(IsoChargesType chargesType) {
        switch (chargesType) {
            case SHAR: {
                return ChargeBearerType1Code.SHAR;
            }
            case DEBT: {
                return ChargeBearerType1Code.DEBT;
            }
            case CRED: {
                return ChargeBearerType1Code.CRED;
            }
            case SLEV: {
                return ChargeBearerType1Code.SLEV;
            }
        }
        throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)chargesType));
    }

    private PaymentIdentification6 mapPaymentIdentification(PaymentData payment) {
        PaymentIdentification6 result = new PaymentIdentification6();
        result.setEndToEndId(payment.getPaymentEndToEndID());
        result.setInstrId(payment.getPaymentInstrID());
        return result;
    }

    private PaymentTypeInformation26 mapPaymentTypeInformation(PaymentInfoData paymentInfo) {
        PaymentTypeInformation26 result = new PaymentTypeInformation26();
        ServiceLevel8Choice level = new ServiceLevel8Choice();
        level.setCd(paymentInfo.getServiceLevelType().getCode());
        result.getSvcLvl().add(level);
        return result;
    }

    private DateAndDateTime2Choice mapReqdExctnDt(PaymentInfoData paymentInfo) {
        DateAndDateTime2Choice result = new DateAndDateTime2Choice();
        result.setDt(new DateAdapter().getCalendarInYYYYMMDD(paymentInfo.getRequestedExecutionDate()));
        return result;
    }

    private AmountType4Choice mapAmount(BigDecimal amount, String currencyCode) {
        AmountType4Choice result = new AmountType4Choice();
        result.setInstdAmt(this.toActiveOrHistoricAmountType(amount, currencyCode));
        return result;
    }

    private ActiveOrHistoricCurrencyAndAmount toActiveOrHistoricAmountType(BigDecimal amount, String currencyCode) {
        ActiveOrHistoricCurrencyAndAmount result = new ActiveOrHistoricCurrencyAndAmount();
        result.setCcy(currencyCode);
        result.setValue(amount);
        return result;
    }

    protected BranchAndFinancialInstitutionIdentification6 mapFinancialInstitution(String bic) {
        if (StringMapper.isNullString((String)bic)) {
            return null;
        }
        BranchAndFinancialInstitutionIdentification6 result = new BranchAndFinancialInstitutionIdentification6();
        FinancialInstitutionIdentification18 instID = new FinancialInstitutionIdentification18();
        instID.setBICFI(bic);
        result.setFinInstnId(instID);
        return result;
    }

    private CashAccount38 createCashAccountWithIBAN(String iban) {
        if (StringMapper.isNullString((String)iban)) {
            return null;
        }
        CashAccount38 account = new CashAccount38();
        AccountIdentification4Choice id = new AccountIdentification4Choice();
        id.setIBAN(iban);
        account.setId(id);
        return account;
    }

    private CashAccount38 createDebtorAccount(PaymentInfoData paymentInfo) {
        CashAccount38 account = this.createCashAccountWithIBAN(paymentInfo.getCompanyIban());
        if (account != null && this.context.getDebtorAccountCurrencyPresenceStrategy().isCurrencyRequired()) {
            IsoPaymentUtil.getBankAccountCurrencyCode(paymentInfo).ifPresent(arg_0 -> ((CashAccount38)account).setCcy(arg_0));
        }
        return account;
    }
}

