/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment;

import com.varial.accounting.domain.openitem.OpenItem;
import com.varial.accounting.domain.payment.PaymentAssociation;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccountAssociation;
import java.util.ArrayList;
import java.util.List;

class PersonalAccountOpenItems {
    private final PersonalAccount personalAccount;
    private final PaymentAssociation paymentAssociation;
    private final List<OpenItem> openItemList;

    PersonalAccountOpenItems(PersonalAccount personalAccount, PaymentAssociation association) {
        this.personalAccount = personalAccount;
        this.paymentAssociation = association;
        this.openItemList = new ArrayList<OpenItem>();
    }

    PersonalAccount getPersonalAccount() {
        return this.personalAccount;
    }

    PersonalAccountAssociation getPersonalAccountAssociation() {
        return this.paymentAssociation == null ? null : this.paymentAssociation.getAssociation();
    }

    PaymentAssociation getPaymentAssociation() {
        return this.paymentAssociation;
    }

    void add(OpenItem oi) {
        this.openItemList.add(oi);
    }

    OpenItem[] getOpenItems() {
        OpenItem[] result = new OpenItem[this.openItemList.size()];
        this.openItemList.toArray(result);
        return result;
    }

    PersonalAccount getPayer() {
        return this.paymentAssociation == null ? this.personalAccount : this.paymentAssociation.getPayer();
    }
}

