/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment;

import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.framework.domain.paymentbase.ModeOfPayment;
import java.util.Set;

public class PaymentTypeUtils {
    private static final Set<ModeOfPayment> DIRECT_DEBIT_TYPES = Set.of(ModeOfPayment.DIRECT_DEBIT, ModeOfPayment.BANK_COLLECTION);
    private static final Set<ModeOfPayment> BILL_TYPES = Set.of(ModeOfPayment.BILL_OF_EXCHANGE, ModeOfPayment.BILL_WITHOUT_ACCEPTANCE);
    private static final Set<ModeOfPayment> STANDARD_TYPES = Set.of(ModeOfPayment.BACS, ModeOfPayment.CHECK, ModeOfPayment.BACS_BILL_OF_EXCHANGE, ModeOfPayment.CHECK_BILL_OF_EXCHANGE);
    private static final Set<ModeOfPayment> EXPORT_PAYMENT_TYPES = Set.of(ModeOfPayment.BACS, ModeOfPayment.BACS_BILL_OF_EXCHANGE, ModeOfPayment.DIRECT_DEBIT, ModeOfPayment.BANK_COLLECTION, ModeOfPayment.DIRECT_DEBIT_ANTICIPATED);

    private PaymentTypeUtils() {
    }

    public static boolean isPaymentTypeAllowedForSession(GeneratePaymentSession session, ModeOfPayment paymentType) {
        Set<ModeOfPayment> allowedTypes = PaymentTypeUtils.getAllowedPaymentTypes(session);
        return allowedTypes.contains(paymentType);
    }

    public static boolean isExportPaymentType(ModeOfPayment paymentType) {
        return EXPORT_PAYMENT_TYPES.contains(paymentType);
    }

    public static boolean isSepaPaymentType(ModeOfPayment paymentType) {
        return PaymentTypeUtils.isExportPaymentType(paymentType);
    }

    private static Set<ModeOfPayment> getAllowedPaymentTypes(GeneratePaymentSession session) {
        if (session.getIsDirectDebit()) {
            return DIRECT_DEBIT_TYPES;
        }
        if (session.getIsBillPayable() || session.getIsBillReceivable()) {
            return BILL_TYPES;
        }
        if (session.getIsReverseFactoring()) {
            return Set.of(ModeOfPayment.REVERSE_FACTORING);
        }
        return STANDARD_TYPES;
    }
}

