/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment;

import com.varial.accounting.domain.bankaccount.BankAccount;
import com.varial.accounting.domain.batch.Batch;
import com.varial.accounting.domain.billofexchange.BillOfExchange;
import com.varial.accounting.domain.billofexchange.BillOfExchangePersistencyManager;
import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocationExceptionMapper;
import com.varial.accounting.domain.openitem.EsrPayment;
import com.varial.accounting.domain.openitem.IOpenItem;
import com.varial.accounting.domain.openitem.OpenItem;
import com.varial.accounting.domain.openitem.SwissReferenceType;
import com.varial.accounting.domain.openitem.SwissReferenceTypeBuilder;
import com.varial.accounting.domain.openitem.SwissReferenceUtil;
import com.varial.accounting.domain.openitemstatus.OpenItemStatusType;
import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.accounting.domain.payment.FinancePaymentExceptionMapper;
import com.varial.accounting.domain.payment.FinancePaymentPersistencyManager;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.GeneratePaymentData;
import com.varial.accounting.domain.payment.GeneratePaymentInvoiceAllocationCreator;
import com.varial.accounting.domain.payment.GeneratePaymentOpenItemComparator;
import com.varial.accounting.domain.payment.GeneratePaymentRemittance;
import com.varial.accounting.domain.payment.GeneratePaymentRemittancePersistencyManager;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.PaymentSessionBankAccount;
import com.varial.accounting.domain.payment.PaymentSessionBankAccountUtils;
import com.varial.accounting.domain.payment.PaymentTypeUtils;
import com.varial.accounting.domain.payment.SplitPayment;
import com.varial.accounting.domain.payment.SplitPaymentHelper;
import com.varial.accounting.domain.payment.WhitelistCheckHelper;
import com.varial.accounting.domain.payment.export.PaymentExportHelper;
import com.varial.accounting.domain.payment.validators.GeneratePaymentValidator;
import com.varial.accounting.domain.payment.validators.GeneratePaymentValidatorImpl;
import com.varial.accounting.domain.personalaccount.IPersonalAccountBankAddress;
import com.varial.accounting.domain.personalaccount.PersonalAccountAssociation;
import com.varial.accounting.domain.personalaccount.Supplier;
import com.varial.accounting.payment.GeneratePaymentErrormessageEnum;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.ConversionRateMapper;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.country.ICountry;
import com.varial.framework.domain.currency.ConversionRate;
import com.varial.framework.domain.paymentbase.ModeOfPayment;
import com.varial.framework.domain.paymentbase.Payment;
import com.varial.framework.domain.paymentbase.PaymentPersistencyManager;
import com.varial.framework.domain.paymentbase.PaymentSession;
import com.varial.interfaces.IAccountingCompany;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class GeneratePayment
extends FinancePayment {
    protected static final String CLASSNAME = GeneratePayment.class.getName();
    private final GeneratePaymentValidator validator = new GeneratePaymentValidatorImpl();
    private GeneratePaymentRemittance[] mGeneratePaymentRemittances;
    private EsrPayment mEsrPayment;
    private PersonalAccountAssociation mPersonalAccountAssociation;
    private boolean mWithSubAccounts;
    private int mSortNumber;
    private Supplier mFactoringSupplier;
    private String mNumberAtFactoringCompany;
    private Date mExecuteDate;
    private boolean mIsSplitPayment;
    private BigDecimal mSplitPaymentBaseVatAmount;
    private SplitPayment mSplitPayment;
    private boolean mMustUpdateExecuteDate = false;
    private Date mTransactionDate = null;
    private FinancialYear mFinancialYear = null;
    private IPersonalAccountBankAddress mPersonalAccountBankAddress;

    public GeneratePayment(GeneratePayment oldGeneratePayment, boolean copyRemittances) throws BusinessDomainException {
        super(oldGeneratePayment);
        if (copyRemittances) {
            this.setGeneratePaymentRemittances(oldGeneratePayment.getGeneratePaymentRemittances());
        }
        this.setEsrPayment(oldGeneratePayment.getEsrPayment());
        this.setPersonalAccountAssociation(oldGeneratePayment.getPersonalAccountAssociation());
        this.setWithSubAccounts(oldGeneratePayment.getWithSubAccounts());
        this.setFactoringSupplier(oldGeneratePayment.getFactoringSupplier());
        this.setNumberAtFactoringCompany(oldGeneratePayment.getNumberAtFactoringCompany());
        this.setExecuteDate(oldGeneratePayment.getExecuteDate());
        this.setIsSplitPayment(oldGeneratePayment.isSplitPayment());
        this.setSplitPaymentBaseVatAmount(oldGeneratePayment.getSplitPaymentBaseVatAmount());
    }

    public GeneratePayment(GeneratePaymentSession session) {
        super((FinancePaymentSession)session);
    }

    public GeneratePayment(String objectid, int version, GeneratePaymentSession session) {
        super(objectid, version, (FinancePaymentSession)session);
    }

    protected GeneratePayment(boolean readOnly, GeneratePaymentSession session) {
        super(readOnly, (FinancePaymentSession)session);
    }

    protected GeneratePayment(String objectid, GeneratePaymentSession session) {
        super(objectid, (FinancePaymentSession)session);
    }

    protected void load() {
        FinancePaymentPersistencyManager.load((GeneratePayment)this);
    }

    protected void deleteImpl() {
        PaymentPersistencyManager.delete((Payment)this);
    }

    protected void destroyImpl() throws BusinessDomainException {
        GeneratePaymentRemittance[] generatePaymentRemittances;
        BillOfExchange bill = this.getBillOfExchange();
        if (bill != null) {
            if (!bill.isReverseBill() && bill.getStatusType() != OpenItemStatusType.BILL_HONORED && bill.getStatusAccountType().value() == 1 && this.getCashTransaction() != null) {
                throw FinancePaymentExceptionMapper.makeSessionCannotBeDeletedAsBillNotHonouredDomainException();
            }
            bill.makeSaveable();
            bill.setDeleteFromPaymentSession(true);
            bill.setGeneratePayment(this);
            BillOfExchangePersistencyManager.setPaymentToNull((BillOfExchange)bill);
            bill.destroy();
        }
        if (this.getSplitPayment() != null) {
            FinancePaymentPersistencyManager.setSplitPaymentToNull((GeneratePayment)this);
            this.getSplitPayment().makeSaveable();
            this.getSplitPayment().destroy();
        }
        for (GeneratePaymentRemittance generatePaymentRemittance : generatePaymentRemittances = this.getGeneratePaymentRemittances()) {
            generatePaymentRemittance.makeSaveable();
            generatePaymentRemittance.destroy();
        }
    }

    public String getClassName() {
        return CLASSNAME;
    }

    protected void saveImpl() {
        FinancePaymentPersistencyManager.save((GeneratePayment)this);
    }

    protected void setData(GeneratePaymentData data) {
        this.mEsrPayment = data.getEsrPayment();
        this.mPersonalAccountAssociation = data.getAssociation();
        this.mWithSubAccounts = data.isWithSubAccounts();
        this.mFactoringSupplier = data.getFactoringSupplier();
        this.mNumberAtFactoringCompany = data.getNumberAtFactoringCompany();
        this.mExecuteDate = data.getExecuteDate();
        this.mIsSplitPayment = data.isSplitPayment();
        this.mSplitPaymentBaseVatAmount = data.getSplitPaymentBaseVatAmount();
        this.mSplitPayment = data.getSplitPayment();
    }

    public Payment getAReadOnlyCopy() throws BusinessDomainException {
        GeneratePayment result = new GeneratePayment(this, true);
        result.makeReadOnly();
        return result;
    }

    public GeneratePayment getAReadOnlyCopyWithoutRemittances() throws BusinessDomainException {
        GeneratePayment result = new GeneratePayment(this, false);
        result.makeReadOnly();
        return result;
    }

    public GeneratePaymentSession getGeneratePaymentSession() {
        return (GeneratePaymentSession)super.getFinancePaymentSession();
    }

    public void setGeneratePaymentSession(GeneratePaymentSession session) {
        super.setPaymentSession((PaymentSession)session);
    }

    public boolean getIsDirectDebit() {
        return this.getGeneratePaymentSession().getIsDirectDebit();
    }

    public boolean getIsCustomerRepayment() {
        return this.getGeneratePaymentSession().getIsCustomerRepayment();
    }

    public boolean getIsBillPayable() {
        return this.getGeneratePaymentSession().getIsBillPayable();
    }

    public boolean getIsBillReceivable() {
        return this.getGeneratePaymentSession().getIsBillReceivable();
    }

    public boolean getIsReverseFactoring() {
        return this.getGeneratePaymentSession().getIsReverseFactoring();
    }

    public void setExecuteDate(Date executeDate) throws BusinessDomainException {
        if (!(this.isNew() || this.getExecuteDate() == null && executeDate == null)) {
            if (this.getExecuteDate() == null && executeDate != null || this.getExecuteDate() != null && executeDate == null || this.getExecuteDate() != null && executeDate != null && !DateHelper.equal((Date)this.getExecuteDate(), (Date)executeDate)) {
                this.mMustUpdateExecuteDate = true;
            }
            if (this.mMustUpdateExecuteDate && this.getGeneratePaymentSession().getFreeForPayment() != null && this.getTypeOfPayment() != ModeOfPayment.BILL_OF_EXCHANGE && this.getTypeOfPayment() != ModeOfPayment.BILL_WITHOUT_ACCEPTANCE) {
                throw FinancePaymentExceptionMapper.makeExecuteDateCannotBeChangedBecauseFreeForPaymentDomainException();
            }
        }
        this.mExecuteDate = executeDate;
    }

    @Override
    public Date getExecuteDate() {
        this.requireLoaded();
        return this.mExecuteDate;
    }

    public void updateExecuteDate() {
        if (this.mMustUpdateExecuteDate) {
            GeneratePaymentRemittance[] remittances = this.getGeneratePaymentRemittances();
            for (int i = 0; i < remittances.length; ++i) {
                OpenItem oi = remittances[i].getOpenItem();
                oi.makeSaveable();
                oi.setPaymentSessionExecuteDate(this.getExecuteDate());
            }
        }
    }

    @Override
    public EsrPayment getEsrPayment() {
        this.requireLoaded();
        return this.mEsrPayment;
    }

    public void setEsrPayment(EsrPayment esrPayment) {
        EsrPayment.protocol((PersistentObject)this, (EsrPayment)esrPayment, (EsrPayment)this.mEsrPayment);
        this.mEsrPayment = esrPayment;
    }

    public PersonalAccountAssociation getPersonalAccountAssociation() {
        this.requireLoaded();
        return this.mPersonalAccountAssociation;
    }

    public void setPersonalAccountAssociation(PersonalAccountAssociation association) {
        this.protocol("association", (IPersistentObject)this.mPersonalAccountAssociation, (IPersistentObject)association);
        this.mPersonalAccountAssociation = association;
    }

    @Override
    public Date getTransactionDate() throws BusinessDomainException {
        if (this.mTransactionDate == null) {
            this.calculatePostingData();
        }
        return this.mTransactionDate;
    }

    @Override
    public FinancialYear getFinancialYear() throws BusinessDomainException {
        if (this.mFinancialYear == null) {
            this.calculatePostingData();
        }
        return this.mFinancialYear;
    }

    @Override
    public boolean isDirectDebitAnticipated() {
        return this.getGeneratePaymentSession().getIsDirectDebitAnticipated();
    }

    private void calculatePostingData() throws BusinessDomainException {
        OpenItem openItem;
        Date dueDate;
        this.mTransactionDate = null;
        this.mFinancialYear = null;
        if (this.isRibaCash() && (dueDate = (openItem = this.getGeneratePaymentRemittances()[0].getOpenItem()).getDueDate()) != null && DateHelper.after((Date)dueDate, (Date)this.getGeneratePaymentSession().getTransactionDate())) {
            this.mTransactionDate = dueDate;
            this.mFinancialYear = this.getGeneratePaymentSession().getAccountingCompany().getFinancialYear(this.mTransactionDate);
            if (this.mFinancialYear == null) {
                throw OpenItemAllocationExceptionMapper.makeNoFinancialYearForDueDateDomainException((String)(StringMapper.toString((String)openItem.getReferenceNumber()) + "/<" + DateMapper.toString((Date)dueDate) + ">"));
            }
        }
        if (this.mTransactionDate == null) {
            this.mTransactionDate = this.getGeneratePaymentSession().getTransactionDate();
        }
        if (this.mFinancialYear == null) {
            this.mFinancialYear = this.getGeneratePaymentSession().getFinancialYear();
        }
    }

    @Override
    public void post(Batch batch, FinancialYear financialYear, Date transactionDate) throws BusinessDomainException {
        this.createBankTransaction(batch, financialYear, transactionDate);
        if (this.getSplitPayment() != null) {
            this.getSplitPayment().post(batch, financialYear, transactionDate);
        }
        this.allocate();
    }

    public void allocate() throws BusinessDomainException {
        new GeneratePaymentInvoiceAllocationCreator(this).create();
    }

    public GeneratePaymentRemittance[] getGeneratePaymentRemittances() {
        if (this.mGeneratePaymentRemittances == null) {
            if (!this.isNew()) {
                this.mGeneratePaymentRemittances = GeneratePaymentRemittancePersistencyManager.getGeneratePaymentRemittances((GeneratePayment)this);
            }
            if (this.mGeneratePaymentRemittances == null) {
                this.mGeneratePaymentRemittances = new GeneratePaymentRemittance[0];
            }
            if (this.mGeneratePaymentRemittances.length > 1) {
                Arrays.sort(this.mGeneratePaymentRemittances, GeneratePaymentOpenItemComparator.getComparator());
            }
        }
        return this.mGeneratePaymentRemittances;
    }

    public void setGeneratePaymentRemittances(GeneratePaymentRemittance[] remittances) throws BusinessDomainException {
        this.mGeneratePaymentRemittances = PersistentObjectUtils.removeUnusedObjects((IPersistentObject[])this.getGeneratePaymentRemittances(), (IPersistentObject[])remittances).toArray(new GeneratePaymentRemittance[0]);
    }

    public void addRemittance(GeneratePaymentRemittance remittance) {
        if (remittance == null) {
            return;
        }
        GeneratePaymentRemittance[] remittances = this.getGeneratePaymentRemittances();
        for (int i = 0; i < remittances.length; ++i) {
            if (!remittances[i].equals((Object)remittance)) continue;
            return;
        }
        this.mGeneratePaymentRemittances = new GeneratePaymentRemittance[remittances.length + 1];
        System.arraycopy(remittances, 0, this.mGeneratePaymentRemittances, 0, remittances.length);
        this.mGeneratePaymentRemittances[this.mGeneratePaymentRemittances.length - 1] = remittance;
    }

    public void setAmount(BigDecimal amount) {
    }

    private void calculateAmount() {
        GeneratePaymentRemittance[] remittances = this.getGeneratePaymentRemittances();
        BigDecimal sum = BigDecimalMapper.ZERO;
        for (int i = 0; i < remittances.length; ++i) {
            sum = sum.add(remittances[i].getAmountOfPayment());
        }
        super.setAmount(sum);
    }

    public void setBaseAmount(BigDecimal amount) {
    }

    protected void calculateBaseAmount() {
        if (this.getIsReverseFactoring()) {
            super.setBaseAmount(null);
        } else {
            BigDecimal baseAmount;
            if (!this.getCurrency().equals(this.getBaseCurrency())) {
                if (this.getPersonalAccount().getNegotiatedExchangeRate()) {
                    baseAmount = BigDecimalMapper.ZERO;
                    GeneratePaymentRemittance[] s = this.getGeneratePaymentRemittances();
                    for (int i = 0; i < s.length; ++i) {
                        BigDecimal a = s[i].getAmountOfPayment().multiply(s[i].getOpenItem().getConversionRate().getRate());
                        baseAmount = baseAmount.add(a);
                    }
                    BigDecimal conversionRate = BigDecimal.valueOf(1L);
                    if (this.getAmount().signum() != 0) {
                        conversionRate = baseAmount.divide(this.getAmount(), 9, RoundingMode.HALF_UP);
                    }
                    this.setConversionRate(new ConversionRate(conversionRate, false));
                    baseAmount = this.getBaseCurrency().round(baseAmount);
                } else if (this.getConversionRate() != null) {
                    baseAmount = this.getAmount().multiply(this.getConversionRate().getRate());
                    baseAmount = this.getBaseCurrency().round(baseAmount);
                } else {
                    baseAmount = null;
                }
            } else {
                baseAmount = this.getAmount();
                this.setConversionRate(ConversionRateMapper.ONE);
            }
            super.setBaseAmount(baseAmount);
        }
    }

    public boolean getIsForeignPayment() {
        return this.getGeneratePaymentSession().getIsForeignPayment();
    }

    public void cleanRemittances() throws BusinessDomainException {
        GeneratePaymentRemittance[] remittances = this.getGeneratePaymentRemittances();
        ArrayList<GeneratePaymentRemittance> remittancesKept = new ArrayList<GeneratePaymentRemittance>();
        for (GeneratePaymentRemittance remittance : remittances) {
            if (remittance.canBeDeleted()) {
                remittance.makeSaveable();
                remittance.destroy();
                continue;
            }
            remittancesKept.add(remittance);
        }
        this.mGeneratePaymentRemittances = remittancesKept.toArray(new GeneratePaymentRemittance[0]);
    }

    public boolean hasNoRemittances() {
        return this.getGeneratePaymentRemittances().length == 0;
    }

    @Override
    public List<GeneratePaymentErrormessageEnum> checkForErrors() {
        return this.validator.checkForErrors(this);
    }

    public boolean isForeignAccount() {
        return this.getBankCountry() != null && this.getBankAccount().getCountry() != null && !this.getBankCountry().equals(this.getBankAccount().getCountry());
    }

    public void checkFreeForPayment() throws BusinessDomainException {
        super.checkFreeForPayment();
        this.validator.checkFreeForPayment(this);
    }

    @Override
    public CustSupAddress getOneOffAddress() {
        return this.getPersonalAccount().getOneOffAccount() && this.getGeneratePaymentRemittances() != null && this.getGeneratePaymentRemittances().length > 0 ? this.getGeneratePaymentRemittances()[0].getOpenItem().getOneOffAccountAddress() : null;
    }

    public boolean isPaymentTypeAllowed() {
        return PaymentTypeUtils.isPaymentTypeAllowedForSession(this.getGeneratePaymentSession(), this.getTypeOfPayment());
    }

    public boolean isPayment() {
        return !this.getIsDirectDebit() && !this.getIsBillReceivable();
    }

    @Override
    protected Date getValueDate() {
        return this.getGeneratePaymentSession().getTransactionDate();
    }

    public BigDecimal getEUSplittGrenze() {
        Date executeDate = this.getGeneratePaymentSession().getExecuteDate();
        if (executeDate == null) {
            executeDate = this.getGeneratePaymentSession().getCreationDate();
        }
        if (DateHelper.before((Date)executeDate, (Date)new VDate("2006-01-01").getDate()) || !StringMapper.isNullString((String)this.getPersonalAccount().getPaymentDetailsCode())) {
            return BigDecimal.valueOf(12500L);
        }
        return BigDecimal.valueOf(50000L);
    }

    public boolean getIsEUStandard() {
        return this.checkEUStandard() && this.getAmount().compareTo(this.getEUSplittGrenze()) <= 0;
    }

    private boolean checkEUStandard() {
        ICountry otherBankCountry;
        ICountry ownBankCountry;
        return this.getIsForeignPayment() && !StringMapper.isNullString((String)this.getShortAddressOwner()) && (ownBankCountry = this.getBankAccount().getCountry()).hasEuCodes() && (otherBankCountry = this.getBankCountry()) != null && otherBankCountry.hasEuCodes() && (this.getCurrency().isTheEuro() || "EUR".equalsIgnoreCase(this.getCurrency().getSwift()));
    }

    public boolean getSplittEUStandard() {
        return this.checkEUStandard() && this.getAmount().compareTo(this.getEUSplittGrenze()) > 0;
    }

    @Override
    protected boolean isDownPayment() {
        return !this.getGeneratePaymentSession().getNoDownPaymentRequests();
    }

    @Override
    protected String getProcessId() {
        if (this.isDownPayment() && this.getGeneratePaymentRemittances().length > 0) {
            return this.mGeneratePaymentRemittances[0].getOpenItem().getProcessID();
        }
        return "";
    }

    public void updateStatus(OpenItemStatusType statusType) throws BusinessDomainException {
        this.getGeneratePaymentRemittances();
        for (int i = 0; i < this.mGeneratePaymentRemittances.length; ++i) {
            this.mGeneratePaymentRemittances[i].getOpenItem().setNewStatus(statusType, this.mGeneratePaymentRemittances[i]);
        }
    }

    public int getSortNumber() {
        return this.mSortNumber;
    }

    public void setSortNumber(int sortNumber) {
        this.mSortNumber = sortNumber;
    }

    @Override
    public void setBankAccount(BankAccount bankAccount) throws BusinessDomainException {
        if (!(this.isNew() || bankAccount == null || this.getBankAccount() != null && this.getBankAccount().equals((Object)bankAccount))) {
            PaymentSessionBankAccount sessionBankAccount = PaymentSessionBankAccountUtils.getPaymentSessionBankAccount((FinancePaymentSession)this.getGeneratePaymentSession(), (BankAccount)bankAccount, (Payment.PaymentType)this.getType());
            if (sessionBankAccount == null) {
                throw FinancePaymentExceptionMapper.makeNoSessionBankAccountSelectedDomainException();
            }
            if (bankAccount.isForeignBankAccount() && !this.getCurrency().equals(bankAccount.getCurrency())) {
                throw FinancePaymentExceptionMapper.makePaymentInOtherCurrencyDomainException((String)bankAccount.getCode());
            }
            if (this.getGeneratePaymentSession().getFreeForPayment() != null) {
                throw FinancePaymentExceptionMapper.makeBankAccountCannotBeChangedBecauseFreeForPaymentDomainException();
            }
        }
        super.setBankAccount(bankAccount);
    }

    public boolean isGeneratePayment() {
        return true;
    }

    private boolean isRibaCash() {
        return this.getTypeOfPayment() == ModeOfPayment.DIRECT_DEBIT && this.getGeneratePaymentSession().isIT() && !this.isDirectDebitAnticipated();
    }

    public void setWithSubAccounts(boolean withSubAccounts) {
        this.mWithSubAccounts = withSubAccounts;
    }

    public boolean getWithSubAccounts() {
        this.requireLoaded();
        return this.mWithSubAccounts;
    }

    @Override
    public Date getSepaDirectDebitExecuteDate() {
        return PaymentExportHelper.getRequestedExecutionDate((GeneratePayment)this);
    }

    public Date getDocumentDate() {
        return this.getGeneratePaymentSession().getBaseDatePayment();
    }

    public Supplier getFactoringSupplier() {
        this.requireLoaded();
        return this.mFactoringSupplier;
    }

    public void setFactoringSupplier(Supplier factoringSupplier) {
        this.mFactoringSupplier = factoringSupplier;
    }

    public String getNumberAtFactoringCompany() {
        this.requireLoaded();
        return this.mNumberAtFactoringCompany;
    }

    public void setNumberAtFactoringCompany(String numberAtFactoringCompany) {
        this.mNumberAtFactoringCompany = numberAtFactoringCompany;
    }

    public void setIsSplitPayment(boolean splitPayment) {
        this.mIsSplitPayment = splitPayment;
    }

    public boolean isSplitPayment() {
        this.requireLoaded();
        return this.mIsSplitPayment;
    }

    private void setSplitPaymentBaseVatAmount(BigDecimal splitPaymentBaseVatAmount) {
        this.mSplitPaymentBaseVatAmount = splitPaymentBaseVatAmount;
    }

    public BigDecimal getSplitPaymentBaseVatAmount() {
        this.requireLoaded();
        return this.mSplitPaymentBaseVatAmount;
    }

    private void calculateSplitPaymentBaseVatAmount() {
        BigDecimal vatAmount = this.isSplitPayment() && this.getGeneratePaymentRemittances().length > 0 ? this.getGeneratePaymentRemittances()[0].getAmountOfVatPayment() : null;
        this.setSplitPaymentBaseVatAmount(vatAmount);
    }

    @Override
    public String getTaxNumber() {
        if (this.isSplitPayment()) {
            return SplitPaymentHelper.getTaxNumber((IOpenItem)this.getGeneratePaymentRemittances()[0].getOpenItem());
        }
        if (this.isWhitelistCheckEnabled()) {
            return WhitelistCheckHelper.getTaxNumber((FinancePayment)this);
        }
        return null;
    }

    @Override
    public SwissReferenceType getSwissReferenceType() {
        AccountingCompany company = this.getGeneratePaymentSession().getAccountingCompany();
        return JurisdictionType.CH != company.getJurisdictionType() ? SwissReferenceType.NO_REFERENCE : new SwissReferenceTypeBuilder((IAccountingCompany)company).withPayment(this).withReference(this.getSwissReference()).build();
    }

    @Override
    public String getSwissReference() {
        GeneratePaymentRemittance[] generatePaymentRemittances = this.getGeneratePaymentRemittances();
        return generatePaymentRemittances.length == 1 ? SwissReferenceUtil.getReference((IOpenItem)generatePaymentRemittances[0].getOpenItem()) : null;
    }

    @Override
    public SplitPayment getSplitPayment() {
        this.requireLoaded();
        return this.mSplitPayment;
    }

    public void setSplitPayment(SplitPayment splitPayment) throws BusinessDomainException {
        if (this.getSplitPayment() != null && splitPayment != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)splitPayment, (IPersistentObject)this.getSplitPayment())) {
            throw ExceptionMapper.makeApplicationException((String)"wrong split payment objectid");
        }
        if (this.getSplitPayment() != null && splitPayment == null) {
            this.getSplitPayment().makeSaveable();
            this.getSplitPayment().destroy();
        }
        this.mSplitPayment = splitPayment;
    }

    public Payment.PaymentType getType() {
        return Payment.PaymentType.GENERATE_PAYMENT;
    }

    public IPersonalAccountBankAddress getPersonalAccountBankAddress() {
        return this.mPersonalAccountBankAddress;
    }

    public void setPersonalAccountBankAddress(IPersonalAccountBankAddress personalAccountBankAddress) {
        this.mPersonalAccountBankAddress = personalAccountBankAddress;
    }

    protected void calculatePaymentDetails() {
        this.calculateAmount();
        this.calculateBaseAmount();
        this.calculateSplitPaymentBaseVatAmount();
        this.setWhitelistCheckRequired();
    }
}

