/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment;

import com.varial.accounting.domain.bankaccount.BankAccount;
import com.varial.accounting.domain.batch.Batch;
import com.varial.accounting.domain.billofexchange.BillOfExchange;
import com.varial.accounting.domain.cashtransaction.CashTransaction;
import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.nominalledger.NLAccountCompanySetting;
import com.varial.accounting.domain.nominaltransactionbase.LedgerTypeMapper;
import com.varial.accounting.domain.nominaltransactionbase.TransactionExceptionMapper;
import com.varial.accounting.domain.openitem.EsrPayment;
import com.varial.accounting.domain.openitem.SwissReferenceType;
import com.varial.accounting.domain.payment.FinancePaymentData;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.PaymentHelper;
import com.varial.accounting.domain.payment.PaymentPostingCreator;
import com.varial.accounting.domain.payment.PaymentSessionBankAccount;
import com.varial.accounting.domain.payment.PaymentTypeUtils;
import com.varial.accounting.domain.payment.SplitPayment;
import com.varial.accounting.domain.payment.WhitelistCheckHelper;
import com.varial.accounting.domain.payment.WhitelistCheckState;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.nominaltransactionbase.LedgerTypeEnum;
import com.varial.accounting.payment.GeneratePaymentErrormessageEnum;
import com.varial.accounting.servantimpl.AccountingRightList;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.security.AuthorizationToken;
import com.varial.framework.basictypes.addresses.IPostalAddress;
import com.varial.framework.basictypes.addresses.PostalAddress;
import com.varial.framework.basictypes.addresses.PostalAddressMapper;
import com.varial.framework.domain.paymentbase.ModeOfPayment;
import com.varial.framework.domain.paymentbase.Payment;
import com.varial.framework.domain.paymentbase.PaymentExceptionMapper;
import com.varial.framework.domain.paymentbase.PaymentSession;
import com.varial.framework.domain.paymentbase.PaymentTransactionTypeMapper;
import com.varial.framework.paymentbase.PaymentTransactionTypeEnum;
import com.varial.framework.paymentbase.SepaDirectDebitTypeEnum;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public abstract class FinancePayment
extends Payment {
    private BankAccount mBankAccount;
    private LedgerTypeEnum mLedgerType;
    private NLAccountCompanySetting mNominalAccount;
    private PersonalAccount mPersonalAccount;
    private CashTransaction mCashTransaction;
    private Date mDueDate;
    private boolean mZ5a;
    protected BillOfExchange mBillOfExchange;
    private String mProcessId;
    private String mSepaMandate;
    private Date mSepaMandateDate;
    private SepaDirectDebitTypeEnum mSepaDirectDebitType;
    private boolean mIsSepaOneOffDirectDebit;
    private Date mSepaLastUsage;
    private Date mValidUntil;
    private WhitelistCheckState mWhitelistCheckState;
    private Date mWhitelistCheckedOn;
    private String mWhitelistCheckRequestId;
    private String mWhitelistCheckErrorCode;
    private PaymentTransactionTypeEnum mPaymentTransactionType;
    private String mPaymentTransactionCode;
    private PaymentSessionBankAccount mPaymentSessionBankAccount;

    protected FinancePayment(FinancePayment oldFinancePayment) throws BusinessDomainException {
        super((Payment)oldFinancePayment);
        this.setLedgerType(oldFinancePayment.getLedgerType());
        this.setNominalAccount(oldFinancePayment.getNominalAccount());
        this.setPersonalAccount(oldFinancePayment.getPersonalAccount());
        this.mCashTransaction = oldFinancePayment.getCashTransaction();
        this.setDueDate(oldFinancePayment.getDueDate());
        this.setZ5a(oldFinancePayment.getZ5a());
        this.setBillOfExchange(oldFinancePayment.getBillOfExchange());
        this.setPaymentTransactionType(oldFinancePayment.getPaymentTransactionType());
        this.setPaymentTransactionCode(oldFinancePayment.getPaymentTransactionCode());
        this.setBankAccount(oldFinancePayment.getBankAccount());
        this.setProcessId(oldFinancePayment.getProcessId());
        this.setSepaMandate(oldFinancePayment.getSepaMandate());
        this.setSepaMandateDate(oldFinancePayment.getSepaMandateDate());
        this.setSepaDirectDebitType(oldFinancePayment.getSepaDirectDebitType());
        this.setIsSepaOneOffDirectDebit(oldFinancePayment.getIsSepaOneOffDirectDebit());
        this.setSepaLastUsage(oldFinancePayment.getSepaLastUsage());
        this.setValidUntil(oldFinancePayment.getValidUntil());
        this.setWhitelistCheckState(oldFinancePayment.getWhitelistCheckState());
        this.setWhitelistCheckedOn(oldFinancePayment.getWhitelistCheckedOn());
        this.setWhitelistCheckRequestId(oldFinancePayment.getWhitelistCheckRequestId());
        this.setWhitelistCheckErrorCode(oldFinancePayment.getWhitelistCheckErrorCode());
    }

    protected FinancePayment(FinancePaymentSession session) {
        super((PaymentSession)session);
        this.mSepaDirectDebitType = SepaDirectDebitTypeEnum.SDDTE_COMPANY;
        this.mWhitelistCheckState = WhitelistCheckState.NOT_REQUIRED;
    }

    protected FinancePayment(String objectid, int version, FinancePaymentSession session) {
        super(objectid, version, (PaymentSession)session);
    }

    protected FinancePayment(boolean readOnly, FinancePaymentSession session) {
        super(readOnly, (PaymentSession)session);
    }

    protected FinancePayment(String objectid, FinancePaymentSession session) {
        super(objectid, (PaymentSession)session);
    }

    public String getDomainKey() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getPaymentSession().getDomainKey()).append('/');
        buffer.append(DateMapper.toString((Date)this.getDocumentDate())).append('/');
        buffer.append(LedgerTypeMapper.toString((LedgerTypeEnum)this.getLedgerType())).append('/');
        switch (this.getLedgerType().value()) {
            case 0: {
                buffer.append(this.getNominalAccount().getDomainKey());
                break;
            }
            case 1: {
                buffer.append(this.getPersonalAccount().getDomainKey());
                break;
            }
            default: {
                buffer.append("no account");
            }
        }
        return buffer.toString();
    }

    protected void check() throws BusinessDomainException {
        if (this.getLedgerType() == null || this.getLedgerType().value() == 2) {
            throw PaymentExceptionMapper.makeNoAccountSetDomainException();
        }
    }

    public void setData(FinancePaymentData data) {
        this.mBankAccount = data.getBankAccount();
        this.mLedgerType = data.getLedgerType();
        this.mNominalAccount = data.getNominalAccount();
        this.mPersonalAccount = data.getPersonalAccount();
        this.mCashTransaction = data.getCashTransaction();
        this.mPaymentTransactionType = data.getPaymentTransactionType();
        this.mPaymentTransactionCode = data.getPaymentTransactionCode();
        this.mBillOfExchange = data.getBillOfExchange();
        this.mDueDate = data.getDueDate();
        this.mZ5a = data.isZ5a();
        this.mProcessId = data.getProcessId();
        this.mSepaMandate = data.getSepaMandate();
        this.mSepaMandateDate = data.getSepaMandateDate();
        this.mSepaDirectDebitType = data.getSepaDirectDebitType();
        this.mIsSepaOneOffDirectDebit = data.isSepaOneOffDirectDebit();
        this.mSepaLastUsage = data.getSepaLastUsage();
        this.mValidUntil = data.getValidUntil();
        this.mWhitelistCheckState = data.getWhitelistCheckState();
        this.mWhitelistCheckedOn = data.getWhitelistCheckedOn();
        this.mWhitelistCheckRequestId = data.getWhitelistCheckRequestId();
        this.mWhitelistCheckErrorCode = data.getWhitelistCheckErrorCode();
    }

    public FinancePaymentSession getFinancePaymentSession() {
        return (FinancePaymentSession)this.getPaymentSession();
    }

    public Date getDueDate() {
        this.requireLoaded();
        return this.mDueDate;
    }

    public void setDueDate(Date dueDate) {
        this.protocol("duedate", this.mDueDate, dueDate);
        this.mDueDate = dueDate;
    }

    public boolean getZ5a() {
        this.requireLoaded();
        return this.mZ5a;
    }

    public void setZ5a(boolean z5a) {
        this.protocol("z5a", this.mZ5a, z5a);
        this.mZ5a = z5a;
    }

    public BillOfExchange getBillOfExchange() {
        this.requireLoaded();
        return this.mBillOfExchange;
    }

    public void setBillOfExchange(BillOfExchange bill) {
        this.mBillOfExchange = bill;
    }

    public LedgerTypeEnum getLedgerType() {
        this.requireLoaded();
        return this.mLedgerType;
    }

    protected void setLedgerType(LedgerTypeEnum ledgerType) {
        this.protocol("ledgertype", LedgerTypeMapper.toString((LedgerTypeEnum)this.mLedgerType), LedgerTypeMapper.toString((LedgerTypeEnum)ledgerType));
        this.mLedgerType = ledgerType;
    }

    public NLAccountCompanySetting getNominalAccount() {
        this.requireLoaded();
        return this.mNominalAccount;
    }

    public void setNominalAccount(NLAccountCompanySetting nominalAccount) throws BusinessDomainException {
        if (nominalAccount != null && nominalAccount.getNominalLedgerAccount().getControlAccount()) {
            throw TransactionExceptionMapper.makeNoControlAccountRequiredDomainException((String)nominalAccount.getNominalLedgerAccount().getCode());
        }
        this.protocol("nominalaccount", (IPersistentObject)this.mNominalAccount, (IPersistentObject)nominalAccount);
        this.mNominalAccount = nominalAccount;
        this.protocol("personalaccount", (IPersistentObject)this.mPersonalAccount, null);
        this.mPersonalAccount = null;
        if (this.mNominalAccount == null) {
            this.setLedgerType(LedgerTypeEnum.LTE_NOLEDGERTYPE);
        } else {
            this.setLedgerType(LedgerTypeEnum.LTE_NOMINALACCOUNT);
        }
    }

    public PersonalAccount getPersonalAccount() {
        this.requireLoaded();
        return this.mPersonalAccount;
    }

    public void setPersonalAccount(PersonalAccount personalAccount) {
        this.protocol("personalaccount", (IPersistentObject)this.mPersonalAccount, (IPersistentObject)personalAccount);
        this.mPersonalAccount = personalAccount;
        this.protocol("nominalaccount", (IPersistentObject)this.mNominalAccount, null);
        this.mNominalAccount = null;
        if (this.mPersonalAccount == null) {
            this.setLedgerType(LedgerTypeEnum.LTE_NOLEDGERTYPE);
        } else {
            this.setLedgerType(LedgerTypeEnum.LTE_PERSONALACCOUNT);
        }
    }

    public String getAccountCode() {
        if (this.getPersonalAccount() != null) {
            return this.getPersonalAccount().getCode();
        }
        if (this.getNominalAccount() != null) {
            return this.getNominalAccount().getNominalLedgerAccount().getCode();
        }
        return null;
    }

    public BankAccount getBankAccount() {
        this.requireLoaded();
        return this.mBankAccount;
    }

    public void setBankAccount(BankAccount bankAccount) throws BusinessDomainException {
        this.mBankAccount = bankAccount;
    }

    public void setBankSortingCode(String bankSortingCode, AuthorizationToken token) {
        if (!this.isNew() && token != null && !StringMapper.equal((String)bankSortingCode, (String)this.getBankSortingCode()) && this.mustCheckAccess()) {
            token.checkAccess(AccountingRightList.getChangeBankDataForPaymentPaymentSessionRight(), this.getFinancePaymentSession().getAccountingCompany().getObjectid());
        }
        this.setBankSortingCode(bankSortingCode);
    }

    public void setBankAccountNumber(String bankAccountNumber, AuthorizationToken token) {
        if (!this.isNew() && token != null && !StringMapper.equal((String)bankAccountNumber, (String)this.getBankAccountNumber()) && this.mustCheckAccess()) {
            token.checkAccess(AccountingRightList.getChangeBankDataForPaymentPaymentSessionRight(), this.getFinancePaymentSession().getAccountingCompany().getObjectid());
        }
        this.setBankAccountNumber(bankAccountNumber);
    }

    private boolean mustCheckAccess() {
        boolean mustCheck = false;
        if (this.getFinancePaymentSession().isGeneratePaymentSession()) {
            GeneratePaymentSession session = (GeneratePaymentSession)this.getFinancePaymentSession();
            if (!session.getIsDirectDebit() && !session.getIsCustomerRepayment()) {
                mustCheck = true;
            }
        } else {
            mustCheck = true;
        }
        return mustCheck;
    }

    public void setShortAddressOwner(String shortAddressOwner, AuthorizationToken token, boolean checkIban) throws BusinessDomainException {
        if (!this.isNew() && token != null && !StringMapper.equal((String)shortAddressOwner, (String)this.getShortAddressOwner()) && this.mustCheckAccess()) {
            token.checkAccess(AccountingRightList.getChangeBankDataForPaymentPaymentSessionRight(), this.getFinancePaymentSession().getAccountingCompany().getObjectid());
        }
        this.setShortAddressOwner(shortAddressOwner, checkIban);
    }

    public void setSwift(String swift, AuthorizationToken token) {
        if (!this.isNew() && token != null && !StringMapper.equal((String)swift, (String)this.getSwift()) && this.mustCheckAccess()) {
            token.checkAccess(AccountingRightList.getChangeBankDataForPaymentPaymentSessionRight(), this.getFinancePaymentSession().getAccountingCompany().getObjectid());
        }
        this.setSwift(swift);
    }

    public PaymentTransactionTypeEnum getPaymentTransactionType() {
        this.requireLoaded();
        return this.mPaymentTransactionType;
    }

    public void setPaymentTransactionType(PaymentTransactionTypeEnum ptt) {
        this.protocol("paymenttransactiontype", PaymentTransactionTypeMapper.toString((PaymentTransactionTypeEnum)this.mPaymentTransactionType), PaymentTransactionTypeMapper.toString((PaymentTransactionTypeEnum)ptt));
        this.mPaymentTransactionType = ptt;
    }

    public String getPaymentTransactionCode() {
        this.requireLoaded();
        return this.mPaymentTransactionCode;
    }

    public void setPaymentTransactionCode(String paymentTransactionCode) {
        this.protocol("paymenttransactioncode", this.mPaymentTransactionCode, paymentTransactionCode);
        this.mPaymentTransactionCode = paymentTransactionCode;
    }

    protected String getProcessId() {
        this.requireLoaded();
        return this.mProcessId;
    }

    public void setProcessId(String processId) {
        this.protocol("processid", this.mProcessId, processId);
        this.mProcessId = processId;
    }

    protected FinancialYear getFinancialYear() throws BusinessDomainException {
        FinancialYear financialYear = this.getFinancePaymentSession().getAccountingCompany().getFinancialYear(this.getTransactionDate());
        if (financialYear == null) {
            throw PaymentExceptionMapper.makeNoFinancialYearDomainException();
        }
        return financialYear;
    }

    public void post(Batch batch) throws BusinessDomainException {
        this.post(batch, this.getFinancialYear(), this.getTransactionDate());
    }

    protected abstract void post(Batch var1, FinancialYear var2, Date var3) throws BusinessDomainException;

    protected void createBankTransaction(Batch batch, FinancialYear financialYear, Date transactionDate) throws BusinessDomainException {
        this.mCashTransaction = new PaymentPostingCreator(this, batch, financialYear, transactionDate).create();
    }

    public boolean isReverseBill() {
        return this.getTypeOfPayment() != null && (this.getTypeOfPayment() == ModeOfPayment.CHECK_BILL_OF_EXCHANGE || this.getTypeOfPayment() == ModeOfPayment.BACS_BILL_OF_EXCHANGE);
    }

    public boolean isCheque() {
        return this.getTypeOfPayment() != null && (this.getTypeOfPayment() == ModeOfPayment.CHECK || this.getTypeOfPayment() == ModeOfPayment.CHECK_BILL_OF_EXCHANGE);
    }

    public boolean isBill() {
        return this.getTypeOfPayment() != null && (this.getTypeOfPayment() == ModeOfPayment.BILL_OF_EXCHANGE || this.getTypeOfPayment() == ModeOfPayment.BILL_WITHOUT_ACCEPTANCE);
    }

    protected Date getValueDate() {
        return this.getDocumentDate();
    }

    public CashTransaction getCashTransaction() {
        this.requireLoaded();
        return this.mCashTransaction;
    }

    public void setChequeNumber(int chequeNumber) throws BusinessDomainException {
        this.requireLoaded();
        if (!this.isCheque()) {
            throw ExceptionMapper.makeApplicationException((String)("wrong paymenttype:" + this.getTypeOfPayment()));
        }
        if (this.mCashTransaction != null && !this.mCashTransaction.getIsJournalized()) {
            this.mCashTransaction.makeSaveable();
            this.mCashTransaction.setChequeNumber(chequeNumber);
        }
    }

    protected Date getTransactionDate() throws BusinessDomainException {
        return this.getDocumentDate();
    }

    protected abstract CustSupAddress getOneOffAddress();

    public BigDecimal getAmountToIdl() {
        return super.getAmount();
    }

    public BigDecimal getBaseAmountToIdl() {
        return super.getBaseAmount();
    }

    public void setPaymentSessionBankAccount(PaymentSessionBankAccount sessionBankAccount) throws BusinessDomainException {
        this.mPaymentSessionBankAccount = sessionBankAccount;
        this.setBankAccount(null);
        if (sessionBankAccount != null) {
            this.setBankAccount(sessionBankAccount.getBankAccount());
        }
    }

    public PaymentSessionBankAccount getPaymentSessionBankAccount() {
        return this.mPaymentSessionBankAccount;
    }

    public void setPostalAddress(PostalAddress postalAddress, AuthorizationToken token) {
        if (!this.isNew() && token != null && this.getFinancePaymentSession().isGeneratePaymentSession() && this.getFinancePaymentSession().isPayment() && !PostalAddressMapper.equalWithTrim((IPostalAddress)this.getPostalAddress(), (IPostalAddress)postalAddress)) {
            token.checkAccess(AccountingRightList.getGET_CHIEF_ACCOUNTANT(), this.getFinancePaymentSession().getAccountingCompany().getObjectid());
        }
        this.setPostalAddress((IPostalAddress)postalAddress);
    }

    public boolean isSepaPayment() {
        return PaymentHelper.isSepaPayment(this.getFinancePaymentSession(), this.getBankAccount(), this.getCurrency(), this.getBankCountry(), this.getShortAddressOwner(), this.getSwift(), this.getSepaMandate(), this.getSepaMandateDate());
    }

    public boolean isDirectDebit() {
        return this.getFinancePaymentSession().getIsDirectDebit();
    }

    public boolean isDirectDebitAnticipated() {
        return false;
    }

    public String getSepaMandate() {
        this.requireLoaded();
        return this.mSepaMandate;
    }

    public void setSepaMandate(String sepaMandate) {
        this.mSepaMandate = sepaMandate;
    }

    public Date getSepaMandateDate() {
        this.requireLoaded();
        return this.mSepaMandateDate;
    }

    public void setSepaMandateDate(Date sepaMandateDate) {
        this.mSepaMandateDate = sepaMandateDate;
    }

    public Date getSepaLastUsage() {
        this.requireLoaded();
        return this.mSepaLastUsage;
    }

    public void setSepaLastUsage(Date sepaLastUsage) {
        this.mSepaLastUsage = sepaLastUsage;
    }

    public SepaDirectDebitTypeEnum getSepaDirectDebitType() {
        this.requireLoaded();
        return this.mSepaDirectDebitType;
    }

    public void setSepaDirectDebitType(SepaDirectDebitTypeEnum sepaDirectDebitType) {
        this.mSepaDirectDebitType = sepaDirectDebitType;
    }

    public boolean getIsSepaOneOffDirectDebit() {
        this.requireLoaded();
        return this.mIsSepaOneOffDirectDebit;
    }

    public void setIsSepaOneOffDirectDebit(boolean isSepaOneOffDirectDebit) {
        this.mIsSepaOneOffDirectDebit = isSepaOneOffDirectDebit;
    }

    public boolean isFinancePayment() {
        return true;
    }

    public boolean isExportPayment() {
        return PaymentTypeUtils.isExportPaymentType(this.getTypeOfPayment());
    }

    public Date getSepaDirectDebitExecuteDate() {
        return null;
    }

    public Date getValidUntil() {
        this.requireLoaded();
        return this.mValidUntil;
    }

    public void setValidUntil(Date validUntil) {
        this.mValidUntil = validUntil;
    }

    public Date getExecuteDate() {
        return null;
    }

    public EsrPayment getEsrPayment() {
        return null;
    }

    public WhitelistCheckState getWhitelistCheckState() {
        this.requireLoaded();
        return this.mWhitelistCheckState;
    }

    private void setWhitelistCheckState(WhitelistCheckState whitelistCheckState) {
        this.mWhitelistCheckState = whitelistCheckState;
        if (whitelistCheckState == WhitelistCheckState.NOT_REQUIRED || whitelistCheckState == WhitelistCheckState.NOT_CHECKED) {
            this.setWhitelistCheckedOn(null);
            this.setWhitelistCheckRequestId(null);
            this.setWhitelistCheckErrorCode(null);
        }
    }

    public Date getWhitelistCheckedOn() {
        this.requireLoaded();
        return this.mWhitelistCheckedOn;
    }

    private void setWhitelistCheckedOn(Date whitelistCheckedOn) {
        this.mWhitelistCheckedOn = whitelistCheckedOn;
    }

    public String getWhitelistCheckRequestId() {
        this.requireLoaded();
        return this.mWhitelistCheckRequestId;
    }

    private void setWhitelistCheckRequestId(String whitelistCheckRequestId) {
        this.mWhitelistCheckRequestId = whitelistCheckRequestId;
    }

    public String getWhitelistCheckErrorCode() {
        this.requireLoaded();
        return this.mWhitelistCheckErrorCode;
    }

    private void setWhitelistCheckErrorCode(String whitelistCheckErrorCode) {
        this.mWhitelistCheckErrorCode = whitelistCheckErrorCode;
    }

    public void setWhitelistCheckResult(WhitelistCheckState whitelistCheckState, String whitelistCheckRequestId, String whitelistCheckErrorCode) {
        this.setWhitelistCheckState(whitelistCheckState);
        this.setWhitelistCheckRequestId(whitelistCheckRequestId);
        this.setWhitelistCheckedOn(new Date());
        this.setWhitelistCheckErrorCode(whitelistCheckErrorCode);
        if (whitelistCheckState != null && whitelistCheckState == WhitelistCheckState.INVALID) {
            this.setStop(true);
        }
    }

    public boolean isWhitelistCheckEnabled() {
        WhitelistCheckState state = this.getWhitelistCheckState();
        return state != null && state != WhitelistCheckState.NOT_REQUIRED;
    }

    public void setWhitelistCheckRequired() {
        boolean whitelistCheckRequired = WhitelistCheckHelper.isWhitelistCheckRequired((FinancePayment)this);
        if (whitelistCheckRequired) {
            if (!this.isWhitelistCheckEnabled() || this.hasBankAccountNumberChanged()) {
                this.setWhitelistCheckState(WhitelistCheckState.NOT_CHECKED);
            }
        } else {
            this.setWhitelistCheckState(WhitelistCheckState.NOT_REQUIRED);
        }
    }

    public abstract String getTaxNumber();

    public SwissReferenceType getSwissReferenceType() {
        return SwissReferenceType.NO_REFERENCE;
    }

    public String getSwissReference() {
        return null;
    }

    public SplitPayment getSplitPayment() {
        return null;
    }

    protected boolean isDownPayment() {
        return false;
    }

    public abstract List<GeneratePaymentErrormessageEnum> checkForErrors();

    public ICurrency getBaseCurrency() {
        return this.getFinancePaymentSession().getFinanceSetup().getBaseCurrency();
    }

    public boolean hasError() {
        return this.checkForErrors().size() != 0;
    }
}

