/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.openitem.dates;

import com.varial.accounting.domain.nominaltransactionbase.INominalTransactionBase;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntryPersistencyManager;
import com.varial.accounting.domain.nominaltransactionbase.PersonalAccountEntry;
import com.varial.base.types.date.DateHelper;
import java.util.Date;

public class PaymentEffectiveDateEntriesUpdater {
    public void updateIfRequired(PersonalAccountEntry entry, Date newDate) {
        if (this.isUpdateRequired(entry, newDate)) {
            this.updateOnEntries(entry, newDate);
        }
    }

    private boolean isUpdateRequired(PersonalAccountEntry entry, Date newDate) {
        if (entry == null || !entry.requiresPaymentEffectiveDate()) {
            return false;
        }
        return !DateHelper.equal((Date)entry.getPaymentEffectiveDate(), (Date)newDate);
    }

    private void updateOnEntries(PersonalAccountEntry entry, Date newDate) {
        NominalLedgerEntryPersistencyManager.updatePaymentEffectiveDate((INominalTransactionBase)entry.getTransaction(), (Date)newDate, (boolean)entry.getIsDownPayment());
    }
}

